/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.cluster.Partition;
import kafka.log.LogLoader$;
import kafka.log.LogManager;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.server.epoch.EpochEntry;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.tools.DumpLogSegments$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tMc\u0001\u0002\u00180\u0001YBQ!\u0011\u0001\u0005\u0002\tCq!\u0012\u0001C\u0002\u0013\u0005a\t\u0003\u0004N\u0001\u0001\u0006Ia\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019A\u0006\u0001)A\u0005!\"9\u0011\f\u0001b\u0001\n\u0003Q\u0006B\u00023\u0001A\u0003%1\fC\u0004f\u0001\t\u0007I\u0011\u0001.\t\r\u0019\u0004\u0001\u0015!\u0003\\\u0011\u001d9\u0007\u00011A\u0005\u0002!DqA\u001d\u0001A\u0002\u0013\u00051\u000f\u0003\u0004z\u0001\u0001\u0006K!\u001b\u0005\bu\u0002\u0001\r\u0011\"\u0001|\u0011%\t\t\u0002\u0001a\u0001\n\u0003\t\u0019\u0002C\u0004\u0002\u0018\u0001\u0001\u000b\u0015\u0002?\t\u0013\u0005e\u0001\u00011A\u0005\u0002\u0005m\u0001\"CA\u0014\u0001\u0001\u0007I\u0011AA\u0015\u0011!\ti\u0003\u0001Q!\n\u0005u\u0001bBA\u0018\u0001\u0011\u0005\u0013\u0011\u0007\u0005\b\u0003#\u0002A\u0011IA*\u0011\u001d\ti\u0006\u0001C\u0001\u0003'Bq!a\u001a\u0001\t\u0003\t\u0019\u0006C\u0004\u0002l\u0001!\t!a\u0015\t\u000f\u0005=\u0004\u0001\"\u0001\u0002T!9\u00111\u000f\u0001\u0005\u0002\u0005M\u0003bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003\u0007\u0003A\u0011BAC\u0011%\tI\nAI\u0001\n\u0013\tY\nC\u0004\u00022\u0002!I!a\u0015\t\u000f\u0005M\u0006\u0001\"\u0003\u00026\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006BBAg\u0001\u0011%1\u0010C\u0004\u0002P\u0002!I!!5\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\"9\u0011Q\u001f\u0001\u0005\n\u0005]\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0005\u000f\u0001A\u0011\u0002B\u0005\u0011%\u0011\u0019\u0003AI\u0001\n\u0013\tY\nC\u0005\u0003&\u0001\t\n\u0011\"\u0003\u0002\u001c\"9!q\u0005\u0001\u0005\n\t%\u0002B\u0002B\u001c\u0001\u0011%1\u0010C\u0004\u0002~\u0001!IA!\u000f\t\u000f\u0005\u0005\u0005\u0001\"\u0003\u0003:!9!1\b\u0001\u0005\n\tu\u0002\"\u0003B'\u0001E\u0005I\u0011\u0002B(\u00051*\u0005o\\2i\tJLg/\u001a8SKBd\u0017nY1uS>t\u0007K]8u_\u000e|G.Q2dKB$\u0018M\\2f)\u0016\u001cHO\u0003\u00021c\u0005)Q\r]8dQ*\u0011!gM\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Q\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001om\u0002\"\u0001O\u001d\u000e\u0003EJ!AO\u0019\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002=\u007f5\tQH\u0003\u0002?g\u0005)Q\u000f^5mg&\u0011\u0001)\u0010\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\t\u0005\u0002E\u00015\tq&\u0001\u0006ba&4VM]:j_:,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015N\n1!\u00199j\u0013\ta\u0015J\u0001\u0006Ba&4VM]:j_:\f1\"\u00199j-\u0016\u00148/[8oA\u0005)Ao\u001c9jGV\t\u0001\u000b\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!A.\u00198h\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005\u0019Qn]4\u0016\u0003m\u00032\u0001X0b\u001b\u0005i&\"\u00010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001l&!B!se\u0006L\bC\u0001/c\u0013\t\u0019WL\u0001\u0003CsR,\u0017\u0001B7tO\u0002\n\u0011\"\\:h\u0005&<w-\u001a:\u0002\u00155\u001cxMQ5hO\u0016\u0014\b%A\u0004ce>\\WM]:\u0016\u0003%\u00042A[7p\u001b\u0005Y'B\u00017^\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003].\u00141aU3r!\tA\u0004/\u0003\u0002rc\tY1*\u00194lCN+'O^3s\u0003-\u0011'o\\6feN|F%Z9\u0015\u0005Q<\bC\u0001/v\u0013\t1XL\u0001\u0003V]&$\bb\u0002=\f\u0003\u0003\u0005\r![\u0001\u0004q\u0012\n\u0014\u0001\u00032s_.,'o\u001d\u0011\u0002\u0011A\u0014x\u000eZ;dKJ,\u0012\u0001 \t\u0006{\u000651lW\u0007\u0002}*\u0011!p \u0006\u0005\u0003\u0003\t\u0019!A\u0004dY&,g\u000e^:\u000b\u0007Q\n)A\u0003\u0003\u0002\b\u0005%\u0011AB1qC\u000eDWM\u0003\u0002\u0002\f\u0005\u0019qN]4\n\u0007\u0005=aPA\u0007LC\u001a\\\u0017\r\u0015:pIV\u001cWM]\u0001\raJ|G-^2fe~#S-\u001d\u000b\u0004i\u0006U\u0001b\u0002=\u000f\u0003\u0003\u0005\r\u0001`\u0001\naJ|G-^2fe\u0002\n\u0001bY8ogVlWM]\u000b\u0003\u0003;\u0001b!a\b\u0002$m[VBAA\u0011\u0015\r\tIb`\u0005\u0005\u0003K\t\tCA\u0007LC\u001a\\\u0017mQ8ogVlWM]\u0001\rG>t7/^7fe~#S-\u001d\u000b\u0004i\u0006-\u0002\u0002\u0003=\u0012\u0003\u0003\u0005\r!!\b\u0002\u0013\r|gn];nKJ\u0004\u0013!B:fiV\u0003Hc\u0001;\u00024!9\u0011QG\nA\u0002\u0005]\u0012\u0001\u0003;fgRLeNZ8\u0011\t\u0005e\u0012QI\u0007\u0003\u0003wQ1ASA\u001f\u0015\u0011\ty$!\u0011\u0002\u000f),\b/\u001b;fe*!\u00111IA\u0005\u0003\u0015QWO\\5u\u0013\u0011\t9%a\u000f\u0003\u0011Q+7\u000f^%oM>D3aEA&!\u0011\tI$!\u0014\n\t\u0005=\u00131\b\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0003;fCJ$un\u001e8\u0015\u0003QD3\u0001FA,!\u0011\tI$!\u0017\n\t\u0005m\u00131\b\u0002\n\u0003\u001a$XM]#bG\"\fAe\u001d5pk2$gi\u001c7m_^dU-\u00193fe\u0016\u0003xn\u00195CCNL7mV8sW\u001adwn\u001e\u0015\u0004+\u0005\u0005\u0004\u0003BA\u001d\u0003GJA!!\u001a\u0002<\t!A+Z:u\u0003m\u0019\bn\\;mI:{G/\u00117m_^$\u0015N^3sO\u0016tG\u000fT8hg\"\u001aa#!\u0019\u00027=4gm]3ugNCw.\u001e7e\u001d>$xi\u001c\"bG.<\u0018M\u001d3tQ\r9\u0012\u0011M\u0001\u001eg\"|W\u000f\u001c3TkJ4\u0018N^3GCN$H*Z1eKJ\u001c\u0005.\u00198hK\"\u001a\u0001$!\u0019\u0002Y1|wm]*i_VdGMT8u\t&4XM]4f\u001f:,fn\u00197fC:dU-\u00193fe\u0016cWm\u0019;j_:\u001c\bfA\r\u0002b\u0005\u0019An\\4\u0015\u000bQ\fY(a \t\r\u0005u$\u00041\u0001p\u0003\u0019aW-\u00193fe\"1\u0011\u0011\u0011\u000eA\u0002=\f\u0001BZ8mY><XM]\u0001\u0013o\u0006LGOR8s\u0019><7\u000fV8NCR\u001c\u0007\u000eF\u0004u\u0003\u000f\u000bY)a$\t\r\u0005%5\u00041\u0001p\u0003\t\u0011\u0017\u0007\u0003\u0004\u0002\u000en\u0001\ra\\\u0001\u0003EJB\u0011\"!%\u001c!\u0003\u0005\r!a%\u0002\u0013A\f'\u000f^5uS>t\u0007c\u0001/\u0002\u0016&\u0019\u0011qS/\u0003\u0007%sG/\u0001\u000fxC&$hi\u001c:M_\u001e\u001cHk\\'bi\u000eDG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005u%\u0006BAJ\u0003?[#!!)\u0011\t\u0005\r\u0016QV\u0007\u0003\u0003KSA!a*\u0002*\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Wk\u0016AC1o]>$\u0018\r^5p]&!\u0011qVAS\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJLg\u000e^*fO6,g\u000e^:\u0002\u001bM$\u0018M\u001d;D_:\u001cX/\\3s)\t\ti\"A\reK2,G/Z'fgN\fw-Z:Ge>lGj\\4GS2,Gc\u0002;\u0002<\u0006\u0015\u0017\u0011\u001a\u0005\b\u0003{{\u0002\u0019AA`\u0003\u0015\u0011\u0017\u0010^3t!\ra\u0016\u0011Y\u0005\u0004\u0003\u0007l&\u0001\u0002'p]\u001eDa!a2 \u0001\u0004y\u0017A\u00022s_.,'\u000fC\u0004\u0002L~\u0001\r!a%\u0002\u0017A\f'\u000f^5uS>t\u0017\nZ\u0001\u0018GJ,\u0017\r^3Ck\u001a4WM]5oOB\u0013x\u000eZ;dKJ\f!bZ3u\u0019><g)\u001b7f)\u0019\t\u0019.a8\u0002bB!\u0011Q[An\u001b\t\t9NC\u0002\u0002ZR\u000b!![8\n\t\u0005u\u0017q\u001b\u0002\u0005\r&dW\r\u0003\u0004\u0002H\u0006\u0002\ra\u001c\u0005\b\u0003#\u000b\u0003\u0019AAJ\u0003\u00199W\r\u001e'pOR1\u0011q]Ay\u0003g\u0004B!!;\u0002n6\u0011\u00111\u001e\u0006\u0004\u0003o\u001a\u0014\u0002BAx\u0003W\u0014!\"\u00168jM&,G\rT8h\u0011\u0019\t9M\ta\u0001_\"9\u0011\u0011\u0013\u0012A\u0002\u0005M\u0015A\u00022pk:\u001cW\rF\u0002u\u0003sDa!!!$\u0001\u0004y\u0017AC3q_\u000eD7)Y2iKR!\u0011q B\u0003!\r!%\u0011A\u0005\u0004\u0005\u0007y#\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW\r\u0003\u0004\u0002H\u0012\u0002\ra\\\u0001\rY\u0006$Xm\u001d;SK\u000e|'\u000f\u001a\u000b\t\u0005\u0017\u0011YB!\b\u0003\"A!!Q\u0002B\f\u001b\t\u0011yA\u0003\u0003\u0003\u0012\tM\u0011A\u0002:fG>\u0014HM\u0003\u0003\u0003\u0016\u0005\r\u0011AB2p[6|g.\u0003\u0003\u0003\u001a\t=!a\u0003*fG>\u0014HMQ1uG\"Da!! &\u0001\u0004y\u0007\"\u0003B\u0010KA\u0005\t\u0019AAJ\u0003\u0019ygMZ:fi\"I\u0011\u0011S\u0013\u0011\u0002\u0003\u0007\u00111S\u0001\u0017Y\u0006$Xm\u001d;SK\u000e|'\u000f\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u00051B.\u0019;fgR\u0014VmY8sI\u0012\"WMZ1vYR$3'\u0001\u0005bo\u0006LG/S*S)\r!(1\u0006\u0005\b\u0005[A\u0003\u0019\u0001B\u0018\u0003\t!\b\u000f\u0005\u0003\u00032\tMRB\u0001B\n\u0013\u0011\u0011)Da\u0005\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006q1M]3bi\u0016\u0004&o\u001c3vG\u0016\u0014X#A8\u0002\u0019\r\u0014X-\u0019;f\u0005J|7.\u001a:\u0015\u000b=\u0014yDa\u0011\t\u000f\t\u0005C\u00061\u0001\u0002\u0014\u0006\u0011\u0011\u000e\u001a\u0005\n\u0005\u000bb\u0003\u0013!a\u0001\u0005\u000f\n1$\u001a8bE2,WK\\2mK\u0006tG*Z1eKJ,E.Z2uS>t\u0007c\u0001/\u0003J%\u0019!1J/\u0003\u000f\t{w\u000e\\3b]\u000612M]3bi\u0016\u0014%o\\6fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0003R)\"!qIAP\u0001")
public class EpochDrivenReplicationProtocolAcceptanceTest
extends QuorumTestHarness {
    private final ApiVersion apiVersion = ApiVersion$.MODULE$.latestVersion();
    private final String topic;
    private final byte[] msg = new byte[1000];
    private final byte[] msgBigger = new byte[10000];
    private Seq<KafkaServer> brokers = null;
    private KafkaProducer<byte[], byte[]> producer = null;
    private KafkaConsumer<byte[], byte[]> consumer = null;

    public ApiVersion apiVersion() {
        return this.apiVersion;
    }

    public String topic() {
        return this.topic;
    }

    public byte[] msg() {
        return this.msg;
    }

    public byte[] msgBigger() {
        return this.msgBigger;
    }

    public Seq<KafkaServer> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<KafkaServer> x$1) {
        this.brokers = x$1;
    }

    public KafkaProducer<byte[], byte[]> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<byte[], byte[]> x$1) {
        this.producer = x$1;
    }

    public KafkaConsumer<byte[], byte[]> consumer() {
        return this.consumer;
    }

    public void consumer_$eq(KafkaConsumer<byte[], byte[]> x$1) {
        this.consumer = x$1;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.brokers());
        super.tearDown();
    }

    @Test
    public void shouldFollowLeaderEpochBasicWorkflow() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$1 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$1), this.createBroker$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals((int)0, (int)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((int)0, (int)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.bounce(this.follower());
        this.awaitISR(tp);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.follower()).epochEntries());
        Assertions.assertEquals((int)1, (int)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((int)1, (int)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        this.bounce(this.leader());
        this.awaitISR(tp);
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L)})), (Object)this.epochCache(this.follower()).epochEntries());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        Assertions.assertEquals((int)2, (int)this.latestRecord(this.leader(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((int)2, (int)this.latestRecord(this.follower(), this.latestRecord$default$2(), this.latestRecord$default$3()).partitionLeaderEpoch());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.leader()).epochEntries());
        Assertions.assertEquals((Object)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new EpochEntry[]{new EpochEntry(0, 0L), new EpochEntry(1, 1L), new EpochEntry(2, 2L)})), (Object)this.epochCache(this.follower()).epochEntries());
    }

    @Test
    public void shouldNotAllowDivergentLogs() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)id -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(BoxesRunTime.unboxToInt((Object)id), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20())), TestUtils$.MODULE$.createServer$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        KafkaServer broker100 = (KafkaServer)this.brokers().apply(0);
        KafkaServer broker101 = (KafkaServer)this.brokers().apply(1);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1 & Serializable & scala.Serializable)i -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldNotAllowDivergentLogs$2(this, BoxesRunTime.unboxToInt((Object)i)));
        broker101.shutdown();
        broker100.shutdown();
        new File((String)broker100.config().logDirs().head(), LogLoader$.MODULE$.CleanShutdownFile()).delete();
        this.deleteMessagesFromLogFile(5 * this.msg().length, broker100, 0);
        broker100.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(11), 20).map((Function1 & Serializable & scala.Serializable)i -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldNotAllowDivergentLogs$3(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> (RecordMetadata)x$2.get());
        broker101.startup();
        this.waitForLogsToMatch(broker100, broker101, this.waitForLogsToMatch$default$3());
        Assertions.assertEquals((long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length(), (String)"Log files should match Broker0 vs Broker 1");
    }

    @Test
    public void offsetsShouldNotGoBackwards() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$3 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$3), this.createBroker$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createBufferingProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        this.brokers().foreach((Function1 & Serializable & scala.Serializable)b -> {
            b.shutdown();
            return BoxedUnit.UNIT;
        });
        new File((String)((KafkaServer)this.brokers().apply(0)).config().logDirs().apply(0), LogLoader$.MODULE$.CleanShutdownFile()).delete();
        this.deleteMessagesFromLogFile(this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length() / 2L, (KafkaServer)this.brokers().apply(0), 0);
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(this.createBufferingProducer());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1 & Serializable & scala.Serializable)x$4 -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$4(this, BoxesRunTime.unboxToInt((Object)x$4)));
        this.producer().flush();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 77).foreach((Function1 & Serializable & scala.Serializable)x$5 -> EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$5(this, BoxesRunTime.unboxToInt((Object)x$5)));
        this.producer().flush();
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        this.printSegments();
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        this.startConsumer();
        Seq<ConsumerRecord<byte[], byte[]>> records = TestUtils$.MODULE$.pollUntilAtLeastNumRecords(this.consumer(), 100, TestUtils$.MODULE$.pollUntilAtLeastNumRecords$default$3());
        LongRef prevOffset = LongRef.create((long)-1L);
        records.foreach((Function1 & Serializable & scala.Serializable)r -> {
            EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$offsetsShouldNotGoBackwards$6(prevOffset, r);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((long)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).length(), (long)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length(), (String)"Log files should match Broker0 vs Broker 1");
    }

    @Test
    public void shouldSurviveFastLeaderChange() {
        TopicPartition tp = new TopicPartition(this.topic(), 0);
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$6 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$6), this.createBroker$default$2()), IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers());
        this.producer_$eq(this.createProducer());
        this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
        IntRef messagesWritten = IntRef.create((int)1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 5).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
            KafkaServer leader = (KafkaServer)((SeqLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$3(leaderId, x$7)))).apply(0);
            KafkaServer follower = (KafkaServer)((SeqLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$4(leaderId, x$8)))).apply(0);
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg())).get();
            ++messagesWritten$1.elem;
            this.bounce(follower);
            this.log(leader, follower);
            this.awaitISR(tp);
            this.bounce(leader);
            this.log(leader, follower);
            this.awaitISR(tp);
            Assertions.assertTrue((boolean)this.brokers().forall((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$shouldSurviveFastLeaderChange$5(this, messagesWritten, broker))));
        });
    }

    @Test
    public void logsShouldNotDivergeOnUncleanLeaderElections() {
        this.brokers_$eq((Seq<KafkaServer>)((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(100), 101).map((Function1 & Serializable & scala.Serializable)x$9 -> this.createBroker(BoxesRunTime.unboxToInt((Object)x$9), true), IndexedSeq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.brokers(), CoreUtils$.MODULE$.propsWith((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)KafkaConfig$.MODULE$.MinInSyncReplicasProp(), (Object)"1")})));
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 3).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msgBigger()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(0)).shutdown();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msg()));
            this.producer().flush();
        });
        ((KafkaServer)this.brokers().apply(1)).shutdown();
        ((KafkaServer)this.brokers().apply(0)).startup();
        this.producer().close();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), 1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            this.producer().send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)this.msgBigger()));
            this.producer().flush();
        });
        this.printSegments();
        ((KafkaServer)this.brokers().apply(1)).startup();
        this.waitForLogsToMatch((KafkaServer)this.brokers().apply(0), (KafkaServer)this.brokers().apply(1), this.waitForLogsToMatch$default$3());
        this.printSegments();
        Seq seq = this.crcSeq$1((KafkaServer)this.brokers().apply(0), EpochDrivenReplicationProtocolAcceptanceTest.crcSeq$default$2$1());
        Seq seq2 = this.crcSeq$1((KafkaServer)this.brokers().apply(1), EpochDrivenReplicationProtocolAcceptanceTest.crcSeq$default$2$1());
        Assertions.assertTrue((!(seq != null ? !seq.equals(seq2) : seq2 != null) ? 1 : 0) != 0, (String)"Logs on Broker 100 and Broker 101 should match");
    }

    private void log(KafkaServer leader, KafkaServer follower) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Bounce complete for follower ").append(follower.config().brokerId()).toString());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Leader: leo").append(leader.config().brokerId()).append(": ").append(this.getLog(leader, 0).logEndOffset()).append(" cache: ").append(this.epochCache(leader).epochEntries()).toString());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Follower: leo").append(follower.config().brokerId()).append(": ").append(this.getLog(follower, 0).logEndOffset()).append(" cache: ").append(this.epochCache(follower).epochEntries()).toString());
    }

    /*
     * WARNING - void declaration
     */
    private void waitForLogsToMatch(KafkaServer b1, KafkaServer b2, int partition) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$waitForLogsToMatch$1(this, b1, partition, b2)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$waitForLogsToMatch$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private int waitForLogsToMatch$default$3() {
        return 0;
    }

    private void printSegments() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker0:");
        DumpLogSegments$.MODULE$.main((String[])new .colon.colon((Object)"--files", (List)new .colon.colon((Object)this.getLogFile((KafkaServer)this.brokers().apply(0), 0).getCanonicalPath(), (List)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)));
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Broker1:");
        DumpLogSegments$.MODULE$.main((String[])new .colon.colon((Object)"--files", (List)new .colon.colon((Object)this.getLogFile((KafkaServer)this.brokers().apply(1), 0).getCanonicalPath(), (List)Nil$.MODULE$)).toArray(ClassTag$.MODULE$.apply(String.class)));
    }

    private KafkaConsumer<byte[], byte[]> startConsumer() {
        Properties consumerConfig = new Properties();
        consumerConfig.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        consumerConfig.put("fetch.max.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        consumerConfig.put("max.partition.fetch.bytes", String.valueOf(this.getLogFile((KafkaServer)this.brokers().apply(1), 0).length() * 2L));
        this.consumer_$eq((KafkaConsumer<byte[], byte[]>)new KafkaConsumer(consumerConfig, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer()));
        this.consumer().assign((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new TopicPartition(this.topic(), 0), (List)Nil$.MODULE$)).asJava());
        this.consumer().seek(new TopicPartition(this.topic(), 0), 0L);
        return this.consumer();
    }

    private void deleteMessagesFromLogFile(long bytes, KafkaServer broker, int partitionId) {
        File logFile = this.getLogFile(broker, partitionId);
        RandomAccessFile writable = new RandomAccessFile(logFile, "rwd");
        writable.setLength(logFile.length() - bytes);
        writable.close();
    }

    private KafkaProducer<byte[], byte[]> createBufferingProducer() {
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        int x$2 = -1;
        int x$3 = 10000;
        int x$4 = this.msg().length * 1000;
        String x$5 = "snappy";
        long x$6 = TestUtils$.MODULE$.createProducer$default$3();
        long x$7 = TestUtils$.MODULE$.createProducer$default$4();
        int x$8 = TestUtils$.MODULE$.createProducer$default$5();
        int x$9 = TestUtils$.MODULE$.createProducer$default$6();
        int x$10 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$11 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$12 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$13 = TestUtils$.MODULE$.createProducer$default$13();
        ByteArraySerializer x$14 = TestUtils$.MODULE$.createProducer$default$14();
        ByteArraySerializer x$15 = TestUtils$.MODULE$.createProducer$default$15();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        return TestUtils$.MODULE$.createProducer(x$1, x$2, x$6, x$7, x$8, x$9, x$3, x$4, x$5, x$10, x$11, x$12, x$13, x$14, x$15, x$16);
    }

    private File getLogFile(KafkaServer broker, int partition) {
        UnifiedLog log = this.getLog(broker, partition);
        log.flush();
        return ((File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])log.dir().listFiles())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$getLogFile$1(x$11))))[0];
    }

    private UnifiedLog getLog(KafkaServer broker, int partition) {
        LogManager qual$1 = broker.logManager();
        TopicPartition x$1 = new TopicPartition(this.topic(), partition);
        boolean x$2 = qual$1.getLog$default$2();
        return (UnifiedLog)qual$1.getLog(x$1, x$2).orNull(Predef$.MODULE$.$conforms());
    }

    private void bounce(KafkaServer follower) {
        follower.shutdown();
        follower.startup();
        this.producer().close();
        this.producer_$eq(this.createProducer());
    }

    private LeaderEpochFileCache epochCache(KafkaServer broker) {
        return (LeaderEpochFileCache)this.getLog(broker, 0).leaderEpochCache().get();
    }

    private RecordBatch latestRecord(KafkaServer leader, int offset, int partition) {
        LogSegment qual$1 = this.getLog(leader, partition).activeSegment();
        long x$1 = 0L;
        int x$2 = Integer.MAX_VALUE;
        long x$3 = qual$1.read$default$3();
        boolean x$4 = qual$1.read$default$4();
        return (RecordBatch)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(qual$1.read(x$1, x$2, x$3, x$4).records().batches()).asScala()).toSeq().last();
    }

    private int latestRecord$default$2() {
        return -1;
    }

    private int latestRecord$default$3() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void awaitISR(TopicPartition tp) {
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$awaitISR$1(this, tp)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$awaitISR$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private KafkaProducer<byte[], byte[]> createProducer() {
        return TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromServers(this.brokers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()), -1, TestUtils$.MODULE$.createProducer$default$3(), TestUtils$.MODULE$.createProducer$default$4(), TestUtils$.MODULE$.createProducer$default$5(), TestUtils$.MODULE$.createProducer$default$6(), TestUtils$.MODULE$.createProducer$default$7(), TestUtils$.MODULE$.createProducer$default$8(), TestUtils$.MODULE$.createProducer$default$9(), TestUtils$.MODULE$.createProducer$default$10(), TestUtils$.MODULE$.createProducer$default$11(), TestUtils$.MODULE$.createProducer$default$12(), TestUtils$.MODULE$.createProducer$default$13(), TestUtils$.MODULE$.createProducer$default$14(), TestUtils$.MODULE$.createProducer$default$15(), TestUtils$.MODULE$.createProducer$default$16());
    }

    private KafkaServer leader() {
        Assertions.assertEquals((int)2, (int)this.brokers().size());
        int leaderId = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((IterableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$leader$1(leaderId, x$12)))).head();
    }

    private KafkaServer follower() {
        Assertions.assertEquals((int)2, (int)this.brokers().size());
        int leader = BoxesRunTime.unboxToInt((Object)this.zkClient().getLeaderForPartition(new TopicPartition(this.topic(), 0)).get());
        return (KafkaServer)((IterableLike)this.brokers().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)EpochDrivenReplicationProtocolAcceptanceTest.$anonfun$follower$1(leader, x$13)))).head();
    }

    private KafkaServer createBroker(int id, boolean enableUncleanLeaderElection) {
        Properties config = TestUtils$.MODULE$.createBrokerConfig(id, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        TestUtils$.MODULE$.setIbpAndMessageFormatVersions(config, this.apiVersion());
        config.setProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), Boolean.toString(enableUncleanLeaderElection));
        return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
    }

    private boolean createBroker$default$2() {
        return false;
    }

    public static final /* synthetic */ RecordMetadata $anonfun$shouldNotAllowDivergentLogs$2(EpochDrivenReplicationProtocolAcceptanceTest $this, int i) {
        return (RecordMetadata)$this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)$this.msg())).get();
    }

    public static final /* synthetic */ Future $anonfun$shouldNotAllowDivergentLogs$3(EpochDrivenReplicationProtocolAcceptanceTest $this, int i) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), (Object)String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes(), (Object)$this.msg()));
    }

    public static final /* synthetic */ Future $anonfun$offsetsShouldNotGoBackwards$4(EpochDrivenReplicationProtocolAcceptanceTest $this, int x$4) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg()));
    }

    public static final /* synthetic */ Future $anonfun$offsetsShouldNotGoBackwards$5(EpochDrivenReplicationProtocolAcceptanceTest $this, int x$5) {
        return $this.producer().send(new ProducerRecord($this.topic(), Predef$.MODULE$.int2Integer(0), null, (Object)$this.msg()));
    }

    public static final /* synthetic */ void $anonfun$offsetsShouldNotGoBackwards$6(LongRef prevOffset$1, ConsumerRecord r) {
        Assertions.assertTrue((r.offset() > prevOffset$1.elem ? 1 : 0) != 0, (String)new StringBuilder(21).append("Offset ").append(prevOffset$1.elem).append(" came before ").append(r.offset()).append(" ").toString());
        prevOffset$1.elem = r.offset();
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$3(int leaderId$1, KafkaServer x$7) {
        return x$7.config().brokerId() == leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$4(int leaderId$1, KafkaServer x$8) {
        return x$8.config().brokerId() != leaderId$1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldSurviveFastLeaderChange$5(EpochDrivenReplicationProtocolAcceptanceTest $this, IntRef messagesWritten$1, KafkaServer broker) {
        return $this.getLog(broker, 0).logEndOffset() == (long)messagesWritten$1.elem;
    }

    private final Seq crcSeq$1(KafkaServer broker, int partition) {
        LogSegment qual$1 = this.getLog(broker, partition).activeSegment();
        long x$1 = 0L;
        int x$2 = Integer.MAX_VALUE;
        long x$3 = qual$1.read$default$3();
        boolean x$4 = qual$1.read$default$4();
        return (Seq)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(qual$1.read(x$1, x$2, x$3, x$4).records().batches()).asScala()).toSeq().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.checksum()), Seq$.MODULE$.canBuildFrom());
    }

    private static final int crcSeq$default$2$1() {
        return 0;
    }

    public static final /* synthetic */ boolean $anonfun$waitForLogsToMatch$1(EpochDrivenReplicationProtocolAcceptanceTest $this, KafkaServer b1$1, int partition$1, KafkaServer b2$1) {
        return $this.getLog(b1$1, partition$1).logEndOffset() == $this.getLog(b2$1, partition$1).logEndOffset();
    }

    public static final /* synthetic */ String $anonfun$waitForLogsToMatch$2() {
        return "Logs didn't match.";
    }

    public static final /* synthetic */ boolean $anonfun$getLogFile$1(File x$11) {
        return x$11.getName().endsWith(".log");
    }

    public static final /* synthetic */ boolean $anonfun$awaitISR$1(EpochDrivenReplicationProtocolAcceptanceTest $this, TopicPartition tp$2) {
        return ((Partition)$this.leader().replicaManager().onlinePartition(tp$2).get()).inSyncReplicaIds().size() == 2;
    }

    public static final /* synthetic */ String $anonfun$awaitISR$2() {
        return "Timed out waiting for replicas to join ISR";
    }

    public static final /* synthetic */ boolean $anonfun$leader$1(int leaderId$2, KafkaServer x$12) {
        return x$12.config().brokerId() == leaderId$2;
    }

    public static final /* synthetic */ boolean $anonfun$follower$1(int leader$2, KafkaServer x$13) {
        return x$13.config().brokerId() != leader$2;
    }

    public EpochDrivenReplicationProtocolAcceptanceTest() {
        this.topic = "topic1";
    }
}

