/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import kafka.tools.GetOffsetShell$;
import org.apache.kafka.common.PartitionInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019BQa\u0012\u0001\u0005\u0002!CQ!\u0014\u0001\u0005\u00029CQa\u0015\u0001\u0005\u0002QCQ!\u0017\u0001\u0005\u0002iCQa\u0018\u0001\u0005\u0002\u0001DQ!\u001a\u0001\u0005\u0002\u0019DQa\u001b\u0001\u0005\u00021DQ!\u001d\u0001\u0005\u0002IDQa\u001e\u0001\u0005\u0002aDa!!\u0001\u0001\t\u0003A\bBBA\u0003\u0001\u0011\u0005\u0001\u0010\u0003\u0004\u0002\n\u0001!\t\u0001\u001f\u0005\u0007\u0003\u001b\u0001A\u0011\u0001=\t\r\u0005E\u0001\u0001\"\u0001y\u0011\u0019\t)\u0002\u0001C\u0001q\"1\u0011\u0011\u0004\u0001\u0005\u0002aDq!!\b\u0001\t\u0013\tyBA\rHKR|eMZ:fiNCW\r\u001c7QCJ\u001c\u0018N\\4UKN$(B\u0001\f\u0018\u0003\u0015!xn\u001c7t\u0015\u0005A\u0012!B6bM.\f7\u0001A\n\u0003\u0001m\u0001\"\u0001H\u0010\u000e\u0003uQ\u0011AH\u0001\u0006g\u000e\fG.Y\u0005\u0003Au\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u0016\u0003\u0011\"Xm\u001d;U_BL7\rU1si&$\u0018n\u001c8GS2$XM\u001d$peR{\u0007/[2OC6,GCA\u0014+!\ta\u0002&\u0003\u0002*;\t!QK\\5u\u0011\u0015Y#\u00011\u0001-\u0003=)\u0007p\u00197vI\u0016Le\u000e^3s]\u0006d\u0007C\u0001\u000f.\u0013\tqSDA\u0004C_>dW-\u00198)\t\t\u0001dh\u0010\t\u0003cqj\u0011A\r\u0006\u0003gQ\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0003kY\na\u0001]1sC6\u001c(BA\u001c9\u0003\u001dQW\u000f]5uKJT!!\u000f\u001e\u0002\u000b),h.\u001b;\u000b\u0003m\n1a\u001c:h\u0013\ti$GA\u0006WC2,XmU8ve\u000e,\u0017\u0001\u00032p_2,\u0017M\\:-\u0005\u0001\u000b\u0015$A\u0001\u001a\u0003\u0001A#AA\"\u0011\u0005\u0011+U\"\u0001\u001b\n\u0005\u0019#$!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006aC/Z:u)>\u0004\u0018n\u0019)beRLG/[8o\r&dG/\u001a:G_JLe\u000e^3s]\u0006dGk\u001c9jG:\u000bW.\u001a\u000b\u0003O%CQaK\u0002A\u00021BCa\u0001\u0019?\u00172\u0012\u0001)\u0011\u0015\u0003\u0007\r\u000b\u0001\u0006^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]\u001aKG\u000e^3s\r>\u0014Hk\u001c9jG:\u000bW.\u001a'jgR$\"aJ(\t\u000b-\"\u0001\u0019\u0001\u0017)\t\u0011\u0001d(\u0015\u0017\u0003\u0001\u0006C#\u0001B\"\u0002AQ,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c$jYR,'OR8s%\u0016<W\r\u001f\u000b\u0003OUCQaK\u0003A\u00021BC!\u0002\u0019?/2\u0012\u0001)\u0011\u0015\u0003\u000b\r\u000bQ\u0006^3tiR{\u0007/[2QCJ$\u0018\u000e^5p]\u001aKG\u000e^3s\r>\u0014\b+\u0019:uSRLwN\\%oI\u0016D8\u000b]3d)\t93\fC\u0003,\r\u0001\u0007A\u0006\u000b\u0003\u0007ayjFF\u0001!BQ\t11)A\u0017uKN$Hk\u001c9jGB\u000b'\u000f^5uS>tg)\u001b7uKJ4uN\u001d)beRLG/[8o%\u0006tw-Z*qK\u000e$\"aJ1\t\u000b-:\u0001\u0019\u0001\u0017)\t\u001d\u0001dh\u0019\u0017\u0003\u0001\u0006C#aB\"\u0002eQ,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c$jYR,'OR8s!\u0006\u0014H/\u001b;j_:dun^3s\u0005>,h\u000eZ*qK\u000e$\"aJ4\t\u000b-B\u0001\u0019\u0001\u0017)\t!\u0001d(\u001b\u0017\u0003\u0001\u0006C#\u0001C\"\u0002eQ,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c$jYR,'OR8s!\u0006\u0014H/\u001b;j_:,\u0006\u000f]3s\u0005>,h\u000eZ*qK\u000e$\"aJ7\t\u000b-J\u0001\u0019\u0001\u0017)\t%\u0001dh\u001c\u0017\u0003\u0001\u0006C#!C\"\u0002?Q,7\u000f\u001e+pa&\u001c\u0007+\u0019:uSRLwN\u001c$jYR,'oQ8na2,\u0007\u0010\u0006\u0002(g\")1F\u0003a\u0001Y!\"!\u0002\r vY\t\u0001\u0015\t\u000b\u0002\u000b\u0007\u0006\tC/Z:u!\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;fe\u001a{'oU5oO2,\u0017J\u001c3fqR\tq\u0005\u000b\u0002\fuB\u00111P`\u0007\u0002y*\u0011QPN\u0001\u0004CBL\u0017BA@}\u0005\u0011!Vm\u001d;\u00027Q,7\u000f\u001e)beRLG/[8o\r&dG/\u001a:G_J\u0014\u0016M\\4fQ\ta!0\u0001\u0011uKN$\b+\u0019:uSRLwN\u001c$jYR,'OR8s\u0019><XM\u001d\"pk:$\u0007FA\u0007{\u0003\u0001\"Xm\u001d;QCJ$\u0018\u000e^5p]\u001aKG\u000e^3s\r>\u0014X\u000b\u001d9fe\n{WO\u001c3)\u00059Q\u0018\u0001\u000b;fgR\u0004\u0016M\u001d;ji&|gNR5mi\u0016\u0014hi\u001c:J]Z\fG.\u001b3TS:<G.Z%oI\u0016D\bFA\b{\u0003\t\"Xm\u001d;QCJ$\u0018\u000e^5p]\u001aKG\u000e^3s\r>\u0014\u0018J\u001c<bY&$'+\u00198hK\"\u0012\u0001C_\u0001(i\u0016\u001cH\u000fU1si&$\u0018n\u001c8GS2$XM\u001d$pe&sg/\u00197jI2{w/\u001a:C_VtG\r\u000b\u0002\u0012u\u00069C/Z:u!\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;fe\u001a{'/\u00138wC2LG-\u00169qKJ\u0014u.\u001e8eQ\t\u0011\"0A\u0007qCJ$\u0018\u000e^5p]&sgm\u001c\u000b\u0007\u0003C\t\u0019$!\u0014\u0011\t\u0005\r\u0012qF\u0007\u0003\u0003KQA!a\n\u0002*\u000511m\\7n_:T1\u0001GA\u0016\u0015\r\tiCO\u0001\u0007CB\f7\r[3\n\t\u0005E\u0012Q\u0005\u0002\u000e!\u0006\u0014H/\u001b;j_:LeNZ8\t\u000f\u0005U2\u00031\u0001\u00028\u0005)Ao\u001c9jGB!\u0011\u0011HA$\u001d\u0011\tY$a\u0011\u0011\u0007\u0005uR$\u0004\u0002\u0002@)\u0019\u0011\u0011I\r\u0002\rq\u0012xn\u001c;?\u0013\r\t)%H\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00131\n\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015S\u0004C\u0004\u0002PM\u0001\r!!\u0015\u0002\u0013A\f'\u000f^5uS>t\u0007c\u0001\u000f\u0002T%\u0019\u0011QK\u000f\u0003\u0007%sG\u000f")
public class GetOffsetShellParsingTest {
    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterForTopicName(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList("test", excludeInternal);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 1))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 0))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 0))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterForInternalTopicName(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList("__consumer_offsets", excludeInternal);
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 0)));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 1)));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 0))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test2", 0))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterForTopicNameList(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList("test,test1,__consumer_offsets", excludeInternal);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 1))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test2", 0))));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 0)));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterForRegex(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList("test.*", excludeInternal);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 1))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test2", 0))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 0))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterForPartitionIndexSpec(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":0", excludeInternal);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 0))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test2", 1))));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 0)));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 1))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterForPartitionRangeSpec(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":1-3", excludeInternal);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 1))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 2))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test2", 0))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test2", 3))));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 2)));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 3))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterForPartitionLowerBoundSpec(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":1-", excludeInternal);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 1))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 2))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test2", 0))));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 2)));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 0))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterForPartitionUpperBoundSpec(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":-3", excludeInternal);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 1))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test2", 2))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test3", 3))));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 2)));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 3))));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testTopicPartitionFilterComplex(boolean excludeInternal) {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList("test.*:0,__consumer_offsets:1-2,.*:3", excludeInternal);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 3))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 1))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 3))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test1", 1))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("custom", 3))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("custom", 0))));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 1)));
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((!excludeInternal ? 1 : 0) != 0), (Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 3)));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 0))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("__consumer_offsets", 2))));
    }

    @Test
    public void testPartitionFilterForSingleIndex() {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":1", false);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 1))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 2))));
    }

    @Test
    public void testPartitionFilterForRange() {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":1-3", false);
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 1))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 2))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 3))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 4))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 5))));
    }

    @Test
    public void testPartitionFilterForLowerBound() {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":3-", false);
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 1))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 2))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 3))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 4))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 5))));
    }

    @Test
    public void testPartitionFilterForUpperBound() {
        Function1 filter = GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":-3", false);
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 0))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 1))));
        Assertions.assertTrue((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 2))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 3))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 4))));
        Assertions.assertFalse((boolean)BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)this.partitionInfo("test", 5))));
    }

    @Test
    public void testPartitionFilterForInvalidSingleIndex() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":a", false));
    }

    @Test
    public void testPartitionFilterForInvalidRange() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":a-b", false));
    }

    @Test
    public void testPartitionFilterForInvalidLowerBound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":a-", false));
    }

    @Test
    public void testPartitionFilterForInvalidUpperBound() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> GetOffsetShell$.MODULE$.createTopicPartitionFilterWithPatternList(":-b", false));
    }

    private PartitionInfo partitionInfo(String topic, int partition) {
        return new PartitionInfo(topic, partition, null, null, null);
    }
}

