/*
 * Decompiled with CFR 0.152.
 */
package unit.kafka.server.metadata;

import java.io.Serializable;
import kafka.log.UnifiedLog;
import kafka.server.metadata.BrokerMetadataPublisher$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.image.MetadataImageTest;
import org.apache.kafka.image.TopicImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4Aa\u0002\u0005\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;!)a\u0006\u0001C\u0001;!)\u0001\u0007\u0001C\u0005c!)\u0011\n\u0001C\u0005\u0015\")\u0001\u000f\u0001C\u0005c\nY\"I]8lKJlU\r^1eCR\f\u0007+\u001e2mSNDWM\u001d+fgRT!!\u0003\u0006\u0002\u00115,G/\u00193bi\u0006T!a\u0003\u0007\u0002\rM,'O^3s\u0015\tia\"A\u0003lC\u001a\\\u0017MC\u0001\u0010\u0003\u0011)h.\u001b;\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u0005A\u0011!\u0005;fgR<U\r\u001e+pa&\u001cG)\u001a7uCR\ta\u0004\u0005\u0002\u0014?%\u0011\u0001\u0005\u0006\u0002\u0005+:LG\u000f\u000b\u0002\u0003EA\u00111\u0005L\u0007\u0002I)\u0011QEJ\u0001\u0004CBL'BA\u0014)\u0003\u001dQW\u000f]5uKJT!!\u000b\u0016\u0002\u000b),h.\u001b;\u000b\u0003-\n1a\u001c:h\u0013\tiCE\u0001\u0003UKN$\u0018!\u0006;fgR4\u0015N\u001c3TiJ\f\u0017PU3qY&\u001c\u0017m\u001d\u0015\u0003\u0007\t\nq!\\8dW2{w\rF\u00023s\u0011\u0003\"aM\u001c\u000e\u0003QR!!\u000e\u001c\u0002\u00071|wMC\u0001\u000e\u0013\tADG\u0001\u0006V]&4\u0017.\u001a3M_\u001eDQA\u000f\u0003A\u0002m\nq\u0001^8qS\u000eLE\r\u0005\u0002=\u00056\tQH\u0003\u0002?\u007f\u000511m\\7n_:T!!\u0004!\u000b\u0005\u0005S\u0013AB1qC\u000eDW-\u0003\u0002D{\t!Q+^5e\u0011\u0015)E\u00011\u0001G\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"\u0001P$\n\u0005!k$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000bi>\u0004\u0018nY%nC\u001e,G\u0003B&R%~\u0003\"\u0001T(\u000e\u00035S!AT \u0002\u000b%l\u0017mZ3\n\u0005Ak%A\u0003+pa&\u001c\u0017*\\1hK\")!(\u0002a\u0001w!)1+\u0002a\u0001)\u0006)Ao\u001c9jGB\u0011Q\u000b\u0018\b\u0003-j\u0003\"a\u0016\u000b\u000e\u0003aS!!\u0017\t\u0002\rq\u0012xn\u001c;?\u0013\tYF#\u0001\u0004Qe\u0016$WMZ\u0005\u0003;z\u0013aa\u0015;sS:<'BA.\u0015\u0011\u0015\u0001W\u00011\u0001b\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0005+\n$w-\u0003\u0002d=\n\u0019Q*\u00199\u0011\u0005M)\u0017B\u00014\u0015\u0005\rIe\u000e\u001e\t\u0004Q6$gBA5l\u001d\t9&.C\u0001\u0016\u0013\taG#A\u0004qC\u000e\\\u0017mZ3\n\u00059|'aA*fc*\u0011A\u000eF\u0001\fi>\u0004\u0018nY:J[\u0006<W\r\u0006\u0002skB\u0011Aj]\u0005\u0003i6\u00131\u0002V8qS\u000e\u001c\u0018*\\1hK\")aO\u0002a\u0001o\u00061Ao\u001c9jGN\u00042\u0001[7L\u0001")
public class BrokerMetadataPublisherTest {
    @Test
    public void testGetTopicDelta() {
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("not-a-topic", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for unknown topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("foo", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Expected no delta for deleted topic");
        Predef$.MODULE$.assert(BrokerMetadataPublisher$.MODULE$.getTopicDelta("bar", MetadataImageTest.IMAGE1, MetadataImageTest.DELTA1).isDefined(), (Function0 & Serializable & scala.Serializable)() -> "Expected to see delta for changed topic");
    }

    @Test
    public void testFindStrayReplicas() {
        int brokerId = 0;
        String deletedTopic = "a";
        Uuid deletedTopicId = Uuid.randomUuid();
        TopicPartition deletedTopicPartition1 = new TopicPartition(deletedTopic, 0);
        UnifiedLog deletedTopicLog1 = this.mockLog(deletedTopicId, deletedTopicPartition1);
        TopicPartition deletedTopicPartition2 = new TopicPartition(deletedTopic, 1);
        UnifiedLog deletedTopicLog2 = this.mockLog(deletedTopicId, deletedTopicPartition2);
        String recreatedTopic = "b";
        TopicPartition recreatedTopicPartition = new TopicPartition(recreatedTopic, 0);
        UnifiedLog recreatedTopicLog = this.mockLog(Uuid.randomUuid(), recreatedTopicPartition);
        TopicImage recreatedTopicImage = this.topicImage(Uuid.randomUuid(), recreatedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)recreatedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))));
        String reassignedTopic = "c";
        Uuid reassignedTopicId = Uuid.randomUuid();
        TopicPartition reassignedTopicPartition = new TopicPartition(reassignedTopic, 0);
        UnifiedLog reassignedTopicLog = this.mockLog(reassignedTopicId, reassignedTopicPartition);
        TopicPartition retainedTopicPartition = new TopicPartition(reassignedTopic, 1);
        UnifiedLog retainedTopicLog = this.mockLog(reassignedTopicId, retainedTopicPartition);
        TopicImage reassignedTopicImage = this.topicImage(reassignedTopicId, reassignedTopic, (scala.collection.immutable.Map<Object, Seq<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)reassignedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)retainedTopicPartition.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})))}))));
        .colon.colon logs = new .colon.colon((Object)deletedTopicLog1, (List)new .colon.colon((Object)deletedTopicLog2, (List)new .colon.colon((Object)recreatedTopicLog, (List)new .colon.colon((Object)reassignedTopicLog, (List)new .colon.colon((Object)retainedTopicLog, (List)Nil$.MODULE$)))));
        TopicsImage image = this.topicsImage((Seq<TopicImage>)new .colon.colon((Object)recreatedTopicImage, (List)new .colon.colon((Object)reassignedTopicImage, (List)Nil$.MODULE$)));
        Set expectedStrayPartitions = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{deletedTopicPartition1, deletedTopicPartition2, recreatedTopicPartition, reassignedTopicPartition}));
        Set strayPartitions = BrokerMetadataPublisher$.MODULE$.findStrayPartitions(brokerId, image, (Iterable)logs).toSet();
        Assertions.assertEquals((Object)expectedStrayPartitions, (Object)strayPartitions);
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog mockLog(Uuid topicId, TopicPartition topicPartition) {
        void var3_3;
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)topicId));
        Mockito.when((Object)log.topicPartition()).thenReturn((Object)topicPartition);
        return var3_3;
    }

    private TopicImage topicImage(Uuid topicId, String topic, scala.collection.immutable.Map<Object, Seq<Object>> partitions) {
        scala.collection.immutable.Map partitionRegistrations = (scala.collection.immutable.Map)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            int partitionId = x0$1._1$mcI$sp();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionRegistration((int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])replicas.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), BoxesRunTime.unboxToInt((Object)replicas.head()), 0, 0));
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        return new TopicImage(topic, topicId, (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)partitionRegistrations).asJava());
    }

    private TopicsImage topicsImage(Seq<TopicImage> topics) {
        scala.collection.immutable.Map idsMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.id()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map namesMap = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t.name()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new TopicsImage((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)idsMap).asJava(), (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)namesMap).asJava());
    }
}

