/*
 * Decompiled with CFR 0.152.
 */
package integration.kafka.server;

import java.time.Duration;
import java.util.Arrays;
import java.util.Properties;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.api.KAFKA_3_1_IV0$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.ZkVersion$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=3Aa\u0002\u0005\u0001\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C!7!)!\u0005\u0001C!G!)Q\u0006\u0001C\u0001]!)q\b\u0001C\u0005\u0001\")A\t\u0001C\u0005\u000b\nIb)\u001a;dQJ+\u0017/^3tiR+7\u000f\u001e#po:<'/\u00193f\u0015\tI!\"\u0001\u0004tKJ4XM\u001d\u0006\u0003\u00171\tQa[1gW\u0006T\u0011!D\u0001\fS:$Xm\u001a:bi&|gn\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"BA\u0005\u0014\u0015\u0005Y\u0011BA\u000b\u0013\u0005=\u0011\u0015m]3SKF,Xm\u001d;UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u0019!\tI\u0002!D\u0001\t\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003q\u0001\"!\b\u0011\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u00111!\u00138u\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001\u0013\u0011\u0007\u0015B#&D\u0001'\u0015\t9c$\u0001\u0006d_2dWm\u0019;j_:L!!\u000b\u0014\u0003\u0007M+\u0017\u000f\u0005\u0002\u0012W%\u0011AF\u0005\u0002\f\u0017\u000647.Y\"p]\u001aLw-A\u001cuKN$Hk\u001c9jG&#\u0017j\u001d*f[>4X\r\u001a$s_64U\r^2iKJ<\u0006.\u001a8D_:$(o\u001c7mKJ$un\u001e8he\u0006$Wm\u001d\u000b\u0002_A\u0011Q\u0004M\u0005\u0003cy\u0011A!\u00168ji\"\u0012Aa\r\t\u0003iuj\u0011!\u000e\u0006\u0003m]\n1!\u00199j\u0015\tA\u0014(A\u0004kkBLG/\u001a:\u000b\u0005iZ\u0014!\u00026v]&$(\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?k\t!A+Z:u\u0003I)gn];sK\u000e{g\u000e\u001e:pY2,'/\u00138\u0015\u0005=\n\u0005\"\u0002\"\u0006\u0001\u0004\u0019\u0015!\u00032s_.,'/\u00133t!\r)\u0003\u0006H\u0001\rGJ,\u0017\r^3D_:4\u0017n\u001a\u000b\u0004U\u0019C\u0005\"B$\u0007\u0001\u0004a\u0012A\u00028pI\u0016LE\rC\u0003J\r\u0001\u0007!*\u0001\nj]R,'O\u0011:pW\u0016\u0014h+\u001a:tS>t\u0007CA&N\u001b\u0005a%B\u0001\u001c\u0014\u0013\tqEJ\u0001\u0006Ba&4VM]:j_:\u0004")
public class FetchRequestTestDowngrade
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return new .colon.colon((Object)this.createConfig(0, (ApiVersion)KAFKA_3_1_IV0$.MODULE$), (List)new .colon.colon((Object)this.createConfig(1, (ApiVersion)KAFKA_2_7_IV0$.MODULE$), (List)Nil$.MODULE$));
    }

    @Test
    public void testTopicIdIsRemovedFromFetcherWhenControllerDowngrades() {
        TopicPartition tp = new TopicPartition("topic", 0);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        this.ensureControllerIn((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))));
        Assertions.assertEquals((int)0, (int)this.controllerSocketServer().config().brokerId());
        scala.collection.immutable.Map<Object, Object> partitionLeaders = this.createTopicWithAssignment(tp.topic(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)tp.partition())), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})))}))), this.createTopicWithAssignment$default$3());
        TestUtils$.MODULE$.waitForAllPartitionsMetadata(this.servers(), tp.topic(), 1);
        this.ensureControllerIn((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))));
        Assertions.assertEquals((int)1, (int)this.controllerSocketServer().config().brokerId());
        Assertions.assertEquals((int)1, (int)BoxesRunTime.unboxToInt((Object)partitionLeaders.apply((Object)BoxesRunTime.boxToInteger((int)0))));
        ProducerRecord record1 = new ProducerRecord(tp.topic(), Predef$.MODULE$.int2Integer(tp.partition()), null, (Object)"key".getBytes(), (Object)"value".getBytes());
        producer.send(record1);
        consumer.assign(Arrays.asList((Object[])new TopicPartition[]{tp}));
        int count = consumer.poll(Duration.ofMillis(5000L)).count();
        Assertions.assertEquals((int)1, (int)count);
    }

    private void ensureControllerIn(Seq<Object> brokerIds) {
        while (!brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)this.controllerSocketServer().config().brokerId()))) {
            this.zkClient().deleteController(ZkVersion$.MODULE$.MatchAnyVersion());
            TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        }
    }

    private KafkaConfig createConfig(int nodeId, ApiVersion interBrokerVersion) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(nodeId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        props.put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), interBrokerVersion.version());
        return KafkaConfig$.MODULE$.fromProps(props);
    }
}

