/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.PlaintextAdminIntegrationTest$;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogConfig$;
import kafka.server.Defaults$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ObjectRef;

@Timeout(value=120L)
@ScalaSignature(bytes="\u0006\u0001\u0005Ug\u0001\u0002\u000f\u001e\u0001\tBQa\f\u0001\u0005\u0002ABqa\r\u0001A\u0002\u0013\u0005A\u0007C\u0004C\u0001\u0001\u0007I\u0011A\"\t\r1\u0003\u0001\u0015)\u00036\u0011\u001di\u0005A1A\u0005\u00029CaA\u0015\u0001!\u0002\u0013y\u0005\"B*\u0001\t\u0003\"\u0006\"\u00023\u0001\t\u0003*\u0007\"\u00026\u0001\t\u0003Y\u0007bBA\u0006\u0001\u0011\u0005\u0013Q\u0002\u0005\u0007\u0003O\u0001A\u0011A3\t\r\u0005E\u0002\u0001\"\u0001f\u0011\u0019\t)\u0004\u0001C\u0001K\u001e9\u0011QI\u000f\t\u0002\u0005\u001dcA\u0002\u000f\u001e\u0011\u0003\tI\u0005\u0003\u00040\u001f\u0011\u0005\u0011\u0011\u000b\u0004\u0007\u0003'z\u0001!!\u0016\t\r=\nB\u0011AA3\u0011-\tY'\u0005a\u0001\u0002\u0004%\t!!\u001c\t\u0017\u00055\u0015\u00031AA\u0002\u0013\u0005\u0011q\u0012\u0005\f\u0003{\n\u0002\u0019!A!B\u0013\ty\u0007C\u0005\u0002\u001cF\u0001\r\u0011\"\u0001\u0002\u001e\"I\u0011QU\tA\u0002\u0013\u0005\u0011q\u0015\u0005\t\u0003W\u000b\u0002\u0015)\u0003\u0002 \"9\u0011QV\t\u0005\u0002\u0005=\u0006bBA_#\u0011\u0005\u0011q\u0018\u0005\u0007\u0003'\fB\u0011A3\u0003M\u0005#W.\u001b8DY&,g\u000e^,ji\"\u0004v\u000e\\5dS\u0016\u001c\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u001f?\u0005\u0019\u0011\r]5\u000b\u0003\u0001\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R!AJ\u0010\u0002\u0017%tG/Z4sCRLwN\\\u0005\u0003Q\u0015\u0012acS1gW\u0006\u001cVM\u001d<feR+7\u000f\u001e%be:,7o\u001d\t\u0003U5j\u0011a\u000b\u0006\u0003Y}\tQ!\u001e;jYNL!AL\u0016\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012!\r\t\u0003e\u0001i\u0011!H\u0001\u0007G2LWM\u001c;\u0016\u0003U\u0002\"A\u000e!\u000e\u0003]R!\u0001O\u001d\u0002\u000b\u0005$W.\u001b8\u000b\u0005iZ\u0014aB2mS\u0016tGo\u001d\u0006\u0003AqR!!\u0010 \u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0014aA8sO&\u0011\u0011i\u000e\u0002\u0006\u0003\u0012l\u0017N\\\u0001\u000bG2LWM\u001c;`I\u0015\fHC\u0001#K!\t)\u0005*D\u0001G\u0015\u00059\u0015!B:dC2\f\u0017BA%G\u0005\u0011)f.\u001b;\t\u000f-\u001b\u0011\u0011!a\u0001k\u0005\u0019\u0001\u0010J\u0019\u0002\u000f\rd\u0017.\u001a8uA\u0005Y!M]8lKJ\u001cu.\u001e8u+\u0005y\u0005CA#Q\u0013\t\tfIA\u0002J]R\fAB\u0019:pW\u0016\u00148i\\;oi\u0002\nQa]3u+B$\"\u0001R+\t\u000bY;\u0001\u0019A,\u0002\u0011Q,7\u000f^%oM>\u0004\"\u0001\u00170\u000e\u0003eS!A\b.\u000b\u0005mc\u0016a\u00026va&$XM\u001d\u0006\u0003;z\nQA[;oSRL!aX-\u0003\u0011Q+7\u000f^%oM>D#aB1\u0011\u0005a\u0013\u0017BA2Z\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]R\tA\t\u000b\u0002\tOB\u0011\u0001\f[\u0005\u0003Sf\u0013\u0011\"\u00114uKJ,\u0015m\u00195\u0002\u0019\r\u0014X-\u0019;f\u0007>tg-[4\u0016\u00031\u0004B!\u001c:u\u007f6\taN\u0003\u0002pa\u0006!Q\u000f^5m\u0015\u0005\t\u0018\u0001\u00026bm\u0006L!a\u001d8\u0003\u00075\u000b\u0007\u000f\u0005\u0002vy:\u0011aO\u001f\t\u0003o\u001ak\u0011\u0001\u001f\u0006\u0003s\u0006\na\u0001\u0010:p_Rt\u0014BA>G\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m4\u0005\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015\u0001/\u0001\u0003mC:<\u0017\u0002BA\u0005\u0003\u0007\u0011aa\u00142kK\u000e$\u0018aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0005\u0005=\u0001CBA\t\u0003/\tY\"\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002\u001a\u0005M!aA*fcB!\u0011QDA\u0012\u001b\t\tyBC\u0002\u0002\"}\taa]3sm\u0016\u0014\u0018\u0002BA\u0013\u0003?\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006)B/Z:u-\u0006d\u0017\u000eZ!mi\u0016\u00148i\u001c8gS\u001e\u001c\bfA\u0006\u0002,A\u0019\u0001,!\f\n\u0007\u0005=\u0012L\u0001\u0003UKN$\u0018a\u0006;fgRLeN^1mS\u0012\fE\u000e^3s\u0007>tg-[4tQ\ra\u00111F\u0001#i\u0016\u001cH/\u00138wC2LG-\u00117uKJ\u001cuN\u001c4jON$U/\u001a+p!>d\u0017nY=)\u00075\tY\u0003K\u0004\u0001\u0003w\t\t%a\u0011\u0011\u0007a\u000bi$C\u0002\u0002@e\u0013q\u0001V5nK>,H/A\u0003wC2,XMH\u0001y\u0003\u0019\nE-\\5o\u00072LWM\u001c;XSRD\u0007k\u001c7jG&,7/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\t\u0003e=\u00192aDA&!\r)\u0015QJ\u0005\u0004\u0003\u001f2%AB!osJ+g\r\u0006\u0002\u0002H\t1\u0001k\u001c7jGf\u001cB!E@\u0002XA!\u0011\u0011LA1\u001b\t\tYF\u0003\u0003\u0002^\u0005}\u0013A\u00029pY&\u001c\u0017PC\u0002\u0002\"mJA!a\u0019\u0002\\\t\t\u0012\t\u001c;fe\u000e{gNZ5h!>d\u0017nY=\u0015\u0005\u0005\u001d\u0004cAA5#5\tq\"A\u0004d_:4\u0017nZ:\u0016\u0005\u0005=\u0004\u0007BA9\u0003s\u0002b!^A:i\u0006U\u0014BA:\u007f!\u0011\t9(!\u001f\r\u0001\u0011Y\u00111P\u000b\u0002\u0002\u0003\u0005)\u0011AA@\u0005\ryF%M\u0001\tG>tg-[4tAE!\u0011\u0011QAD!\r)\u00151Q\u0005\u0004\u0003\u000b3%a\u0002(pi\"Lgn\u001a\t\u0004\u000b\u0006%\u0015bAAF\r\n\u0019\u0011I\\=\u0002\u0017\r|gNZ5hg~#S-\u001d\u000b\u0004\t\u0006E\u0005\u0002C&\u0015\u0003\u0003\u0005\r!a%1\t\u0005U\u0015\u0011\u0014\t\u0007k\u0006MD/a&\u0011\t\u0005]\u0014\u0011\u0014\u0003\r\u0003w\n\t*!A\u0001\u0002\u000b\u0005\u0011qP\u0001\u0007G2|7/\u001a3\u0016\u0005\u0005}\u0005cA#\u0002\"&\u0019\u00111\u0015$\u0003\u000f\t{w\u000e\\3b]\u0006Q1\r\\8tK\u0012|F%Z9\u0015\u0007\u0011\u000bI\u000b\u0003\u0005L/\u0005\u0005\t\u0019AAP\u0003\u001d\u0019Gn\\:fI\u0002\n\u0011bY8oM&<WO]3\u0015\u0007\u0011\u000b\t\fC\u0004\u0002le\u0001\r!a-1\t\u0005U\u0016\u0011\u0018\t\u0006[J$\u0018q\u0017\t\u0005\u0003o\nI\f\u0002\u0007\u0002<\u0006E\u0016\u0011!A\u0001\u0006\u0003\tyHA\u0002`II\n\u0001B^1mS\u0012\fG/\u001a\u000b\u0004\t\u0006\u0005\u0007bBAb5\u0001\u0007\u0011QY\u0001\u0010e\u0016\fX/Z:u\u001b\u0016$\u0018\rZ1uCB!\u0011qYAg\u001d\u0011\tI&!3\n\t\u0005-\u00171L\u0001\u0012\u00032$XM]\"p]\u001aLw\rU8mS\u000eL\u0018\u0002BAh\u0003#\u0014qBU3rk\u0016\u001cH/T3uC\u0012\fG/\u0019\u0006\u0005\u0003\u0017\fY&A\u0003dY>\u001cX\r")
public class AdminClientWithPoliciesIntegrationTest
extends KafkaServerTestHarness {
    private Admin client = null;
    private final int brokerCount;

    public Admin client() {
        return this.client;
    }

    public void client_$eq(Admin x$1) {
        this.client = x$1;
    }

    public int brokerCount() {
        return this.brokerCount;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated(this.servers(), TestUtils$.MODULE$.waitUntilBrokerMetadataIsPropagated$default$2());
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.client() != null) {
            Utils.closeQuietly((AutoCloseable)this.client(), (String)"AdminClient");
        }
        super.tearDown();
    }

    public java.util.Map<String, Object> createConfig() {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)this.bootstrapServers(this.bootstrapServers$default$1()))}))).asJava();
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        Seq<Properties> configs = TestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17());
        configs.foreach((Function1 & Serializable & scala.Serializable)props -> props.put(KafkaConfig$.MODULE$.AlterConfigPolicyClassNameProp(), Policy.class));
        return (Seq)configs.map((Function1 & Serializable & scala.Serializable)props -> KafkaConfig$.MODULE$.fromProps(props), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testValidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "describe-alter-configs-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        Properties topicConfig1 = new Properties();
        topicConfig1.setProperty(LogConfig$.MODULE$.MaxMessageBytesProp(), "500000");
        topicConfig1.setProperty(LogConfig$.MODULE$.RetentionMsProp(), "60000000");
        this.createTopic(topic1, 1, 1, topicConfig1, this.createTopic$default$5());
        String topic2 = "describe-alter-configs-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        PlaintextAdminIntegrationTest$.MODULE$.checkValidAlterConfigs(this.client(), topicResource1, topicResource2);
    }

    @Test
    public void testInvalidAlterConfigs() {
        this.client_$eq(Admin.create(this.createConfig()));
        PlaintextAdminIntegrationTest$.MODULE$.checkInvalidAlterConfigs(this.zkClient(), (Seq<KafkaServer>)this.servers(), this.client());
    }

    @Test
    public void testInvalidAlterConfigsDueToPolicy() {
        this.client_$eq(Admin.create(this.createConfig()));
        String topic1 = "invalid-alter-configs-due-to-policy-topic-1";
        ConfigResource topicResource1 = new ConfigResource(ConfigResource.Type.TOPIC, topic1);
        this.createTopic(topic1, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        String topic2 = "invalid-alter-configs-due-to-policy-topic-2";
        ConfigResource topicResource2 = new ConfigResource(ConfigResource.Type.TOPIC, topic2);
        this.createTopic(topic2, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        String topic3 = "invalid-alter-configs-due-to-policy-topic-3";
        ConfigResource topicResource3 = new ConfigResource(ConfigResource.Type.TOPIC, topic3);
        this.createTopic(topic3, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        java.util.List topicConfigEntries1 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.9"), (List)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "2"), (List)Nil$.MODULE$))).asJava();
        java.util.List topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.8"), (List)Nil$.MODULE$)).asJava();
        java.util.List topicConfigEntries3 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinInSyncReplicasProp(), "-1"), (List)Nil$.MODULE$)).asJava();
        ConfigResource brokerResource = new ConfigResource(ConfigResource.Type.BROKER, Integer.toString(((KafkaServer)this.servers().head()).config().brokerId()));
        java.util.List brokerConfigEntries = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "12313"), (List)Nil$.MODULE$)).asJava();
        ObjectRef alterResult = ObjectRef.create((Object)this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries))}))).asJava()));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get()).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get()).getCause() instanceof InvalidRequestException));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get()).getCause() instanceof InvalidRequestException));
        java.util.Map configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MinInSyncReplicas()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
        topicConfigEntries2 = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new ConfigEntry(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), "0.7"), (List)Nil$.MODULE$)).asJava();
        alterResult.elem = this.client().alterConfigs((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource1), (Object)new Config((Collection)topicConfigEntries1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource2), (Object)new Config((Collection)topicConfigEntries2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)brokerResource), (Object)new Config((Collection)brokerConfigEntries)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicResource3), (Object)new Config((Collection)topicConfigEntries3))}))).asJava(), new AlterConfigsOptions().validateOnly(true));
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ConfigResource[]{topicResource1, topicResource2, topicResource3, brokerResource}))).asJava(), ((AlterConfigsResult)alterResult.elem).values().keySet());
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource1)).get()).getCause() instanceof PolicyViolationException));
        ((KafkaFuture)((AlterConfigsResult)alterResult.elem).values().get(topicResource2)).get();
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(topicResource3)).get()).getCause() instanceof InvalidRequestException));
        Assertions.assertTrue((boolean)(Assertions.assertThrows(ExecutionException.class, () -> ((KafkaFuture)((AlterConfigsResult)alterResult$1.elem).values().get(brokerResource)).get()).getCause() instanceof InvalidRequestException));
        configs = (java.util.Map)this.client().describeConfigs((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topicResource1, (List)new .colon.colon((Object)topicResource2, (List)new .colon.colon((Object)topicResource3, (List)new .colon.colon((Object)brokerResource, (List)Nil$.MODULE$))))).asJava()).all().get();
        Assertions.assertEquals((int)4, (int)configs.size());
        Assertions.assertEquals((Object)Double.toString(Defaults$.MODULE$.LogCleanerMinCleanRatio()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertEquals((Object)Integer.toString(Defaults$.MODULE$.MinInSyncReplicas()), (Object)((Config)configs.get(topicResource1)).get(LogConfig$.MODULE$.MinInSyncReplicasProp()).value());
        Assertions.assertEquals((Object)"0.8", (Object)((Config)configs.get(topicResource2)).get(LogConfig$.MODULE$.MinCleanableDirtyRatioProp()).value());
        Assertions.assertNull((Object)((Config)configs.get(brokerResource)).get(KafkaConfig$.MODULE$.SslTruststorePasswordProp()).value());
    }

    public AdminClientWithPoliciesIntegrationTest() {
        this.brokerCount = 3;
    }

    public static class Policy
    implements AlterConfigPolicy {
        private scala.collection.immutable.Map<String, ?> configs;
        private boolean closed = false;

        public scala.collection.immutable.Map<String, ?> configs() {
            return this.configs;
        }

        public void configs_$eq(scala.collection.immutable.Map<String, ?> x$1) {
            this.configs = x$1;
        }

        public boolean closed() {
            return this.closed;
        }

        public void closed_$eq(boolean x$1) {
            this.closed = x$1;
        }

        public void configure(java.util.Map<String, ?> configs) {
            this.configs_$eq(((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(configs).asScala()).toMap(Predef$.MODULE$.$conforms()));
        }

        public void validate(AlterConfigPolicy.RequestMetadata requestMetadata) {
            Predef$.MODULE$.require(!this.closed(), (Function0 & Serializable & scala.Serializable)() -> "Policy should not be closed");
            Predef$.MODULE$.require(!this.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "configure should have been called with non empty configs");
            Predef$.MODULE$.require(!requestMetadata.configs().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "request configs should not be empty");
            Predef$.MODULE$.require(new StringOps(Predef$.MODULE$.augmentString(requestMetadata.resource().name())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "resource name should not be empty");
            Predef$.MODULE$.require(requestMetadata.resource().name().contains("topic"));
            if (requestMetadata.configs().containsKey("min.insync.replicas")) {
                throw new PolicyViolationException("Min in sync replicas cannot be updated");
            }
        }

        public void close() {
            this.closed_$eq(true);
        }
    }
}

