/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import kafka.api.ApiVersion;
import kafka.api.ApiVersion$;
import kafka.api.KAFKA_2_6_IV0$;
import kafka.cluster.AbstractPartitionTest;
import kafka.cluster.CommittedPartitionState;
import kafka.cluster.DelayedOperations;
import kafka.cluster.IsrChangeListener;
import kafka.cluster.OngoingReassignmentState;
import kafka.cluster.Partition;
import kafka.cluster.Partition$;
import kafka.cluster.PartitionState;
import kafka.cluster.PendingShrinkIsr;
import kafka.cluster.Replica;
import kafka.cluster.SimpleAssignmentState;
import kafka.common.UnexpectedAppendOffsetException;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.ClientRecordDeletion$;
import kafka.log.LoadedLogOffsets;
import kafka.log.LocalLog;
import kafka.log.LogAppendInfo;
import kafka.log.LogLoader;
import kafka.log.LogManager;
import kafka.log.LogReadInfo;
import kafka.log.LogSegments;
import kafka.log.LogStartOffsetIncrementReason;
import kafka.log.ProducerStateManager;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.AlterIsrItem;
import kafka.server.AlterIsrManager;
import kafka.server.AlterIsrManager$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.epoch.LeaderEpochFileCache;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.KafkaScheduler;
import kafka.utils.KafkaScheduler$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.InconsistentTopicIdException;
import org.apache.kafka.common.errors.NotLeaderOrFollowerException;
import org.apache.kafka.common.errors.OffsetNotAvailableException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.SystemTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t]g\u0001B!C\u0001\u001dCQ\u0001\u0014\u0001\u0005\u00025CQa\u0014\u0001\u0005\u0002ACQ\u0001\u001a\u0001\u0005\u0002ACQA\u001a\u0001\u0005\u0002ACQ\u0001\u001b\u0001\u0005\u0002ACQA\u001b\u0001\u0005\u0002ACQ\u0001\u001c\u0001\u0005\u0002ACQA\u001c\u0001\u0005\u0002ACQ\u0001\u001d\u0001\u0005\u0002ACQA\u001d\u0001\u0005\u0002ACQ\u0001\u001e\u0001\u0005\u0002ACQA\u001e\u0001\u0005\u0002ACQ\u0001\u001f\u0001\u0005\u0002ACQA\u001f\u0001\u0005\u0002ACQ\u0001 \u0001\u0005\u0002ACQA \u0001\u0005\u0002ACa!!\u0001\u0001\t\u0003\u0001\u0006BBA\u0003\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002\n\u0001!\t\u0001\u0015\u0005\u0007\u0003\u001b\u0001A\u0011\u0001)\t\r\u0005E\u0001\u0001\"\u0001Q\u0011\u0019\t)\u0002\u0001C\u0001!\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001\"CA5\u0001E\u0005I\u0011AA6\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007Ca!!#\u0001\t\u0003\u0001\u0006BBAG\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002\u0012\u0002!\t\u0001\u0015\u0005\u0007\u0003+\u0003A\u0011\u0001)\t\r\u0005e\u0005\u0001\"\u0001Q\u0011\u0019\ti\n\u0001C\u0001!\"1\u0011\u0011\u0015\u0001\u0005\u0002ACa!!*\u0001\t\u0003\u0001\u0006BBAU\u0001\u0011\u0005\u0001\u000b\u0003\u0004\u0002.\u0002!\t\u0001\u0015\u0005\u0007\u0003c\u0003A\u0011\u0001)\t\r\u0005U\u0006\u0001\"\u0001Q\u0011\u0019\tI\f\u0001C\u0001!\"1\u0011Q\u0018\u0001\u0005\u0002ACq!!1\u0001\t\u0003\t\u0019\r\u0003\u0004\u0002f\u0002!\t\u0001\u0015\u0005\u0007\u0003S\u0004A\u0011\u0001)\t\r\u00055\b\u0001\"\u0001Q\u0011\u0019\t\t\u0010\u0001C\u0001!\"1\u0011Q\u001f\u0001\u0005\u0002ACq!!?\u0001\t\u0003\tY\u0010\u0003\u0004\u0003\u000e\u0001!\t\u0001\u0015\u0005\u0007\u0005#\u0001A\u0011\u0001)\t\r\tU\u0001\u0001\"\u0001Q\u0011\u0019\u0011I\u0002\u0001C\u0001!\"1!Q\u0004\u0001\u0005\u0002ACaA!\t\u0001\t\u0003\u0001\u0006b\u0002B\u0013\u0001\u0011%!q\u0005\u0005\n\u00053\u0002\u0011\u0013!C\u0005\u00057BqAa\u0018\u0001\t\u0013\u0011\tG\u0002\u0004\u0003x\u0001!!\u0011\u0010\u0005\u000b\u0005KB$\u0011!Q\u0001\n\t\u001d\u0004B\u0003B>q\t\u0005\t\u0015!\u0003\u0002Z!Q!Q\u0010\u001d\u0003\u0002\u0003\u0006IAa \t\u0015\t\u0015\u0005H!A!\u0002\u0013\u00119\t\u0003\u0007\u0003\u001ab\u0012\t\u0011)A\u0005\u00057\u0013\t\u000b\u0003\u0006\u0003$b\u0012\t\u0011)A\u0005\u0005KCa\u0001\u0014\u001d\u0005\u0002\te\u0006b\u0002Bfq\u0011\u0005#Q\u001a\u0002\u000e!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u000b\u0005\r#\u0015aB2mkN$XM\u001d\u0006\u0002\u000b\u0006)1.\u00194lC\u000e\u00011C\u0001\u0001I!\tI%*D\u0001C\u0013\tY%IA\u000bBEN$(/Y2u!\u0006\u0014H/\u001b;j_:$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005q\u0005CA%\u0001\u0003}!Xm\u001d;MCN$h)\u001a;dQ\u0016$wJ\u001a4tKR4\u0016\r\\5eCRLwN\u001c\u000b\u0002#B\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\n!QK\\5uQ\t\u0011\u0001\f\u0005\u0002ZE6\t!L\u0003\u0002\\9\u0006\u0019\u0011\r]5\u000b\u0005us\u0016a\u00026va&$XM\u001d\u0006\u0003?\u0002\fQA[;oSRT\u0011!Y\u0001\u0004_J<\u0017BA2[\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f^'bW\u0016dU-\u00193feV\u0003H-\u0019;fg\u0016\u0003xn\u00195DC\u000eDW\r\u000b\u0002\u00041\u0006AC/Z:u\u001b\u0006L(-\u001a*fa2\f7-Z\"veJ,g\u000e^,ji\"4U\u000f^;sKJ+\u0007\u000f\\5dC\"\u0012A\u0001W\u0001.i\u0016\u001cH/T1lK\u001a{G\u000e\\8xKJ<\u0016\u000e\u001e5XSRDgi\u001c7m_^,'/\u00119qK:$'+Z2pe\u0012\u001c\bFA\u0003Y\u0003q\"Xm\u001d;NCf\u0014WMU3qY\u0006\u001cWmQ;se\u0016tGoV5uQ\u001a+H/\u001e:f%\u0016\u0004H.[2b\t&4g-\u001a:f]R\u0014\u0015m]3PM\u001a\u001cX\r^:)\u0005\u0019A\u0016a\f;fgR4U\r^2i\u001f\u001a47/\u001a;T]\u0006\u00048\u000f[8u\u000bB|7\r\u001b,bY&$\u0017\r^5p]\u001a{'\u000fT3bI\u0016\u0014\bFA\u0004Y\u0003E\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$8K\\1qg\"|G/\u00129pG\"4\u0016\r\\5eCRLwN\u001c$pe\u001a{G\u000e\\8xKJD#\u0001\u0003-\u0002WQ,7\u000f^(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014H*Z1eKJD#!\u0003-\u0002[Q,7\u000f^(gMN,GOR8s\u0019\u0016\fG-\u001a:Fa>\u001c\u0007NV1mS\u0012\fG/[8o\r>\u0014hi\u001c7m_^,'\u000f\u000b\u0002\u000b1\u00061C/Z:u%\u0016\fGMU3d_J$W\t]8dQZ\u000bG.\u001b3bi&|gNR8s\u0019\u0016\fG-\u001a:)\u0005-A\u0016\u0001\u000b;fgR\u0014V-\u00193SK\u000e|'\u000fZ#q_\u000eDg+\u00197jI\u0006$\u0018n\u001c8G_J4u\u000e\u001c7po\u0016\u0014\bF\u0001\u0007Y\u0003M\"Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$hi\u001c:US6,7\u000f^1na\u0016\u0003xn\u00195WC2LG-\u0019;j_:4uN\u001d'fC\u0012,'\u000f\u000b\u0002\u000e1\u0006)D/Z:u\r\u0016$8\r[(gMN,GOR8s)&lWm\u001d;b[B,\u0005o\\2i-\u0006d\u0017\u000eZ1uS>tgi\u001c:G_2dwn^3sQ\tq\u0001,\u0001\u0015uKN$h)\u001a;dQ2\u000bG/Z:u\u001f\u001a47/\u001a;J]\u000edW\u000fZ3t\u0019\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u000b\u0002\u00101\u0006)C/Z:u\u001b>tw\u000e^8oS\u000e|eMZ:fiN\fe\r^3s\u0019\u0016\fG-\u001a:DQ\u0006tw-\u001a\u0015\u0003!a\u000ba\u0006^3ti\u0006\u0003\b/\u001a8e%\u0016\u001cwN\u001d3t\u0003N4u\u000e\u001c7po\u0016\u0014()\u001a7po2{wm\u0015;beR|eMZ:fi\"\u0012\u0011\u0003W\u0001\u001ei\u0016\u001cH\u000fT5ti>3gm]3u\u0013N|G.\u0019;j_:dUM^3mg\"\u0012!\u0003W\u0001\u000fi\u0016\u001cHoR3u%\u0016\u0004H.[2bQ\t\u0019\u0002,A\u001cuKN$\u0018\t\u001d9f]\u0012\u0014VmY8sIN$vNR8mY><XM],ji\"tuNU3qY&\u001c\u0017\r\u00165s_^\u001cX\t_2faRLwN\u001c\u0015\u0003)a\u000bA\u0005^3ti6\u000b7.\u001a$pY2|w/\u001a:XSRDgj\u001c'fC\u0012,'/\u00133DQ\u0006tw-\u001a\u0015\u0003+a\u000bq\t^3ti\u001a{G\u000e\\8xKJ$u.Z:O_RTu.\u001b8J'J+f\u000e^5m\u0007\u0006,x\r\u001b;VaR{wJ\u001a4tKR<\u0016\u000e\u001e5j]\u000e+(O]3oi2+\u0017\rZ3s\u000bB|7\r\u001b\u0015\u0003-a\u000bQb\u0019:fCR,'+Z2pe\u0012\u001cH\u0003CA\u000f\u0003g\t)&a\u0018\u0011\t\u0005}\u0011qF\u0007\u0003\u0003CQA!a\t\u0002&\u00051!/Z2pe\u0012TA!a\n\u0002*\u000511m\\7n_:T1!RA\u0016\u0015\r\ti\u0003Y\u0001\u0007CB\f7\r[3\n\t\u0005E\u0012\u0011\u0005\u0002\u000e\u001b\u0016lwN]=SK\u000e|'\u000fZ:\t\u000f\u0005Ur\u00031\u0001\u00028\u00059!/Z2pe\u0012\u001c\bCBA\u001d\u0003\u0013\nyE\u0004\u0003\u0002<\u0005\u0015c\u0002BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005c)\u0001\u0004=e>|GOP\u0005\u0002)&\u0019\u0011qI*\u0002\u000fA\f7m[1hK&!\u00111JA'\u0005!IE/\u001a:bE2,'bAA$'B!\u0011qDA)\u0013\u0011\t\u0019&!\t\u0003\u0019MKW\u000e\u001d7f%\u0016\u001cwN\u001d3\t\u000f\u0005]s\u00031\u0001\u0002Z\u0005Q!-Y:f\u001f\u001a47/\u001a;\u0011\u0007I\u000bY&C\u0002\u0002^M\u0013A\u0001T8oO\"I\u0011\u0011M\f\u0011\u0002\u0003\u0007\u00111M\u0001\u0015a\u0006\u0014H/\u001b;j_:dU-\u00193fe\u0016\u0003xn\u00195\u0011\u0007I\u000b)'C\u0002\u0002hM\u00131!\u00138u\u0003]\u0019'/Z1uKJ+7m\u001c:eg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002n)\"\u00111MA8W\t\t\t\b\u0005\u0003\u0002t\u0005uTBAA;\u0015\u0011\t9(!\u001f\u0002\u0013Ut7\r[3dW\u0016$'bAA>'\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0014Q\u000f\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AG2sK\u0006$X\r\u0016:b]N\f7\r^5p]\u0006d'+Z2pe\u0012\u001cHCBA\u000f\u0003\u000b\u000b9\tC\u0004\u00026e\u0001\r!a\u000e\t\u000f\u0005]\u0013\u00041\u0001\u0002Z\u0005aA/Z:u\u0003Rl\u0015N\\%te\"\u0012!\u0004W\u0001\u001di\u0016\u001cH/\u00169eCR,gi\u001c7m_^,'OR3uG\"\u001cF/\u0019;fQ\tY\u0002,\u0001\u0018uKN$\u0018J\u001c<bY&$\u0017\t\u001c;feB\u000b'\u000f^5uS>t'+Z9vKN$8/\u0011:f\u001d>$(+\u001a;sS\u0016$\u0007F\u0001\u000fY\u0003A!Xm\u001d;JgJ,\u0005\u0010]1og&|g\u000e\u000b\u0002\u001e1\u0006yB/Z:u\u0013N\u0014hj\u001c;FqB\fg\u000eZ3e\u0013\u001a,\u0006\u000fZ1uK\u001a\u000b\u0017\u000e\\:)\u0005yA\u0016A\u0005;fgR\u0014V\r\u001e:z'\"\u0014\u0018N\\6JgJD#a\b-\u0002%Q,7\u000f^'bs\n,7\u000b\u001b:j].L5O\u001d\u0015\u0003Aa\u000bA\u0004^3ti\u0006cG/\u001a:JgJdU-\u00193fe\u0006sG-S:s%\u0006\u001cW\r\u000b\u0002\"1\u0006yC/Z:u'\"|W\u000f\u001c3O_R\u001c\u0006N]5oW&\u001b(/\u00134Qe\u00164\u0018n\\;t\r\u0016$8\r[%t\u0007\u0006,x\r\u001b;Va\"\u0012!\u0005W\u00011i\u0016\u001cHo\u00155pk2$gj\u001c;TQJLgn[%te&3gi\u001c7m_^,'oQ1vO\"$X\u000b\u001d+p\u0019><WI\u001c3)\u0005\rB\u0016!\b;fgRL5O\u001d(piNC'/\u001e8l\u0013\u001a,\u0006\u000fZ1uK\u001a\u000b\u0017\u000e\\:)\u0005\u0011B\u0016\u0001\u0007;fgR\fE\u000e^3s\u0013N\u0014XK\\6o_^tGk\u001c9jG\"\u0012Q\u0005W\u0001\u001bi\u0016\u001cH/\u00117uKJL5O]%om\u0006d\u0017\u000e\u001a,feNLwN\u001c\u0015\u0003Ma\u000b1\u0004^3ti\u0006cG/\u001a:JgJ,f.\u001a=qK\u000e$X\rZ#se>\u0014\bFA\u0014Y\u0003UA\u0017M\u001c3mK\u0006cG/\u001a:JgJ4\u0015-\u001b7ve\u0016$R!UAc\u0003+Dq!a2)\u0001\u0004\tI-A\u0003feJ|'\u000f\u0005\u0003\u0002L\u0006EWBAAg\u0015\u0011\ty-!\n\u0002\u0011A\u0014x\u000e^8d_2LA!a5\u0002N\n1QI\u001d:peNDq!a6)\u0001\u0004\tI.\u0001\u0005dC2d'-Y2l!)\u0011\u00161\\A2\u0003G\ny.U\u0005\u0004\u0003;\u001c&!\u0003$v]\u000e$\u0018n\u001c84!\rI\u0015\u0011]\u0005\u0004\u0003G\u0014%!\u0003)beRLG/[8o\u0003i!Xm\u001d;TS:<G.Z%o\r2Lw\r\u001b;BYR,'/S:sQ\tI\u0003,A\u000fuKN$(l[%te6\u000bg.Y4fe\u0006\u001b\u0018P\\2DC2d'-Y2lQ\tQ\u0003,\u0001\u0016uKN$Xk]3DQ\u0016\u001c7\u000e]8j]R$v.\u00138ji&\fG.\u001b>f\u0011&<\u0007nV1uKJl\u0017M]6)\u0005-B\u0016\u0001\f;fgR$v\u000e]5d\u0013\u0012\fe\u000e\u001a)beRLG/[8o\u001b\u0016$\u0018\rZ1uC\u001aKG.\u001a$pe2+\u0017\rZ3sQ\ta\u0003,\u0001\u0018uKN$Hk\u001c9jG&#\u0017I\u001c3QCJ$\u0018\u000e^5p]6+G/\u00193bi\u00064\u0015\u000e\\3G_J4u\u000e\u001c7po\u0016\u0014\bFA\u0017Y\u00031\u0019\u0007.Z2l)>\u0004\u0018nY%e)\u0015\t\u0016Q B\u0005\u0011\u001d\tyP\fa\u0001\u0005\u0003\tq\"\u001a=qK\u000e$X\r\u001a+pa&\u001c\u0017\n\u001a\t\u0005\u0005\u0007\u0011)!\u0004\u0002\u0002&%!!qAA\u0013\u0005\u0011)V/\u001b3\t\u000f\t-a\u00061\u0001\u0002`\u0006I\u0001/\u0019:uSRLwN\\\u0001\u0018i\u0016\u001cH/\u00113e\u0003:$'+Z7pm\u0016lU\r\u001e:jGND#a\f-\u0002[Q,7\u000f^+oI\u0016\u0014(+\u001a9mS\u000e\fG/\u001a3QCJ$\u0018\u000e^5p]N\u001cuN\u001d:fGR\u001cV-\\1oi&\u001c7\u000f\u000b\u000211\u0006QB/Z:u+B$\u0017\r^3BgNLwM\\7f]R\fe\u000eZ%te\"\u0012\u0011\u0007W\u0001\u0016i\u0016\u001cH\u000fT8h\u0007>tg-[4O_R$\u0015N\u001d;zQ\t\u0011\u0004,\u0001\u0011uKN$Hj\\4D_:4\u0017n\u001a#jeRL\u0018i\u001d+pa&\u001cW\u000b\u001d3bi\u0016$\u0007FA\u001aY\u0003\u0005\"Xm\u001d;M_\u001e\u001cuN\u001c4jO\u0012K'\u000f^=Bg\n\u0013xn[3s+B$\u0017\r^3eQ\t!\u0004,\u0001\u0006nC.,G*Z1eKJ$\"C!\u000b\u00030\te\"Q\bB!\u0005\u0017\u0012yEa\u0015\u0003XA\u0019!Ka\u000b\n\u0007\t52KA\u0004C_>dW-\u00198\t\u000f\tER\u00071\u0001\u00034\u00059Ao\u001c9jG&#\u0007#\u0002*\u00036\t\u0005\u0011b\u0001B\u001c'\n1q\n\u001d;j_:DqAa\u000f6\u0001\u0004\t\u0019'A\bd_:$(o\u001c7mKJ,\u0005o\\2i\u0011\u001d\u0011y$\u000ea\u0001\u0003G\n1\u0002\\3bI\u0016\u0014X\t]8dQ\"9!1I\u001bA\u0002\t\u0015\u0013aA5teB1\u0011\u0011\bB$\u0003GJAA!\u0013\u0002N\t\u00191+Z9\t\u000f\t5S\u00071\u0001\u0003F\u0005A!/\u001a9mS\u000e\f7\u000fC\u0004\u0003RU\u0002\r!a\u0019\u0002\u0013i\\g+\u001a:tS>t\u0007b\u0002B+k\u0001\u0007!\u0011F\u0001\u0006SNtUm\u001e\u0005\n\u0005\u0017)\u0004\u0013!a\u0001\u0003?\fA#\\1lK2+\u0017\rZ3sI\u0011,g-Y;mi\u0012BTC\u0001B/U\u0011\ty.a\u001c\u0002\u0017M,W\r\u001a'pO\u0012\u000bG/\u0019\u000b\b#\n\r$\u0011\u000fB;\u0011\u001d\u0011)g\u000ea\u0001\u0005O\n1\u0001\\8h!\u0011\u0011IG!\u001c\u000e\u0005\t-$b\u0001B3\t&!!q\u000eB6\u0005))f.\u001b4jK\u0012dun\u001a\u0005\b\u0005g:\u0004\u0019AA2\u0003)qW/\u001c*fG>\u0014Hm\u001d\u0005\b\u0005\u007f9\u0004\u0019AA2\u0005\u001d\u0019Fn\\<M_\u001e\u001c2\u0001\u000fB4\u00039awnZ*uCJ$xJ\u001a4tKR\f\u0001\u0002\\8dC2dun\u001a\t\u0005\u0005S\u0012\t)\u0003\u0003\u0003\u0004\n-$\u0001\u0003'pG\u0006dGj\\4\u0002!1,\u0017\rZ3s\u000bB|7\r[\"bG\",\u0007#\u0002*\u00036\t%\u0005\u0003\u0002BF\u0005+k!A!$\u000b\t\t=%\u0011S\u0001\u0006KB|7\r\u001b\u0006\u0004\u0005'#\u0015AB:feZ,'/\u0003\u0003\u0003\u0018\n5%\u0001\u0006'fC\u0012,'/\u00129pG\"4\u0015\u000e\\3DC\u000eDW-\u0001\u000bqe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d\t\u0005\u0005S\u0012i*\u0003\u0003\u0003 \n-$\u0001\u0006)s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'/\u0003\u0003\u0003\u001a\n5\u0014aD1qa\u0016tGmU3nCBDwN]3\u0011\t\t\u001d&QW\u0007\u0003\u0005SSAAa+\u0003.\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\t=&\u0011W\u0001\u0005kRLGN\u0003\u0002\u00034\u0006!!.\u0019<b\u0013\u0011\u00119L!+\u0003\u0013M+W.\u00199i_J,GC\u0004B^\u0005\u007f\u0013\tMa1\u0003F\n\u001d'\u0011\u001a\t\u0004\u0005{CT\"\u0001\u0001\t\u000f\t\u0015t\b1\u0001\u0003h!9!1P A\u0002\u0005e\u0003b\u0002B?\u007f\u0001\u0007!q\u0010\u0005\b\u0005\u000b{\u0004\u0019\u0001BD\u0011\u001d\u0011Ij\u0010a\u0001\u00057CqAa)@\u0001\u0004\u0011)+\u0001\tbaB,g\u000eZ!t\r>dGn\\<feR!!q\u001aBk!\u0011\u0011IG!5\n\t\tM'1\u000e\u0002\u000e\u0019><\u0017\t\u001d9f]\u0012LeNZ8\t\u000f\u0005U\u0002\t1\u0001\u0002\u001e\u0001")
public class PartitionTest
extends AbstractPartitionTest {
    @Test
    public void testLastFetchedOffsetValidation() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        PartitionTest.append$1(0, 2, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(3, 3, log);
        PartitionTest.append$1(4, 5, log);
        PartitionTest.append$1(7, 1, log);
        PartitionTest.append$1(9, 3, log);
        Assertions.assertEquals((long)17L, (long)log.logEndOffset());
        int leaderEpoch = 10;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(2, 5L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(0, 2L), PartitionTest.read$1(0, 4L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(6, 6L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(4, 13L), PartitionTest.read$1(5, 9L, partition, leaderEpoch));
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(10, 17L), PartitionTest.read$1(10, 18L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 2L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(7, 14L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(9, 17L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(10, 17L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(11, 5L, partition, leaderEpoch));
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(5L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        PartitionTest.assertDivergence$1(PartitionTest.epochEndOffset$1(2, 5L), PartitionTest.read$1(2, 8L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(0, 5L, partition, leaderEpoch));
        PartitionTest.assertNoDivergence$1(PartitionTest.read$1(3, 5L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(0, 0L, partition, leaderEpoch));
        log.maybeIncrementLogStartOffset(10L, (LogStartOffsetIncrementReason)ClientRecordDeletion$.MODULE$);
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(5, 6L, partition, leaderEpoch));
        Assertions.assertThrows(OffsetOutOfRangeException.class, () -> PartitionTest.read$1(3, 6L, partition, leaderEpoch));
    }

    @Test
    public void testMakeLeaderUpdatesEpochCache() {
        int leaderEpoch = 8;
        LogManager qual$1 = this.logManager();
        TopicPartition x$12 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$12, x$3, x$4, (Option)x$2);
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k2".getBytes(), "v2".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        log.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(5), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v3".getBytes()), new SimpleRecord("k4".getBytes(), "v4".getBytes())}), 5, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        Assertions.assertEquals((long)4L, (long)log.logEndOffset());
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)4)), (Object)partition.leaderLogIfLocal().map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1.logEndOffset())));
        OffsetForLeaderEpochResponseData.EpochEndOffset epochEndOffset = partition.lastOffsetForLeaderEpoch(Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), leaderEpoch, true);
        Assertions.assertEquals((long)4L, (long)epochEndOffset.endOffset());
        Assertions.assertEquals((int)leaderEpoch, (int)epochEndOffset.leaderEpoch());
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplica() {
        CountDownLatch latch = new CountDownLatch(1);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        Thread thread1 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                Partition qual$1 = this.$outer.partition();
                boolean x$1 = qual$1.removeFutureLocalReplica$default$1();
                qual$1.removeFutureLocalReplica(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        Thread thread2 = new Thread(this, latch){
            private final /* synthetic */ PartitionTest $outer;
            private final CountDownLatch latch$1;

            public void run() {
                this.latch$1.await();
                this.$outer.partition().maybeReplaceCurrentWithFutureReplica();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.latch$1 = latch$1;
            }
        };
        thread1.start();
        thread2.start();
        latch.countDown();
        thread1.join();
        thread2.join();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().futureLog());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMakeFollowerWithWithFollowerAppendRecords() {
        Semaphore appendSemaphore = new Semaphore(0);
        MockTime mockTime = new MockTime();
        this.partition_$eq(new Partition(this, mockTime, appendSemaphore){
            private final /* synthetic */ PartitionTest $outer;
            private final MockTime mockTime$1;
            private final Semaphore appendSemaphore$1;

            public UnifiedLog createLog(boolean isNew, boolean isFutureReplica, OffsetCheckpoints offsetCheckpoints, Option<Uuid> topicId) {
                UnifiedLog log = super.createLog(isNew, isFutureReplica, offsetCheckpoints, (Option)None$.MODULE$);
                LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(1);
                LogSegments segments = new LogSegments(log.topicPartition());
                Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(log.dir(), log.topicPartition(), logDirFailureChannel, log.config().recordVersion(), "");
                int maxTransactionTimeoutMs = 300000;
                int maxProducerIdExpirationMs = 3600000;
                ProducerStateManager producerStateManager = new ProducerStateManager(log.topicPartition(), log.dir(), maxTransactionTimeoutMs, maxProducerIdExpirationMs, (Time)this.mockTime$1);
                LoadedLogOffsets offsets = new LogLoader(log.dir(), log.topicPartition(), log.config(), (Scheduler)this.mockTime$1.scheduler(), (Time)this.mockTime$1, logDirFailureChannel, true, segments, 0L, 0L, leaderEpochCache, producerStateManager).load();
                LocalLog localLog = new LocalLog(log.dir(), log.config(), segments, offsets.recoveryPoint(), offsets.nextOffsetMetadata(), (Scheduler)this.mockTime$1.scheduler(), (Time)this.mockTime$1, log.topicPartition(), logDirFailureChannel);
                return new SlowLog(this.$outer, log, offsets.logStartOffset(), localLog, (Option<LeaderEpochFileCache>)leaderEpochCache, producerStateManager, this.appendSemaphore$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.mockTime$1 = mockTime$1;
                this.appendSemaphore$1 = appendSemaphore$1;
                super($outer.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), $outer.brokerId(), (Time)$outer.time(), (IsrChangeListener)$outer.isrChangeListener(), $outer.delayedOperations(), $outer.metadataCache(), $outer.logManager(), (AlterIsrManager)$outer.alterIsrManager());
            }
        });
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Thread appendThread = new Thread(this){
            private final /* synthetic */ PartitionTest $outer;

            public void run() {
                MemoryRecords records = this.$outer.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 0L, this.$outer.createRecords$default$3());
                this.$outer.partition().appendRecordsToFollowerOrFutureReplica(records, false);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        appendThread.start();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!appendSemaphore.hasQueuedThreads()) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PartitionTest.$anonfun$testMakeFollowerWithWithFollowerAppendRecords$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(2).setLeaderEpoch(1).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
        appendSemaphore.release();
        appendThread.join();
        Assertions.assertEquals((long)2L, (long)this.partition().localLogOrException().logEndOffset());
        Assertions.assertEquals((long)2L, (long)BoxesRunTime.unboxToInt((Object)this.partition().leaderReplicaIdOpt().get()));
    }

    @Test
    public void testMaybeReplaceCurrentWithFutureReplicaDifferentBaseOffsets() {
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir1().getAbsolutePath());
        this.partition().createLogIfNotExists(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.logManager().maybeUpdatePreferredLogDir(this.topicPartition(), this.logDir2().getAbsolutePath());
        this.partition().maybeCreateFutureReplica(this.logDir2().getAbsolutePath(), this.offsetCheckpoints());
        UnifiedLog currentLog = (UnifiedLog)this.partition().log().get();
        currentLog.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k1".getBytes(), "v1".getBytes()), new SimpleRecord("k1".getBytes(), "v2".getBytes()), new SimpleRecord("k1".getBytes(), "v3".getBytes()), new SimpleRecord("k2".getBytes(), "v4".getBytes()), new SimpleRecord("k2".getBytes(), "v5".getBytes()), new SimpleRecord("k2".getBytes(), "v6".getBytes())}), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4(), currentLog.appendAsLeader$default$5());
        currentLog.roll(currentLog.roll$default$1());
        currentLog.appendAsLeader(MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(0), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("k3".getBytes(), "v7".getBytes()), new SimpleRecord("k4".getBytes(), "v8".getBytes())}), 0, currentLog.appendAsLeader$default$3(), currentLog.appendAsLeader$default$4(), currentLog.appendAsLeader$default$5());
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(1024), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.CREATE_TIME, (long)0L, (long)-1L, (int)0);
        builder.appendWithOffset(2L, new SimpleRecord("k1".getBytes(), "v3".getBytes()));
        builder.appendWithOffset(5L, new SimpleRecord("k2".getBytes(), "v6".getBytes()));
        builder.appendWithOffset(6L, new SimpleRecord("k3".getBytes(), "v7".getBytes()));
        builder.appendWithOffset(7L, new SimpleRecord("k4".getBytes(), "v8".getBytes()));
        this.partition().futureLocalLogOrException().appendAsFollower(builder.build());
        Assertions.assertTrue((boolean)this.partition().maybeReplaceCurrentWithFutureReplica());
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertSnapshotError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertSnapshotError$1(Errors.NONE, Optional.empty(), partition);
    }

    @Test
    public void testFetchOffsetSnapshotEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertSnapshotError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertLastOffsetForLeaderError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testOffsetForLeaderEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertLastOffsetForLeaderError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testReadRecordEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertReadRecordsError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertReadRecordsError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testReadRecordEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertReadRecordsError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForLeader() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, true);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.empty(), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), partition);
        PartitionTest.assertFetchOffsetError$1(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), partition);
    }

    @Test
    public void testFetchOffsetForTimestampEpochValidationForFollower() {
        int leaderEpoch = 5;
        Partition partition = this.setupPartitionWithMocks(leaderEpoch, false);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.empty(), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NONE, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), false, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.empty(), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.NOT_LEADER_OR_FOLLOWER, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.FENCED_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch - 1)), true, partition);
        PartitionTest.assertFetchOffsetError$2(Errors.UNKNOWN_LEADER_EPOCH, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch + 1)), true, partition);
    }

    @Test
    public void testFetchLatestOffsetIncludesLeaderEpoch() {
        int leaderEpoch = 5;
        Option timestampAndOffsetOpt = this.setupPartitionWithMocks(leaderEpoch, true).fetchOffsetForTimestamp(-1L, (Option)None$.MODULE$, Optional.empty(), true);
        Assertions.assertTrue((boolean)timestampAndOffsetOpt.isDefined());
        FileRecords.TimestampAndOffset timestampAndOffset = (FileRecords.TimestampAndOffset)timestampAndOffsetOpt.get();
        Assertions.assertEquals((int)leaderEpoch, (Integer)((Integer)timestampAndOffset.leaderEpoch.get()));
    }

    /*
     * Unable to fully structure code
     */
    @Test
    public void testMonotonicOffsetsAfterLeaderChange() {
        block51: {
            block53: {
                block52: {
                    block50: {
                        block47: {
                            block49: {
                                block48: {
                                    block46: {
                                        controllerEpoch = 3;
                                        leader = this.brokerId();
                                        follower1 = this.brokerId() + 1;
                                        follower2 = this.brokerId() + 2;
                                        replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2}));
                                        isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
                                        leaderEpoch = 8;
                                        batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord(10L, "k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(11L, "k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(20L, "k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord(21L, "k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
                                        leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)(), List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true);
                                        Assertions.assertTrue((boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected first makeLeader() to return 'leader changed'");
                                        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch(), (String)"Current leader epoch");
                                        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().isr(), (String)"ISR");
                                        requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
                                        this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
                                        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
                                        Assertions.assertEquals((long)this.partition().localLogOrException().logStartOffset(), (long)this.partition().localLogOrException().highWatermark(), (String)"Expected leader's HW not move");
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(2L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
                                        this.alterIsrManager().completeIsrUpdate(2);
                                        Assertions.assertEquals((long)2L, (long)this.partition().localLogOrException().highWatermark());
                                        var12_12 = false;
                                        var13_13 = null;
                                        var14_14 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                                        if (!(var14_14 instanceof Right)) ** GOTO lbl-1000
                                        var12_12 = true;
                                        var13_13 = (Right)var14_14;
                                        var15_15 = (Option)var13_13.value();
                                        if (var15_15 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var15_15).value();
                                            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                                        } else if (var12_12 && None$.MODULE$.equals(var17_17 = (Option)var13_13.value())) {
                                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                                        } else if (var14_14 instanceof Left) {
                                            (BoxedUnit)Assertions.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var14_14);
                                        }
                                        var18_18 = false;
                                        var19_19 = null;
                                        var20_20 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var20_20 instanceof Right)) ** GOTO lbl-1000
                                        var18_18 = true;
                                        var19_19 = (Right)var20_20;
                                        var21_21 = (Option)var19_19.value();
                                        if (var21_21 instanceof Some) {
                                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var21_21).value();
                                            Assertions.assertEquals((long)2L, (long)offsetAndTimestamp.offset);
                                        } else if (var18_18 && None$.MODULE$.equals(var23_23 = (Option)var19_19.value())) {
                                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                                        } else if (var20_20 instanceof Left) {
                                            (BoxedUnit)Assertions.fail((String)"Should not have seen an error");
                                        } else {
                                            throw new MatchError((Object)var20_20);
                                        }
                                        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(30L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
                                        followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(4).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)(), List$.MODULE$.canBuildFrom())).asJava()).setIsNew(false);
                                        Assertions.assertTrue((boolean)this.partition().makeFollower(followerState, this.offsetCheckpoints(), (Option)None$.MODULE$));
                                        newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(5).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(java.lang.Object ), (Ljava/lang/Object;)Ljava/lang/Integer;)(), List$.MODULE$.canBuildFrom())).asJava()).setIsNew(false);
                                        Assertions.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints(), (Option)None$.MODULE$));
                                        var26_26 = false;
                                        var27_27 = null;
                                        var28_28 = false;
                                        var29_29 = null;
                                        var30_30 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                                        if (!(var30_30 instanceof Right)) break block46;
                                        var26_26 = true;
                                        var27_27 = (Right)var30_30;
                                        if (!((Option)var27_27.value() instanceof Some)) break block46;
                                        (BoxedUnit)Assertions.fail((String)"Should have failed with OffsetNotAvailable");
                                        break block47;
                                    }
                                    if (!var26_26 || !None$.MODULE$.equals(var31_31 = (Option)var27_27.value())) break block48;
                                    (BoxedUnit)Assertions.fail((String)"Should have seen an error");
                                    break block47;
                                }
                                if (!(var30_30 instanceof Left)) break block49;
                                var28_28 = true;
                                var29_29 = (Left)var30_30;
                                if ((ApiException)var29_29.value() instanceof OffsetNotAvailableException) break block47;
                            }
                            if (var28_28 && (e = (ApiException)var29_29.value()) != null) {
                                (BoxedUnit)Assertions.fail((String)new StringBuilder(42).append("Expected OffsetNotAvailableException, got ").append(e).toString());
                            } else {
                                throw new MatchError((Object)var30_30);
                            }
                        }
                        var33_33 = false;
                        var34_34 = null;
                        var35_35 = this.fetchOffsetsForTimestamp$1(-1L, (Option)None$.MODULE$);
                        if (!(var35_35 instanceof Right)) ** GOTO lbl-1000
                        var33_33 = true;
                        var34_34 = (Right)var35_35;
                        var36_36 = (Option)var34_34.value();
                        if (var36_36 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var36_36).value();
                            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
                        } else if (var33_33 && None$.MODULE$.equals(var38_38 = (Option)var34_34.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var35_35 instanceof Left && (e = (ApiException)((Left)var35_35).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var35_35);
                        }
                        var40_40 = false;
                        var41_41 = null;
                        var42_42 = this.fetchOffsetsForTimestamp$1(-2L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var42_42 instanceof Right)) ** GOTO lbl-1000
                        var40_40 = true;
                        var41_41 = (Right)var42_42;
                        var43_43 = (Option)var41_41.value();
                        if (var43_43 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var43_43).value();
                            Assertions.assertEquals((long)0L, (long)offsetAndTimestamp.offset);
                        } else if (var40_40 && None$.MODULE$.equals(var45_45 = (Option)var41_41.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var42_42 instanceof Left && (e = (ApiException)((Left)var42_42).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var42_42);
                        }
                        var47_47 = false;
                        var48_48 = null;
                        var49_49 = this.fetchOffsetsForTimestamp$1(11L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var49_49 instanceof Right)) ** GOTO lbl-1000
                        var47_47 = true;
                        var48_48 = (Right)var49_49;
                        var50_50 = (Option)var48_48.value();
                        if (var50_50 instanceof Some) {
                            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var50_50).value();
                            Assertions.assertEquals((long)1L, (long)offsetAndTimestamp.offset);
                            Assertions.assertEquals((long)11L, (long)offsetAndTimestamp.timestamp);
                        } else if (var47_47 && None$.MODULE$.equals(var52_52 = (Option)var48_48.value())) {
                            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
                        } else if (var49_49 instanceof Left && (e = (ApiException)((Left)var49_49).value()) != null) {
                            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
                        } else {
                            throw new MatchError((Object)var49_49);
                        }
                        var54_54 = false;
                        var55_55 = null;
                        var56_56 = false;
                        var57_57 = null;
                        var58_58 = this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
                        if (!(var58_58 instanceof Right)) break block50;
                        var54_54 = true;
                        var55_55 = (Right)var58_58;
                        if (!((Option)var55_55.value() instanceof Some)) break block50;
                        (BoxedUnit)Assertions.fail((String)"Should have failed");
                        break block51;
                    }
                    if (!var54_54 || !None$.MODULE$.equals(var59_59 = (Option)var55_55.value())) break block52;
                    (BoxedUnit)Assertions.fail((String)"Should have failed");
                    break block51;
                }
                if (!(var58_58 instanceof Left)) break block53;
                var56_56 = true;
                var57_57 = (Left)var58_58;
                if ((ApiException)var57_57.value() instanceof OffsetNotAvailableException) break block51;
            }
            if (var56_56 && (e = (ApiException)var57_57.value()) != null) {
                (BoxedUnit)Assertions.fail((String)new StringBuilder(50).append("Should have seen OffsetNotAvailableException, saw ").append(e).toString());
            } else {
                throw new MatchError((Object)var58_58);
            }
        }
        this.updateFollowerFetchState$1(follower1, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$1(follower2, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.alterIsrManager().completeIsrUpdate(6);
        var61_61 = false;
        var62_62 = null;
        var63_63 = this.fetchOffsetsForTimestamp$1(-1L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED));
        if (!(var63_63 instanceof Right)) ** GOTO lbl-1000
        var61_61 = true;
        var62_62 = (Right)var63_63;
        var64_64 = (Option)var62_62.value();
        if (var64_64 instanceof Some) {
            offsetAndTimestamp = (FileRecords.TimestampAndOffset)((Some)var64_64).value();
            Assertions.assertEquals((long)5L, (long)offsetAndTimestamp.offset);
        } else if (var61_61 && None$.MODULE$.equals(var66_66 = (Option)var62_62.value())) {
            (BoxedUnit)Assertions.fail((String)"Should have seen some offsets");
        } else if (var63_63 instanceof Left && (e = (ApiException)((Left)var63_63).value()) != null) {
            (BoxedUnit)Assertions.fail((String)new StringBuilder(17).append("Got ApiException ").append(e).toString());
        } else {
            throw new MatchError((Object)var63_63);
        }
        Assertions.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.fetchOffsetsForTimestamp$1(100L, (Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)));
    }

    @Test
    public void testAppendRecordsAsFollowerBelowLogStartOffset() {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        UnifiedLog log = this.partition().localLogOrException();
        long initialLogStartOffset = 5L;
        this.partition().truncateFullyAndStartAt(initialLogStartOffset, false);
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logEndOffset(), (String)new StringBuilder(50).append("Log end offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString());
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logStartOffset(), (String)new StringBuilder(52).append("Log start offset after truncate fully and start at ").append(initialLogStartOffset).append(":").toString());
        Assertions.assertThrows(UnexpectedAppendOffsetException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 3L, this.createRecords$default$3()), false));
        Assertions.assertEquals((long)initialLogStartOffset, (long)log.logEndOffset(), (String)"Log end offset should not change after failure to append");
        long newLogStartOffset = 4L;
        MemoryRecords records = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), newLogStartOffset, this.createRecords$default$3());
        this.partition().appendRecordsToFollowerOrFutureReplica(records, false);
        Assertions.assertEquals((long)7L, (long)log.logEndOffset(), (String)new StringBuilder(59).append("Log end offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString());
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)new StringBuilder(61).append("Log start offset after append of 3 records with base offset ").append(newLogStartOffset).append(":").toString());
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 7L, this.createRecords$default$3()), false);
        Assertions.assertEquals((long)8L, (long)log.logEndOffset(), (String)"Log end offset after append of 1 record at offset 7:");
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)"Log start offset not expected to change:");
        MemoryRecords records2 = this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), 3L, this.createRecords$default$3());
        Assertions.assertThrows(UnexpectedAppendOffsetException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(records2, false));
        Assertions.assertEquals((long)8L, (long)log.logEndOffset(), (String)"Log end offset should not change after failure to append");
        this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 8L, this.createRecords$default$3()), false);
        Assertions.assertEquals((long)9L, (long)log.logEndOffset(), (String)"Log end offset after append of 1 record at offset 8:");
        Assertions.assertEquals((long)newLogStartOffset, (long)log.logStartOffset(), (String)"Log start offset not expected to change:");
    }

    @Test
    public void testListOffsetIsolationLevels() {
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        MemoryRecords records = this.createTransactionalRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), 0L);
        this.partition().appendRecordsToLeader(records, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, RequestLocal$.MODULE$.withThreadConfinedCaching());
        Assertions.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        ((UnifiedLog)this.partition().log().get()).updateHighWatermark(1L);
        Assertions.assertEquals((long)3L, (long)this.fetchLatestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)1L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchLatestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)None$.MODULE$).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_UNCOMMITTED)).offset);
        Assertions.assertEquals((long)0L, (long)this.fetchEarliestOffset$1((Option)new Some((Object)IsolationLevel.READ_COMMITTED)).offset);
    }

    @Test
    public void testGetReplica() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().log());
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.partition().localLogOrException());
    }

    @Test
    public void testAppendRecordsToFollowerWithNoReplicaThrowsException() {
        Assertions.assertThrows(NotLeaderOrFollowerException.class, () -> this.partition().appendRecordsToFollowerOrFutureReplica(this.createRecords((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)Nil$.MODULE$), 0L, this.createRecords$default$3()), false));
    }

    @Test
    public void testMakeFollowerWithNoLeaderIdChange() {
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(1).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
        partitionState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(0).setLeader(1).setLeaderEpoch(4).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava()).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(0), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(2), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$))))).asJava());
        Assertions.assertFalse((boolean)this.partition().makeFollower(partitionState, this.offsetCheckpoints(), (Option)None$.MODULE$));
    }

    @Test
    public void testFollowerDoesNotJoinISRUntilCaughtUpToOffsetWithinCurrentLeaderEpoch() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$))).asJava();
        int leaderEpoch = 8;
        MemoryRecords batch1 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k1".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k2".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch2 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k3".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k4".getBytes(), "v2".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k5".getBytes(), "v3".getBytes()), (List)Nil$.MODULE$))), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        MemoryRecords batch3 = TestUtils$.MODULE$.records((Iterable<SimpleRecord>)new .colon.colon((Object)new SimpleRecord("k6".getBytes(), "v1".getBytes()), (List)new .colon.colon((Object)new SimpleRecord("k7".getBytes(), "v2".getBytes()), (List)Nil$.MODULE$)), TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        Assertions.assertTrue((boolean)this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected first makeLeader() to return 'leader changed'");
        Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch(), (String)"Current leader epoch");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().isr(), (String)"ISR");
        RequestLocal requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        long lastOffsetOfFirstBatch = this.partition().appendRecordsToLeader(batch1, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal).lastOffset();
        this.partition().appendRecordsToLeader(batch2, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
        Assertions.assertEquals((long)this.partition().localLogOrException().logStartOffset(), (long)((UnifiedLog)this.partition().log().get()).highWatermark(), (String)"Expected leader's HW not move");
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$2(follower2, new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assertions.assertEquals((long)lastOffsetOfFirstBatch, (long)((UnifiedLog)this.partition().log().get()).highWatermark(), (String)"Expected leader's HW");
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState followerState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(follower2).setLeaderEpoch(leaderEpoch + 1).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(followerState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState newLeaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch + 2).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        Assertions.assertTrue((boolean)this.partition().makeLeader(newLeaderState, this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected makeLeader() to return 'leader changed' after makeFollower()");
        long currentLeaderEpochStartOffset = this.partition().localLogOrException().logEndOffset();
        this.partition().appendRecordsToLeader(batch3, (AppendOrigin)AppendOrigin.Client$.MODULE$, 0, requestLocal);
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(lastOffsetOfFirstBatch, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().isr(), (String)"ISR");
        this.updateFollowerFetchState$2(follower1, new LogOffsetMetadata(currentLeaderEpochStartOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().isr(), (String)"ISR");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(leader), Predef$.MODULE$.int2Integer(follower1), Predef$.MODULE$.int2Integer(follower2)})), (Object)this.partition().partitionState().maximalIsr(), (String)"ISR");
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr().toSet(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader, follower1, follower2})), (String)"AlterIsr");
    }

    public MemoryRecords createRecords(Iterable<SimpleRecord> records, long baseOffset, int partitionLeaderEpoch) {
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(records).asJava()))), (byte)2, (CompressionType)CompressionType.NONE, (TimestampType)TimestampType.LOG_APPEND_TIME, (long)baseOffset, (long)this.time().milliseconds(), (int)partitionLeaderEpoch);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    public int createRecords$default$3() {
        return 0;
    }

    public MemoryRecords createTransactionalRecords(Iterable<SimpleRecord> records, long baseOffset) {
        long producerId = 1L;
        short producerEpoch = (short)0;
        int baseSequence = 0;
        boolean isTransactional = true;
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)ByteBuffer.allocate(DefaultRecordBatch.sizeInBytes((java.lang.Iterable)((java.lang.Iterable)CollectionConverters$.MODULE$.asJavaIterableConverter(records).asJava()))), (CompressionType)CompressionType.NONE, (long)baseOffset, (long)producerId, (short)producerEpoch, (int)baseSequence, (boolean)isTransactional);
        records.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            builder.append(x$1);
            return BoxedUnit.UNIT;
        });
        return builder.build();
    }

    @Test
    public void testAtMinIsr() {
        int controllerEpoch = 3;
        int leader = this.brokerId();
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(follower2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(leader), (List)Nil$.MODULE$)).asJava();
        int leaderEpoch = 8;
        Assertions.assertFalse((boolean)this.partition().isAtMinIsr());
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().isAtMinIsr());
    }

    @Test
    public void testUpdateFollowerFetchState() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 6, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(500L);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(6L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((long)this.time().milliseconds(), (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)6L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
    }

    @Test
    public void testInvalidAlterPartitionRequestsAreNotRetried() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)1, (int)this.alterIsrManager().isrUpdates().size());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr().toSet());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_REQUEST);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)0, (int)this.alterIsrManager().isrUpdates().size());
        Assertions.assertEquals((int)0, (int)this.isrChangeListener().expands().get());
        Assertions.assertEquals((int)0, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)1, (int)this.isrChangeListener().failures().get());
    }

    @Test
    public void testIsrExpansion() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        List replicas = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$testIsrExpansion$1(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava()).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(3L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((long)3L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 6L);
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().completeIsrUpdate(2);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((int)this.isrChangeListener().expands().get(), (int)1);
        Assertions.assertEquals((int)this.isrChangeListener().shrinks().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().failures().get(), (int)0);
    }

    @Test
    public void testIsrNotExpandedIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(remoteBrokerId), (List)Nil$.MODULE$))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)Nil$.MODULE$)).asJava();
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_UPDATE_VERSION);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().expands().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().shrinks().get(), (int)0);
        Assertions.assertEquals((int)this.isrChangeListener().failures().get(), (int)1);
    }

    @Test
    public void testRetryShrinkIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Uuid topicId = Uuid.randomUuid();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)new Some((Object)topicId), controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 1, true, this.makeLeader$default$8()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        this.alterIsrManager().failIsrUpdate(Errors.NETWORK_EXCEPTION);
        Assertions.assertEquals((int)0, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)1, (int)this.isrChangeListener().failures().get());
        Assertions.assertEquals((int)1, (int)this.partition().getZkVersion());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.alterIsrManager().completeIsrUpdate(2);
        Assertions.assertEquals((int)1, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)2, (int)this.partition().getZkVersion());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)log.logEndOffset(), (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testMaybeShrinkIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 1, true, this.makeLeader$default$8()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((int)0, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((Object)((AlterIsrItem)this.alterIsrManager().isrUpdates().head()).leaderAndIsr().isr(), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.alterIsrManager().completeIsrUpdate(2);
        Assertions.assertEquals((int)1, (int)this.isrChangeListener().shrinks().get());
        Assertions.assertEquals((int)2, (int)this.partition().getZkVersion());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((long)log.logEndOffset(), (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAlterIsrLeaderAndIsrRace() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 1, true, this.makeLeader$default$8()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertTrue((boolean)this.partition().partitionState().isInflight());
        Assertions.assertFalse((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 2, false, this.makeLeader$default$8()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertFalse((boolean)this.partition().partitionState().isInflight(), (String)"ISR should be committed and not inflight");
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertFalse((boolean)this.partition().partitionState().isInflight(), (String)"ISR should still be committed and not inflight");
        this.alterIsrManager().completeIsrUpdate(10);
        this.partition().maybeShrinkIsr();
        Assertions.assertTrue((boolean)this.partition().partitionState().isInflight(), (String)"ISR should be pending a shrink");
    }

    @Test
    public void testShouldNotShrinkIsrIfPreviousFetchIsCaughtUp() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 1, true, this.makeLeader$default$8()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(5000L);
        long firstFetchTimeMs = this.time().milliseconds();
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, firstFetchTimeMs, 10L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)5L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)5L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(5001L);
        this.seedLogData(log, 5, leaderEpoch);
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 15L);
        Assertions.assertEquals((long)firstFetchTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    @Test
    public void testShouldNotShrinkIsrIfFollowerCaughtUpToLogEnd() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 1, true, this.makeLeader$default$8()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    @Test
    public void testIsrNotShrunkIfUpdateFails() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        long initializeTimeMs = this.time().milliseconds();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 1, true, this.makeLeader$default$8()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)initializeTimeMs, (long)remoteReplica.lastCaughtUpTimeMs());
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.time().sleep(30001L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.alterIsrManager().failIsrUpdate(Errors.INVALID_UPDATE_VERSION);
        Assertions.assertEquals(this.partition().partitionState().getClass(), PendingShrinkIsr.class);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)0);
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testAlterIsrUnknownTopic() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_TOPIC_OR_PARTITION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnknownTopic$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrInvalidVersion() {
        this.handleAlterIsrFailure(Errors.INVALID_UPDATE_VERSION, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrInvalidVersion$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testAlterIsrUnexpectedError() {
        this.handleAlterIsrFailure(Errors.UNKNOWN_SERVER_ERROR, (Function3<Object, Object, Partition, BoxedUnit>)(Function3 & Serializable & scala.Serializable)(brokerId, remoteBrokerId, partition) -> {
            PartitionTest.$anonfun$testAlterIsrUnexpectedError$1(this, BoxesRunTime.unboxToInt((Object)brokerId), BoxesRunTime.unboxToInt((Object)remoteBrokerId), partition);
            return BoxedUnit.UNIT;
        });
    }

    public void handleAlterIsrFailure(Errors error, Function3<Object, Object, Partition, BoxedUnit> callback) {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int remoteBrokerId = this.brokerId() + 1;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}));
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 1, true, this.makeLeader$default$8()));
        Assertions.assertEquals((long)10L, (long)this.partition().localLogOrException().highWatermark());
        Replica remoteReplica = (Replica)this.partition().getReplica(remoteBrokerId).get();
        Assertions.assertEquals((long)LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata().messageOffset(), (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)UnifiedLog$.MODULE$.UnknownOffset(), (long)remoteReplica.logStartOffset());
        this.partition().updateFollowerFetchState(remoteBrokerId, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), (Object)this.partition().inSyncReplicaIds());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), remoteBrokerId})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        Assertions.assertEquals((long)10L, (long)remoteReplica.logEndOffset());
        Assertions.assertEquals((long)0L, (long)remoteReplica.logStartOffset());
        this.alterIsrManager().failIsrUpdate(error);
        callback.apply((Object)BoxesRunTime.boxToInteger((int)this.brokerId()), (Object)BoxesRunTime.boxToInteger((int)remoteBrokerId), (Object)this.partition());
    }

    @Test
    public void testSingleInFlightAlterIsr() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2}));
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)None$.MODULE$, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, 1, true, this.makeLeader$default$8()));
        Assertions.assertEquals((long)0L, (long)this.partition().localLogOrException().highWatermark());
        this.partition().updateFollowerFetchState(follower3, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2})), (Object)this.partition().partitionState().isr());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)this.partition().partitionState().maximalIsr());
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
        this.time().sleep(this.partition().replicaLagTimeMaxMs() + 1L);
        this.partition().maybeShrinkIsr();
        Assertions.assertEquals((int)this.alterIsrManager().isrUpdates().size(), (int)1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testZkIsrManagerAsyncCallback() {
        KafkaScheduler scheduler = new KafkaScheduler(1, "zk-isr-test", KafkaScheduler$.MODULE$.$lessinit$greater$default$3());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$2 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        AlterIsrManager zkIsrManager = AlterIsrManager$.MODULE$.apply((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        Partition partition = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), (ApiVersion)KAFKA_2_6_IV0$.MODULE$, this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), zkIsrManager);
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$22 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$22);
        this.seedLogData(log, 10, 4);
        int controllerEpoch = 0;
        int leaderEpoch = 5;
        int follower1 = this.brokerId() + 1;
        int follower2 = this.brokerId() + 2;
        int follower3 = this.brokerId() + 3;
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3}));
        Seq isr = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2}));
        ((DelayedOperations)Mockito.doNothing().when((Object)this.delayedOperations())).checkAndCompleteAll();
        None$ x$6 = None$.MODULE$;
        int x$11 = 1;
        boolean x$12 = true;
        Assertions.assertTrue((boolean)this.makeLeader((Option<Uuid>)x$6, controllerEpoch, leaderEpoch, (Seq<Object>)isr, (Seq<Object>)replicas, x$11, x$12, partition));
        Assertions.assertEquals((long)0L, (long)partition.localLogOrException().highWatermark());
        partition.updateFollowerFetchState(follower3, new LogOffsetMetadata(10L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 0L, this.time().milliseconds(), 10L);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 100L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!PartitionTest.$anonfun$testZkIsrManagerAsyncCallback$2(partition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)PartitionTest.$anonfun$testZkIsrManagerAsyncCallback$3());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        PartitionState partitionState = partition.partitionState();
        if (partitionState instanceof CommittedPartitionState) {
            scala.collection.immutable.Set isr2 = ((CommittedPartitionState)partitionState).isr();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), follower1, follower2, follower3})), (Object)isr2);
        } else {
            BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)"Expected a committed ISR following Zk expansion");
        }
        scheduler.shutdown();
    }

    @Test
    public void testUseCheckpointToInitializeHighWatermark() {
        LogManager qual$1 = this.logManager();
        TopicPartition x$1 = this.topicPartition();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = qual$1.getOrCreateLog$default$2();
        boolean x$4 = qual$1.getOrCreateLog$default$3();
        UnifiedLog log = qual$1.getOrCreateLog(x$1, x$3, x$4, (Option)x$2);
        this.seedLogData(log, 6, 5);
        Mockito.when((Object)this.offsetCheckpoints().fetch(this.logDir1().getAbsolutePath(), this.topicPartition())).thenReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)4L)));
        int controllerEpoch = 3;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertEquals((long)4L, (long)this.partition().localLogOrException().highWatermark());
    }

    @Test
    public void testTopicIdAndPartitionMetadataFileForLeader() {
        int controllerEpoch = 3;
        int leaderEpoch = 5;
        Uuid topicId = Uuid.randomUuid();
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)topicId));
        this.checkTopicId(topicId, this.partition());
        Partition partition2 = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)this.alterIsrManager());
        Assertions.assertTrue((boolean)partition2.topicId().isDefined());
        Assertions.assertEquals((Object)topicId, (Object)partition2.topicId().get());
        Assertions.assertFalse((boolean)partition2.log().isDefined());
        Assertions.assertThrows(InconsistentTopicIdException.class, () -> partition2.makeLeader(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)Uuid.randomUuid())));
        partition2.makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.checkTopicId(topicId, partition2);
    }

    @Test
    public void testTopicIdAndPartitionMetadataFileForFollower() {
        int controllerEpoch = 3;
        int leaderEpoch = 5;
        Uuid topicId = Uuid.randomUuid();
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeFollower(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)topicId));
        this.checkTopicId(topicId, this.partition());
        Partition partition2 = new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterIsrManager)this.alterIsrManager());
        Assertions.assertTrue((boolean)partition2.topicId().isDefined());
        Assertions.assertEquals((Object)topicId, (Object)partition2.topicId().get());
        Assertions.assertFalse((boolean)partition2.log().isDefined());
        Assertions.assertThrows(InconsistentTopicIdException.class, () -> partition2.makeFollower(leaderState, this.offsetCheckpoints(), (Option)new Some((Object)Uuid.randomUuid())));
        partition2.makeFollower(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        this.checkTopicId(topicId, partition2);
    }

    public void checkTopicId(Uuid expectedTopicId, Partition partition) {
        Assertions.assertTrue((boolean)partition.topicId().isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)partition.topicId().get());
        Assertions.assertTrue((boolean)partition.log().isDefined());
        UnifiedLog log = (UnifiedLog)partition.log().get();
        Assertions.assertEquals((Object)expectedTopicId, (Object)log.topicId().get());
        Assertions.assertTrue((boolean)log.partitionMetadataFile().exists());
        Assertions.assertEquals((Object)expectedTopicId, (Object)log.partitionMetadataFile().read().topicId());
    }

    @Test
    public void testAddAndRemoveMetrics() {
        Assertions.assertTrue((boolean)new .colon.colon((Object)"UnderReplicated", (List)new .colon.colon((Object)"UnderMinIsr", (List)new .colon.colon((Object)"InSyncReplicasCount", (List)new .colon.colon((Object)"ReplicasCount", (List)new .colon.colon((Object)"LastStableOffsetLag", (List)new .colon.colon((Object)"AtMinIsr", (List)Nil$.MODULE$)))))).forall((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$3(x$4))));
        Partition$.MODULE$.removeMetrics(this.topicPartition());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).keySet().filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$4(x$5))));
    }

    @Test
    public void testUnderReplicatedPartitionsCorrectSemantics() {
        int controllerEpoch = 3;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 2), (List)Nil$.MODULE$)))).asJava();
        java.util.List isr = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId() + 1), (List)Nil$.MODULE$))).asJava();
        LeaderAndIsrRequestData.LeaderAndIsrPartitionState leaderState = new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(6).setIsr(isr).setZkVersion(1).setReplicas(replicas).setIsNew(false);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertTrue((boolean)this.partition().isUnderReplicated());
        leaderState = leaderState.setIsr(replicas);
        this.partition().makeLeader(leaderState, this.offsetCheckpoints(), (Option)None$.MODULE$);
        Assertions.assertFalse((boolean)this.partition().isUnderReplicated());
    }

    @Test
    public void testUpdateAssignmentAndIsr() {
        TopicPartition topicPartition = new TopicPartition("test", 1);
        Partition partition = new Partition(topicPartition, 1000L, ApiVersion$.MODULE$.latestVersion(), 0, (Time)new SystemTime(), (IsrChangeListener)Mockito.mock(IsrChangeListener.class), (DelayedOperations)Mockito.mock(DelayedOperations.class), (MetadataCache)Mockito.mock(MetadataCache.class), (LogManager)Mockito.mock(LogManager.class), (AlterIsrManager)Mockito.mock(AlterIsrManager.class));
        Seq replicas = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        scala.collection.immutable.Set isr = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}));
        Seq adding = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{4, 5}));
        Seq removing = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}));
        partition.updateAssignmentAndIsr(replicas, isr, adding, removing, LeaderRecoveryState.RECOVERED);
        Assertions.assertTrue((boolean)(partition.assignmentState() instanceof OngoingReassignmentState), (String)"The assignmentState is not OngoingReassignmentState");
        Assertions.assertEquals((Object)replicas, (Object)partition.assignmentState().replicas());
        Assertions.assertEquals((Object)isr, (Object)partition.partitionState().isr());
        Assertions.assertEquals((Object)adding, (Object)((OngoingReassignmentState)partition.assignmentState()).addingReplicas());
        Assertions.assertEquals((Object)removing, (Object)((OngoingReassignmentState)partition.assignmentState()).removingReplicas());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)partition.remoteReplicas().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()), Iterable$.MODULE$.canBuildFrom()));
        Seq replicas2 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        scala.collection.immutable.Set isr2 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 4, 5}));
        partition.updateAssignmentAndIsr(replicas2, isr2, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, LeaderRecoveryState.RECOVERED);
        Assertions.assertTrue((boolean)(partition.assignmentState() instanceof SimpleAssignmentState), (String)"The assignmentState is not SimpleAssignmentState");
        Assertions.assertEquals((Object)replicas2, (Object)partition.assignmentState().replicas());
        Assertions.assertEquals((Object)isr2, (Object)partition.partitionState().isr());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4, 5})), (Object)partition.remoteReplicas().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()), Iterable$.MODULE$.canBuildFrom()));
    }

    @Test
    public void testLogConfigNotDirty() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), this.logConfig(), spyConfigRepository, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$9), this.time(), TestUtils$.MODULE$.createLogManager$default$6()));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)1))).topicConfig(this.topicPartition().topic());
    }

    @Test
    public void testLogConfigDirtyAsTopicUpdated() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$82 = CleanerConfig$.MODULE$.apply$default$7();
        String x$9 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), this.logConfig(), spyConfigRepository, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$82, x$1, x$9), this.time(), TestUtils$.MODULE$.createLogManager$default$6()));
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(x$8 -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsTopicUpdated$1(this, x$8);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)2))).topicConfig(this.topicPartition().topic());
    }

    @Test
    public void testLogConfigDirtyAsBrokerUpdated() {
        this.logManager().shutdown();
        MockConfigRepository spyConfigRepository = (MockConfigRepository)Mockito.spy((Object)this.configRepository());
        boolean x$1 = false;
        int x$2 = CleanerConfig$.MODULE$.apply$default$1();
        long x$3 = CleanerConfig$.MODULE$.apply$default$2();
        double x$4 = CleanerConfig$.MODULE$.apply$default$3();
        int x$5 = CleanerConfig$.MODULE$.apply$default$4();
        int x$6 = CleanerConfig$.MODULE$.apply$default$5();
        double x$7 = CleanerConfig$.MODULE$.apply$default$6();
        long x$8 = CleanerConfig$.MODULE$.apply$default$7();
        String x$92 = CleanerConfig$.MODULE$.apply$default$9();
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), this.logConfig(), spyConfigRepository, new CleanerConfig(x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$1, x$92), this.time(), TestUtils$.MODULE$.createLogManager$default$6()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        LogManager spyLogManager = (LogManager)Mockito.spy((Object)this.logManager());
        ((LogManager)Mockito.doAnswer(x$9 -> {
            PartitionTest.$anonfun$testLogConfigDirtyAsBrokerUpdated$1(this, x$9);
            return BoxedUnit.UNIT;
        }).when((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), ApiVersion$.MODULE$.latestVersion(), this.brokerId(), (Time)this.time(), (IsrChangeListener)this.isrChangeListener(), this.delayedOperations(), this.metadataCache(), spyLogManager, (AlterIsrManager)this.alterIsrManager()).createLog(true, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        ((LogManager)Mockito.verify((Object)spyLogManager)).initializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()));
        ((LogManager)Mockito.verify((Object)spyLogManager)).finishedInitializingLog((TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()), (Option)ArgumentMatchers.any());
        ((ConfigRepository)Mockito.verify((Object)spyConfigRepository, (VerificationMode)Mockito.times((int)2))).topicConfig(this.topicPartition().topic());
    }

    private boolean makeLeader(Option<Uuid> topicId, int controllerEpoch, int leaderEpoch, Seq<Object> isr, Seq<Object> replicas, int zkVersion, boolean isNew, Partition partition) {
        partition.createLogIfNotExists(isNew, false, this.offsetCheckpoints(), topicId);
        boolean newLeader = partition.makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)isr.map((Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$makeLeader$1(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava()).setZkVersion(zkVersion).setReplicas((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)replicas.map((Function1 & Serializable & scala.Serializable)x -> PartitionTest.$anonfun$makeLeader$2(BoxesRunTime.unboxToInt((Object)x)), Seq$.MODULE$.canBuildFrom())).asJava()).setIsNew(isNew), this.offsetCheckpoints(), topicId);
        Assertions.assertTrue((boolean)partition.isLeader());
        Assertions.assertFalse((boolean)partition.partitionState().isInflight());
        Assertions.assertEquals(topicId, (Object)partition.topicId());
        Assertions.assertEquals((int)leaderEpoch, (int)partition.getLeaderEpoch());
        Assertions.assertEquals((Object)isr.toSet(), (Object)partition.partitionState().isr());
        Assertions.assertEquals((Object)isr.toSet(), (Object)partition.partitionState().maximalIsr());
        Assertions.assertEquals((int)zkVersion, (int)partition.getZkVersion());
        return newLeader;
    }

    private Partition makeLeader$default$8() {
        return this.partition();
    }

    private void seedLogData(UnifiedLog log, int numRecords, int leaderEpoch) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)i -> PartitionTest.$anonfun$seedLogData$1(leaderEpoch, log, BoxesRunTime.unboxToInt((Object)i)));
    }

    public static final /* synthetic */ SimpleRecord $anonfun$testLastFetchedOffsetValidation$1(int i) {
        return new SimpleRecord(String.valueOf(BoxesRunTime.boxToInteger((int)i)).getBytes());
    }

    private static final void append$1(int leaderEpoch, int count, UnifiedLog log$1) {
        IndexedSeq recordArray = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), count).map((Function1 & Serializable & scala.Serializable)i -> PartitionTest.$anonfun$testLastFetchedOffsetValidation$1(BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch), (SimpleRecord[])((SimpleRecord[])recordArray.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        log$1.appendAsLeader(records, leaderEpoch, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
    }

    private static final FetchResponseData.EpochEndOffset epochEndOffset$1(int epoch, long endOffset) {
        return new FetchResponseData.EpochEndOffset().setEpoch(epoch).setEndOffset(endOffset);
    }

    private static final LogReadInfo read$1(int lastFetchedEpoch, long fetchOffset, Partition partition$1, int leaderEpoch$1) {
        return partition$1.readRecords(Optional.of(Predef$.MODULE$.int2Integer(lastFetchedEpoch)), fetchOffset, Optional.of(Predef$.MODULE$.int2Integer(leaderEpoch$1)), Integer.MAX_VALUE, (FetchIsolation)FetchLogEnd$.MODULE$, true, true);
    }

    private static final void assertDivergence$1(FetchResponseData.EpochEndOffset divergingEpoch, LogReadInfo readInfo) {
        Assertions.assertEquals((Object)new Some((Object)divergingEpoch), (Object)readInfo.divergingEpoch());
        Assertions.assertEquals((int)0, (int)readInfo.fetchedData().records().sizeInBytes());
    }

    private static final void assertNoDivergence$1(LogReadInfo readInfo) {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)readInfo.divergingEpoch());
    }

    public static final /* synthetic */ String $anonfun$testMakeFollowerWithWithFollowerAppendRecords$2() {
        return "follower log append is not called.";
    }

    private static final void assertSnapshotError$1(Errors expectedError, Optional currentLeaderEpoch, Partition partition$2) {
        try {
            partition$2.fetchOffsetSnapshot(currentLeaderEpoch, true);
            Assertions.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assertions.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertSnapshotError$2(Errors expectedError, Optional currentLeaderEpoch, boolean fetchOnlyLeader, Partition partition$3) {
        try {
            partition$3.fetchOffsetSnapshot(currentLeaderEpoch, fetchOnlyLeader);
            Assertions.assertEquals((Object)Errors.NONE, (Object)expectedError);
            return;
        }
        catch (ApiException error) {
            Assertions.assertEquals((Object)expectedError, (Object)Errors.forException((Throwable)error));
            return;
        }
    }

    private static final void assertLastOffsetForLeaderError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$4) {
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = partition$4.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, true);
        Assertions.assertEquals((short)error.code(), (short)endOffset.errorCode());
    }

    private static final void assertLastOffsetForLeaderError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$5) {
        OffsetForLeaderEpochResponseData.EpochEndOffset endOffset = partition$5.lastOffsetForLeaderEpoch(currentLeaderEpochOpt, 0, fetchOnlyLeader);
        Assertions.assertEquals((short)error.code(), (short)endOffset.errorCode());
    }

    private static final void assertReadRecordsError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$6) {
        try {
            partition$6.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, true, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertReadRecordsError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$7) {
        try {
            partition$7.readRecords(Optional.empty(), 0L, currentLeaderEpochOpt, 1024, (FetchIsolation)FetchLogEnd$.MODULE$, fetchOnlyLeader, false);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$1(Errors error, Optional currentLeaderEpochOpt, Partition partition$8) {
        try {
            partition$8.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, true);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    private static final void assertFetchOffsetError$2(Errors error, Optional currentLeaderEpochOpt, boolean fetchOnlyLeader, Partition partition$9) {
        try {
            partition$9.fetchOffsetForTimestamp(0L, (Option)None$.MODULE$, currentLeaderEpochOpt, fetchOnlyLeader);
            Errors errors = error;
            Errors errors2 = Errors.NONE;
            if (errors == null ? errors2 != null : !errors.equals(errors2)) {
                Assertions.fail((String)new StringBuilder(40).append("Expected readRecords to fail with error ").append(error).toString());
            }
        }
        catch (Exception e) {
            Assertions.assertEquals((Object)error, (Object)Errors.forException((Throwable)e));
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final void updateFollowerFetchState$1(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    private final Either fetchOffsetsForTimestamp$1(long timestamp, Option isolation) {
        try {
            return package$.MODULE$.Right().apply((Object)this.partition().fetchOffsetForTimestamp(timestamp, isolation, Optional.of(Predef$.MODULE$.int2Integer(this.partition().getLeaderEpoch())), true));
        }
        catch (ApiException e) {
            return package$.MODULE$.Left().apply((Object)e);
        }
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    private final FileRecords.TimestampAndOffset fetchLatestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-1L, isolationLevel, Optional.empty(), true);
        Assertions.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final FileRecords.TimestampAndOffset fetchEarliestOffset$1(Option isolationLevel) {
        Option res = this.partition().fetchOffsetForTimestamp(-2L, isolationLevel, Optional.empty(), true);
        Assertions.assertTrue((boolean)res.isDefined());
        return (FileRecords.TimestampAndOffset)res.get();
    }

    private final void updateFollowerFetchState$2(int followerId, LogOffsetMetadata fetchOffsetMetadata) {
        this.partition().updateFollowerFetchState(followerId, fetchOffsetMetadata, 0L, this.time().milliseconds(), this.partition().localLogOrException().logEndOffset());
    }

    public static final /* synthetic */ Integer $anonfun$testIsrExpansion$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrUnknownTopic$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.partitionState().isr(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.partitionState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrInvalidVersion$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.partitionState().isr(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.partitionState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)0);
    }

    public static final /* synthetic */ void $anonfun$testAlterIsrUnexpectedError$1(PartitionTest $this, int brokerId, int remoteBrokerId, Partition partition) {
        Assertions.assertEquals((Object)partition.partitionState().isr(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId})));
        Assertions.assertEquals((Object)partition.partitionState().maximalIsr(), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{brokerId, remoteBrokerId})));
        Assertions.assertEquals((int)$this.alterIsrManager().isrUpdates().size(), (int)1);
    }

    public static final /* synthetic */ boolean $anonfun$testZkIsrManagerAsyncCallback$2(Partition partition$10) {
        return !partition$10.partitionState().isInflight();
    }

    public static final /* synthetic */ String $anonfun$testZkIsrManagerAsyncCallback$3() {
        return "Expected ISR state to be committed";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$1(String metric$1, Tuple2 x0$1) {
        if (x0$1 == null) throw new MatchError(null);
        MetricName metricName = (MetricName)x0$1._1();
        String string = metricName.getName();
        if (string == null) {
            if (metric$1 != null) {
                return false;
            }
        } else if (!string.equals(metric$1)) return false;
        String string2 = metricName.getType();
        String string3 = "Partition";
        if (string2 == null) return false;
        if (!string2.equals(string3)) return false;
        return true;
    }

    private static final Option getMetric$1(String metric) {
        return ((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionTest.$anonfun$testAddAndRemoveMetrics$1(metric, x0$1)))).headOption().map((Function1 & Serializable & scala.Serializable)x$3 -> (Metric)x$3._2());
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$3(String x$4) {
        return PartitionTest.getMetric$1(x$4).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$testAddAndRemoveMetrics$4(MetricName x$5) {
        String string = x$5.getType();
        String string2 = "Partition";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsTopicUpdated$1(PartitionTest $this, InvocationOnMock x$8) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().topicConfigUpdated($this.topicPartition().topic());
    }

    public static final /* synthetic */ void $anonfun$testLogConfigDirtyAsBrokerUpdated$1(PartitionTest $this, InvocationOnMock x$9) {
        $this.logManager().initializingLog($this.topicPartition());
        $this.logManager().brokerConfigUpdated();
    }

    public static final /* synthetic */ Integer $anonfun$makeLeader$1(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ Integer $anonfun$makeLeader$2(int x) {
        return BoxesRunTime.boxToInteger((int)x);
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$seedLogData$1(int leaderEpoch$2, UnifiedLog log$2, int i) {
        MemoryRecords records = MemoryRecords.withRecords((long)0L, (CompressionType)CompressionType.NONE, (Integer)Predef$.MODULE$.int2Integer(leaderEpoch$2), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(1).append("k").append(i).toString().getBytes(), new StringBuilder(1).append("v").append(i).toString().getBytes())});
        return log$2.appendAsLeader(records, leaderEpoch$2, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5());
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$1$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$1(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$2$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$2(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ Integer $anonfun$testMonotonicOffsetsAfterLeaderChange$3$adapted(Object x) {
        return PartitionTest.$anonfun$testMonotonicOffsetsAfterLeaderChange$3(BoxesRunTime.unboxToInt((Object)x));
    }

    private class SlowLog
    extends UnifiedLog {
        private final Semaphore appendSemaphore;
        public final /* synthetic */ PartitionTest $outer;

        public LogAppendInfo appendAsFollower(MemoryRecords records) {
            this.appendSemaphore.acquire();
            return super.appendAsFollower(records);
        }

        public /* synthetic */ PartitionTest kafka$cluster$PartitionTest$SlowLog$$$outer() {
            return this.$outer;
        }

        public SlowLog(PartitionTest $outer, UnifiedLog log, long logStartOffset, LocalLog localLog, Option<LeaderEpochFileCache> leaderEpochCache, ProducerStateManager producerStateManager, Semaphore appendSemaphore) {
            this.appendSemaphore = appendSemaphore;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(logStartOffset, localLog, new BrokerTopicStats(), log.producerIdExpirationCheckIntervalMs(), leaderEpochCache, producerStateManager, (Option)None$.MODULE$, true);
        }
    }
}

