/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.AbstractControllerBrokerRequestBatch;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaAssignment;
import kafka.controller.ReplicaAssignment$;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine;
import kafka.controller.StateChangeLogger;
import kafka.controller.ZkReplicaStateMachine;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.TopicPartitionStateZNode$;
import kafka.zookeeper.GetDataResponse;
import kafka.zookeeper.ResponseMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B'O\u0001MCQA\u0017\u0001\u0005\u0002mCqA\u0018\u0001A\u0002\u0013%q\fC\u0004d\u0001\u0001\u0007I\u0011\u00023\t\r)\u0004\u0001\u0015)\u0003a\u0011\u001dY\u0007\u00011A\u0005\n1Dqa\u001d\u0001A\u0002\u0013%A\u000f\u0003\u0004w\u0001\u0001\u0006K!\u001c\u0005\bo\u0002\u0001\r\u0011\"\u0003y\u0011\u001da\b\u00011A\u0005\nuDaa \u0001!B\u0013I\b\"CA\u0001\u0001\u0001\u0007I\u0011BA\u0002\u0011%\tY\u0001\u0001a\u0001\n\u0013\ti\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0015BA\u0003\u0011%\t\u0019\u0002\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u0002\u001e\u0001\u0001\u000b\u0011BA\f\u0011%\ty\u0002\u0001b\u0001\n\u0013\t\t\u0003\u0003\u0005\u00020\u0001\u0001\u000b\u0011BA\u0012\u0011%\t\t\u0004\u0001b\u0001\n\u0013\t)\u0002\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\f\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\u001d\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t\u0019\u0006\u0003\u0005\u0002b\u0001\u0001\u000b\u0011BA+\u0011%\t\u0019\u0007\u0001b\u0001\n\u0013\t)\u0007\u0003\u0005\u0002n\u0001\u0001\u000b\u0011BA4\u0011%\ty\u0007\u0001b\u0001\n\u0013\t\t\b\u0003\u0005\u0002v\u0001\u0001\u000b\u0011BA:\u0011\u001d\t9\b\u0001C\u0001\u0003sBq!!%\u0001\t\u0013\t\u0019\nC\u0004\u0002\u001e\u0002!\t!!\u001f\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002z!9\u00111\u0016\u0001\u0005\u0002\u0005e\u0004bBAX\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003g\u0003A\u0011AA=\u0011\u001d\t9\f\u0001C\u0001\u0003sBq!a/\u0001\t\u0003\tI\bC\u0004\u0002@\u0002!\t!!\u001f\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002z!9\u0011q\u0019\u0001\u0005\u0002\u0005e\u0004bBAf\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003\u001f\u0004A\u0011AA=\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003sBq!a6\u0001\t\u0003\tI\bC\u0004\u0002\\\u0002!\t!!\u001f\t\u000f\u0005}\u0007\u0001\"\u0001\u0002z!9\u00111\u001d\u0001\u0005\u0002\u0005e\u0004bBAt\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003W\u0004A\u0011AA=\u0011\u001d\ty\u000f\u0001C\u0001\u0003sBq!a=\u0001\t\u0003\tI\bC\u0004\u0002x\u0002!\t!!\u001f\t\u000f\u0005m\b\u0001\"\u0001\u0002z!9\u0011q \u0001\u0005\u0002\u0005e\u0004b\u0002B\u0002\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0005\u000f\u0001A\u0011AA=\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003sBqAa\u0004\u0001\t\u0003\tI\bC\u0004\u0003\u0014\u0001!\t!!\u001f\t\u000f\t]\u0001\u0001\"\u0001\u0002z!9!1\u0004\u0001\u0005\u0002\u0005e\u0004b\u0002B\u0010\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0005G\u0001A\u0011AA=\u0011\u001d\u00119\u0003\u0001C\u0001\u0003sBqAa\u000b\u0001\t\u0003\tI\bC\u0004\u00030\u0001!\t!!\u001f\t\u000f\tM\u0002\u0001\"\u0001\u0002z!9!q\u0007\u0001\u0005\u0002\u0005e\u0004b\u0002B\u001e\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0005\u007f\u0001A\u0011AA=\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0003sBqAa\u0012\u0001\t\u0003\tI\bC\u0004\u0003L\u0001!\t!!\u001f\t\u000f\t=\u0003\u0001\"\u0001\u0002z!9!1\u000b\u0001\u0005\u0002\u0005e\u0004b\u0002B,\u0001\u0011%!\u0011\f\u0005\b\u0005G\u0002A\u0011\u0002B3\u0005]\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f)\u0016\u001cHO\u0003\u0002P!\u0006Q1m\u001c8ue>dG.\u001a:\u000b\u0003E\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001)B\u0011Q\u000bW\u0007\u0002-*\tq+A\u0003tG\u0006d\u0017-\u0003\u0002Z-\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001/\u0011\u0005u\u0003Q\"\u0001(\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001a!\ti\u0016-\u0003\u0002c\u001d\n\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0002+\r|g\u000e\u001e:pY2,'oQ8oi\u0016DHo\u0018\u0013fcR\u0011Q\r\u001b\t\u0003+\u001aL!a\u001a,\u0003\tUs\u0017\u000e\u001e\u0005\bS\u000e\t\t\u00111\u0001a\u0003\rAH%M\u0001\u0013G>tGO]8mY\u0016\u00148i\u001c8uKb$\b%\u0001\u0007n_\u000e\\'l[\"mS\u0016tG/F\u0001n!\tq\u0017/D\u0001p\u0015\t\u0001\b+\u0001\u0002{W&\u0011!o\u001c\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002!5|7m\u001b.l\u00072LWM\u001c;`I\u0015\fHCA3v\u0011\u001dIg!!AA\u00025\fQ\"\\8dWj[7\t\\5f]R\u0004\u0013\u0001I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\",\u0012!\u001f\t\u0003;jL!a\u001f(\u00039\r{g\u000e\u001e:pY2,'O\u0011:pW\u0016\u0014(+Z9vKN$()\u0019;dQ\u0006!Sn\\2l\u0007>tGO]8mY\u0016\u0014(I]8lKJ\u0014V-];fgR\u0014\u0015\r^2i?\u0012*\u0017\u000f\u0006\u0002f}\"9\u0011.CA\u0001\u0002\u0004I\u0018!I7pG.\u001cuN\u001c;s_2dWM\u001d\"s_.,'OU3rk\u0016\u001cHOQ1uG\"\u0004\u0013a\u0005:fa2L7-Y*uCR,W*Y2iS:,WCAA\u0003!\ri\u0016qA\u0005\u0004\u0003\u0013q%a\u0005*fa2L7-Y*uCR,W*Y2iS:,\u0017a\u0006:fa2L7-Y*uCR,W*Y2iS:,w\fJ3r)\r)\u0017q\u0002\u0005\tS2\t\t\u00111\u0001\u0002\u0006\u0005!\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oK\u0002\n\u0001B\u0019:pW\u0016\u0014\u0018\nZ\u000b\u0003\u0003/\u00012!VA\r\u0013\r\tYB\u0016\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003\u0019\u0019wN\u001c4jOV\u0011\u00111\u0005\t\u0005\u0003K\tY#\u0004\u0002\u0002()\u0019\u0011\u0011\u0006)\u0002\rM,'O^3s\u0013\u0011\ti#a\n\u0003\u0017-\u000bgm[1D_:4\u0017nZ\u0001\bG>tg-[4!\u0003=\u0019wN\u001c;s_2dWM]#q_\u000eD\u0017\u0001E2p]R\u0014x\u000e\u001c7fe\u0016\u0003xn\u00195!\u0003%\u0001\u0018M\u001d;ji&|g.\u0006\u0002\u0002:A!\u00111HA&\u001b\t\tiD\u0003\u0003\u0002@\u0005\u0005\u0013AB2p[6|gNC\u0002R\u0003\u0007RA!!\u0012\u0002H\u00051\u0011\r]1dQ\u0016T!!!\u0013\u0002\u0007=\u0014x-\u0003\u0003\u0002N\u0005u\"A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u000ba\u0006\u0014H/\u001b;j_:\u0004\u0013A\u00039beRLG/[8ogV\u0011\u0011Q\u000b\t\u0007\u0003/\ni&!\u000f\u000e\u0005\u0005e#bAA.-\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005}\u0013\u0011\f\u0002\u0004'\u0016\f\u0018a\u00039beRLG/[8og\u0002\nqA]3qY&\u001c\u0017-\u0006\u0002\u0002hA\u0019Q,!\u001b\n\u0007\u0005-dJA\nQCJ$\u0018\u000e^5p]\u0006sGMU3qY&\u001c\u0017-\u0001\u0005sKBd\u0017nY1!\u0003!\u0011X\r\u001d7jG\u0006\u001cXCAA:!\u0019\t9&!\u0018\u0002h\u0005I!/\u001a9mS\u000e\f7\u000fI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002K\"\u001aA$! \u0011\t\u0005}\u0014QR\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006\u0019\u0011\r]5\u000b\t\u0005\u001d\u0015\u0011R\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\tY)a\u0012\u0002\u000b),h.\u001b;\n\t\u0005=\u0015\u0011\u0011\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001\u0004:fa2L7-Y*uCR,G\u0003BAK\u00037\u00032!XAL\u0013\r\tIJ\u0014\u0002\r%\u0016\u0004H.[2b'R\fG/\u001a\u0005\b\u0003Gj\u0002\u0019AA4\u0003i!Xm\u001d;Ti\u0006\u0014H/\u001e9P]2Lg.\u001a)beRLG/[8oQ\rq\u0012\u0011\u0015\t\u0005\u0003\u007f\n\u0019+\u0003\u0003\u0002&\u0006\u0005%\u0001\u0002+fgR\f1\u0004^3tiN#\u0018M\u001d;va>3g\r\\5oKB\u000b'\u000f^5uS>t\u0007fA\u0010\u0002\"\u0006\u0019C/Z:u'R\f'\u000f^;q/&$\bNU3qY&\u001c\u0017mV5uQ>,H\u000fT3bI\u0016\u0014\bf\u0001\u0011\u0002\"\u0006aC/Z:u\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\rV8OK^\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004C\u0005\u0005\u0016A\u000e;fgRLeN^1mS\u0012tuN\\3ySN$XM\u001c;SKBd\u0017nY1U_>sG.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001\u0012\u0002\"\u00069D/Z:u\u0013:4\u0018\r\\5e\u001d>tW\r_5ti\u0016tGOU3qY&\u001c\u0017\rV8PM\u001ad\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3aIAQ\u0003}\"Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3Ue\u0006t7/\u001b;j_:D3\u0001JAQ\u0003\t#Xm\u001d;J]Z\fG.\u001b3O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0004K\u0005\u0005\u0016A\u0011;fgRLeN^1mS\u0012tuN\\3ySN$XM\u001c;SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aa%!)\u0002gQ,7\u000f^%om\u0006d\u0017\u000e\u001a(foJ+\u0007\u000f\\5dCR{gj\u001c8fq&\u001cH/\u001a8u%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007fA\u0014\u0002\"\u00069C/Z:u\u001d\u0016<(+\u001a9mS\u000e\fGk\\(oY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\rA\u0013\u0011U\u0001)i\u0016\u001cHOT3x%\u0016\u0004H.[2b)>|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004S\u0005\u0005\u0016a\u000e;fgRLeN^1mS\u0012tUm\u001e*fa2L7-\u0019+p%\u0016\u0004H.[2b\t\u0016dW\r^5p]N#\u0018M\u001d;fIR\u0013\u0018M\\:ji&|g\u000eK\u0002+\u0003C\u000b!\b^3ti&sg/\u00197jI:+wOU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o\u0013:,G.[4jE2,GK]1og&$\u0018n\u001c8)\u0007-\n\t+\u0001\u001euKN$\u0018J\u001c<bY&$g*Z<SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]\"\u001aA&!)\u0002mQ,7\u000f^%om\u0006d\u0017\u000eZ(oY&tWMU3qY&\u001c\u0017\rV8O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u00075\n\t+\u0001\u0018uKN$\u0018J\u001c<bY&$wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007f\u0001\u0018\u0002\"\u0006QC/Z:u\u001f:d\u0017N\\3SKBd\u0017nY1U_>sG.\u001b8f%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007fA\u0018\u0002\"\u0006YC/Z:u\u001f:d\u0017N\\3SKBd\u0017nY1U_>3g\r\\5oKJ+\u0007\u000f\\5dCR\u0013\u0018M\\:ji&|g\u000eK\u00021\u0003C\u000b!\b^3ti&sg/\u00197jI>sG.\u001b8f%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$GK]1og&$\u0018n\u001c8)\u0007E\n\t+A\u001fuKN$\u0018J\u001c<bY&$wJ\u001c7j]\u0016\u0014V\r\u001d7jG\u0006$vNU3qY&\u001c\u0017\rR3mKRLwN\\%oK2Lw-\u001b2mKR\u0013\u0018M\\:ji&|g\u000eK\u00023\u0003C\u000bQ\b^3ti&sg/\u00197jI>sG.\u001b8f%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:D3aMAQ\u0003]\"Xm\u001d;J]Z\fG.\u001b3PM\u001ad\u0017N\\3SKBd\u0017nY1U_:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001aA'!)\u0002_Q,7\u000f^%om\u0006d\u0017\u000eZ(gM2Lg.\u001a*fa2L7-\u0019+p\u001d\u0016<(+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007U\n\t+A\u0016uKN$xJ\u001a4mS:,'+\u001a9mS\u000e\fGk\\(oY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r1\u0014\u0011U\u00015i\u0016\u001cHo\u00144gY&tWMU3qY&\u001c\u0017\rV8SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)J\fgn]5uS>t\u0007fA\u001c\u0002\"\u00069D/Z:u\u001f\u001a4G.\u001b8f%\u0016\u0004H.[2b)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t\u0017J\\3mS\u001eL'\r\\3Ue\u0006t7/\u001b;j_:D3\u0001OAQ\u0003y\"Xm\u001d;J]Z\fG.\u001b3PM\u001ad\u0017N\\3SKBd\u0017nY1U_J+\u0007\u000f\\5dC\u0012+G.\u001a;j_:\u001cVoY2fgN4W\u000f\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011(!)\u0002\u007fQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3U_:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a!(!)\u0002oQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Ti\u0006\u0014H/\u001a3U_:+wOU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\rY\u0014\u0011U\u0001;i\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*uCJ$X\r\u001a+p\u001f:d\u0017N\\3SKBd\u0017nY1Ue\u0006t7/\u001b;j_:D3\u0001PAQ\u0003m\"Xm\u001d;J]Z\fG.\u001b3SKBd\u0017nY1EK2,G/[8o'R\f'\u000f^3e)>|eM\u001a7j]\u0016\u0014V\r\u001d7jG\u0006$&/\u00198tSRLwN\u001c\u0015\u0004{\u0005\u0005\u0016a\u0010;fgR\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$Gk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$&/\u00198tSRLwN\u001c\u0015\u0004}\u0005\u0005\u0016a\u0010;fgR\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$Gk\u001c*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$&/\u00198tSRLwN\u001c\u0015\u0004\u007f\u0005\u0005\u0016a\u000f;fgR\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7U_:{g.\u001a=jgR,g\u000e\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a\u0001)!)\u0002uQ,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$vNT3x%\u0016\u0004H.[2b)J\fgn]5uS>t\u0007fA!\u0002\"\u0006iD/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]N+8mY3tg\u001a,H\u000eV8P]2Lg.\u001a*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001a!)!)\u0002}Q,7\u000f^%om\u0006d\u0017\u000e\u001a*fa2L7-\u0019#fY\u0016$\u0018n\u001c8Tk\u000e\u001cWm]:gk2$vn\u00144gY&tWMU3qY&\u001c\u0017\r\u0016:b]NLG/[8oQ\r\u0019\u0015\u0011U\u0001Gi\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{'+\u001a9mS\u000e\fG)\u001a7fi&|gn\u0015;beR,G\r\u0016:b]NLG/[8oQ\r!\u0015\u0011U\u0001Ji\u0016\u001cH/\u00138wC2LGMU3qY&\u001c\u0017\rR3mKRLwN\\*vG\u000e,7o\u001d4vYR{'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)J\fgn]5uS>t\u0007fA#\u0002\"\u0006\u0011E/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\t\u0016dW\r^5p]&sW\r\\5hS\ndW\rV8O_:,\u00070[:uK:$(+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007\u0019\u000b\t+\u0001\u001euKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)>tUm\u001e*fa2L7-\u0019+sC:\u001c\u0018\u000e^5p]\"\u001aq)!)\u0002mQ,7\u000f\u001e*fa2L7-\u0019#fY\u0016$\u0018n\u001c8J]\u0016d\u0017nZ5cY\u0016$vn\u00148mS:,'+\u001a9mS\u000e\fGK]1og&$\u0018n\u001c8)\u0007!\u000b\t+\u0001$uKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7\u000b^1si\u0016$GK]1og&$\u0018n\u001c8)\u0007%\u000b\t+A%uKN$\u0018J\u001c<bY&$'+\u001a9mS\u000e\fG)\u001a7fi&|g.\u00138fY&<\u0017N\u00197f)>\u0014V\r\u001d7jG\u0006$U\r\\3uS>t7+^2dKN\u001ch-\u001e7Ue\u0006t7/\u001b;j_:D3ASAQ\u0003U!Xm\u001d;J]Z\fG.\u001b3Ue\u0006t7/\u001b;j_:$R!\u001aB.\u0005?BqA!\u0018L\u0001\u0004\t)*A\u0005ge>l7\u000b^1uK\"9!\u0011M&A\u0002\u0005U\u0015a\u0002;p'R\fG/Z\u0001\u0012e\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$H\u0003\u0002B4\u0005[\u00022!\u0018B5\u0013\r\u0011YG\u0014\u0002\u0012%\u0016\u0004H.[2b\u0003N\u001c\u0018n\u001a8nK:$\bbBA8\u0019\u0002\u0007!q\u000e\t\u0007\u0005c\u0012\t)a\u0006\u000f\t\tM$Q\u0010\b\u0005\u0005k\u0012Y(\u0004\u0002\u0003x)\u0019!\u0011\u0010*\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0016b\u0001B@-\u00069\u0001/Y2lC\u001e,\u0017\u0002BA0\u0005\u0007S1Aa W\u0001")
public class ReplicaStateMachineTest {
    private ControllerContext controllerContext = null;
    private KafkaZkClient mockZkClient = null;
    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch = null;
    private ReplicaStateMachine replicaStateMachine = null;
    private final int brokerId;
    private final KafkaConfig config = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), "zkConnect", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
    private final int controllerEpoch;
    private final TopicPartition partition = new TopicPartition("t", 0);
    private final Seq<TopicPartition> partitions = new .colon.colon((Object)this.partition(), (List)Nil$.MODULE$);
    private final PartitionAndReplica replica = new PartitionAndReplica(this.partition(), this.brokerId());
    private final Seq<PartitionAndReplica> replicas = new .colon.colon((Object)this.replica(), (List)Nil$.MODULE$);

    private ControllerContext controllerContext() {
        return this.controllerContext;
    }

    private void controllerContext_$eq(ControllerContext x$1) {
        this.controllerContext = x$1;
    }

    private KafkaZkClient mockZkClient() {
        return this.mockZkClient;
    }

    private void mockZkClient_$eq(KafkaZkClient x$1) {
        this.mockZkClient = x$1;
    }

    private ControllerBrokerRequestBatch mockControllerBrokerRequestBatch() {
        return this.mockControllerBrokerRequestBatch;
    }

    private void mockControllerBrokerRequestBatch_$eq(ControllerBrokerRequestBatch x$1) {
        this.mockControllerBrokerRequestBatch = x$1;
    }

    private ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    private void replicaStateMachine_$eq(ReplicaStateMachine x$1) {
        this.replicaStateMachine = x$1;
    }

    private int brokerId() {
        return this.brokerId;
    }

    private KafkaConfig config() {
        return this.config;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private Seq<TopicPartition> partitions() {
        return this.partitions;
    }

    private PartitionAndReplica replica() {
        return this.replica;
    }

    private Seq<PartitionAndReplica> replicas() {
        return this.replicas;
    }

    @BeforeEach
    public void setUp() {
        this.controllerContext_$eq(new ControllerContext());
        this.controllerContext().epoch_$eq(this.controllerEpoch());
        this.mockZkClient_$eq((KafkaZkClient)Mockito.mock(KafkaZkClient.class));
        this.mockControllerBrokerRequestBatch_$eq((ControllerBrokerRequestBatch)Mockito.mock(ControllerBrokerRequestBatch.class));
        this.replicaStateMachine_$eq((ReplicaStateMachine)new ZkReplicaStateMachine(this.config(), new StateChangeLogger(this.brokerId(), true, (Option)None$.MODULE$), this.controllerContext(), this.mockZkClient(), this.mockControllerBrokerRequestBatch()));
    }

    private ReplicaState replicaState(PartitionAndReplica replica) {
        return this.controllerContext().replicaState(replica);
    }

    @Test
    public void testStartupOnlinePartition() {
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupOfflinePartition() {
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
        this.replicaStateMachine().startup();
        Assertions.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testStartupWithReplicaWithoutLeader() {
        int shutdownBrokerId = 100;
        PartitionAndReplica offlineReplica = new PartitionAndReplica(this.partition(), shutdownBrokerId);
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{shutdownBrokerId}))));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)offlineReplica));
        this.replicaStateMachine().startup();
        Assertions.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(offlineReplica));
    }

    @Test
    public void testNonexistentReplicaToNewReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)NewReplica$.MODULE$);
        Assertions.assertEquals((Object)NewReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOnlineReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToOfflineReplicaTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionStartedTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionIneligibleTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNonexistentReplicaToReplicaDeletionSuccessfulTransition() {
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Assertions.assertEquals((Object)NonExistentReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testNewReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testNewReplicaToOfflineReplicaTransition() {
        EndPoint endpoint1 = new EndPoint("localhost", 9997, new ListenerName("blah"), SecurityProtocol.PLAINTEXT);
        scala.collection.immutable.Map liveBrokerEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Broker$.MODULE$.apply(this.brokerId(), (Seq)new .colon.colon((Object)endpoint1, (List)Nil$.MODULE$), (Option)None$.MODULE$)), (Object)BoxesRunTime.boxToLong((long)1L))}));
        this.controllerContext().setLiveBrokers((Map)liveBrokerEpochs);
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)NewReplica$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addStopReplicaRequestForBrokers((Seq)ArgumentMatchers.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)ArgumentMatchers.eq((Object)this.partition()), ArgumentMatchers.eq((boolean)false));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addUpdateMetadataRequestForBrokers((Seq)ArgumentMatchers.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (Set)ArgumentMatchers.eq((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.partition()}))));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(ArgumentMatchers.eq((int)this.controllerEpoch()));
        Assertions.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidNewReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)NewReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOnlineReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOnlineReplicaToOfflineReplicaTransition() {
        int otherBrokerId = this.brokerId() + 1;
        List replicaIds = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId(), otherBrokerId}));
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OnlineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)replicaIds));
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(this.brokerId(), replicaIds);
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(leaderAndIsr, this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        Stat stat = new Stat(0L, 0L, 0L, 0L, 0, 0, 0, 0L, 0, 0, 0L);
        LeaderAndIsr adjustedLeaderAndIsr = leaderAndIsr.newLeaderAndIsr(LeaderAndIsr$.MODULE$.NoLeader(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})));
        LeaderAndIsr updatedLeaderAndIsr = adjustedLeaderAndIsr.withZkVersion(adjustedLeaderAndIsr.zkVersion() + 1);
        LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(updatedLeaderAndIsr, this.controllerEpoch());
        Mockito.when((Object)this.mockZkClient().getTopicPartitionStatesRaw(this.partitions())).thenReturn((Object)new .colon.colon((Object)new GetDataResponse(KeeperException.Code.OK, null, (Option)new Some((Object)this.partition()), TopicPartitionStateZNode$.MODULE$.encode(leaderIsrAndControllerEpoch), stat, new ResponseMetadata(0L, 0L)), (List)Nil$.MODULE$));
        Mockito.when((Object)this.mockZkClient().updateLeaderAndIsr((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)adjustedLeaderAndIsr)})), this.controllerEpoch(), this.controllerContext().epochZkVersion())).thenReturn((Object)new KafkaZkClient.UpdateLeaderAndIsrResult((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition()), (Object)package$.MODULE$.Right().apply((Object)updatedLeaderAndIsr))})), (Seq)Nil$.MODULE$));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OfflineReplica$.MODULE$);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addStopReplicaRequestForBrokers((Seq)ArgumentMatchers.eq((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), (TopicPartition)ArgumentMatchers.eq((Object)this.partition()), ArgumentMatchers.eq((boolean)false));
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{otherBrokerId})), this.partition(), updatedLeaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)replicaIds), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).getTopicPartitionStatesRaw((Seq)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.verify((Object)this.mockZkClient())).updateLeaderAndIsr((Map)ArgumentMatchers.any(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt());
        Assertions.assertEquals((Object)updatedLeaderIsrAndControllerEpoch, (Object)this.controllerContext().partitionLeadershipInfo(this.partition()).get());
        Assertions.assertEquals((Object)OfflineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidOnlineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OnlineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidOfflineReplicaToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testOfflineReplicaToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionStartedTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addStopReplicaRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), true);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)ReplicaDeletionStarted$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testOfflineReplicaToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)OfflineReplica$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assertions.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidOfflineReplicaToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)OfflineReplica$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionStartedToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionStarted$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionIneligibleTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        Assertions.assertEquals((Object)ReplicaDeletionIneligible$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionStartedToReplicaDeletionSuccessfulTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionStarted$.MODULE$);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        Assertions.assertEquals((Object)ReplicaDeletionSuccessful$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testReplicaDeletionSuccessfulToNonexistentReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)NonExistentReplica$.MODULE$);
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)this.controllerContext().partitionReplicaAssignment(this.partition()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.controllerContext().replicaStates().get((Object)this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOnlineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OnlineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToOfflineReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)OfflineReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionSuccessfulToReplicaDeletionIneligibleTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionSuccessful$.MODULE$, (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNonexistentReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NonExistentReplica$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToNewReplicaTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)NewReplica$.MODULE$);
    }

    @Test
    public void testReplicaDeletionIneligibleToOnlineReplicaTransition() {
        this.controllerContext().putReplicaState(this.replica(), (ReplicaState)ReplicaDeletionIneligible$.MODULE$);
        this.controllerContext().updatePartitionFullReplicaAssignment(this.partition(), ReplicaAssignment$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))));
        LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = new LeaderIsrAndControllerEpoch(LeaderAndIsr$.MODULE$.apply(this.brokerId(), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()}))), this.controllerEpoch());
        this.controllerContext().putPartitionLeadershipInfo(this.partition(), leaderIsrAndControllerEpoch);
        this.replicaStateMachine().handleStateChanges(this.replicas(), (ReplicaState)OnlineReplica$.MODULE$);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).newBatch();
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).addLeaderAndIsrRequestForBrokers((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})), this.partition(), leaderIsrAndControllerEpoch, this.replicaAssignment((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.brokerId()})))), false);
        ((AbstractControllerBrokerRequestBatch)Mockito.verify((Object)this.mockControllerBrokerRequestBatch())).sendRequestsToBrokers(this.controllerEpoch());
        Assertions.assertEquals((Object)OnlineReplica$.MODULE$, (Object)this.replicaState(this.replica()));
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionStartedTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionStarted$.MODULE$);
    }

    @Test
    public void testInvalidReplicaDeletionIneligibleToReplicaDeletionSuccessfulTransition() {
        this.testInvalidTransition((ReplicaState)ReplicaDeletionIneligible$.MODULE$, (ReplicaState)ReplicaDeletionSuccessful$.MODULE$);
    }

    private void testInvalidTransition(ReplicaState fromState, ReplicaState toState) {
        this.controllerContext().putReplicaState(this.replica(), fromState);
        this.replicaStateMachine().handleStateChanges(this.replicas(), toState);
        Assertions.assertEquals((Object)fromState, (Object)this.replicaState(this.replica()));
    }

    private ReplicaAssignment replicaAssignment(Seq<Object> replicas) {
        return ReplicaAssignment$.MODULE$.apply(replicas, (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$);
    }

    public ReplicaStateMachineTest() {
        this.brokerId = 5;
        this.controllerEpoch = 50;
    }
}

