/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.coordinator.group.CommitRecordMetadataAndOffset;
import kafka.coordinator.group.CompletingRebalance$;
import kafka.coordinator.group.Dead$;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.JoinGroupResult;
import kafka.coordinator.group.JoinGroupResult$;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.MemberMetadata$;
import kafka.coordinator.group.PreparingRebalance$;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.SyncGroupResult;
import kafka.coordinator.group.SyncGroupResult$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSetLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUc\u0001\u0002(P\u0001YCQ!\u0018\u0001\u0005\u0002yCq!\u0019\u0001C\u0002\u0013%!\r\u0003\u0004l\u0001\u0001\u0006Ia\u0019\u0005\bY\u0002\u0011\r\u0011\"\u0003c\u0011\u0019i\u0007\u0001)A\u0005G\"9a\u000e\u0001b\u0001\n\u0013\u0011\u0007BB8\u0001A\u0003%1\rC\u0004q\u0001\t\u0007I\u0011\u00022\t\rE\u0004\u0001\u0015!\u0003d\u0011\u001d\u0011\bA1A\u0005\n\tDaa\u001d\u0001!\u0002\u0013\u0019\u0007b\u0002;\u0001\u0005\u0004%I!\u001e\u0005\u0007s\u0002\u0001\u000b\u0011\u0002<\t\u000fi\u0004!\u0019!C\u0005k\"11\u0010\u0001Q\u0001\nYDq\u0001\u0015\u0001A\u0002\u0013%A\u0010C\u0005\u0002\u0002\u0001\u0001\r\u0011\"\u0003\u0002\u0004!9\u0011q\u0002\u0001!B\u0013i\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003_\u0001A\u0011AA\n\u0011\u001d\tI\u0004\u0001C\u0001\u0003'Aq!!\u0010\u0001\t\u0003\t\u0019\u0002C\u0004\u0002B\u0001!\t!a\u0005\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002\u0014!9\u0011\u0011\n\u0001\u0005\u0002\u0005M\u0001bBA'\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003#\u0002A\u0011AA\n\u0011\u001d\t)\u0006\u0001C\u0001\u0003'Aq!!\u0017\u0001\t\u0003\t\u0019\u0002C\u0004\u0002^\u0001!\t!a\u0005\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002\u0014!9\u0011Q\r\u0001\u0005\u0002\u0005M\u0001bBA5\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003[\u0002A\u0011AA\n\u0011\u001d\t\t\b\u0001C\u0001\u0003'Aq!!\u001e\u0001\t\u0003\t\u0019\u0002C\u0004\u0002z\u0001!\t!a\u0005\t\u000f\u0005m\u0004\u0001\"\u0001\u0002\u0014!9\u0011q\u0010\u0001\u0005\u0002\u0005M\u0001bBAB\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u000f\u0003A\u0011AA\n\u0011\u001d\tY\t\u0001C\u0001\u0003'Aq!a$\u0001\t\u0003\t\u0019\u0002C\u0004\u0002\u0014\u0002!\t!a\u0005\t\u000f\u0005]\u0005\u0001\"\u0001\u0002\u0014!9\u00111\u0014\u0001\u0005\u0002\u0005M\u0001bBAP\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003G\u0003A\u0011AA\n\u0011\u001d\t9\u000b\u0001C\u0001\u0003'Aq!a+\u0001\t\u0003\t\u0019\u0002C\u0004\u00020\u0002!\t!a\u0005\t\u000f\u0005M\u0006\u0001\"\u0001\u0002\u0014!9\u0011q\u0017\u0001\u0005\u0002\u0005M\u0001bBA^\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003\u007f\u0003A\u0011AA\n\u0011\u001d\t\u0019\r\u0001C\u0001\u0003'Aq!a2\u0001\t\u0003\t\u0019\u0002C\u0004\u0002L\u0002!\t!a\u0005\t\u000f\u0005=\u0007\u0001\"\u0001\u0002\u0014!9\u00111\u001b\u0001\u0005\u0002\u0005M\u0001bBAl\u0001\u0011\u0005\u00111\u0003\u0005\b\u00037\u0004A\u0011AA\n\u0011\u001d\ty\u000e\u0001C\u0001\u0003'Aq!a9\u0001\t\u0003\t\u0019\u0002C\u0004\u0002h\u0002!\t!a\u0005\t\u000f\u0005-\b\u0001\"\u0001\u0002\u0014!9\u0011q\u001e\u0001\u0005\u0002\u0005M\u0001bBAz\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003o\u0004A\u0011AA\n\u0011\u001d\tY\u0010\u0001C\u0001\u0003'Aq!a@\u0001\t\u0003\t\u0019\u0002C\u0004\u0003\u0004\u0001!\t!a\u0005\t\u000f\t\u001d\u0001\u0001\"\u0001\u0002\u0014!9!1\u0002\u0001\u0005\u0002\u0005M\u0001b\u0002B\b\u0001\u0011%!\u0011\u0003\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u0011%\u0011i\u0004AI\u0001\n\u0013\u0011yDA\tHe>,\b/T3uC\u0012\fG/\u0019+fgRT!\u0001U)\u0002\u000b\u001d\u0014x.\u001e9\u000b\u0005I\u001b\u0016aC2p_J$\u0017N\\1u_JT\u0011\u0001V\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u000b\u0005\u0002Y76\t\u0011LC\u0001[\u0003\u0015\u00198-\u00197b\u0013\ta\u0016L\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0003\"\u0001\u0019\u0001\u000e\u0003=\u000bA\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016,\u0012a\u0019\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\fA\u0001\\1oO*\t\u0001.\u0001\u0003kCZ\f\u0017B\u00016f\u0005\u0019\u0019FO]5oO\u0006i\u0001O]8u_\u000e|G\u000eV=qK\u0002\nqb\u001a:pkBLen\u001d;b]\u000e,\u0017\nZ\u0001\u0011OJ|W\u000f]%ogR\fgnY3JI\u0002\n\u0001\"\\3nE\u0016\u0014\u0018\nZ\u0001\n[\u0016l'-\u001a:JI\u0002\n\u0001b\u00197jK:$\u0018\nZ\u0001\nG2LWM\u001c;JI\u0002\n!b\u00197jK:$\bj\\:u\u0003-\u0019G.[3oi\"{7\u000f\u001e\u0011\u0002%I,'-\u00197b]\u000e,G+[7f_V$Xj]\u000b\u0002mB\u0011\u0001l^\u0005\u0003qf\u00131!\u00138u\u0003M\u0011XMY1mC:\u001cW\rV5nK>,H/T:!\u0003A\u0019Xm]:j_:$\u0016.\\3pkRl5/A\ttKN\u001c\u0018n\u001c8US6,w.\u001e;Ng\u0002*\u0012! \t\u0003AzL!a`(\u0003\u001b\u001d\u0013x.\u001e9NKR\fG-\u0019;b\u0003%9'o\\;q?\u0012*\u0017\u000f\u0006\u0003\u0002\u0006\u0005-\u0001c\u0001-\u0002\b%\u0019\u0011\u0011B-\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u001b\t\u0012\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002\r\u001d\u0014x.\u001e9!\u0003\u0015\u0019X\r^+q)\t\t)\u0001K\u0002\u0014\u0003/\u0001B!!\u0007\u0002,5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"A\u0002ba&TA!!\t\u0002$\u00059!.\u001e9ji\u0016\u0014(\u0002BA\u0013\u0003O\tQA[;oSRT!!!\u000b\u0002\u0007=\u0014x-\u0003\u0003\u0002.\u0005m!A\u0003\"fM>\u0014X-R1dQ\u0006QB/Z:u\u0007\u0006t'+\u001a2bY\u0006t7-Z,iK:\u001cF/\u00192mK\"\u001aA#a\r\u0011\t\u0005e\u0011QG\u0005\u0005\u0003o\tYB\u0001\u0003UKN$\u0018a\n;fgR\u001c\u0015M\u001c*fE\u0006d\u0017M\\2f/\",gnQ8na2,G/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016D3!FA\u001a\u0003%\"Xm\u001d;DC:tw\u000e\u001e*fE\u0006d\u0017M\\2f/\",g\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK\"\u001aa#a\r\u00027Q,7\u000f^\"b]:|GOU3cC2\fgnY3XQ\u0016tG)Z1eQ\r9\u00121G\u0001)i\u0016\u001cHo\u0015;bE2,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u00041\u0005M\u0012A\u0007;fgR\u001cF/\u00192mKR{G)Z1e)J\fgn]5uS>t\u0007fA\r\u00024\u0005\u0019D/Z:u\u0003^\f\u0017\u000e^5oOJ+'-\u00197b]\u000e,Gk\u001c)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$&/\u00198tSRLwN\u001c\u0015\u00045\u0005M\u0012A\n;fgR\u0004&/\u001a9be&twMU3cC2\fgnY3U_\u0012+\u0017\r\u001a+sC:\u001c\u0018\u000e^5p]\"\u001a1$a\r\u0002OQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.R7qif$&/\u00198tSRLwN\u001c\u0015\u00049\u0005M\u0012!\u0007;fgR,U\u000e\u001d;z)>$U-\u00193Ue\u0006t7/\u001b;j_:D3!HA\u001a\u0003\u001d\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$vn\u0015;bE2,GK]1og&$\u0018n\u001c8)\u0007y\t\u0019$\u0001\u0012uKN$X)\u001c9usR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004?\u0005M\u0012a\t;fgR\u001cF/\u00192mKR{7\u000b^1cY\u0016LE\u000e\\3hC2$&/\u00198tSRLwN\u001c\u0015\u0004A\u0005M\u0012!\f;fgR,U\u000e\u001d;z)>\fu/Y5uS:<'+\u001a2bY\u0006t7-Z%mY\u0016<\u0017\r\u001c+sC:\u001c\u0018\u000e^5p]\"\u001a\u0011%a\r\u0002wQ,7\u000f\u001e)sKB\f'/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v\u000e\u0015:fa\u0006\u0014\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002#\u0003g\tq\u0006^3tiB\u0013X\r]1sS:<'+\u001a2bY\u0006t7-\u001a+p'R\f'\r\\3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3aIA\u001a\u0003e\"Xm\u001d;Bo\u0006LG/\u001b8h%\u0016\u0014\u0017\r\\1oG\u0016$v.Q<bSRLgn\u001a*fE\u0006d\u0017M\\2f\u00132dWmZ1m)J\fgn]5uS>t\u0007f\u0001\u0013\u00024\u0005yB/Z:u\t\u0016\fG\rV8EK\u0006$\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8\u0002CQ,7\u000f\u001e#fC\u0012$vn\u0015;bE2,\u0017\n\u001c7fO\u0006dGK]1og&$\u0018n\u001c8)\u0007\u0019\n\u0019$A\u0017uKN$H)Z1e)>\u0004&/\u001a9be&twMU3cC2\fgnY3JY2,w-\u00197Ue\u0006t7/\u001b;j_:D3aJA\u001a\u00031\"Xm\u001d;EK\u0006$Gk\\!xC&$\u0018N\\4SK\n\fG.\u00198dK&cG.Z4bYR\u0013\u0018M\\:ji&|g\u000eK\u0002)\u0003g\t!\u0003^3tiN+G.Z2u!J|Go\\2pY\"\u001a\u0011&a\r\u0002GQ,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\u001c*bSN,7/\u00134O_6+WNY3sg\"\u001a!&a\r\u0002WQ,7\u000f^*fY\u0016\u001cG\u000f\u0015:pi>\u001cw\u000e\\\"i_>\u001cXm]\"p[B\fG/\u001b2mKB\u0013x\u000e^8d_2D3aKA\u001a\u0003U!Xm\u001d;TkB\u0004xN\u001d;t!J|Go\\2pYND3\u0001LA\u001a\u0003Q\"Xm\u001d;PM\u001a\u001cX\r\u001e*f[>4\u0018\r\u001c#ve&tw\r\u0016:b]NLG/[8o\rJ|W.R7qif$vNT8o\u000b6\u0004H/\u001f\u0015\u0004[\u0005M\u0012\u0001\u0006;fgR\u001cVOY:de&\u0014W\r\u001a+pa&\u001c7\u000fK\u0002/\u0003g\tA\u0005^3tiN+(m]2sS\n,G\rV8qS\u000e\u001chj\u001c8D_:\u001cX/\\3s\u000fJ|W\u000f\u001d\u0015\u0004_\u0005M\u0012A\u0006;fgRLe.\u001b;OKb$x)\u001a8fe\u0006$\u0018n\u001c8)\u0007A\n\u0019$\u0001\u0011uKN$\u0018J\\5u\u001d\u0016DHoR3oKJ\fG/[8o\u000b6\u0004H/_$s_V\u0004\bfA\u0019\u00024\u0005\u0001B/Z:u\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004e\u0005M\u0012a\u0006;fgR|eMZ:fi\u000e{W.\\5u\r\u0006LG.\u001e:fQ\r\u0019\u00141G\u0001*i\u0016\u001cHo\u00144gg\u0016$8i\\7nSR4\u0015-\u001b7ve\u0016<\u0016\u000e\u001e5B]>$\b.\u001a:QK:$\u0017N\\4)\u0007Q\n\u0019$\u0001\u0012uKN$xJ\u001a4tKR\u001cu.\\7ji^KG\u000f[!o_RDWM\u001d)f]\u0012Lgn\u001a\u0015\u0004k\u0005M\u0012A\u000b;fgR\u001cuN\\:v[\u0016\u0014()Z1ugR\u0013\u0018M\\:bGRLwN\\1m\u001f\u001a47/\u001a;D_6l\u0017\u000e\u001e\u0015\u0004m\u0005M\u0012\u0001\u000b;fgR$&/\u00198tC\u000e$\u0018n\u001c8CK\u0006$8oQ8ogVlWM](gMN,GoQ8n[&$\bfA\u001c\u00024\u0005)D/Z:u)J\fgn]1di&|g.\u00197D_6l\u0017\u000e^%t\u0003\n|'\u000f^3e\u0003:$7i\u001c8tk6,'oQ8n[&$x+\u001b8tQ\rA\u00141G\u0001.i\u0016\u001cHOR1jY\u0016$G\u000b\u001f8PM\u001a\u001cX\r^\"p[6LG\u000fT3bm\u0016\u001chj\u001c)f]\u0012LgnZ*uCR,\u0007fA\u001d\u00024\u0005iC/Z:u%\u0016\u0004H.Y2f\u000fJ|W\u000f]%ogR\fgnY3XSRDgj\u001c8Fq&\u001cH/\u001b8h\u001b\u0016l'-\u001a:)\u0007i\n\u0019$\u0001\ruKN$(+\u001a9mC\u000e,wI]8va&s7\u000f^1oG\u0016D3aOA\u001a\u0003Y!Xm\u001d;J]Z|7.\u001a&pS:\u001c\u0015\r\u001c7cC\u000e\\\u0007f\u0001\u001f\u00024\u0005IB/Z:u\u001d>$\u0018J\u001c<pW\u0016Tu.\u001b8DC2d'-Y2lQ\ri\u00141G\u0001\u0017i\u0016\u001cH/\u00138w_.,7+\u001f8d\u0007\u0006dGNY1dW\"\u001aa(a\r\u00023Q,7\u000f\u001e(pi&sgo\\6f'ft7mQ1mY\n\f7m\u001b\u0015\u0004\u007f\u0005M\u0012a\u0007;fgRD\u0015m\u001d)f]\u0012Lgn\u001a(p]RChn\u00144gg\u0016$8\u000fK\u0002A\u0003g\t\u0001\u0004^3ti\"\u000b7\u000fU3oI&tw\r\u0016=o\u001f\u001a47/\u001a;tQ\r\t\u00151G\u0001#i\u0016\u001cHoQ1o]>$\u0018\t\u001a3QK:$\u0017N\\4NK6\u0014WM]%g'R\f'\r\\3)\u0007\t\u000b\u0019$A\u0015uKN$(+Z7pm\u0006dgI]8n!\u0016tG-\u001b8h\u0003\u001a$XM]'f[\n,'/S:Ti\u0006\u0014G.\u001a\u0015\u0004\u0007\u0006M\u0012!\u000b;fgR\u0014V-\\8wC24%o\\7QK:$\u0017N\\4XQ\u0016tW*Z7cKJL5OU3n_Z,G\rK\u0002E\u0003g\t\u0011\u0006^3ti\u000e\u000bgN\\8u\u0003\u0012$7\u000b^1uS\u000elU-\u001c2fe&3\u0017\t\u001c:fC\u0012L\bK]3tK:$\bfA#\u00024\u00059C/Z:u\u0007\u0006tgn\u001c;BI\u0012\u0004VM\u001c3j]\u001e\u001c\u0016P\\2PMVs7N\\8x]6+WNY3sQ\r1\u00151G\u0001+i\u0016\u001cHoQ1o]>$(+Z7pm\u0016\u0004VM\u001c3j]\u001e\u001c\u0016P\\2PMVs7N\\8x]6+WNY3sQ\r9\u00151G\u0001%i\u0016\u001cHoQ1o\u0003\u0012$\u0017I\u001c3SK6|g/\u001a)f]\u0012LgnZ*z]\u000elU-\u001c2fe\"\u001a\u0001*a\r\u0002[Q,7\u000f\u001e*f[>4\u0018\r\u001c$s_6\u0004VM\u001c3j]\u001e\u001c\u0016P\\2XQ\u0016tW*Z7cKJL5OU3n_Z,G\rK\u0002J\u0003g\t\u0011\u0006^3ti:+woR3oKJ\fG/[8o\u00072,\u0017M]:QK:$\u0017N\\4Ts:\u001cW*Z7cKJ\u001c\bf\u0001&\u00024\u0005Y\u0011m]:feR\u001cF/\u0019;f)\u0019\t)Aa\u0005\u0003\u0016!)\u0001k\u0013a\u0001{\"9!qC&A\u0002\te\u0011a\u0003;be\u001e,Go\u0015;bi\u0016\u00042\u0001\u0019B\u000e\u0013\r\u0011ib\u0014\u0002\u000b\u000fJ|W\u000f]*uCR,\u0017!E8gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uCR1!1\u0005B\u0018\u0005s\u0001BA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005S\u0019\u0016AB2p[6|g.\u0003\u0003\u0003.\t\u001d\"!E(gMN,G/\u00118e\u001b\u0016$\u0018\rZ1uC\"9!\u0011\u0007'A\u0002\tM\u0012AB8gMN,G\u000fE\u0002Y\u0005kI1Aa\u000eZ\u0005\u0011auN\\4\t\u0013\tmB\n%AA\u0002\tM\u0012!\u0003;j[\u0016\u001cH/Y7q\u0003mygMZ:fi\u0006sG-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%eU\u0011!\u0011\t\u0016\u0005\u0005g\u0011\u0019e\u000b\u0002\u0003FA!!q\tB)\u001b\t\u0011IE\u0003\u0003\u0003L\t5\u0013!C;oG\",7m[3e\u0015\r\u0011y%W\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B*\u0005\u0013\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class GroupMetadataTest {
    private final String protocolType;
    private final String groupInstanceId;
    private final String memberId;
    private final String clientId;
    private final String clientHost;
    private final int rebalanceTimeoutMs;
    private final int sessionTimeoutMs;
    private GroupMetadata group = null;

    private String protocolType() {
        return this.protocolType;
    }

    private String groupInstanceId() {
        return this.groupInstanceId;
    }

    private String memberId() {
        return this.memberId;
    }

    private String clientId() {
        return this.clientId;
    }

    private String clientHost() {
        return this.clientHost;
    }

    private int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    private int sessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    private GroupMetadata group() {
        return this.group;
    }

    private void group_$eq(GroupMetadata x$1) {
        this.group = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, Time.SYSTEM));
    }

    @Test
    public void testCanRebalanceWhenStable() {
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCanRebalanceWhenCompletingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenPreparingRebalance() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testCannotRebalanceWhenDead() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertFalse((boolean)this.group().canRebalance());
    }

    @Test
    public void testStableToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testStableToDeadTransition() {
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToPreparingRebalanceTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.assertState(this.group(), (GroupState)PreparingRebalance$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testPreparingRebalanceToEmptyTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.assertState(this.group(), (GroupState)Empty$.MODULE$);
    }

    @Test
    public void testEmptyToDeadTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Empty$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testAwaitingRebalanceToStableTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        this.assertState(this.group(), (GroupState)Stable$.MODULE$);
    }

    @Test
    public void testEmptyToStableIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testStableToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Stable$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testEmptyToAwaitingRebalanceIllegalTransition() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testPreparingRebalanceToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testAwaitingRebalanceToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    public void testDeadToDeadIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        this.assertState(this.group(), (GroupState)Dead$.MODULE$);
    }

    @Test
    public void testDeadToStableIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)Stable$.MODULE$));
    }

    @Test
    public void testDeadToPreparingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$));
    }

    @Test
    public void testDeadToAwaitingRebalanceIllegalTransition() {
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().transitionTo((GroupState)Dead$.MODULE$);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().transitionTo((GroupState)CompletingRebalance$.MODULE$));
    }

    @Test
    public void testSelectProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertEquals((Object)"range", (Object)this.group().selectProtocol());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)((GenSetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "roundrobin"}))).apply((Object)this.group().selectProtocol()));
        String lastMemberId = "lastMemberId";
        MemberMetadata lastMember = new MemberMetadata(lastMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$3 = this.group();
        Function1 x$6 = qual$3.add$default$2();
        qual$3.add(lastMember, x$6);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolRaisesIfNoMembers() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().selectProtocol());
    }

    @Test
    public void testSelectProtocolChoosesCompatibleProtocol() {
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().selectProtocol());
    }

    @Test
    public void testSupportsProtocols() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "range"}))));
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        String otherMemberId = "otherMemberId";
        MemberMetadata otherMember = new MemberMetadata(otherMemberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"blah", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(otherMember, x$4);
        Assertions.assertTrue((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols("invalid_type", (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"roundrobin", "foo"}))));
        Assertions.assertFalse((boolean)this.group().supportsProtocols(this.protocolType(), (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"range", "foo"}))));
    }

    @Test
    public void testOffsetRemovalDuringTransitionFromEmptyToNonEmpty() {
        String topic = "foo";
        TopicPartition partition = new TopicPartition(topic, 0);
        MockTime time = new MockTime();
        this.group_$eq(new GroupMetadata("groupId", (GroupState)Empty$.MODULE$, (Time)time));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava())).array()), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        OffsetAndMetadata offset = this.offsetAndMetadata(37L, time.milliseconds());
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        long offsetRetentionMs = 50000L;
        time.sleep(offsetRetentionMs + 1L);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(this.memberId());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.group().removeExpiredOffsets(time.milliseconds(), offsetRetentionMs));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(member, x$4);
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)this.group().removeExpiredOffsets(time.milliseconds(), offsetRetentionMs));
    }

    @Test
    public void testSubscribedTopics() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", (Object)ConsumerProtocol.serializeSubscription((ConsumerPartitionAssignor.Subscription)new ConsumerPartitionAssignor.Subscription((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)"foo", (List)Nil$.MODULE$)).asJava())).array()), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"}))), (Object)this.group().getSubscribedTopics());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().remove(memberId);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)new Some((Object)Predef$.MODULE$.Set().empty()), (Object)this.group().getSubscribedTopics());
        MemberMetadata memberWithFaultyProtocol = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$2 = this.group();
        Function1 x$4 = qual$2.add$default$2();
        qual$2.add(memberWithFaultyProtocol, x$4);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testSubscribedTopicsNonConsumerGroup() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
        String memberId = "memberId";
        MemberMetadata member = new MemberMetadata(memberId, (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), "My Protocol", (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().getSubscribedTopics());
    }

    @Test
    public void testInitNextGeneration() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        member.supportedProtocols_$eq((List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().add(member, (Function1 & Serializable & scala.Serializable)x$1 -> {
            GroupMetadataTest.$anonfun$testInitNextGeneration$1(x$1);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertEquals((Object)"roundrobin", (Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testInitNextGenerationEmptyGroup() {
        Assertions.assertEquals((Object)Empty$.MODULE$, (Object)this.group().currentState());
        Assertions.assertEquals((int)0, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().initNextGeneration();
        Assertions.assertEquals((int)1, (int)this.group().generationId());
        Assertions.assertNull((Object)this.group().protocolName().orNull(Predef$.MODULE$.$conforms()));
    }

    @Test
    public void testOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        int commitRecordOffset = 3;
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)commitRecordOffset)), offset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)offset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailure() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingOffsetWrite(partition, offset);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitFailureWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L, this.offsetAndMetadata$default$2());
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().failPendingOffsetWrite(partition, firstOffset);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testOffsetCommitWithAnotherPending() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata firstOffset = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        OffsetAndMetadata secondOffset = this.offsetAndMetadata(57L, this.offsetAndMetadata$default$2());
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)firstOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)secondOffset)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), firstOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)firstOffset), (Object)this.group().offset(partition));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)5L)), secondOffset));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)secondOffset), (Object)this.group().offset(partition));
    }

    @Test
    public void testConsumerBeatsTransactionalOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L, this.offsetAndMetadata$default$2());
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), txnOffsetCommit));
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), consumerOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionBeatsConsumerOffsetCommit() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L, this.offsetAndMetadata$default$2());
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)txnOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testTransactionalCommitIsAbortedAndConsumerCommitWins() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        OffsetAndMetadata consumerOffsetCommit = this.offsetAndMetadata(57L, this.offsetAndMetadata$default$2());
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)consumerOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        this.group().onOffsetCommitAppend(partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)3L)), consumerOffsetCommit));
        this.group().onTxnOffsetCommitAppend(producerId, partition, new CommitRecordMetadataAndOffset((Option)new Some((Object)BoxesRunTime.boxToLong((long)4L)), txnOffsetCommit));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
        this.group().completePendingTxnOffsetCommit(producerId, false);
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertEquals((Object)new Some((Object)consumerOffsetCommit), (Object)this.group().offset(partition));
    }

    @Test
    public void testFailedTxnOffsetCommitLeavesNoPendingState() {
        TopicPartition partition = new TopicPartition("foo", 0);
        long producerId = 13232L;
        OffsetAndMetadata txnOffsetCommit = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        this.group().prepareTxnOffsetCommit(producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)txnOffsetCommit)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        Assertions.assertTrue((boolean)this.group().hasOffsets());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.group().offset(partition));
        this.group().failPendingTxnOffsetCommit(producerId, partition);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
        this.group().completePendingTxnOffsetCommit(producerId, true);
        Assertions.assertFalse((boolean)this.group().hasOffsets());
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsFromProducer(producerId));
    }

    @Test
    public void testReplaceGroupInstanceWithNonExistingMember() {
        String newMemberId = "newMemberId";
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId));
    }

    @Test
    public void testReplaceGroupInstance() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef joinAwaitingMemberFenced = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable & scala.Serializable)joinGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$1(joinAwaitingMemberFenced, joinGroupResult);
            return BoxedUnit.UNIT;
        });
        BooleanRef syncAwaitingMemberFenced = BooleanRef.create((boolean)false);
        member.awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)syncGroupResult -> {
            GroupMetadataTest.$anonfun$testReplaceGroupInstance$2(syncAwaitingMemberFenced, syncGroupResult);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().isLeader(this.memberId()));
        Assertions.assertEquals((Object)new Some((Object)this.memberId()), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        String newMemberId = "newMemberId";
        this.group().replaceStaticMember(this.groupInstanceId(), this.memberId(), newMemberId);
        Assertions.assertTrue((boolean)this.group().isLeader(newMemberId));
        Assertions.assertEquals((Object)new Some((Object)newMemberId), (Object)this.group().currentStaticMemberId(this.groupInstanceId()));
        Assertions.assertTrue((boolean)joinAwaitingMemberFenced.elem);
        Assertions.assertTrue((boolean)syncAwaitingMemberFenced.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        BooleanRef invoked = BooleanRef.create((boolean)false);
        this.group().add(member, (Function1 & Serializable & scala.Serializable)x$2 -> {
            invoked.elem = true;
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().hasAllMembersJoined());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertTrue((boolean)invoked.elem);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testNotInvokeJoinCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
        this.group().maybeInvokeJoinCallback(member, JoinGroupResult$.MODULE$.apply(member.memberId(), Errors.NONE));
        Assertions.assertFalse((boolean)member.isAwaitingJoin());
    }

    @Test
    public void testInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        member.awaitingSyncCallback_$eq((Function1 & Serializable & scala.Serializable)x$3 -> {
            GroupMetadataTest.$anonfun$testInvokeSyncCallback$1(x$3);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testNotInvokeSyncCallback() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertFalse((boolean)this.group().maybeInvokeSyncCallback(member, SyncGroupResult$.MODULE$.apply(Errors.NONE)));
        Assertions.assertFalse((boolean)member.isAwaitingSync());
    }

    @Test
    public void testHasPendingNonTxnOffsets() {
        TopicPartition partition = new TopicPartition("foo", 0);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        this.group().prepareOffsetCommit((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(partition));
    }

    @Test
    public void testHasPendingTxnOffsets() {
        TopicPartition txnPartition = new TopicPartition("foo", 1);
        OffsetAndMetadata offset = this.offsetAndMetadata(37L, this.offsetAndMetadata$default$2());
        int producerId = 5;
        this.group().prepareTxnOffsetCommit((long)producerId, (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)txnPartition), (Object)offset)})));
        Assertions.assertTrue((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(txnPartition));
        Assertions.assertFalse((boolean)this.group().hasPendingOffsetCommitsForTopicPartition(new TopicPartition("non-exist", 0)));
    }

    @Test
    public void testCannotAddPendingMemberIfStable() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingAfterMemberIsStable() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)None$.MODULE$, this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)new .colon.colon((Object)new Tuple2((Object)"roundrobin", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$)), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testRemovalFromPendingWhenMemberIsRemoved() {
        this.group().addPendingMember(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().isPendingMember(this.memberId()));
        this.group().remove(this.memberId());
        Assertions.assertFalse((boolean)this.group().has(this.memberId()));
        Assertions.assertFalse((boolean)this.group().isPendingMember(this.memberId()));
    }

    @Test
    public void testCannotAddStaticMemberIfAlreadyPresent() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        Assertions.assertTrue((boolean)this.group().has(this.memberId()));
        Assertions.assertTrue((boolean)this.group().hasStaticMember(this.groupInstanceId()));
        Assertions.assertThrows(IllegalStateException.class, () -> {
            GroupMetadata qual$2 = this.group();
            Function1 x$4 = qual$2.add$default$2();
            qual$2.add(member, x$4);
        });
    }

    @Test
    public void testCannotAddPendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().addPendingSyncMember(this.memberId()));
    }

    @Test
    public void testCannotRemovePendingSyncOfUnknownMember() {
        Assertions.assertThrows(IllegalStateException.class, () -> this.group().removePendingSyncMember(this.memberId()));
    }

    @Test
    public void testCanAddAndRemovePendingSyncMember() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().removePendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testRemovalFromPendingSyncWhenMemberIsRemoved() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().remove(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    @Test
    public void testNewGenerationClearsPendingSyncMembers() {
        MemberMetadata member = new MemberMetadata(this.memberId(), (Option)new Some((Object)this.groupInstanceId()), this.clientId(), this.clientHost(), this.rebalanceTimeoutMs(), this.sessionTimeoutMs(), this.protocolType(), (List)new .colon.colon((Object)new Tuple2((Object)"range", Array$.MODULE$.empty(ClassTag$.MODULE$.Byte())), (List)Nil$.MODULE$), MemberMetadata$.MODULE$.$lessinit$greater$default$9());
        GroupMetadata qual$1 = this.group();
        Function1 x$2 = qual$1.add$default$2();
        qual$1.add(member, x$2);
        this.group().transitionTo((GroupState)PreparingRebalance$.MODULE$);
        this.group().addPendingSyncMember(this.memberId());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.memberId()})), (Object)this.group().allPendingSyncMembers());
        this.group().initNextGeneration();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Object)this.group().allPendingSyncMembers());
    }

    private void assertState(GroupMetadata group, GroupState targetState) {
        ((Set)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GroupState[]{Stable$.MODULE$, PreparingRebalance$.MODULE$, CompletingRebalance$.MODULE$, Dead$.MODULE$}))).$minus((Object)targetState)).foreach((Function1 & Serializable & scala.Serializable)otherState -> {
            GroupMetadataTest.$anonfun$assertState$1(group, otherState);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((boolean)group.is(targetState));
    }

    private OffsetAndMetadata offsetAndMetadata(long offset, long timestamp) {
        return OffsetAndMetadata$.MODULE$.apply(offset, "", timestamp);
    }

    private long offsetAndMetadata$default$2() {
        return Time.SYSTEM.milliseconds();
    }

    public static final /* synthetic */ void $anonfun$testInitNextGeneration$1(JoinGroupResult x$1) {
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$1(BooleanRef joinAwaitingMemberFenced$1, JoinGroupResult joinGroupResult) {
        Errors errors = joinGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        joinAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testReplaceGroupInstance$2(BooleanRef syncAwaitingMemberFenced$1, SyncGroupResult syncGroupResult) {
        Errors errors = syncGroupResult.error();
        Errors errors2 = Errors.FENCED_INSTANCE_ID;
        syncAwaitingMemberFenced$1.elem = !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ void $anonfun$testInvokeSyncCallback$1(SyncGroupResult x$3) {
    }

    public static final /* synthetic */ void $anonfun$assertState$1(GroupMetadata group$1, GroupState otherState) {
        Assertions.assertFalse((boolean)group$1.is(otherState));
    }

    public GroupMetadataTest() {
        this.protocolType = "consumer";
        this.groupInstanceId = "groupInstanceId";
        this.memberId = "memberId";
        this.clientId = "clientId";
        this.clientHost = "clientHost";
        this.rebalanceTimeoutMs = 60000;
        this.sessionTimeoutMs = 10000;
    }
}

