/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import kafka.utils.NotNothing$;
import org.apache.kafka.common.message.InitProducerIdRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.InitProducerIdRequest;
import org.apache.kafka.common.requests.InitProducerIdResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.Predef;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={ClusterTestExtensions.class})
@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u0004\t\u0001=AQA\u0006\u0001\u0005\u0002]AQA\u0007\u0001\u0005\u0002mAQ\u0001\u000e\u0001\u0005\u0002UBQA\u0017\u0001\u0005\u0002mCQ\u0001\u001a\u0001\u0005\n\u0015DQa\u001a\u0001\u0005\n!\u0014!\u0004\u0015:pIV\u001cWM]%eg&sG/Z4sCRLwN\u001c+fgRT!!\u0003\u0006\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003\u00171\t1bY8pe\u0012Lg.\u0019;pe*\tQ\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0015\u001b\u0005\u0011\"\"A\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005U\u0011\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00021A\u0011\u0011\u0004A\u0007\u0002\u0011\u0005)1/\u001a;vaR\u0011Ad\b\t\u0003#uI!A\b\n\u0003\tUs\u0017\u000e\u001e\u0005\u0006A\t\u0001\r!I\u0001\u000eG2,8\u000f^3s\u0007>tg-[4\u0011\u0005\t*S\"A\u0012\u000b\u0005\u0011b\u0011\u0001\u0002;fgRL!AJ\u0012\u0003\u001b\rcWo\u001d;fe\u000e{gNZ5hQ\t\u0011\u0001\u0006\u0005\u0002*e5\t!F\u0003\u0002,Y\u0005\u0019\u0011\r]5\u000b\u00055r\u0013a\u00026va&$XM\u001d\u0006\u0003_A\nQA[;oSRT\u0011!M\u0001\u0004_J<\u0017BA\u001a+\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u0016i\u0016\u001cH/\u00168jcV,\u0007K]8ek\u000e,'/\u00133t)\tab\u0007C\u00038\u0007\u0001\u0007\u0001(A\bdYV\u001cH/\u001a:J]N$\u0018M\\2f!\t\u0011\u0013(\u0003\u0002;G\ty1\t\\;ti\u0016\u0014\u0018J\\:uC:\u001cW\r\u000b\u0003\u0004y\t\u001b\u0005CA\u001fA\u001b\u0005q$BA $\u0003)\tgN\\8uCRLwN\\\u0005\u0003\u0003z\u0012Ab\u00117vgR,'\u000fV3tiN\fQA^1mk\u0016d3\u0001R*WW\u001d)\u0005*\u0013(P!F\u0003\"!\u0010$\n\u0005\u001ds$aC\"mkN$XM\u001d+fgR\f1b\u00197vgR,'\u000fV=qK\u0012\n!*\u0003\u0002L\u0019\u0006\u0011!l\u0013\u0006\u0003\u001bz\nA\u0001V=qK\u00069!M]8lKJ\u001cX$A\u0002\u0002\u0007%\u0014\u0007/I\u0001S\u0003\r\u0011d\u0006O\u0016\b\u000b\"Kej\u0014)UC\u0005)\u0016aB\u001a/a5Je\u000bM\u0016\b\u000b\";fj\u0014)UI\u0005A\u0016BA-M\u0003\u0015Y%+\u0011$U\u0003q!Xm\u001d;V]&\fX/\u001a)s_\u0012,8-\u001a:JIN\u0014U/\u001c9J\u0005B#\"\u0001\b/\t\u000b]\"\u0001\u0019\u0001\u001d)\u0011\u0011)\u0005*\u0013(P=~\u000b\u0011\"Y;u_N#\u0018M\u001d;%\u0003\u0001L!!\u00192\u0002\u00059{%BA2?\u0003%\tU\u000f^8Ti\u0006\u0014H/A\bwKJLg-_+oSF,X-\u00133t)\tab\rC\u00038\u000b\u0001\u0007\u0001(\u0001\boKb$\bK]8ek\u000e,'/\u00133\u0015\u0007%dG\u000f\u0005\u0002\u0012U&\u00111N\u0005\u0002\u0005\u0019>tw\rC\u0003n\r\u0001\u0007a.\u0001\u0004ce>\\WM\u001d\t\u0003_Jl\u0011\u0001\u001d\u0006\u0003c2\tqA\\3uo>\u00148.\u0003\u0002ta\na1k\\2lKR\u001cVM\u001d<fe\")QO\u0002a\u0001m\u0006AA.[:uK:,'\u000f\u0005\u0002x}6\t\u0001P\u0003\u0002rs*\u0011!p_\u0001\u0007G>lWn\u001c8\u000b\u00055a(BA?1\u0003\u0019\t\u0007/Y2iK&\u0011q\u0010\u001f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0015\u0007\u0001\u0005\r!)a\u0004\u0011\t\u0005\u0015\u00111B\u0007\u0003\u0003\u000fQ1!!\u0003+\u0003%)\u0007\u0010^3og&|g.\u0003\u0003\u0002\u000e\u0005\u001d!AC#yi\u0016tGmV5uQ2\u0012\u0011\u0011C\u0012\u0003\u0003'\u0001B!!\u0006\u0002\u001a5\u0011\u0011q\u0003\u0006\u0003_\rJA!a\u0007\u0002\u0018\t)2\t\\;ti\u0016\u0014H+Z:u\u000bb$XM\\:j_:\u001c\b")
public class ProducerIdsIntegrationTest {
    @BeforeEach
    public void setup(ClusterConfig clusterConfig) {
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.TransactionsTopicPartitionsProp(), "1");
        clusterConfig.serverProperties().put(KafkaConfig$.MODULE$.TransactionsTopicReplicationFactorProp(), "3");
    }

    @ClusterTests(value={@ClusterTest(clusterType=Type.ZK, brokers=3, ibp="2.8"), @ClusterTest(clusterType=Type.ZK, brokers=3, ibp="3.0-IV0"), @ClusterTest(clusterType=Type.KRAFT, brokers=3, ibp="3.0-IV0")})
    public void testUniqueProducerIds(ClusterInstance clusterInstance) {
        this.verifyUniqueIds(clusterInstance);
    }

    @ClusterTest(clusterType=Type.ZK, brokers=3, autoStart=AutoStart.NO)
    public void testUniqueProducerIdsBumpIBP(ClusterInstance clusterInstance) {
        clusterInstance.config().serverProperties().put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "2.8");
        clusterInstance.config().brokerServerProperties(0).put(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), "3.0-IV0");
        clusterInstance.start();
        this.verifyUniqueIds(clusterInstance);
        clusterInstance.stop();
    }

    private void verifyUniqueIds(ClusterInstance clusterInstance) {
        Seq ids = ((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(clusterInstance.brokerSocketServers().stream().flatMap(broker -> IntStream.range(0, 1001).parallel().mapToObj(x$1 -> BoxesRunTime.boxToLong((long)this.nextProducerId(broker, clusterInstance.clientListener())))).collect(Collectors.toList())).asScala()).toSeq();
        Assertions.assertEquals((int)3003, (int)ids.size(), (String)"Expected exactly 3003 IDs");
        Assertions.assertEquals((int)ids.size(), (int)((SeqLike)ids.distinct()).size(), (String)"Found duplicate producer IDs");
    }

    private long nextProducerId(SocketServer broker, ListenerName listener) {
        InitProducerIdRequestData data = new InitProducerIdRequestData().setProducerEpoch((short)-1).setProducerId(-1L).setTransactionalId(null).setTransactionTimeoutMs(10);
        InitProducerIdRequest request = (InitProducerIdRequest)new InitProducerIdRequest.Builder(data).build();
        return ((InitProducerIdResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, broker, listener, ClassTag$.MODULE$.apply(InitProducerIdResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).data().producerId();
    }
}

