/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import kafka.log.BrokerCompressionTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager$;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.message.BrokerCompressionCodec$;
import kafka.message.CompressionCodec;
import kafka.message.CompressionCodec$;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.LogDirFailureChannel;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.None$;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\t\u0012\u0001YAQ!\b\u0001\u0005\u0002yAq!\t\u0001C\u0002\u0013\u0005!\u0005\u0003\u0004,\u0001\u0001\u0006Ia\t\u0005\bY\u0001\u0011\r\u0011\"\u0001#\u0011\u0019i\u0003\u0001)A\u0005G!9a\u0006\u0001b\u0001\n\u0003y\u0003B\u0002\u001c\u0001A\u0003%\u0001\u0007C\u00048\u0001\t\u0007I\u0011\u0001\u001d\t\rq\u0002\u0001\u0015!\u0003:\u0011\u0015i\u0004\u0001\"\u0001?\u0011\u0015y\u0005\u0001\"\u0001Q\u000f\u0015\u0011\u0018\u0003#\u0001t\r\u0015\u0001\u0012\u0003#\u0001u\u0011\u0015iR\u0002\"\u0001v\u0011\u0015aW\u0002\"\u0001w\u0005U\u0011%o\\6fe\u000e{W\u000e\u001d:fgNLwN\u001c+fgRT!AE\n\u0002\u00071|wMC\u0001\u0015\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0003i\tQa]2bY\u0006L!\u0001H\r\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002!\u00015\t\u0011#\u0001\u0004u[B$\u0015N]\u000b\u0002GA\u0011A%K\u0007\u0002K)\u0011aeJ\u0001\u0003S>T\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t!a)\u001b7f\u0003\u001d!X\u000e\u001d#je\u0002\na\u0001\\8h\t&\u0014\u0018a\u00027pO\u0012K'\u000fI\u0001\u0005i&lW-F\u00011!\t\tD'D\u00013\u0015\t\u00194#A\u0003vi&d7/\u0003\u00026e\tAQj\\2l)&lW-A\u0003uS6,\u0007%A\u0005m_\u001e\u001cuN\u001c4jOV\t\u0011\b\u0005\u0002!u%\u00111(\u0005\u0002\n\u0019><7i\u001c8gS\u001e\f!\u0002\\8h\u0007>tg-[4!\u0003!!X-\u0019:E_^tG#A \u0011\u0005a\u0001\u0015BA!\u001a\u0005\u0011)f.\u001b;)\u0005)\u0019\u0005C\u0001#N\u001b\u0005)%B\u0001$H\u0003\r\t\u0007/\u001b\u0006\u0003\u0011&\u000bqA[;qSR,'O\u0003\u0002K\u0017\u0006)!.\u001e8ji*\tA*A\u0002pe\u001eL!AT#\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017!\u0007;fgR\u0014%o\\6feNKG-Z\"p[B\u0014Xm]:j_:$2aP)_\u0011\u0015\u00116\u00021\u0001T\u0003IiWm]:bO\u0016\u001cu.\u001c9sKN\u001c\u0018n\u001c8\u0011\u0005Q[fBA+Z!\t1\u0016$D\u0001X\u0015\tAV#\u0001\u0004=e>|GOP\u0005\u00035f\ta\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!,\u0007\u0005\u0006?.\u0001\raU\u0001\u0012EJ|7.\u001a:D_6\u0004(/Z:tS>t\u0007\u0006B\u0006bS*\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u0011A\u0014xN^5eKJT!AZ$\u0002\rA\f'/Y7t\u0013\tA7M\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\rL\u0001lC\u0005a\u0017A\u00039be\u0006lW\r^3sg\"\u00121B\u001c\t\u0003_Bl\u0011!Z\u0005\u0003c\u0016\u0014\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003U\u0011%o\\6fe\u000e{W\u000e\u001d:fgNLwN\u001c+fgR\u0004\"\u0001I\u0007\u0014\u000559B#A:\u0016\u0003]\u00042\u0001_?\u0000\u001b\u0005I(B\u0001>|\u0003\u0019\u0019HO]3b[*\u0011ApJ\u0001\u0005kRLG.\u0003\u0002\u007fs\n11\u000b\u001e:fC6\u00042AYA\u0001\u0013\r\t\u0019a\u0019\u0002\n\u0003J<W/\\3oiN\u0004")
public class BrokerCompressionTest {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime(0L, 0L);
    private final LogConfig logConfig = LogConfig$.MODULE$.apply();

    public static Stream<Arguments> parameters() {
        return BrokerCompressionTest$.MODULE$.parameters();
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @ParameterizedTest
    @MethodSource(value={"parameters"})
    public void testBrokerSideCompression(String messageCompression, String brokerCompression) {
        CompressionCodec messageCompressionCode = CompressionCodec$.MODULE$.getCompressionCodec(messageCompression);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), brokerCompression);
        File x$1 = this.logDir();
        LogConfig x$2 = new LogConfig((Map)logProps, LogConfig$.MODULE$.apply$default$2());
        long x$3 = 0L;
        long x$4 = 0L;
        MockScheduler x$5 = this.time().scheduler();
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats();
        int x$8 = 300000;
        int x$9 = 3600000;
        int x$10 = LogManager$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$13 = true;
        boolean x$14 = UnifiedLog$.MODULE$.apply$default$12();
        UnifiedLog log = UnifiedLog$.MODULE$.apply(x$1, x$2, x$3, x$4, (Scheduler)x$5, x$7, (Time)x$6, x$8, x$9, x$10, x$11, x$14, (Option)x$12, x$13);
        log.appendAsLeader(MemoryRecords.withRecords((CompressionType)CompressionType.forId((int)messageCompressionCode.codec()), (int)0, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("hello".getBytes()), new SimpleRecord("there".getBytes())}), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5());
        if (!brokerCompression.equals("producer")) {
            CompressionCodec brokerCompressionCode = BrokerCompressionCodec$.MODULE$.getCompressionCodec(brokerCompression);
            Assertions.assertEquals((int)brokerCompressionCode.codec(), (int)BrokerCompressionTest.readBatch$1((int)0, (UnifiedLog)log).compressionType().id, (String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(brokerCompressionCode.name()).toString());
            return;
        }
        Assertions.assertEquals((int)messageCompressionCode.codec(), (int)BrokerCompressionTest.readBatch$1((int)0, (UnifiedLog)log).compressionType().id, (String)new StringBuilder(39).append("Compression at offset 0 should produce ").append(messageCompressionCode.name()).toString());
    }

    private static final RecordBatch readBatch$1(int offset, UnifiedLog log$1) {
        return (RecordBatch)log$1.read((long)offset, 4096, (FetchIsolation)FetchLogEnd$.MODULE$, true).records().batches().iterator().next();
    }
}

