/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.AppendOrigin;
import kafka.log.CompletedTxn;
import kafka.log.ProducerAppendInfo;
import kafka.log.ProducerStateEntry;
import kafka.log.ProducerStateEntry$;
import kafka.log.ProducerStateManager;
import kafka.log.ProducerStateManager$;
import kafka.log.SnapshotFile;
import kafka.log.TxnMetadata;
import kafka.log.TxnMetadata$;
import kafka.log.UnifiedLog$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidProducerEpochException;
import org.apache.kafka.common.errors.InvalidTxnStateException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.TransactionCoordinatorFencedException;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r\u0015a\u0001B(Q\u0001UCQ\u0001\u0018\u0001\u0005\u0002uCq\u0001\u0019\u0001A\u0002\u0013%\u0011\rC\u0004k\u0001\u0001\u0007I\u0011B6\t\rE\u0004\u0001\u0015)\u0003c\u0011\u001d\u0011\b\u00011A\u0005\nMDqa\u001e\u0001A\u0002\u0013%\u0001\u0010\u0003\u0004{\u0001\u0001\u0006K\u0001\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0003}\u0011\u001d\t\t\u0002\u0001Q\u0001\nuD\u0011\"a\u0005\u0001\u0005\u0004%I!!\u0006\t\u0011\u0005u\u0001\u0001)A\u0005\u0003/A\u0011\"a\b\u0001\u0005\u0004%I!!\t\t\u0011\u0005%\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000b\u0001\u0005\u0004%I!!\t\t\u0011\u00055\u0002\u0001)A\u0005\u0003GA\u0011\"a\f\u0001\u0005\u0004%I!!\t\t\u0011\u0005E\u0002\u0001)A\u0005\u0003GA\u0011\"a\r\u0001\u0005\u0004%I!!\u000e\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003oAq!!\u0012\u0001\t\u0003\t9\u0005C\u0004\u0002`\u0001!\t!a\u0012\t\u000f\u0005%\u0004\u0001\"\u0001\u0002H!9\u00111\u000f\u0001\u0005\u0002\u0005\u001d\u0003bBA<\u0001\u0011\u0005\u0011q\t\u0005\b\u0003w\u0002A\u0011AA$\u0011\u001d\ty\b\u0001C\u0001\u0003\u000fBq!a!\u0001\t\u0003\t9\u0005C\u0004\u0002\b\u0002!\t!a\u0012\t\u000f\u0005-\u0005\u0001\"\u0001\u0002H!9\u0011q\u0012\u0001\u0005\u0002\u0005\u001d\u0003bBAJ\u0001\u0011\u0005\u0011q\t\u0005\b\u0003/\u0003A\u0011AA$\u0011\u001d\tY\n\u0001C\u0001\u0003\u000fBq!a(\u0001\t\u0003\t9\u0005C\u0004\u0002$\u0002!\t!a\u0012\t\u000f\u0005\u001d\u0006\u0001\"\u0001\u0002H!9\u00111\u0016\u0001\u0005\u0002\u0005\u001d\u0003bBAX\u0001\u0011\u0005\u0011q\t\u0005\b\u0003g\u0003A\u0011AA$\u0011\u001d\t9\f\u0001C\u0001\u0003\u000fBq!a/\u0001\t\u0003\t9\u0005C\u0004\u0002@\u0002!\t!a\u0012\t\u000f\u0005\r\u0007\u0001\"\u0001\u0002H!9\u0011q\u0019\u0001\u0005\u0002\u0005\u001d\u0003bBAf\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u001f\u0004A\u0011AA$\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003\u000fBq!a6\u0001\t\u0003\t9\u0005C\u0004\u0002\\\u0002!\t!a\u0012\t\u000f\u0005}\u0007\u0001\"\u0001\u0002H!9\u00111\u001d\u0001\u0005\u0002\u0005\u001d\u0003bBAt\u0001\u0011\u0005\u0011q\t\u0005\b\u0003W\u0004A\u0011AA$\u0011\u001d\ty\u000f\u0001C\u0001\u0003\u000fBq!a=\u0001\t\u0003\t9\u0005C\u0004\u0002x\u0002!\t!a\u0012\t\u000f\u0005m\b\u0001\"\u0001\u0002H!9\u0011q \u0001\u0005\u0002\u0005\u001d\u0003b\u0002B\u0002\u0001\u0011\u0005\u0011q\t\u0005\b\u0005\u000f\u0001A\u0011AA$\u0011\u001d\u0011Y\u0001\u0001C\u0001\u0003\u000fBqAa\u0004\u0001\t\u0003\t9\u0005C\u0004\u0003\u0014\u0001!\t!a\u0012\t\u000f\t]\u0001\u0001\"\u0001\u0002H!9!1\u0004\u0001\u0005\u0002\u0005\u001d\u0003b\u0002B\u0010\u0001\u0011\u0005\u0011q\t\u0005\b\u0005G\u0001A\u0011AA$\u0011\u001d\u00119\u0003\u0001C\u0001\u0003\u000fBqAa\u000b\u0001\t\u0013\u0011i\u0003C\u0004\u0003J\u0001!IAa\u0013\t\u0013\t\u0015\u0005!%A\u0005\n\t\u001d\u0005\"\u0003BO\u0001E\u0005I\u0011\u0002BP\u0011\u001d\u0011\u0019\u000b\u0001C\u0005\u0005KC\u0011B!3\u0001#\u0003%IAa(\t\u0013\t-\u0007!%A\u0005\n\t5\u0007\"\u0003Bi\u0001E\u0005I\u0011\u0002Bj\u0011\u001d\u0011\u0019\u000b\u0001C\u0005\u0005/DqAa;\u0001\t\u0013\u0011iO\u0001\rQe>$WoY3s'R\fG/Z'b]\u0006<WM\u001d+fgRT!!\u0015*\u0002\u00071|wMC\u0001T\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\f\u0005\u0002`\u00015\t\u0001+\u0001\u0004m_\u001e$\u0015N]\u000b\u0002EB\u00111\r[\u0007\u0002I*\u0011QMZ\u0001\u0003S>T\u0011aZ\u0001\u0005U\u00064\u0018-\u0003\u0002jI\n!a)\u001b7f\u0003)awn\u001a#je~#S-\u001d\u000b\u0003Y>\u0004\"aV7\n\u00059D&\u0001B+oSRDq\u0001]\u0002\u0002\u0002\u0003\u0007!-A\u0002yIE\nq\u0001\\8h\t&\u0014\b%\u0001\u0007ti\u0006$X-T1oC\u001e,'/F\u0001u!\tyV/\u0003\u0002w!\n!\u0002K]8ek\u000e,'o\u0015;bi\u0016l\u0015M\\1hKJ\f\u0001c\u001d;bi\u0016l\u0015M\\1hKJ|F%Z9\u0015\u00051L\bb\u00029\u0007\u0003\u0003\u0005\r\u0001^\u0001\u000egR\fG/Z'b]\u0006<WM\u001d\u0011\u0002\u0013A\f'\u000f^5uS>tW#A?\u0011\u0007y\fi!D\u0001\u0000\u0015\u0011\t\t!a\u0001\u0002\r\r|W.\\8o\u0015\r\u0019\u0016Q\u0001\u0006\u0005\u0003\u000f\tI!\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0017\t1a\u001c:h\u0013\r\tya \u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u000baJ|G-^2fe&#WCAA\f!\r9\u0016\u0011D\u0005\u0004\u00037A&\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u00059R.\u0019=Ue\u0006t7/Y2uS>tG+[7f_V$Xj]\u000b\u0003\u0003G\u00012aVA\u0013\u0013\r\t9\u0003\u0017\u0002\u0004\u0013:$\u0018\u0001G7bqR\u0013\u0018M\\:bGRLwN\u001c+j[\u0016|W\u000f^'tA\u0005IR.\u0019=Qe>$WoY3s\u0013\u0012,\u0005\u0010]5sCRLwN\\'t\u0003ii\u0017\r\u001f)s_\u0012,8-\u001a:JI\u0016C\b/\u001b:bi&|g.T:!\u0003aa\u0017\r^3Ue\u0006t7/Y2uS>tG+[7f_V$Xj]\u0001\u001aY\u0006$X\r\u0016:b]N\f7\r^5p]RKW.Z8vi6\u001b\b%\u0001\u0003uS6,WCAA\u001c!\u0011\tI$a\u0010\u000e\u0005\u0005m\"bAA\u001f\u007f\u0006)Q\u000f^5mg&!\u0011\u0011IA\u001e\u0005!iunY6US6,\u0017!\u0002;j[\u0016\u0004\u0013!B:fiV\u0003H#\u00017)\u0007Q\tY\u0005\u0005\u0003\u0002N\u0005mSBAA(\u0015\u0011\t\t&a\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002V\u0005]\u0013a\u00026va&$XM\u001d\u0006\u0005\u00033\nI!A\u0003kk:LG/\u0003\u0003\u0002^\u0005=#A\u0003\"fM>\u0014X-R1dQ\u0006AA/Z1s\t><h\u000eK\u0002\u0016\u0003G\u0002B!!\u0014\u0002f%!\u0011qMA(\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\nuKN$()Y:jG&#W*\u00199qS:<\u0007f\u0001\f\u0002nA!\u0011QJA8\u0013\u0011\t\t(a\u0014\u0003\tQ+7\u000f^\u0001'i\u0016\u001cH/\u00119qK:$G\u000b\u001f8NCJ\\WM],ji\"tu\u000e\u0015:pIV\u001cWM]*uCR,\u0007fA\f\u0002n\u0005qB/Z:u!J|G-^2feN+\u0017/^3oG\u0016<&/\u00199Be>,h\u000e\u001a\u0015\u00041\u00055\u0014!\f;fgR\u0004&o\u001c3vG\u0016\u00148+Z9vK:\u001cWmV5uQ^\u0013\u0018\r]!s_VtGMQ1uG\"\u0014VmY8sI\"\u001a\u0011$!\u001c\u0002KQ,7\u000f\u001e)s_\u0012,8-\u001a:TKF,XM\\2f\u0013:4\u0018\r\\5e/J\f\u0007/\u0011:pk:$\u0007f\u0001\u000e\u0002n\u0005QC/Z:u\u001d>4\u0016\r\\5eCRLwN\\(o\r&\u00148\u000f^#oiJLx\u000b[3o\u0019>\fG-\u001b8h\u0019><\u0007fA\u000e\u0002n\u0005\u0019C/Z:u\u0007>tGO]8m%\u0016\u001cwN\u001d3Ck6\u00048\u000f\u0015:pIV\u001cWM]#q_\u000eD\u0007f\u0001\u000f\u0002n\u0005\u0001C/Z:u)btg)\u001b:ti>3gm]3u\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3eQ\ri\u0012QN\u0001\u001ai\u0016\u001cHoU6ja\u0016k\u0007\u000f^=Ue\u0006t7/Y2uS>t7\u000fK\u0002\u001f\u0003[\na\u0003^3ti\"\u000b7\u000fT1uKR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004?\u00055\u0014\u0001\f;fgRD\u0015m\u001d'bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8J]&$\u0018.\u00197ju\u0016$\u0017I\u001a;feJ+Gn\\1eQ\r\u0001\u0013QN\u00014i\u0016\u001cH\u000fS1t\u0019\u0006$X\r\u0016:b]N\f7\r^5p]V\u0003H-\u0019;fI\u00063G/\u001a:QCJ$\u0018.\u00197UeVt7-\u0019;j_:D3!IA7\u0003A\"Xm\u001d;ICNd\u0015\r^3Ue\u0006t7/Y2uS>tW\u000b\u001d3bi\u0016$\u0017I\u001a;fe\u001a+H\u000e\u001c+sk:\u001c\u0017\r^5p]\"\u001a!%!\u001c\u0002AQ,7\u000f\u001e'bgR\u001cF/\u00192mK>3gm]3u\u0007>l\u0007\u000f\\3uK\u0012$\u0006P\u001c\u0015\u0004G\u00055\u0014A\b;fgR\u0004&/\u001a9be\u0016,\u0006\u000fZ1uK\u0012{Wm\u001d(pi6+H/\u0019;fQ\r!\u0013QN\u0001\u001fkB$\u0017\r^3Qe>$WoY3s)J\fgn]1di&|gn\u0015;bi\u0016D3!JA7\u00031\"Xm\u001d;PkR|emU3rk\u0016t7-Z!gi\u0016\u00148i\u001c8ue>d'+Z2pe\u0012,\u0005o\\2i\u0005Vl\u0007\u000fK\u0002'\u0003[\n\u0001\u0007^3ti:{g\u000e\u0016:b]N\f7\r^5p]\u0006d\u0017\t\u001d9f]\u0012<\u0016\u000e\u001e5P]\u001e|\u0017N\\4Ue\u0006t7/Y2uS>t\u0007fA\u0014\u0002n\u0005yC/Z:u)J,hnY1uK\u0006sGMU3m_\u0006$'+Z7pm\u0016\u001cx*\u001e;PMJ\u000bgnZ3T]\u0006\u00048\u000f[8ug\"\u001a\u0001&!\u001c\u0002!Q,7\u000f\u001e+bW\u0016\u001cf.\u00199tQ>$\bfA\u0015\u0002n\u0005aC/Z:u%\u0016\u001cwN^3s\rJ|Wn\u00158baNDw\u000e^+oM&t\u0017n\u001d5fIR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004U\u00055\u0014A\u000b;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u\r&t\u0017n\u001d5fIR\u0013\u0018M\\:bGRLwN\u001c\u0015\u0004W\u00055\u0014a\n;fgR\u0014VmY8wKJ4%o\\7T]\u0006\u00048\u000f[8u\u000b6\u0004H/\u001f+sC:\u001c\u0018m\u0019;j_:D3\u0001LA7\u0003!\"Xm\u001d;Qe>$WoY3s'R\fG/Z!gi\u0016\u0014h)\u001a8dS:<\u0017IY8si6\u000b'o[3sQ\ri\u0013QN\u0001\u001ei\u0016\u001cHOU3n_Z,W\t\u001f9je\u0016$\u0007+\u001b3t\u001f:\u0014V\r\\8bI\"\u001aa&!\u001c\u0002[Q,7\u000f^!dG\u0016\u0004H/\u00119qK:$w+\u001b;i_V$\bK]8ek\u000e,'o\u0015;bi\u0016|eNU3qY&\u001c\u0017\rK\u00020\u0003[\n\u0011\u0006^3ti\u0006\u001b7-\u001a9u\u0003B\u0004XM\u001c3XSRD7+Z9vK:\u001cWmR1qg>s'+\u001a9mS\u000e\f\u0007f\u0001\u0019\u0002n\u0005IB/Z:u\t\u0016dW\r^3T]\u0006\u00048\u000f[8ug\n+gm\u001c:fQ\r\t\u0014QN\u0001\u001ci\u0016\u001cH\u000f\u0016:v]\u000e\fG/\u001a$vY2L\u0018I\u001c3Ti\u0006\u0014H/\u0011;)\u0007I\ni'\u0001\u0014uKN$h)\u001b:tiVs7\u000f^1cY\u0016|eMZ:fi\u00063G/\u001a:UeVt7-\u0019;j_:D3aMA7\u00039\"Xm\u001d;M_\u0006$gI]8n':\f\u0007o\u001d5piJ+G/Y5og:{g.\u0012=qSJ,G\r\u0015:pIV\u001cWM]:)\u0007Q\ni'A\u0011uKN$8k[5q':\f\u0007o\u001d5pi&3wJ\u001a4tKR,fn\u00195b]\u001e,G\rK\u00026\u0003[\n\u0001\u0004^3tiBKG-\u0012=qSJ\fG/[8o)&lWm\\;uQ\r1\u0014QN\u0001\u0018i\u0016\u001cHOR5sgR,fn\u001d;bE2,wJ\u001a4tKRD3aNA7\u00039\"Xm\u001d;Qe>$WoY3sg^KG\u000f[(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\u001cHi\u001c8u\u000bb\u0004\u0018N]3)\u0007a\ni'A\u0017uKN$8+Z9vK:\u001cWMT8u-\u0006d\u0017\u000eZ1uK\u00124uN]$s_V\u0004X*\u001a;bI\u0006$\u0018\rV8qS\u000eD3!OA7\u0003q!Xm\u001d;PY\u0012,\u0005o\\2i\r>\u00148i\u001c8ue>d'+Z2pe\u0012D3AOA7\u0003Y!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)\u001a8dS:<\u0007fA\u001e\u0002n\u0005\u0001C/Z:u\u0007>|'\u000fZ5oCR|'OR3oG\u0016$\u0017I\u001a;feJ+Gn\\1eQ\ra\u0014QN\u0001\u001ei\u0016\u001cH\u000fT8bI\u001a\u0013x.\\#naRL8K\\1qg\"|GOR5mK\"\u001aQ(!\u001c\u0002CQ,7\u000f\u001e'pC\u00124%o\\7UeVt7-\u0019;fINs\u0017\r]:i_R4\u0015\u000e\\3)\u0007y\ni'A\u0010uKN$Hj\\1e\rJ|WnQ8seV\u0004Ho\u00158baNDw\u000e\u001e$jY\u0016D3aPA7\u0003m!Xm\u001d;BaB,g\u000eZ#naRL8i\u001c8ue>d')\u0019;dQ\"\u001a\u0001)!\u001c\u0002cQ,7\u000f\u001e*f[>4Xm\u0015;sCf\u001cf.\u00199tQ>$8oS3fa\u000ecW-\u00198TQV$Hm\\<o':\f\u0007o\u001d5pi\"\u001a\u0011)!\u001c\u00027Q,7\u000f\u001e*f[>4X-\u00117m'R\u0014\u0018-_*oCB\u001c\bn\u001c;tQ\r\u0011\u0015QN\u0001%i\u0016\u001cHOU3n_Z,\u0017I\u001c3NCJ\\7K\\1qg\"|GOR8s\t\u0016dW\r^5p]\"\u001a1)!\u001c\u0002eQ,7\u000f\u001e*f[>4X-\u00118e\u001b\u0006\u00148n\u00158baNDw\u000e\u001e$pe\u0012+G.\u001a;j_:\fEN]3bIf$U\r\\3uK\u0012D3\u0001RA7\u0003m!Xm\u001d;M_\u0006$gI]8n\u0007>\u0014(/\u001e9u':\f\u0007o\u001d5piR\u0019ANa\f\t\u000f\tER\t1\u0001\u00034\u0005yQ.Y6f\r&dWmQ8seV\u0004H\u000f\u0005\u0004X\u0005k\u0011I\u0004\\\u0005\u0004\u0005oA&!\u0003$v]\u000e$\u0018n\u001c82!\u0011\u0011YD!\u0012\u000e\u0005\tu\"\u0002\u0002B \u0005\u0003\n\u0001b\u00195b]:,Gn\u001d\u0006\u0004\u0005\u00072\u0017a\u00018j_&!!q\tB\u001f\u0005-1\u0015\u000e\\3DQ\u0006tg.\u001a7\u0002%\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u000b\u0011\u0005\u001b\u0012IF!\u0018\u0003`\t%$\u0011\u0010B?\u0005\u0003\u0003Ra\u0016B(\u0005'J1A!\u0015Y\u0005\u0019y\u0005\u000f^5p]B\u0019qL!\u0016\n\u0007\t]\u0003K\u0001\u0007D_6\u0004H.\u001a;fIRCh\u000e\u0003\u0004\u0003\\\u0019\u0003\r\u0001^\u0001\b[\u0006\u0004\b/\u001b8h\u0011\u001d\t\u0019B\u0012a\u0001\u0003/AqA!\u0019G\u0001\u0004\u0011\u0019'A\u0007qe>$WoY3s\u000bB|7\r\u001b\t\u0004/\n\u0015\u0014b\u0001B41\n)1\u000b[8si\"9!1\u000e$A\u0002\t5\u0014aC2p]R\u0014x\u000e\u001c+za\u0016\u0004BAa\u001c\u0003v5\u0011!\u0011\u000f\u0006\u0004\u0005gz\u0018A\u0002:fG>\u0014H-\u0003\u0003\u0003x\tE$!E\"p]R\u0014x\u000e\u001c*fG>\u0014H\rV=qK\"9!1\u0010$A\u0002\u0005]\u0011AB8gMN,G\u000fC\u0005\u0003\u0000\u0019\u0003\n\u00111\u0001\u0002$\u0005\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r\u001b\u0005\n\u0005\u00073\u0005\u0013!a\u0001\u0003/\t\u0011\u0002^5nKN$\u0018-\u001c9\u00029\u0005\u0004\b/\u001a8e\u000b:$G\u000b\u001f8NCJ\\WM\u001d\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011\u0012\u0016\u0005\u0003G\u0011Yi\u000b\u0002\u0003\u000eB!!q\u0012BM\u001b\t\u0011\tJ\u0003\u0003\u0003\u0014\nU\u0015!C;oG\",7m[3e\u0015\r\u00119\nW\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002BN\u0005#\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003q\t\u0007\u000f]3oI\u0016sG\r\u0016=o\u001b\u0006\u00148.\u001a:%I\u00164\u0017-\u001e7uI]*\"A!)+\t\u0005]!1R\u0001\u0007CB\u0004XM\u001c3\u0015#1\u00149K!+\u0003,\n5&\u0011\u0017BZ\u0005k\u0013y\fC\u0003s\u0013\u0002\u0007A\u000fC\u0004\u0002\u0014%\u0003\r!a\u0006\t\u000f\t\u0005\u0014\n1\u0001\u0003d!9!qV%A\u0002\u0005\r\u0012aA:fc\"9!1P%A\u0002\u0005]\u0001\"\u0003BB\u0013B\u0005\t\u0019AA\f\u0011%\u00119,\u0013I\u0001\u0002\u0004\u0011I,A\bjgR\u0013\u0018M\\:bGRLwN\\1m!\r9&1X\u0005\u0004\u0005{C&a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005\u0003L\u0005\u0013!a\u0001\u0005\u0007\faa\u001c:jO&t\u0007cA0\u0003F&\u0019!q\u0019)\u0003\u0019\u0005\u0003\b/\u001a8e\u001fJLw-\u001b8\u0002!\u0005\u0004\b/\u001a8eI\u0011,g-Y;mi\u00122\u0014\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00138+\t\u0011yM\u000b\u0003\u0003:\n-\u0015\u0001E1qa\u0016tG\r\n3fM\u0006,H\u000e\u001e\u00139+\t\u0011)N\u000b\u0003\u0003D\n-Ec\u00037\u0003Z\nm'Q\u001cBp\u0005SDQA]'A\u0002QDq!a\u0005N\u0001\u0004\t9\u0002C\u0004\u0003|5\u0003\r!a\u0006\t\u000f\t\u0005X\n1\u0001\u0003d\u0006)!-\u0019;dQB!!q\u000eBs\u0013\u0011\u00119O!\u001d\u0003\u0017I+7m\u001c:e\u0005\u0006$8\r\u001b\u0005\b\u0005\u0003l\u0005\u0019\u0001Bb\u0003Y\u0019WO\u001d:f]R\u001cf.\u00199tQ>$xJ\u001a4tKR\u001cXC\u0001Bx!\u0019\u0011\tPa@\u0002\u00189!!1\u001fB~!\r\u0011)\u0010W\u0007\u0003\u0005oT1A!?U\u0003\u0019a$o\\8u}%\u0019!Q -\u0002\rA\u0013X\rZ3g\u0013\u0011\u0019\taa\u0001\u0003\u0007M+GOC\u0002\u0003~b\u0003")
public class ProducerStateManagerTest {
    private File logDir = null;
    private ProducerStateManager stateManager = null;
    private final TopicPartition partition = new TopicPartition("test", 0);
    private final long producerId;
    private final int maxTransactionTimeoutMs;
    private final int maxProducerIdExpirationMs;
    private final int lateTransactionTimeoutMs = this.maxTransactionTimeoutMs() + ProducerStateManager$.MODULE$.LateTransactionBufferMs();
    private final MockTime time = new MockTime();

    private File logDir() {
        return this.logDir;
    }

    private void logDir_$eq(File x$1) {
        this.logDir = x$1;
    }

    private ProducerStateManager stateManager() {
        return this.stateManager;
    }

    private void stateManager_$eq(ProducerStateManager x$1) {
        this.stateManager = x$1;
    }

    private TopicPartition partition() {
        return this.partition;
    }

    private long producerId() {
        return this.producerId;
    }

    private int maxTransactionTimeoutMs() {
        return this.maxTransactionTimeoutMs;
    }

    private int maxProducerIdExpirationMs() {
        return this.maxProducerIdExpirationMs;
    }

    private int lateTransactionTimeoutMs() {
        return this.lateTransactionTimeoutMs;
    }

    private MockTime time() {
        return this.time;
    }

    @BeforeEach
    public void setUp() {
        this.logDir_$eq(TestUtils$.MODULE$.tempDir());
        this.stateManager_$eq(new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time()));
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.logDir());
    }

    @Test
    public void testBasicIdMapping() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, 0L, 1L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 5, 0L, 2L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), (short)(epoch + 1), 0, 0L, 3L, this.append$default$7(), this.append$default$8());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testAppendTxnMarkerWithNoProducerState() {
        short producerEpoch = (short)2;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 27L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry firstEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)firstEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)firstEntry.producerId());
        Assertions.assertEquals((int)-1, (int)firstEntry.lastSeq());
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.append(this.stateManager(), this.producerId(), (short)0, 0, 0L, 4L, this.append$default$7(), this.append$default$8()));
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), producerEpoch, 17, 0L, 4L, this.append$default$7(), this.append$default$8()));
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 39L, 4L, this.append$default$7(), this.append$default$8());
        ProducerStateEntry secondEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new RuntimeException("Expected last entry to be defined");
        });
        Assertions.assertEquals((short)producerEpoch, (short)secondEntry.producerEpoch());
        Assertions.assertEquals((long)this.producerId(), (long)secondEntry.producerId());
        Assertions.assertEquals((int)0, (int)secondEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        this.append(this.stateManager(), this.producerId(), epoch, 0, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)0, (int)lastEntry.lastSeq());
    }

    @Test
    public void testProducerSequenceWithWrapAroundBatchRecord() {
        short epoch = (short)15;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Replication$.MODULE$);
        appendInfo.appendDataBatch(epoch, 0x7FFFFFF5, 9, this.time().milliseconds(), new LogOffsetMetadata(2000L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 2020L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0x7FFFFFF5, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)9, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)2000L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)2020L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void testProducerSequenceInvalidWrapAround() {
        short epoch = (short)15;
        int sequence = Integer.MAX_VALUE;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> this.append(this.stateManager(), this.producerId(), epoch, 1, offset + 500L, this.append$default$6(), this.append$default$7(), this.append$default$8()));
    }

    @Test
    public void testNoValidationOnFirstEntryWhenLoadingLog() {
        short epoch = (short)5;
        int sequence = 16;
        long offset = 735L;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        AppendOrigin.Replication$ x$6 = AppendOrigin.Replication$.MODULE$;
        long x$7 = this.append$default$6();
        boolean x$8 = this.append$default$7();
        this.append(x$1, x$2, epoch, sequence, offset, x$7, x$8, (AppendOrigin)x$6);
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)epoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)offset, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)offset, (long)lastEntry.firstDataOffset());
    }

    @Test
    public void testControlRecordBumpsProducerEpoch() {
        short producerEpoch = (short)0;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        short bumpedProducerEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedProducerEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Option maybeLastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertTrue((boolean)maybeLastEntry.isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)maybeLastEntry.get();
        Assertions.assertEquals((short)bumpedProducerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((int)-1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)-1, (int)lastEntry.lastSeq());
        this.append(this.stateManager(), this.producerId(), bumpedProducerEpoch, 0, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)this.stateManager().lastEntry(this.producerId()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.firstSeq())));
    }

    @Test
    public void testTxnFirstOffsetMetadataCached() {
        short producerEpoch = (short)0;
        long offset = 992342L;
        int seq = 0;
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), this.producerId(), ProducerStateEntry$.MODULE$.empty(this.producerId()), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(offset, 990000L, 234224);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, this.time().milliseconds(), firstOffsetMetadata, offset, true);
        this.stateManager().update(producerAppendInfo);
        Assertions.assertEquals((Object)new Some((Object)firstOffsetMetadata), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testSkipEmptyTransactions() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 27;
        AtomicInteger seq = new AtomicInteger(0);
        ProducerAppendInfo firstAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        this.appendData$1(16L, 20L, firstAppend, producerEpoch, seq);
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), 16L), (Object)firstAppend.startedTransactions().head());
        this.stateManager().update(firstAppend);
        this.stateManager().onHighWatermarkUpdated(21L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
        ProducerAppendInfo secondAppend = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Option firstCompletedTxn = this.appendEndTxn$1(ControlRecordType.COMMIT, 21L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertEquals((Object)new Some((Object)new CompletedTxn(this.producerId(), 16L, 21L, false)), (Object)firstCompletedTxn);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.COMMIT, 22L, secondAppend, coordinatorEpoch, producerEpoch));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 23L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(24L, 27L, secondAppend, producerEpoch, seq);
        Option secondCompletedTxn = this.appendEndTxn$1(ControlRecordType.ABORT, 28L, secondAppend, coordinatorEpoch, producerEpoch);
        Assertions.assertTrue((boolean)secondCompletedTxn.isDefined());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.appendEndTxn$1(ControlRecordType.ABORT, 29L, secondAppend, coordinatorEpoch, producerEpoch));
        this.appendData$1(30L, 31L, secondAppend, producerEpoch, seq);
        Assertions.assertEquals((int)2, (int)secondAppend.startedTransactions().size());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(24L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), TxnMetadata$.MODULE$.apply$default$3()), (Object)secondAppend.startedTransactions().head());
        Assertions.assertEquals((Object)new TxnMetadata(this.producerId(), new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), TxnMetadata$.MODULE$.apply$default$3()), (Object)secondAppend.startedTransactions().last());
        this.stateManager().update(secondAppend);
        this.stateManager().completeTxn((CompletedTxn)firstCompletedTxn.get());
        this.stateManager().completeTxn((CompletedTxn)secondCompletedTxn.get());
        this.stateManager().onHighWatermarkUpdated(32L);
        Assertions.assertEquals((Object)new Some((Object)new LogOffsetMetadata(30L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())), (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testHasLateTransaction() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId1, epoch1, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        int x$12 = 0;
        long x$13 = 150L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, producerId2, epoch2, x$12, x$13, x$15, x$14, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() - 500 + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId1, epoch1, ControlRecordType.COMMIT, 200L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.appendEndTxnMarker(this.stateManager(), producerId2, epoch2, ControlRecordType.COMMIT, 250L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionInitializedAfterReload() {
        long producerId1 = 39L;
        short epoch1 = (short)2;
        long producerId2 = 57L;
        short epoch2 = (short)9;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId1, epoch1, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep(500L);
        ProducerStateManager x$9 = this.stateManager();
        int x$12 = 0;
        long x$13 = 150L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, producerId2, epoch2, x$12, x$13, x$15, x$14, x$16);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().takeSnapshot();
        this.time().sleep((long)(this.lateTransactionTimeoutMs() - 500 + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, this.stateManager().mapEndOffset(), this.time().milliseconds());
        Assertions.assertTrue((boolean)reloadedStateManager.hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterPartialTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateAndReload(0L, 80L, this.time().milliseconds());
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testHasLateTransactionUpdatedAfterFullTruncation() {
        long producerId = 39L;
        short epoch = (short)2;
        ProducerStateManager x$1 = this.stateManager();
        int x$4 = 0;
        long x$5 = 100L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, producerId, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.time().sleep((long)(this.lateTransactionTimeoutMs() + 1));
        Assertions.assertTrue((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
        this.stateManager().truncateFullyAndStartAt(150L);
        Assertions.assertFalse((boolean)this.stateManager().hasLateTransaction(this.time().milliseconds()));
    }

    @Test
    public void testLastStableOffsetCompletedTxn() {
        short producerEpoch = (short)0;
        long segmentBaseOffset = 990000L;
        long producerId1 = this.producerId();
        long startOffset1 = 992342L;
        this.beginTxn$1(producerId1, startOffset1, segmentBaseOffset, producerEpoch);
        long producerId2 = this.producerId() + 1L;
        long startOffset2 = startOffset1 + 25L;
        this.beginTxn$1(producerId2, startOffset2, segmentBaseOffset, producerEpoch);
        long producerId3 = this.producerId() + 2L;
        long startOffset3 = startOffset1 + 57L;
        this.beginTxn$1(producerId3, startOffset3, segmentBaseOffset, producerEpoch);
        long lastOffset1 = startOffset3 + 15L;
        CompletedTxn completedTxn1 = new CompletedTxn(producerId1, startOffset1, lastOffset1, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn1));
        this.stateManager().completeTxn(completedTxn1);
        this.stateManager().onHighWatermarkUpdated(lastOffset1 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.messageOffset())));
        long lastOffset3 = lastOffset1 + 20L;
        CompletedTxn completedTxn3 = new CompletedTxn(producerId3, startOffset3, lastOffset3, false);
        Assertions.assertEquals((long)startOffset2, (long)this.stateManager().lastStableOffset(completedTxn3));
        this.stateManager().completeTxn(completedTxn3);
        this.stateManager().onHighWatermarkUpdated(lastOffset3 + 1L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)startOffset2)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.messageOffset())));
        long lastOffset2 = lastOffset3 + 78L;
        CompletedTxn completedTxn2 = new CompletedTxn(producerId2, startOffset2, lastOffset2, false);
        Assertions.assertEquals((long)(lastOffset2 + 1L), (long)this.stateManager().lastStableOffset(completedTxn2));
        this.stateManager().completeTxn(completedTxn2);
        this.stateManager().onHighWatermarkUpdated(lastOffset2 + 1L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset());
    }

    @Test
    public void testPrepareUpdateDoesNotMutate() {
        short producerEpoch = (short)0;
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 0, 5, this.time().milliseconds(), new LogOffsetMetadata(15L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, false);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().lastEntry(this.producerId()));
        this.stateManager().update(appendInfo);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerAppendInfo nextAppendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        nextAppendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, false);
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        this.stateManager().update(nextAppendInfo);
        lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((int)0, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
    }

    @Test
    public void updateProducerTransactionState() {
        short producerEpoch = (short)0;
        int coordinatorEpoch = 15;
        long offset = 9L;
        this.append(this.stateManager(), this.producerId(), producerEpoch, 0, offset, this.append$default$6(), this.append$default$7(), this.append$default$8());
        ProducerAppendInfo appendInfo = this.stateManager().prepareUpdate(this.producerId(), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        appendInfo.appendDataBatch(producerEpoch, 1, 5, this.time().milliseconds(), new LogOffsetMetadata(16L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 20L, true);
        ProducerStateEntry lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)5, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)20L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        appendInfo.appendDataBatch(producerEpoch, 6, 10, this.time().milliseconds(), new LogOffsetMetadata(26L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), 30L, true);
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)16L)), (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, coordinatorEpoch);
        Option completedTxnOpt = appendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, 40L, this.time().milliseconds());
        Assertions.assertTrue((boolean)completedTxnOpt.isDefined());
        CompletedTxn completedTxn = (CompletedTxn)completedTxnOpt.get();
        Assertions.assertEquals((long)this.producerId(), (long)completedTxn.producerId());
        Assertions.assertEquals((long)16L, (long)completedTxn.firstOffset());
        Assertions.assertEquals((long)40L, (long)completedTxn.lastOffset());
        Assertions.assertFalse((boolean)completedTxn.isAborted());
        lastEntry = appendInfo.toEntry();
        Assertions.assertEquals((short)producerEpoch, (short)lastEntry.producerEpoch());
        Assertions.assertEquals((int)1, (int)lastEntry.firstSeq());
        Assertions.assertEquals((int)10, (int)lastEntry.lastSeq());
        Assertions.assertEquals((long)16L, (long)lastEntry.firstDataOffset());
        Assertions.assertEquals((long)30L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((int)coordinatorEpoch, (int)lastEntry.coordinatorEpoch());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((Object)new .colon.colon((Object)new TxnMetadata(this.producerId(), 16L), (List)Nil$.MODULE$), (Object)appendInfo.startedTransactions());
    }

    @Test
    public void testOutOfSequenceAfterControlRecordEpochBump() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        short bumpedEpoch = (short)1;
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), bumpedEpoch, ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$17 = this.stateManager();
            long x$18 = this.producerId();
            int x$20 = 2;
            long x$21 = 2L;
            boolean x$22 = true;
            long x$23 = this.append$default$6();
            AppendOrigin x$24 = this.append$default$8();
            this.append(x$17, x$18, bumpedEpoch, x$20, x$21, x$23, x$22, x$24);
        });
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$25 = this.stateManager();
            long x$26 = this.producerId();
            short x$27 = (short)(bumpedEpoch + 1);
            int x$28 = 2;
            long x$29 = 2L;
            boolean x$30 = true;
            long x$31 = this.append$default$6();
            AppendOrigin x$32 = this.append$default$8();
            this.append(x$25, x$26, x$27, x$28, x$29, x$31, x$30, x$32);
        });
        ProducerStateManager x$33 = this.stateManager();
        long x$34 = this.producerId();
        int x$36 = 0;
        long x$37 = 0L;
        boolean x$38 = true;
        long x$39 = this.append$default$6();
        AppendOrigin x$40 = this.append$default$8();
        this.append(x$33, x$34, bumpedEpoch, x$36, x$37, x$39, x$38, x$40);
        Assertions.assertEquals((short)bumpedEpoch, (short)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).producerEpoch());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get()).lastSeq());
    }

    @Test
    public void testNonTransactionalAppendWithOngoingTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidTxnStateException.class, () -> {
            ProducerStateManager x$9 = this.stateManager();
            long x$10 = this.producerId();
            int x$12 = 1;
            long x$13 = 1L;
            boolean x$14 = false;
            long x$15 = this.append$default$6();
            AppendOrigin x$16 = this.append$default$8();
            this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        });
    }

    @Test
    public void testTruncateAndReloadRemovesOutOfRangeSnapshots() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 3, 3L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, 4, 4L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.stateManager().truncateAndReload(1L, 3L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)3L)), (Object)this.stateManager().latestSnapshotOffset());
    }

    @Test
    public void testTakeSnapshot() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().list().length, (String)"Directory doesn't contain a single file as expected");
        Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().list())).head())).nonEmpty(), (String)"Snapshot file is empty");
    }

    @Test
    public void testRecoverFromSnapshotUnfinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
        long x$18 = this.producerId();
        int x$20 = 2;
        long x$21 = 2L;
        boolean x$22 = true;
        long x$23 = this.append$default$6();
        AppendOrigin x$24 = this.append$default$8();
        this.append(recoveredMapping, x$18, epoch, x$20, x$21, x$23, x$22, x$24);
    }

    @Test
    public void testRecoverFromSnapshotFinishedTransaction() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        int x$12 = 1;
        long x$13 = 1L;
        boolean x$14 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$9, x$10, epoch, x$12, x$13, x$15, x$14, x$16);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.ABORT, 2L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 3L, this.time().milliseconds());
        Option loadedEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).firstDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).firstSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)loadedEntry.get()).lastDataOffset());
        Assertions.assertEquals((int)1, (int)((ProducerStateEntry)loadedEntry.get()).lastSeq());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)loadedEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testRecoverFromSnapshotEmptyTransaction() {
        short epoch = (short)0;
        long appendTimestamp = this.time().milliseconds();
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        ControlRecordType x$4 = ControlRecordType.ABORT;
        long x$5 = 0L;
        int x$7 = this.appendEndTxnMarker$default$6();
        this.appendEndTxnMarker(x$1, x$2, epoch, x$4, x$5, x$7, appendTimestamp);
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, this.time().milliseconds());
        Option lastEntry = recoveredMapping.lastEntry(this.producerId());
        Assertions.assertTrue((boolean)lastEntry.isDefined());
        Assertions.assertEquals((long)appendTimestamp, (long)((ProducerStateEntry)lastEntry.get()).lastTimestamp());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)lastEntry.get()).currentTxnFirstOffset());
    }

    @Test
    public void testProducerStateAfterFencingAbortMarker() {
        short epoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 0L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)(epoch + 1), ControlRecordType.ABORT, 1L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        ProducerStateEntry lastEntry = (ProducerStateEntry)this.stateManager().lastEntry(this.producerId()).get();
        Assertions.assertEquals((Object)None$.MODULE$, (Object)lastEntry.currentTxnFirstOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.lastDataOffset());
        Assertions.assertEquals((long)-1L, (long)lastEntry.firstDataOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testRemoveExpiredPidsOnReload() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        this.append(recoveredMapping, this.producerId(), epoch, 2, 2L, 70001L, this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)recoveredMapping.activeProducers().size());
        Assertions.assertEquals((int)2, (int)((ProducerStateEntry)((Tuple2)recoveredMapping.activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)recoveredMapping.mapEndOffset());
    }

    @Test
    public void testAcceptAppendWithoutProducerStateOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, 1L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        ProducerStateManager recoveredMapping = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        recoveredMapping.truncateAndReload(0L, 1L, 70000L);
        int sequence = 2;
        Assertions.assertFalse((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        long x$2 = this.producerId();
        long x$5 = 2L;
        long x$6 = 70001L;
        AppendOrigin.Replication$ x$7 = AppendOrigin.Replication$.MODULE$;
        boolean x$8 = this.append$default$7();
        this.append(recoveredMapping, x$2, epoch, sequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        Assertions.assertTrue((boolean)recoveredMapping.activeProducers().contains((Object)BoxesRunTime.boxToLong((long)this.producerId())));
        ProducerStateEntry producerStateEntry = (ProducerStateEntry)Option$.MODULE$.option2Iterable(recoveredMapping.activeProducers().get((Object)BoxesRunTime.boxToLong((long)this.producerId()))).head();
        Assertions.assertEquals((short)epoch, (short)producerStateEntry.producerEpoch());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.firstSeq());
        Assertions.assertEquals((int)sequence, (int)producerStateEntry.lastSeq());
    }

    @Test
    public void testAcceptAppendWithSequenceGapsOnReplica() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        int outOfOrderSequence = 3;
        Assertions.assertThrows(OutOfOrderSequenceException.class, () -> {
            ProducerStateManager x$1 = this.stateManager();
            long x$2 = this.producerId();
            long x$5 = 1L;
            long x$6 = 1L;
            AppendOrigin.Client$ x$7 = AppendOrigin.Client$.MODULE$;
            boolean x$8 = this.append$default$7();
            this.append(x$1, x$2, epoch, outOfOrderSequence, x$5, x$6, x$8, (AppendOrigin)x$7);
        });
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
        ProducerStateManager x$9 = this.stateManager();
        long x$10 = this.producerId();
        long x$13 = 1L;
        long x$14 = 1L;
        AppendOrigin.Replication$ x$15 = AppendOrigin.Replication$.MODULE$;
        boolean x$16 = this.append$default$7();
        this.append(x$9, x$10, epoch, outOfOrderSequence, x$13, x$14, x$16, (AppendOrigin)x$15);
        Assertions.assertEquals((int)outOfOrderSequence, (int)((ProducerStateEntry)this.stateManager().activeProducers().apply((Object)BoxesRunTime.boxToLong((long)this.producerId()))).lastSeq());
    }

    @Test
    public void testDeleteSnapshotsBefore() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(3L);
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), this.currentSnapshotOffsets());
        this.stateManager().deleteSnapshotsBefore(4L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), this.producerId(), epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 2, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), this.currentSnapshotOffsets());
        this.stateManager().truncateFullyAndStartAt(0L);
        Assertions.assertEquals((int)0, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), this.currentSnapshotOffsets());
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testFirstUnstableOffsetAfterTruncation() {
        short epoch = (short)0;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$52 = 99L;
        boolean x$62 = true;
        long x$72 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$52, x$72, x$62, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToLong((long)x$4.messageOffset())));
        this.stateManager().takeSnapshot();
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 105L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        this.stateManager().onHighWatermarkUpdated(106L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.messageOffset())));
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 106L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().truncateAndReload(0L, 106L, this.time().milliseconds());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.messageOffset())));
        this.stateManager().truncateAndReload(0L, 100L, this.time().milliseconds());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)99)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.messageOffset())));
    }

    @Test
    public void testLoadFromSnapshotRetainsNonExpiredProducers() {
        short epoch = (short)0;
        long pid1 = 1L;
        long pid2 = 2L;
        this.append(this.stateManager(), pid1, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.append(this.stateManager(), pid2, epoch, 0, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        this.stateManager().truncateAndReload(1L, 2L, this.time().milliseconds());
        Assertions.assertEquals((int)2, (int)this.stateManager().activeProducers().size());
        Option entry1 = this.stateManager().lastEntry(pid1);
        Assertions.assertTrue((boolean)entry1.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry1.get()).lastSeq());
        Assertions.assertEquals((long)0L, (long)((ProducerStateEntry)entry1.get()).lastDataOffset());
        Option entry2 = this.stateManager().lastEntry(pid2);
        Assertions.assertTrue((boolean)entry2.isDefined());
        Assertions.assertEquals((int)0, (int)((ProducerStateEntry)entry2.get()).lastSeq());
        Assertions.assertEquals((long)1L, (long)((ProducerStateEntry)entry2.get()).lastDataOffset());
    }

    @Test
    public void testSkipSnapshotIfOffsetUnchanged() {
        short epoch = (short)0;
        this.append(this.stateManager(), this.producerId(), epoch, 0, 0L, 0L, this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
        this.stateManager().takeSnapshot();
        Assertions.assertEquals((int)1, (int)this.logDir().listFiles().length);
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), this.currentSnapshotOffsets());
    }

    @Test
    public void testPidExpirationTimeout() {
        short epoch = (short)5;
        int sequence = 37;
        this.append(this.stateManager(), this.producerId(), epoch, sequence, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.time().sleep((long)(this.maxProducerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        this.append(this.stateManager(), this.producerId(), epoch, sequence + 1, 2L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        Assertions.assertEquals((int)1, (int)this.stateManager().activeProducers().size());
        Assertions.assertEquals((int)(sequence + 1), (int)((ProducerStateEntry)((Tuple2)this.stateManager().activeProducers().head())._2()).lastSeq());
        Assertions.assertEquals((long)3L, (long)this.stateManager().mapEndOffset());
    }

    @Test
    public void testFirstUnstableOffset() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$82 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$82);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.messageOffset())));
        long anotherPid = 2L;
        ProducerStateManager x$92 = this.stateManager();
        long x$132 = 105L;
        boolean x$142 = true;
        long x$15 = this.append$default$6();
        AppendOrigin x$16 = this.append$default$8();
        this.append(x$92, anotherPid, epoch, sequence, x$132, x$15, x$142, x$16);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 109L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(100L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(110L);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.messageOffset())));
        this.appendEndTxnMarker(this.stateManager(), anotherPid, epoch, ControlRecordType.ABORT, 112L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)105L)), (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.messageOffset())));
        this.stateManager().onHighWatermarkUpdated(113L);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUnstableOffset().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.messageOffset())));
    }

    @Test
    public void testProducersWithOngoingTransactionsDontExpire() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.time().sleep((long)(this.maxProducerIdExpirationMs() + 1));
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)99L)), (Object)this.stateManager().firstUndecidedOffset());
        this.stateManager().removeExpiredProducers(this.time().milliseconds());
        Assertions.assertTrue((boolean)this.stateManager().lastEntry(this.producerId()).isDefined());
    }

    @Test
    public void testSequenceNotValidatedForGroupMetadataTopic() {
        TopicPartition partition = new TopicPartition("__consumer_offsets", 0);
        ProducerStateManager stateManager = new ProducerStateManager(partition, this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        short epoch = (short)0;
        long x$2 = this.producerId();
        int x$4 = -1;
        long x$5 = 99L;
        boolean x$6 = true;
        AppendOrigin.Coordinator$ x$7 = AppendOrigin.Coordinator$.MODULE$;
        long x$8 = this.append$default$6();
        this.append(stateManager, x$2, epoch, x$4, x$5, x$8, x$6, (AppendOrigin)x$7);
        long x$10 = this.producerId();
        int x$12 = -1;
        long x$13 = 100L;
        boolean x$14 = true;
        AppendOrigin.Coordinator$ x$15 = AppendOrigin.Coordinator$.MODULE$;
        long x$16 = this.append$default$6();
        this.append(stateManager, x$10, epoch, x$12, x$13, x$16, x$14, (AppendOrigin)x$15);
    }

    @Test
    public void testOldEpochForControlRecord() {
        short epoch = (short)5;
        int sequence = 0;
        Assertions.assertEquals((Object)None$.MODULE$, (Object)this.stateManager().firstUndecidedOffset());
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        Assertions.assertThrows(InvalidProducerEpochException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), (short)3, ControlRecordType.COMMIT, 100L, this.appendEndTxnMarker$default$6(), this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencing() {
        short epoch = (short)5;
        int sequence = 0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, epoch, sequence, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        Option lastEntry = this.stateManager().lastEntry(this.producerId());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)1)), (Object)lastEntry.map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.coordinatorEpoch())));
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 101L, 1, this.appendEndTxnMarker$default$7());
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 102L, 2, this.appendEndTxnMarker$default$7());
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), epoch, ControlRecordType.COMMIT, 103L, 1, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testCoordinatorFencedAfterReload() {
        short producerEpoch = (short)0;
        ProducerStateManager x$1 = this.stateManager();
        long x$2 = this.producerId();
        int x$4 = 0;
        long x$5 = 99L;
        boolean x$6 = true;
        long x$7 = this.append$default$6();
        AppendOrigin x$8 = this.append$default$8();
        this.append(x$1, x$2, producerEpoch, x$4, x$5, x$7, x$6, x$8);
        this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 1, this.appendEndTxnMarker$default$7());
        this.stateManager().takeSnapshot();
        new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time()).truncateAndReload(0L, 2L, 70000L);
        Assertions.assertThrows(TransactionCoordinatorFencedException.class, () -> this.appendEndTxnMarker(this.stateManager(), this.producerId(), producerEpoch, ControlRecordType.COMMIT, 100L, 0, this.appendEndTxnMarker$default$7()));
    }

    @Test
    public void testLoadFromEmptySnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            testLoadFromCorruptSnapshot_channel.truncate(0L);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromTruncatedSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testLoadFromCorruptSnapshotFile() {
        short testLoadFromCorruptSnapshot_epoch = (short)0;
        long testLoadFromCorruptSnapshot_producerId = 1L;
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), testLoadFromCorruptSnapshot_producerId, testLoadFromCorruptSnapshot_epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option testLoadFromCorruptSnapshot_latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)testLoadFromCorruptSnapshot_latestSnapshotOffset);
        File testLoadFromCorruptSnapshot_snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)testLoadFromCorruptSnapshot_latestSnapshotOffset.get()));
        try (FileChannel testLoadFromCorruptSnapshot_channel = FileChannel.open(testLoadFromCorruptSnapshot_snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(testLoadFromCorruptSnapshot_channel);
        }
        ProducerStateManager testLoadFromCorruptSnapshot_reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        testLoadFromCorruptSnapshot_reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)testLoadFromCorruptSnapshot_snapshotToTruncate.exists());
        ProducerStateEntry testLoadFromCorruptSnapshot_loadedProducerState = (ProducerStateEntry)testLoadFromCorruptSnapshot_reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)testLoadFromCorruptSnapshot_producerId));
        Assertions.assertEquals((long)0L, (long)testLoadFromCorruptSnapshot_loadedProducerState.lastDataOffset());
    }

    @Test
    public void testAppendEmptyControlBatch() {
        long producerId = 23423L;
        int baseOffset = 15;
        RecordBatch batch = (RecordBatch)Mockito.mock(RecordBatch.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)batch.isControlBatch())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Mockito.when((Object)batch.iterator()).thenReturn(Collections.emptyIterator());
        this.append(this.stateManager(), producerId, baseOffset, batch, (AppendOrigin)AppendOrigin.Client$.MODULE$);
        Assertions.assertEquals((Object)None$.MODULE$, (Object)((ProducerStateEntry)this.stateManager().lastEntry(producerId).get()).currentTxnFirstOffset());
    }

    @Test
    public void testRemoveStraySnapshotsKeepCleanShutdownSnapshot() {
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{5L})));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)42)), (Object)this.stateManager().latestSnapshotOffset());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)5)), (Object)this.stateManager().oldestSnapshotOffset());
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{5, 42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToLong((long)x$16.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAllStraySnapshots() {
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 2L).createNewFile();
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 42L).createNewFile();
        this.stateManager().removeStraySnapshots((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{42L})));
        Assertions.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{42})), (Object)((SeqLike)ProducerStateManager$.MODULE$.listSnapshotFiles(this.logDir()).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToLong((long)x$17.offset()), Seq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Long$.MODULE$));
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletion() {
        UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L).createNewFile();
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Assertions.assertTrue((boolean)((Object)((SnapshotFile)manager.removeAndMarkSnapshotForDeletion(5L).get()).file().toPath()).toString().endsWith(UnifiedLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    @Test
    public void testRemoveAndMarkSnapshotForDeletionAlreadyDeleted() {
        File file = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), 5L);
        file.createNewFile();
        ProducerStateManager manager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isDefined());
        Files.delete(file.toPath());
        Assertions.assertTrue((boolean)manager.removeAndMarkSnapshotForDeletion(5L).isEmpty());
        Assertions.assertTrue((boolean)manager.latestSnapshotOffset().isEmpty());
    }

    private void testLoadFromCorruptSnapshot(Function1<FileChannel, BoxedUnit> makeFileCorrupt) {
        short epoch = (short)0;
        long producerId = 1L;
        this.append(this.stateManager(), producerId, epoch, 0, 0L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        this.append(this.stateManager(), producerId, epoch, 1, 1L, this.append$default$6(), this.append$default$7(), this.append$default$8());
        this.stateManager().takeSnapshot();
        Option latestSnapshotOffset = this.stateManager().latestSnapshotOffset();
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)2L)), (Object)latestSnapshotOffset);
        File snapshotToTruncate = UnifiedLog$.MODULE$.producerSnapshotFile(this.logDir(), BoxesRunTime.unboxToLong((Object)latestSnapshotOffset.get()));
        try (FileChannel channel = FileChannel.open(snapshotToTruncate.toPath(), StandardOpenOption.WRITE);){
            makeFileCorrupt.apply((Object)channel);
        }
        ProducerStateManager reloadedStateManager = new ProducerStateManager(this.partition(), this.logDir(), this.maxTransactionTimeoutMs(), this.maxProducerIdExpirationMs(), (Time)this.time());
        reloadedStateManager.truncateAndReload(0L, 20L, this.time().milliseconds());
        Assertions.assertFalse((boolean)snapshotToTruncate.exists());
        ProducerStateEntry loadedProducerState = (ProducerStateEntry)reloadedStateManager.activeProducers().apply((Object)BoxesRunTime.boxToLong((long)producerId));
        Assertions.assertEquals((long)0L, (long)loadedProducerState.lastDataOffset());
    }

    private Option<CompletedTxn> appendEndTxnMarker(ProducerStateManager mapping, long producerId, short producerEpoch, ControlRecordType controlType, long offset, int coordinatorEpoch, long timestamp) {
        ProducerAppendInfo producerAppendInfo = this.stateManager().prepareUpdate(producerId, (AppendOrigin)AppendOrigin.Coordinator$.MODULE$);
        EndTransactionMarker endTxnMarker = new EndTransactionMarker(controlType, coordinatorEpoch);
        Option completedTxnOpt = producerAppendInfo.appendEndTxnMarker(endTxnMarker, producerEpoch, offset, timestamp);
        mapping.update(producerAppendInfo);
        completedTxnOpt.foreach((Function1 & Serializable & scala.Serializable)completedTxn -> {
            mapping.completeTxn(completedTxn);
            return BoxedUnit.UNIT;
        });
        mapping.updateMapEndOffset(offset + 1L);
        return completedTxnOpt;
    }

    private void append(ProducerStateManager stateManager, long producerId, short producerEpoch, int seq, long offset, long timestamp, boolean isTransactional, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.appendDataBatch(producerEpoch, seq, seq, timestamp, new LogOffsetMetadata(offset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), offset, isTransactional);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private void append(ProducerStateManager stateManager, long producerId, long offset, RecordBatch batch, AppendOrigin origin) {
        ProducerAppendInfo producerAppendInfo = stateManager.prepareUpdate(producerId, origin);
        producerAppendInfo.append(batch, (Option)None$.MODULE$);
        stateManager.update(producerAppendInfo);
        stateManager.updateMapEndOffset(offset + 1L);
    }

    private int appendEndTxnMarker$default$6() {
        return 0;
    }

    private long appendEndTxnMarker$default$7() {
        return this.time().milliseconds();
    }

    private long append$default$6() {
        return this.time().milliseconds();
    }

    private boolean append$default$7() {
        return false;
    }

    private AppendOrigin append$default$8() {
        return AppendOrigin.Client$.MODULE$;
    }

    private Set<Object> currentSnapshotOffsets() {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())).map((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToLong((long)UnifiedLog$.MODULE$.offsetFromFile(file)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).toSet();
    }

    private final Option appendEndTxn$1(ControlRecordType recordType, long offset, ProducerAppendInfo appendInfo, int coordinatorEpoch$1, short producerEpoch$2) {
        return appendInfo.appendEndTxnMarker(new EndTransactionMarker(recordType, coordinatorEpoch$1), producerEpoch$2, offset, this.time().milliseconds());
    }

    private final void appendData$1(long startOffset, long endOffset, ProducerAppendInfo appendInfo, short producerEpoch$2, AtomicInteger seq$1) {
        int count = (int)(endOffset - startOffset);
        appendInfo.appendDataBatch(producerEpoch$2, seq$1.get(), seq$1.addAndGet(count), this.time().milliseconds(), new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), endOffset, true);
        seq$1.incrementAndGet();
    }

    private final void beginTxn$1(long producerId, long startOffset, long segmentBaseOffset$1, short producerEpoch$3) {
        int relativeOffset = (int)(startOffset - segmentBaseOffset$1);
        ProducerAppendInfo producerAppendInfo = new ProducerAppendInfo(this.partition(), producerId, ProducerStateEntry$.MODULE$.empty(producerId), (AppendOrigin)AppendOrigin.Client$.MODULE$);
        LogOffsetMetadata firstOffsetMetadata = new LogOffsetMetadata(startOffset, segmentBaseOffset$1, 50 * relativeOffset);
        producerAppendInfo.appendDataBatch(producerEpoch$3, 0, 0, this.time().milliseconds(), firstOffsetMetadata, startOffset, true);
        this.stateManager().update(producerAppendInfo);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromTruncatedSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.truncate(file.size() / 2L);
    }

    public static final /* synthetic */ void $anonfun$testLoadFromCorruptSnapshotFile$1(FileChannel file) {
        Assertions.assertTrue((file.size() > 2L ? 1 : 0) != 0);
        file.write(ByteBuffer.wrap((byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{37}), ClassTag$.MODULE$.Byte())), file.size() / 2L);
    }

    public ProducerStateManagerTest() {
        this.producerId = 1L;
        this.maxTransactionTimeoutMs = 300000;
        this.maxProducerIdExpirationMs = 3600000;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromEmptySnapshotFile$1$adapted(FileChannel file) {
        file.truncate(0L);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromTruncatedSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromTruncatedSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLoadFromCorruptSnapshotFile$1$adapted(FileChannel file) {
        ProducerStateManagerTest.$anonfun$testLoadFromCorruptSnapshotFile$1(file);
        return BoxedUnit.UNIT;
    }
}

