/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import scala.Function1;
import scala.Predef;
import scala.collection.IterableLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u000194Q\u0001C\u0005\u0002\u00029A\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IA\u0006\u0005\u00069\u0001!\t!\b\u0005\u0006C\u0001!\tA\t\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\u0019\u0002!\t!\u0014\u0005\u0006\u001f\u0002!\t\u0001\u0015\u0005\b)\u0002\t\n\u0011\"\u0001V\u0005y\t%m\u001d;sC\u000e$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\u0016\u001cHO\u0003\u0002\u000b\u0017\u000511/\u001a:wKJT\u0011\u0001D\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0002\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VMZ\u0001\bG2,8\u000f^3s!\t9\"$D\u0001\u0019\u0015\tI2\"\u0001\u0003uKN$\u0018BA\u000e\u0019\u0005=\u0019E.^:uKJLen\u001d;b]\u000e,\u0017A\u0002\u001fj]&$h\b\u0006\u0002\u001fAA\u0011q\u0004A\u0007\u0002\u0013!)QC\u0001a\u0001-\u000512/\u001a8e\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fF\u0002$aU\u0002\"\u0001\n\u0018\u000e\u0003\u0015R!AJ\u0014\u0002\u0011I,\u0017/^3tiNT!\u0001K\u0015\u0002\r\r|W.\\8o\u0015\ta!F\u0003\u0002,Y\u00051\u0011\r]1dQ\u0016T\u0011!L\u0001\u0004_J<\u0017BA\u0018&\u0005M\t\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:f\u0011\u0015\t4\u00011\u00013\u0003\u001d\u0011X-];fgR\u0004\"\u0001J\u001a\n\u0005Q*#AE!qSZ+'o]5p]N\u0014V-];fgRDQAN\u0002A\u0002]\nA\u0002\\5ti\u0016tWM\u001d(b[\u0016\u0004\"\u0001O\u001e\u000e\u0003eR!AO\u0014\u0002\u000f9,Go^8sW&\u0011A(\u000f\u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"a\u0010\"\u0011\u0005A\u0001\u0015BA!\u0012\u0005\u0011)f.\u001b;\t\u000b\r#\u0001\u0019\u0001#\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006!Q\u000f^5m\u0015\u0005I\u0015\u0001\u00026bm\u0006L!a\u0013$\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\u0011tK:$WK\\:vaB|'\u000f^3e\u0003BLg+\u001a:tS>t'+Z9vKN$HCA\u0012O\u0011\u0015\tT\u00011\u00013\u0003m1\u0018\r\\5eCR,\u0017\t]5WKJ\u001c\u0018n\u001c8t%\u0016\u001c\bo\u001c8tKR\u0019q(U*\t\u000bI3\u0001\u0019A\u0012\u0002'\u0005\u0004\u0018NV3sg&|gn\u001d*fgB|gn]3\t\u000fY2\u0001\u0013!a\u0001o\u0005)c/\u00197jI\u0006$X-\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016$C-\u001a4bk2$HEM\u000b\u0002-*\u0012qgV\u0016\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\nk:\u001c\u0007.Z2lK\u0012T!!X\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002`5\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3)\t\u0001\t7\u000e\u001c\t\u0003E&l\u0011a\u0019\u0006\u0003I\u0016\f1!\u00199j\u0015\t1w-A\u0004kkBLG/\u001a:\u000b\u0005!d\u0013!\u00026v]&$\u0018B\u00016d\u0005\r!\u0016mZ\u0001\u0006m\u0006dW/Z\u0011\u0002[\u0006Y\u0011N\u001c;fOJ\fG/[8o\u0001")
public abstract class AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request, ListenerName listenerName) {
        SocketServer socket = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.controllerSocketServers()).asScala()).head() : (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head();
        return (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, socket, listenerName, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public void brokerPropertyOverrides(Properties properties) {
        if (!this.cluster.isKRaftTest()) {
            String controlPlaneListenerName = "CONTROL_PLANE";
            SecurityProtocol securityProtocol = this.cluster.config().securityProtocol();
            properties.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), controlPlaneListenerName);
            properties.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(3).append(controlPlaneListenerName).append(":").append(securityProtocol).append(",").append(securityProtocol).append(":").append(securityProtocol).toString());
            properties.setProperty("listeners", new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(controlPlaneListenerName).append("://localhost:0").toString());
            properties.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(controlPlaneListenerName).append("://localhost:0").toString());
        }
    }

    public ApiVersionsResponse sendUnsupportedApiVersionRequest(ApiVersionsRequest request) {
        ApiVersionsResponse apiVersionsResponse;
        RequestHeader overrideHeader = IntegrationTestUtils$.MODULE$.nextRequestHeader(ApiKeys.API_VERSIONS, (short)Short.MAX_VALUE, IntegrationTestUtils$.MODULE$.nextRequestHeader$default$3(), IntegrationTestUtils$.MODULE$.nextRequestHeader$default$4());
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener());){
            byte[] serializedBytes = Utils.toArray((ByteBuffer)RequestUtils.serialize((Message)overrideHeader.data(), (short)overrideHeader.headerVersion(), (Message)request.data(), (short)request.version()));
            IntegrationTestUtils$.MODULE$.sendRequest(socket, serializedBytes);
            apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.receive(socket, ApiKeys.API_VERSIONS, (short)0, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
        return apiVersionsResponse;
    }

    public void validateApiVersionsResponse(ApiVersionsResponse apiVersionsResponse, ListenerName listenerName) {
        EnumSet expectedApis = !this.cluster.isKRaftTest() ? ApiKeys.zkBrokerApis() : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? ApiKeys.controllerApis() : ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (RecordVersion)RecordVersion.current(), (Map)new NodeApiVersions((Collection)CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.controllerApis()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1), Set$.MODULE$.canBuildFrom())).asJava()).allSupportedApiVersions()));
        Assertions.assertEquals((int)expectedApis.size(), (int)apiVersionsResponse.data().apiKeys().size(), (String)"API keys in ApiVersionsResponse must match API keys supported by broker.");
        ApiVersionsResponse defaultApiVersionsResponse = !this.cluster.isKRaftTest() ? ApiVersionsResponse.defaultApiVersionsResponse((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? ApiVersionsResponse.defaultApiVersionsResponse((ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER) : ApiVersionsResponse.createApiVersionsResponse((int)0, (ApiVersionsResponseData.ApiVersionCollection)((ApiVersionsResponseData.ApiVersionCollection)expectedApis)));
        ((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)defaultApiVersionsResponse.data().apiKeys()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)expectedApiVersion -> {
            AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$3(apiVersionsResponse, expectedApiVersion);
            return BoxedUnit.UNIT;
        });
    }

    public ListenerName validateApiVersionsResponse$default$2() {
        return this.cluster.clientListener();
    }

    public static final /* synthetic */ void $anonfun$validateApiVersionsResponse$3(ApiVersionsResponse apiVersionsResponse$1, ApiVersionsResponseData.ApiVersion expectedApiVersion) {
        ApiVersionsResponseData.ApiVersion actualApiVersion = apiVersionsResponse$1.apiVersion(expectedApiVersion.apiKey());
        Assertions.assertNotNull((Object)actualApiVersion, (String)new StringBuilder(73).append("API key ").append(expectedApiVersion.apiKey()).append(" is supported by broker, but not received in ApiVersionsResponse.").toString());
        Assertions.assertEquals((short)expectedApiVersion.apiKey(), (short)actualApiVersion.apiKey(), (String)"API key must be supported by the broker.");
        Assertions.assertEquals((short)expectedApiVersion.minVersion(), (short)actualApiVersion.minVersion(), (String)new StringBuilder(45).append("Received unexpected min version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
        Assertions.assertEquals((short)expectedApiVersion.maxVersion(), (short)actualApiVersion.maxVersion(), (String)new StringBuilder(45).append("Received unexpected max version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
    }

    public AbstractApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

