/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.Serializable;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogAppendInfo;
import kafka.metrics.KafkaYammerMetrics;
import kafka.server.AbstractFetcherManager;
import kafka.server.AbstractFetcherThread;
import kafka.server.AbstractFetcherThread$;
import kafka.server.BrokerIdAndFetcherId;
import kafka.server.BrokerTopicStats;
import kafka.server.FailedPartitions;
import kafka.server.InitialFetchState;
import kafka.server.OffsetAndEpoch;
import kafka.server.OffsetTruncationState;
import kafka.server.PartitionFetchState;
import kafka.server.PartitionFetchState$;
import kafka.server.ReplicaState;
import kafka.server.Truncating$;
import kafka.utils.Implicits;
import kafka.utils.Implicits$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t}d\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005\u0002UBQA\u0012\u0001\u0005\n\u001dCQ\u0001\u0017\u0001\u0005\u0002UBQ!\u0018\u0001\u0005\u0002UBQa\u0018\u0001\u0005\u0002UBQ!\u0019\u0001\u0005\u0002UBQa\u0019\u0001\u0005\u0002UBQ!\u001a\u0001\u0005\u0002UBQa\u001a\u0001\u0005\n!DqA\u001d\u0001\u0012\u0002\u0013%1\u000fC\u0003\u007f\u0001\u0011%q\u0010C\u0005\u0002,\u0001\t\n\u0011\"\u0003\u0002.!9\u0011\u0011\u0007\u0001\u0005\n\u0005MbABA\u001e\u0001\u0011\ti\u0004\u0003\u0006\u0002F=\u0011\t\u0011)A\u0005\u0003\u000fB!\"a\u0015\u0010\u0005\u0003\u0005\u000b\u0011BA+\u0011\u0019\u0001t\u0002\"\u0001\u0002\\!9\u0011QM\b\u0005R\u0005\u001d\u0004bBAK\u001f\u0011E\u0013q\u0013\u0005\b\u0003K{A\u0011KAT\u0011\u001d\tyk\u0004C)\u0003cCq!!9\u0010\t#\n\u0019\u000fC\u0004\u0002j>!\t&a;\t\u000f\u0005=x\u0002\"\u0015\u0002r\"9\u0011Q_\b\u0005R\u0005]\bb\u0002B\u0004\u001f\u0011E#\u0011\u0002\u0005\b\u0005\u007fyA\u0011\u000bB!\u0011\u001d\u0011if\u0004C)\u0005?BqAa\u001a\u0010\t#\u0012I\u0007C\u0005\u0003p=\u0011\r\u0011\"\u0015\u0003r!A!\u0011P\b!\u0002\u0013\u0011\u0019\bC\u0005\u0003|=\u0011\r\u0011\"\u0015\u0003r!A!QP\b!\u0002\u0013\u0011\u0019H\u0001\u000eBEN$(/Y2u\r\u0016$8\r[3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002&M\u000511/\u001a:wKJT\u0011aJ\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001!\u0006\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\u0002\"a\r\u0001\u000e\u0003\u0011\n1c\u00197fC:lU\r\u001e:jGJ+w-[:uef$\u0012A\u000e\t\u0003W]J!\u0001\u000f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005i\u0002\"a\u000f#\u000e\u0003qR!!\u0010 \u0002\u0007\u0005\u0004\u0018N\u0003\u0002@\u0001\u00069!.\u001e9ji\u0016\u0014(BA!C\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0015aA8sO&\u0011Q\t\u0010\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017AD4fi6+GO]5d-\u0006dW/\u001a\u000b\u0003\u0011.\u0003\"aK%\n\u0005)c#aA!os\")Aj\u0001a\u0001\u001b\u0006!a.Y7f!\tqUK\u0004\u0002P'B\u0011\u0001\u000bL\u0007\u0002#*\u0011!\u000bK\u0001\u0007yI|w\u000e\u001e \n\u0005Qc\u0013A\u0002)sK\u0012,g-\u0003\u0002W/\n11\u000b\u001e:j]\u001eT!\u0001\u0016\u0017\u00023Q,7\u000f^!eI\u0006sGMU3n_Z,\u0007+\u0019:uSRLwN\u001c\u0015\u0003\ti\u0003\"aO.\n\u0005qc$\u0001\u0002+fgR\fa\u0004^3ti6+GO]5d\r\u0006LG.\u001a3QCJ$\u0018\u000e^5p]\u000e{WO\u001c;)\u0005\u0015Q\u0016!\u0007;fgR$U-\u00193UQJ,\u0017\rZ\"pk:$X*\u001a;sS\u000eD#A\u0002.\u0002/Q,7\u000f^'bs\n,W\u000b\u001d3bi\u0016$v\u000e]5d\u0013\u0012\u001c\bFA\u0004[\u0003Q!Xm\u001d;FqB\fg\u000e\u001a+ie\u0016\fG\rU8pY\"\u0012\u0001BW\u0001\u0015i\u0016\u001cHo\u00155sS:\\G\u000b\u001b:fC\u0012\u0004vn\u001c7)\u0005%Q\u0016\u0001\u0006;fgR\u0014Vm]5{KRC'/Z1e!>|G\u000e\u0006\u00037S:\u0004\b\"\u00026\u000b\u0001\u0004Y\u0017AE2veJ,g\u000e\u001e$fi\u000eDWM]*ju\u0016\u0004\"a\u000b7\n\u00055d#aA%oi\")qN\u0003a\u0001W\u0006qa.Z<GKR\u001c\u0007.\u001a:TSj,\u0007bB9\u000b!\u0003\u0005\ra[\u0001\nEJ|7.\u001a:Ok6\fa\u0004^3tiJ+7/\u001b>f)\"\u0014X-\u00193Q_>dG\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003QT#a[;,\u0003Y\u0004\"a\u001e?\u000e\u0003aT!!\u001f>\u0002\u0013Ut7\r[3dW\u0016$'BA>-\u0003)\tgN\\8uCRLwN\\\u0005\u0003{b\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003Ii\u0017m[3U_BL7\rU1si&$\u0018n\u001c8\u0015\u0011\u0005\u0005\u0011qDA\u0012\u0003O\u0001b!a\u0001\u0002\n\u00055QBAA\u0003\u0015\r\t9\u0001L\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u0006\u0003\u000b\u00111aU3u!\u0011\ty!a\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\taaY8n[>t'bA\u0014\u0002\u0018)\u0019\u0011\u0011\u0004\"\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\ti\"!\u0005\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\"1\u0011\u0011\u0005\u0007A\u0002-\f\u0001\u0002^8qS\u000etU/\u001c\u0005\u0007\u0003Ka\u0001\u0019A6\u0002\u0019A\f'\u000f^5uS>tg*^7\t\u0011\u0005%B\u0002%AA\u00025\u000b1\u0002^8qS\u000e\u0004&/\u001a4jq\u0006aR.Y6f)>\u0004\u0018n\u0019)beRLG/[8oI\u0011,g-Y;mi\u0012\u001aTCAA\u0018U\tiU/A\u0006hKR\u0014%o\\6fe&#G#B6\u00026\u0005e\u0002bBA\u001c\u001d\u0001\u0007\u0011QB\u0001\u0003iBDQ!\u001d\bA\u0002-\u0014q\u0003V3tiJ+7/\u001b>f\r\u0016$8\r[3s)\"\u0014X-\u00193\u0014\u0007=\ty\u0004E\u00024\u0003\u0003J1!a\u0011%\u0005U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012\fAb]8ve\u000e,'I]8lKJ\u0004B!!\u0013\u0002P5\u0011\u00111\n\u0006\u0004\u0003\u001b2\u0013aB2mkN$XM]\u0005\u0005\u0003#\nYE\u0001\bCe>\\WM]#oIB{\u0017N\u001c;\u0002!\u0019\f\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001c\bcA\u001a\u0002X%\u0019\u0011\u0011\f\u0013\u0003!\u0019\u000b\u0017\u000e\\3e!\u0006\u0014H/\u001b;j_:\u001cHCBA/\u0003C\n\u0019\u0007E\u0002\u0002`=i\u0011\u0001\u0001\u0005\b\u0003\u000b\u0012\u0002\u0019AA$\u0011\u001d\t\u0019F\u0005a\u0001\u0003+\nA\u0003\u001d:pG\u0016\u001c8\u000fU1si&$\u0018n\u001c8ECR\fG\u0003CA5\u0003w\ny(!#\u0011\u000b-\nY'a\u001c\n\u0007\u00055DF\u0001\u0004PaRLwN\u001c\t\u0005\u0003c\n9(\u0004\u0002\u0002t)\u0019\u0011Q\u000f\u0014\u0002\u00071|w-\u0003\u0003\u0002z\u0005M$!\u0004'pO\u0006\u0003\b/\u001a8e\u0013:4w\u000eC\u0004\u0002~M\u0001\r!!\u0004\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"9\u0011\u0011Q\nA\u0002\u0005\r\u0015a\u00034fi\u000eDwJ\u001a4tKR\u00042aKAC\u0013\r\t9\t\f\u0002\u0005\u0019>tw\rC\u0004\u0002\fN\u0001\r!!$\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\ty)!%\u000e\u0003=IA!a%\u0002B\tIa)\u001a;dQ\u0012\u000bG/Y\u0001\tiJ,hnY1uKR)a'!'\u0002\u001c\"9\u0011Q\u0010\u000bA\u0002\u00055\u0001bBAO)\u0001\u0007\u0011qT\u0001\u0010iJ,hnY1uS>t7\u000b^1uKB\u00191'!)\n\u0007\u0005\rFEA\u000bPM\u001a\u001cX\r\u001e+sk:\u001c\u0017\r^5p]N#\u0018\r^3\u0002/Q\u0014XO\\2bi\u00164U\u000f\u001c7z\u0003:$7\u000b^1si\u0006#H#\u0002\u001c\u0002*\u0006-\u0006bBA?+\u0001\u0007\u0011Q\u0002\u0005\b\u0003[+\u0002\u0019AAB\u0003\u0019ygMZ:fi\u0006Q!-^5mI\u001a+Go\u00195\u0015\t\u0005M\u0016\u0011\u001b\t\u0007\u0003k\u000b\u0019-!3\u000f\t\u0005]\u0016q\u0018\b\u0005\u0003s\u000biLD\u0002Q\u0003wK\u0011aJ\u0005\u0003K\u0019J1!!1%\u0003U\t%m\u001d;sC\u000e$h)\u001a;dQ\u0016\u0014H\u000b\u001b:fC\u0012LA!!2\u0002H\n!\"+Z:vYR<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]NT1!!1%!\u0015Y\u00131NAf!\u0011\t),!4\n\t\u0005=\u0017q\u0019\u0002\r%\u0016\u0004H.[2b\r\u0016$8\r\u001b\u0005\b\u0003'4\u0002\u0019AAk\u00031\u0001\u0018M\u001d;ji&|g.T1q!!\t\u0019!a6\u0002\u000e\u0005m\u0017\u0002BAm\u0003\u000b\u00111!T1q!\r\u0019\u0014Q\\\u0005\u0004\u0003?$#a\u0005)beRLG/[8o\r\u0016$8\r[*uCR,\u0017a\u00037bi\u0016\u001cH/\u00129pG\"$B!!:\u0002hB!1&a\u001bl\u0011\u001d\tih\u0006a\u0001\u0003\u001b\ta\u0002\\8h'R\f'\u000f^(gMN,G\u000f\u0006\u0003\u0002\u0004\u00065\bbBA?1\u0001\u0007\u0011QB\u0001\rY><WI\u001c3PM\u001a\u001cX\r\u001e\u000b\u0005\u0003\u0007\u000b\u0019\u0010C\u0004\u0002~e\u0001\r!!\u0004\u0002#\u0015tGm\u00144gg\u0016$hi\u001c:Fa>\u001c\u0007\u000e\u0006\u0004\u0002z\n\u0005!1\u0001\t\u0006W\u0005-\u00141 \t\u0004g\u0005u\u0018bAA\u0000I\tqqJ\u001a4tKR\fe\u000eZ#q_\u000eD\u0007bBA?5\u0001\u0007\u0011Q\u0002\u0005\u0007\u0005\u000bQ\u0002\u0019A6\u0002\u000b\u0015\u0004xn\u00195\u0002)\u0019,Go\u00195Fa>\u001c\u0007.\u00128e\u001f\u001a47/\u001a;t)\u0011\u0011YAa\r\u0011\u0011\u0005\r\u0011q[A\u0007\u0005\u001b\u0001BAa\u0004\u0003.9!!\u0011\u0003B\u0014\u001d\u0011\u0011\u0019Ba\t\u000f\t\tU!\u0011\u0005\b\u0005\u0005/\u0011yB\u0004\u0003\u0003\u001a\tuab\u0001)\u0003\u001c%\t1)C\u0002\u0002\u001a\tK1aJA\f\u0013\u0011\t\u0019\"!\u0006\n\t\t\u0015\u0012\u0011C\u0001\b[\u0016\u001c8/Y4f\u0013\u0011\u0011ICa\u000b\u0002A=3gm]3u\r>\u0014H*Z1eKJ,\u0005o\\2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0006\u0005\u0005K\t\t\"\u0003\u0003\u00030\tE\"AD#q_\u000eDWI\u001c3PM\u001a\u001cX\r\u001e\u0006\u0005\u0005S\u0011Y\u0003C\u0004\u00036m\u0001\rAa\u000e\u0002\u0015A\f'\u000f^5uS>t7\u000f\u0005\u0005\u0002\u0004\u0005]\u0017Q\u0002B\u001d!\u0011\tyIa\u000f\n\t\tu\u0012\u0011\t\u0002\n\u000bB|7\r\u001b#bi\u0006\fqBZ3uG\"4%o\\7MK\u0006$WM\u001d\u000b\u0005\u0005\u0007\u0012)\u0005\u0005\u0005\u0002\u0004\u0005]\u0017QBAG\u0011\u001d\u00119\u0005\ba\u0001\u0005\u0013\nABZ3uG\"\u0014V-];fgR\u0004BAa\u0013\u0003X9!!Q\nB*\u001b\t\u0011yE\u0003\u0003\u0003R\u0005E\u0011\u0001\u0003:fcV,7\u000f^:\n\t\tU#qJ\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u00053\u0012YFA\u0004Ck&dG-\u001a:\u000b\t\tU#qJ\u0001\u001eM\u0016$8\r[#be2LWm\u001d;PM\u001a\u001cX\r\u001e$s_6dU-\u00193feR1\u00111\u0011B1\u0005GBq!! \u001e\u0001\u0004\ti\u0001\u0003\u0004\u0003fu\u0001\ra[\u0001\u0013GV\u0014(/\u001a8u\u0019\u0016\fG-\u001a:Fa>\u001c\u0007.A\u000egKR\u001c\u0007\u000eT1uKN$xJ\u001a4tKR4%o\\7MK\u0006$WM\u001d\u000b\u0007\u0003\u0007\u0013YG!\u001c\t\u000f\u0005ud\u00041\u0001\u0002\u000e!1!Q\r\u0010A\u0002-\fq$[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3e+\t\u0011\u0019\bE\u0002,\u0005kJ1Aa\u001e-\u0005\u001d\u0011un\u001c7fC:\f\u0001%[:PM\u001a\u001cX\r\u001e$pe2+\u0017\rZ3s\u000bB|7\r[*vaB|'\u000f^3eA\u0005a\u0012n\u001d+sk:\u001c\u0017\r^5p]>sg)\u001a;dQN+\b\u000f]8si\u0016$\u0017!H5t)J,hnY1uS>twJ\u001c$fi\u000eD7+\u001e9q_J$X\r\u001a\u0011")
public class AbstractFetcherManagerTest {
    @BeforeEach
    public void cleanMetricRegistry() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    private Object getMetricValue(String name) {
        return ((Gauge)((MapLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManagerTest.$anonfun$getMetricValue$1(name, x0$1)))).values().headOption().get()).value();
    }

    @Test
    public void testAddAndRemovePartition() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$1;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$1;
            }
            {
                this.fetcher$1 = fetcher$1;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.sourceBroker()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)fetcher.fetchState(tp)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$))).thenReturn((Object)None$.MODULE$);
        Mockito.when((Object)fetcher.removePartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})))).thenReturn((Object)Map$.MODULE$.empty());
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((Object)new Some((Object)fetcher), (Object)fetcherManager.getFetcher(tp));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)fetcherManager.getFetcher(tp));
        ((Thread)Mockito.verify((Object)fetcher)).start();
    }

    @Test
    public void testMetricFailedPartitionCount() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$2;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$2;
            }
            {
                this.fetcher$2 = fetcher$2;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        TopicPartition tp = new TopicPartition("topic", 0);
        String metricName = "FailedPartitionsCount";
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
        fetcherManager.failedPartitions().add(tp);
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)1), (Object)this.getMetricValue(metricName));
        fetcherManager.removeFetcherForPartitions((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)0), (Object)this.getMetricValue(metricName));
    }

    @Test
    public void testDeadThreadCountMetric() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$3;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$3;
            }
            {
                this.fetcher$3 = fetcher$3;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp = new TopicPartition("topic", 0);
        Some topicId = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState = new InitialFetchState((Option)topicId, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.sourceBroker()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})))).thenReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp})));
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)initialFetchState)})));
        Assertions.assertEquals((int)1, (int)fetcherManager.deadThreadCount());
        ((Thread)Mockito.verify((Object)fetcher)).start();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)fetcher.isThreadFailed())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Assertions.assertEquals((int)0, (int)fetcherManager.deadThreadCount());
    }

    @Test
    public void testMaybeUpdateTopicIds() {
        AbstractFetcherThread fetcher = (AbstractFetcherThread)Mockito.mock(AbstractFetcherThread.class);
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(null, fetcher){
            private final AbstractFetcherThread fetcher$4;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.fetcher$4;
            }
            {
                this.fetcher$4 = fetcher$4;
                super("fetcher-manager", "fetcher-manager", 2);
            }
        };
        long fetchOffset = 10L;
        int leaderEpoch = 15;
        TopicPartition tp1 = new TopicPartition("topic1", 0);
        TopicPartition tp2 = new TopicPartition("topic2", 0);
        TopicPartition unknownTp = new TopicPartition("topic2", 1);
        Some topicId1 = new Some((Object)Uuid.randomUuid());
        Some topicId2 = new Some((Object)Uuid.randomUuid());
        InitialFetchState initialFetchState1 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(0, "localhost", 9092), leaderEpoch, fetchOffset);
        InitialFetchState initialFetchState2 = new InitialFetchState((Option)None$.MODULE$, new BrokerEndPoint(1, "localhost", 9092), leaderEpoch, fetchOffset);
        Mockito.when((Object)fetcher.sourceBroker()).thenReturn((Object)new BrokerEndPoint(0, "localhost", 9092));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1)})))).thenReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})));
        Mockito.when((Object)fetcher.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})))).thenReturn((Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})));
        Mockito.when((Object)fetcher.fetchState(tp1)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)None$.MODULE$, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$))).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId1, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$)));
        Mockito.when((Object)fetcher.fetchState(tp2)).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)None$.MODULE$, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$))).thenReturn((Object)new Some((Object)PartitionFetchState$.MODULE$.apply((Option)topicId2, fetchOffset, (Option)None$.MODULE$, leaderEpoch, (ReplicaState)Truncating$.MODULE$, (Option)None$.MODULE$)));
        Map topicIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1.topic()), (Object)topicId1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2.topic()), (Object)topicId2)}));
        Mockito.when((Object)fetcher.fetchState(unknownTp)).thenReturn((Object)None$.MODULE$);
        fetcherManager.addFetcherForPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)initialFetchState1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)initialFetchState2)})));
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)None$.MODULE$);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)None$.MODULE$);
        Map partitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)initialFetchState2.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(partitionsToUpdate, (Function1)topicIds);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp1), (Option)topicId1);
        AbstractFetcherManagerTest.verifyFetchState$1(fetcher.fetchState(tp2), (Option)topicId2);
        Map invalidPartitionsToUpdate = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)unknownTp), (Object)BoxesRunTime.boxToInteger((int)initialFetchState1.leader().id()))}));
        fetcherManager.maybeUpdateTopicIds(invalidPartitionsToUpdate, (Function1)topicIds);
        Assertions.assertTrue((boolean)fetcher.fetchState(unknownTp).isEmpty());
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{unknownTp})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp1})), (Function1)topicIds);
        ((AbstractFetcherThread)Mockito.verify((Object)fetcher)).maybeUpdateTopicIds((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp2})), (Function1)topicIds);
    }

    @Test
    public void testExpandThreadPool() {
        this.testResizeThreadPool(10, 50, this.testResizeThreadPool$default$3());
    }

    @Test
    public void testShrinkThreadPool() {
        this.testResizeThreadPool(50, 10, this.testResizeThreadPool$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private void testResizeThreadPool(int currentFetcherSize, int newFetcherSize, int brokerNum) {
        Set<TopicPartition> fetchingTopicPartitions = this.makeTopicPartition(10, 100, this.makeTopicPartition$default$3());
        Set<TopicPartition> failedTopicPartitions = this.makeTopicPartition(2, 5, "topic_failed");
        AbstractFetcherManager<AbstractFetcherThread> fetcherManager = new AbstractFetcherManager<AbstractFetcherThread>(this, currentFetcherSize){
            private final /* synthetic */ AbstractFetcherManagerTest $outer;

            public AbstractFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                return this.$outer.new TestResizeFetcherThread(sourceBroker, this.failedPartitions());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super("fetcher-manager", "fetcher-manager", currentFetcherSize$1);
            }
        };
        try {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            fetcherManager.addFetcherForPartitions((Map)((TraversableOnce)fetchingTopicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> {
                int brokerId = this.getBrokerId((TopicPartition)tp, brokerNum);
                BrokerEndPoint brokerEndPoint = new BrokerEndPoint(brokerId, new StringBuilder(11).append("kafka-host-").append(brokerId).toString(), 9092);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)new InitialFetchState((Option)None$.MODULE$, brokerEndPoint, 0, 0L));
            }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
            ((IterableLike)fetchingTopicPartitions.take(20)).foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$2$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            failedTopicPartitions.foreach(arg_0 -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$3$adapted((AbstractFetcherManager)fetcherManager, arg_0));
            fetcherManager.resizeThreadPool(newFetcherSize);
            scala.collection.mutable.Set ownedPartitions = scala.collection.mutable.Set$.MODULE$.empty();
            Function2 & Serializable & scala.Serializable intersect = (arg_0, arg_1) -> AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4$adapted(this, ownedPartitions, (AbstractFetcherManager)fetcherManager, brokerNum, arg_0, arg_1);
            Map map = Implicits$.MODULE$.MapExtensionMethods((Map)fetcherManager.fetcherThreadMap());
            if (Implicits.MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits.MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            Assertions.assertEquals(fetchingTopicPartitions, (Object)ownedPartitions);
            Assertions.assertEquals(failedTopicPartitions, (Object)fetcherManager.failedPartitions().partitions());
        }
        finally {
            fetcherManager.closeAllFetchers();
        }
    }

    private int testResizeThreadPool$default$3() {
        return 6;
    }

    private Set<TopicPartition> makeTopicPartition(int topicNum, int partitionNum, String topicPrefix) {
        scala.collection.mutable.Set res = (scala.collection.mutable.Set)scala.collection.mutable.Set$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), topicNum - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String topic = new StringBuilder(0).append(topicPrefix).append(i).toString();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), partitionNum - 1).foreach((Function1 & Serializable & scala.Serializable)j -> AbstractFetcherManagerTest.$anonfun$makeTopicPartition$2(res, topic, BoxesRunTime.unboxToInt((Object)j)));
        });
        return res.toSet();
    }

    private String makeTopicPartition$default$3() {
        return "topic_";
    }

    private int getBrokerId(TopicPartition tp, int brokerNum) {
        return Utils.abs((int)tp.hashCode()) % brokerNum;
    }

    public static final /* synthetic */ boolean $anonfun$getMetricValue$1(String name$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getName();
        boolean bl = !(string != null ? !string.equals(name$1) : name$1 != null);
        return bl;
    }

    private static final void verifyFetchState$1(Option fetchState, Option expectedTopicId) {
        Assertions.assertTrue((boolean)fetchState.isDefined());
        Assertions.assertEquals((Object)expectedTopicId, (Object)((PartitionFetchState)fetchState.get()).topicId());
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$5(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int fetcherId$1, int brokerNum$1, int brokerId$1, TopicPartition tp) {
        ownedPartitions$1.$plus$eq((Object)tp);
        Assertions.assertEquals((int)fetcherManager$1.getFetcherId(tp), (int)fetcherId$1);
        Assertions.assertEquals((int)$this.getBrokerId(tp, brokerNum$1), (int)brokerId$1);
    }

    public static final /* synthetic */ void $anonfun$testResizeThreadPool$4(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        int fetcherId = brokerIdAndFetcherId.fetcherId();
        int brokerId = brokerIdAndFetcherId.brokerId();
        fetcherThread.partitions().foreach((Function1 & Serializable & scala.Serializable)tp -> {
            AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$5($this, ownedPartitions$1, fetcherManager$1, fetcherId, brokerNum$1, brokerId, tp);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ scala.collection.mutable.Set $anonfun$makeTopicPartition$2(scala.collection.mutable.Set res$1, String topic$1, int j) {
        return (scala.collection.mutable.Set)res$1.$plus$eq((Object)new TopicPartition(topic$1, j));
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$2$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$3$adapted(AbstractFetcherManager fetcherManager$1, TopicPartition topicPartition) {
        fetcherManager$1.addFailedPartition(topicPartition);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testResizeThreadPool$4$adapted(AbstractFetcherManagerTest $this, scala.collection.mutable.Set ownedPartitions$1, AbstractFetcherManager fetcherManager$1, int brokerNum$1, BrokerIdAndFetcherId brokerIdAndFetcherId, AbstractFetcherThread fetcherThread) {
        AbstractFetcherManagerTest.$anonfun$testResizeThreadPool$4($this, ownedPartitions$1, fetcherManager$1, brokerNum$1, brokerIdAndFetcherId, fetcherThread);
        return BoxedUnit.UNIT;
    }

    private class TestResizeFetcherThread
    extends AbstractFetcherThread {
        private final boolean isOffsetForLeaderEpochSupported;
        private final boolean isTruncationOnFetchSupported;

        public Option<LogAppendInfo> processPartitionData(TopicPartition topicPartition, long fetchOffset, FetchResponseData.PartitionData partitionData) {
            return None$.MODULE$;
        }

        public void truncate(TopicPartition topicPartition, OffsetTruncationState truncationState) {
        }

        public void truncateFullyAndStartAt(TopicPartition topicPartition, long offset) {
        }

        public AbstractFetcherThread.ResultWithPartitions<Option<AbstractFetcherThread.ReplicaFetch>> buildFetch(Map<TopicPartition, PartitionFetchState> partitionMap) {
            return new AbstractFetcherThread.ResultWithPartitions((Object)None$.MODULE$, Set$.MODULE$.empty());
        }

        public Option<Object> latestEpoch(TopicPartition topicPartition) {
            return new Some((Object)BoxesRunTime.boxToInteger((int)0));
        }

        public long logStartOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public long logEndOffset(TopicPartition topicPartition) {
            return 1L;
        }

        public Option<OffsetAndEpoch> endOffsetForEpoch(TopicPartition topicPartition, int epoch) {
            return new Some((Object)new OffsetAndEpoch(1L, 0));
        }

        public Map<TopicPartition, OffsetForLeaderEpochResponseData.EpochEndOffset> fetchEpochEndOffsets(Map<TopicPartition, OffsetForLeaderEpochRequestData.OffsetForLeaderPartition> partitions) {
            return Map$.MODULE$.empty();
        }

        public Map<TopicPartition, FetchResponseData.PartitionData> fetchFromLeader(FetchRequest.Builder fetchRequest) {
            return Map$.MODULE$.empty();
        }

        public long fetchEarliestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 1L;
        }

        public long fetchLatestOffsetFromLeader(TopicPartition topicPartition, int currentLeaderEpoch) {
            return 1L;
        }

        public boolean isOffsetForLeaderEpochSupported() {
            return this.isOffsetForLeaderEpochSupported;
        }

        public boolean isTruncationOnFetchSupported() {
            return this.isTruncationOnFetchSupported;
        }

        public /* synthetic */ AbstractFetcherManagerTest kafka$server$AbstractFetcherManagerTest$TestResizeFetcherThread$$$outer() {
            return AbstractFetcherManagerTest.this;
        }

        public TestResizeFetcherThread(BrokerEndPoint sourceBroker, FailedPartitions failedPartitions) {
            if (AbstractFetcherManagerTest.this == null) {
                throw null;
            }
            String x$1 = "test-resize-fetcher";
            String x$2 = "mock-fetcher";
            int x$5 = 0;
            BrokerTopicStats x$6 = new BrokerTopicStats();
            boolean x$7 = AbstractFetcherThread$.MODULE$.$lessinit$greater$default$6();
            super(x$1, x$2, sourceBroker, failedPartitions, x$5, x$7, x$6);
            this.isOffsetForLeaderEpochSupported = false;
            this.isTruncationOnFetchSupported = false;
        }
    }
}

