/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import kafka.api.ApiVersion;
import kafka.api.KAFKA_3_2_IV0$;
import kafka.api.LeaderAndIsr;
import kafka.server.AlterIsrManager;
import kafka.server.AlterIsrManagerTest$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterIsrManager;
import kafka.server.ZkIsrManager;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001\u0002\u00180\u0001QBQa\u000f\u0001\u0005\u0002qBqa\u0010\u0001C\u0002\u0013\u0005\u0001\t\u0003\u0004J\u0001\u0001\u0006I!\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u0019\u0011\u0006\u0001)A\u0005\u0019\"91\u000b\u0001b\u0001\n\u0003!\u0006BB1\u0001A\u0003%Q\u000bC\u0004c\u0001\t\u0007I\u0011A2\t\r\u001d\u0004\u0001\u0015!\u0003e\u0011%A\u0007\u00011AA\u0002\u0013\u0005\u0011\u000eC\u0005n\u0001\u0001\u0007\t\u0019!C\u0001]\"IA\u000f\u0001a\u0001\u0002\u0003\u0006KA\u001b\u0005\bk\u0002\u0011\r\u0011\"\u0001w\u0011\u0019Y\b\u0001)A\u0005o\"9A\u0010\u0001b\u0001\n\u00031\bBB?\u0001A\u0003%q\u000fC\u0004\u007f\u0001\t\u0007I\u0011\u0001<\t\r}\u0004\u0001\u0015!\u0003x\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007Aq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t!9\u0011Q\u0010\u0001\u0005\u0002\u0005}\u0004bBAE\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003'\u0003A\u0011AA\u0002\u0011\u001d\t9\n\u0001C\u0001\u0003\u0007Aq!a'\u0001\t\u0003\t\u0019\u0001C\u0004\u0002 \u0002!\t!a\u0001\t\u000f\u0005\r\u0006\u0001\"\u0003\u0002&\"9\u0011q\u0017\u0001\u0005\n\u0005e\u0006bBAf\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003\u001f\u0004A\u0011AA\u0002\u0011\u001d\t\u0019\u000e\u0001C\u0001\u0003\u0007Aq!a6\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\\\u0002!I!!8\t\u000f\u0005\u0005\b\u0001\"\u0003\u0002d\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\bbBA\u007f\u0001\u0011\u0005\u0011q \u0005\b\u0005\u0013\u0001A\u0011AA\u0002\u0011\u001d\u0011i\u0001\u0001C\u0005\u0005\u001f9qA!\t0\u0011\u0003\u0011\u0019C\u0002\u0004/_!\u0005!Q\u0005\u0005\u0007w)\"\tAa\n\t\u000f\u0005\u0015#\u0006\"\u0001\u0003*!9\u0011Q\u000e\u0016\u0005\u0002\tm\"aE!mi\u0016\u0014\u0018j\u001d:NC:\fw-\u001a:UKN$(B\u0001\u00192\u0003\u0019\u0019XM\u001d<fe*\t!'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0004C\u0001\u001c:\u001b\u00059$\"\u0001\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005i:$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002{A\u0011a\bA\u0007\u0002_\u0005)Ao\u001c9jGV\t\u0011\t\u0005\u0002C\u000f6\t1I\u0003\u0002E\u000b\u0006!A.\u00198h\u0015\u00051\u0015\u0001\u00026bm\u0006L!\u0001S\"\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!A/[7f+\u0005a\u0005CA'Q\u001b\u0005q%BA(2\u0003\u0015)H/\u001b7t\u0013\t\tfJ\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012!\u0016\t\u0003-~k\u0011a\u0016\u0006\u0003'bS!!\u0017.\u0002\r\r|W.\\8o\u0015\t\u00114L\u0003\u0002];\u00061\u0011\r]1dQ\u0016T\u0011AX\u0001\u0004_J<\u0017B\u00011X\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\tEJ|7.\u001a:JIV\tA\r\u0005\u00027K&\u0011am\u000e\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0003)\u0004\"AP6\n\u00051|#\u0001\t\"s_.,'\u000fV8D_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2l\u0015M\\1hKJ\faC\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe~#S-\u001d\u000b\u0003_J\u0004\"A\u000e9\n\u0005E<$\u0001B+oSRDqa]\u0006\u0002\u0002\u0003\u0007!.A\u0002yIE\n1C\u0019:pW\u0016\u0014Hk\\\"p]R\u0014x\u000e\u001c7fe\u0002\n1\u0001\u001e91+\u00059\bC\u0001=z\u001b\u0005A\u0016B\u0001>Y\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fA\u0001\u001e91A\u0005\u0019A\u000f]\u0019\u0002\tQ\u0004\u0018\u0007I\u0001\u0004iB\u0014\u0014\u0001\u0002;qe\u0001\nQa]3ukB$\u0012a\u001c\u0015\u0004'\u0005\u001d\u0001\u0003BA\u0005\u0003/i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0004CBL'\u0002BA\t\u0003'\tqA[;qSR,'OC\u0002\u0002\u0016u\u000bQA[;oSRLA!!\u0007\u0002\f\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0013Q,7\u000f\u001e\"bg&\u001cGcA8\u0002 !9\u0011\u0011\u0005\u000bA\u0002\u0005\r\u0012AC1qSZ+'o]5p]B!\u0011QEA\u0015\u001b\t\t9CC\u0002\u0002\u000eEJA!a\u000b\u0002(\tQ\u0011\t]5WKJ\u001c\u0018n\u001c8)\u000fQ\ty#a\u0010\u0002BA!\u0011\u0011GA\u001e\u001b\t\t\u0019D\u0003\u0003\u00026\u0005]\u0012\u0001\u00039s_ZLG-\u001a:\u000b\t\u0005e\u0012qB\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005u\u00121\u0007\u0002\r\u001b\u0016$\bn\u001c3T_V\u00148-Z\u0001\u0006m\u0006dW/\u001a\u0017\u0003\u0003\u0007\n#!!\u0012\u0002%A\u0014xN^5eK\u0006\u0003\u0018NV3sg&|gn\u001d\u0015\u0004)\u0005%\u0003\u0003BA&\u0003\u001bj!!a\u000e\n\t\u0005=\u0013q\u0007\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018\u0001\t;fgR\u0014\u0015m]5d'\u0016tG\u000fT3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018p\u0015;bi\u0016$Ra\\A+\u0003/Bq!!\t\u0016\u0001\u0004\t\u0019\u0003C\u0004\u0002ZU\u0001\r!a\u0017\u0002'1,\u0017\rZ3s%\u0016\u001cwN^3ssN#\u0018\r^3\u0011\t\u0005u\u00131M\u0007\u0003\u0003?R1!!\u0019[\u0003!iW\r^1eCR\f\u0017\u0002BA3\u0003?\u00121\u0003T3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018p\u0015;bi\u0016Ds!FA\u0018\u0003\u007f\tI\u0007\f\u0002\u0002l\u0005\u0012\u0011QN\u0001\u001baJ|g/\u001b3f\u0019\u0016\fG-\u001a:SK\u000e|g/\u001a:z'R\fG/\u001a\u0015\u0004+\u0005%\u0013\u0001\u0007;fgR|e/\u001a:xe&$XmV5uQ&t')\u0019;dQR\u0019q.!\u001e\t\u000f\u0005\u0005b\u00031\u0001\u0002$!:a#a\f\u0002@\u0005eDFAA\"Q\r1\u0012\u0011J\u0001\u0010i\u0016\u001cHoU5oO2,')\u0019;dQR\u0019q.!!\t\u000f\u0005\u0005r\u00031\u0001\u0002$!:q#a\f\u0002@\u0005\u0015EFAA\"Q\r9\u0012\u0011J\u0001\u0018i\u0016\u001cH/Q;uQ>\u0014\u0018N_1uS>tg)Y5mK\u0012D3\u0001GAG!\u0011\tI!a$\n\t\u0005E\u00151\u0002\u0002\u0005)\u0016\u001cH/\u0001\u000buKN$8\u000b^1mK\n\u0013xn[3s\u000bB|7\r\u001b\u0015\u00043\u00055\u0015!\u0005;fgR,fn\u001b8po:\u001cVM\u001d<fe\"\u001a!$!$\u0002AQ,7\u000f\u001e*fiJLxJ\\!vi\",g\u000e^5dCRLwN\u001c$bS2,(/\u001a\u0015\u00047\u00055\u0015A\t;fgR\u0014V\r\u001e:z\u001f:,fn];qa>\u0014H/\u001a3WKJ\u001c\u0018n\u001c8FeJ|'\u000fK\u0002\u001d\u0003\u001b\u000b\u0001\u0004^3tiJ+GO]=P]R{\u0007\u000fT3wK2,%O]8s)\ry\u0017q\u0015\u0005\b\u0003Sk\u0002\u0019AAV\u0003\u0015)'O]8s!\u0011\ti+a-\u000e\u0005\u0005=&bAAY1\u0006A\u0001O]8u_\u000e|G.\u0003\u0003\u00026\u0006=&AB#se>\u00148/\u0001\ruKN$(+\u001a;ss>sWI\u001d:peJ+7\u000f]8og\u0016$2a\\A^\u0011\u001d\tiL\ba\u0001\u0003\u007f\u000b\u0001B]3ta>t7/\u001a\t\u0005\u0003\u0003\f9-\u0004\u0002\u0002D*\u0019\u0011Q\u0019.\u0002\u000f\rd\u0017.\u001a8ug&!\u0011\u0011ZAb\u00059\u0019E.[3oiJ+7\u000f]8og\u0016\f\u0001\u0004^3ti&sg/\u00197jIV\u0003H-\u0019;f-\u0016\u00148/[8oQ\ry\u0012QR\u0001\u001ai\u0016\u001cH/\u00168l]><h\u000eV8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eK\u0002!\u0003\u001b\u000bq\u0003^3ti:{G\u000fT3bI\u0016\u0014xJ\u001d$pY2|w/\u001a:)\u0007\u0005\ni)\u0001\nuKN$\u0018J\u001c<bY&$'+Z9vKN$\bf\u0001\u0012\u0002\u000e\u0006\u00192\r[3dWB\u000b'\u000f^5uS>tWI\u001d:peR\u0019q.a8\t\u000f\u0005%6\u00051\u0001\u0002,\u0006\u0011B/Z:u!\u0006\u0014H/\u001b;j_:,%O]8s)\u0019\t)/a;\u0002pB\u0019a(a:\n\u0007\u0005%xFA\bBYR,'/S:s\u001b\u0006t\u0017mZ3s\u0011\u0019\ti\u000f\na\u0001o\u0006\u0011A\u000f\u001d\u0005\b\u0003S#\u0003\u0019AAV\u0003=!Xm\u001d;P]\u0016LeN\u00127jO\"$HcA8\u0002v\"9\u0011\u0011E\u0013A\u0002\u0005\r\u0002fB\u0013\u00020\u0005}\u0012\u0011 \u0017\u0003\u0003\u0007B3!JA%\u0003y!Xm\u001d;QCJ$\u0018\u000e^5p]6K7o]5oO&s'+Z:q_:\u001cX\rF\u0002p\u0005\u0003Aq!!\t'\u0001\u0004\t\u0019\u0003K\u0004'\u0003_\tyD!\u0002-\u0005\u0005\r\u0003f\u0001\u0014\u0002J\u0005YA/Z:u5.\u0014\u0015m]5dQ\r9\u0013QR\u0001\u0012a\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,GC\u0002B\t\u0005;\u0011y\u0002\u0005\u0003\u0003\u0014\teQB\u0001B\u000b\u0015\r\u00119\u0002W\u0001\te\u0016\fX/Z:ug&!!1\u0004B\u000b\u0005Y\tE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,\u0007BBAwQ\u0001\u0007q\u000fC\u0004\u0002*\"\u0002\r!a+\u0002'\u0005cG/\u001a:JgJl\u0015M\\1hKJ$Vm\u001d;\u0011\u0005yR3C\u0001\u00166)\t\u0011\u0019\u0003\u0006\u0002\u0003,A1!Q\u0006B\u001c\u0003Gi!Aa\f\u000b\t\tE\"1G\u0001\u0007gR\u0014X-Y7\u000b\u0007\tUR)\u0001\u0003vi&d\u0017\u0002\u0002B\u001d\u0005_\u0011aa\u0015;sK\u0006lGC\u0001B\u001f!\u0019\u0011iCa\u000e\u0003@A!\u0011\u0011\u0007B!\u0013\u0011\u0011\u0019%a\r\u0003\u0013\u0005\u0013x-^7f]R\u001c\b")
public class AlterIsrManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicPartition tp0 = new TopicPartition(this.topic(), 0);
    private final TopicPartition tp1 = new TopicPartition(this.topic(), 1);
    private final TopicPartition tp2 = new TopicPartition(this.topic(), 2);

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterIsrManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<ApiVersion> provideApiVersions() {
        return AlterIsrManagerTest$.MODULE$.provideApiVersions();
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicPartition tp0() {
        return this.tp0;
    }

    public TopicPartition tp1() {
        return this.tp1;
    }

    public TopicPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testBasic(ApiVersion apiVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(ApiVersion apiVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        Assertions.assertEquals((byte)(apiVersion.$greater$eq((Object)KAFKA_3_2_IV0$.MODULE$) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED).value(), (byte)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).leaderRecoveryState());
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testOverwriteWithinBatch(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        Assertions.assertFalse((boolean)alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        CompletableFuture failedSubmitFuture = alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10), 0);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testSingleBatch(ApiVersion apiVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(new TopicPartition(this.topic(), 0), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable & scala.Serializable)i -> alterIsrManager.submit(new TopicPartition(this.topic(), BoxesRunTime.unboxToInt((Object)i)), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), leaderAndIsr, 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE);
        ClientResponse retryResponse = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)retryAlterPartitionResponse);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterIsrManager.unsentIsrUpdates().containsKey(this.tp0()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
    }

    private AlterIsrManager testPartitionError(TopicPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (ApiVersion)KAFKA_3_2_IV0$.MODULE$);
        alterIsrManager.start();
        CompletableFuture future = alterIsrManager.submit(tp, new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error);
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterIsrManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testOneInFlight(ApiVersion apiVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, apiVersion);
        alterIsrManager.start();
        alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterIsrManager.submit(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterIsrManager.submit(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideApiVersions"})
    public void testPartitionMissingInResponse(ApiVersion apiVersion) {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterIsrManager alterIsrManager = new DefaultAlterIsrManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> brokerEpoch, apiVersion);
        alterIsrManager.start();
        CompletableFuture future1 = alterIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ControllerRequestCompletionHandler callback1 = this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp0()})));
        CompletableFuture future2 = alterIsrManager.submit(this.tp1(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        CompletableFuture future3 = alterIsrManager.submit(this.tp2(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        callback1.onComplete(this.clientResponse$1(this.tp0(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1(), this.tp2()}))).onComplete(this.clientResponse$1(this.tp2(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendAlterIsr$1((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp1()}))).onComplete(this.clientResponse$1(this.tp1(), Errors.UNKNOWN_SERVER_ERROR));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$1 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$2 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkIsrManager zkIsrManager = new ZkIsrManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1), 0);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), new LeaderAndIsr(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3), 0);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    private AlterPartitionResponse partitionResponse(TopicPartition tp, Errors error) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setName(tp.topic()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setErrorCode(error.code()))))));
    }

    private static final AbstractRequest.Builder matchesAlterIsr$1(Set topicPartitions) {
        return (AbstractRequest.Builder)ArgumentMatchers.argThat(request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Set requestTopicPartitions = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(alterPartitionRequest.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)topicData -> {
                String topic = topicData.name();
                return (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicData.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)partitionData -> new TopicPartition(topic, partitionData.partitionIndex()), Buffer$.MODULE$.canBuildFrom());
            }, Buffer$.MODULE$.canBuildFrom())).toSet();
            Set set = topicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        });
    }

    private final ControllerRequestCompletionHandler verifySendAlterIsr$1(Set topicPartitions) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest(AlterIsrManagerTest.matchesAlterIsr$1(topicPartitions), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private final ClientResponse clientResponse$1(TopicPartition topicPartition, Errors error) {
        AlterPartitionResponse alterIsrResponse = this.partitionResponse(topicPartition, error);
        return new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterIsrResponse);
    }

    public AlterIsrManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

