/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Set;
import kafka.api.ApiVersion$;
import kafka.server.BrokerFeatures;
import kafka.server.BrokerFeatures$;
import kafka.server.DefaultApiVersionManager;
import kafka.server.FinalizedFeatureCache;
import kafka.server.ForwardingManager;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U4Aa\u0003\u0007\u0001#!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0013i\u0002BB\u0011\u0001A\u0003%a\u0004C\u0004#\u0001\t\u0007I\u0011B\u0012\t\r\u001d\u0002\u0001\u0015!\u0003%\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u0015I\u0007\u0001\"\u0001b\u0011\u0015Y\u0007\u0001\"\u0001b\u0011\u0015\u0019\b\u0001\"\u0001b\u0005U\t\u0005/\u001b,feNLwN\\'b]\u0006<WM\u001d+fgRT!!\u0004\b\u0002\rM,'O^3s\u0015\u0005y\u0011!B6bM.\f7\u0001A\n\u0003\u0001I\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001b!\tY\u0002!D\u0001\r\u00039\u0011'o\\6fe\u001a+\u0017\r^;sKN,\u0012A\b\t\u00037}I!\u0001\t\u0007\u0003\u001d\t\u0013xn[3s\r\u0016\fG/\u001e:fg\u0006y!M]8lKJ4U-\u0019;ve\u0016\u001c\b%\u0001\u0007gK\u0006$XO]3DC\u000eDW-F\u0001%!\tYR%\u0003\u0002'\u0019\t)b)\u001b8bY&TX\r\u001a$fCR,(/Z\"bG\",\u0017!\u00044fCR,(/Z\"bG\",\u0007%\u0001\u0007uKN$\u0018\t]5TG>\u0004X\r\u0006\u0002+[A\u00111cK\u0005\u0003YQ\u0011A!\u00168ji\")aF\u0002a\u0001_\u0005A\u0011\r]5TG>\u0004X\r\u0005\u00021\u0013:\u0011\u0011G\u0012\b\u0003e\rs!a\r!\u000f\u0005QrdBA\u001b<\u001d\t1\u0014(D\u00018\u0015\tA\u0004#\u0001\u0004=e>|GOP\u0005\u0002u\u0005\u0019qN]4\n\u0005qj\u0014AB1qC\u000eDWMC\u0001;\u0013\tyqH\u0003\u0002={%\u0011\u0011IQ\u0001\u0007G>lWn\u001c8\u000b\u0005=y\u0014B\u0001#F\u0003\u001diWm]:bO\u0016T!!\u0011\"\n\u0005\u001dC\u0015AD!qS6+7o]1hKRK\b/\u001a\u0006\u0003\t\u0016K!AS&\u0003\u00191K7\u000f^3oKJ$\u0016\u0010]3\u000b\u0005\u001dC\u0005\u0006\u0002\u0004N3j\u0003\"AT,\u000e\u0003=S!\u0001U)\u0002\u0011A\u0014xN^5eKJT!AU*\u0002\rA\f'/Y7t\u0015\t!V+A\u0004kkBLG/\u001a:\u000b\u0005Yk\u0014!\u00026v]&$\u0018B\u0001-P\u0005))e.^7T_V\u00148-Z\u0001\u0006m\u0006dW/Z\u0012\u0002_!\u0012a\u0001\u0018\t\u0003;zk\u0011!U\u0005\u0003?F\u0013\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003u!Xm\u001d;D_:$(o\u001c7mKJ\f\u0005/[%oi\u0016\u00148/Z2uS>tG#\u0001\u0016)\u0005\u001d\u0019\u0007C\u00013h\u001b\u0005)'B\u00014T\u0003\r\t\u0007/[\u0005\u0003Q\u0016\u0014A\u0001V3ti\u0006\u0011C/Z:u\u000b:4X\r\\8qK\u0012K7/\u00192mK\u00124uN]&SC\u001a$(I]8lKJD#\u0001C2\u0002_Q,7\u000f^#om\u0016dw\u000e]3F]\u0006\u0014G.\u001a3XQ\u0016tgi\u001c:xCJ$\u0017N\\4NC:\fw-\u001a:Qe\u0016\u001cXM\u001c;)\u0005%\u0019\u0007\u0006B\u0005o3F\u0004\"\u0001Z8\n\u0005A,'\u0001\u0003#jg\u0006\u0014G.\u001a3\"\u0003I\fQ'\u00128bE2,\u0007%\u00194uKJ\u0004SM\\1cY\u0016\u00043*\u0013).ke\u0002\u0004EZ8so\u0006\u0014H-\u001b8hA%t\u0007eS!G\u0017\u0006k\u0013G\r\u001d9m\u0005qC/Z:u\u000b:4X\r\\8qK\u0012K7/\u00192mK\u0012<\u0006.\u001a8G_J<\u0018M\u001d3j]\u001el\u0015M\\1hKJ,U\u000e\u001d;zQ\tQ1\r")
public class ApiVersionManagerTest {
    private final BrokerFeatures brokerFeatures = BrokerFeatures$.MODULE$.createDefault();
    private final FinalizedFeatureCache featureCache = new FinalizedFeatureCache(this.brokerFeatures());

    private BrokerFeatures brokerFeatures() {
        return this.brokerFeatures;
    }

    private FinalizedFeatureCache featureCache() {
        return this.featureCache;
    }

    @ParameterizedTest
    @EnumSource(value=ApiMessageType.ListenerType.class)
    public void testApiScope(ApiMessageType.ListenerType apiScope) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(apiScope, ApiVersion$.MODULE$.latestVersion(), (Option)None$.MODULE$, this.brokerFeatures(), this.featureCache());
        Assertions.assertEquals((Object)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala(), (Object)versionManager.enabledApis());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)apiScope)).asScala()).forall((Function1 & Serializable & scala.Serializable)apiKey -> BoxesRunTime.boxToBoolean((boolean)versionManager.isApiEnabled(apiKey))));
    }

    @Test
    public void testControllerApiIntersection() {
        short controllerMinVersion = 1;
        short controllerMaxVersion = 5;
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)new Some((Object)NodeApiVersions.create((short)ApiKeys.CREATE_TOPICS.id, (short)controllerMinVersion, (short)controllerMaxVersion)));
        ApiVersionsResponseData.ApiVersion alterConfigVersion = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, ApiVersion$.MODULE$.latestVersion(), (Option)new Some((Object)forwardingManager), this.brokerFeatures(), this.featureCache()).apiVersionResponse(0).data().apiKeys().find(ApiKeys.CREATE_TOPICS.id);
        Assertions.assertNotNull((Object)alterConfigVersion);
        Assertions.assertEquals((short)controllerMinVersion, (short)alterConfigVersion.minVersion());
        Assertions.assertEquals((short)controllerMaxVersion, (short)alterConfigVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledForKRaftBroker() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        new .colon.colon((Object)new Some((Object)forwardingManager), (List)new .colon.colon((Object)None$.MODULE$, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)forwardingManagerOpt -> {
            ApiVersionManagerTest.$anonfun$testEnvelopeDisabledForKRaftBroker$1(this, forwardingManagerOpt);
            return BoxedUnit.UNIT;
        });
    }

    @Disabled(value="Enable after enable KIP-590 forwarding in KAFKA-12886")
    @Test
    public void testEnvelopeEnabledWhenForwardingManagerPresent() {
        ForwardingManager forwardingManager = (ForwardingManager)Mockito.mock(ForwardingManager.class);
        Mockito.when((Object)forwardingManager.controllerApiVersions()).thenReturn((Object)None$.MODULE$);
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, ApiVersion$.MODULE$.latestVersion(), (Option)new Some((Object)forwardingManager), this.brokerFeatures(), this.featureCache());
        Assertions.assertTrue((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE));
        Assertions.assertTrue((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        ApiVersionsResponseData.ApiVersion envelopeVersion = versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id);
        Assertions.assertNotNull((Object)envelopeVersion);
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.oldestVersion(), (short)envelopeVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.ENVELOPE.latestVersion(), (short)envelopeVersion.maxVersion());
    }

    @Test
    public void testEnvelopeDisabledWhenForwardingManagerEmpty() {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.ZK_BROKER, ApiVersion$.MODULE$.latestVersion(), (Option)None$.MODULE$, this.brokerFeatures(), this.featureCache());
        Assertions.assertFalse((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE));
        Assertions.assertFalse((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }

    public static final /* synthetic */ void $anonfun$testEnvelopeDisabledForKRaftBroker$1(ApiVersionManagerTest $this, Option forwardingManagerOpt) {
        DefaultApiVersionManager versionManager = new DefaultApiVersionManager(ApiMessageType.ListenerType.BROKER, ApiVersion$.MODULE$.latestVersion(), forwardingManagerOpt, $this.brokerFeatures(), $this.featureCache());
        Assertions.assertFalse((boolean)versionManager.isApiEnabled(ApiKeys.ENVELOPE));
        Assertions.assertFalse((boolean)versionManager.enabledApis().contains((Object)ApiKeys.ENVELOPE));
        Assertions.assertNull((Object)versionManager.apiVersionResponse(0).data().apiKeys().find(ApiKeys.ENVELOPE.id));
    }
}

