/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import kafka.network.RequestChannel;
import kafka.raft.RaftManager;
import kafka.server.ApiVersionManager;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientRequestQuotaManager;
import kafka.server.ControllerApis;
import kafka.server.ControllerMutationQuotaManager;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetaProperties;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.RequestLocal$;
import kafka.server.SimpleApiVersionManager;
import kafka.test.MockController;
import kafka.utils.MockTime;
import kafka.utils.NotNothing;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.common.ElectionType;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.NotControllerException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AlterClientQuotasRequestData;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.AlterPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.BeginQuorumEpochRequestData;
import org.apache.kafka.common.message.BrokerHeartbeatRequestData;
import org.apache.kafka.common.message.BrokerRegistrationRequestData;
import org.apache.kafka.common.message.CreatePartitionsRequestData;
import org.apache.kafka.common.message.CreatePartitionsResponseData;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.DeleteTopicsResponseData;
import org.apache.kafka.common.message.DescribeQuorumRequestData;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.message.EndQuorumEpochRequestData;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchSnapshotRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.message.ListPartitionReassignmentsRequestData;
import org.apache.kafka.common.message.UnregisterBrokerRequestData;
import org.apache.kafka.common.message.VoteRequestData;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AlterClientQuotasRequest;
import org.apache.kafka.common.requests.AlterConfigsRequest;
import org.apache.kafka.common.requests.AlterConfigsResponse;
import org.apache.kafka.common.requests.AlterPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.BeginQuorumEpochRequest;
import org.apache.kafka.common.requests.BrokerHeartbeatRequest;
import org.apache.kafka.common.requests.BrokerRegistrationRequest;
import org.apache.kafka.common.requests.BrokerRegistrationResponse;
import org.apache.kafka.common.requests.CreatePartitionsRequest;
import org.apache.kafka.common.requests.CreatePartitionsResponse;
import org.apache.kafka.common.requests.DescribeQuorumRequest;
import org.apache.kafka.common.requests.ElectLeadersRequest;
import org.apache.kafka.common.requests.ElectLeadersResponse;
import org.apache.kafka.common.requests.EndQuorumEpochRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchSnapshotRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsRequest;
import org.apache.kafka.common.requests.IncrementalAlterConfigsResponse;
import org.apache.kafka.common.requests.ListPartitionReassignmentsRequest;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.UnregisterBrokerRequest;
import org.apache.kafka.common.requests.VoteRequest;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tUh\u0001B!C\u0001\u001dCQA\u0014\u0001\u0005\u0002=CqA\u0015\u0001C\u0002\u0013%1\u000b\u0003\u0004X\u0001\u0001\u0006I\u0001\u0016\u0005\b1\u0002\u0011\r\u0011\"\u0003Z\u0011\u0019\u0011\u0007\u0001)A\u00055\"91\r\u0001b\u0001\n\u0013I\u0006B\u00023\u0001A\u0003%!\fC\u0004f\u0001\t\u0007I\u0011\u00024\t\rE\u0004\u0001\u0015!\u0003h\u0011\u001d\u0011\bA1A\u0005\nMDaa\u001e\u0001!\u0002\u0013!\bb\u0002=\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u0003\u0001\u0001\u0015!\u0003{\u0011%\t\u0019\u0001\u0001b\u0001\n\u0013\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0004\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u0002\u001a\u0001\u0001\u000b\u0011BA\n\u0011%\tY\u0002\u0001b\u0001\n\u0013\ti\u0002\u0003\u0005\u0002&\u0001\u0001\u000b\u0011BA\u0010\u0011%\t9\u0003\u0001b\u0001\n\u0013\tI\u0003\u0003\u0005\u00022\u0001\u0001\u000b\u0011BA\u0016\u0011%\t\u0019\u0004\u0001b\u0001\n\u0013\t)\u0004\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA\u001c\u0011%\ti\u0006\u0001b\u0001\n\u0013\ty\u0006\u0003\u0005\u0002~\u0001\u0001\u000b\u0011BA1\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003C\u0011\"a/\u0001#\u0003%I!!0\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"I!1\u0002\u0001\u0012\u0002\u0013%!Q\u0002\u0005\b\u0005+\u0001A\u0011\u0001B\f\u0011\u001d\u0011I\u0002\u0001C\u0001\u00057AqA!\u000f\u0001\t\u0003\u0011Y\u0002C\u0004\u0003>\u0001!\tAa\u0007\t\u000f\t\u0005\u0003\u0001\"\u0001\u0003\u001c!9!Q\t\u0001\u0005\u0002\tm\u0001b\u0002B%\u0001\u0011\u0005!1\u0004\u0005\b\u0005\u001b\u0002A\u0011\u0001B\u000e\u0011\u001d\u0011\t\u0006\u0001C\u0001\u00057AqA!\u0016\u0001\t\u0003\u0011Y\u0002C\u0004\u0003Z\u0001!\tAa\u0007\t\u000f\tu\u0003\u0001\"\u0001\u0003\u001c!9!\u0011\r\u0001\u0005\u0002\tm\u0001b\u0002B3\u0001\u0011\u0005!1\u0004\u0005\b\u0005S\u0002A\u0011\u0001B\u000e\u0011\u001d\u0011i\u0007\u0001C\u0001\u00057AqA!\u001d\u0001\t\u0003\u0011Y\u0002C\u0004\u0003v\u0001!\tAa\u0007\t\u000f\te\u0004\u0001\"\u0001\u0003\u001c!9!Q\u0010\u0001\u0005\u0002\tm\u0001b\u0002BA\u0001\u0011\u0005!1\u0004\u0005\b\u0005\u000b\u0003A\u0011\u0001B\u000e\u0011\u001d\u0011I\t\u0001C\u0001\u00057AqA!$\u0001\t\u0003\u0011Y\u0002C\u0004\u0003\u0012\u0002!\tAa\u0007\t\u000f\tU\u0005\u0001\"\u0001\u0003\u001c!9!\u0011\u0014\u0001\u0005\u0002\tm\u0001b\u0002BO\u0001\u0011\u0005!1\u0004\u0005\b\u0005C\u0003A\u0011\u0001B\u000e\u0011\u001d\u0011)\u000b\u0001C\u0001\u00057AqA!+\u0001\t\u0003\u0011Y\u0002C\u0004\u0003.\u0002!\tAa\u0007\t\u000f\tE\u0006\u0001\"\u0001\u0003\u001c!9!Q\u0017\u0001\u0005\n\t]\u0006b\u0002Bv\u0001\u0011\u0005!1\u0004\u0002\u0013\u0007>tGO]8mY\u0016\u0014\u0018\t]5t)\u0016\u001cHO\u0003\u0002D\t\u000611/\u001a:wKJT\u0011!R\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\n\u0005\u0002J\u00196\t!JC\u0001L\u0003\u0015\u00198-\u00197b\u0013\ti%J\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0003\"!\u0015\u0001\u000e\u0003\t\u000baA\\8eK&#W#\u0001+\u0011\u0005%+\u0016B\u0001,K\u0005\rIe\u000e^\u0001\b]>$W-\u00133!\u0003)\u0011'o\\6feJ\u000b7m[\u000b\u00025B\u00111\fY\u0007\u00029*\u0011QLX\u0001\u0005Y\u0006twMC\u0001`\u0003\u0011Q\u0017M^1\n\u0005\u0005d&AB*ue&tw-A\u0006ce>\\WM\u001d*bG.\u0004\u0013\u0001C2mS\u0016tG/\u0013#\u0002\u0013\rd\u0017.\u001a8u\u0013\u0012\u0003\u0013!\u0006:fcV,7\u000f^\"iC:tW\r\\'fiJL7m]\u000b\u0002OB\u0011\u0001N\u001c\b\u0003S2l\u0011A\u001b\u0006\u0003W\u0012\u000bqA\\3uo>\u00148.\u0003\u0002nU\u0006q!+Z9vKN$8\t[1o]\u0016d\u0017BA8q\u0005\u001diU\r\u001e:jGNT!!\u001c6\u0002-I,\u0017/^3ti\u000eC\u0017M\u001c8fY6+GO]5dg\u0002\naB]3rk\u0016\u001cHo\u00115b]:,G.F\u0001u!\tIW/\u0003\u0002wU\nq!+Z9vKN$8\t[1o]\u0016d\u0017a\u0004:fcV,7\u000f^\"iC:tW\r\u001c\u0011\u0002\tQLW.Z\u000b\u0002uB\u00111P`\u0007\u0002y*\u0011Q\u0010R\u0001\u0006kRLGn]\u0005\u0003\u007fr\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0013G2LWM\u001c;Rk>$\u0018-T1oC\u001e,'/\u0006\u0002\u0002\bA\u0019\u0011+!\u0003\n\u0007\u0005-!I\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\u0018aE2mS\u0016tG/U;pi\u0006l\u0015M\\1hKJ\u0004\u0013!G2mS\u0016tGOU3rk\u0016\u001cH/U;pi\u0006l\u0015M\\1hKJ,\"!a\u0005\u0011\u0007E\u000b)\"C\u0002\u0002\u0018\t\u0013\u0011d\u00117jK:$(+Z9vKN$\u0018+^8uC6\u000bg.Y4fe\u0006Q2\r\\5f]R\u0014V-];fgR\fVo\u001c;b\u001b\u0006t\u0017mZ3sA\u0005a2\r\\5f]R\u001cuN\u001c;s_2dWM])v_R\fW*\u00198bO\u0016\u0014XCAA\u0010!\r\t\u0016\u0011E\u0005\u0004\u0003G\u0011%AH\"p]R\u0014x\u000e\u001c7fe6+H/\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003u\u0019G.[3oi\u000e{g\u000e\u001e:pY2,'/U;pi\u0006l\u0015M\\1hKJ\u0004\u0013a\u0005:fa2L7-Y)v_R\fW*\u00198bO\u0016\u0014XCAA\u0016!\r\t\u0016QF\u0005\u0004\u0003_\u0011%a\u0006*fa2L7-\u0019;j_:\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0003Q\u0011X\r\u001d7jG\u0006\fVo\u001c;b\u001b\u0006t\u0017mZ3sA\u0005Y!/\u00194u\u001b\u0006t\u0017mZ3s+\t\t9\u0004\u0005\u0004\u0002:\u0005}\u00121I\u0007\u0003\u0003wQ1!!\u0010E\u0003\u0011\u0011\u0018M\u001a;\n\t\u0005\u0005\u00131\b\u0002\f%\u00064G/T1oC\u001e,'\u000f\u0005\u0003\u0002F\u0005]SBAA$\u0015\u0011\tI%a\u0013\u0002\r\r|W.\\8o\u0015\r\u0019\u0015Q\n\u0006\u0004\u000b\u0006=#\u0002BA)\u0003'\na!\u00199bG\",'BAA+\u0003\ry'oZ\u0005\u0005\u00033\n9E\u0001\u000bBa&lUm]:bO\u0016\fe\u000e\u001a,feNLwN\\\u0001\re\u00064G/T1oC\u001e,'\u000fI\u0001\u0007cV|G/Y:\u0016\u0005\u0005\u0005\u0004\u0003BA2\u0003orA!!\u001a\u0002t9!\u0011qMA9\u001d\u0011\tI'a\u001c\u000e\u0005\u0005-$bAA7\r\u00061AH]8pizJ\u0011!R\u0005\u0003\u0007\u0012K1!!\u001eC\u00031\tVo\u001c;b\r\u0006\u001cGo\u001c:z\u0013\u0011\tI(a\u001f\u0003\u001bE+x\u000e^1NC:\fw-\u001a:t\u0015\r\t)HQ\u0001\bcV|G/Y:!\u0003Q\u0019'/Z1uK\u000e{g\u000e\u001e:pY2,'/\u00119jgRA\u00111QAE\u0003;\u000bY\u000bE\u0002R\u0003\u000bK1!a\"C\u00059\u0019uN\u001c;s_2dWM]!qSNDq!a#\u001b\u0001\u0004\ti)\u0001\u0006bkRDwN]5{KJ\u0004R!SAH\u0003'K1!!%K\u0005\u0019y\u0005\u000f^5p]B!\u0011QSAM\u001b\t\t9J\u0003\u0003\u0002\f\u0006-\u0013\u0002BAN\u0003/\u0013!\"Q;uQ>\u0014\u0018N_3s\u0011\u001d\tyJ\u0007a\u0001\u0003C\u000b!bY8oiJ|G\u000e\\3s!\u0011\t\u0019+a*\u000e\u0005\u0005\u0015&\u0002BAP\u0003\u001bJA!!+\u0002&\nQ1i\u001c8ue>dG.\u001a:\t\u0013\u00055&\u0004%AA\u0002\u0005=\u0016!\u00029s_B\u001c\b\u0003BAY\u0003ok!!a-\u000b\u0007\u0005Uf,\u0001\u0003vi&d\u0017\u0002BA]\u0003g\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003y\u0019'/Z1uK\u000e{g\u000e\u001e:pY2,'/\u00119jg\u0012\"WMZ1vYR$3'\u0006\u0002\u0002@*\"\u0011qVAaW\t\t\u0019\r\u0005\u0003\u0002F\u0006=WBAAd\u0015\u0011\tI-a3\u0002\u0013Ut7\r[3dW\u0016$'bAAg\u0015\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005E\u0017q\u0019\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00042vS2$'+Z9vKN$X\u0003BAl\u0003\u007f$b!!7\u0002`\u0006E\bc\u00015\u0002\\&\u0019\u0011Q\u001c9\u0003\u000fI+\u0017/^3ti\"9\u0011\u0011\u001d\u000fA\u0002\u0005\r\u0018a\u0002:fcV,7\u000f\u001e\t\u0005\u0003K\fi/\u0004\u0002\u0002h*!\u0011\u0011^Av\u0003!\u0011X-];fgR\u001c(\u0002BA%\u0003\u001bJA!a<\u0002h\ny\u0011IY:ue\u0006\u001cGOU3rk\u0016\u001cH\u000fC\u0005\u0002tr\u0001\n\u00111\u0001\u0002v\u0006aA.[:uK:,'OT1nKB!\u0011q_A~\u001b\t\tIPC\u0002l\u0003WLA!!@\u0002z\naA*[:uK:,'OT1nK\u00129!\u0011\u0001\u000fC\u0002\t\r!!\u0001+\u0012\t\t\u0015\u00111\u001d\t\u0004\u0013\n\u001d\u0011b\u0001B\u0005\u0015\n9aj\u001c;iS:<\u0017A\u00062vS2$'+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\t\t=!1C\u000b\u0003\u0005#QC!!>\u0002B\u00129!\u0011A\u000fC\u0002\t\r\u0011aF2sK\u0006$X\rR3os\u0006cG.Q;uQ>\u0014\u0018N_3s)\t\t\u0019*A\u000buKN$XK\\1vi\"|'/\u001b>fI\u001a+Go\u00195\u0015\u0005\tu\u0001cA%\u0003 %\u0019!\u0011\u0005&\u0003\tUs\u0017\u000e\u001e\u0015\u0004?\t\u0015\u0002\u0003\u0002B\u0014\u0005ki!A!\u000b\u000b\t\t-\"QF\u0001\u0004CBL'\u0002\u0002B\u0018\u0005c\tqA[;qSR,'O\u0003\u0003\u00034\u0005M\u0013!\u00026v]&$\u0018\u0002\u0002B\u001c\u0005S\u0011A\u0001V3ti\u0006!B/Z:u\r\u0016$8\r[*f]R$vn\u0013*bMRD3\u0001\tB\u0013\u0003u!Xm\u001d;V]\u0006,H\u000f[8sSj,GMR3uG\"\u001cf.\u00199tQ>$\bfA\u0011\u0003&\u0005aB/Z:u\r\u0016$8\r[*oCB\u001c\bn\u001c;TK:$Hk\\&SC\u001a$\bf\u0001\u0012\u0003&\u0005!B/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a,pi\u0016D3a\tB\u0013\u0003\t\"Xm\u001d;IC:$G.\u001a'fO\u0006\u001c\u00170\u00117uKJ\u001cuN\u001c4jON,%O]8sg\"\u001aAE!\n\u0002AQ,7\u000f^+oCV$\bn\u001c:ju\u0016$')Z4j]F+xN];n\u000bB|7\r\u001b\u0015\u0004K\t\u0015\u0012A\b;fgR,f.Y;uQ>\u0014\u0018N_3e\u000b:$\u0017+^8sk6,\u0005o\\2iQ\r1#QE\u0001\u001fi\u0016\u001cH/\u00168bkRDwN]5{K\u0012$Um]2sS\n,\u0017+^8sk6D3a\nB\u0013\u0003-\"Xm\u001d;V]\u0006,H\u000f[8sSj,G\rS1oI2,\u0017\t\u001c;feB\u000b'\u000f^5uS>t'+Z9vKN$\bf\u0001\u0015\u0003&\u0005aC/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a%b]\u0012dWM\u0011:pW\u0016\u0014\b*Z1si\n+\u0017\r\u001e*fcV,7\u000f\u001e\u0015\u0004S\t\u0015\u0012A\n;fgR,f.Y;uQ>\u0014\u0018N_3e\u0011\u0006tG\r\\3V]J,w-[:uKJ\u0014%o\\6fe\"\u001a!F!\n\u0002\u0013Q,7\u000f^\"m_N,\u0007fA\u0016\u0003&\u0005\u0011C/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a\"s_.,'OU3hSN$(/\u0019;j_:D3\u0001\fB\u0013\u0003\u001d\"Xm\u001d;V]\u0006,H\u000f[8sSj,G\rS1oI2,\u0017\t\u001c;fe\u000ec\u0017.\u001a8u#V|G/Y:)\u00075\u0012)#A\u0017uKN$XK\\1vi\"|'/\u001b>fI\"\u000bg\u000e\u001a7f\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jOND3A\fB\u0013\u0003-\"Xm\u001d;J]Z\fG.\u001b3J]\u000e\u0014X-\\3oi\u0006d\u0017\t\u001c;fe\u000e{gNZ5hgJ+7o\\;sG\u0016\u001c\bfA\u0018\u0003&\u0005\tD/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a%b]\u0012dW-\u00117uKJ\u0004\u0016M\u001d;ji&|gNU3bgNLwM\\7f]R\u001c\bf\u0001\u0019\u0003&\u0005IC/Z:u+:\fW\u000f\u001e5pe&TX\r\u001a%b]\u0012dW-\u00117m_\u000e\fG/\u001a)s_\u0012,8-\u001a:JIND3!\rB\u0013\u0003A\"Xm\u001d;V]\u0006,H\u000f[8sSj,G\rS1oI2,G*[:u!\u0006\u0014H/\u001b;j_:\u0014V-Y:tS\u001etW.\u001a8ug\"\u001a!G!\n\u0002!Q,7\u000f^\"sK\u0006$X\rV8qS\u000e\u001c\bfA\u001a\u0003&\u00051B/Z:u\t\u0016dW\r^3U_BL7m\u001d\"z\u001d\u0006lW\rK\u00025\u0005K\tA\u0003^3ti\u0012+G.\u001a;f)>\u0004\u0018nY:Cs&#\u0007fA\u001b\u0003&\u0005qB/Z:u\u0013:4\u0018\r\\5e\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e\u0015\u0004m\t\u0015\u0012A\u000b;fgRtu\u000e^!vi\"|'/\u001b>fIR{G)\u001a7fi\u0016<\u0016\u000e\u001e5U_BL7-\u0012=jgRLgn\u001a\u0015\u0004o\t\u0015\u0012!\f;fgRtu\u000e^!vi\"|'/\u001b>fIR{G)\u001a7fi\u0016<\u0016\u000e\u001e5U_BL7MT8u\u000bbL7\u000f^5oO\"\u001a\u0001H!\n\u0002YQ,7\u000f\u001e(pi\u000e{g\u000e\u001e:pY2,'/\u0012:s_J\u0004&/\u001a<f]R\u001cH)\u001a7fi&tw\rV8qS\u000e\u001c\bfA\u001d\u0003&\u0005AB/Z:u\t\u0016dW\r^3U_BL7m\u001d#jg\u0006\u0014G.\u001a3)\u0007i\u0012)#A\u000euKN$8I]3bi\u0016\u0004\u0016M\u001d;ji&|gn\u001d*fcV,7\u000f\u001e\u0015\u0004w\t\u0015\u0012!\t;fgR\u001c%/Z1uKB\u000b'\u000f^5uS>t7/Q;uQ>\u0014\u0018N_1uS>t\u0007f\u0001\u001f\u0003&\u0005iB/Z:u\u000b2,7\r\u001e'fC\u0012,'o]!vi\"|'/\u001b>bi&|g\u000eK\u0002>\u0005K\t1\u0005^3ti\u0016cWm\u0019;MK\u0006$WM]:IC:$G.\u001a3Cs\u000e{g\u000e\u001e:pY2,'\u000fK\u0002?\u0005K\tQ\u0002[1oI2,'+Z9vKN$X\u0003\u0002B]\u0005\u0003$bAa/\u0003f\n\u001dHC\u0002B_\u0005\u0017\u0014Y\u000e\u0005\u0003\u0003@\n\u0005G\u0002\u0001\u0003\b\u0005\u0003y$\u0019\u0001Bb#\u0011\u0011)A!2\u0011\t\u0005\u0015(qY\u0005\u0005\u0005\u0013\f9O\u0001\tBEN$(/Y2u%\u0016\u001c\bo\u001c8tK\"9!QZ A\u0004\t=\u0017\u0001C2mCN\u001cH+Y4\u0011\r\tE'q\u001bB_\u001b\t\u0011\u0019NC\u0002\u0003V*\u000bqA]3gY\u0016\u001cG/\u0003\u0003\u0003Z\nM'\u0001C\"mCN\u001cH+Y4\t\u000f\tuw\bq\u0001\u0003`\u0006\u0011aN\u001c\t\u0006w\n\u0005(QX\u0005\u0004\u0005Gd(A\u0003(pi:{G\u000f[5oO\"9\u0011\u0011] A\u0002\u0005\r\bb\u0002Bu\u007f\u0001\u0007\u00111Q\u0001\u000fG>tGO]8mY\u0016\u0014\u0018\t]5t\u0003!!X-\u0019:E_^t\u0007f\u0001!\u0003pB!!q\u0005By\u0013\u0011\u0011\u0019P!\u000b\u0003\u0013\u00053G/\u001a:FC\u000eD\u0007")
public class ControllerApisTest {
    private final int nodeId;
    private final String brokerRack;
    private final String clientID;
    private final RequestChannel.Metrics requestChannelMetrics = (RequestChannel.Metrics)Mockito.mock(RequestChannel.Metrics.class);
    private final RequestChannel requestChannel = (RequestChannel)Mockito.mock(RequestChannel.class);
    private final MockTime time = new MockTime();
    private final ClientQuotaManager clientQuotaManager = (ClientQuotaManager)Mockito.mock(ClientQuotaManager.class);
    private final ClientRequestQuotaManager clientRequestQuotaManager = (ClientRequestQuotaManager)Mockito.mock(ClientRequestQuotaManager.class);
    private final ControllerMutationQuotaManager clientControllerQuotaManager = (ControllerMutationQuotaManager)Mockito.mock(ControllerMutationQuotaManager.class);
    private final ReplicationQuotaManager replicaQuotaManager = (ReplicationQuotaManager)Mockito.mock(ReplicationQuotaManager.class);
    private final RaftManager<ApiMessageAndVersion> raftManager = (RaftManager)Mockito.mock(RaftManager.class);
    private final QuotaFactory.QuotaManagers quotas = new QuotaFactory.QuotaManagers(this.clientQuotaManager(), this.clientQuotaManager(), this.clientRequestQuotaManager(), this.clientControllerQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), this.replicaQuotaManager(), (Option)None$.MODULE$);

    private int nodeId() {
        return this.nodeId;
    }

    private String brokerRack() {
        return this.brokerRack;
    }

    private String clientID() {
        return this.clientID;
    }

    private RequestChannel.Metrics requestChannelMetrics() {
        return this.requestChannelMetrics;
    }

    private RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private MockTime time() {
        return this.time;
    }

    private ClientQuotaManager clientQuotaManager() {
        return this.clientQuotaManager;
    }

    private ClientRequestQuotaManager clientRequestQuotaManager() {
        return this.clientRequestQuotaManager;
    }

    private ControllerMutationQuotaManager clientControllerQuotaManager() {
        return this.clientControllerQuotaManager;
    }

    private ReplicationQuotaManager replicaQuotaManager() {
        return this.replicaQuotaManager;
    }

    private RaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    private QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private ControllerApis createControllerApis(Option<Authorizer> authorizer, Controller controller, Properties props) {
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Predef$.MODULE$.int2Integer(this.nodeId()));
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "PLAINTEXT");
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(15).append(this.nodeId()).append("@localhost:9092").toString());
        return new ControllerApis(this.requestChannel(), authorizer, this.quotas(), (Time)this.time(), Predef$.MODULE$.Map().empty(), controller, this.raftManager(), new KafkaConfig((Map)props), new MetaProperties("JgxuGe9URy-E-ceaL04lEw", this.nodeId()), (Seq)Nil$.MODULE$, (ApiVersionManager)new SimpleApiVersionManager(ApiMessageType.ListenerType.CONTROLLER));
    }

    private Properties createControllerApis$default$3() {
        return new Properties();
    }

    private <T extends AbstractRequest> RequestChannel.Request buildRequest(AbstractRequest request, ListenerName listenerName) {
        ByteBuffer buffer = request.serializeWithHeader(new RequestHeader(request.apiKey(), request.version(), this.clientID(), 0));
        RequestHeader header = RequestHeader.parse((ByteBuffer)buffer);
        RequestContext context = new RequestContext(header, "1", InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, listenerName, SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, false);
        return new RequestChannel.Request(1, context, 0L, MemoryPool.NONE, buffer, this.requestChannelMetrics(), RequestChannel.Request$.MODULE$.$lessinit$greater$default$7());
    }

    private <T extends AbstractRequest> ListenerName buildRequest$default$2() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
    }

    /*
     * WARNING - void declaration
     */
    public Authorizer createDenyAllAuthorizer() {
        void var1_1;
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(AuthorizableRequestContext.class), (List)ArgumentMatchers.any(List.class))).thenReturn(Collections.singletonList(AuthorizationResult.DENIED));
        return var1_1;
    }

    @Test
    public void testUnauthorizedFetch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetch(this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), this.buildRequest$default$2())));
    }

    @Test
    public void testFetchSentToKRaft() {
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(new CompletableFuture());
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetch(this.buildRequest((AbstractRequest)new FetchRequest(new FetchRequestData(), 12), this.buildRequest$default$2()));
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testUnauthorizedFetchSnapshot() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetchSnapshot(this.buildRequest((AbstractRequest)new FetchSnapshotRequest(new FetchSnapshotRequestData(), 0), this.buildRequest$default$2())));
    }

    @Test
    public void testFetchSnapshotSentToKRaft() {
        Mockito.when((Object)this.raftManager().handleRequest((RequestHeader)ArgumentMatchers.any(RequestHeader.class), (ApiMessage)ArgumentMatchers.any(ApiMessage.class), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any(Long.TYPE)))).thenReturn(new CompletableFuture());
        this.createControllerApis((Option<Authorizer>)None$.MODULE$, new MockController.Builder().build(), this.createControllerApis$default$3()).handleFetchSnapshot(this.buildRequest((AbstractRequest)new FetchSnapshotRequest(new FetchSnapshotRequestData(), 0), this.buildRequest$default$2()));
        ((RaftManager)Mockito.verify(this.raftManager())).handleRequest((RequestHeader)ArgumentMatchers.any(), (ApiMessage)ArgumentMatchers.any(), BoxesRunTime.unboxToLong((Object)ArgumentMatchers.any()));
    }

    @Test
    public void testUnauthorizedVote() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleVote(this.buildRequest((AbstractRequest)new VoteRequest.Builder(new VoteRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testHandleLegacyAlterConfigsErrors() {
        AlterConfigsRequestData requestData = new AlterConfigsRequestData().setResources(new AlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterConfigsResource[]{new AlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000")}).iterator())), new AlterConfigsRequestData.AlterConfigsResource().setResourceName("baz").setResourceType((byte)123).setConfigs(new AlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new AlterConfigsRequestData.AlterableConfig[]{new AlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar")}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new AlterConfigsRequest(requestData, 0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleLegacyAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        AlterConfigsResponse response = (AlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterConfigsResponseData.AlterConfigsResourceResponse[]{new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName("2").setResourceType(ConfigResource.Type.BROKER.id()), new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage("Unknown resource type 123.").setResourceName("baz").setResourceType((byte)123), new AlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage("Cluster authorization failed.").setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id())})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testUnauthorizedBeginQuorumEpoch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleBeginQuorumEpoch(this.buildRequest((AbstractRequest)new BeginQuorumEpochRequest.Builder(new BeginQuorumEpochRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedEndQuorumEpoch() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleEndQuorumEpoch(this.buildRequest((AbstractRequest)new EndQuorumEpochRequest.Builder(new EndQuorumEpochRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedDescribeQuorum() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleDescribeQuorum(this.buildRequest((AbstractRequest)new DescribeQuorumRequest.Builder(new DescribeQuorumRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleAlterPartitionRequest() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterPartitionRequest(this.buildRequest((AbstractRequest)new AlterPartitionRequest.Builder(new AlterPartitionRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleBrokerHeartBeatRequest() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleBrokerHeartBeatRequest(this.buildRequest((AbstractRequest)new BrokerHeartbeatRequest.Builder(new BrokerHeartbeatRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleUnregisterBroker() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleUnregisterBroker(this.buildRequest((AbstractRequest)new UnregisterBrokerRequest.Builder(new UnregisterBrokerRequestData()).build((short)0), this.buildRequest$default$2())));
    }

    @Test
    public void testClose() {
        ControllerApis apis = this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), (Controller)Mockito.mock(Controller.class), this.createControllerApis$default$3());
        apis.close();
        Assertions.assertTrue((boolean)apis.isClosed());
    }

    @Test
    public void testUnauthorizedBrokerRegistration() {
        BrokerRegistrationRequest brokerRegistrationRequest = (BrokerRegistrationRequest)new BrokerRegistrationRequest.Builder(new BrokerRegistrationRequestData().setBrokerId(this.nodeId()).setRack(this.brokerRack())).build();
        RequestChannel.Request request = this.buildRequest((AbstractRequest)brokerRegistrationRequest, this.buildRequest$default$2());
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), (Controller)Mockito.mock(Controller.class), this.createControllerApis$default$3()).handle(request, RequestLocal$.MODULE$.withThreadConfinedCaching());
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        BrokerRegistrationResponse brokerRegistrationResponse = (BrokerRegistrationResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Errors.CLUSTER_AUTHORIZATION_FAILED), (Object)BoxesRunTime.boxToInteger((int)1))})), (Object)CollectionConverters$.MODULE$.mapAsScalaMapConverter(brokerRegistrationResponse.errorCounts()).asScala());
    }

    @Test
    public void testUnauthorizedHandleAlterClientQuotas() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterClientQuotas(this.buildRequest((AbstractRequest)new AlterClientQuotasRequest(new AlterClientQuotasRequestData(), 0), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleIncrementalAlterConfigs() {
        IncrementalAlterConfigsRequestData requestData = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("flush.ms").setValue("1000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new IncrementalAlterConfigsRequest.Builder(requestData).build((short)0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleIncrementalAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.CLUSTER_AUTHORIZATION_FAILED.message()).setResourceName("1").setResourceType(ConfigResource.Type.BROKER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()).setResourceName("foo").setResourceType(ConfigResource.Type.TOPIC.id())})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testInvalidIncrementalAlterConfigsResources() {
        IncrementalAlterConfigsRequestData requestData = new IncrementalAlterConfigsRequestData().setResources(new IncrementalAlterConfigsRequestData.AlterConfigsResourceCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterConfigsResource[]{new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("kafka.server.KafkaConfig").setValue("TRACE").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName(KafkaConfig$.MODULE$.LogCleanerBackoffMsProp()).setValue("100000").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator())), new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName("foo").setResourceType((byte)124).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(Arrays.asList((Object[])new IncrementalAlterConfigsRequestData.AlterableConfig[]{new IncrementalAlterConfigsRequestData.AlterableConfig().setName("foo").setValue("bar").setConfigOperation(AlterConfigOp.OpType.SET.id())}).iterator()))}).iterator()));
        RequestChannel.Request request = this.buildRequest((AbstractRequest)new IncrementalAlterConfigsRequest.Builder(requestData).build((short)0), this.buildRequest$default$2());
        this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleIncrementalAlterConfigs(request);
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)request), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        Assertions.assertNotNull((Object)capturedResponse.getValue());
        IncrementalAlterConfigsResponse response = (IncrementalAlterConfigsResponse)capturedResponse.getValue();
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse[]{new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Unexpected resource type BROKER_LOGGER.").setResourceName("1").setResourceType(ConfigResource.Type.BROKER_LOGGER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate resource.").setResourceName("3").setResourceType(ConfigResource.Type.BROKER.id()), new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setErrorCode(Errors.UNSUPPORTED_VERSION.code()).setErrorMessage("Unknown resource type 124.").setResourceName("foo").setResourceType((byte)124)})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().responses()).asScala()).toSet());
    }

    @Test
    public void testUnauthorizedHandleAlterPartitionReassignments() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAlterPartitionReassignments(this.buildRequest(new AlterPartitionReassignmentsRequest.Builder(new AlterPartitionReassignmentsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleAllocateProducerIds() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleAllocateProducerIdsRequest(this.buildRequest(new AllocateProducerIdsRequest.Builder(new AllocateProducerIdsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testUnauthorizedHandleListPartitionReassignments() {
        Assertions.assertThrows(ClusterAuthorizationException.class, () -> this.createControllerApis((Option<Authorizer>)new Some((Object)this.createDenyAllAuthorizer()), new MockController.Builder().build(), this.createControllerApis$default$3()).handleListPartitionReassignments(this.buildRequest(new ListPartitionReassignmentsRequest.Builder(new ListPartitionReassignmentsRequestData()).build(), this.buildRequest$default$2())));
    }

    @Test
    public void testCreateTopics() {
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        CreateTopicsRequestData request = new CreateTopicsRequestData().setTopics(new CreateTopicsRequestData.CreatableTopicCollection(Arrays.asList((Object[])new CreateTopicsRequestData.CreatableTopic[]{new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(1).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("foo").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("bar").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("baz").setNumPartitions(2).setReplicationFactor((short)3), new CreateTopicsRequestData.CreatableTopic().setName("quux").setNumPartitions(2).setReplicationFactor((short)3)}).iterator()));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreateTopicsResponseData.CreatableTopicResult[]{new CreateTopicsResponseData.CreatableTopicResult().setName("foo").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreateTopicsResponseData.CreatableTopicResult().setName("bar").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreateTopicsResponseData.CreatableTopicResult().setName("baz").setErrorCode(Errors.NONE.code()).setTopicId(new Uuid(0L, 1L)), new CreateTopicsResponseData.CreatableTopicResult().setName("quux").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)((CreateTopicsResponseData)controllerApis.createTopics(request, false, (Function1 & Serializable & scala.Serializable)x$1 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"baz"}))).get()).topics()).asScala()).toSet());
    }

    @Test
    public void testDeleteTopicsByName() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"foo", "bar", "quux", "quux"}));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage("This server does not host this topic-partition."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable & scala.Serializable)x$2 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable & scala.Serializable)x$3 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testDeleteTopicsById() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid quuxId = Uuid.fromString((String)"ObXkLhL_S5W62FAE67U3MQ");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(quuxId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(quuxId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage("This server does not host this topic ID."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId)}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), true, (Function1 & Serializable & scala.Serializable)x$4 -> Predef$.MODULE$.Set().empty(), (Function1 & Serializable & scala.Serializable)x$5 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testInvalidDeleteTopicsRequest() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"YOS4oQ3UT9eSAZahN1ysSA");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(bazId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Neither topic name nor id were specified."), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("You may not specify both topic name and topic id."), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setTopicId(barId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("The provided topic name maps to an ID that was already supplied."), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(bazId).setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic id.")}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)names -> names.toSet(), (Function1 & Serializable & scala.Serializable)names -> names.toSet()).get()).asScala()).toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicExisting() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        Uuid bazId = Uuid.fromString((String)"hr4TVh3YQiu3p16Awkka6w");
        Uuid quuxId = Uuid.fromString((String)"5URoQzW_RJiERVZXJgUVLg");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).newInitialTopic("bar", barId).newInitialTopic("baz", bazId).newInitialTopic("quux", quuxId).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("baz").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("quux").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("quux").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("baz").setTopicId(Uuid.ZERO_UUID).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setTopicId(fooId).setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$6 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "baz"})), (Function1 & Serializable & scala.Serializable)x$7 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testNotAuthorizedToDeleteWithTopicNotExisting() {
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("bar").setTopicId(Uuid.ZERO_UUID));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new DeleteTopicsResponseData.DeletableTopicResult[]{new DeleteTopicsResponseData.DeletableTopicResult().setName("foo").setErrorCode(Errors.UNKNOWN_TOPIC_OR_PARTITION.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_OR_PARTITION.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName("bar").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(Errors.TOPIC_AUTHORIZATION_FAILED.message()), new DeleteTopicsResponseData.DeletableTopicResult().setName(null).setTopicId(barId).setErrorCode(Errors.UNKNOWN_TOPIC_ID.code()).setErrorMessage(Errors.UNKNOWN_TOPIC_ID.message())}))), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$8 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo"})), (Function1 & Serializable & scala.Serializable)x$9 -> Predef$.MODULE$.Set().empty()).get()).asScala()).toSet());
    }

    @Test
    public void testNotControllerErrorPreventsDeletingTopics() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        Uuid barId = Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        controller.setActive(false);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(fooId));
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName(null).setTopicId(barId));
        Assertions.assertEquals(NotControllerException.class, Assertions.assertThrows(ExecutionException.class, () -> controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$10 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$11 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).get()).getCause().getClass());
    }

    @Test
    public void testDeleteTopicsDisabled() {
        Uuid fooId = Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q");
        MockController controller = new MockController.Builder().newInitialTopic("foo", fooId).build();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.DeleteTopicEnableProp(), "false");
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, props);
        DeleteTopicsRequestData request = new DeleteTopicsRequestData();
        request.topics().add(new DeleteTopicsRequestData.DeleteTopicState().setName("foo").setTopicId(Uuid.ZERO_UUID));
        Assertions.assertThrows(TopicDeletionDisabledException.class, () -> controllerApis.deleteTopics(request, (int)ApiKeys.DELETE_TOPICS.latestVersion(), false, (Function1 & Serializable & scala.Serializable)x$12 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$13 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
        Assertions.assertThrows(InvalidRequestException.class, () -> controllerApis.deleteTopics(request, 1, false, (Function1 & Serializable & scala.Serializable)x$14 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"})), (Function1 & Serializable & scala.Serializable)x$15 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))));
    }

    @Test
    public void testCreatePartitionsRequest() {
        MockController controller = new MockController.Builder().newInitialTopic("foo", Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")).newInitialTopic("bar", Uuid.fromString((String)"VlFu5c51ToiNx64wtwkhQw")).build();
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        CreatePartitionsRequestData request = new CreatePartitionsRequestData();
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(5));
        request.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("baz").setAssignments(null).setCount(5));
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CreatePartitionsResponseData.CreatePartitionsTopicResult[]{new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("foo").setErrorCode(Errors.NONE.code()).setErrorMessage(null), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("bar").setErrorCode(Errors.INVALID_REQUEST.code()).setErrorMessage("Duplicate topic name."), new CreatePartitionsResponseData.CreatePartitionsTopicResult().setName("baz").setErrorCode(Errors.TOPIC_AUTHORIZATION_FAILED.code()).setErrorMessage(null)})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter((List)controllerApis.createPartitions(request, (Function1 & Serializable & scala.Serializable)x$16 -> (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"foo", "bar"}))).get()).asScala()).toSet());
    }

    @Test
    public void testCreatePartitionsAuthorization() {
        MockController controller = new MockController.Builder().newInitialTopic("foo", Uuid.fromString((String)"vZKYST0pSA2HO5x_6hoO2Q")).build();
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)new Some((Object)authorizer), controller, this.createControllerApis$default$3());
        CreatePartitionsRequestData requestData = new CreatePartitionsRequestData();
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("foo").setAssignments(null).setCount(2));
        requestData.topics().add((ImplicitLinkedHashCollection.Element)new CreatePartitionsRequestData.CreatePartitionsTopic().setName("bar").setAssignments(null).setCount(10));
        CreatePartitionsRequest request = (CreatePartitionsRequest)new CreatePartitionsRequest.Builder(requestData).build();
        ResourcePattern fooResource = new ResourcePattern(ResourceType.TOPIC, "foo", PatternType.LITERAL);
        Action fooAction = new Action(AclOperation.ALTER, fooResource, 1, true, true);
        ResourcePattern barResource = new ResourcePattern(ResourceType.TOPIC, "bar", PatternType.LITERAL);
        Action barAction = new Action(AclOperation.ALTER, barResource, 1, true, true);
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(), (List)ArgumentMatchers.any())).thenAnswer(invocation -> {
            Buffer results = (Buffer)((Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter((List)invocation.getArgument(1)).asScala()).map((Function1 & Serializable & scala.Serializable)action -> {
                Action action2 = action;
                if (!(action2 != null ? !action2.equals(fooAction) : fooAction != null)) {
                    return AuthorizationResult.ALLOWED;
                }
                Action action3 = action;
                if (!(action3 != null ? !action3.equals(barAction) : barAction != null)) {
                    return AuthorizationResult.DENIED;
                }
                throw new AssertionError((Object)new StringBuilder(18).append("Unexpected action ").append(action).toString());
            }, Buffer$.MODULE$.canBuildFrom());
            return new ArrayList((Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(results).asJava());
        });
        CreatePartitionsResponse response = (CreatePartitionsResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(CreatePartitionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Buffer results = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(response.data().results()).asScala();
        Assertions.assertEquals((Object)new Some((Object)Errors.NONE), (Object)results.find((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)ControllerApisTest.$anonfun$testCreatePartitionsAuthorization$3(x$17))).map((Function1 & Serializable & scala.Serializable)result -> Errors.forCode((short)result.errorCode())));
        Assertions.assertEquals((Object)new Some((Object)Errors.TOPIC_AUTHORIZATION_FAILED), (Object)results.find((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)ControllerApisTest.$anonfun$testCreatePartitionsAuthorization$5(x$18))).map((Function1 & Serializable & scala.Serializable)result -> Errors.forCode((short)result.errorCode())));
    }

    @Test
    public void testElectLeadersAuthorization() {
        Authorizer authorizer = (Authorizer)Mockito.mock(Authorizer.class);
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)new Some((Object)authorizer), controller, this.createControllerApis$default$3());
        ElectLeadersRequest request = (ElectLeadersRequest)new ElectLeadersRequest.Builder(ElectionType.PREFERRED, null, 30000).build();
        ResourcePattern resource = new ResourcePattern(ResourceType.CLUSTER, "kafka-cluster", PatternType.LITERAL);
        List<Action> actions = Collections.singletonList(new Action(AclOperation.ALTER, resource, 1, true, true));
        Mockito.when((Object)authorizer.authorize((AuthorizableRequestContext)ArgumentMatchers.any(), (List)ArgumentMatchers.eq(actions))).thenReturn(Collections.singletonList(AuthorizationResult.DENIED));
        ElectLeadersResponse response = (ElectLeadersResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(ElectLeadersResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)Errors.forCode((short)response.data().errorCode()));
    }

    @Test
    public void testElectLeadersHandledByController() {
        Controller controller = (Controller)Mockito.mock(Controller.class);
        ControllerApis controllerApis = this.createControllerApis((Option<Authorizer>)None$.MODULE$, controller, this.createControllerApis$default$3());
        ElectLeadersRequest request = (ElectLeadersRequest)new ElectLeadersRequest.Builder(ElectionType.PREFERRED, null, 30000).build();
        ElectLeadersResponseData responseData = new ElectLeadersResponseData().setErrorCode(Errors.NOT_CONTROLLER.code());
        Mockito.when((Object)controller.electLeaders(request.data())).thenReturn(CompletableFuture.completedFuture(responseData));
        ElectLeadersResponse response = (ElectLeadersResponse)this.handleRequest((AbstractRequest)request, controllerApis, ClassTag$.MODULE$.apply(ElectLeadersResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        Assertions.assertEquals((Object)Errors.NOT_CONTROLLER, (Object)Errors.forCode((short)response.data().errorCode()));
    }

    private <T extends AbstractResponse> T handleRequest(AbstractRequest request, ControllerApis controllerApis, ClassTag<T> classTag, NotNothing<T> nn) {
        RequestChannel.Request req = this.buildRequest(request, this.buildRequest$default$2());
        controllerApis.handle(req, RequestLocal$.MODULE$.NoCaching());
        ArgumentCaptor capturedResponse = ArgumentCaptor.forClass(AbstractResponse.class);
        ((RequestChannel)Mockito.verify((Object)this.requestChannel())).sendResponse((RequestChannel.Request)ArgumentMatchers.eq((Object)req), (AbstractResponse)capturedResponse.capture(), (Option)ArgumentMatchers.eq((Object)None$.MODULE$));
        AbstractResponse abstractResponse = (AbstractResponse)capturedResponse.getValue();
        Option option = classTag.unapply((Object)abstractResponse);
        if (option.isEmpty() || option.get() == null) {
            throw new ClassCastException(new StringBuilder(40).append("Expected response with type ").append(classTag.runtimeClass()).append(", ").append("but found ").append(abstractResponse.getClass()).toString());
        }
        return (T)abstractResponse;
    }

    @AfterEach
    public void tearDown() {
        this.quotas().shutdown();
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitionsAuthorization$3(CreatePartitionsResponseData.CreatePartitionsTopicResult x$17) {
        String string = x$17.name();
        String string2 = "foo";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testCreatePartitionsAuthorization$5(CreatePartitionsResponseData.CreatePartitionsTopicResult x$18) {
        String string = x$18.name();
        String string2 = "bar";
        return string != null && string.equals(string2);
    }

    public ControllerApisTest() {
        this.nodeId = 1;
        this.brokerRack = "Rack1";
        this.clientID = "Client1";
    }
}

