/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import kafka.server.ControllerConfigurationValidator;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001m2AAC\u0006\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C\u00019!)Q\u0006\u0001C\u00019!)q\u0006\u0001C\u00019!)\u0011\u0007\u0001C\u00019!)1\u0007\u0001C\u00019!)Q\u0007\u0001C\u00019!)q\u0007\u0001C\u00019!)\u0011\b\u0001C\u00019\t!3i\u001c8ue>dG.\u001a:D_:4\u0017nZ;sCRLwN\u001c,bY&$\u0017\r^8s)\u0016\u001cHO\u0003\u0002\r\u001b\u000511/\u001a:wKJT\u0011AD\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013+5\t1CC\u0001\u0015\u0003\u0015\u00198-\u00197b\u0013\t12C\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\u0001\"A\u0007\u0001\u000e\u0003-\t!\u0005^3ti\u0012+g-Y;miR{\u0007/[2SKN|WO]2f\u0013N\u0014VM[3di\u0016$G#A\u000f\u0011\u0005Iq\u0012BA\u0010\u0014\u0005\u0011)f.\u001b;)\u0005\t\t\u0003C\u0001\u0012,\u001b\u0005\u0019#B\u0001\u0013&\u0003\r\t\u0007/\u001b\u0006\u0003M\u001d\nqA[;qSR,'O\u0003\u0002)S\u0005)!.\u001e8ji*\t!&A\u0002pe\u001eL!\u0001L\u0012\u0003\tQ+7\u000f^\u0001\u001di\u0016\u001cH/\u00138wC2LG\rV8qS\u000et\u0015-\\3SK*,7\r^3eQ\t\u0019\u0011%A\fuKN$XK\\6o_^t'+Z:pkJ\u001cW\rV=qK\"\u0012A!I\u0001\u0019i\u0016\u001cHOT;mYR{\u0007/[2D_:4\u0017n\u001a,bYV,\u0007FA\u0003\"\u0003Q!Xm\u001d;WC2LG\rV8qS\u000e\u001cuN\u001c4jO\"\u0012a!I\u0001\u0017i\u0016\u001cH/\u00138wC2LG\rV8qS\u000e\u001cuN\u001c4jO\"\u0012q!I\u0001\u0018i\u0016\u001cH/\u00138wC2LGM\u0011:pW\u0016\u0014XI\u001c;jifD#\u0001C\u0011\u00027Q,7\u000f^%om\u0006d\u0017\u000e\u001a(fO\u0006$\u0018N^3Ce>\\WM]%eQ\tI\u0011\u0005")
public class ControllerConfigurationValidatorTest {
    @Test
    public void testDefaultTopicResourceIsRejected() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        Assertions.assertEquals((Object)"Default topic resources are not allowed.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.TOPIC, ""), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testInvalidTopicNameRejected() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        Assertions.assertEquals((Object)"Topic name \"(<-invalid->)\" is illegal, it contains a character other than ASCII alphanumerics, '.', '_' and '-'", (Object)Assertions.assertThrows(InvalidTopicException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "(<-invalid->)"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testUnknownResourceType() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        Assertions.assertEquals((Object)"Unknown resource type BROKER_LOGGER", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.BROKER_LOGGER, "foo"), Collections.emptyMap())).getMessage());
    }

    @Test
    public void testNullTopicConfigValue() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "10");
        config.put("segment.bytes", null);
        config.put("segment.ms", null);
        Assertions.assertEquals((Object)"Null value not supported for topic configs : segment.bytes,segment.ms", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testValidTopicConfig() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        validator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), config);
    }

    @Test
    public void testInvalidTopicConfig() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        config.put("segment.bytes", "67108864");
        config.put("foobar", "abc");
        Assertions.assertEquals((Object)"Unknown topic config name: foobar", (Object)Assertions.assertThrows(InvalidConfigurationException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.TOPIC, "foo"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidBrokerEntity() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Unable to parse broker name as a base 10 number.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.BROKER, "blah"), (Map)config)).getMessage());
    }

    @Test
    public void testInvalidNegativeBrokerId() {
        ControllerConfigurationValidator validator = new ControllerConfigurationValidator();
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("segment.jitter.ms", "1000");
        Assertions.assertEquals((Object)"Invalid negative broker ID.", (Object)Assertions.assertThrows(InvalidRequestException.class, () -> validator.validate(new ConfigResource(ConfigResource.Type.BROKER, "-1"), (Map)config)).getMessage());
    }
}

