/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.server.AbstractCreateTopicsRequestTest;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r4A\u0001C\u0005\u0001\u001d!)1\u0003\u0001C\u0001)!)a\u0003\u0001C\u0001/!)Q\t\u0001C\u0001\r\")1\n\u0001C\u0001\u0019\")\u0011\u000b\u0001C\u0001%\")q\u000b\u0001C\u00011\")Q\f\u0001C\u0001=\n92I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0015-\taa]3sm\u0016\u0014(\"\u0001\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0004\t\u0003!Ei\u0011!C\u0005\u0003%%\u0011q$\u00112tiJ\f7\r^\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0011\u0001\u0005iB/Z:u-\u0006d\u0017\u000eZ\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$8\u000f\u0006\u0002\u0019=A\u0011\u0011\u0004H\u0007\u00025)\t1$A\u0003tG\u0006d\u0017-\u0003\u0002\u001e5\t!QK\\5u\u0011\u0015y\"\u00011\u0001!\u0003\u0019\tXo\u001c:v[B\u0011\u0011\u0005\u000b\b\u0003E\u0019\u0002\"a\t\u000e\u000e\u0003\u0011R!!J\u0007\u0002\rq\u0012xn\u001c;?\u0013\t9#$\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014\u001bQ\u0011\u0011AFO\u001e\u0011\u00055BT\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00039s_ZLG-\u001a:\u000b\u0005E\u0012\u0014A\u00029be\u0006l7O\u0003\u00024i\u00059!.\u001e9ji\u0016\u0014(BA\u001b7\u0003\u0015QWO\\5u\u0015\u00059\u0014aA8sO&\u0011\u0011H\f\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005qr\u0014%A\u001f\u0002\u0005i\\\u0017%A \u0002\u000b-\u0014\u0018M\u001a;)\u0005\t\t\u0005C\u0001\"D\u001b\u0005\u0001\u0014B\u0001#1\u0005E\u0001\u0016M]1nKR,'/\u001b>fIR+7\u000f^\u0001\u001ei\u0016\u001cH/\u0012:s_J\u001c%/Z1uKR{\u0007/[2t%\u0016\fX/Z:ugR\u0011\u0001d\u0012\u0005\u0006?\r\u0001\r\u0001\t\u0015\u0005\u00071R\u0014\n\f\u0002=}!\u00121!Q\u0001&i\u0016\u001cHo\u0011:fCR,Gk\u001c9jGN<\u0016\u000e\u001e5WKJL8\u000b[8siRKW.Z8viN$\"\u0001G'\t\u000b}!\u0001\u0019\u0001\u0011)\t\u0011a#h\u0014\u0017\u0002y!\u0012A!Q\u0001 i\u0016\u001cH/\u00138wC2LGm\u0011:fCR,Gk\u001c9jGN\u0014V-];fgR\u001cHC\u0001\rT\u0011\u0015yR\u00011\u0001!Q\u0011)AFO+-\u0005qr\u0004FA\u0003B\u0003E!Xm\u001d;O_R\u001cuN\u001c;s_2dWM\u001d\u000b\u00031eCQa\b\u0004A\u0002\u0001BCA\u0002\u0017;72\nA\b\u000b\u0002\u0007\u0003\u0006yB/Z:u\u0007J,\u0017\r^3U_BL7m\u001d*fcV,7\u000f\u001e,feNLwN\\:\u0015\u0005ay\u0006\"B\u0010\b\u0001\u0004\u0001\u0003\u0006B\u0004-u\u0005d\u0013\u0001\u0010\u0015\u0003\u000f\u0005\u0003")
public class CreateTopicsRequestTest
extends AbstractCreateTopicsRequestTest {
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testValidCreateTopicsRequests(String quorum) {
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic1", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$1 = "topic2";
        Integer x$2 = Predef$.MODULE$.int2Integer(3);
        Integer x$3 = this.topicReq$default$2();
        Map<String, String> x$4 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$5 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$3, x$2, x$4, x$5), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic3", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$6 = "topic4";
        Map x$7 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$8 = this.topicReq$default$2();
        Integer x$9 = this.topicReq$default$3();
        Map<String, String> x$10 = this.topicReq$default$4();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$6, x$8, x$9, x$10, (Map<Object, Seq<Object>>)x$7), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$11 = "topic5";
        Map x$12 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Map x$13 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}));
        Integer x$14 = this.topicReq$default$2();
        Integer x$15 = this.topicReq$default$3();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$11, x$14, x$15, (Map<String, String>)x$13, (Map<Object, Seq<Object>>)x$12), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$16 = "topic8";
        Map x$17 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Integer x$18 = this.topicReq$default$2();
        Integer x$19 = this.topicReq$default$3();
        Map<String, String> x$20 = this.topicReq$default$4();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic6", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("topic7", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq(x$16, x$18, x$19, x$20, (Map<Object, Seq<Object>>)x$17), (List)Nil$.MODULE$))), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$21 = "topic11";
        Map x$22 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        Integer x$23 = this.topicReq$default$2();
        Integer x$24 = this.topicReq$default$3();
        Map<String, String> x$25 = this.topicReq$default$4();
        .colon.colon x$26 = new .colon.colon((Object)this.topicReq("topic9", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("topic10", Predef$.MODULE$.int2Integer(5), Predef$.MODULE$.int2Integer(2), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq(x$21, x$23, x$24, x$25, (Map<Object, Seq<Object>>)x$22), (List)Nil$.MODULE$)));
        boolean x$27 = true;
        Integer x$28 = this.topicsReq$default$2();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$26, x$28, x$27));
        String x$29 = "topic12";
        Integer x$30 = Predef$.MODULE$.int2Integer(-1);
        Integer x$31 = Predef$.MODULE$.int2Integer(-1);
        Map<String, String> x$32 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$33 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$29, x$31, x$30, x$32, x$33), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$34 = "topic13";
        Integer x$35 = Predef$.MODULE$.int2Integer(2);
        Integer x$36 = Predef$.MODULE$.int2Integer(-1);
        Map<String, String> x$37 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$38 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$34, x$36, x$35, x$37, x$38), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
        String x$39 = "topic14";
        Integer x$40 = Predef$.MODULE$.int2Integer(-1);
        Integer x$41 = Predef$.MODULE$.int2Integer(2);
        Map<String, String> x$42 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$43 = this.topicReq$default$5();
        this.validateValidCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$39, x$41, x$40, x$42, x$43), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testErrorCreateTopicsRequests(String quorum) {
        String existingTopic = "existing-topic";
        this.createTopic(existingTopic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5());
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(existingTopic, this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, (Option<String>)new Some((Object)"Topic 'existing-topic' already exists.")))}))), this.validateErrorCreateTopicsRequests$default$3());
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-partitions", Predef$.MODULE$.int2Integer(-2), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2()))}))), false);
        String x$1 = "error-replication";
        Integer x$2 = Predef$.MODULE$.int2Integer(this.brokerCount() + 1);
        Integer x$3 = this.topicReq$default$2();
        Map<String, String> x$4 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$5 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$3, x$2, x$4, x$5), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2()))}))), false);
        String x$6 = "error-config";
        Map x$7 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"not.a.property"), (Object)"error")}));
        Integer x$8 = this.topicReq$default$2();
        Integer x$9 = this.topicReq$default$3();
        Map<Object, Seq<Object>> x$10 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$6, x$8, x$9, (Map<String, String>)x$7, x$10), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        String x$11 = "error-config-value";
        Map x$12 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message.format.version"), (Object)"invalid-value")}));
        Integer x$13 = this.topicReq$default$2();
        Integer x$14 = this.topicReq$default$3();
        Map<Object, Seq<Object>> x$15 = this.topicReq$default$5();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$11, x$13, x$14, (Map<String, String>)x$12, x$15), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config-value"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        String x$16 = "error-assignment";
        Map x$17 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$18 = this.topicReq$default$2();
        Integer x$19 = this.topicReq$default$3();
        Map<String, String> x$20 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$16, x$18, x$19, x$20, (Map<Object, Seq<Object>>)x$17), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2()))}))), false);
        String x$21 = "partial-replication";
        Integer x$22 = Predef$.MODULE$.int2Integer(this.brokerCount() + 1);
        Integer x$23 = this.topicReq$default$2();
        Map<String, String> x$24 = this.topicReq$default$4();
        Map<Object, Seq<Object>> x$25 = this.topicReq$default$5();
        String x$26 = "partial-assignment";
        Map x$27 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Integer x$28 = this.topicReq$default$2();
        Integer x$29 = this.topicReq$default$3();
        Map<String, String> x$30 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(existingTopic, this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq("partial-partitions", Predef$.MODULE$.int2Integer(-2), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)new .colon.colon((Object)this.topicReq(x$21, x$23, x$22, x$24, x$25), (List)new .colon.colon((Object)this.topicReq(x$26, x$28, x$29, x$30, (Map<Object, Seq<Object>>)x$27), (List)new .colon.colon((Object)this.topicReq("partial-none", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$))))), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-none"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false);
        this.validateTopicExists("partial-none");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testCreateTopicsWithVeryShortTimeouts(String quorum) {
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(1), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout-zero", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(0), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-zero"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("error-timeout-negative", Predef$.MODULE$.int2Integer(10), Predef$.MODULE$.int2Integer(3), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), Predef$.MODULE$.int2Integer(-1), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-negative"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout-zero", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        TestUtils$.MODULE$.waitForPartitionMetadata(this.servers(), "error-timeout-negative", 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        this.validateTopicExists("error-timeout");
        this.validateTopicExists("error-timeout-zero");
        this.validateTopicExists("error-timeout-negative");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testInvalidCreateTopicsRequests(String quorum) {
        String x$1 = "bad-args-topic";
        Integer x$2 = Predef$.MODULE$.int2Integer(10);
        Integer x$3 = Predef$.MODULE$.int2Integer(3);
        Map x$4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Map<String, String> x$5 = this.topicReq$default$4();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq(x$1, x$2, x$3, x$5, (Map<Object, Seq<Object>>)x$4), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3()), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        String x$6 = "bad-args-topic";
        Integer x$7 = Predef$.MODULE$.int2Integer(10);
        Integer x$8 = Predef$.MODULE$.int2Integer(3);
        Map x$9 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}));
        Map<String, String> x$10 = this.topicReq$default$4();
        .colon.colon x$11 = new .colon.colon((Object)this.topicReq(x$6, x$7, x$8, x$10, (Map<Object, Seq<Object>>)x$9), (List)Nil$.MODULE$);
        boolean x$12 = true;
        Integer x$13 = this.topicsReq$default$2();
        this.validateErrorCreateTopicsRequests(this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)x$11, x$13, x$12), (Map<String, ApiError>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testNotController(String quorum) {
        CreateTopicsRequest req = this.topicsReq((Seq<CreateTopicsRequestData.CreatableTopic>)new .colon.colon((Object)this.topicReq("topic1", this.topicReq$default$2(), this.topicReq$default$3(), this.topicReq$default$4(), this.topicReq$default$5()), (List)Nil$.MODULE$), this.topicsReq$default$2(), this.topicsReq$default$3());
        CreateTopicsResponse response = this.sendCreateTopicRequest(req, this.notControllerSocketServer());
        Assertions.assertEquals((int)1, (Integer)((Integer)response.errorCounts().get(Errors.NOT_CONTROLLER)));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testCreateTopicsRequestVersions(String quorum) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)ApiKeys.CREATE_TOPICS.oldestVersion()), (int)ApiKeys.CREATE_TOPICS.latestVersion()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)version -> {
            String topic = new StringBuilder(6).append("topic_").append(version).toString();
            CreateTopicsRequestData data = new CreateTopicsRequestData();
            data.setTimeoutMs(10000);
            data.setValidateOnly(false);
            data.setTopics(new CreateTopicsRequestData.CreatableTopicCollection(((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topicReq(topic, Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(1), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))), this.topicReq$default$5()), (List)Nil$.MODULE$)).asJava()).iterator()));
            CreateTopicsRequest request = new CreateTopicsRequest.Builder(data).build((short)version);
            CreateTopicsResponseData.CreatableTopicResult topicResponse = this.sendCreateTopicRequest(request, this.sendCreateTopicRequest$default$2()).data().topics().find(topic);
            Assertions.assertNotNull((Object)topicResponse);
            Assertions.assertEquals((Object)topic, (Object)topicResponse.name());
            Assertions.assertEquals((short)Errors.NONE.code(), (short)topicResponse.errorCode());
            if (version >= 5) {
                Assertions.assertEquals((int)1, (int)topicResponse.numPartitions());
                Assertions.assertEquals((int)1, (int)topicResponse.replicationFactor());
                Option config = ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicResponse.configs()).asScala()).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CreateTopicsRequestTest.$anonfun$testCreateTopicsRequestVersions$2(x$1)));
                Assertions.assertTrue((boolean)config.isDefined());
                Assertions.assertEquals((Object)"2", (Object)((CreateTopicsResponseData.CreatableTopicConfigs)config.get()).value());
            } else {
                Assertions.assertEquals((int)-1, (int)topicResponse.numPartitions());
                Assertions.assertEquals((int)-1, (int)topicResponse.replicationFactor());
                Assertions.assertTrue((boolean)topicResponse.configs().isEmpty());
            }
            if (version >= 7) {
                Assertions.assertNotEquals((Object)Uuid.ZERO_UUID, (Object)topicResponse.topicId());
                return;
            }
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicResponse.topicId());
        });
    }

    public static final /* synthetic */ boolean $anonfun$testCreateTopicsRequestVersions$2(CreateTopicsResponseData.CreatableTopicConfigs x$1) {
        String string = x$1.name();
        String string2 = "min.insync.replicas";
        return string != null && string.equals(string2);
    }
}

