/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import kafka.controller.KafkaController;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.network.DataPlaneAcceptor;
import kafka.network.SocketServer;
import kafka.server.BrokerReconfigurable;
import kafka.server.Defaults$;
import kafka.server.DynamicBrokerConfig;
import kafka.server.DynamicBrokerConfig$;
import kafka.server.DynamicBrokerConfigTest;
import kafka.server.DynamicListenerConfig;
import kafka.server.DynamicLogConfig;
import kafka.server.DynamicThreadPool;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRequestHandlerPool;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager;
import kafka.server.TestDynamicThreadPool;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.Reconfigurable;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019BQa\u000e\u0001\u0005\u0002\u0019BQ!\u000f\u0001\u0005\u0002\u0019BQa\u000f\u0001\u0005\u0002\u0019BQ!\u0010\u0001\u0005\u0002\u0019BQa\u0010\u0001\u0005\u0002\u0019BQ!\u0011\u0001\u0005\u0002\u0019BQa\u0011\u0001\u0005\u0002\u0019BQ!\u0012\u0001\u0005\u0002\u0019BQa\u0012\u0001\u0005\n!CQa\u001a\u0001\u0005\n!DQ! \u0001\u0005\u0002\u0019BQa \u0001\u0005\u0002\u0019Ba!a\u0001\u0001\t\u00031\u0003BBA\u0004\u0001\u0011\u0005a\u0005\u0003\u0004\u0002\f\u0001!\tA\n\u0005\u0007\u0003\u001f\u0001A\u0011\u0001\u0014\t\r\u0005M\u0001\u0001\"\u0001'\u0005]!\u0015P\\1nS\u000e\u0014%o\\6fe\u000e{gNZ5h)\u0016\u001cHO\u0003\u0002\u0017/\u000511/\u001a:wKJT\u0011\u0001G\u0001\u0006W\u000647.Y\u0002\u0001'\t\u00011\u0004\u0005\u0002\u001d?5\tQDC\u0001\u001f\u0003\u0015\u00198-\u00197b\u0013\t\u0001SD\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0002\"\u0001\n\u0001\u000e\u0003U\t\u0001\u0003^3ti\u000e{gNZ5h+B$\u0017\r^3\u0015\u0003\u001d\u0002\"\u0001\b\u0015\n\u0005%j\"\u0001B+oSRD#AA\u0016\u0011\u00051*T\"A\u0017\u000b\u00059z\u0013aA1qS*\u0011\u0001'M\u0001\bUV\u0004\u0018\u000e^3s\u0015\t\u00114'A\u0003kk:LGOC\u00015\u0003\ry'oZ\u0005\u0003m5\u0012A\u0001V3ti\u00061C/Z:u\u000b:\f'\r\\3EK\u001a\fW\u000f\u001c;V]\u000edW-\u00198MK\u0006$WM]#mK\u000e$\u0018n\u001c8)\u0005\rY\u0013a\u0007;fgR,\u0006\u000fZ1uK\u0012Kh.Y7jGRC'/Z1e!>|G\u000e\u000b\u0002\u0005W\u00051C/Z:u\u0007>tg-[4Va\u0012\fG/Z,ji\"\u001cv.\\3J]Z\fG.\u001b3D_:4\u0017nZ:)\u0005\u0015Y\u0013a\r;fgR\u001cuN\u001c4jOV\u0003H-\u0019;f/&$\bNU3d_:4\u0017nZ;sC\ndWMV1mS\u0012\fG/[8o\r\u0006LG.\u001e:fQ\t11&\u0001\u000fuKN$(+Z2p]\u001aLw-\u001e:bE2,g+\u00197jI\u0006$\u0018n\u001c8)\u0005\u001dY\u0013a\u0005;fgR\u001cVmY;sSRL8i\u001c8gS\u001e\u001c\bF\u0001\u0005,\u0003M!Xm\u001d;D_:tWm\u0019;j_:\fVo\u001c;bQ\tI1&A\fuKN$8i\u001c8oK\u000e$\u0018n\u001c8SCR,\u0017+^8uC\"\u0012!bK\u0001\u0013m\u0016\u0014\u0018NZ=D_:4\u0017nZ+qI\u0006$X\rF\u0003(\u0013Z\u0003W\rC\u0003K\u0017\u0001\u00071*\u0001\u0003oC6,\u0007C\u0001'T\u001d\ti\u0015\u000b\u0005\u0002O;5\tqJ\u0003\u0002Q3\u00051AH]8pizJ!AU\u000f\u0002\rA\u0013X\rZ3g\u0013\t!VK\u0001\u0004TiJLgn\u001a\u0006\u0003%vAQaV\u0006A\u0002a\u000bQA^1mk\u0016\u0004\"!\u00170\u000e\u0003iS!a\u0017/\u0002\t1\fgn\u001a\u0006\u0002;\u0006!!.\u0019<b\u0013\ty&L\u0001\u0004PE*,7\r\u001e\u0005\u0006C.\u0001\rAY\u0001\u0010a\u0016\u0014(I]8lKJ\u001cuN\u001c4jOB\u0011AdY\u0005\u0003Iv\u0011qAQ8pY\u0016\fg\u000eC\u0003g\u0017\u0001\u0007!-A\u0007fqB,7\r\u001e$bS2,(/Z\u0001$m\u0016\u0014\u0018NZ=D_:4\u0017nZ+qI\u0006$XmV5uQ&sg/\u00197jI\u000e{gNZ5h)\u00159\u0013N\u001c<|\u0011\u0015QG\u00021\u0001l\u0003\u0019\u0019wN\u001c4jOB\u0011A\u0005\\\u0005\u0003[V\u00111bS1gW\u0006\u001cuN\u001c4jO\")q\u000e\u0004a\u0001a\u0006IqN]5h!J|\u0007o\u001d\t\u0003cRl\u0011A\u001d\u0006\u0003gr\u000bA!\u001e;jY&\u0011QO\u001d\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\b\"B<\r\u0001\u0004A\u0018A\u0003<bY&$\u0007K]8qgB!A*_&L\u0013\tQXKA\u0002NCBDQ\u0001 \u0007A\u0002a\fA\"\u001b8wC2LG\r\u0015:paN\fA\u0004^3tiB\u000b7o]<pe\u0012\u001cuN\u001c4jO\u0016s7M]=qi&|g\u000e\u000b\u0002\u000eW\u0005)C/Z:u!\u0006\u001c8o^8sI\u000e{gNZ5h\u000b:\u001cw\u000eZ3s'\u0016\u001c'/\u001a;DQ\u0006tw-\u001a\u0015\u0003\u001d-\n\u0011\u0004^3ti\u0012Kh.Y7jG2K7\u000f^3oKJ\u001cuN\u001c4jO\"\u0012qbK\u0001\u0015i\u0016\u001cH/Q;uQ>\u0014\u0018N_3s\u0007>tg-[4)\u0005AY\u0013\u0001\u0004;fgR\u001c\u0016P\\8os6\u001c\bFA\t,\u0003E\"Xm\u001d;Es:\fW.[2D_:4\u0017nZ%oSRL\u0017\r\\5{CRLwN\\,ji\"|W\u000f^\"p]\u001aLwm]%o5.C#AE\u0016\u0002;Q,7\u000f^%naJ|\u0007/\u001a:D_:4\u0017nZ:Be\u0016\u0014V-\\8wK\u0012D#aE\u0016")
public class DynamicBrokerConfigTest {
    @Test
    public void testConfigUpdate() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        String oldKeystore = "oldKs.jks";
        props.put("ssl.keystore.location", oldKeystore);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        DynamicBrokerConfig dynamicConfig = config.dynamicConfig();
        dynamicConfig.initialize((Option)None$.MODULE$);
        Assertions.assertEquals((Object)config, (Object)dynamicConfig.currentKafkaConfig());
        Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
        Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Properties props1 = new Properties();
            String newKeystore = new StringBuilder(6).append("ks").append(i).append(".jks").toString();
            props1.put(new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString(), newKeystore);
            dynamicConfig.updateBrokerConfig(0, props1, dynamicConfig.updateBrokerConfig$default$3());
            Assertions.assertNotSame((Object)config, (Object)dynamicConfig.currentKafkaConfig());
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.valuesWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)newKeystore, config.originalsWithPrefix("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, (Object)config.getString(KafkaConfig$.MODULE$.SslKeystoreLocationProp()));
            Assertions.assertEquals((Object)oldKeystore, config.originals().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.values().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsStrings().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfigWithPrefixOverride("listener.name.external.").get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.originalsFromThisConfig().get("ssl.keystore.location"));
            Assertions.assertEquals((Object)oldKeystore, config.valuesFromThisConfig().get("ssl.keystore.location"));
        });
    }

    @Test
    public void testEnableDefaultUncleanLeaderElection() {
        int x$12 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$12, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "false");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaServer serverMock = (KafkaServer)Mockito.mock(KafkaServer.class);
        KafkaController controllerMock = (KafkaController)Mockito.mock(KafkaController.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.kafkaController()).thenReturn((Object)controllerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)logManagerMock.allLogs()).thenReturn((Object)package$.MODULE$.Iterable().empty());
        AtomicReference<LogConfig> currentDefaultLogConfig = new AtomicReference<LogConfig>(LogConfig$.MODULE$.apply());
        Mockito.when((Object)logManagerMock.currentDefaultConfig()).thenAnswer(x$1 -> (LogConfig)currentDefaultLogConfig.get());
        logManagerMock.reconfigureDefaultLogConfig((LogConfig)ArgumentMatchers.any(LogConfig.class));
        Mockito.when((Object)BoxedUnit.UNIT).thenAnswer(invocation -> {
            currentDefaultLogConfig.set(invocation.getArgument(0));
            return BoxedUnit.UNIT;
        });
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicLogConfig(logManagerMock, (KafkaBroker)serverMock));
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertTrue((boolean)Predef$.MODULE$.Boolean2boolean(config.uncleanLeaderElectionEnable()));
        ((KafkaController)Mockito.verify((Object)controllerMock)).enableDefaultUncleanLeaderElection();
    }

    @Test
    public void testUpdateDynamicThreadPool() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "4");
        origProps.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "2");
        origProps.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "1");
        origProps.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "3");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        KafkaBroker serverMock = (KafkaBroker)Mockito.mock(KafkaBroker.class);
        DataPlaneAcceptor acceptorMock = (DataPlaneAcceptor)Mockito.mock(DataPlaneAcceptor.class);
        KafkaRequestHandlerPool handlerPoolMock = (KafkaRequestHandlerPool)Mockito.mock(KafkaRequestHandlerPool.class);
        SocketServer socketServerMock = (SocketServer)Mockito.mock(SocketServer.class);
        ReplicaManager replicaManagerMock = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        LogManager logManagerMock = (LogManager)Mockito.mock(LogManager.class);
        KafkaScheduler schedulerMock = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        Mockito.when((Object)serverMock.config()).thenReturn((Object)config);
        Mockito.when((Object)serverMock.dataPlaneRequestHandlerPool()).thenReturn((Object)handlerPoolMock);
        Mockito.when((Object)acceptorMock.listenerName()).thenReturn((Object)new ListenerName("plaintext"));
        Mockito.when((Object)acceptorMock.reconfigurableConfigs()).thenCallRealMethod();
        Mockito.when((Object)serverMock.socketServer()).thenReturn((Object)socketServerMock);
        Mockito.when((Object)socketServerMock.dataPlaneAcceptor(ArgumentMatchers.anyString())).thenReturn((Object)new Some((Object)acceptorMock));
        Mockito.when((Object)serverMock.replicaManager()).thenReturn((Object)replicaManagerMock);
        Mockito.when((Object)serverMock.logManager()).thenReturn((Object)logManagerMock);
        Mockito.when((Object)serverMock.kafkaScheduler()).thenReturn((Object)schedulerMock);
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        config.dynamicConfig().addBrokerReconfigurable((BrokerReconfigurable)new DynamicThreadPool(serverMock));
        config.dynamicConfig().addReconfigurable((Reconfigurable)acceptorMock);
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "8");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)8, (Integer)config.numIoThreads());
        ((KafkaRequestHandlerPool)Mockito.verify((Object)handlerPoolMock)).resizeThreadPool(8);
        props.put(KafkaConfig$.MODULE$.NumNetworkThreadsProp(), "4");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)4, (Integer)config.numNetworkThreads());
        ArgumentCaptor captor = ArgumentCaptor.forClass(java.util.Map.class);
        ((DataPlaneAcceptor)Mockito.verify((Object)acceptorMock)).reconfigure((java.util.Map)captor.capture());
        Assertions.assertTrue((boolean)((java.util.Map)captor.getValue()).containsKey(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        Assertions.assertEquals((Object)BoxesRunTime.boxToInteger((int)4), ((java.util.Map)captor.getValue()).get(KafkaConfig$.MODULE$.NumNetworkThreadsProp()));
        props.put(KafkaConfig$.MODULE$.NumReplicaFetchersProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numReplicaFetchers());
        ((ReplicaManager)Mockito.verify((Object)replicaManagerMock)).resizeFetcherThreadPool(2);
        props.put(KafkaConfig$.MODULE$.NumRecoveryThreadsPerDataDirProp(), "2");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)2, (Integer)config.numRecoveryThreadsPerDataDir());
        ((LogManager)Mockito.verify((Object)logManagerMock)).resizeRecoveryThreadPool(2);
        props.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "6");
        config.dynamicConfig().updateDefaultConfig(props, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)6, (Integer)config.backgroundThreads());
        ((KafkaScheduler)Mockito.verify((Object)schedulerMock)).resizeThreadPool(6);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handlerPoolMock, socketServerMock, replicaManagerMock, logManagerMock, schedulerMock});
    }

    @Test
    public void testConfigUpdateWithSomeInvalidConfigs() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put("ssl.keystore.type", "JKS");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new StringBuilder(44).append("listener.name.external.").append("ssl.keystore.location").toString()), (Object)"ks.p12")}));
        scala.collection.immutable.Map securityPropsWithoutListenerPrefix = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ssl.keystore.type"), (Object)"PKCS12")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)securityPropsWithoutListenerPrefix);
        scala.collection.immutable.Map nonDynamicProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.ZkConnectProp()), (Object)"somehost:2181")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)nonDynamicProps);
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"invalid")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        scala.collection.immutable.Map excludedTopicConfig = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogMessageFormatVersionProp()), (Object)"0.10.2")}));
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)excludedTopicConfig);
    }

    @Test
    public void testConfigUpdateWithReconfigurableValidationFailure() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        origProps.put(KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "100000000");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        scala.collection.immutable.Map validProps = Predef$.MODULE$.Map().empty();
        scala.collection.immutable.Map invalidProps = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KafkaConfig$.MODULE$.LogCleanerThreadsProp()), (Object)"20")}));
        Reconfigurable reconfigurable = new Reconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(configs);
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addReconfigurable(reconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
        config.dynamicConfig().removeReconfigurable(reconfigurable);
        BrokerReconfigurable brokerReconfigurable = new BrokerReconfigurable(this){
            private final /* synthetic */ DynamicBrokerConfigTest $outer;

            public Set<String> reconfigurableConfigs() {
                return (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp()}));
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
                DynamicBrokerConfigTest.kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(newConfig.originals());
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        config.dynamicConfig().addBrokerReconfigurable(brokerReconfigurable);
        this.verifyConfigUpdateWithInvalidConfig(config, origProps, (scala.collection.immutable.Map<String, String>)validProps, (scala.collection.immutable.Map<String, String>)invalidProps);
    }

    @Test
    public void testReconfigurableValidation() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties origProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)origProps, KafkaConfig$.MODULE$.apply$default$2());
        Set invalidReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.BrokerIdProp(), "some.prop"}));
        Set validReconfigurableProps = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{KafkaConfig$.MODULE$.LogCleanerThreadsProp(), KafkaConfig$.MODULE$.LogCleanerDedupeBufferSizeProp(), "some.prop"}));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addReconfigurable(DynamicBrokerConfigTest.createReconfigurable$1(validReconfigurableProps));
        Assertions.assertThrows(IllegalArgumentException.class, () -> config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(invalidReconfigurableProps)));
        config.dynamicConfig().addBrokerReconfigurable(DynamicBrokerConfigTest.createBrokerReconfigurable$1(validReconfigurableProps));
    }

    @Test
    public void testSecurityConfigs() {
        this.verifyUpdate$1("ssl.keystore.location", "ks.jks");
        this.verifyUpdate$1("ssl.keystore.type", "JKS");
        this.verifyUpdate$1("ssl.keystore.password", "password");
        this.verifyUpdate$1("ssl.key.password", "password");
    }

    @Test
    public void testConnectionQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "100", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpProp(), "0", false, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName1:100,hostName2:0", false, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), "hostName#:100", true, true);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionsProp(), "100", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionsProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "10", false, false);
    }

    @Test
    public void testConnectionRateQuota() {
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "110", true, false);
        this.verifyConfigUpdate(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp(), "120", false, false);
        String listenerMaxConnectionsProp = new StringBuilder(23).append("listener.name.external.").append(KafkaConfig$.MODULE$.MaxConnectionCreationRateProp()).toString();
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "20", true, false);
        this.verifyConfigUpdate(listenerMaxConnectionsProp, "30", false, false);
    }

    private void verifyConfigUpdate(String name, Object value, boolean perBrokerConfig, boolean expectFailure) {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties configProps = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        configProps.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "broker.secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)configProps, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties props = new Properties();
        props.put(name, value);
        Object oldValue = config.originals().get(name);
        if (!expectFailure) {
            config.dynamicConfig().validate(props, perBrokerConfig);
            DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
            Assertions.assertEquals((Object)value, config.originals().get(name));
            return;
        }
        Assertions.assertThrows(Exception.class, () -> config.dynamicConfig().validate(props, perBrokerConfig));
        DynamicBrokerConfigTest.updateConfig$1(perBrokerConfig, config, props);
        Assertions.assertEquals(oldValue, config.originals().get(name));
    }

    private void verifyConfigUpdateWithInvalidConfig(KafkaConfig config, Properties origProps, scala.collection.immutable.Map<String, String> validProps, scala.collection.immutable.Map<String, String> invalidProps) {
        Properties props = new Properties();
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = props.put(k, v);
            return object;
        });
        invalidProps.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$2._1();
            String v = (String)x0$2._2();
            Object object = props.put(k, v);
            return object;
        });
        Assertions.assertThrows(ConfigException.class, () -> config.dynamicConfig().validate(props, true));
        config.dynamicConfig().updateBrokerConfig(0, props, config.dynamicConfig().updateBrokerConfig$default$3());
        validProps.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$4(config, x0$3);
            return BoxedUnit.UNIT;
        });
        invalidProps.keySet().foreach((Function1 & Serializable & scala.Serializable)name -> {
            DynamicBrokerConfigTest.$anonfun$verifyConfigUpdateWithInvalidConfig$5(origProps, config, name);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPasswordConfigEncryption() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig configWithoutSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig configWithSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "myLoginModule required;");
        try {
            configWithoutSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        }
        catch (ConfigException configException) {}
        Properties persistedProps = configWithSecret.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("myLoginModule"), (String)"Password not encoded");
        Properties decodedProps = configWithSecret.dynamicConfig().fromPersistentProps(persistedProps, true);
        Assertions.assertEquals((Object)"myLoginModule required;", (Object)decodedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()));
    }

    @Test
    public void testPasswordConfigEncoderSecretChange() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 8181;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        props.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "staticLoginModule required;");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "config-encoder-secret");
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Properties dynamicProps = new Properties();
        dynamicProps.put(KafkaConfig$.MODULE$.SaslJaasConfigProp(), "dynamicLoginModule required;");
        Properties persistedProps = config.dynamicConfig().toPersistentProps(dynamicProps, true);
        Assertions.assertFalse((boolean)persistedProps.getProperty(KafkaConfig$.MODULE$.SaslJaasConfigProp()).contains("LoginModule"), (String)"Password not encoded");
        config.dynamicConfig().updateBrokerConfig(0, persistedProps, config.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)config.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        KafkaConfig newConfigWithSameSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithSameSecret.dynamicConfig().initialize((Option)None$.MODULE$);
        newConfigWithSameSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithSameSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "new-encoder-secret");
        props.put(KafkaConfig$.MODULE$.PasswordEncoderOldSecretProp(), "config-encoder-secret");
        KafkaConfig newConfigWithNewAndOldSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewAndOldSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"dynamicLoginModule required;", (Object)((Password)newConfigWithSameSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
        props.put(KafkaConfig$.MODULE$.PasswordEncoderSecretProp(), "another-new-encoder-secret");
        KafkaConfig newConfigWithNewSecret = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        newConfigWithNewSecret.dynamicConfig().updateBrokerConfig(0, persistedProps, newConfigWithNewSecret.dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"staticLoginModule required;", (Object)((Password)newConfigWithNewSecret.values().get(KafkaConfig$.MODULE$.SaslJaasConfigProp())).value());
    }

    @Test
    public void testDynamicListenerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        props.put(KafkaConfig$.MODULE$.ListenersProp(), "PLAINTEXT://hostname:9092,SASL_PLAINTEXT://hostname:9093");
        new DynamicListenerConfig((KafkaBroker)kafkaServer).validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2()));
        props.put("listener.name.plaintext.you.should.not.pass", "failure");
        DynamicListenerConfig dynamicListenerConfig = new DynamicListenerConfig((KafkaBroker)kafkaServer);
        Assertions.assertThrows(ConfigException.class, () -> dynamicListenerConfig.validateReconfiguration(KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2())));
    }

    @Test
    public void testAuthorizerConfig() {
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20);
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(props);
        oldConfig.dynamicConfig().initialize((Option)None$.MODULE$);
        KafkaServer kafkaServer = (KafkaServer)Mockito.mock(KafkaServer.class);
        public class Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1
        implements Authorizer,
        Reconfigurable {
            private volatile String superUsers;

            public int aclCount() {
                return super.aclCount();
            }

            public AuthorizationResult authorizeByResourceType(AuthorizableRequestContext x$1, AclOperation x$2, ResourceType x$3) {
                return super.authorizeByResourceType(x$1, x$2, x$3);
            }

            public String superUsers() {
                return this.superUsers;
            }

            public void superUsers_$eq(String x$1) {
                this.superUsers = x$1;
            }

            public java.util.Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
                return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava();
            }

            public java.util.List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, java.util.List<Action> actions) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, java.util.List<AclBinding> aclBindings) {
                return null;
            }

            public java.util.List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, java.util.List<AclBindingFilter> aclBindingFilters) {
                return null;
            }

            public Iterable<AclBinding> acls(AclBindingFilter filter) {
                return null;
            }

            public void close() {
            }

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"super.users"}))).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
                this.superUsers_$eq(configs.get("super.users").toString());
            }

            public Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(DynamicBrokerConfigTest $outer) {
                this.superUsers = "";
            }
        }
        Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1 authorizer = new Kafka_server_DynamicBrokerConfigTest$TestAuthorizer$1(null);
        Mockito.when((Object)kafkaServer.config()).thenReturn((Object)oldConfig);
        Mockito.when((Object)kafkaServer.authorizer()).thenReturn((Object)new Some((Object)authorizer));
        Assertions.assertThrows(Throwable.class, () -> kafkaServer.config().dynamicConfig().addReconfigurables((KafkaBroker)kafkaServer));
        props.put("super.users", "User:admin");
        kafkaServer.config().dynamicConfig().updateBrokerConfig(0, props, kafkaServer.config().dynamicConfig().updateBrokerConfig$default$3());
        Assertions.assertEquals((Object)"User:admin", (Object)authorizer.superUsers());
    }

    @Test
    public void testSynonyms() {
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.secure.ssl.keystore.type", (List)new .colon.colon((Object)"ssl.keystore.type", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.secure.ssl.keystore.type", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"listener.name.sasl_ssl.plain.sasl.jaas.config", (List)new .colon.colon((Object)"sasl.jaas.config", (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("listener.name.sasl_ssl.plain.sasl.jaas.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)"some.config", (List)Nil$.MODULE$), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms("some.config", true));
        Assertions.assertEquals((Object)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeMillisProp(), (List)new .colon.colon((Object)KafkaConfig$.MODULE$.LogRollTimeHoursProp(), (List)Nil$.MODULE$)), (Object)DynamicBrokerConfig$.MODULE$.brokerConfigSynonyms(KafkaConfig$.MODULE$.LogRollTimeMillisProp(), true));
    }

    @Test
    public void testDynamicConfigInitializationWithoutConfigsInZK() {
        KafkaZkClient zkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        Mockito.when((Object)zkClient.getEntityConfigs(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)new Properties());
        int x$1 = 0;
        String x$2 = TestUtils$.MODULE$.MockZkConnect();
        int x$3 = 9092;
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        KafkaConfig oldConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$4, x$5, x$3, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20));
        DynamicBrokerConfig dynamicBrokerConfig = new DynamicBrokerConfig(oldConfig);
        dynamicBrokerConfig.initialize((Option)new Some((Object)zkClient));
        dynamicBrokerConfig.addBrokerReconfigurable((BrokerReconfigurable)new TestDynamicThreadPool());
        Properties newprops = new Properties();
        newprops.put(KafkaConfig$.MODULE$.NumIoThreadsProp(), "10");
        newprops.put(KafkaConfig$.MODULE$.BackgroundThreadsProp(), "100");
        dynamicBrokerConfig.updateBrokerConfig(0, newprops, dynamicBrokerConfig.updateBrokerConfig$default$3());
    }

    @Test
    public void testImproperConfigsAreRemoved() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20());
        KafkaConfig config = KafkaConfig$.MODULE$.apply((java.util.Map)props, KafkaConfig$.MODULE$.apply$default$2());
        config.dynamicConfig().initialize((Option)None$.MODULE$);
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)Defaults$.MODULE$.MessageMaxBytes(), (Integer)config.messageMaxBytes());
        Properties newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "9999");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "2222");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)9999, (Integer)config.maxConnections());
        Assertions.assertEquals((int)2222, (Integer)config.messageMaxBytes());
        newProps = new Properties();
        newProps.put(KafkaConfig$.MODULE$.MaxConnectionsProp(), "INVALID_INT");
        newProps.put(KafkaConfig$.MODULE$.MessageMaxBytesProp(), "1111");
        config.dynamicConfig().updateDefaultConfig(newProps, config.dynamicConfig().updateDefaultConfig$default$2());
        Assertions.assertEquals((int)Defaults$.MODULE$.MaxConnections(), (Integer)config.maxConnections());
        Assertions.assertEquals((int)1111, (Integer)config.messageMaxBytes());
    }

    public static final void kafka$server$DynamicBrokerConfigTest$$validateLogCleanerConfig$1(java.util.Map configs) {
        int cleanerThreads = new StringOps(Predef$.MODULE$.augmentString(configs.get(KafkaConfig$.MODULE$.LogCleanerThreadsProp()).toString())).toInt();
        if (cleanerThreads <= 0 || cleanerThreads >= 5) {
            throw new ConfigException(new StringBuilder(24).append("Invalid cleaner threads ").append(cleanerThreads).toString());
        }
    }

    private static final Reconfigurable createReconfigurable$1(Set configs) {
        return new Reconfigurable(null, configs){
            private final Set configs$1;

            public void configure(java.util.Map<String, ?> configs) {
            }

            public java.util.Set<String> reconfigurableConfigs() {
                return (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(this.configs$1).asJava();
            }

            public void validateReconfiguration(java.util.Map<String, ?> configs) {
            }

            public void reconfigure(java.util.Map<String, ?> configs) {
            }
            {
                this.configs$1 = configs$1;
            }
        };
    }

    private static final BrokerReconfigurable createBrokerReconfigurable$1(Set configs) {
        return new BrokerReconfigurable(null, configs){
            private final Set configs$2;

            public Set<String> reconfigurableConfigs() {
                return this.configs$2;
            }

            public void validateReconfiguration(KafkaConfig newConfig) {
            }

            public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
            }
            {
                this.configs$2 = configs$2;
            }
        };
    }

    private final void verifyUpdate$1(String name, Object value) {
        this.verifyConfigUpdate(name, value, true, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, true, false);
        this.verifyConfigUpdate(name, value, false, true);
        this.verifyConfigUpdate(new StringBuilder(23).append("listener.name.external.").append(name).toString(), value, false, true);
    }

    private static final void updateConfig$1(boolean perBrokerConfig$1, KafkaConfig config$3, Properties props$1) {
        if (perBrokerConfig$1) {
            config$3.dynamicConfig().updateBrokerConfig(0, config$3.dynamicConfig().toPersistentProps(props$1, perBrokerConfig$1), config$3.dynamicConfig().updateBrokerConfig$default$3());
            return;
        }
        config$3.dynamicConfig().updateDefaultConfig(props$1, config$3.dynamicConfig().updateDefaultConfig$default$2());
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$4(KafkaConfig config$4, Tuple2 x0$3) {
        if (x0$3 != null) {
            String name = (String)x0$3._1();
            Assertions.assertEquals((Object)((String)x0$3._2()), config$4.originals().get(name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$verifyConfigUpdateWithInvalidConfig$5(Properties origProps$1, KafkaConfig config$4, String name) {
        Assertions.assertEquals((Object)origProps$1.get(name), config$4.originals().get(name));
    }
}

