/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\t\u0012\u0001YA\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tk\u0001\u0011\t\u0011)A\u0005G!Aa\u0007\u0001BC\u0002\u0013\u0005q\u0007\u0003\u0005<\u0001\t\u0005\t\u0015!\u00039\u0011!a\u0004A!b\u0001\n\u0003i\u0004\u0002\u0003$\u0001\u0005\u0003\u0005\u000b\u0011\u0002 \t\u0011\u001d\u0003!Q1A\u0005\u0002!C\u0001B\u001c\u0001\u0003\u0002\u0003\u0006I!\u0013\u0005\t_\u0002\u0011)\u0019!C\u0001a\"A\u0011\u0010\u0001B\u0001B\u0003%\u0011\u000f\u0003\u0005{\u0001\t\u0015\r\u0011\"\u0001|\u0011%\t)\u0001\u0001B\u0001B\u0003%A\u0010C\u0004\u0002\b\u0001!\t!!\u0003\t\u000f\u0005e\u0001\u0001\"\u0011\u0002\u001c!9\u0011q\t\u0001\u0005B\u0005%#!G&SC\u001a$\u0018+^8sk6LU\u000e\u001d7f[\u0016tG/\u0019;j_:T!AE\n\u0002\rM,'O^3s\u0015\u0005!\u0012!B6bM.\f7\u0001A\n\u0004\u0001]i\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g\r\u0005\u0002\u001f?5\t\u0011#\u0003\u0002!#\t!\u0012+^8sk6LU\u000e\u001d7f[\u0016tG/\u0019;j_:\f1B]1gi6\u000bg.Y4feV\t1\u0005E\u0002%O%j\u0011!\n\u0006\u0003MM\tAA]1gi&\u0011\u0001&\n\u0002\u0011\u0017\u000647.\u0019*bMRl\u0015M\\1hKJ\u0004\"AK\u001a\u000e\u0003-R!\u0001L\u0017\u0002\r\r|W.\\8o\u0015\t\u0011bF\u0003\u0002\u0015_)\u0011\u0001'M\u0001\u0007CB\f7\r[3\u000b\u0003I\n1a\u001c:h\u0013\t!4F\u0001\u000bBa&lUm]:bO\u0016\fe\u000e\u001a,feNLwN\\\u0001\re\u00064G/T1oC\u001e,'\u000fI\u0001\u0011G>tGO]8mY\u0016\u00148+\u001a:wKJ,\u0012\u0001\u000f\t\u0003=eJ!AO\t\u0003!\r{g\u000e\u001e:pY2,'oU3sm\u0016\u0014\u0018!E2p]R\u0014x\u000e\u001c7feN+'O^3sA\u0005YQ.\u001a;bI\u0006$\u0018\rR5s+\u0005q\u0004CA E\u001b\u0005\u0001%BA!C\u0003\tIwNC\u0001D\u0003\u0011Q\u0017M^1\n\u0005\u0015\u0003%\u0001\u0002$jY\u0016\fA\"\\3uC\u0012\fG/\u0019#je\u0002\nAdY8oiJ|G\u000e\\3s#V|'/^7W_R,'o\u001d$viV\u0014X-F\u0001J!\rQu*U\u0007\u0002\u0017*\u0011A*T\u0001\u000bG>t7-\u001e:sK:$(B\u0001(C\u0003\u0011)H/\u001b7\n\u0005A[%!E\"p[BdW\r^1cY\u00164U\u000f^;sKB!!kU+\\\u001b\u0005i\u0015B\u0001+N\u0005\ri\u0015\r\u001d\t\u0003-fk\u0011a\u0016\u0006\u00031\n\u000bA\u0001\\1oO&\u0011!l\u0016\u0002\b\u0013:$XmZ3s!\ta6N\u0004\u0002^Q:\u0011al\u001a\b\u0003?\u001at!\u0001Y3\u000f\u0005\u0005$W\"\u00012\u000b\u0005\r,\u0012A\u0002\u001fs_>$h(C\u00013\u0013\t\u0001\u0014'\u0003\u0002\u0015_%\u0011aEL\u0005\u0003S*\f!BU1gi\u000e{gNZ5h\u0015\t1c&\u0003\u0002m[\nY\u0011\t\u001a3sKN\u001c8\u000b]3d\u0015\tI'.A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003%\u0019G.^:uKJLE-F\u0001r!\t\u0011hO\u0004\u0002tiB\u0011\u0011-G\u0005\u0003kf\ta\u0001\u0015:fI\u00164\u0017BA<y\u0005\u0019\u0019FO]5oO*\u0011Q/G\u0001\u000bG2,8\u000f^3s\u0013\u0012\u0004\u0013a\u00017pOV\tA\u0010E\u0002~\u0003\u0003i\u0011A \u0006\u0003\u007fN\tQ!\u001e;jYNL1!a\u0001\u007f\u0005\u001daunZ4j]\u001e\fA\u0001\\8hA\u00051A(\u001b8jiz\"b\"a\u0003\u0002\u000e\u0005=\u0011\u0011CA\n\u0003+\t9\u0002\u0005\u0002\u001f\u0001!)\u0011%\u0004a\u0001G!)a'\u0004a\u0001q!)A(\u0004a\u0001}!)q)\u0004a\u0001\u0013\")q.\u0004a\u0001c\")!0\u0004a\u0001y\u0006a1M]3bi\u0016\u0014%o\\6feRA\u0011QDA\u0012\u0003[\ti\u0004E\u0002\u001f\u0003?I1!!\t\u0012\u0005-Y\u0015MZ6b\u0005J|7.\u001a:\t\u000f\u0005\u0015b\u00021\u0001\u0002(\u000511m\u001c8gS\u001e\u00042AHA\u0015\u0013\r\tY#\u0005\u0002\f\u0017\u000647.Y\"p]\u001aLw\rC\u0004\u000209\u0001\r!!\r\u0002\tQLW.\u001a\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019q0a\u000e\u000b\u00051r\u0013\u0002BA\u001e\u0003k\u0011A\u0001V5nK\"9\u0011q\b\bA\u0002\u0005\u0005\u0013aB:uCJ$X\u000f\u001d\t\u00041\u0005\r\u0013bAA#3\t9!i\\8mK\u0006t\u0017\u0001C:ikR$wn\u001e8\u0015\u0005\u0005-\u0003c\u0001\r\u0002N%\u0019\u0011qJ\r\u0003\tUs\u0017\u000e\u001e")
public class KRaftQuorumImplementation
implements QuorumImplementation {
    private final KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private final ControllerServer controllerServer;
    private final File metadataDir;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final String clusterId;
    private final Logging log;

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public ControllerServer controllerServer() {
        return this.controllerServer;
    }

    public File metadataDir() {
        return this.metadataDir;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public Logging log() {
        return this.log;
    }

    @Override
    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup) {
        BrokerServer broker = new BrokerServer(config, new MetaProperties(this.clusterId(), config.nodeId()), this.raftManager(), time, new Metrics(), (Option)new Some((Object)new StringOps(Predef$.MODULE$.augmentString("Broker%02d_")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.nodeId())}))), (Seq)Nil$.MODULE$, this.controllerQuorumVotersFuture(), Collections.emptyMap());
        if (startup) {
            broker.startup();
        }
        return broker;
    }

    @Override
    public void shutdown() {
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftManager().shutdown(), this.log(), CoreUtils$.MODULE$.swallow$default$3());
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerServer().shutdown(), this.log(), CoreUtils$.MODULE$.swallow$default$3());
    }

    public KRaftQuorumImplementation(KafkaRaftManager<ApiMessageAndVersion> raftManager, ControllerServer controllerServer, File metadataDir, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, String clusterId, Logging log) {
        this.raftManager = raftManager;
        this.controllerServer = controllerServer;
        this.metadataDir = metadataDir;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.clusterId = clusterId;
        this.log = log;
    }
}

