/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.login.Configuration;
import kafka.raft.KafkaRaftManager;
import kafka.raft.RaftManager;
import kafka.server.ControllerServer;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t\u001dd!B\u00181\u0003\u0003)\u0004\"\u0002\"\u0001\t\u0003\u0019\u0005b\u0002$\u0001\u0005\u0004%\ta\u0012\u0005\u0007\u0017\u0002\u0001\u000b\u0011\u0002%\t\u000f1\u0003!\u0019!C\u0001\u000f\"1Q\n\u0001Q\u0001\n!CqA\u0014\u0001C\u0002\u0013\u0005q\t\u0003\u0004P\u0001\u0001\u0006I\u0001\u0013\u0005\u0006!\u0002!\t\"\u0015\u0005\b1\u0002\u0011\r\u0011\"\u0005Z\u0011\u0019I\u0007\u0001)A\u00055\")!\u000e\u0001C\tW\"9!\u0010\u0001a\u0001\n\u0013Y\b\u0002C@\u0001\u0001\u0004%I!!\u0001\t\u000f\u00055\u0001\u0001)Q\u0005y\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003/\u0001A\u0011AA\u000b\u0011\u001d\tI\u0002\u0001C\u0005\u00037Aq!a\t\u0001\t\u0013\t)\u0003C\u0004\u0002.\u0001!\t!a\f\t\u000f\u0005u\u0002\u0001\"\u0001\u0002@!9\u0011q\t\u0001\u0005\u0002\u0005}\u0002bBA%\u0001\u0011\u0005\u00111\n\u0005\u0007\u0003'\u0002A\u0011A$\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X!9\u0011q\u000e\u0001\u0005\u0002\u0005]\u0003bBA9\u0001\u0011\u0005\u00111\u000f\u0005\b\u0003w\u0002A\u0011AA?\u0011\u001d\t\t\t\u0001C\u0001\u0003\u0007Cq!!*\u0001\t\u0003\t9\u000bC\u0005\u0002L\u0002\t\n\u0011\"\u0001\u0002N\"I\u00111\u001d\u0001\u0012\u0002\u0013\u0005\u0011Q\u001d\u0005\b\u0003S\u0004A\u0011AA\u000b\u0011\u001d\tY\u000f\u0001C\u0001\u0003+Aq!!<\u0001\t\u0013\ty\u000fC\u0004\u0003\n\u0001!IAa\u0003\t\u000f\t=\u0001\u0001\"\u0003\u0002\u001c!9!\u0011\u0003\u0001\u0005\u0002\u0005U\u0001b\u0002B\u000e\u0001\u0011\u0005!QD\u0004\b\u0005w\u0001\u0004\u0012\u0001B\u001f\r\u0019y\u0003\u0007#\u0001\u0003@!1!)\u000bC\u0001\u0005\u0003B\u0011Ba\u0011*\u0005\u0004%\tA!\u0012\t\u0011\tE\u0013\u0006)A\u0005\u0005\u000fBqAa\u0015*\t\u0003\t)\u0002C\u0004\u0003^%\"\t!!\u0006\u0003#E+xN];n)\u0016\u001cH\u000fS1s]\u0016\u001c8O\u0003\u00022e\u000511/\u001a:wKJT\u0011aM\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001a\u0007\u0010\t\u0003oij\u0011\u0001\u000f\u0006\u0002s\u0005)1oY1mC&\u00111\b\u000f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0012\u0014!B;uS2\u001c\u0018BA!?\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u0001#\u0011\u0005\u0015\u0003Q\"\u0001\u0019\u0002'i\\7i\u001c8oK\u000e$\u0018n\u001c8US6,w.\u001e;\u0016\u0003!\u0003\"aN%\n\u0005)C$aA%oi\u0006!\"p[\"p]:,7\r^5p]RKW.Z8vi\u0002\n\u0001C_6TKN\u001c\u0018n\u001c8US6,w.\u001e;\u0002#i\\7+Z:tS>tG+[7f_V$\b%A\u000b{W6\u000b\u00070\u00138GY&<\u0007\u000e\u001e*fcV,7\u000f^:\u0002-i\\W*\u0019=J]\u001ac\u0017n\u001a5u%\u0016\fX/Z:ug\u0002\nQB_6BG2\u001cXI\\1cY\u0016$W#\u0001*\u0011\u0007]\u001aV+\u0003\u0002Uq\t1q\n\u001d;j_:\u0004\"a\u000e,\n\u0005]C$a\u0002\"p_2,\u0017M\\\u0001#G>tGO]8mY\u0016\u0014H*[:uK:,'oU3dkJLG/\u001f)s_R|7m\u001c7\u0016\u0003i\u0003\"aW4\u000e\u0003qS!!\u00180\u0002\t\u0005,H\u000f\u001b\u0006\u0003?\u0002\f\u0001b]3dkJLG/\u001f\u0006\u0003C\n\faaY8n[>t'BA\u001ad\u0015\t!W-\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0006\u0019qN]4\n\u0005!d&\u0001E*fGV\u0014\u0018\u000e^=Qe>$xnY8m\u0003\r\u001awN\u001c;s_2dWM\u001d'jgR,g.\u001a:TK\u000e,(/\u001b;z!J|Go\\2pY\u0002\nac\u001b:bMR\u001cuN\u001c;s_2dWM]\"p]\u001aLwm\u001d\u000b\u0002YB\u0019Q\u000e\u001d:\u000e\u00039T!a\u001c\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002r]\n\u00191+Z9\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018\u0001B;uS2T\u0011a^\u0001\u0005U\u00064\u0018-\u0003\u0002zi\nQ\u0001K]8qKJ$\u0018.Z:\u0002\u001d%l\u0007\u000f\\3nK:$\u0018\r^5p]V\tA\u0010\u0005\u0002F{&\u0011a\u0010\r\u0002\u0015#V|'/^7J[BdW-\\3oi\u0006$\u0018n\u001c8\u0002%%l\u0007\u000f\\3nK:$\u0018\r^5p]~#S-\u001d\u000b\u0005\u0003\u0007\tI\u0001E\u00028\u0003\u000bI1!a\u00029\u0005\u0011)f.\u001b;\t\u0011\u0005-Q\"!AA\u0002q\f1\u0001\u001f\u00132\u0003=IW\u000e\u001d7f[\u0016tG/\u0019;j_:\u0004\u0013aC5t\u0017J\u000bg\r\u001e+fgR$\u0012!V\u0001\u000eG\",7m[%t5.#Vm\u001d;\u0015\u0005\u0005\r\u0011\u0001E2iK\u000e\\\u0017j]&SC\u001a$H+Z:u\u0003\u0011\t7OW6\u0015\u0005\u0005u\u0001cA#\u0002 %\u0019\u0011\u0011\u0005\u0019\u0003;i{wnS3fa\u0016\u0014\u0018+^8sk6LU\u000e\u001d7f[\u0016tG/\u0019;j_:\fq!Y:L%\u00064G\u000f\u0006\u0002\u0002(A\u0019Q)!\u000b\n\u0007\u0005-\u0002GA\rL%\u00064G/U;peVl\u0017*\u001c9mK6,g\u000e^1uS>t\u0017!\u0003>p_.,W\r]3s+\t\t\t\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9DM\u0001\u0003u.LA!a\u000f\u00026\t\tR)\u001c2fI\u0012,GMW8pW\u0016,\u0007/\u001a:\u0002\u0011i\\7\t\\5f]R,\"!!\u0011\u0011\t\u0005M\u00121I\u0005\u0005\u0003\u000b\n)DA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\u000fu.\u001cE.[3oi>\u0013h*\u001e7m\u00035\tG-\\5o5.\u001cE.[3oiV\u0011\u0011Q\n\t\u0005\u0003g\ty%\u0003\u0003\u0002R\u0005U\"!D!e[&t'l[\"mS\u0016tG/\u0001\u0004{WB{'\u000f^\u0001\nu.\u001cuN\u001c8fGR,\"!!\u0017\u0011\t\u0005m\u0013\u0011\u000e\b\u0005\u0003;\n)\u0007E\u0002\u0002`aj!!!\u0019\u000b\u0007\u0005\rD'\u0001\u0004=e>|GOP\u0005\u0004\u0003OB\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002l\u00055$AB*ue&twMC\u0002\u0002ha\nqB_6D_:tWm\u0019;Pe:+H\u000e\\\u0001\u0011G>tGO]8mY\u0016\u00148+\u001a:wKJ,\"!!\u001e\u0011\u0007\u0015\u000b9(C\u0002\u0002zA\u0012\u0001cQ8oiJ|G\u000e\\3s'\u0016\u0014h/\u001a:\u0002#\r|g\u000e\u001e:pY2,'oU3sm\u0016\u00148/\u0006\u0002\u0002\u0000A!Q\u000e]A;\u0003\u0015\u0019X\r^+q)\u0011\t\u0019!!\"\t\u000f\u0005\u001dU\u00041\u0001\u0002\n\u0006AA/Z:u\u0013:4w\u000e\u0005\u0003\u0002\f\u0006eUBAAG\u0015\u0011\ty)!%\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002\u0014\u0006U\u0015a\u00026va&$XM\u001d\u0006\u0004\u0003/+\u0017!\u00026v]&$\u0018\u0002BAN\u0003\u001b\u0013\u0001\u0002V3ti&sgm\u001c\u0015\u0004;\u0005}\u0005\u0003BAF\u0003CKA!a)\u0002\u000e\nQ!)\u001a4pe\u0016,\u0015m\u00195\u0002\u0019\r\u0014X-\u0019;f\u0005J|7.\u001a:\u0015\u0011\u0005%\u0016qVA]\u0003\u000f\u00042!RAV\u0013\r\ti\u000b\r\u0002\f\u0017\u000647.\u0019\"s_.,'\u000fC\u0004\u00022z\u0001\r!a-\u0002\r\r|gNZ5h!\r)\u0015QW\u0005\u0004\u0003o\u0003$aC&bM.\f7i\u001c8gS\u001eD\u0011\"a/\u001f!\u0003\u0005\r!!0\u0002\tQLW.\u001a\t\u0005\u0003\u007f\u000b\u0019-\u0004\u0002\u0002B*\u0011q\bY\u0005\u0005\u0003\u000b\f\tM\u0001\u0003US6,\u0007\u0002CAe=A\u0005\t\u0019A+\u0002\u000fM$\u0018M\u001d;va\u000612M]3bi\u0016\u0014%o\\6fe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002P*\"\u0011QXAiW\t\t\u0019\u000e\u0005\u0003\u0002V\u0006}WBAAl\u0015\u0011\tI.a7\u0002\u0013Ut7\r[3dW\u0016$'bAAoq\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0018q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AF2sK\u0006$XM\u0011:pW\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u001d(fA+\u0002R\u0006\t2\u000f[;uI><hNW8p\u0017\u0016,\u0007/\u001a:\u0002/MDW\u000f\u001e3po:\\%+\u00194u\u0007>tGO]8mY\u0016\u0014\u0018!\u00054pe6\fG\u000fR5sK\u000e$xN]5fgR1\u00111AAy\u0003\u007fDq!a=$\u0001\u0004\t)0A\u0006eSJ,7\r^8sS\u0016\u001c\bCBA|\u0003{\fI&\u0004\u0002\u0002z*\u0019\u00111 8\u0002\u0013%lW.\u001e;bE2,\u0017bA9\u0002z\"9!\u0011A\u0012A\u0002\t\r\u0011AD7fi\u0006\u0004&o\u001c9feRLWm\u001d\t\u0004\u000b\n\u0015\u0011b\u0001B\u0004a\tqQ*\u001a;b!J|\u0007/\u001a:uS\u0016\u001c\u0018A\u00048fo.\u0013\u0016M\u001a;Rk>\u0014X/\u001c\u000b\u0005\u0003O\u0011i\u0001C\u0004\u0002\b\u0012\u0002\r!!#\u0002%9,wOW8p\u0017\u0016,\u0007/\u001a:Rk>\u0014X/\\\u0001\ti\u0016\f'\u000fR8x]\"\u001aaE!\u0006\u0011\t\u0005-%qC\u0005\u0005\u00053\tiIA\u0005BMR,'/R1dQ\u0006Y3M]3bi\u0016Tvn\\&fKB,'o\u00117jK:$Hk\u001c+sS\u001e<WM]*fgNLwN\\#ya&\u0014\u0018\u0010\u0006\u0003\u0003 \t%\u0002\u0003\u0002B\u0011\u0005Ki!Aa\t\u000b\u0007\u000552-\u0003\u0003\u0003(\t\r\"!\u0003.p_.+W\r]3s\u0011\u001d\u0011Yc\na\u0001\u0005?\t\u0011B_8p\u0017\u0016,\u0007/\u001a:)\u000f\u0001\u0011yC!\u000e\u00038A!\u00111\u0012B\u0019\u0013\u0011\u0011\u0019$!$\u0003\u0007Q\u000bw-A\u0003wC2,X-\t\u0002\u0003:\u0005Y\u0011N\u001c;fOJ\fG/[8o\u0003E\tVo\u001c:v[R+7\u000f\u001e%be:,7o\u001d\t\u0003\u000b&\u001a\"!\u000b\u001c\u0015\u0005\tu\u0012!\u0007.l\u00072LWM\u001c;Fm\u0016tG\u000f\u00165sK\u0006$7+\u001e4gSb,\"Aa\u0012\u0011\t\t%#qJ\u0007\u0003\u0005\u0017R1A!\u0014w\u0003\u0011a\u0017M\\4\n\t\u0005-$1J\u0001\u001b5.\u001cE.[3oi\u00163XM\u001c;UQJ,\u0017\rZ*vM\u001aL\u0007\u0010I\u0001\u000bg\u0016$X\u000b]\"mCN\u001c\bfA\u0017\u0003XA!\u00111\u0012B-\u0013\u0011\u0011Y&!$\u0003\u0013\t+gm\u001c:f\u00032d\u0017!\u0004;fCJ$un\u001e8DY\u0006\u001c8\u000fK\u0002/\u0005C\u0002B!a#\u0003d%!!QMAG\u0005!\te\r^3s\u00032d\u0007")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private final SecurityProtocol controllerListenerSecurityProtocol;
    private QuorumImplementation implementation;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.setUpClass();
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public boolean isKRaftTest() {
        return this.implementation() instanceof KRaftQuorumImplementation;
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        String name;
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String string = name = testInfo.getTestMethod().isPresent() ? ((Method)testInfo.getTestMethod().get()).toString() : "[unspecified]";
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup) {
        return this.implementation().createBroker(config, time, startup);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), CoreUtils$.MODULE$.swallow$default$3());
    }

    private void formatDirectories(scala.collection.immutable.Seq<String> directories, MetaProperties metaProperties) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories).toString());
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        String clusterId = Uuid.randomUuid().toString();
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties(clusterId, 0);
        this.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties);
        Metrics controllerMetrics = new Metrics();
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), "1000@localhost:0");
        KafkaConfig config = new KafkaConfig((Map)props);
        String threadNamePrefix = new StringBuilder(11).append("Controller_").append(testInfo.getDisplayName()).toString();
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        KafkaRaftManager raftManager = new KafkaRaftManager(metaProperties, config, (RecordSerde)MetadataRecordSerde.INSTANCE, new TopicPartition(KafkaRaftServer$.MODULE$.MetadataTopic(), 0), KafkaRaftServer$.MODULE$.MetadataTopicId(), Time.SYSTEM, controllerMetrics, Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture);
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(metaProperties, config, (RaftManager)raftManager, Time.SYSTEM, controllerMetrics, Option$.MODULE$.apply((Object)threadNamePrefix), controllerQuorumVotersFuture, KafkaRaftServer$.MODULE$.configSchema());
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(1000), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
            raftManager.startup();
        }
        catch (Throwable e2) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> raftManager.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw e2;
        }
        return new KRaftQuorumImplementation((KafkaRaftManager<ApiMessageAndVersion>)raftManager, (ControllerServer)controllerServer.elem, metadataDir, controllerQuorumVotersFuture, clusterId, this);
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString(), BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSaslEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "ZooKeeperTestHarness", new ZKClientConfig(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10(), KafkaZkClient$.MODULE$.apply$default$11());
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zookeeper.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public QuorumTestHarness() {
        Logging.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
        this.implementation = null;
    }
}

