/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.ApiVersion;
import kafka.api.LeaderAndIsr;
import kafka.cluster.Partition;
import kafka.log.AppendOrigin;
import kafka.log.CleanerConfig;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchPartitionData;
import kafka.server.HostedPartition;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerConcurrencyTest$AlterIsrEvent$;
import kafka.server.ReplicaManagerConcurrencyTest$InitializeEvent$;
import kafka.server.ReplicaManagerConcurrencyTest$ShutdownEvent$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.MockConfigRepository;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.PartitionChangeRecord;
import org.apache.kafka.common.metadata.PartitionRecord;
import org.apache.kafka.common.metadata.TopicRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.replica.ClientMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.metadata.PartitionRegistration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015haBA\r\u00037\u0001\u0011Q\u0005\u0005\b\u0003g\u0001A\u0011AA\u001b\u0011%\tY\u0004\u0001b\u0001\n\u0013\ti\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0011BA \u0011%\ti\u0005\u0001b\u0001\n\u0013\ty\u0005\u0003\u0005\u0002j\u0001\u0001\u000b\u0011BA)\u0011%\tY\u0007\u0001b\u0001\n\u0013\ti\u0007\u0003\u0005\u0002\u0004\u0002\u0001\u000b\u0011BA8\u0011%\t)\t\u0001b\u0001\n\u0013\t9\t\u0003\u0005\u0002 \u0002\u0001\u000b\u0011BAE\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!a,\u0001\t\u0003\t\t\fC\u0004\u0002J\u0002!\t!!-\u0007\r\u0005M\u0007\u0001BAk\u0011)\tY$\u0004B\u0001B\u0003%\u0011q\b\u0005\b\u0003giA\u0011AAl\u0011\u001d\ty.\u0004C!\u0003cCq!!9\u0001\t\u0013\t\u0019O\u0002\u0004\u0003\u0000\u0002!1\u0011\u0001\u0005\r\u0007\u0007\u0011\"\u0011!Q\u0001\n\r\u00151\u0011\u0004\u0005\u000b\u0007;\u0011\"\u0011!Q\u0001\n\u0005=\bBCB\u0010%\t\u0005\t\u0015!\u0003\u0004\"!Q1q\u0005\n\u0003\u0002\u0003\u0006I!!:\t\u000f\u0005M\"\u0003\"\u0001\u0004*!I1Q\u0007\nC\u0002\u0013%1q\u0007\u0005\t\u0007\u0007\u0012\u0002\u0015!\u0003\u0004:!I1Q\t\nC\u0002\u0013%1q\t\u0005\t\u0007_\u0012\u0002\u0015!\u0003\u0004J!I1\u0011\u000f\nA\u0002\u0013%11\u000f\u0005\n\u0007w\u0012\u0002\u0019!C\u0005\u0007{B\u0001b!!\u0013A\u0003&1Q\u000f\u0005\b\u0003?\u0014B\u0011IAY\r\u0019\u0019\u0019\t\u0001\u0003\u0004\u0006\"a11\u0001\u0011\u0003\u0002\u0003\u0006Ia!\u0002\u0004\u001a!Q!\u0011\b\u0011\u0003\u0002\u0003\u0006IA!\u0010\t\u0015\r\u001d\u0002E!A!\u0002\u0013\t)\u000fC\u0004\u00024\u0001\"\taa\"\t\u0013\rU\u0002E1A\u0005\n\r]\u0002\u0002CB\"A\u0001\u0006Ia!\u000f\t\u0013\rE\u0005\u00051A\u0005\n\t]\u0005\"CBJA\u0001\u0007I\u0011BBK\u0011!\u0019I\n\tQ!\n\u0005=\bbBApA\u0011\u0005\u0013\u0011\u0017\u0005\u000f\u00077\u0003\u0003\u0013aA\u0001\u0002\u0013%1QTB\r\r%\u0011i\u0001\u0001I\u0001$C\u0011yaB\u0004\u0004 \u0002A\tIa5\u0007\u000f\t5\u0007\u0001#!\u0003P\"9\u00111\u0007\u0018\u0005\u0002\tE\u0007\"\u0003BC]\u0005\u0005I\u0011\tBD\u0011%\u0011)JLA\u0001\n\u0003\u00119\nC\u0005\u0003\u001a:\n\t\u0011\"\u0001\u0003V\"I!q\u0015\u0018\u0002\u0002\u0013\u0005#\u0011\u0016\u0005\n\u0005gs\u0013\u0011!C\u0001\u00053D\u0011Ba0/\u0003\u0003%\tE!1\t\u0013\t\rg&!A\u0005B\t\u0015waBBQ\u0001!\u0005%1\u001d\u0004\b\u0005;\u0004\u0001\u0012\u0011Bp\u0011\u001d\t\u0019\u0004\u000fC\u0001\u0005CD\u0011B!\"9\u0003\u0003%\tEa\"\t\u0013\tU\u0005(!A\u0005\u0002\t]\u0005\"\u0003BMq\u0005\u0005I\u0011\u0001Bs\u0011%\u00119\u000bOA\u0001\n\u0003\u0012I\u000bC\u0005\u00034b\n\t\u0011\"\u0001\u0003j\"I!q\u0018\u001d\u0002\u0002\u0013\u0005#\u0011\u0019\u0005\n\u0005\u0007D\u0014\u0011!C!\u0005\u000b4aAa\u0005\u0001\u0001\nU\u0001B\u0003B\u0012\u0003\nU\r\u0011\"\u0001\u0003&!Q!qG!\u0003\u0012\u0003\u0006IAa\n\t\u0015\te\u0012I!f\u0001\n\u0003\u0011Y\u0004\u0003\u0006\u0003F\u0005\u0013\t\u0012)A\u0005\u0005{A!Ba\u0012B\u0005+\u0007I\u0011\u0001B%\u0011)\u0011Y%\u0011B\tB\u0003%!Q\u0006\u0005\b\u0003g\tE\u0011\u0001B'\u0011%\u00119&QA\u0001\n\u0003\u0011I\u0006C\u0005\u0003b\u0005\u000b\n\u0011\"\u0001\u0003d!I!\u0011P!\u0012\u0002\u0013\u0005!1\u0010\u0005\n\u0005\u007f\n\u0015\u0013!C\u0001\u0005\u0003C\u0011B!\"B\u0003\u0003%\tEa\"\t\u0013\tU\u0015)!A\u0005\u0002\t]\u0005\"\u0003BM\u0003\u0006\u0005I\u0011\u0001BN\u0011%\u00119+QA\u0001\n\u0003\u0012I\u000bC\u0005\u00034\u0006\u000b\t\u0011\"\u0001\u00036\"I!qX!\u0002\u0002\u0013\u0005#\u0011\u0019\u0005\n\u0005\u0007\f\u0015\u0011!C!\u0005\u000bD\u0011Ba2B\u0003\u0003%\tE!3\b\u0013\r\r\u0006!!A\t\u0002\r\u0015f!\u0003B\n\u0001\u0005\u0005\t\u0012ABT\u0011\u001d\t\u0019D\u0016C\u0001\u0007kC\u0011Ba1W\u0003\u0003%)E!2\t\u0013\r]f+!A\u0005\u0002\u000ee\u0006\"CBa-\u0006\u0005I\u0011QBb\r\u0019\tY\u0010\u0001\u0003\u0002~\"9\u00111G.\u0005\u0002\u0005}\b\"\u0003B\u00017\n\u0007I\u0011\u0002B\u0002\u0011!\u0011io\u0017Q\u0001\n\t\u0015\u0001b\u0002Bx7\u0012\u0005!\u0011\u001f\u0005\b\u0005g\\F\u0011\u0001B{\u0011\u001d\u0011Yp\u0017C\u0001\u0003cCqA!@\\\t\u0003\t\tL\u0002\u0004\u0004V\u0002!1q\u001b\u0005\u000b\u00073\u001c'\u0011!Q\u0001\n\rm\u0007BCA|G\n\u0005\t\u0015!\u0003\u0002z\"Q1qE2\u0003\u0002\u0003\u0006I!!:\t\u000f\u0005M2\r\"\u0001\u0005v!IAqP2A\u0002\u0013%A\u0011\u0011\u0005\n\t\u0013\u001b\u0007\u0019!C\u0005\t\u0017C\u0001\u0002b$dA\u0003&A1\u0011\u0005\b\u0005w\u001cG\u0011AAY\u0011\u001d\u0011ip\u0019C!\u0003cCq!a8d\t\u0003\n\tL\u0002\u0004\u0004^\u0002!1q\u001c\u0005\u000b\u0007Ct'Q1A\u0005\u0002\r\r\bBCBv]\n\u0005\t\u0015!\u0003\u0004f\"Q11\u00048\u0003\u0006\u0004%\ta!(\t\u0015\r5hN!A!\u0002\u0013\u0019)\u0001\u0003\u0006\u0004p:\u0014\t\u0011)A\u0005\u0007cDq!a\ro\t\u0003!\u0019\u0001C\u0005\u0005\f9\u0014\r\u0011\"\u0003\u0005\u000e!AAq\r8!\u0002\u0013!y\u0001C\u0004\u0003|:$\t\u0001\"\u001b\t\u000f\tMh\u000e\"\u0001\u0005n\u00191A1\u0003\u0001\u0005\t+A!b!7z\u0005\u000b\u0007I\u0011\u0001C\f\u0011)!I\"\u001fB\u0001B\u0003%11\u001c\u0005\u000b\t7I(Q1A\u0005\u0002\t]\u0005B\u0003C\u000fs\n\u0005\t\u0015!\u0003\u0002p\"QAqD=\u0003\u0002\u0004%\t\u0001\"\t\t\u0015\u0011\r\u0012P!a\u0001\n\u0003!)\u0003\u0003\u0006\u0005*e\u0014\t\u0011)Q\u0005\u0007oDq!a\rz\t\u0003!Y\u0003C\u0004\u0003tf$\t\u0001b\r\t\u000f\u0011\u001d\u0013\u0010\"\u0003\u0005J!9!1`=\u0005\u0002\u0011\rdA\u0002CI\u0001\u0011!\u0019\nC\u0006\u0002x\u0006-!\u0011!Q\u0001\n\u0005e\b\u0002CA\u001a\u0003\u0017!\t\u0001b'\t\u0011\u0005\u0005\u00161\u0002C!\tCCq\u0001b\b\u0001\t\u0013!Y\u000bC\u0005\u0005^\u0002\t\n\u0011\"\u0003\u0005`\"IA1\u001d\u0001\u0012\u0002\u0013%Aq\u001c\u0002\u001e%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0007>t7-\u001e:sK:\u001c\u0017\u0010V3ti*!\u0011QDA\u0010\u0003\u0019\u0019XM\u001d<fe*\u0011\u0011\u0011E\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001\u0011q\u0005\t\u0005\u0003S\ty#\u0004\u0002\u0002,)\u0011\u0011QF\u0001\u0006g\u000e\fG.Y\u0005\u0005\u0003c\tYC\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005]\u0002cAA\u001d\u00015\u0011\u00111D\u0001\u0005i&lW-\u0006\u0002\u0002@A!\u0011\u0011IA$\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005}\u0011!B;uS2\u001c\u0018\u0002BA%\u0003\u0007\u0012\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\b[\u0016$(/[2t+\t\t\t\u0006\u0005\u0003\u0002T\u0005\u0015TBAA+\u0015\u0011\ti%a\u0016\u000b\t\u0005e\u00131L\u0001\u0007G>lWn\u001c8\u000b\t\u0005\u0005\u0012Q\f\u0006\u0005\u0003?\n\t'\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003G\n1a\u001c:h\u0013\u0011\t9'!\u0016\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%\u0001\u0005fq\u0016\u001cW\u000f^8s+\t\ty\u0007\u0005\u0003\u0002r\u0005}TBAA:\u0015\u0011\t)(a\u001e\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0003\u0002z\u0005m\u0014\u0001B;uS2T!!! \u0002\t)\fg/Y\u0005\u0005\u0003\u0003\u000b\u0019H\u0001\rTG\",G-\u001e7fI\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\f\u0011\"\u001a=fGV$xN\u001d\u0011\u0002\u000bQ\f7o[:\u0016\u0005\u0005%\u0005CBAF\u0003+\u000bI*\u0004\u0002\u0002\u000e*!\u0011qRAI\u0003\u001diW\u000f^1cY\u0016TA!a%\u0002,\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0015Q\u0012\u0002\u0007\u0005V4g-\u001a:\u0011\t\u0005\u0005\u00131T\u0005\u0005\u0003;\u000b\u0019E\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0017A\u0002;bg.\u001c\b%\u0001\u0004tk\nl\u0017\u000e\u001e\u000b\u0005\u0003K\u000bY\u000b\u0005\u0003\u0002*\u0005\u001d\u0016\u0002BAU\u0003W\u0011A!\u00168ji\"9\u0011Q\u0016\u0006A\u0002\u0005e\u0015\u0001\u0002;bg.\fqa\u00197fC:,\b\u000f\u0006\u0002\u0002&\"\u001a1\"!.\u0011\t\u0005]\u0016QY\u0007\u0003\u0003sSA!a/\u0002>\u0006\u0019\u0011\r]5\u000b\t\u0005}\u0016\u0011Y\u0001\bUV\u0004\u0018\u000e^3s\u0015\u0011\t\u0019-!\u0019\u0002\u000b),h.\u001b;\n\t\u0005\u001d\u0017\u0011\u0018\u0002\n\u0003\u001a$XM]#bG\"\f1\u0006^3ti&\u001b(/\u0012=qC:$\u0017I\u001c3TQJLgn[,ji\"\u001cuN\\2veJ,g\u000e\u001e)s_\u0012,8-\u001a\u0015\u0004\u0019\u00055\u0007\u0003BA\\\u0003\u001fLA!!5\u0002:\n!A+Z:u\u0005\u0015\u0019En\\2l'\ri\u0011\u0011\u0014\u000b\u0005\u00033\fi\u000eE\u0002\u0002\\6i\u0011\u0001\u0001\u0005\b\u0003wy\u0001\u0019AA \u0003\u0019!wnV8sW\u0006\u0019\"-^5mIJ+\u0007\u000f\\5dC6\u000bg.Y4feR1\u0011Q]Av\u0003k\u0004B!!\u000f\u0002h&!\u0011\u0011^A\u000e\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDq!!<\u0012\u0001\u0004\ty/A\u0004m_\u000e\fG.\u00133\u0011\t\u0005%\u0012\u0011_\u0005\u0005\u0003g\fYCA\u0002J]RDq!a>\u0012\u0001\u0004\tI0A\u0004dQ\u0006tg.\u001a7\u0011\u0007\u0005m7LA\tD_:$(o\u001c7mKJ\u001c\u0005.\u00198oK2\u001c2aWA\u0014)\t\tI0\u0001\u0006fm\u0016tG/U;fk\u0016,\"A!\u0002\u0011\r\u0005E$q\u0001B\u0006\u0013\u0011\u0011I!a\u001d\u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\u0011\u0007\u0005mGFA\bD_:$(o\u001c7mKJ,e/\u001a8u'\ra\u0013qE\u0015\u0005Y\u0005s\u0003HA\u0007BYR,'/S:s\u000bZ,g\u000e^\n\n\u0003\u0006\u001d\"1\u0002B\f\u0005;\u0001B!!\u000b\u0003\u001a%!!1DA\u0016\u0005\u001d\u0001&o\u001c3vGR\u0004B!!\u000b\u0003 %!!\u0011EA\u0016\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003\u00191W\u000f^;sKV\u0011!q\u0005\t\u0007\u0003c\u0012IC!\f\n\t\t-\u00121\u000f\u0002\u0012\u0007>l\u0007\u000f\\3uC\ndWMR;ukJ,\u0007\u0003\u0002B\u0018\u0005gi!A!\r\u000b\t\u0005m\u0016qD\u0005\u0005\u0005k\u0011\tD\u0001\u0007MK\u0006$WM]!oI&\u001b(/A\u0004gkR,(/\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011!Q\b\t\u0005\u0005\u007f\u0011\t%\u0004\u0002\u0002X%!!1IA,\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\rY\u0016\fG-\u001a:B]\u0012L5O]\u000b\u0003\u0005[\tQ\u0002\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0004C\u0003\u0003B(\u0005#\u0012\u0019F!\u0016\u0011\u0007\u0005m\u0017\tC\u0004\u0003$!\u0003\rAa\n\t\u000f\te\u0002\n1\u0001\u0003>!9!q\t%A\u0002\t5\u0012\u0001B2paf$\u0002Ba\u0014\u0003\\\tu#q\f\u0005\n\u0005GI\u0005\u0013!a\u0001\u0005OA\u0011B!\u000fJ!\u0003\u0005\rA!\u0010\t\u0013\t\u001d\u0013\n%AA\u0002\t5\u0012AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005KRCAa\n\u0003h-\u0012!\u0011\u000e\t\u0005\u0005W\u0012)(\u0004\u0002\u0003n)!!q\u000eB9\u0003%)hn\u00195fG.,GM\u0003\u0003\u0003t\u0005-\u0012AC1o]>$\u0018\r^5p]&!!q\u000fB7\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iH\u000b\u0003\u0003>\t\u001d\u0014AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005\u0007SCA!\f\u0003h\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"A!#\u0011\t\t-%\u0011S\u0007\u0003\u0005\u001bSAAa$\u0002|\u0005!A.\u00198h\u0013\u0011\u0011\u0019J!$\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\ty/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\tu%1\u0015\t\u0005\u0003S\u0011y*\u0003\u0003\u0003\"\u0006-\"aA!os\"I!QU(\u0002\u0002\u0003\u0007\u0011q^\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\t-\u0006C\u0002BW\u0005_\u0013i*\u0004\u0002\u0002\u0012&!!\u0011WAI\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t]&Q\u0018\t\u0005\u0003S\u0011I,\u0003\u0003\u0003<\u0006-\"a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005K\u000b\u0016\u0011!a\u0001\u0005;\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003_\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0005\u0013\u000ba!Z9vC2\u001cH\u0003\u0002B\\\u0005\u0017D\u0011B!*U\u0003\u0003\u0005\rA!(\u0003\u001f%s\u0017\u000e^5bY&TX-\u0012<f]R\u001c\u0012BLA\u0014\u0005\u0017\u00119B!\b\u0015\u0005\tM\u0007cAAn]Q!!Q\u0014Bl\u0011%\u0011)KMA\u0001\u0002\u0004\ty\u000f\u0006\u0003\u00038\nm\u0007\"\u0003BSi\u0005\u0005\t\u0019\u0001BO\u00055\u0019\u0006.\u001e;e_^tWI^3oiNI\u0001(a\n\u0003\f\t]!Q\u0004\u000b\u0003\u0005G\u00042!a79)\u0011\u0011iJa:\t\u0013\t\u0015F(!AA\u0002\u0005=H\u0003\u0002B\\\u0005WD\u0011B!*?\u0003\u0003\u0005\rA!(\u0002\u0017\u00154XM\u001c;Rk\u0016,X\rI\u0001\u0005a>dG\u000e\u0006\u0002\u0003\f\u0005A\u0011\r\u001c;fe&\u001b(\u000f\u0006\u0004\u0003(\t](\u0011 \u0005\b\u0005s\u0001\u0007\u0019\u0001B\u001f\u0011\u001d\u00119\u0005\u0019a\u0001\u0005[\t!\"\u001b8ji&\fG.\u001b>f\u0003!\u0019\b.\u001e;e_^t'\u0001\u0004$fi\u000eDWM]'pI\u0016d7c\u0001\n\u0002\u001a\u0006A1\r\\5f]RLE\r\u0005\u0003\u0004\b\rUa\u0002BB\u0005\u0007#\u0001Baa\u0003\u0002,5\u00111Q\u0002\u0006\u0005\u0007\u001f\t\u0019#\u0001\u0004=e>|GOP\u0005\u0005\u0007'\tY#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005'\u001b9B\u0003\u0003\u0004\u0014\u0005-\u0012\u0002BB\u000e\u00037\u000bAA\\1nK\u0006I!/\u001a9mS\u000e\f\u0017\nZ\u0001\u0011i>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004BAa\u0010\u0004$%!1QEA,\u0005A!v\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|g.\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0015\u0015\r-2QFB\u0018\u0007c\u0019\u0019\u0004E\u0002\u0002\\JAqaa\u0001\u0018\u0001\u0004\u0019)\u0001C\u0004\u0004\u001e]\u0001\r!a<\t\u000f\r}q\u00031\u0001\u0004\"!91qE\fA\u0002\u0005\u0015\u0018A\u0002:b]\u0012|W.\u0006\u0002\u0004:A!11HB \u001b\t\u0019iD\u0003\u0003\u0002z\u0005-\u0012\u0002BB!\u0007{\u0011aAU1oI>l\u0017a\u0002:b]\u0012|W\u000eI\u0001\u000fG2LWM\u001c;NKR\fG-\u0019;b+\t\u0019I\u0005\u0005\u0003\u0004L\r%d\u0002BB'\u0007GrAaa\u0014\u0004`9!1\u0011KB/\u001d\u0011\u0019\u0019fa\u0017\u000f\t\rU3\u0011\f\b\u0005\u0007\u0017\u00199&\u0003\u0002\u0002d%!\u0011qLA1\u0013\u0011\t\t#!\u0018\n\t\u0005e\u00131L\u0005\u0005\u0007C\n9&A\u0004sKBd\u0017nY1\n\t\r\u00154qM\u0001\u000f\u00072LWM\u001c;NKR\fG-\u0019;b\u0015\u0011\u0019\t'a\u0016\n\t\r-4Q\u000e\u0002\u0016\t\u00164\u0017-\u001e7u\u00072LWM\u001c;NKR\fG-\u0019;b\u0015\u0011\u0019)ga\u001a\u0002\u001f\rd\u0017.\u001a8u\u001b\u0016$\u0018\rZ1uC\u0002\n1BZ3uG\"|eMZ:fiV\u00111Q\u000f\t\u0005\u0003S\u00199(\u0003\u0003\u0004z\u0005-\"\u0001\u0002'p]\u001e\fqBZ3uG\"|eMZ:fi~#S-\u001d\u000b\u0005\u0003K\u001by\bC\u0005\u0003&v\t\t\u00111\u0001\u0004v\u0005aa-\u001a;dQ>3gm]3uA\ti\u0001K]8ek\u000e,'/T8eK2\u001c2\u0001IAM)!\u0019Iia#\u0004\u000e\u000e=\u0005cAAnA!911\u0001\u0013A\u0002\r\u0015\u0001b\u0002B\u001dI\u0001\u0007!Q\b\u0005\b\u0007O!\u0003\u0019AAs\u0003!\u0019X-];f]\u000e,\u0017\u0001D:fcV,gnY3`I\u0015\fH\u0003BAS\u0007/C\u0011B!*)\u0003\u0003\u0005\r!a<\u0002\u0013M,\u0017/^3oG\u0016\u0004\u0013AC:va\u0016\u0014HE\\1nKV\u00111QA\u0001\u0010\u0013:LG/[1mSj,WI^3oi\u0006i1\u000b[;uI><h.\u0012<f]R\fQ\"\u00117uKJL5O]#wK:$\bcAAn-N)ak!+\u0003\u001eAa11VBY\u0005O\u0011iD!\f\u0003P5\u00111Q\u0016\u0006\u0005\u0007_\u000bY#A\u0004sk:$\u0018.\\3\n\t\rM6Q\u0016\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u001cDCABS\u0003\u0015\t\u0007\u000f\u001d7z)!\u0011yea/\u0004>\u000e}\u0006b\u0002B\u00123\u0002\u0007!q\u0005\u0005\b\u0005sI\u0006\u0019\u0001B\u001f\u0011\u001d\u00119%\u0017a\u0001\u0005[\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0004F\u000eE\u0007CBA\u0015\u0007\u000f\u001cY-\u0003\u0003\u0004J\u0006-\"AB(qi&|g\u000e\u0005\u0006\u0002*\r5'q\u0005B\u001f\u0005[IAaa4\u0002,\t1A+\u001e9mKNB\u0011ba5[\u0003\u0003\u0005\rAa\u0014\u0002\u0007a$\u0003GA\bD_:$(o\u001c7mKJlu\u000eZ3m'\r\u0019\u0017\u0011T\u0001\u0006i>\u0004\u0018n\u0019\t\u0004\u00037t'A\u0003+pa&\u001cWj\u001c3fYN\u0019a.a\n\u0002\u000fQ|\u0007/[2JIV\u00111Q\u001d\t\u0005\u0005\u007f\u00199/\u0003\u0003\u0004j\u0006]#\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\u0006]\u0006lW\rI\u0001\u0015S:LG/[1m%\u0016<\u0017n\u001d;sCRLwN\\:\u0011\u0011\r\u001d11_Ax\u0007oLAa!>\u0004\u0018\t\u0019Q*\u00199\u0011\t\re8q`\u0007\u0003\u0007wTAa!@\u0002\\\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0005\u0002\rm(!\u0006)beRLG/[8o%\u0016<\u0017n\u001d;sCRLwN\u001c\u000b\t\u00077$)\u0001b\u0002\u0005\n!91\u0011\u001d;A\u0002\r\u0015\bbBB\u000ei\u0002\u00071Q\u0001\u0005\b\u0007_$\b\u0019ABy\u0003)\u0001\u0018M\u001d;ji&|gn]\u000b\u0003\t\u001f\u0001\u0002ba\u0002\u0004t\u0006=H\u0011\u0003\t\u0004\u00037L(A\u0004)beRLG/[8o\u001b>$W\r\\\n\u0004s\u0006\u001dRCABn\u0003\u0019!x\u000e]5dA\u0005Y\u0001/\u0019:uSRLwN\\%e\u00031\u0001\u0018M\u001d;ji&|g.\u00133!\u00031\u0011XmZ5tiJ\fG/[8o+\t\u001990\u0001\tsK\u001eL7\u000f\u001e:bi&|gn\u0018\u0013fcR!\u0011Q\u0015C\u0014\u0011%\u0011)k`A\u0001\u0002\u0004\u001990A\u0007sK\u001eL7\u000f\u001e:bi&|g\u000e\t\u000b\t\t#!i\u0003b\f\u00052!A1\u0011\\A\u0002\u0001\u0004\u0019Y\u000e\u0003\u0005\u0005\u001c\u0005\r\u0001\u0019AAx\u0011!!y\"a\u0001A\u0002\r]HC\u0002B\u0017\tk!9\u0004\u0003\u0005\u0003H\u0005\u0015\u0001\u0019\u0001B\u0017\u0011!!I$!\u0002A\u0002\u0011m\u0012!\u00023fYR\f\u0007\u0003\u0002C\u001f\t\u0007j!\u0001b\u0010\u000b\t\u0011\u0005\u00131L\u0001\u0006S6\fw-Z\u0005\u0005\t\u000b\"yDA\u0007NKR\fG-\u0019;b\t\u0016dG/Y\u0001\u0007i>d\u0015n\u001d;\u0015\t\u0011-C\u0011\f\t\u0007\t\u001b\"y\u0005b\u0015\u000e\u0005\u0005]\u0014\u0002\u0002C)\u0003o\u0012A\u0001T5tiB!!1\u0012C+\u0013\u0011!9F!$\u0003\u000f%sG/Z4fe\"AA1LA\u0004\u0001\u0004!i&\u0001\u0003j]R\u001c\bCBA\u0015\t?\ny/\u0003\u0003\u0005b\u0005-\"!B!se\u0006LH\u0003BAS\tKB\u0001\u0002\"\u000f\u0002\n\u0001\u0007A1H\u0001\fa\u0006\u0014H/\u001b;j_:\u001c\b\u0005\u0006\u0003\u0002&\u0012-\u0004b\u0002C\u001do\u0002\u0007A1\b\u000b\t\u0005[!y\u0007\"\u001d\u0005t!9!\u0011\b=A\u0002\tu\u0002b\u0002B$q\u0002\u0007!Q\u0006\u0005\b\tsA\b\u0019\u0001C\u001e)!!9\b\"\u001f\u0005|\u0011u\u0004cAAnG\"91\u0011\\4A\u0002\rm\u0007bBA|O\u0002\u0007\u0011\u0011 \u0005\b\u0007O9\u0007\u0019AAs\u0003-a\u0017\r^3ti&k\u0017mZ3\u0016\u0005\u0011\r\u0005\u0003\u0002C\u001f\t\u000bKA\u0001b\"\u0005@\tiQ*\u001a;bI\u0006$\u0018-S7bO\u0016\fq\u0002\\1uKN$\u0018*\\1hK~#S-\u001d\u000b\u0005\u0003K#i\tC\u0005\u0003&&\f\t\u00111\u0001\u0005\u0004\u0006aA.\u0019;fgRLU.Y4fA\t\u0019Rj\\2l\u00032$XM]%te6\u000bg.Y4feN1\u00111BA\u0014\t+\u0003B!!\u000f\u0005\u0018&!A\u0011TA\u000e\u0005=\tE\u000e^3s\u0013N\u0014X*\u00198bO\u0016\u0014H\u0003\u0002CO\t?\u0003B!a7\u0002\f!A\u0011q_A\b\u0001\u0004\tI\u0010\u0006\u0005\u0003(\u0011\rFQ\u0015CT\u0011!\u0011I$!\u0005A\u0002\tu\u0002\u0002\u0003B$\u0003#\u0001\rA!\f\t\u0011\u0011%\u0016\u0011\u0003a\u0001\u0003_\fqbY8oiJ|G\u000e\\3s\u000bB|7\r\u001b\u000b\u000f\u0007o$i\u000bb1\u0005H\u0012-GQ\u001bCm\u0011!!y+a\u0005A\u0002\u0011E\u0016A\u0003:fa2L7-Y%egB1A1\u0017C_\u0003_tA\u0001\".\u0005::!11\u0002C\\\u0013\t\ti#\u0003\u0003\u0005<\u0006-\u0012a\u00029bG.\fw-Z\u0005\u0005\t\u007f#\tMA\u0002TKFTA\u0001b/\u0002,!AAQYA\n\u0001\u0004!\t,A\u0002jgJD\u0001\u0002\"3\u0002\u0014\u0001\u0007\u0011q^\u0001\u0007Y\u0016\fG-\u001a:\t\u0011\u00115\u00171\u0003a\u0001\t\u001f\f1\u0003\\3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018p\u0015;bi\u0016\u0004Ba!?\u0005R&!A1[B~\u0005MaU-\u00193feJ+7m\u001c<fef\u001cF/\u0019;f\u0011)!9.a\u0005\u0011\u0002\u0003\u0007\u0011q^\u0001\fY\u0016\fG-\u001a:Fa>\u001c\u0007\u000e\u0003\u0006\u0005\\\u0006M\u0001\u0013!a\u0001\u0003_\fa\u0002]1si&$\u0018n\u001c8Fa>\u001c\u0007.\u0001\fsK\u001eL7\u000f\u001e:bi&|g\u000e\n3fM\u0006,H\u000e\u001e\u00136+\t!\tO\u000b\u0003\u0002p\n\u001d\u0014A\u0006:fO&\u001cHO]1uS>tG\u0005Z3gCVdG\u000f\n\u001c")
public class ReplicaManagerConcurrencyTest {
    private volatile ReplicaManagerConcurrencyTest$InitializeEvent$ InitializeEvent$module;
    private volatile ReplicaManagerConcurrencyTest$ShutdownEvent$ ShutdownEvent$module;
    private volatile ReplicaManagerConcurrencyTest$AlterIsrEvent$ AlterIsrEvent$module;
    private final MockTime kafka$server$ReplicaManagerConcurrencyTest$$time = new MockTime();
    private final Metrics kafka$server$ReplicaManagerConcurrencyTest$$metrics = new Metrics();
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(8);
    private final Buffer<ShutdownableThread> tasks = (Buffer)Buffer$.MODULE$.empty();

    public ReplicaManagerConcurrencyTest$InitializeEvent$ InitializeEvent() {
        if (this.InitializeEvent$module == null) {
            this.InitializeEvent$lzycompute$1();
        }
        return this.InitializeEvent$module;
    }

    public ReplicaManagerConcurrencyTest$ShutdownEvent$ ShutdownEvent() {
        if (this.ShutdownEvent$module == null) {
            this.ShutdownEvent$lzycompute$1();
        }
        return this.ShutdownEvent$module;
    }

    public ReplicaManagerConcurrencyTest$AlterIsrEvent$ AlterIsrEvent() {
        if (this.AlterIsrEvent$module == null) {
            this.AlterIsrEvent$lzycompute$1();
        }
        return this.AlterIsrEvent$module;
    }

    public MockTime kafka$server$ReplicaManagerConcurrencyTest$$time() {
        return this.kafka$server$ReplicaManagerConcurrencyTest$$time;
    }

    public Metrics kafka$server$ReplicaManagerConcurrencyTest$$metrics() {
        return this.kafka$server$ReplicaManagerConcurrencyTest$$metrics;
    }

    private ScheduledExecutorService executor() {
        return this.executor;
    }

    private Buffer<ShutdownableThread> tasks() {
        return this.tasks;
    }

    private void submit(ShutdownableThread task) {
        this.tasks().$plus$eq((Object)task);
        this.executor().submit((Runnable)task);
    }

    @AfterEach
    public void cleanup() {
        this.tasks().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        this.executor().shutdownNow();
        this.executor().awaitTermination(5L, TimeUnit.SECONDS);
        this.kafka$server$ReplicaManagerConcurrencyTest$$metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsrExpandAndShrinkWithConcurrentProduce() {
        int localId = 0;
        int remoteId = 1;
        ControllerChannel channel = new ControllerChannel();
        ReplicaManager replicaManager = this.buildReplicaManager(localId, channel);
        PartitionRegistration initialPartitionRegistration = this.registration((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{localId, remoteId}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{localId}))), localId, LeaderRecoveryState.RECOVERED, this.registration$default$5(), this.registration$default$6());
        TopicModel topicModel = new TopicModel(this, Uuid.randomUuid(), "foo", (scala.collection.immutable.Map<Object, PartitionRegistration>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)initialPartitionRegistration)}))));
        TopicPartition topicPartition = new TopicPartition(topicModel.name(), 0);
        TopicIdPartition topicIdPartition = new TopicIdPartition(topicModel.topicId(), topicPartition);
        ControllerModel controller = new ControllerModel(this, topicModel, channel, replicaManager);
        this.submit(new Clock(this, this.kafka$server$ReplicaManagerConcurrencyTest$$time()));
        replicaManager.startup();
        this.submit(controller);
        controller.initialize();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$1(replicaManager, topicPartition)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Partition partition = replicaManager.getPartitionOrException(topicPartition);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.submit(new ProducerModel(this, new StringBuilder(9).append("producer-").append(i).toString(), topicPartition, replicaManager)));
        FetcherModel fetcher = new FetcherModel(this, new StringBuilder(8).append("replica-").append(remoteId).toString(), remoteId, topicIdPartition, replicaManager);
        this.submit(fetcher);
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$4(partition, localId, remoteId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$5());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        fetcher.shutdown();
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$6(partition, localId)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)ReplicaManagerConcurrencyTest.$anonfun$testIsrExpandAndShrinkWithConcurrentProduce$7());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    private ReplicaManager buildReplicaManager(int localId, ControllerChannel channel) {
        File logDir = TestUtils$.MODULE$.tempDir();
        Properties props = new Properties();
        props.put(KafkaConfig$.MODULE$.QuorumVotersProp(), "100@localhost:12345");
        props.put(KafkaConfig$.MODULE$.ProcessRolesProp(), "broker");
        props.put(KafkaConfig$.MODULE$.NodeIdProp(), Integer.toString(localId));
        props.put(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "SSL");
        props.put(KafkaConfig$.MODULE$.LogDirProp(), logDir.getAbsolutePath());
        props.put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), Integer.toString(5000));
        KafkaConfig config = new KafkaConfig((java.util.Map)props, false);
        LogConfig x$1 = new LogConfig((java.util.Map)new Properties(), LogConfig$.MODULE$.$lessinit$greater$default$2());
        MockConfigRepository x$2 = new MockConfigRepository();
        .colon.colon x$3 = new .colon.colon((Object)logDir, (List)Nil$.MODULE$);
        MockTime x$4 = this.kafka$server$ReplicaManagerConcurrencyTest$$time();
        CleanerConfig x$5 = TestUtils$.MODULE$.createLogManager$default$4();
        ApiVersion x$6 = TestUtils$.MODULE$.createLogManager$default$6();
        LogManager logManager = TestUtils$.MODULE$.createLogManager((Seq<File>)x$3, x$1, x$2, x$5, x$4, x$6);
        return new ReplicaManager(this, config, logManager, channel){

            public ReplicaFetcherManager createReplicaFetcherManager(Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
                return (ReplicaFetcherManager)Mockito.mock(ReplicaFetcherManager.class);
            }
            {
                Metrics x$1 = $outer.kafka$server$ReplicaManagerConcurrencyTest$$metrics();
                MockTime x$3 = $outer.kafka$server$ReplicaManagerConcurrencyTest$$time();
                MockScheduler x$4 = $outer.kafka$server$ReplicaManagerConcurrencyTest$$time().scheduler();
                QuotaFactory.QuotaManagers x$6 = QuotaFactory$.MODULE$.instantiate(config$1, $outer.kafka$server$ReplicaManagerConcurrencyTest$$metrics(), (Time)$outer.kafka$server$ReplicaManagerConcurrencyTest$$time(), "");
                KRaftMetadataCache x$7 = MetadataCache$.MODULE$.kRaftMetadataCache(config$1.brokerId());
                LogDirFailureChannel x$8 = new LogDirFailureChannel(config$1.logDirs().size());
                MockAlterIsrManager x$9 = new MockAlterIsrManager($outer, channel$1);
                BrokerTopicStats x$10 = ReplicaManager$.MODULE$.$lessinit$greater$default$10();
                AtomicBoolean x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
                Option x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
                Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
                Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
                Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
                Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
                Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
                super(config$1, x$1, (Time)x$3, (Scheduler)x$4, logManager$1, x$6, (MetadataCache)x$7, x$8, (AlterIsrManager)x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17);
            }
        };
    }

    private PartitionRegistration registration(Seq<Object> replicaIds, Seq<Object> isr, int leader, LeaderRecoveryState leaderRecoveryState, int leaderEpoch, int partitionEpoch) {
        return new PartitionRegistration((int[])replicaIds.toArray(ClassTag$.MODULE$.Int()), (int[])isr.toArray(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int()), leader, leaderRecoveryState, leaderEpoch, partitionEpoch);
    }

    private int registration$default$5() {
        return 0;
    }

    private int registration$default$6() {
        return 0;
    }

    private final void InitializeEvent$lzycompute$1() {
        synchronized (this) {
            if (this.InitializeEvent$module == null) {
                this.InitializeEvent$module = new ReplicaManagerConcurrencyTest$InitializeEvent$(this);
            }
            return;
        }
    }

    private final void ShutdownEvent$lzycompute$1() {
        synchronized (this) {
            if (this.ShutdownEvent$module == null) {
                this.ShutdownEvent$module = new ReplicaManagerConcurrencyTest$ShutdownEvent$(this);
            }
            return;
        }
    }

    private final void AlterIsrEvent$lzycompute$1() {
        synchronized (this) {
            if (this.AlterIsrEvent$module == null) {
                this.AlterIsrEvent$module = new ReplicaManagerConcurrencyTest$AlterIsrEvent$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$1(ReplicaManager replicaManager$1, TopicPartition topicPartition$1) {
        HostedPartition hostedPartition = replicaManager$1.getPartition(topicPartition$1);
        boolean bl = hostedPartition instanceof HostedPartition.Online ? ((HostedPartition.Online)hostedPartition).partition().isLeader() : false;
        return bl;
    }

    public static final /* synthetic */ String $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$2() {
        return "Timed out waiting for partition to initialize";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$4(Partition partition$1, int localId$1, int remoteId$1) {
        Set set = partition$1.inSyncReplicaIds();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{localId$1, remoteId$1}));
        return !(set != null ? !set.equals(genTraversable) : genTraversable != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$5() {
        return "Test timed out before ISR was expanded";
    }

    public static final /* synthetic */ boolean $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$6(Partition partition$1, int localId$1) {
        Set set = partition$1.inSyncReplicaIds();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{localId$1}));
        return !(set != null ? !set.equals(genTraversable) : genTraversable != null);
    }

    public static final /* synthetic */ String $anonfun$testIsrExpandAndShrinkWithConcurrentProduce$7() {
        return "Test timed out before ISR was shrunk";
    }

    public class AlterIsrEvent
    implements ControllerEvent,
    Product,
    scala.Serializable {
        private final CompletableFuture<LeaderAndIsr> future;
        private final TopicPartition topicPartition;
        private final LeaderAndIsr leaderAndIsr;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public CompletableFuture<LeaderAndIsr> future() {
            return this.future;
        }

        public TopicPartition topicPartition() {
            return this.topicPartition;
        }

        public LeaderAndIsr leaderAndIsr() {
            return this.leaderAndIsr;
        }

        public AlterIsrEvent copy(CompletableFuture<LeaderAndIsr> future, TopicPartition topicPartition, LeaderAndIsr leaderAndIsr) {
            return new AlterIsrEvent(this.kafka$server$ReplicaManagerConcurrencyTest$AlterIsrEvent$$$outer(), future, topicPartition, leaderAndIsr);
        }

        public CompletableFuture<LeaderAndIsr> copy$default$1() {
            return this.future();
        }

        public TopicPartition copy$default$2() {
            return this.topicPartition();
        }

        public LeaderAndIsr copy$default$3() {
            return this.leaderAndIsr();
        }

        public String productPrefix() {
            return "AlterIsrEvent";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.future();
                }
                case 1: {
                    return this.topicPartition();
                }
                case 2: {
                    return this.leaderAndIsr();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AlterIsrEvent;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof AlterIsrEvent)) return false;
            if (((AlterIsrEvent)x$1).kafka$server$ReplicaManagerConcurrencyTest$AlterIsrEvent$$$outer() != this.kafka$server$ReplicaManagerConcurrencyTest$AlterIsrEvent$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AlterIsrEvent alterIsrEvent = (AlterIsrEvent)x$1;
            CompletableFuture<LeaderAndIsr> completableFuture = this.future();
            CompletableFuture<LeaderAndIsr> completableFuture2 = alterIsrEvent.future();
            if (completableFuture == null) {
                if (completableFuture2 != null) {
                    return false;
                }
            } else if (!completableFuture.equals(completableFuture2)) return false;
            TopicPartition topicPartition = this.topicPartition();
            TopicPartition topicPartition2 = alterIsrEvent.topicPartition();
            if (topicPartition == null) {
                if (topicPartition2 != null) {
                    return false;
                }
            } else if (!topicPartition.equals(topicPartition2)) return false;
            LeaderAndIsr leaderAndIsr = this.leaderAndIsr();
            LeaderAndIsr leaderAndIsr2 = alterIsrEvent.leaderAndIsr();
            if (leaderAndIsr == null) {
                if (leaderAndIsr2 != null) {
                    return false;
                }
            } else if (!leaderAndIsr.equals(leaderAndIsr2)) return false;
            if (!alterIsrEvent.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$AlterIsrEvent$$$outer() {
            return this.$outer;
        }

        public AlterIsrEvent(ReplicaManagerConcurrencyTest $outer, CompletableFuture<LeaderAndIsr> future, TopicPartition topicPartition, LeaderAndIsr leaderAndIsr) {
            this.future = future;
            this.topicPartition = topicPartition;
            this.leaderAndIsr = leaderAndIsr;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    private class Clock
    extends ShutdownableThread {
        private final MockTime time;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public void doWork() {
            this.time.sleep(1L);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$Clock$$$outer() {
            return this.$outer;
        }

        public Clock(ReplicaManagerConcurrencyTest $outer, MockTime time) {
            this.time = time;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("clock", false);
        }
    }

    private class ControllerChannel {
        private final LinkedBlockingQueue<ControllerEvent> eventQueue;

        private LinkedBlockingQueue<ControllerEvent> eventQueue() {
            return this.eventQueue;
        }

        public ControllerEvent poll() {
            return this.eventQueue().take();
        }

        /*
         * WARNING - void declaration
         */
        public CompletableFuture<LeaderAndIsr> alterIsr(TopicPartition topicPartition, LeaderAndIsr leaderAndIsr) {
            void var3_3;
            CompletableFuture<LeaderAndIsr> future = new CompletableFuture<LeaderAndIsr>();
            this.eventQueue().offer(new AlterIsrEvent(this.kafka$server$ReplicaManagerConcurrencyTest$ControllerChannel$$$outer(), future, topicPartition, leaderAndIsr));
            return var3_3;
        }

        public void initialize() {
            this.eventQueue().offer(this.kafka$server$ReplicaManagerConcurrencyTest$ControllerChannel$$$outer().InitializeEvent());
        }

        public void shutdown() {
            this.eventQueue().offer(this.kafka$server$ReplicaManagerConcurrencyTest$ControllerChannel$$$outer().ShutdownEvent());
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$ControllerChannel$$$outer() {
            return ReplicaManagerConcurrencyTest.this;
        }

        public ControllerChannel() {
            if (ReplicaManagerConcurrencyTest.this == null) {
                throw null;
            }
            this.eventQueue = new LinkedBlockingQueue();
        }
    }

    public interface ControllerEvent {
    }

    private class ControllerModel
    extends ShutdownableThread {
        private final TopicModel topic;
        private final ControllerChannel channel;
        private final ReplicaManager replicaManager;
        private MetadataImage latestImage;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        private MetadataImage latestImage() {
            return this.latestImage;
        }

        private void latestImage_$eq(MetadataImage x$1) {
            this.latestImage = x$1;
        }

        public void initialize() {
            this.channel.initialize();
        }

        public void shutdown() {
            super.initiateShutdown();
            this.channel.shutdown();
            super.awaitShutdown();
        }

        public void doWork() {
            ControllerEvent controllerEvent = this.channel.poll();
            if (this.kafka$server$ReplicaManagerConcurrencyTest$ControllerModel$$$outer().InitializeEvent().equals(controllerEvent)) {
                MetadataDelta delta = new MetadataDelta(this.latestImage());
                this.topic.initialize(delta);
                this.latestImage_$eq(delta.apply());
                this.replicaManager.applyDelta(delta.topicsDelta(), this.latestImage());
                return;
            }
            if (controllerEvent instanceof AlterIsrEvent) {
                AlterIsrEvent alterIsrEvent = (AlterIsrEvent)controllerEvent;
                CompletableFuture<LeaderAndIsr> future = alterIsrEvent.future();
                TopicPartition topicPartition = alterIsrEvent.topicPartition();
                LeaderAndIsr leaderAndIsr = alterIsrEvent.leaderAndIsr();
                MetadataDelta delta = new MetadataDelta(this.latestImage());
                LeaderAndIsr updatedLeaderAndIsr = this.topic.alterIsr(topicPartition, leaderAndIsr, delta);
                this.latestImage_$eq(delta.apply());
                future.complete(updatedLeaderAndIsr);
                this.replicaManager.applyDelta(delta.topicsDelta(), this.latestImage());
                return;
            }
            if (this.kafka$server$ReplicaManagerConcurrencyTest$ControllerModel$$$outer().ShutdownEvent().equals(controllerEvent)) {
                return;
            }
            throw new MatchError((Object)controllerEvent);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$ControllerModel$$$outer() {
            return this.$outer;
        }

        public ControllerModel(ReplicaManagerConcurrencyTest $outer, TopicModel topic, ControllerChannel channel, ReplicaManager replicaManager) {
            this.topic = topic;
            this.channel = channel;
            this.replicaManager = replicaManager;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("controller", false);
            this.latestImage = MetadataImage.EMPTY;
        }
    }

    private class FetcherModel
    extends ShutdownableThread {
        private final int replicaId;
        private final TopicIdPartition topicIdPartition;
        private final ReplicaManager replicaManager;
        private final Random random;
        private final ClientMetadata.DefaultClientMetadata clientMetadata;
        private long fetchOffset;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        private Random random() {
            return this.random;
        }

        private ClientMetadata.DefaultClientMetadata clientMetadata() {
            return this.clientMetadata;
        }

        private long fetchOffset() {
            return this.fetchOffset;
        }

        private void fetchOffset_$eq(long x$1) {
            this.fetchOffset = x$1;
        }

        public void doWork() {
            FetchRequest.PartitionData partitionData = new FetchRequest.PartitionData(this.topicIdPartition.topicId(), this.fetchOffset(), -1L, 65536, Optional.empty(), Optional.empty());
            CompletableFuture future = new CompletableFuture();
            this.replicaManager.fetchMessages((long)this.random().nextInt(100), this.replicaId, 1, 0x100000, false, (Seq)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition), (Object)partitionData), (List)Nil$.MODULE$), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$, (Function1 & Serializable & scala.Serializable)results -> {
                this.fetchCallback$1(results, future);
                return BoxedUnit.UNIT;
            }, IsolationLevel.READ_UNCOMMITTED, (Option)new Some((Object)this.clientMetadata()));
            ((FetchPartitionData)future.get()).records().batches().forEach(batch -> this.fetchOffset_$eq(batch.lastOffset() + 1L));
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$FetcherModel$$$outer() {
            return this.$outer;
        }

        /*
         * WARNING - void declaration
         */
        private final void fetchCallback$1(Seq results, CompletableFuture future$1) {
            try {
                void var5_5;
                void var4_4;
                Assertions.assertEquals((int)1, (int)results.size());
                Tuple2 tuple2 = (Tuple2)results.head();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                TopicIdPartition topicIdPartition = (TopicIdPartition)tuple2._1();
                FetchPartitionData result = (FetchPartitionData)tuple2._2();
                void topicIdPartition2 = var4_4;
                void result2 = var5_5;
                Assertions.assertEquals((Object)this.topicIdPartition, (Object)topicIdPartition2);
                Assertions.assertEquals((Object)Errors.NONE, (Object)result2.error());
                future$1.complete(result2);
                return;
            }
            catch (Throwable e) {
                future$1.completeExceptionally(e);
                return;
            }
        }

        public FetcherModel(ReplicaManagerConcurrencyTest $outer, String clientId, int replicaId, TopicIdPartition topicIdPartition, ReplicaManager replicaManager) {
            this.replicaId = replicaId;
            this.topicIdPartition = topicIdPartition;
            this.replicaManager = replicaManager;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(clientId, false);
            this.random = new Random();
            this.clientMetadata = new ClientMetadata.DefaultClientMetadata("", super.name(), InetAddress.getLocalHost(), KafkaPrincipal.ANONYMOUS, "PLAINTEXT");
            this.fetchOffset = 0L;
        }
    }

    private class MockAlterIsrManager
    implements AlterIsrManager {
        private final ControllerChannel channel;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public void start() {
            AlterIsrManager.start$((AlterIsrManager)this);
        }

        public void shutdown() {
            AlterIsrManager.shutdown$((AlterIsrManager)this);
        }

        public CompletableFuture<LeaderAndIsr> submit(TopicPartition topicPartition, LeaderAndIsr leaderAndIsr, int controllerEpoch) {
            return this.channel.alterIsr(topicPartition, leaderAndIsr);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$MockAlterIsrManager$$$outer() {
            return this.$outer;
        }

        public MockAlterIsrManager(ReplicaManagerConcurrencyTest $outer, ControllerChannel channel) {
            this.channel = channel;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            AlterIsrManager.$init$((AlterIsrManager)this);
        }
    }

    private class PartitionModel {
        private final TopicModel topic;
        private final int partitionId;
        private PartitionRegistration registration;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public TopicModel topic() {
            return this.topic;
        }

        public int partitionId() {
            return this.partitionId;
        }

        public PartitionRegistration registration() {
            return this.registration;
        }

        public void registration_$eq(PartitionRegistration x$1) {
            this.registration = x$1;
        }

        public LeaderAndIsr alterIsr(LeaderAndIsr leaderAndIsr, MetadataDelta delta) {
            delta.replay(new PartitionChangeRecord().setTopicId(this.topic().topicId()).setPartitionId(this.partitionId()).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)leaderAndIsr.isr().map((Function1 & Serializable & scala.Serializable)x -> PartitionModel.$anonfun$alterIsr$2(BoxesRunTime.unboxToInt((Object)x)), List$.MODULE$.canBuildFrom())).asJava()).setLeader(leaderAndIsr.leader()));
            this.registration_$eq((PartitionRegistration)delta.topicsDelta().changedTopic(this.topic().topicId()).partitionChanges().get(BoxesRunTime.boxToInteger((int)this.partitionId())));
            return leaderAndIsr.withZkVersion(this.registration().partitionEpoch);
        }

        private java.util.List<Integer> toList(int[] ints) {
            return (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(ints)).map((Function1 & Serializable & scala.Serializable)x -> PartitionModel.$anonfun$toList$1(BoxesRunTime.unboxToInt((Object)x)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Integer.class))))).toList()).asJava();
        }

        public void initialize(MetadataDelta delta) {
            delta.replay(new PartitionRecord().setTopicId(this.topic().topicId()).setPartitionId(this.partitionId()).setReplicas(this.toList(this.registration().replicas)).setIsr(this.toList(this.registration().isr)).setLeader(this.registration().leader).setLeaderEpoch(this.registration().leaderEpoch).setPartitionEpoch(this.registration().partitionEpoch));
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$PartitionModel$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ Integer $anonfun$alterIsr$2(int x) {
            return BoxesRunTime.boxToInteger((int)x);
        }

        public static final /* synthetic */ Integer $anonfun$toList$1(int x) {
            return BoxesRunTime.boxToInteger((int)x);
        }

        public PartitionModel(ReplicaManagerConcurrencyTest $outer, TopicModel topic, int partitionId, PartitionRegistration registration) {
            this.topic = topic;
            this.partitionId = partitionId;
            this.registration = registration;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }

    private class ProducerModel
    extends ShutdownableThread {
        private final TopicPartition topicPartition;
        private final ReplicaManager replicaManager;
        private final Random random;
        private int sequence;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        private /* synthetic */ String super$name() {
            return super.name();
        }

        private Random random() {
            return this.random;
        }

        private int sequence() {
            return this.sequence;
        }

        private void sequence_$eq(int x$1) {
            this.sequence = x$1;
        }

        public void doWork() {
            int numRecords = this.random().nextInt() % 10 + 1;
            IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable & scala.Serializable)i -> ProducerModel.$anonfun$doWork$3(this, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            CompletableFuture future = new CompletableFuture();
            this.replicaManager.appendRecords(30000L, (short)-1, false, (AppendOrigin)AppendOrigin.Client$.MODULE$, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition), (Object)TestUtils$.MODULE$.records((Iterable<SimpleRecord>)records, TestUtils$.MODULE$.records$default$2(), TestUtils$.MODULE$.records$default$3(), TestUtils$.MODULE$.records$default$4(), TestUtils$.MODULE$.records$default$5(), TestUtils$.MODULE$.records$default$6(), TestUtils$.MODULE$.records$default$7(), TestUtils$.MODULE$.records$default$8()))})), (Function1 & Serializable & scala.Serializable)results -> {
                this.produceCallback$1(results, future);
                return BoxedUnit.UNIT;
            }, this.replicaManager.appendRecords$default$7(), this.replicaManager.appendRecords$default$8(), this.replicaManager.appendRecords$default$9());
            future.get();
            this.sequence_$eq(this.sequence() + numRecords);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$ProducerModel$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ SimpleRecord $anonfun$doWork$3(ProducerModel $this, int i) {
            return new SimpleRecord(new StringBuilder(1).append($this.super$name()).append("-").append($this.sequence() + i).toString().getBytes());
        }

        /*
         * WARNING - void declaration
         */
        private final void produceCallback$1(Map results, CompletableFuture future$2) {
            try {
                void var5_5;
                void var4_4;
                Assertions.assertEquals((int)1, (int)results.size());
                Tuple2 tuple2 = (Tuple2)results.head();
                if (tuple2 == null) {
                    throw new MatchError(null);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                ProduceResponse.PartitionResponse result = (ProduceResponse.PartitionResponse)tuple2._2();
                void topicPartition2 = var4_4;
                void result2 = var5_5;
                Assertions.assertEquals((Object)this.topicPartition, (Object)topicPartition2);
                Assertions.assertEquals((Object)Errors.NONE, (Object)result2.error);
                future$2.complete(result2);
                return;
            }
            catch (Throwable e) {
                future$2.completeExceptionally(e);
                return;
            }
        }

        public ProducerModel(ReplicaManagerConcurrencyTest $outer, String clientId, TopicPartition topicPartition, ReplicaManager replicaManager) {
            this.topicPartition = topicPartition;
            this.replicaManager = replicaManager;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(clientId, false);
            this.random = new Random();
            this.sequence = 0;
        }
    }

    private class TopicModel {
        private final Uuid topicId;
        private final String name;
        private final scala.collection.immutable.Map<Object, PartitionModel> partitions;
        public final /* synthetic */ ReplicaManagerConcurrencyTest $outer;

        public Uuid topicId() {
            return this.topicId;
        }

        public String name() {
            return this.name;
        }

        private scala.collection.immutable.Map<Object, PartitionModel> partitions() {
            return this.partitions;
        }

        public void initialize(MetadataDelta delta) {
            delta.replay(new TopicRecord().setName(this.name()).setTopicId(this.topicId()));
            this.partitions().values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.initialize(delta);
                return BoxedUnit.UNIT;
            });
        }

        public LeaderAndIsr alterIsr(TopicPartition topicPartition, LeaderAndIsr leaderAndIsr, MetadataDelta delta) {
            return ((PartitionModel)this.partitions().getOrElse((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Function0 & Serializable & scala.Serializable)() -> {
                throw new IllegalStateException(new StringBuilder(21).append("Unexpected partition ").append(topicPartition).toString());
            })).alterIsr(leaderAndIsr, delta);
        }

        public /* synthetic */ ReplicaManagerConcurrencyTest kafka$server$ReplicaManagerConcurrencyTest$TopicModel$$$outer() {
            return this.$outer;
        }

        public TopicModel(ReplicaManagerConcurrencyTest $outer, Uuid topicId, String name, scala.collection.immutable.Map<Object, PartitionRegistration> initialRegistrations) {
            this.topicId = topicId;
            this.name = name;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.partitions = (scala.collection.immutable.Map)initialRegistrations.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                if (x0$1 == null) {
                    throw new MatchError(null);
                }
                int partitionId = x0$1._1$mcI$sp();
                PartitionRegistration registration = (PartitionRegistration)x0$1._2();
                Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partitionId)), (Object)new PartitionModel(this.kafka$server$ReplicaManagerConcurrencyTest$TopicModel$$$outer(), this, partitionId, registration));
                return tuple2;
            }, scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        }
    }
}

