/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.log.LogOffsetSnapshot;
import kafka.log.UnifiedLog;
import kafka.server.AlterIsrManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedFetch;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.FetchHighWatermark$;
import kafka.server.FetchIsolation;
import kafka.server.FetchLogEnd$;
import kafka.server.FetchMetadata;
import kafka.server.FetchPartitionStatus;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.AdditionalMatchers;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tma\u0001\u0002\u0016,\u0001ABQa\u000e\u0001\u0005\u0002aBqa\u000f\u0001C\u0002\u0013\u0005A\b\u0003\u0004G\u0001\u0001\u0006I!\u0010\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0011\u0019y\u0005\u0001)A\u0005\u0013\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u00020\u0001A\u0003%!\u000bC\u0004`\u0001\t\u0007I\u0011\u00011\t\r\u0019\u0004\u0001\u0015!\u0003b\u0011\u001d9\u0007A1A\u0005\u0002!Da!\u001c\u0001!\u0002\u0013I\u0007b\u00028\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007_\u0002\u0001\u000b\u0011B5\t\u000fA\u0004!\u0019!C\u0001c\"1Q\u000f\u0001Q\u0001\nIDqA\u001e\u0001C\u0002\u0013\u0005q\u000fC\u0004\u0002\u000e\u0001\u0001\u000b\u0011\u0002=\t\u0013\u0005=\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\r\u0001\u0001\u0006I!a\u0005\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005E\u0001\u0002CA\u000f\u0001\u0001\u0006I!a\u0005\t\u0013\u0005}\u0001A1A\u0005\u0002\u0005\u0005\u0002\u0002CA,\u0001\u0001\u0006I!a\t\t\u0017\u0005e\u0003\u00011AA\u0002\u0013\u0005\u00111\f\u0005\f\u0003g\u0002\u0001\u0019!a\u0001\n\u0003\t)\bC\u0006\u0002\u0002\u0002\u0001\r\u0011!Q!\n\u0005u\u0003bCAB\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000bC1\"!$\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010\"Y\u00111\u0013\u0001A\u0002\u0003\u0005\u000b\u0015BAD\u0011\u001d\t)\n\u0001C\u0001\u0003/Cq!a,\u0001\t\u0003\t9\nC\u0004\u00024\u0002!\t!a&\t\u000f\u0005]\u0006\u0001\"\u0001\u0002\u0018\"9\u00111\u0018\u0001\u0005\u0002\u0005]\u0005bBA`\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0003\u0007\u0004A\u0011AAL\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013D\u0011\"!;\u0001#\u0003%\t!a;\t\u0013\t\u0005\u0001!%A\u0005\u0002\t\r\u0001b\u0002B\u0004\u0001\u0011\u0005\u0011q\u0013\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0005a\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJ\fVo\u001c;bgR+7\u000f\u001e\u0006\u0003Y5\naa]3sm\u0016\u0014(\"\u0001\u0018\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001!\r\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005I\u0004C\u0001\u001e\u0001\u001b\u0005Y\u0013aB2p]\u001aLwm]\u000b\u0002{A\u0019a(Q\"\u000e\u0003}R!\u0001Q\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002C\u007f\t\u00191+Z9\u0011\u0005i\"\u0015BA#,\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0011\r|gNZ5hg\u0002\nA\u0001^5nKV\t\u0011\n\u0005\u0002K\u001b6\t1J\u0003\u0002M[\u0005)Q\u000f^5mg&\u0011aj\u0013\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#\u0001*\u0011\u0005McV\"\u0001+\u000b\u0005A+&B\u0001,X\u0003\u0019\u0019w.\\7p]*\u0011a\u0006\u0017\u0006\u00033j\u000ba!\u00199bG\",'\"A.\u0002\u0007=\u0014x-\u0003\u0002^)\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\rI,7m\u001c:e+\u0005\t\u0007C\u00012e\u001b\u0005\u0019'BA0V\u0013\t)7M\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H-A\u0004sK\u000e|'\u000f\u001a\u0011\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]F*\u0012!\u001b\t\u0003U.l\u0011!V\u0005\u0003YV\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\tu_BL7\rU1si&$\u0018n\u001c82A\u0005yAo\u001c9jGB\u000b'\u000f^5uS>t''\u0001\tu_BL7\rU1si&$\u0018n\u001c83A\u00059Ao\u001c9jG&#W#\u0001:\u0011\u0005)\u001c\u0018B\u0001;V\u0005\u0011)V/\u001b3\u0002\u0011Q|\u0007/[2JI\u0002\n\u0001\u0002^8qS\u000eLEm]\u000b\u0002qB)\u0011P`A\u0001e6\t!P\u0003\u0002|y\u0006!Q\u000f^5m\u0015\u0005i\u0018\u0001\u00026bm\u0006L!a >\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u0004\u0005%QBAA\u0003\u0015\r\t9\u0001`\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\f\u0005\u0015!AB*ue&tw-A\u0005u_BL7-\u00133tA\u0005\tBo\u001c9jG&#\u0007+\u0019:uSRLwN\\\u0019\u0016\u0005\u0005M\u0001c\u00016\u0002\u0016%\u0019\u0011qC+\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0017A\u0005;pa&\u001c\u0017\n\u001a)beRLG/[8oc\u0001\n\u0011\u0003^8qS\u000eLE\rU1si&$\u0018n\u001c83\u0003I!x\u000e]5d\u0013\u0012\u0004\u0016M\u001d;ji&|gN\r\u0011\u0002\u0013\u0019,Go\u00195J]\u001a|WCAA\u0012!\u0011q\u0014)!\n\u0011\u000fI\n9#a\u0005\u0002,%\u0019\u0011\u0011F\u001a\u0003\rQ+\b\u000f\\33!\u0011\ti#!\u0015\u000f\t\u0005=\u00121\n\b\u0005\u0003c\t9E\u0004\u0003\u00024\u0005\u0015c\u0002BA\u001b\u0003\u0007rA!a\u000e\u0002B9!\u0011\u0011HA \u001b\t\tYDC\u0002\u0002>=\na\u0001\u0010:p_Rt\u0014\"A.\n\u0005eS\u0016B\u0001\u0018Y\u0013\t1v+C\u0002\u0002JU\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003\u001b\ny%\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cHOC\u0002\u0002JUKA!a\u0015\u0002V\ti\u0001+\u0019:uSRLwN\u001c#bi\u0006TA!!\u0014\u0002P\u0005Qa-\u001a;dQ&sgm\u001c\u0011\u0002\u0019E,x\u000e^1NC:\fw-\u001a:\u0016\u0005\u0005u\u0003\u0003BA0\u0003[rA!!\u0019\u0002j9!\u00111MA4\u001d\u0011\tI$!\u001a\n\u00039J!\u0001L\u0017\n\u0007\u0005-4&\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0003\u0002p\u0005E$!D)v_R\fW*\u00198bO\u0016\u00148OC\u0002\u0002l-\n\u0001#];pi\u0006l\u0015M\\1hKJ|F%Z9\u0015\t\u0005]\u0014Q\u0010\t\u0004e\u0005e\u0014bAA>g\t!QK\\5u\u0011%\ty(GA\u0001\u0002\u0004\ti&A\u0002yIE\nQ\"];pi\u0006l\u0015M\\1hKJ\u0004\u0013A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003\u000f\u00032AOAE\u0013\r\tYi\u000b\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\t\u0005]\u0014\u0011\u0013\u0005\n\u0003\u007fb\u0012\u0011!a\u0001\u0003\u000f\u000bqB]3qY&\u001c\u0017-T1oC\u001e,'\u000fI\u0001+g\"|W\u000f\u001c3Fq\u000edW\u000fZ3Tk\n\u001cX-];f]R$\u0006N]8ui2,G\rU1si&$\u0018n\u001c8t)\t\t9\bK\u0002\u001f\u00037\u0003B!!(\u0002,6\u0011\u0011q\u0014\u0006\u0005\u0003C\u000b\u0019+A\u0002ba&TA!!*\u0002(\u00069!.\u001e9ji\u0016\u0014(bAAU5\u0006)!.\u001e8ji&!\u0011QVAP\u0005\u0011!Vm\u001d;\u0002sMDw.\u001e7e\u000f\u0016$hj\\'fgN\fw-Z:JMF+x\u000e^1t\u000bb\u001cW-\u001a3fI>s7+\u001e2tKF,XM\u001c;QCJ$\u0018\u000e^5p]ND3aHAN\u0003\t\u001a\bn\\;mI\u001e+GOQ8uQ6+7o]1hKNLe-U;pi\u0006\u001c\u0018\t\u001c7po\"\u001a\u0001%a'\u0002IMDw.\u001e7e\u0013:\u001cG.\u001e3f\u0013:\u001c\u0016P\\2UQJ|G\u000f\u001e7fIJ+\u0007\u000f\\5dCND3!IAN\u00039\u001a\bn\\;mI&s7\r\\;eKRC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7OR8s\u0007>t7/^7fe\u001a+Go\u00195)\u0007\t\nY*A\u0018uKN$8i\\7qY\u0016$X-\u00138EK2\f\u00170\u001a3GKR\u001c\u0007nV5uQJ+\u0007\u000f\\5dCRC'o\u001c;uY&tw\rK\u0002$\u00037\u000bq\u0005^3ti\u000e{W\u000e\u001d7fi\u0016Le\u000eR3mCf,GMR3uG\"\u001cuN\\:v[\u0016\u0014h)\u001a;dQ\"\u001aA%a'\u0002\u0015M,G/\u00169N_\u000e\\7\u000f\u0006\u0005\u0002x\u0005-\u0017Q\\Ap\u0011\u001d\ty\"\na\u0001\u0003\u001b\u0004b!a4\u0002Z\u0006\u0015b\u0002BAi\u0003+tA!!\u000f\u0002T&\tA'C\u0002\u0002XN\nq\u0001]1dW\u0006<W-C\u0002C\u00037T1!a64\u0011\u001dyV\u0005%AA\u0002\u0005D\u0011\"!9&!\u0003\u0005\r!a9\u0002%\t|G\u000f\u001b*fa2L7-Y:J]NKhn\u0019\t\u0004e\u0005\u0015\u0018bAAtg\t9!i\\8mK\u0006t\u0017\u0001F:fiV\u0003Xj\\2lg\u0012\"WMZ1vYR$#'\u0006\u0002\u0002n*\u001a\u0011-a<,\u0005\u0005E\b\u0003BAz\u0003{l!!!>\u000b\t\u0005]\u0018\u0011`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a?4\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u007f\f)PA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAc]3u+BlunY6tI\u0011,g-Y;mi\u0012\u001aTC\u0001B\u0003U\u0011\t\u0019/a<\u0002\u0011Q,\u0017M\u001d#po:D3\u0001\u000bB\u0006!\u0011\tiJ!\u0004\n\t\t=\u0011q\u0014\u0002\n\u0003\u001a$XM]#bG\"\f\u0011\"\\8dWF+x\u000e^1\u0015\u0005\tU\u0001c\u0001\u001e\u0003\u0018%\u0019!\u0011D\u0016\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final SimpleRecord record = new SimpleRecord("some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Uuid topicId = Uuid.randomUuid();
    private final Map<String, Uuid> topicIds = Collections.singletonMap("test-topic", this.topicId());
    private final TopicIdPartition topicIdPartition1 = new TopicIdPartition(this.topicId(), this.topicPartition1());
    private final TopicIdPartition topicIdPartition2 = new TopicIdPartition(this.topicId(), this.topicPartition2());
    private final Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition1()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), (List)new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicIdPartition2()), (Object)new FetchRequest.PartitionData(Uuid.ZERO_UUID, 0L, 0L, 100, Optional.empty())), (List)Nil$.MODULE$));
    private QuotaFactory.QuotaManagers quotaManager;
    private ReplicaManager replicaManager;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public SimpleRecord record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public Map<String, Uuid> topicIds() {
        return this.topicIds;
    }

    public TopicIdPartition topicIdPartition1() {
        return this.topicIdPartition1;
    }

    public TopicIdPartition topicIdPartition2() {
        return this.topicIdPartition2;
    }

    public Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public QuotaFactory.QuotaManagers quotaManager() {
        return this.quotaManager;
    }

    public void quotaManager_$eq(QuotaFactory.QuotaManagers x$1) {
        this.quotaManager = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$1(this, x$2))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldExcludeSubsequentThrottledPartitions$2(this, x$3))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we shouldn't get the second");
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(this, x$4))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
        Assertions.assertEquals((int)0, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(this, x$5))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both throttled, we should get no messages");
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$1(this, x$6))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldGetBothMessagesIfQuotasAllow$2(this, x$7))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with both non-throttled, we should get both messages");
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> x$1 = this.fetchInfo();
        boolean x$2 = true;
        SimpleRecord x$3 = this.setUpMocks$default$2();
        this.setUpMocks(x$1, x$3, x$2);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Seq fetch = this.replicaManager().readFromLocalLog(followerReplicaId, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$);
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$1(this, x$8))).get())._2()).info().records().batches()).asScala()).size(), (String)"Given two partitions, with only one throttled, we should get the first");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch.find((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ReplicaManagerQuotasTest.$anonfun$shouldIncludeInSyncThrottledReplicas$2(this, x$9))).get())._2()).info().records().batches()).asScala()).size(), (String)"But we should get the second too since it's throttled but in sync");
    }

    @Test
    public void shouldIncludeThrottledReplicasForConsumerFetch() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        ReplicaQuota quota = this.mockQuota();
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        scala.collection.immutable.Map fetch = this.replicaManager().readFromLocalLog(-1, true, (FetchIsolation)FetchHighWatermark$.MODULE$, Integer.MAX_VALUE, false, this.fetchInfo(), quota, (Option)None$.MODULE$).toMap(Predef$.MODULE$.$conforms());
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)fetch.apply((Object)this.topicIdPartition1())).info().records().batches()).asScala()).size(), (String)"Replication throttled partitions should return data for consumer fetch");
        Assertions.assertEquals((int)1, (int)((TraversableOnce)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)fetch.apply((Object)this.topicIdPartition2())).info().records().batches()).asScala()).size(), (String)"Replication throttled partitions should return data for consumer fetch");
    }

    @Test
    public void testCompleteInDelayedFetchWithReplicaThrottling() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(true).tryComplete(), (String)"In sync replica should complete");
        Assertions.assertFalse((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$1(false).tryComplete(), (String)"Out of sync replica should not complete");
    }

    @Test
    public void testCompleteInDelayedFetchConsumerFetch() {
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$2(false).tryComplete(), (String)"Consumer fetch replica should complete if reading from current segment");
        Assertions.assertTrue((boolean)ReplicaManagerQuotasTest.setupDelayedFetch$2(true).tryComplete(), (String)"Consumer fetch replica should complete if reading from older segment");
    }

    public void setUpMocks(Seq<Tuple2<TopicIdPartition, FetchRequest.PartitionData>> fetchInfo, SimpleRecord record, boolean bothReplicasInSync) {
        KafkaScheduler scheduler = (KafkaScheduler)Mockito.mock(KafkaScheduler.class);
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logStartOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)0L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)20L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.highWatermark())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)BoxesRunTime.boxToLong((long)log.lastStableOffset())).thenReturn((Object)BoxesRunTime.boxToLong((long)5L));
        Mockito.when((Object)log.logEndOffsetMetadata()).thenReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()));
        Mockito.when((Object)log.topicId()).thenReturn((Object)new Some((Object)this.topicId()));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), AdditionalMatchers.geq((int)1), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{record}), FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        Mockito.when((Object)log.read(ArgumentMatchers.anyLong(), ArgumentMatchers.eq((int)0), (FetchIsolation)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        LogManager logManager = (LogManager)Mockito.mock(LogManager.class);
        Mockito.when((Object)logManager.getLog((TopicPartition)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean())).thenReturn((Object)new Some((Object)log));
        Mockito.when((Object)logManager.liveLogDirs()).thenReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class))));
        AlterIsrManager alterIsrManager = (AlterIsrManager)Mockito.mock(AlterIsrManager.class);
        int leaderBrokerId = ((KafkaConfig)this.configs().head()).brokerId();
        this.quotaManager_$eq(QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""));
        Metrics x$1 = this.metrics();
        KafkaConfig x$2 = (KafkaConfig)this.configs().head();
        MockTime x$3 = this.time();
        QuotaFactory.QuotaManagers x$6 = this.quotaManager();
        ZkMetadataCache x$7 = MetadataCache$.MODULE$.zkMetadataCache(leaderBrokerId);
        LogDirFailureChannel x$8 = new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size());
        BrokerTopicStats x$102 = ReplicaManager$.MODULE$.$lessinit$greater$default$10();
        AtomicBoolean x$11 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        Option x$12 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$13 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$14 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$15 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$16 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$17 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        this.replicaManager_$eq(new ReplicaManager(x$2, x$1, (Time)x$3, (Scheduler)scheduler, logManager, x$6, (MetadataCache)x$7, x$8, alterIsrManager, x$102, x$11, x$12, x$13, x$14, x$15, x$16, x$17));
        fetchInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$10 -> {
            ReplicaManagerQuotasTest.$anonfun$setUpMocks$2(this, log, leaderBrokerId, bothReplicasInSync, x$10);
            return BoxedUnit.UNIT;
        });
    }

    public SimpleRecord setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @AfterEach
    public void tearDown() {
        Option$.MODULE$.apply((Object)this.replicaManager()).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            x$11.shutdown(false);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.quotaManager()).foreach((Function1 & Serializable & scala.Serializable)x$12 -> {
            x$12.shutdown();
            return BoxedUnit.UNIT;
        });
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota() {
        void var1_1;
        ReplicaQuota quota = (ReplicaQuota)Mockito.mock(ReplicaQuota.class);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)ArgumentMatchers.any()))).thenReturn((Object)BoxesRunTime.boxToBoolean((boolean)true));
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$2) {
        Object object = x$2._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldExcludeSubsequentThrottledPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$3) {
        Object object = x$3._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$1(ReplicaManagerQuotasTest $this, Tuple2 x$4) {
        Object object = x$4._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions$2(ReplicaManagerQuotasTest $this, Tuple2 x$5) {
        Object object = x$5._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$1(ReplicaManagerQuotasTest $this, Tuple2 x$6) {
        Object object = x$6._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldGetBothMessagesIfQuotasAllow$2(ReplicaManagerQuotasTest $this, Tuple2 x$7) {
        Object object = x$7._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$1(ReplicaManagerQuotasTest $this, Tuple2 x$8) {
        Object object = x$8._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition1();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    public static final /* synthetic */ boolean $anonfun$shouldIncludeInSyncThrottledReplicas$2(ReplicaManagerQuotasTest $this, Tuple2 x$9) {
        Object object = x$9._1();
        TopicIdPartition topicIdPartition = $this.topicIdPartition2();
        return !(object != null ? !object.equals(topicIdPartition) : topicIdPartition != null);
    }

    private static final DelayedFetch setupDelayedFetch$1(boolean isReplicaInSync) {
        LogOffsetMetadata endOffsetMetadata = new LogOffsetMetadata(100L, 0L, 500);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        Mockito.when((Object)BoxesRunTime.boxToBoolean((boolean)replicaManager.shouldLeaderThrottle((ReplicaQuota)ArgumentMatchers.any(), (Partition)ArgumentMatchers.any(), ArgumentMatchers.anyInt()))).thenReturn((Object)BoxesRunTime.boxToBoolean((!isReplicaInSync ? 1 : 0) != 0));
        Mockito.when((Object)partition.getReplica(1)).thenReturn((Object)None$.MODULE$);
        TopicIdPartition tp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, true, 1, (Seq)new .colon.colon((Object)new Tuple2((Object)tp, (Object)fetchPartitionStatus), (List)Nil$.MODULE$));
        return new DelayedFetch(null, fetchMetadata, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    private static final DelayedFetch setupDelayedFetch$2(boolean isFetchFromOlderSegment) {
        LogOffsetMetadata endOffsetMetadata = isFetchFromOlderSegment ? new LogOffsetMetadata(100L, 0L, 500) : new LogOffsetMetadata(150L, 50L, 500);
        Partition partition = (Partition)Mockito.mock(Partition.class);
        LogOffsetSnapshot offsetSnapshot = new LogOffsetSnapshot(0L, endOffsetMetadata, endOffsetMetadata, endOffsetMetadata);
        Mockito.when((Object)partition.fetchOffsetSnapshot(Optional.empty(), true)).thenReturn((Object)offsetSnapshot);
        ReplicaManager replicaManager = (ReplicaManager)Mockito.mock(ReplicaManager.class);
        Mockito.when((Object)replicaManager.getPartitionOrException((TopicPartition)ArgumentMatchers.any())).thenReturn((Object)partition);
        TopicIdPartition tidp = new TopicIdPartition(Uuid.randomUuid(), new TopicPartition("t1", 0));
        FetchPartitionStatus fetchPartitionStatus = new FetchPartitionStatus(new LogOffsetMetadata(50L, 0L, 250), new FetchRequest.PartitionData(Uuid.ZERO_UUID, 50L, 0L, 1, Optional.empty()));
        FetchMetadata fetchMetadata = new FetchMetadata(1, 1000, true, true, (FetchIsolation)FetchLogEnd$.MODULE$, false, -1, (Seq)new .colon.colon((Object)new Tuple2((Object)tidp, (Object)fetchPartitionStatus), (List)Nil$.MODULE$));
        return new DelayedFetch(null, fetchMetadata, replicaManager){

            public boolean forceComplete() {
                return true;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$setUpMocks$2(ReplicaManagerQuotasTest $this, UnifiedLog log$1, int leaderBrokerId$1, boolean bothReplicasInSync$1, Tuple2 x$10) {
        if (x$10 != null) {
            TopicIdPartition p = (TopicIdPartition)x$10._1();
            Partition partition = $this.replicaManager().createPartition(p.topicPartition());
            log$1.updateHighWatermark(5L);
            partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderBrokerId$1)));
            partition.setLog(log$1, false);
            partition.updateAssignmentAndIsr((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})), bothReplicasInSync$1 ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1, ((KafkaConfig)$this.configs().last()).brokerId()})) : (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leaderBrokerId$1})), (Seq)Nil$.MODULE$, (Seq)Nil$.MODULE$, LeaderRecoveryState.RECOVERED);
            return;
        }
        throw new MatchError(null);
    }
}

