/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.DataInputStream;
import java.io.File;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Broker;
import kafka.controller.ControllerChannelManager;
import kafka.controller.ControllerChannelManager$;
import kafka.controller.ControllerContext;
import kafka.controller.StateChangeLogger;
import kafka.integration.KafkaServerTestHarness;
import kafka.log.LogManager$;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.TestUtils$;
import kafka.zookeeper.ZooKeeperClientTimeoutException;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.AbstractControlRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.BrokerState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@Timeout(value=60L)
@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001\u0002\u0011\"\u0001\u0019BQ!\f\u0001\u0005\u00029Bq!\r\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004<\u0001\u0001\u0006Ia\r\u0005\by\u0001\u0011\r\u0011\"\u00013\u0011\u0019i\u0004\u0001)A\u0005g!9a\b\u0001b\u0001\n\u0003y\u0004B\u0002&\u0001A\u0003%\u0001\tC\u0004L\u0001\t\u0007I\u0011A \t\r1\u0003\u0001\u0015!\u0003A\u0011\u001di\u0005A1A\u0005\u00029Ca!\u0016\u0001!\u0002\u0013y\u0005b\u0002,\u0001\u0001\u0004%\ta\u0016\u0005\b?\u0002\u0001\r\u0011\"\u0001a\u0011\u00191\u0007\u0001)Q\u00051\")q\r\u0001C!Q\")Q\u000e\u0001C!]\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA$\u0001\u0011\u0005\u0011\u0011\n\u0005\b\u0003'\u0002A\u0011AA+\u0011\u001d\ty\u0006\u0001C\u0001\u0003CBq!a\u001b\u0001\t\u0003\ti\u0007C\u0004\u0002x\u0001!I!!\u001f\t\u0011\u0005M\u0006\u0001)C\u0005\u0003kCq!a2\u0001\t\u0003\tI\rC\u0004\u0002L\u0002!\t!!4\t\u000f\u0005]\u0007\u0001\"\u0001\u0002J\"9\u0011\u0011\u001d\u0001\u0005\n\u0005\r\bbBAs\u0001\u0011%\u0011q\u001d\u0005\b\u0003_\u0004A\u0011BAe\u0011\u001d\t\t\u0010\u0001C\u0005\u0003\u0013Dq!a=\u0001\t\u0013\t)P\u0001\nTKJ4XM]*ikR$wn\u001e8UKN$(B\u0001\u0012$\u0003\u0019\u0019XM\u001d<fe*\tA%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u00019\u0003C\u0001\u0015,\u001b\u0005I#B\u0001\u0016$\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u00051J#AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005y\u0003C\u0001\u0019\u0001\u001b\u0005\t\u0013\u0001\u00025pgR,\u0012a\r\t\u0003iej\u0011!\u000e\u0006\u0003m]\nA\u0001\\1oO*\t\u0001(\u0001\u0003kCZ\f\u0017B\u0001\u001e6\u0005\u0019\u0019FO]5oO\u0006)\u0001n\\:uA\u0005)Ao\u001c9jG\u00061Ao\u001c9jG\u0002\nQa]3oiF*\u0012\u0001\u0011\t\u0004\u0003\"\u001bT\"\u0001\"\u000b\u0005\r#\u0015!C5n[V$\u0018M\u00197f\u0015\t)e)\u0001\u0006d_2dWm\u0019;j_:T\u0011aR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0013\n\u0013A\u0001T5ti\u000611/\u001a8uc\u0001\nQa]3oiJ\naa]3oiJ\u0002\u0013\u0001\u00079s_B\u001cHk\\\"iC:<W-\u00169p]J+7\u000f^1siV\tq\n\u0005\u0002Q'6\t\u0011K\u0003\u0002So\u0005!Q\u000f^5m\u0013\t!\u0016K\u0001\u0006Qe>\u0004XM\u001d;jKN\f\u0011\u0004\u001d:paN$vn\u00115b]\u001e,W\u000b]8o%\u0016\u001cH/\u0019:uA\u0005Y\u0001O]5pe\u000e{gNZ5h+\u0005A\u0006cA-[96\ta)\u0003\u0002\\\r\n1q\n\u001d;j_:\u0004\"\u0001M/\n\u0005y\u000b#aC&bM.\f7i\u001c8gS\u001e\fq\u0002\u001d:j_J\u001cuN\u001c4jO~#S-\u001d\u000b\u0003C\u0012\u0004\"!\u00172\n\u0005\r4%\u0001B+oSRDq!Z\u0007\u0002\u0002\u0003\u0007\u0001,A\u0002yIE\nA\u0002\u001d:j_J\u001cuN\u001c4jO\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u000b\u0002SB\u0019!n\u001b/\u000e\u0003\u0011K!\u0001\u001c#\u0003\u0007M+\u0017/A\u0003tKR,\u0006\u000f\u0006\u0002b_\")\u0001\u000f\u0005a\u0001c\u0006AA/Z:u\u0013:4w\u000e\u0005\u0002sw6\t1O\u0003\u0002uk\u0006\u0019\u0011\r]5\u000b\u0005Y<\u0018a\u00026va&$XM\u001d\u0006\u0003qf\fQA[;oSRT\u0011A_\u0001\u0004_J<\u0017B\u0001?t\u0005!!Vm\u001d;J]\u001a|\u0007F\u0001\t\u007f!\t\u0011x0C\u0002\u0002\u0002M\u0014!BQ3g_J,W)Y2i\u0003E!Xm\u001d;DY\u0016\fgn\u00155vi\u0012|wO\u001c\u000b\u0004C\u0006\u001d\u0001bBA\u0005#\u0001\u0007\u00111B\u0001\u0007cV|'/^7\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u0012\u0019k!!a\u0005\u000b\u0007\u0005UQ%\u0001\u0004=e>|GOP\u0005\u0004\u000331\u0015A\u0002)sK\u0012,g-C\u0002;\u0003;Q1!!\u0007GQ\u001d\t\u0012\u0011EA\u0019\u0003g\u0001B!a\t\u0002.5\u0011\u0011Q\u0005\u0006\u0005\u0003O\tI#\u0001\u0005qe>4\u0018\u000eZ3s\u0015\r\tY#^\u0001\u0007a\u0006\u0014\u0018-\\:\n\t\u0005=\u0012Q\u0005\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\t\u0005U\u0012\u0011H\u0011\u0003\u0003o\t!A_6\"\u0005\u0005m\u0012!B6sC\u001a$\bfA\t\u0002@A!\u0011\u0011IA\"\u001b\t\tI#\u0003\u0003\u0002F\u0005%\"!\u0005)be\u0006lW\r^3sSj,G\rV3ti\u0006\u0019C/Z:u\u00072,\u0017M\\*ikR$wn\u001e8BMR,'OR1jY\u0016$7\u000b^1siV\u0004HcA1\u0002L!9\u0011\u0011\u0002\nA\u0002\u0005-\u0001f\u0002\n\u0002\"\u0005E\u0012q\n\u0017\u0005\u0003k\tI\u0004K\u0002\u0013\u0003\u007f\t1\u0007^3ti\u000ecW-\u00198TQV$Hm\\<o\u0003\u001a$XM\u001d$bS2,Gm\u0015;beR,\b\u000fR;f)>\u001cuN\u001d:vaRdunZ:\u0015\u0007\u0005\f9\u0006C\u0004\u0002\nM\u0001\r!a\u0003)\u000fM\t\t#!\r\u0002\\1\"\u0011QGA\u001dQ\r\u0019\u0012qH\u0001#i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tw+\u001b;i5.,f.\u0019<bS2\f'\r\\3\u0015\u0007\u0005\f\u0019\u0007C\u0004\u0002\nQ\u0001\r!a\u0003)\u000fQ\t\t#!\r\u0002h1\u0012\u0011Q\u0007\u0015\u0004)\u0005}\u0012a\f;fgR\u001cE.Z1o'\",H\u000fZ8x]^KG\u000f[&SC\u001a$8i\u001c8ue>dG.\u001a:V]\u00064\u0018-\u001b7bE2,GcA1\u0002p!9\u0011\u0011B\u000bA\u0002\u0005-\u0001fB\u000b\u0002\"\u0005E\u00121\u000f\u0017\u0003\u0003sA3!FA \u0003\u00152XM]5gs\u000ecW-\u00198TQV$Hm\\<o\u0003\u001a$XM\u001d$bS2,Gm\u0015;beR,\b/\u0006\u0003\u0002|\u0005ME\u0003BA?\u0003c#2!YA@\u0011\u001d\t\tI\u0006a\u0002\u0003\u0007\u000b\u0011#\u001a=dKB$\u0018n\u001c8DY\u0006\u001c8\u000fV1h!\u0019\t))a#\u0002\u00106\u0011\u0011q\u0011\u0006\u0004\u0003\u00133\u0015a\u0002:fM2,7\r^\u0005\u0005\u0003\u001b\u000b9I\u0001\u0005DY\u0006\u001c8\u000fV1h!\u0011\t\t*a%\r\u0001\u00119\u0011Q\u0013\fC\u0002\u0005]%!A#\u0012\t\u0005e\u0015q\u0014\t\u00043\u0006m\u0015bAAO\r\n9aj\u001c;iS:<\u0007\u0003BAQ\u0003WsA!a)\u0002(:!\u0011\u0011CAS\u0013\u00059\u0015bAAU\r\u00069\u0001/Y2lC\u001e,\u0017\u0002BAW\u0003_\u0013\u0011\"\u0012=dKB$\u0018n\u001c8\u000b\u0007\u0005%f\tC\u0004\u0002\nY\u0001\r!a\u0003\u0002-%\u001chj\u001c8EC\u0016lwN\\&bM.\fG\u000b\u001b:fC\u0012$B!a.\u0002>B\u0019\u0011,!/\n\u0007\u0005mfIA\u0004C_>dW-\u00198\t\u000f\u0005}v\u00031\u0001\u0002B\u0006\tA\u000fE\u00025\u0003\u0007L1!!26\u0005\u0019!\u0006N]3bI\u0006ab/\u001a:jMftuN\u001c#bK6|g\u000e\u00165sK\u0006$7o\u0015;biV\u001cH#A1\u0002/Q,7\u000f^\"p]N,7-\u001e;jm\u0016\u001c\u0006.\u001e;e_^tGcA1\u0002P\"9\u0011\u0011B\rA\u0002\u0005-\u0001fB\r\u0002\"\u0005E\u00121\u001b\u0017\u0005\u0003k\tI\u0004K\u0002\u001a\u0003\u007f\t\u0001\u0005^3ti\u000e{g\u000e\u001e:pY2,'o\u00155vi\u0012|wO\u001c#ve&twmU3oI\"\u001a!$a7\u0011\u0007I\fi.C\u0002\u0002`N\u0014A\u0001V3ti\u000611m\u001c8gS\u001e,\u0012\u0001X\u0001\u0007EJ|7.\u001a:\u0016\u0005\u0005%\bc\u0001\u0019\u0002l&\u0019\u0011Q^\u0011\u0003\u0017-\u000bgm[1Ce>\\WM]\u0001\u000fg\",H\u000fZ8x]\n\u0013xn[3s\u00035\u0011Xm\u001d;beR\u0014%o\\6fe\u0006q!/Z2sK\u0006$XM\u0011:pW\u0016\u0014HcA1\u0002x\"9\u0011\u0011`\u0010A\u0002\u0005]\u0016aB:uCJ$X\u000f\u001d\u0015\b\u0001\u0005u(1\u0001B\u0003!\r\u0011\u0018q`\u0005\u0004\u0005\u0003\u0019(a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0002y\u0001")
public class ServerShutdownTest
extends KafkaServerTestHarness {
    private final String host;
    private final String topic;
    private final List<String> sent1 = new .colon.colon((Object)"hello", (List)new .colon.colon((Object)"there", (List)Nil$.MODULE$));
    private final List<String> sent2 = new .colon.colon((Object)"more", (List)new .colon.colon((Object)"messages", (List)Nil$.MODULE$));
    private final Properties propsToChangeUponRestart = new Properties();
    private Option<KafkaConfig> priorConfig = None$.MODULE$;

    public String host() {
        return this.host;
    }

    public String topic() {
        return this.topic;
    }

    public List<String> sent1() {
        return this.sent1;
    }

    public List<String> sent2() {
        return this.sent2;
    }

    public Properties propsToChangeUponRestart() {
        return this.propsToChangeUponRestart;
    }

    public Option<KafkaConfig> priorConfig() {
        return this.priorConfig;
    }

    public void priorConfig_$eq(Option<KafkaConfig> x$1) {
        this.priorConfig = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        this.priorConfig().foreach((Function1 & Serializable & scala.Serializable)config -> {
            java.util.Map originals = config.originals();
            Object logDirsValue = originals.get(KafkaConfig$.MODULE$.LogDirsProp());
            if (logDirsValue != null) {
                return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirsProp(), logDirsValue);
            }
            return this.propsToChangeUponRestart().put(KafkaConfig$.MODULE$.LogDirProp(), originals.get(KafkaConfig$.MODULE$.LogDirProp()));
        });
        this.priorConfig_$eq((Option<KafkaConfig>)new Some((Object)KafkaConfig$.MODULE$.fromProps((Properties)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnectOrNull(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).head(), this.propsToChangeUponRestart())));
        return new .colon.colon((Object)((KafkaConfig)this.priorConfig().get()), (List)Nil$.MODULE$);
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.priorConfig_$eq((Option<KafkaConfig>)None$.MODULE$);
        this.propsToChangeUponRestart().clear();
        super.setUp(testInfo);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdown(String quorum) {
        ObjectRef producer = ObjectRef.create((Object)this.createProducer$1());
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        ((List)this.sent1().map((Function1 & Serializable & scala.Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$1 -> (RecordMetadata)x$1.get());
        this.shutdownBroker();
        this.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            ServerShutdownTest.$anonfun$testCleanShutdown$3(logDir);
            return BoxedUnit.UNIT;
        });
        ((KafkaProducer)producer.elem).close();
        this.restartBroker();
        TestUtils$.MODULE$.waitForPartitionMetadata(new .colon.colon((Object)this.broker(), (List)Nil$.MODULE$), this.topic(), 0, TestUtils$.MODULE$.waitForPartitionMetadata$default$4());
        producer.elem = this.createProducer$1();
        KafkaConsumer consumer = this.createConsumer$1();
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava());
        Seq consumerRecords = TestUtils$.MODULE$.consumeRecords(consumer, this.sent1().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals(this.sent1(), (Object)consumerRecords.map((Function1 & Serializable & scala.Serializable)x$2 -> (String)x$2.value(), Seq$.MODULE$.canBuildFrom()));
        ((List)this.sent2().map((Function1 & Serializable & scala.Serializable)value -> ((KafkaProducer)producer$1.elem).send(new ProducerRecord(this.topic(), (Object)Predef$.MODULE$.int2Integer(0), value)), List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$3 -> (RecordMetadata)x$3.get());
        Seq consumerRecords2 = TestUtils$.MODULE$.consumeRecords(consumer, this.sent2().size(), TestUtils$.MODULE$.consumeRecords$default$3());
        Assertions.assertEquals(this.sent2(), (Object)consumerRecords2.map((Function1 & Serializable & scala.Serializable)x$4 -> (String)x$4.value(), Seq$.MODULE$.canBuildFrom()));
        consumer.close();
        ((KafkaProducer)producer.elem).close();
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartup(String quorum) {
        String string = quorum;
        String string2 = "zk";
        if (string != null && string.equals(string2)) {
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectionTimeoutMsProp(), "50");
            this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.ZkConnectProp(), "some.invalid.hostname.foo.bar.local:65535");
            this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(ZooKeeperClientTimeoutException.class));
            return;
        }
        this.propsToChangeUponRestart().setProperty(KafkaConfig$.MODULE$.InitialBrokerRegistrationTimeoutMsProp(), "1000");
        this.shutdownBroker();
        this.shutdownKRaftController();
        this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(CancellationException.class));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testCleanShutdownAfterFailedStartupDueToCorruptLogs(String quorum) {
        this.createTopic(this.topic(), this.createTopic$default$2(), this.createTopic$default$3(), this.createTopic$default$4(), this.createTopic$default$5());
        this.shutdownBroker();
        this.config().logDirs().foreach((Function1 & Serializable & scala.Serializable)dirName -> {
            ServerShutdownTest.$anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(this, dirName);
            return BoxedUnit.UNIT;
        });
        this.verifyCleanShutdownAfterFailedStartup(quorum, ClassTag$.MODULE$.apply(KafkaStorageException.class));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk"})
    public void testCleanShutdownWithZkUnavailable(String quorum) {
        this.shutdownZooKeeper();
        this.shutdownBroker();
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    @ParameterizedTest
    @ValueSource(strings={"kraft"})
    public void testCleanShutdownWithKRaftControllerUnavailable(String quorum) {
        this.shutdownKRaftController();
        this.shutdownBroker();
        CoreUtils$.MODULE$.delete(this.broker().config().logDirs());
        this.verifyNonDaemonThreadsStatus();
    }

    private <E extends Exception> void verifyCleanShutdownAfterFailedStartup(String quorum, ClassTag<E> exceptionClassTag) {
        try {
            try {
                this.recreateBroker(true);
                Assertions.fail((String)"Expected KafkaServer setup to fail and throw exception");
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)exceptionClassTag.runtimeClass().isInstance(e), (String)new StringBuilder(21).append("Unexpected exception ").append(e).toString());
                String string = quorum;
                String string2 = "zk";
                Assertions.assertEquals((Object)(string != null && string.equals(string2) ? BrokerState.NOT_RUNNING : BrokerState.SHUTTING_DOWN), (Object)((KafkaBroker)this.brokers().head()).brokerState());
            }
        }
        finally {
            this.shutdownBroker();
        }
    }

    private boolean isNonDaemonKafkaThread(Thread t) {
        return !t.isDaemon() && t.isAlive() && t.getName().startsWith(this.getClass().getName());
    }

    public void verifyNonDaemonThreadsStatus() {
        Assertions.assertEquals((int)0, (int)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(Thread.getAllStackTraces().keySet().toArray())).map((Function1 & Serializable & scala.Serializable)x$5 -> (Thread)x$5, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Thread.class))))).count((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)this.isNonDaemonKafkaThread(t))));
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testConsecutiveShutdown(String quorum) {
        this.shutdownBroker();
        ((KafkaBroker)this.brokers().head()).shutdown();
    }

    @Test
    public void testControllerShutdownDuringSend() {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        int controllerId = 2;
        Metrics metrics = new Metrics();
        ExecutorService executor = Executors.newSingleThreadExecutor();
        ObjectRef serverSocket = ObjectRef.create(null);
        ObjectRef controllerChannelManager = ObjectRef.create(null);
        try {
            serverSocket.elem = new ServerSocket(0);
            Future<?> receiveFuture = executor.submit(new Runnable(null, serverSocket){
                private final ObjectRef serverSocket$1;

                public void run() {
                    Socket socket = ((ServerSocket)this.serverSocket$1.elem).accept();
                    new DataInputStream(socket.getInputStream()).readByte();
                }
                {
                    this.serverSocket$1 = serverSocket$1;
                }
            });
            scala.collection.immutable.Map brokerAndEpochs = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new Broker(1, "localhost", ((ServerSocket)serverSocket.elem).getLocalPort(), listenerName, securityProtocol), (Object)BoxesRunTime.boxToLong((long)0L))}));
            KafkaConfig controllerConfig = KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(controllerId, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20()));
            ControllerContext controllerContext = new ControllerContext();
            controllerContext.setLiveBrokers((Map)brokerAndEpochs);
            controllerChannelManager.elem = new ControllerChannelManager(controllerContext, controllerConfig, Time.SYSTEM, metrics, new StateChangeLogger(controllerId, true, (Option)None$.MODULE$), ControllerChannelManager$.MODULE$.$lessinit$greater$default$6());
            ((ControllerChannelManager)controllerChannelManager.elem).startup();
            LeaderAndIsrRequest.Builder requestBuilder = new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, 1, 0L, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava(), Collections.singletonMap(this.topic(), Uuid.randomUuid()), (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)brokerAndEpochs.keys().map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.node(listenerName), Iterable$.MODULE$.canBuildFrom())).toSet()).asJava());
            ControllerChannelManager qual$1 = (ControllerChannelManager)controllerChannelManager.elem;
            int x$1 = 1;
            Function1 x$3 = qual$1.sendRequest$default$3();
            qual$1.sendRequest(x$1, (AbstractControlRequest.Builder)requestBuilder, x$3);
            receiveFuture.get(10L, TimeUnit.SECONDS);
            executor.submit(new Runnable(null, controllerChannelManager){
                private final ObjectRef controllerChannelManager$1;

                public void run() {
                    ((ControllerChannelManager)this.controllerChannelManager$1.elem).shutdown();
                }
                {
                    this.controllerChannelManager$1 = controllerChannelManager$1;
                }
            }).get(10L, TimeUnit.SECONDS);
        }
        finally {
            if ((ServerSocket)serverSocket.elem != null) {
                ((ServerSocket)serverSocket.elem).close();
            }
            if ((ControllerChannelManager)controllerChannelManager.elem != null) {
                ((ControllerChannelManager)controllerChannelManager.elem).shutdown();
            }
            executor.shutdownNow();
            metrics.close();
        }
    }

    private KafkaConfig config() {
        return (KafkaConfig)this.configs().head();
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private void shutdownBroker() {
        this.killBroker(0);
    }

    private void restartBroker() {
        this.shutdownBroker();
        this.restartDeadBrokers(!this.propsToChangeUponRestart().isEmpty());
    }

    private void recreateBroker(boolean startup) {
        this.recreateBrokers(!this.propsToChangeUponRestart().isEmpty(), startup);
    }

    private final KafkaProducer createProducer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        return TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16);
    }

    private final KafkaConsumer createConsumer$1() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        SecurityProtocol x$2 = SecurityProtocol.PLAINTEXT;
        IntegerDeserializer x$3 = new IntegerDeserializer();
        StringDeserializer x$4 = new StringDeserializer();
        String x$5 = TestUtils$.MODULE$.createConsumer$default$2();
        String x$6 = TestUtils$.MODULE$.createConsumer$default$3();
        boolean x$7 = TestUtils$.MODULE$.createConsumer$default$4();
        boolean x$8 = TestUtils$.MODULE$.createConsumer$default$5();
        int x$9 = TestUtils$.MODULE$.createConsumer$default$6();
        Option<File> x$10 = TestUtils$.MODULE$.createConsumer$default$8();
        Option<Properties> x$11 = TestUtils$.MODULE$.createConsumer$default$9();
        return TestUtils$.MODULE$.createConsumer(x$1, x$5, x$6, x$7, x$8, x$9, x$2, x$10, x$11, x$3, x$4);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdown$3(String logDir) {
        File OffsetCheckpointFile2 = new File(logDir, LogManager$.MODULE$.RecoveryPointCheckpointFile());
        Assertions.assertTrue((boolean)OffsetCheckpointFile2.exists());
        Assertions.assertTrue((OffsetCheckpointFile2.length() > 0L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$testCleanShutdownAfterFailedStartupDueToCorruptLogs$1(ServerShutdownTest $this, String dirName) {
        File partitionDir = new File(dirName, new StringBuilder(2).append($this.topic()).append("-0").toString());
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionDir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)f -> {
            TestUtils$.MODULE$.appendNonsenseToFile(f, TestUtils$.MODULE$.random().nextInt(1024) + 1);
            return BoxedUnit.UNIT;
        });
    }

    public ServerShutdownTest() {
        this.host = "localhost";
        this.topic = "test";
    }
}

