/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.api.KAFKA_2_7_IV0$;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.DeleteTopicsRequestData;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001\u0002\t\u0012\u0001YAQa\u0007\u0001\u0005\u0002qAQA\b\u0001\u0005B}AQ\u0001\r\u0001\u0005BEBQ\u0001\u0012\u0001\u0005\u0002\u0015CQA\u0013\u0001\u0005\u0002\u0015CQ\u0001\u0014\u0001\u0005\u0002\u0015CQA\u0014\u0001\u0005\u0002\u0015CQ\u0001\u0015\u0001\u0005\u0002\u0015CQA\u0015\u0001\u0005\nMCQa\u001c\u0001\u0005\nADq!a\u0010\u0001\t\u0013\t\t\u0005C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u00055\u0004\u0001\"\u0003\u0002p!I\u00111\u0011\u0001\u0012\u0002\u0013%\u0011Q\u0011\u0005\b\u00037\u0003A\u0011BAO\u0005\u0015\"v\u000e]5d\u0013\u0012<\u0016\u000e\u001e5PY\u0012Le\u000e^3s\u0005J|7.\u001a:Qe>$xnY8m)\u0016\u001cHO\u0003\u0002\u0013'\u000511/\u001a:wKJT\u0011\u0001F\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t\u0011#\u0003\u0002\u001b#\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011\u0001\u0004A\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"\u0001\t\u0014\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006O\t\u0001\r\u0001K\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\bCA\u0015/\u001b\u0005Q#BA\u0016-\u0003\u0011)H/\u001b7\u000b\u00035\nAA[1wC&\u0011qF\u000b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!B:fiV\u0003HC\u0001\u00113\u0011\u0015\u00194\u00011\u00015\u0003!!Xm\u001d;J]\u001a|\u0007CA\u001b?\u001b\u00051$BA\u001c9\u0003\r\t\u0007/\u001b\u0006\u0003si\nqA[;qSR,'O\u0003\u0002<y\u0005)!.\u001e8ji*\tQ(A\u0002pe\u001eL!a\u0010\u001c\u0003\u0011Q+7\u000f^%oM>D#aA!\u0011\u0005U\u0012\u0015BA\"7\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\u001fi\u0016\u001cH/T3uC\u0012\fG/\u0019+pa&\u001c\u0017\nZ:XSRDw\n\u001c3J\u0005B#\u0012\u0001\t\u0015\u0003\t\u001d\u0003\"!\u000e%\n\u0005%3$\u0001\u0002+fgR\fA\u0006^3ti\u001a+Go\u00195U_BL7-\u00133t/&$\bn\u00147e\u0013\n\u0003vK]8oO\u001a+Go\u00195WKJ\u001c\u0018n\u001c8)\u0005\u00159\u0015A\f;fgR4U\r^2i)>\u0004\u0018nY%eg^KG\u000f[(mI&\u0013\u0005kQ8se\u0016\u001cGOR3uG\"4VM]:j_:D#AB$\u00025Q,7\u000f\u001e#fY\u0016$X\rV8qS\u000e\u001cx+\u001b;i\u001f2$\u0017J\u0011))\u0005\u001d9\u0015A\t;fgR$U\r\\3uKR{\u0007/[2t/&$\bn\u00147e\u0013\n\u0003Vk]5oO&#5\u000f\u000b\u0002\t\u000f\u0006\u00192/\u001a8e\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiR\u0019Ak\u00183\u0011\u0005UkV\"\u0001,\u000b\u0005]C\u0016\u0001\u0003:fcV,7\u000f^:\u000b\u0005eS\u0016AB2p[6|gN\u0003\u0002\u00157*\u0011A\fP\u0001\u0007CB\f7\r[3\n\u0005y3&\u0001E'fi\u0006$\u0017\r^1SKN\u0004xN\\:f\u0011\u0015\u0001\u0017\u00021\u0001b\u0003\u001d\u0011X-];fgR\u0004\"!\u00162\n\u0005\r4&aD'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u000b\u0015L\u0001\u0019\u00014\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\t\u0004C\u001dL\u0017B\u00015#\u0005\u0019y\u0005\u000f^5p]B\u0011!.\\\u0007\u0002W*\u0011AnE\u0001\b]\u0016$xo\u001c:l\u0013\tq7N\u0001\u0007T_\u000e\\W\r^*feZ,'/\u0001\nde\u0016\fG/\u001a$fi\u000eD'+Z9vKN$H\u0003C9usn\fy!!\u000e\u0011\u0005U\u0013\u0018BA:W\u000511U\r^2i%\u0016\fX/Z:u\u0011\u0015)(\u00021\u0001w\u0003Ai\u0017\r\u001f*fgB|gn]3CsR,7\u000f\u0005\u0002\"o&\u0011\u0001P\t\u0002\u0004\u0013:$\b\"\u0002>\u000b\u0001\u00041\u0018!E7bqB\u000b'\u000f^5uS>t')\u001f;fg\")AP\u0003a\u0001{\u0006yAo\u001c9jGB\u000b'\u000f^5uS>t7\u000fE\u0003\u007f\u0003\u0007\t9!D\u0001\u0000\u0015\r\t\tAI\u0001\u000bG>dG.Z2uS>t\u0017bAA\u0003\u007f\n\u00191+Z9\u0011\t\u0005%\u00111B\u0007\u00021&\u0019\u0011Q\u0002-\u0003!Q{\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBA\t\u0015\u0001\u0007\u00111C\u0001\n_\u001a47/\u001a;NCB\u0004\u0002\"!\u0006\u0002$\u0005%\u0012q\u0006\b\u0005\u0003/\ty\u0002E\u0002\u0002\u001a\tj!!a\u0007\u000b\u0007\u0005uQ#\u0001\u0004=e>|GOP\u0005\u0004\u0003C\u0011\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002&\u0005\u001d\"aA'ba*\u0019\u0011\u0011\u0005\u0012\u0011\t\u0005%\u00111F\u0005\u0004\u0003[A&A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\t\u0004C\u0005E\u0012bAA\u001aE\t!Aj\u001c8h\u0011\u001d\t9D\u0003a\u0001\u0003s\tqA^3sg&|g\u000eE\u0002\"\u0003wI1!!\u0010#\u0005\u0015\u0019\u0006n\u001c:u\u0003I\u0019'/Z1uKB\u000b'\u000f^5uS>tW*\u00199\u0015\u0011\u0005\r\u0013qKA-\u00037\u0002r!KA#\u0003S\tI%C\u0002\u0002H)\u0012Q\u0002T5oW\u0016$\u0007*Y:i\u001b\u0006\u0004\b\u0003BA&\u0003#r1!VA'\u0013\r\tyEV\u0001\r\r\u0016$8\r\u001b*fcV,7\u000f^\u0005\u0005\u0003'\n)FA\u0007QCJ$\u0018\u000e^5p]\u0012\u000bG/\u0019\u0006\u0004\u0003\u001f2\u0006\"\u0002>\f\u0001\u00041\b\"\u0002?\f\u0001\u0004i\bbBA\t\u0017\u0001\u0007\u00111C\u0001\u0011g\u0016tGMR3uG\"\u0014V-];fgR$b!!\u0019\u0002h\u0005-\u0004cA+\u0002d%\u0019\u0011Q\r,\u0003\u001b\u0019+Go\u00195SKN\u0004xN\\:f\u0011\u0019\tI\u0007\u0004a\u0001m\u0006AA.Z1eKJLE\rC\u0003a\u0019\u0001\u0007\u0011/A\ftK:$G)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3tiR1\u0011\u0011OA<\u0003\u007f\u00022!VA:\u0013\r\t)H\u0016\u0002\u0015\t\u0016dW\r^3U_BL7m\u001d*fgB|gn]3\t\r\u0001l\u0001\u0019AA=!\r)\u00161P\u0005\u0004\u0003{2&a\u0005#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$\b\u0002CAA\u001bA\u0005\t\u0019A5\u0002\u0019M|7m[3u'\u0016\u0014h/\u001a:\u0002CM,g\u000e\u001a#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005\u001d%fA5\u0002\n.\u0012\u00111\u0012\t\u0005\u0003\u001b\u000b9*\u0004\u0002\u0002\u0010*!\u0011\u0011SAJ\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0016\n\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI*a$\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\fwC2LG-\u0019;f)>\u0004\u0018nY%t\t\u0016dW\r^3e)\r\u0001\u0013q\u0014\u0005\b\u0003C{\u0001\u0019AAR\u0003\u0015!x\u000e]5d!\u0011\t)\"!*\n\t\u0005\u001d\u0016q\u0005\u0002\u0007'R\u0014\u0018N\\4")
public class TopicIdWithOldInterBrokerProtocolTest
extends BaseRequestTest {
    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.InterBrokerProtocolVersionProp(), KAFKA_2_7_IV0$.MODULE$.toString());
        properties.setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.setProperty(KafkaConfig$.MODULE$.DefaultReplicationFactorProp(), "2");
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringBuilder(5).append("rack/").append(properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())).toString());
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.doSetup(testInfo, false);
    }

    @Test
    public void testMetadataTopicIdsWithOldIBP() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        this.createTopicWithAssignment(topic1, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        MetadataResponse resp = this.sendMetadataRequest((MetadataRequest)new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic1, (List)new .colon.colon((Object)topic1, (List)Nil$.MODULE$))).asJava(), true, 10, 10).build(), (Option<SocketServer>)new Some((Object)this.notControllerSocketServer()));
        Assertions.assertEquals((int)1, (int)resp.topicMetadata().size());
        resp.topicMetadata().forEach(topicMetadata -> {
            Assertions.assertEquals((Object)Errors.NONE, (Object)topicMetadata.error());
            Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)topicMetadata.topicId());
        });
    }

    @Test
    public void testFetchTopicIdsWithOldIBPWrongFetchVersion() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        TopicPartition tp0 = new TopicPartition("topic1", 0);
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map topicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)Uuid.randomUuid())}));
        scala.collection.immutable.Map topicNames = (scala.collection.immutable.Map)topicIds.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom());
        TopicIdPartition tidp0 = new TopicIdPartition((Uuid)topicIds.apply((Object)topic1), tp0);
        scala.collection.immutable.Map<Object, Object> leadersMap = this.createTopicWithAssignment(topic1, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        FetchRequest req = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicIdPartition>)new .colon.colon((Object)tidp0, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), ApiKeys.FETCH.latestVersion());
        FetchResponse resp = this.sendFetchRequest(BoxesRunTime.unboxToInt((Object)leadersMap.apply((Object)BoxesRunTime.boxToInteger((int)0))), req);
        LinkedHashMap responseData = resp.responseData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava(), ApiKeys.FETCH.latestVersion());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)resp.error().code());
        Assertions.assertEquals((int)1, (int)responseData.size());
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_ID.code(), (short)((FetchResponseData.PartitionData)responseData.get(tp0)).errorCode());
    }

    @Test
    public void testFetchTopicIdsWithOldIBPCorrectFetchVersion() {
        scala.collection.immutable.Map replicaAssignment = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 0, 1})))}));
        String topic1 = "topic1";
        TopicPartition tp0 = new TopicPartition("topic1", 0);
        int maxResponseBytes = 800;
        int maxPartitionBytes = 190;
        scala.collection.immutable.Map topicIds = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)Uuid.randomUuid())}));
        scala.collection.immutable.Map topicNames = (scala.collection.immutable.Map)topicIds.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap(), Map$.MODULE$.canBuildFrom());
        TopicIdPartition tidp0 = new TopicIdPartition((Uuid)topicIds.apply((Object)topic1), tp0);
        scala.collection.immutable.Map<Object, Object> leadersMap = this.createTopicWithAssignment(topic1, (Map<Object, Seq<Object>>)replicaAssignment, this.createTopicWithAssignment$default$3());
        FetchRequest req = this.createFetchRequest(maxResponseBytes, maxPartitionBytes, (Seq<TopicIdPartition>)new .colon.colon((Object)tidp0, (List)Nil$.MODULE$), (scala.collection.immutable.Map<TopicPartition, Object>)Predef$.MODULE$.Map().empty(), (short)12);
        FetchResponse resp = this.sendFetchRequest(BoxesRunTime.unboxToInt((Object)leadersMap.apply((Object)BoxesRunTime.boxToInteger((int)0))), req);
        Assertions.assertEquals((Object)Errors.NONE, (Object)resp.error());
        LinkedHashMap responseData = resp.responseData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNames).asJava(), (short)12);
        Assertions.assertEquals((short)Errors.NONE.code(), (short)((FetchResponseData.PartitionData)responseData.get(tp0)).errorCode());
    }

    @Test
    public void testDeleteTopicsWithOldIBP() {
        int timeout = 10000;
        this.createTopic("topic-3", 5, 2, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic("topic-4", 1, 2, this.createTopic$default$4(), this.createTopic$default$5());
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopicNames(Arrays.asList((Object[])new String[]{"topic-3", "topic-4"})).setTimeoutMs(timeout)).build();
        DeleteTopicsResponse resp = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        Assertions.assertTrue((boolean)((IterableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(resp.errorCounts()).asScala()).find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TopicIdWithOldInterBrokerProtocolTest.$anonfun$testDeleteTopicsWithOldIBP$1(x$3))).isEmpty(), (String)new StringBuilder(33).append("There should be no errors, found ").append(CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)resp.data().responses()).asScala()).toString());
        request.data().topicNames().forEach(topic -> this.validateTopicIsDeleted((String)topic));
        resp.data().responses().forEach(response -> Assertions.assertEquals((Object)Uuid.ZERO_UUID, (Object)response.topicId()));
    }

    @Test
    public void testDeleteTopicsWithOldIBPUsingIDs() {
        int timeout = 10000;
        this.createTopic("topic-7", 3, 2, this.createTopic$default$4(), this.createTopic$default$5());
        this.createTopic("topic-6", 1, 2, this.createTopic$default$4(), this.createTopic$default$5());
        scala.collection.immutable.Map ids = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-7"), (Object)Uuid.randomUuid()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic-6"), (Object)Uuid.randomUuid())}));
        DeleteTopicsRequest request = (DeleteTopicsRequest)new DeleteTopicsRequest.Builder(new DeleteTopicsRequestData().setTopics(Arrays.asList((Object[])new DeleteTopicsRequestData.DeleteTopicState[]{new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-7")), new DeleteTopicsRequestData.DeleteTopicState().setTopicId((Uuid)ids.apply((Object)"topic-6"))})).setTimeoutMs(timeout)).build();
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        scala.collection.mutable.Map error = (scala.collection.mutable.Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(response.errorCounts()).asScala();
        Assertions.assertEquals((int)2, (Integer)((Integer)error.apply((Object)Errors.UNKNOWN_TOPIC_ID)));
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request, Option<SocketServer> destination) {
        return (MetadataResponse)this.connectAndReceive((AbstractRequest)request, (SocketServer)destination.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.anySocketServer()), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private FetchRequest createFetchRequest(int maxResponseBytes, int maxPartitionBytes, Seq<TopicIdPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap, short version) {
        return (FetchRequest)FetchRequest.Builder.forConsumer((short)version, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(maxPartitionBytes, topicPartitions, offsetMap)).setMaxBytes(maxResponseBytes).build();
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicIdPartition> topicPartitions, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> partitionMap.put(tp.topicPartition(), new FetchRequest.PartitionData(tp.topicId(), BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)tp.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    private FetchResponse sendFetchRequest(int leaderId, FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        return (DeleteTopicsResponse)this.connectAndReceive((AbstractRequest)request, socketServer, this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(DeleteTopicsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.controllerSocketServer();
    }

    /*
     * WARNING - void declaration
     */
    private void validateTopicIsDeleted(String topic) {
        Iterable metadata = (Iterable)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(((MetadataResponse)this.connectAndReceive(new MetadataRequest.Builder((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)topic, (List)Nil$.MODULE$)).asJava(), true).build(), this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(MetadataResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()))).topicMetadata()).asScala();
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TopicIdWithOldInterBrokerProtocolTest.$anonfun$validateTopicIsDeleted$1(metadata, topic)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)TopicIdWithOldInterBrokerProtocolTest.$anonfun$validateTopicIsDeleted$3(topic));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteTopicsWithOldIBP$1(Tuple2 x$3) {
        Object object = x$3._1();
        Errors errors = Errors.NONE;
        return object == null ? errors != null : !object.equals(errors);
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$2(String topic$1, MetadataResponse.TopicMetadata p) {
        if (p.topic().equals(topic$1)) {
            Errors errors = p.error();
            Errors errors2 = Errors.NONE;
            if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$validateTopicIsDeleted$1(Iterable metadata$1, String topic$1) {
        return !metadata$1.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)TopicIdWithOldInterBrokerProtocolTest.$anonfun$validateTopicIsDeleted$2(topic$1, p)));
    }

    public static final /* synthetic */ String $anonfun$validateTopicIsDeleted$3(String topic$1) {
        return new StringBuilder(27).append("The topic ").append(topic$1).append(" should not exist").toString();
    }
}

