/*
 * Decompiled with CFR 0.152.
 */
package kafka.test;

import kafka.test.ClusterConfig;
import kafka.test.ClusterGenerator;
import kafka.test.ClusterInstance;
import kafka.test.annotation.AutoStart;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTemplate;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.ClusterTests;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ClusterTestDefaults(clusterType=Type.ZK)
@ExtendWith(value={ClusterTestExtensions.class})
public class ClusterTestExtensionsTest {
    private final ClusterInstance clusterInstance;
    private final ClusterConfig config;

    ClusterTestExtensionsTest(ClusterInstance clusterInstance, ClusterConfig config) {
        this.clusterInstance = clusterInstance;
        this.config = config;
    }

    static void generate1(ClusterGenerator clusterGenerator) {
        clusterGenerator.accept(ClusterConfig.defaultClusterBuilder().name("Generated Test").build());
    }

    @BeforeEach
    public void beforeEach(ClusterConfig config) {
        Assertions.assertSame((Object)this.config, (Object)config, (String)"Injected objects should be the same");
        config.serverProperties().put("before", "each");
    }

    @AfterEach
    public void afterEach(ClusterConfig config) {
        Assertions.assertSame((Object)this.config, (Object)config, (String)"Injected objects should be the same");
    }

    @ClusterTest
    public void testClusterTest(ClusterConfig config, ClusterInstance clusterInstance) {
        Assertions.assertSame((Object)this.config, (Object)config, (String)"Injected objects should be the same");
        Assertions.assertSame((Object)this.clusterInstance, (Object)clusterInstance, (String)"Injected objects should be the same");
        Assertions.assertEquals((Object)((Object)clusterInstance.clusterType()), (Object)((Object)ClusterInstance.ClusterType.ZK));
        Assertions.assertEquals((Object)clusterInstance.config().serverProperties().getProperty("before"), (Object)"each");
    }

    @ClusterTemplate(value="generate1")
    public void testClusterTemplate() {
        Assertions.assertEquals((Object)((Object)this.clusterInstance.clusterType()), (Object)((Object)ClusterInstance.ClusterType.ZK), (String)"generate1 provided a Zk cluster, so we should see that here");
        Assertions.assertEquals((Object)this.clusterInstance.config().name().orElse(""), (Object)"Generated Test", (String)"generate 1 named this cluster config, so we should see that here");
        Assertions.assertEquals((Object)this.clusterInstance.config().serverProperties().getProperty("before"), (Object)"each");
    }

    @ClusterTests(value={@ClusterTest(name="cluster-tests-1", clusterType=Type.ZK, serverProperties={@ClusterConfigProperty(key="foo", value="bar"), @ClusterConfigProperty(key="spam", value="eggs")}), @ClusterTest(name="cluster-tests-2", clusterType=Type.KRAFT, serverProperties={@ClusterConfigProperty(key="foo", value="baz"), @ClusterConfigProperty(key="spam", value="eggz")})})
    public void testClusterTests() {
        if (this.clusterInstance.clusterType().equals((Object)ClusterInstance.ClusterType.ZK)) {
            Assertions.assertEquals((Object)this.clusterInstance.config().serverProperties().getProperty("foo"), (Object)"bar");
            Assertions.assertEquals((Object)this.clusterInstance.config().serverProperties().getProperty("spam"), (Object)"eggs");
        } else if (this.clusterInstance.clusterType().equals((Object)ClusterInstance.ClusterType.RAFT)) {
            Assertions.assertEquals((Object)this.clusterInstance.config().serverProperties().getProperty("foo"), (Object)"baz");
            Assertions.assertEquals((Object)this.clusterInstance.config().serverProperties().getProperty("spam"), (Object)"eggz");
        } else {
            Assertions.fail((String)("Unknown cluster type " + (Object)((Object)this.clusterInstance.clusterType())));
        }
    }

    @ClusterTest(autoStart=AutoStart.NO)
    public void testNoAutoStart() {
        Assertions.assertThrows(RuntimeException.class, this.clusterInstance::anyBrokerSocketServer);
        this.clusterInstance.start();
        Assertions.assertNotNull((Object)this.clusterInstance.anyBrokerSocketServer());
    }
}

