/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.integration.KafkaServerTestHarness;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.tools.MirrorMaker;
import kafka.tools.MirrorMaker$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001%4AAC\u0006\u0001!!)q\u0003\u0001C\u00011!)1\u0004\u0001C!9!91\u0006\u0001b\u0001\n\u0003a\u0003BB\u001d\u0001A\u0003%Q\u0006C\u0003;\u0001\u0011\u00053\bC\u0003S\u0001\u0011\u00053\u000bC\u0003Y\u0001\u0011\u00051\u000bC\u0003^\u0001\u0011\u00051\u000bC\u0003`\u0001\u0011\u00051K\u0001\u000eNSJ\u0014xN]'bW\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\r\u001b\u0005)Ao\\8mg*\ta\"A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u000e\u0003-Ig\u000e^3he\u0006$\u0018n\u001c8\n\u0005Y\u0019\"AF&bM.\f7+\u001a:wKJ$Vm\u001d;ICJtWm]:\u0002\rqJg.\u001b;?)\u0005I\u0002C\u0001\u000e\u0001\u001b\u0005Y\u0011aD4f]\u0016\u0014\u0018\r^3D_:4\u0017nZ:\u0016\u0003u\u00012AH\u0012&\u001b\u0005y\"B\u0001\u0011\"\u0003)\u0019w\u000e\u001c7fGRLwN\u001c\u0006\u0002E\u0005)1oY1mC&\u0011Ae\b\u0002\u0004'\u0016\f\bC\u0001\u0014*\u001b\u00059#B\u0001\u0015\u000e\u0003\u0019\u0019XM\u001d<fe&\u0011!f\n\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0004fq&$X\rZ\u000b\u0002[A\u0011afN\u0007\u0002_)\u0011\u0001'M\u0001\u0007CR|W.[2\u000b\u0005I\u001a\u0014AC2p]\u000e,(O]3oi*\u0011A'N\u0001\u0005kRLGNC\u00017\u0003\u0011Q\u0017M^1\n\u0005az#!D!u_6L7MQ8pY\u0016\fg.A\u0004fq&$X\r\u001a\u0011\u0002\u000bM,G/\u00169\u0015\u0005q\u0002\u0005CA\u001f?\u001b\u0005\t\u0013BA \"\u0005\u0011)f.\u001b;\t\u000b\u0005+\u0001\u0019\u0001\"\u0002\u0011Q,7\u000f^%oM>\u0004\"a\u0011'\u000e\u0003\u0011S!!\u0012$\u0002\u0007\u0005\u0004\u0018N\u0003\u0002H\u0011\u00069!.\u001e9ji\u0016\u0014(BA%K\u0003\u0015QWO\\5u\u0015\u0005Y\u0015aA8sO&\u0011Q\n\u0012\u0002\t)\u0016\u001cH/\u00138g_\"\u0012Qa\u0014\t\u0003\u0007BK!!\u0015#\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005a\u0004F\u0001\u0004V!\t\u0019e+\u0003\u0002X\t\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001'i\u0016\u001cHoQ8n[&$xJ\u001a4tKR\u001cH\u000b\u001b:poRKW.Z8vi\u0016C8-\u001a9uS>t\u0007FA\u0004[!\t\u00195,\u0003\u0002]\t\n!A+Z:u\u0003!\"Xm\u001d;D_6l\u0017\u000e^(gMN,Go\u001d*f[>4XMT8o\u000bbL7\u000f^3oiR{\u0007/[2tQ\tA!,A\fuKN$8i\\7nCN+\u0007/\u0019:bi\u0016$'+Z4fq\"\u0012\u0011B\u0017\u0015\u0005\u0001\t,w\r\u0005\u0002>G&\u0011A-\t\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017%\u00014\u0002iU\u001bX\r\t;iK\u0002\u001auN\u001c8fGRl#-Y:fI\u0002j\u0015N\u001d:pe6\u000b7.\u001a:!S:\u001cH/Z1eA!\n7.\u0019\u0011N\u001bJJc&I\u0001i\u0003\r\u0019d\u0006\r")
public class MirrorMakerIntegrationTest
extends KafkaServerTestHarness {
    private final AtomicBoolean exited = new AtomicBoolean(false);

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16(), TestUtils$.MODULE$.createBrokerConfigs$default$17()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, new Properties()), Seq$.MODULE$.canBuildFrom());
    }

    public AtomicBoolean exited() {
        return this.exited;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        Exit.setExitProcedure((x$2, x$3) -> this.exited().set(true));
        super.setUp(testInfo);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        try {
            Assertions.assertFalse((boolean)this.exited().get());
        }
        finally {
            Exit.resetExitProcedure();
        }
    }

    @Test
    public void testCommitOffsetsThrowTimeoutException() {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("default.api.timeout.ms", "1");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"any"));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("test", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        Assertions.assertThrows(TimeoutException.class, () -> mirrorMakerConsumer.commit());
    }

    @Test
    public void testCommitOffsetsRemoveNonExistentTopics() {
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        consumerProps.put("default.api.timeout.ms", "2000");
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"any"));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("nonexistent-topic1", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        mirrorMakerConsumer.offsets().put((Object)new TopicPartition("nonexistent-topic2", 0), (Object)BoxesRunTime.boxToLong((long)0L));
        MirrorMaker$.MODULE$.commitOffsets(mirrorMakerConsumer);
        Assertions.assertTrue((boolean)mirrorMakerConsumer.offsets().isEmpty(), (String)"Offsets for non-existent topics should be removed");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testCommaSeparatedRegex() {
        String topic = "new-topic";
        String msg = "a test message";
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        producerProps.put("key.serializer", ByteArraySerializer.class);
        producerProps.put("value.serializer", ByteArraySerializer.class);
        MirrorMaker.MirrorMakerProducer producer = new MirrorMaker.MirrorMakerProducer(true, producerProps);
        MirrorMaker$.MODULE$.producer_$eq(producer);
        MirrorMaker$.MODULE$.producer().send(new ProducerRecord(topic, (Object)msg.getBytes()));
        MirrorMaker$.MODULE$.producer().close();
        Properties consumerProps = new Properties();
        consumerProps.put("group.id", "test-group");
        consumerProps.put("auto.offset.reset", "earliest");
        consumerProps.put("bootstrap.servers", this.bootstrapServers(this.bootstrapServers$default$1()));
        KafkaConsumer consumer = new KafkaConsumer(consumerProps, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        MirrorMaker.ConsumerWrapper mirrorMakerConsumer = new MirrorMaker.ConsumerWrapper((Consumer)consumer, (Option)None$.MODULE$, (Option)new Some((Object)"another_topic,new.*,foo"));
        mirrorMakerConsumer.init();
        try {
            long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
            long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!MirrorMakerIntegrationTest.$anonfun$testCommaSeparatedRegex$1(mirrorMakerConsumer, topic, msg)) {
                void waitUntilTrue_pause;
                void waitUntilTrue_waitTimeMs;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)MirrorMakerIntegrationTest.$anonfun$testCommaSeparatedRegex$2());
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
        }
        finally {
            consumer.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testCommaSeparatedRegex$1(MirrorMaker.ConsumerWrapper mirrorMakerConsumer$2, String topic$1, String msg$1) {
        boolean bl;
        try {
            ConsumerRecord data = mirrorMakerConsumer$2.receive();
            String string = data.topic();
            if ((string != null ? !string.equals(topic$1) : topic$1 != null) || !new String((byte[])data.value()).equals(msg$1)) {
                return false;
            }
            bl = true;
        }
        catch (MirrorMaker.NoRecordsException noRecordsException) {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ String $anonfun$testCommaSeparatedRegex$2() {
        return "MirrorMaker consumer should read the expected message from the expected topic within the timeout";
    }
}

