/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.util.Properties;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.utils.CommandLineUtils$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Predef$;
import scala.collection.Iterable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0012%\u0001%BQ\u0001\r\u0001\u0005\u0002EBQ\u0001\u000e\u0001\u0005\u0002UBQA\u0012\u0001\u0005\u0002UBQ\u0001\u0013\u0001\u0005\u0002UBQA\u0013\u0001\u0005\u0002UBQ\u0001\u0014\u0001\u0005\u0002UBQA\u0014\u0001\u0005\u0002UBq\u0001\u0015\u0001C\u0002\u0013\u0005\u0011\u000b\u0003\u0004[\u0001\u0001\u0006IA\u0015\u0005\b7\u0002\u0011\r\u0011\"\u0001]\u0011\u0019\u0019\u0007\u0001)A\u0005;\"IA\r\u0001a\u0001\u0002\u0004%\t!\u001a\u0005\ni\u0002\u0001\r\u00111A\u0005\u0002UD\u0011\u0002\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0013e\u0004\u0001\u0019!a\u0001\n\u0003Q\bbCA\u0003\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u000fA!\"a\u0003\u0001\u0001\u0004\u0005\t\u0015)\u0003|\u0011)\ti\u0001\u0001a\u0001\u0002\u0004%\t!\u001a\u0005\f\u0003\u001f\u0001\u0001\u0019!a\u0001\n\u0003\t\t\u0002\u0003\u0006\u0002\u0016\u0001\u0001\r\u0011!Q!\n\u0019D!\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0001{\u0011-\tI\u0002\u0001a\u0001\u0002\u0004%\t!a\u0007\t\u0015\u0005}\u0001\u00011A\u0001B\u0003&1\u0010\u0003\u0006\u0002\"\u0001\u0001\r\u00111A\u0005\u0002\u0015D1\"a\t\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002&!Q\u0011\u0011\u0006\u0001A\u0002\u0003\u0005\u000b\u0015\u00024\t\u0015\u0005-\u0002\u00011AA\u0002\u0013\u0005!\u0010C\u0006\u0002.\u0001\u0001\r\u00111A\u0005\u0002\u0005=\u0002BCA\u001a\u0001\u0001\u0007\t\u0011)Q\u0005w\"1\u0011Q\u0007\u0001\u0005\u0002UBa!a\u000e\u0001\t\u0003)\u0004BBA\u001e\u0001\u0011\u0005Q\u0007\u0003\u0004\u0002@\u0001!\t!\u000e\u0005\u0007\u0003\u0007\u0002A\u0011A\u001b\u0003)\r{W.\\1oI2Kg.Z+uS2\u001cH+Z:u\u0015\t)c%A\u0003vi&d7OC\u0001(\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\u0016\u0011\u0005-rS\"\u0001\u0017\u000b\u00035\nQa]2bY\u0006L!a\f\u0017\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t!\u0007\u0005\u00024\u00015\tA%A\tuKN$\b+\u0019:tK\u0016k\u0007\u000f^=Be\u001e$\u0012A\u000e\t\u0003W]J!\u0001\u000f\u0017\u0003\tUs\u0017\u000e\u001e\u0015\u0003\u0005i\u0002\"a\u000f#\u000e\u0003qR!!\u0010 \u0002\u0007\u0005\u0004\u0018N\u0003\u0002@\u0001\u00069!.\u001e9ji\u0016\u0014(BA!C\u0003\u0015QWO\\5u\u0015\u0005\u0019\u0015aA8sO&\u0011Q\t\u0010\u0002\u0005)\u0016\u001cH/\u0001\u0011uKN$\b+\u0019:tK\u0016k\u0007\u000f^=Be\u001e<\u0016\u000e\u001e5O_\u0012+G.[7ji\u0016\u0014\bFA\u0002;\u0003a!Xm\u001d;QCJ\u001cX-R7qif\f%oZ!t-\u0006d\u0017\u000e\u001a\u0015\u0003\ti\n!\u0003^3tiB\u000b'o]3TS:<G.Z!sO\"\u0012QAO\u0001\u000ei\u0016\u001cH\u000fU1sg\u0016\f%oZ:)\u0005\u0019Q\u0014a\t;fgR\u0004\u0016M]:f\u0003J<7oV5uQ6+H\u000e^5qY\u0016$U\r\\5nSR,'o\u001d\u0015\u0003\u000fi\nQ\u0001\u001d:paN,\u0012A\u0015\t\u0003'bk\u0011\u0001\u0016\u0006\u0003+Z\u000bA!\u001e;jY*\tq+\u0001\u0003kCZ\f\u0017BA-U\u0005)\u0001&o\u001c9feRLWm]\u0001\u0007aJ|\u0007o\u001d\u0011\u0002\rA\f'o]3s+\u0005i\u0006C\u00010b\u001b\u0005y&\"\u00011\u0002\u0015)|\u0007\u000f^:j[BdW-\u0003\u0002c?\naq\n\u001d;j_:\u0004\u0016M]:fe\u00069\u0001/\u0019:tKJ\u0004\u0013!C:ue&twm\u00149u+\u00051\u0007c\u00010hS&\u0011\u0001n\u0018\u0002\u000b\u001fB$\u0018n\u001c8Ta\u0016\u001c\u0007C\u00016r\u001d\tYw\u000e\u0005\u0002mY5\tQN\u0003\u0002oQ\u00051AH]8pizJ!\u0001\u001d\u0017\u0002\rA\u0013X\rZ3g\u0013\t\u00118O\u0001\u0004TiJLgn\u001a\u0006\u0003a2\nQb\u001d;sS:<w\n\u001d;`I\u0015\fHC\u0001\u001cw\u0011\u001d9X\"!AA\u0002\u0019\f1\u0001\u001f\u00132\u0003)\u0019HO]5oO>\u0003H\u000fI\u0001\u0007S:$x\n\u001d;\u0016\u0003m\u00042AX4}!\ri\u0018\u0011A\u0007\u0002}*\u0011qPV\u0001\u0005Y\u0006tw-C\u0002\u0002\u0004y\u0014q!\u00138uK\u001e,'/\u0001\u0006j]R|\u0005\u000f^0%KF$2ANA\u0005\u0011\u001d9\b#!AA\u0002m\fq!\u001b8u\u001fB$\b%\u0001\u000btiJLgnZ(qi>\u0003H/[8oC2\f%oZ\u0001\u0019gR\u0014\u0018N\\4PaR|\u0005\u000f^5p]\u0006d\u0017I]4`I\u0015\fHc\u0001\u001c\u0002\u0014!9qoEA\u0001\u0002\u00041\u0017!F:ue&twm\u00149u\u001fB$\u0018n\u001c8bY\u0006\u0013x\rI\u0001\u0012S:$x\n\u001d;PaRLwN\\1m\u0003J<\u0017!F5oi>\u0003Ho\u00149uS>t\u0017\r\\!sO~#S-\u001d\u000b\u0004m\u0005u\u0001bB<\u0017\u0003\u0003\u0005\ra_\u0001\u0013S:$x\n\u001d;PaRLwN\\1m\u0003J<\u0007%A\u000ftiJLgnZ(qi>\u0003H/[8oC2\f%o\u001a(p\t\u00164\u0017-\u001e7u\u0003\u0005\u001aHO]5oO>\u0003Ho\u00149uS>t\u0017\r\\!sO:{G)\u001a4bk2$x\fJ3r)\r1\u0014q\u0005\u0005\bof\t\t\u00111\u0001g\u0003y\u0019HO]5oO>\u0003Ho\u00149uS>t\u0017\r\\!sO:{G)\u001a4bk2$\b%\u0001\u000ej]R|\u0005\u000f^(qi&|g.\u00197Be\u001etu\u000eR3gCVdG/\u0001\u0010j]R|\u0005\u000f^(qi&|g.\u00197Be\u001etu\u000eR3gCVdGo\u0018\u0013fcR\u0019a'!\r\t\u000f]d\u0012\u0011!a\u0001w\u0006Y\u0012N\u001c;PaR|\u0005\u000f^5p]\u0006d\u0017I]4O_\u0012+g-Y;mi\u0002\nAb]3u+B|\u0005\u000f^5p]N\fa\u0005^3ti6\u000b\u0017PY3NKJ<Wm\u00149uS>t7o\u0014<fe^\u0014\u0018\u000e^3Fq&\u001cH/\u001b8hQ\ty\"(A\u0017uKN$X*Y=cK6+'oZ3PaRLwN\\:EK\u001a\fW\u000f\u001c;Pm\u0016\u0014xO]5uK\u0016C\u0018n\u001d;j]\u001eD#\u0001\t\u001e\u0002WQ,7\u000f^'bs\n,W*\u001a:hK>\u0003H/[8og\u0012+g-Y;miZ\u000bG.^3JM:{G/\u0012=jgRD#!\t\u001e\u0002SQ,7\u000f^'bs\n,W*\u001a:hK>\u0003H/[8og:{Go\u0014<fe^\u0014\u0018\u000e^3Fq&\u001cH/\u001b8hQ\t\u0011#\b")
public class CommandLineUtilsTest {
    private final Properties props = new Properties();
    private final OptionParser parser = new OptionParser(false);
    private OptionSpec<String> stringOpt;
    private OptionSpec<Integer> intOpt;
    private OptionSpec<String> stringOptOptionalArg;
    private OptionSpec<Integer> intOptOptionalArg;
    private OptionSpec<String> stringOptOptionalArgNoDefault;
    private OptionSpec<Integer> intOptOptionalArgNoDefault;

    @Test
    public void testParseEmptyArg() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property="});
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), false));
    }

    @Test
    public void testParseEmptyArgWithNoDelimiter() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property"});
        Assertions.assertThrows(IllegalArgumentException.class, () -> CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), false));
    }

    @Test
    public void testParseEmptyArgAsValid() {
        String[] argArray = (String[])((Object[])new String[]{"my.empty.property=", "my.empty.property1"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assertions.assertEquals((Object)props.getProperty("my.empty.property"), (Object)"", (String)"Value of a key with missing value should be an empty string");
        Assertions.assertEquals((Object)props.getProperty("my.empty.property1"), (Object)"", (String)"Value of a key with missing value with no delimiter should be an empty string");
    }

    @Test
    public void testParseSingleArg() {
        String[] argArray = (String[])((Object[])new String[]{"my.property=value"});
        Assertions.assertEquals((Object)CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2()).getProperty("my.property"), (Object)"value", (String)"Value of a single property should be 'value' ");
    }

    @Test
    public void testParseArgs() {
        String[] argArray = (String[])((Object[])new String[]{"first.property=first", "second.property=second"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assertions.assertEquals((Object)props.getProperty("first.property"), (Object)"first", (String)"Value of first property should be 'first'");
        Assertions.assertEquals((Object)props.getProperty("second.property"), (Object)"second", (String)"Value of second property should be 'second'");
    }

    @Test
    public void testParseArgsWithMultipleDelimiters() {
        String[] argArray = (String[])((Object[])new String[]{"first.property==first", "second.property=second=", "third.property=thi=rd"});
        Properties props = CommandLineUtils$.MODULE$.parseKeyValueArgs((Iterable)Predef$.MODULE$.wrapRefArray((Object[])argArray), CommandLineUtils$.MODULE$.parseKeyValueArgs$default$2());
        Assertions.assertEquals((Object)props.getProperty("first.property"), (Object)"=first", (String)"Value of first property should be '=first'");
        Assertions.assertEquals((Object)props.getProperty("second.property"), (Object)"second=", (String)"Value of second property should be 'second='");
        Assertions.assertEquals((Object)props.getProperty("third.property"), (Object)"thi=rd", (String)"Value of second property should be 'thi=rd'");
    }

    public Properties props() {
        return this.props;
    }

    public OptionParser parser() {
        return this.parser;
    }

    public OptionSpec<String> stringOpt() {
        return this.stringOpt;
    }

    public void stringOpt_$eq(OptionSpec<String> x$1) {
        this.stringOpt = x$1;
    }

    public OptionSpec<Integer> intOpt() {
        return this.intOpt;
    }

    public void intOpt_$eq(OptionSpec<Integer> x$1) {
        this.intOpt = x$1;
    }

    public OptionSpec<String> stringOptOptionalArg() {
        return this.stringOptOptionalArg;
    }

    public void stringOptOptionalArg_$eq(OptionSpec<String> x$1) {
        this.stringOptOptionalArg = x$1;
    }

    public OptionSpec<Integer> intOptOptionalArg() {
        return this.intOptOptionalArg;
    }

    public void intOptOptionalArg_$eq(OptionSpec<Integer> x$1) {
        this.intOptOptionalArg = x$1;
    }

    public OptionSpec<String> stringOptOptionalArgNoDefault() {
        return this.stringOptOptionalArgNoDefault;
    }

    public void stringOptOptionalArgNoDefault_$eq(OptionSpec<String> x$1) {
        this.stringOptOptionalArgNoDefault = x$1;
    }

    public OptionSpec<Integer> intOptOptionalArgNoDefault() {
        return this.intOptOptionalArgNoDefault;
    }

    public void intOptOptionalArgNoDefault_$eq(OptionSpec<Integer> x$1) {
        this.intOptOptionalArgNoDefault = x$1;
    }

    public void setUpOptions() {
        this.stringOpt_$eq((OptionSpec<String>)this.parser().accepts("str").withRequiredArg().ofType(String.class).defaultsTo((Object)"default-string", (Object[])new String[0]));
        this.intOpt_$eq((OptionSpec<Integer>)this.parser().accepts("int").withRequiredArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(100), (Object[])new Integer[0]));
        this.stringOptOptionalArg_$eq((OptionSpec<String>)this.parser().accepts("str-opt").withOptionalArg().ofType(String.class).defaultsTo((Object)"default-string-2", (Object[])new String[0]));
        this.intOptOptionalArg_$eq((OptionSpec<Integer>)this.parser().accepts("int-opt").withOptionalArg().ofType(Integer.class).defaultsTo((Object)Predef$.MODULE$.int2Integer(200), (Object[])new Integer[0]));
        this.stringOptOptionalArgNoDefault_$eq((OptionSpec<String>)this.parser().accepts("str-opt-nodef").withOptionalArg().ofType(String.class));
        this.intOptOptionalArgNoDefault_$eq((OptionSpec<Integer>)this.parser().accepts("int-opt-nodef").withOptionalArg().ofType(Integer.class));
    }

    @Test
    public void testMaybeMergeOptionsOverwriteExisting() {
        this.setUpOptions();
        this.props().put("skey", "existing-string");
        this.props().put("ikey", "300");
        this.props().put("sokey", "existing-string-2");
        this.props().put("iokey", "400");
        this.props().put("sondkey", "existing-string-3");
        this.props().put("iondkey", "500");
        OptionSet options = this.parser().parse(new String[]{"--str", "some-string", "--int", "600", "--str-opt", "some-string-2", "--int-opt", "700", "--str-opt-nodef", "some-string-3", "--int-opt-nodef", "800"});
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assertions.assertEquals((Object)"some-string", (Object)this.props().get("skey"));
        Assertions.assertEquals((Object)"600", (Object)this.props().get("ikey"));
        Assertions.assertEquals((Object)"some-string-2", (Object)this.props().get("sokey"));
        Assertions.assertEquals((Object)"700", (Object)this.props().get("iokey"));
        Assertions.assertEquals((Object)"some-string-3", (Object)this.props().get("sondkey"));
        Assertions.assertEquals((Object)"800", (Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsDefaultOverwriteExisting() {
        this.setUpOptions();
        this.props().put("sokey", "existing-string");
        this.props().put("iokey", "300");
        this.props().put("sondkey", "existing-string-2");
        this.props().put("iondkey", "400");
        OptionSet options = this.parser().parse(new String[]{"--str-opt", "--int-opt", "--str-opt-nodef", "--int-opt-nodef"});
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assertions.assertEquals((Object)"default-string-2", (Object)this.props().get("sokey"));
        Assertions.assertEquals((Object)"200", (Object)this.props().get("iokey"));
        Assertions.assertNull((Object)this.props().get("sondkey"));
        Assertions.assertNull((Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsDefaultValueIfNotExist() {
        this.setUpOptions();
        OptionSet options = this.parser().parse(new String[0]);
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assertions.assertEquals((Object)"default-string", (Object)this.props().get("skey"));
        Assertions.assertEquals((Object)"100", (Object)this.props().get("ikey"));
        Assertions.assertEquals((Object)"default-string-2", (Object)this.props().get("sokey"));
        Assertions.assertEquals((Object)"200", (Object)this.props().get("iokey"));
        Assertions.assertNull((Object)this.props().get("sondkey"));
        Assertions.assertNull((Object)this.props().get("iondkey"));
    }

    @Test
    public void testMaybeMergeOptionsNotOverwriteExisting() {
        this.setUpOptions();
        this.props().put("skey", "existing-string");
        this.props().put("ikey", "300");
        this.props().put("sokey", "existing-string-2");
        this.props().put("iokey", "400");
        this.props().put("sondkey", "existing-string-3");
        this.props().put("iondkey", "500");
        OptionSet options = this.parser().parse(new String[0]);
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "skey", options, this.stringOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "ikey", options, this.intOpt());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sokey", options, this.stringOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iokey", options, this.intOptOptionalArg());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "sondkey", options, this.stringOptOptionalArgNoDefault());
        CommandLineUtils$.MODULE$.maybeMergeOptions(this.props(), "iondkey", options, this.intOptOptionalArgNoDefault());
        Assertions.assertEquals((Object)"existing-string", (Object)this.props().get("skey"));
        Assertions.assertEquals((Object)"300", (Object)this.props().get("ikey"));
        Assertions.assertEquals((Object)"existing-string-2", (Object)this.props().get("sokey"));
        Assertions.assertEquals((Object)"400", (Object)this.props().get("iokey"));
        Assertions.assertEquals((Object)"existing-string-3", (Object)this.props().get("sondkey"));
        Assertions.assertEquals((Object)"500", (Object)this.props().get("iondkey"));
    }
}

