/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import kafka.api.EndToEndAuthorizationTest;
import kafka.api.PlaintextEndToEndAuthorizationTest$;
import kafka.api.ZkSasl$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.PlaintextAuthenticationContext;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.DefaultKafkaPrincipalBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ut!B\u000e\u001d\u0011\u0003\tc!B\u0012\u001d\u0011\u0003!\u0003\"B\u0016\u0002\t\u0003a\u0003bB\u0017\u0002\u0001\u0004%IA\f\u0005\b{\u0005\u0001\r\u0011\"\u0003?\u0011\u0019!\u0015\u0001)Q\u0005_!9\u0011*\u0001a\u0001\n\u0013q\u0003b\u0002&\u0002\u0001\u0004%Ia\u0013\u0005\u0007\u001b\u0006\u0001\u000b\u0015B\u0018\u0007\t=\u000b\u0001\u0001\u0015\u0005\u0006W%!\t\u0001\u0019\u0005\u0006G&!\t\u0005\u001a\u0004\u0005a\u0006\u0001\u0011\u000fC\u0003,\u0019\u0011\u0005!\u000fC\u0003d\u0019\u0011\u0005CO\u0002\u0003$9\u00011\b\"B\u0016\u0010\t\u0003Q\b\"\u0002?\u0010\t#j\bbBA\u0002\u001f\u0011E\u0013Q\u0001\u0005\b\u0003'yA\u0011KA\u0003\u0011%\t)b\u0004b\u0001\n\u0003\n9\u0002C\u0004\u0002\u001a=\u0001\u000b\u0011B3\t\u0013\u0005mqB1A\u0005B\u0005]\u0001bBA\u000f\u001f\u0001\u0006I!\u001a\u0005\b\u0003?yA\u0011IA\u0011\u0011\u001d\t\te\u0004C!\u0003\u0007Bq!a\u0012\u0010\t\u0003\tI%\u0001\u0012QY\u0006Lg\u000e^3yi\u0016sG\rV8F]\u0012\fU\u000f\u001e5pe&T\u0018\r^5p]R+7\u000f\u001e\u0006\u0003;y\t1!\u00199j\u0015\u0005y\u0012!B6bM.\f7\u0001\u0001\t\u0003E\u0005i\u0011\u0001\b\u0002#!2\f\u0017N\u001c;fqR,e\u000e\u001a+p\u000b:$\u0017)\u001e;i_JL'0\u0019;j_:$Vm\u001d;\u0014\u0005\u0005)\u0003C\u0001\u0014*\u001b\u00059#\"\u0001\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005):#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002C\u0005\u00112\r\\5f]Rd\u0015n\u001d;f]\u0016\u0014h*Y7f+\u0005y\u0003c\u0001\u00141e%\u0011\u0011g\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005MRdB\u0001\u001b9!\t)t%D\u00017\u0015\t9\u0004%\u0001\u0004=e>|GOP\u0005\u0003s\u001d\na\u0001\u0015:fI\u00164\u0017BA\u001e=\u0005\u0019\u0019FO]5oO*\u0011\u0011hJ\u0001\u0017G2LWM\u001c;MSN$XM\\3s\u001d\u0006lWm\u0018\u0013fcR\u0011qH\u0011\t\u0003M\u0001K!!Q\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0007\u0012\t\t\u00111\u00010\u0003\rAH%M\u0001\u0014G2LWM\u001c;MSN$XM\\3s\u001d\u0006lW\r\t\u0015\u0003\u000b\u0019\u0003\"AJ$\n\u0005!;#\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002%M,'O^3s\u0019&\u001cH/\u001a8fe:\u000bW.Z\u0001\u0017g\u0016\u0014h/\u001a:MSN$XM\\3s\u001d\u0006lWm\u0018\u0013fcR\u0011q\b\u0014\u0005\b\u0007\u001e\t\t\u00111\u00010\u0003M\u0019XM\u001d<fe2K7\u000f^3oKJt\u0015-\\3!Q\tAaI\u0001\u000eUKN$8\t\\5f]R\u0004&/\u001b8dSB\fGNQ;jY\u0012,'o\u0005\u0002\n#B\u0011!KX\u0007\u0002'*\u0011A+V\u0001\u000eCV$\b.\u001a8uS\u000e\fGo\u001c:\u000b\u0005Y;\u0016\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0005aK\u0016AB2p[6|gN\u0003\u0002 5*\u00111\fX\u0001\u0007CB\f7\r[3\u000b\u0003u\u000b1a\u001c:h\u0013\ty6K\u0001\u000fEK\u001a\fW\u000f\u001c;LC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197Ck&dG-\u001a:\u0015\u0003\u0005\u0004\"AY\u0005\u000e\u0003\u0005\tQAY;jY\u0012$\"!Z6\u0011\u0005\u0019LW\"A4\u000b\u0005!,\u0016\u0001B1vi\"L!A[4\u0003\u001d-\u000bgm[1Qe&t7-\u001b9bY\")An\u0003a\u0001[\u000691m\u001c8uKb$\bC\u00014o\u0013\tywMA\u000bBkRDWM\u001c;jG\u0006$\u0018n\u001c8D_:$X\r\u001f;\u00035Q+7\u000f^*feZ,'\u000f\u0015:j]\u000eL\u0007/\u00197Ck&dG-\u001a:\u0014\u00051\tF#A:\u0011\u0005\tdACA3v\u0011\u0015ag\u00021\u0001n'\tyq\u000f\u0005\u0002#q&\u0011\u0011\u0010\b\u0002\u001a\u000b:$Gk\\#oI\u0006+H\u000f[8sSj\fG/[8o)\u0016\u001cH\u000fF\u0001|!\t\u0011s\"\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYV\ta\u0010\u0005\u0002g\u007f&\u0019\u0011\u0011A4\u0003!M+7-\u001e:jif\u0004&o\u001c;pG>d\u0017\u0001\u00047jgR,g.\u001a:OC6,WCAA\u0004!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007/\u00069a.\u001a;x_J\\\u0017\u0002BA\t\u0003\u0017\u0011A\u0002T5ti\u0016tWM\u001d(b[\u0016\fq#\u001b8uKJ\u0014%o\\6fe2K7\u000f^3oKJt\u0015-\\3\u0002\u001f\rd\u0017.\u001a8u!JLgnY5qC2,\u0012!Z\u0001\u0011G2LWM\u001c;Qe&t7-\u001b9bY\u0002\nab[1gW\u0006\u0004&/\u001b8dSB\fG.A\blC\u001a\\\u0017\r\u0015:j]\u000eL\u0007/\u00197!\u0003\u0015\u0019X\r^+q)\ry\u00141\u0005\u0005\b\u0003KA\u0002\u0019AA\u0014\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA\u0015\u0003ki!!a\u000b\u000b\u0007u\tiC\u0003\u0003\u00020\u0005E\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003ga\u0016!\u00026v]&$\u0018\u0002BA\u001c\u0003W\u0011\u0001\u0002V3ti&sgm\u001c\u0015\u00041\u0005m\u0002\u0003BA\u0015\u0003{IA!a\u0010\u0002,\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002!\u0011|7+\u001e9feV\u001cXM]*fiV\u0004HcA \u0002F!9\u0011QE\rA\u0002\u0005\u001d\u0012\u0001\u0005;fgRd\u0015n\u001d;f]\u0016\u0014h*Y7f)\ry\u00141\n\u0005\u0007\u0003\u001bR\u0002\u0019\u0001\u001a\u0002\rE,xN];nQ\u001dQ\u0012\u0011KA1\u0003G\u0002B!a\u0015\u0002^5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0005qe>4\u0018\u000eZ3s\u0015\u0011\tY&!\f\u0002\rA\f'/Y7t\u0013\u0011\ty&!\u0016\u0003\u0017Y\u000bG.^3T_V\u00148-Z\u0001\bgR\u0014\u0018N\\4tY\u0011\t)'!\u001b\"\u0005\u0005\u001d\u0014!B6sC\u001a$\u0018EAA6\u0003\tQ8\u000eK\u0004\u001b\u0003_\n9(!\u001f\u0011\t\u0005E\u00141O\u0007\u0003\u00033JA!!\u001e\u0002Z\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0003\u0003w\n\u0001d\u001f3jgBd\u0017-\u001f(b[\u0016lh&];peVlWh\u001f\u0019~\u0001")
public class PlaintextEndToEndAuthorizationTest
extends EndToEndAuthorizationTest {
    private final KafkaPrincipal clientPrincipal;
    private final KafkaPrincipal kafkaPrincipal;

    @Override
    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    @Override
    public ListenerName listenerName() {
        return new ListenerName("CLIENT");
    }

    @Override
    public ListenerName interBrokerListenerName() {
        return new ListenerName("SERVER");
    }

    @Override
    public KafkaPrincipal clientPrincipal() {
        return this.clientPrincipal;
    }

    @Override
    public KafkaPrincipal kafkaPrincipal() {
        return this.kafkaPrincipal;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.startSasl(this.jaasSections((Seq<String>)List$.MODULE$.empty(), (Option<String>)None$.MODULE$, ZkSasl$.MODULE$, this.jaasSections$default$4()));
        super.setUp(testInfo);
    }

    @Override
    public void doSuperuserSetup(TestInfo testInfo) {
        this.superuserClientConfig().put("bootstrap.servers", this.bootstrapServers(this.interBrokerListenerName()));
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"kraft", "zk"})
    public void testListenerName(String quorum) {
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        Assertions.assertThrows(TopicAuthorizationException.class, () -> this.sendRecords((KafkaProducer<byte[], byte[]>)producer, 1, this.tp()));
        Assertions.assertEquals((Object)new Some((Object)"CLIENT"), PlaintextEndToEndAuthorizationTest$.MODULE$.kafka$api$PlaintextEndToEndAuthorizationTest$$clientListenerName());
        Assertions.assertEquals((Object)new Some((Object)"SERVER"), PlaintextEndToEndAuthorizationTest$.MODULE$.kafka$api$PlaintextEndToEndAuthorizationTest$$serverListenerName());
    }

    public PlaintextEndToEndAuthorizationTest() {
        this.serverConfig().setProperty("listener.name.client.principal.builder.class", TestClientPrincipalBuilder.class.getName());
        this.serverConfig().setProperty("listener.name.server.principal.builder.class", TestServerPrincipalBuilder.class.getName());
        this.clientPrincipal = new KafkaPrincipal("User", "client");
        this.kafkaPrincipal = new KafkaPrincipal("User", "server");
    }

    public static class TestClientPrincipalBuilder
    extends DefaultKafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            PlaintextEndToEndAuthorizationTest$.MODULE$.kafka$api$PlaintextEndToEndAuthorizationTest$$clientListenerName_$eq((Option<String>)new Some((Object)context.listenerName()));
            KafkaPrincipal kafkaPrincipal = context instanceof PlaintextAuthenticationContext && ((PlaintextAuthenticationContext)context).clientAddress() != null ? new KafkaPrincipal("User", "client") : KafkaPrincipal.ANONYMOUS;
            return kafkaPrincipal;
        }

        public TestClientPrincipalBuilder() {
            super(null, null);
        }
    }

    public static class TestServerPrincipalBuilder
    extends DefaultKafkaPrincipalBuilder {
        public KafkaPrincipal build(AuthenticationContext context) {
            PlaintextEndToEndAuthorizationTest$.MODULE$.kafka$api$PlaintextEndToEndAuthorizationTest$$serverListenerName_$eq((Option<String>)new Some((Object)context.listenerName()));
            KafkaPrincipal kafkaPrincipal = context instanceof PlaintextAuthenticationContext ? new KafkaPrincipal("User", "server") : KafkaPrincipal.ANONYMOUS;
            return kafkaPrincipal;
        }

        public TestServerPrincipalBuilder() {
            super(null, null);
        }
    }
}

