/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.BrokerMetadataCheckpoint$;
import kafka.server.MetaProperties;
import kafka.server.MetaProperties$;
import kafka.server.RawMetaProperties;
import kafka.server.RawMetaProperties$;
import kafka.server.ZkMetaProperties;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015c\u0001\u0002\f\u0018\u0001qAQ!\u000b\u0001\u0005\u0002)Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00048\u0001\u0001\u0006Ia\f\u0005\u0006q\u0001!\t!\u000f\u0005\u0006\u0015\u0002!\t!\u000f\u0005\u0006\u0019\u0002!\t!\u000f\u0005\u0006\u001d\u0002!\t!\u000f\u0005\u0006!\u0002!\t!\u000f\u0005\u0006%\u0002!\t!\u000f\u0005\u0006)\u0002!\t!\u000f\u0005\u0006-\u0002!\t!\u000f\u0005\u00061\u0002!I!\u0017\u0005\u0006M\u0002!\t!\u000f\u0005\u0006Q\u0002!\t!\u000f\u0005\u0006U\u0002!\t!\u000f\u0005\u0006Y\u0002!\t!\u000f\u0005\u0006]\u0002!\t!\u000f\u0005\u0006a\u0002!I!\u001d\u0005\u0007\u0003?\u0001A\u0011A\u001d\t\r\u0005\r\u0002\u0001\"\u0001:\u0011\u001d\t9\u0003\u0001C\u0005\u0003S\u0011AD\u0011:pW\u0016\u0014X*\u001a;bI\u0006$\u0018m\u00115fG.\u0004x.\u001b8u)\u0016\u001cHO\u0003\u0002\u00193\u000511/\u001a:wKJT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019J\u0012!B;uS2\u001c\u0018B\u0001\u0015&\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0016\u0011\u00051\u0002Q\"A\f\u0002\u001f\rdWo\u001d;fe&#')Y:fmQ*\u0012a\f\t\u0003aUj\u0011!\r\u0006\u0003eM\nA\u0001\\1oO*\tA'\u0001\u0003kCZ\f\u0017B\u0001\u001c2\u0005\u0019\u0019FO]5oO\u0006\u00012\r\\;ti\u0016\u0014\u0018\n\u001a\"bg\u00164D\u0007I\u0001\u001ci\u0016\u001cHOU3bI^KG\u000f\u001b(p]\u0016C\u0018n\u001d;f]R4\u0015\u000e\\3\u0015\u0003i\u0002\"AH\u001e\n\u0005qz\"\u0001B+oSRD#\u0001\u0002 \u0011\u0005}BU\"\u0001!\u000b\u0005\u0005\u0013\u0015aA1qS*\u00111\tR\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)e)A\u0003kk:LGOC\u0001H\u0003\ry'oZ\u0005\u0003\u0013\u0002\u0013A\u0001V3ti\u0006qB/Z:u\u0007J,\u0017\r^3[W6+G/\u00193bi\u0006\u0004&o\u001c9feRLWm\u001d\u0015\u0003\u000by\n\u0001\u0006^3tiB\u000b'o]3SC^lU\r^1Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5pkR4VM]:j_:D#A\u0002 \u0002IQ,7\u000f\u001e*boB\u0013x\u000e]3si&,7oV5uQ&sg/\u00197jI\n\u0013xn[3s\u0013\u0012D#a\u0002 \u00029Q,7\u000f^\"sK\u0006$X-T3uC\u0012\fG/\u0019)s_B,'\u000f^5fg\"\u0012\u0001BP\u0001%i\u0016\u001cH/T3uCB\u0013x\u000e]3si&,7oV5uQ6K7o]5oOZ+'o]5p]\"\u0012\u0011BP\u0001(i\u0016\u001cH/T3uCB\u0013x\u000e]3si&,7/\u00117m_^\u001c\b*\u001a=F]\u000e|G-\u001a3V+&#5\u000f\u000b\u0002\u000b}\u00051C/Z:u\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t/&$\bNT8o+VLGm\u00117vgR,'/\u00133)\u0005-q\u0014!H2p]\u001aL'/\u001c,bY&$gi\u001c:NKR\f\u0007K]8qKJ$\u0018.Z:\u0015\u0005iR\u0006\"B.\r\u0001\u0004a\u0016!C2mkN$XM]%e!\tiFM\u0004\u0002_EB\u0011qlH\u0007\u0002A*\u0011\u0011mG\u0001\u0007yI|w\u000e\u001e \n\u0005\r|\u0012A\u0002)sK\u0012,g-\u0003\u00027K*\u00111mH\u0001&i\u0016\u001cH/T3uCB\u0013x\u000e]3si&,7oV5uQ6K7o]5oO\n\u0013xn[3s\u0013\u0012D#!\u0004 \u0002SQ,7\u000f^'fi\u0006\u0004&o\u001c9feRLWm],ji\"l\u0015n]:j]\u001e\u001cuN\u001c;s_2dWM]%eQ\tqa(A\u0011uKN$X*\u001a;b!J|\u0007/\u001a:uS\u0016\u001cx+\u001b;i-\u0016\u00148/[8o5\u0016\u0014x\u000e\u000b\u0002\u0010}\u0005!D/Z:u-\u0006d\u0017\u000eZ'fi\u0006\u0004&o\u001c9feRLWm],ji\"lU\u000f\u001c;ja2,g+\u001a:tS>t7/\u00138M_\u001e$\u0015N]:)\u0005Aq\u0014A\u000e;fgRLeN^1mS\u0012lU\r^1Qe>\u0004XM\u001d;jKN<\u0016\u000e\u001e5Nk2$\u0018\u000e\u001d7f-\u0016\u00148/[8og&sGj\\4ESJ\u001c\bFA\t?\u0003\u0019:W\r^'fi\u0006$\u0017\r^1XSRDW*\u001e7uSBdW-T3uCB\u0013x\u000e\u001d'pO\u0012K'o\u001d\u000b\u0007ez\f\t\"a\u0007\u0011\ty\u0019X\u000f_\u0005\u0003i~\u0011a\u0001V;qY\u0016\u0014\u0004C\u0001\u0017w\u0013\t9xCA\tSC^lU\r^1Qe>\u0004XM\u001d;jKN\u00042!\u001f?]\u001b\u0005Q(BA> \u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003{j\u00141aU3r\u0011\u0019y(\u00031\u0001\u0002\u0002\u0005qQ.\u001a;b!J|\u0007/\u001a:uS\u0016\u001c\b#BA\u0002\u0003\u001b)h\u0002BA\u0003\u0003\u0013q1aXA\u0004\u0013\u0005\u0001\u0013bAA\u0006?\u00059\u0001/Y2lC\u001e,\u0017bA?\u0002\u0010)\u0019\u00111B\u0010\t\u000f\u0005M!\u00031\u0001\u0002\u0016\u0005i\u0011n\u001a8pe\u0016l\u0015n]:j]\u001e\u00042AHA\f\u0013\r\tIb\b\u0002\b\u0005>|G.Z1o\u0011\u001d\tiB\u0005a\u0001\u0003+\t\u0011b\u001b:bMRlu\u000eZ3\u0002{Q,7\u000f^$fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\u0006sGm\u00144gY&tW\rR5sg^KG\u000f\u001b(p]\u0016D\u0018n\u001d;f]R$\u0015N]3di>\u0014\u0018.Z:)\u0005Mq\u0014\u0001\r;fgR<U\r\u001e\"s_.,'/T3uC\u0012\fG/Y!oI>3g\r\\5oK\u0012K'o]%h]>\u0014X-T5tg&tw\r\u000b\u0002\u0015}\u0005AC/Z:u\u000b6\u0004H/_$fi\n\u0013xn[3s\u001b\u0016$\u0018\rZ1uC\u0006sGm\u00144gY&tW\rR5sgRI!(a\u000b\u0002<\u0005\u0005\u00131\t\u0005\b\u0003[)\u0002\u0019AA\u0018\u0003\u0019awn\u001a#jeB!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026M\n!![8\n\t\u0005e\u00121\u0007\u0002\u0005\r&dW\rC\u0004\u0002>U\u0001\r!a\u0010\u0002'\u0015D\b/Z2uK\u0012|eM\u001a7j]\u0016$\u0015N]:\u0011\r\u0005\r\u0011QBA\u0018\u0011\u001d\t\u0019\"\u0006a\u0001\u0003+Aq!!\b\u0016\u0001\u0004\t)\u0002")
public class BrokerMetadataCheckpointTest
implements Logging {
    private final String clusterIdBase64;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private String clusterIdBase64() {
        return this.clusterIdBase64;
    }

    @Test
    public void testReadWithNonExistentFile() {
        Assertions.assertEquals((Object)None$.MODULE$, (Object)new BrokerMetadataCheckpoint(new File("path/that/does/not/exist")).read());
    }

    @Test
    public void testCreateZkMetadataProperties() {
        ZkMetaProperties meta = new ZkMetaProperties("7bc79ca1-9746-42a3-a35a-efb3cde44492", 3);
        Properties properties = meta.toProperties();
        RawMetaProperties parsed = new RawMetaProperties(properties);
        Assertions.assertEquals((int)0, (int)parsed.version());
        Assertions.assertEquals((Object)new Some((Object)meta.clusterId()), (Object)parsed.clusterId());
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)meta.brokerId())), (Object)parsed.brokerId());
    }

    @Test
    public void testParseRawMetaPropertiesWithoutVersion() {
        int brokerId = 1;
        String clusterId = "7bc79ca1-9746-42a3-a35a-efb3cde44492";
        Properties properties = new Properties();
        properties.put(RawMetaProperties$.MODULE$.BrokerIdKey(), Integer.toString(brokerId));
        properties.put(RawMetaProperties$.MODULE$.ClusterIdKey(), clusterId);
        RawMetaProperties parsed = new RawMetaProperties(properties);
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)brokerId)), (Object)parsed.brokerId());
        Assertions.assertEquals((Object)new Some((Object)clusterId), (Object)parsed.clusterId());
        Assertions.assertEquals((int)0, (int)parsed.version());
    }

    @Test
    public void testRawPropertiesWithInvalidBrokerId() {
        Properties properties = new Properties();
        properties.put(RawMetaProperties$.MODULE$.BrokerIdKey(), "oof");
        RawMetaProperties parsed = new RawMetaProperties(properties);
        Assertions.assertThrows(RuntimeException.class, () -> parsed.brokerId());
    }

    @Test
    public void testCreateMetadataProperties() {
        this.confirmValidForMetaProperties(this.clusterIdBase64());
    }

    @Test
    public void testMetaPropertiesWithMissingVersion() {
        RawMetaProperties properties = new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1());
        properties.clusterId_$eq(this.clusterIdBase64());
        properties.nodeId_$eq(1);
        Assertions.assertThrows(RuntimeException.class, () -> MetaProperties$.MODULE$.parse(properties));
    }

    @Test
    public void testMetaPropertiesAllowsHexEncodedUUIDs() {
        String clusterId = "7bc79ca1-9746-42a3-a35a-efb3cde44492";
        this.confirmValidForMetaProperties(clusterId);
    }

    @Test
    public void testMetaPropertiesWithNonUuidClusterId() {
        String clusterId = "not a valid uuid";
        this.confirmValidForMetaProperties(clusterId);
    }

    private void confirmValidForMetaProperties(String clusterId) {
        MetaProperties meta = new MetaProperties(clusterId, 5);
        RawMetaProperties properties = new RawMetaProperties(meta.toProperties());
        MetaProperties meta2 = MetaProperties$.MODULE$.parse(properties);
        Assertions.assertEquals((Object)meta, (Object)meta2);
    }

    @Test
    public void testMetaPropertiesWithMissingBrokerId() {
        RawMetaProperties properties = new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1());
        properties.version_$eq(1);
        properties.clusterId_$eq(this.clusterIdBase64());
        Assertions.assertThrows(RuntimeException.class, () -> MetaProperties$.MODULE$.parse(properties));
    }

    @Test
    public void testMetaPropertiesWithMissingControllerId() {
        RawMetaProperties properties = new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1());
        properties.version_$eq(1);
        properties.clusterId_$eq(this.clusterIdBase64());
        Assertions.assertThrows(RuntimeException.class, () -> MetaProperties$.MODULE$.parse(properties));
    }

    @Test
    public void testMetaPropertiesWithVersionZero() {
        RawMetaProperties properties = new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1());
        properties.version_$eq(0);
        properties.clusterId_$eq(this.clusterIdBase64());
        properties.brokerId_$eq(5);
        MetaProperties metaProps = MetaProperties$.MODULE$.parse(properties);
        Assertions.assertEquals((Object)this.clusterIdBase64(), (Object)metaProps.clusterId());
        Assertions.assertEquals((int)5, (int)metaProps.nodeId());
    }

    @Test
    public void testValidMetaPropertiesWithMultipleVersionsInLogDirs() {
        RawMetaProperties props1 = new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1());
        props1.version_$eq(0);
        props1.clusterId_$eq(this.clusterIdBase64());
        props1.brokerId_$eq(5);
        RawMetaProperties props2 = new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1());
        props2.version_$eq(1);
        props2.clusterId_$eq(this.clusterIdBase64());
        props2.nodeId_$eq(5);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)ignoreMissing -> {
            BrokerMetadataCheckpointTest.$anonfun$testValidMetaPropertiesWithMultipleVersionsInLogDirs$1(this, props1, props2, BoxesRunTime.unboxToBoolean((Object)ignoreMissing));
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testInvalidMetaPropertiesWithMultipleVersionsInLogDirs() {
        RawMetaProperties props1 = new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1());
        props1.version_$eq(0);
        props1.brokerId_$eq(5);
        RawMetaProperties props2 = new RawMetaProperties(RawMetaProperties$.MODULE$.$lessinit$greater$default$1());
        props2.version_$eq(1);
        props2.clusterId_$eq(this.clusterIdBase64());
        props2.nodeId_$eq(5);
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)ignoreMissing -> BrokerMetadataCheckpointTest.$anonfun$testInvalidMetaPropertiesWithMultipleVersionsInLogDirs$1(this, props1, props2, BoxesRunTime.unboxToBoolean((Object)ignoreMissing)));
    }

    private Tuple2<RawMetaProperties, Seq<String>> getMetadataWithMultipleMetaPropLogDirs(Seq<RawMetaProperties> metaProperties, boolean ignoreMissing, boolean kraftMode) {
        Tuple2 tuple2;
        Buffer logDirs = (Buffer)Buffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        try {
            metaProperties.foreach((Function1 & Serializable & scala.Serializable)mp -> {
                BrokerMetadataCheckpointTest.$anonfun$getMetadataWithMultipleMetaPropLogDirs$1(logDirs, mp);
                return BoxedUnit.UNIT;
            });
            tuple2 = BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs((Seq)logDirs.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getAbsolutePath(), Buffer$.MODULE$.canBuildFrom()), ignoreMissing, kraftMode);
        }
        finally {
            logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Utils.delete((File)logDir), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
                return BoxedUnit.UNIT;
            });
        }
        return tuple2;
    }

    @Test
    public void testGetBrokerMetadataAndOfflineDirsWithNonexistentDirectories() {
        File invalidDir = TestUtils.tempFile((String)"blah");
        try {
            this.testEmptyGetBrokerMetadataAndOfflineDirs(invalidDir, (Seq<File>)new .colon.colon((Object)invalidDir, (List)Nil$.MODULE$), true, true);
            this.testEmptyGetBrokerMetadataAndOfflineDirs(invalidDir, (Seq<File>)new .colon.colon((Object)invalidDir, (List)Nil$.MODULE$), false, true);
        }
        finally {
            Utils.delete((File)invalidDir);
        }
    }

    @Test
    public void testGetBrokerMetadataAndOfflineDirsIgnoreMissing() {
        File tempDir = TestUtils.tempDirectory();
        try {
            this.testEmptyGetBrokerMetadataAndOfflineDirs(tempDir, (Seq<File>)Nil$.MODULE$, true, true);
            this.testEmptyGetBrokerMetadataAndOfflineDirs(tempDir, (Seq<File>)Nil$.MODULE$, true, false);
            Assertions.assertThrows(RuntimeException.class, () -> BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs((Seq)new .colon.colon((Object)tempDir.getAbsolutePath(), (List)Nil$.MODULE$), false, false));
            Assertions.assertThrows(RuntimeException.class, () -> BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs((Seq)new .colon.colon((Object)tempDir.getAbsolutePath(), (List)Nil$.MODULE$), false, true));
        }
        finally {
            Utils.delete((File)tempDir);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void testEmptyGetBrokerMetadataAndOfflineDirs(File logDir, Seq<File> expectedOfflineDirs, boolean ignoreMissing, boolean kraftMode) {
        void var7_7;
        void var6_6;
        Tuple2 tuple2 = BrokerMetadataCheckpoint$.MODULE$.getBrokerMetadataAndOfflineDirs((Seq)new .colon.colon((Object)logDir.getAbsolutePath(), (List)Nil$.MODULE$), ignoreMissing, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RawMetaProperties metaProperties = (RawMetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        void metaProperties2 = var6_6;
        void offlineDirs2 = var7_7;
        Assertions.assertEquals((Object)expectedOfflineDirs.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getAbsolutePath(), Seq$.MODULE$.canBuildFrom()), (Object)offlineDirs2);
        Assertions.assertEquals((Object)new Properties(), (Object)metaProperties2.props());
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testValidMetaPropertiesWithMultipleVersionsInLogDirs$1(BrokerMetadataCheckpointTest $this, RawMetaProperties props1$1, RawMetaProperties props2$1, boolean ignoreMissing) {
        void var6_6;
        void var5_5;
        Tuple2<RawMetaProperties, Seq<String>> tuple2 = $this.getMetadataWithMultipleMetaPropLogDirs((Seq<RawMetaProperties>)new .colon.colon((Object)props1$1, (List)new .colon.colon((Object)props2$1, (List)Nil$.MODULE$)), ignoreMissing, true);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        RawMetaProperties metaProps = (RawMetaProperties)tuple2._1();
        Seq offlineDirs = (Seq)tuple2._2();
        void metaProps2 = var5_5;
        void offlineDirs2 = var6_6;
        Assertions.assertEquals((Object)MetaProperties$.MODULE$.parse(props2$1), (Object)MetaProperties$.MODULE$.parse((RawMetaProperties)metaProps2));
        Assertions.assertEquals((Object)Nil$.MODULE$, (Object)offlineDirs2);
    }

    public static final /* synthetic */ RuntimeException $anonfun$testInvalidMetaPropertiesWithMultipleVersionsInLogDirs$1(BrokerMetadataCheckpointTest $this, RawMetaProperties props1$2, RawMetaProperties props2$2, boolean ignoreMissing) {
        return (RuntimeException)Assertions.assertThrows(RuntimeException.class, () -> $this.getMetadataWithMultipleMetaPropLogDirs((Seq<RawMetaProperties>)new .colon.colon((Object)props1$2, (List)new .colon.colon((Object)props2$2, (List)Nil$.MODULE$)), ignoreMissing, true));
    }

    public static final /* synthetic */ void $anonfun$getMetadataWithMultipleMetaPropLogDirs$1(Buffer logDirs$1, RawMetaProperties mp) {
        File logDir = TestUtils.tempDirectory();
        logDirs$1.$plus$eq((Object)logDir);
        File propFile = new File(logDir.getAbsolutePath(), "meta.properties");
        FileOutputStream fs = new FileOutputStream(propFile);
        try {
            mp.props().store(fs, "");
            fs.flush();
            fs.getFD().sync();
        }
        finally {
            Utils.closeQuietly((AutoCloseable)fs, (String)propFile.getName());
        }
    }

    public BrokerMetadataCheckpointTest() {
        Logging.$init$((Logging)this);
        this.clusterIdBase64 = "H3KKO4NTRPaCWtEmm3vW7A";
    }
}

