/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Properties;
import kafka.log.LogConfig$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMb\u0001B\f\u0019\u0001uAQA\t\u0001\u0005\u0002\rB\u0011\"\n\u0001A\u0002\u0003\u0007I\u0011\u0002\u0014\t\u0013\u0001\u0003\u0001\u0019!a\u0001\n\u0013\t\u0005\"\u0003%\u0001\u0001\u0004\u0005\t\u0015)\u0003(\u0011\u0015I\u0005\u0001\"\u0011K\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0011\u00151\u0007\u0001\"\u0015h\u0011\u0015\u0011\b\u0001\"\u0003b\u0011\u0015\u0019\b\u0001\"\u0003u\u0011%\ty\u0001AI\u0001\n\u0013\t\t\u0002C\u0005\u0002(\u0001\t\n\u0011\"\u0003\u0002*!9\u0011Q\u0006\u0001\u0005\n\u0005=\u0002\"CA?\u0001E\u0005I\u0011BA@\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCa!a'\u0001\t\u0003\t\u0007BBAS\u0001\u0011\u0005\u0011\r\u0003\u0004\u0002*\u0002!\t!\u0019\u0005\b\u0003[\u0003A\u0011AAX\u0011\u001d\t\u0019\u000f\u0001C\u0001\u0003KDq!a<\u0001\t\u0003\t\t\u0010C\u0004\u0002~\u0002!I!a@\u0003I\u0019+Go\u00195SKF,Xm\u001d;E_^t7i\u001c8wKJ\u001c\u0018n\u001c8D_:4\u0017n\u001a+fgRT!!\u0007\u000e\u0002\rM,'O^3s\u0015\u0005Y\u0012!B6bM.\f7\u0001A\n\u0003\u0001y\u0001\"a\b\u0011\u000e\u0003aI!!\t\r\u0003\u001f\t\u000b7/\u001a*fcV,7\u000f\u001e+fgR\fa\u0001P5oSRtD#\u0001\u0013\u0011\u0005}\u0001\u0011\u0001\u00039s_\u0012,8-\u001a:\u0016\u0003\u001d\u0002B\u0001K\u00194g5\t\u0011F\u0003\u0002&U)\u00111\u0006L\u0001\bG2LWM\u001c;t\u0015\tYRF\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<\u0017B\u0001\u001a*\u00055Y\u0015MZ6b!J|G-^2feB\u0011A'\u0010\b\u0003km\u0002\"AN\u001d\u000e\u0003]R!\u0001\u000f\u000f\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qJ\u0014\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHC\u0001\"G!\t\u0019E)D\u0001:\u0013\t)\u0015H\u0001\u0003V]&$\bbB$\u0004\u0003\u0003\u0005\raJ\u0001\u0004q\u0012\n\u0014!\u00039s_\u0012,8-\u001a:!\u0003-\u0011'o\\6fe\u000e{WO\u001c;\u0016\u0003-\u0003\"a\u0011'\n\u00055K$aA%oi\u0006)1/\u001a;VaR\u0011!\t\u0015\u0005\u0006#\u001a\u0001\rAU\u0001\ti\u0016\u001cH/\u00138g_B\u00111KW\u0007\u0002)*\u0011QKV\u0001\u0004CBL'BA,Y\u0003\u001dQW\u000f]5uKJT!!W\u0018\u0002\u000b),h.\u001b;\n\u0005m#&\u0001\u0003+fgRLeNZ8)\u0005\u0019i\u0006CA*_\u0013\tyFK\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0002\u0005\"\u0012qa\u0019\t\u0003'\u0012L!!\u001a+\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u00062s_.,'\u000f\u0015:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t\u0011\u0005\u000eC\u0003j\u0011\u0001\u0007!.\u0001\u0006qe>\u0004XM\u001d;jKN\u0004\"a\u001b9\u000e\u00031T!!\u001c8\u0002\tU$\u0018\u000e\u001c\u0006\u0002_\u0006!!.\u0019<b\u0013\t\tHN\u0001\u0006Qe>\u0004XM\u001d;jKN\fA\"\u001b8jiB\u0013x\u000eZ;dKJ\fAb\u0019:fCR,Gk\u001c9jGN$\u0002\"\u001e@\u0002\u0002\u0005\u0015\u00111\u0002\t\u0005iYD8*\u0003\u0002x\u007f\t\u0019Q*\u00199\u0011\u0005edX\"\u0001>\u000b\u0005md\u0013AB2p[6|g.\u0003\u0002~u\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007\"B@\u000b\u0001\u0004Y\u0015!\u00038v[R{\u0007/[2t\u0011\u0019\t\u0019A\u0003a\u0001\u0017\u0006ia.^7QCJ$\u0018\u000e^5p]ND\u0011\"a\u0002\u000b!\u0003\u0005\r!!\u0003\u0002\u000f\r|gNZ5hgB!AG^\u001a4\u0011!\tiA\u0003I\u0001\u0002\u0004Y\u0015\u0001\u0005;pa&\u001c7+\u001e4gSb\u001cF/\u0019:u\u0003Y\u0019'/Z1uKR{\u0007/[2tI\u0011,g-Y;mi\u0012\u001aTCAA\nU\u0011\tI!!\u0006,\u0005\u0005]\u0001\u0003BA\r\u0003Gi!!a\u0007\u000b\t\u0005u\u0011qD\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\t:\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003K\tYBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fac\u0019:fCR,Gk\u001c9jGN$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003WQ3aSA\u000b\u0003I\u0019'/Z1uKB\u000b'\u000f^5uS>tW*\u00199\u0015\u0015\u0005E\u00121JA(\u0003K\n\t\b\u0005\u0004l\u0003gA\u0018qG\u0005\u0004\u0003ka'!\u0004'j].,G\rS1tQ6\u000b\u0007\u000f\u0005\u0003\u0002:\u0005\u0015c\u0002BA\u001e\u0003\u0003j!!!\u0010\u000b\u0007\u0005}\"0\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\t\u0019%!\u0010\u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\t\u0005\u001d\u0013\u0011\n\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\t\u0005\r\u0013Q\b\u0005\u0007\u0003\u001bj\u0001\u0019A&\u0002#5\f\u0007\u0010U1si&$\u0018n\u001c8CsR,7\u000fC\u0004\u0002R5\u0001\r!a\u0015\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004R!!\u0016\u0002`atA!a\u0016\u0002\\9\u0019a'!\u0017\n\u0003iJ1!!\u0018:\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0019\u0002d\t\u00191+Z9\u000b\u0007\u0005u\u0013\bC\u0004\u0002h5\u0001\r!!\u001b\u0002\u0011Q|\u0007/[2JIN\u0004R\u0001\u000e<4\u0003W\u00022!_A7\u0013\r\tyG\u001f\u0002\u0005+VLG\rC\u0005\u0002t5\u0001\n\u00111\u0001\u0002v\u0005IqN\u001a4tKRl\u0015\r\u001d\t\u0006iYD\u0018q\u000f\t\u0004\u0007\u0006e\u0014bAA>s\t!Aj\u001c8h\u0003q\u0019'/Z1uKB\u000b'\u000f^5uS>tW*\u00199%I\u00164\u0017-\u001e7uIQ*\"!!!+\t\u0005U\u0014QC\u0001\u0011g\u0016tGMR3uG\"\u0014V-];fgR$b!a\"\u0002\u000e\u0006E\u0005\u0003BA\u001e\u0003\u0013KA!a#\u0002>\tia)\u001a;dQJ+7\u000f]8og\u0016Da!a$\u0010\u0001\u0004Y\u0015\u0001\u00037fC\u0012,'/\u00133\t\u000f\u0005Mu\u00021\u0001\u0002\u0016\u00069!/Z9vKN$\b\u0003BA\u001e\u0003/KA!!'\u0002>\taa)\u001a;dQJ+\u0017/^3ti\u0006)C/Z:u-F2U\r^2i/&$\b\u000eR8x]\u000e{gN^3sg&|g\u000eR5tC\ndW\r\u001a\u0015\u0004!\u0005}\u0005cA*\u0002\"&\u0019\u00111\u0015+\u0003\tQ+7\u000f^\u0001*i\u0016\u001cH\u000fT1uKN$h)\u001a;dQ^KG\u000f\u001b#po:\u001cuN\u001c<feNLwN\u001c#jg\u0006\u0014G.\u001a3)\u0007E\ty*A\u0011uKN$h+\r\u001aXSRDGi\\<o\u0007>tg/\u001a:tS>tG)[:bE2,G\rK\u0002\u0013\u0003?\u000bq\u0003^3tiZ\u000bd)\u001a;dQ\u001a\u0013x.\\\"p]N,X.\u001a:\u0015\u0007\t\u000b\t\f\u0003\u0004\u00024N\u0001\raM\u0001\u0007cV|'/^7)\u000fM\t9,a2\u0002JB!\u0011\u0011XAb\u001b\t\tYL\u0003\u0003\u0002>\u0006}\u0016\u0001\u00039s_ZLG-\u001a:\u000b\u0007\u0005\u0005g+\u0001\u0004qCJ\fWn]\u0005\u0005\u0003\u000b\fYLA\u0006WC2,XmU8ve\u000e,\u0017aB:ue&twm\u001d\u0017\u0005\u0003\u0017\fy-\t\u0002\u0002N\u0006\u0011!p[\u0011\u0003\u0003#\fQa\u001b:bMRDsaEAk\u0003;\fy\u000e\u0005\u0003\u0002X\u0006eWBAA`\u0013\u0011\tY.a0\u0003#A\u000b'/Y7fi\u0016\u0014\u0018N_3e)\u0016\u001cH/\u0001\u0003oC6,\u0017EAAq\u0003aYH-[:qY\u0006Lh*Y7f{:\nXo\u001c:v[vZ\b'`\u0001\u0017i\u0016\u001cHOV\u0019GKR\u001c\u0007N\u0012:p[J+\u0007\u000f\\5dCR\u0019!)a:\t\r\u0005MF\u00031\u00014Q\u001d!\u0012qWAd\u0003WdC!a3\u0002P\":A#!6\u0002^\u0006}\u0017a\u0003;fgR4\u0016GR3uG\"$2AQAz\u0011\u001d\t)0\u0006a\u0001\u0003o\fq\"[:G_2dwn^3s\r\u0016$8\r\u001b\t\u0004\u0007\u0006e\u0018bAA~s\t9!i\\8mK\u0006t\u0017!C:f]\u00124U\r^2i)1\u0011\tA!\u0006\u0003\u0018\tm!q\u0004B\u0015!\u0019Y\u00171\u0007=\u0003\u0004A!!Q\u0001B\t\u001d\u0011\u00119A!\u0004\u000e\u0005\t%!b\u0001B\u0006u\u00069Q.Z:tC\u001e,\u0017\u0002\u0002B\b\u0005\u0013\t\u0011CR3uG\"\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\t9Ea\u0005\u000b\t\t=!\u0011\u0002\u0005\u0007\u0003\u001f3\u0002\u0019A&\t\u000f\tea\u00031\u0001\u0002T\u0005Q\u0001/\u0019:uSRLwN\\:\t\u000f\tua\u00031\u0001\u0002j\u0005QAo\u001c9jG&#W*\u00199\t\u000f\t\u0005b\u00031\u0001\u0003$\u0005aa-\u001a;dQZ+'o]5p]B\u00191I!\n\n\u0007\t\u001d\u0012HA\u0003TQ>\u0014H\u000fC\u0004\u0003,Y\u0001\rA!\f\u0002\u0019I,\u0007\u000f\\5dC&#w\n\u001d;\u0011\t\r\u0013ycS\u0005\u0004\u0005cI$AB(qi&|g\u000e")
public class FetchRequestDownConversionConfigTest
extends BaseRequestTest {
    private KafkaProducer<String, String> producer;

    private KafkaProducer<String, String> producer() {
        return this.producer;
    }

    private void producer_$eq(KafkaProducer<String, String> x$1) {
        this.producer = x$1;
    }

    @Override
    public int brokerCount() {
        return 2;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.initProducer();
    }

    @Override
    @AfterEach
    public void tearDown() {
        if (this.producer() != null) {
            this.producer().close();
        }
        super.tearDown();
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        super.brokerPropertyOverrides(properties);
        properties.put(KafkaConfig$.MODULE$.LogMessageDownConversionEnableProp(), "false");
    }

    private void initProducer() {
        String x$1 = this.bootstrapServers(this.bootstrapServers$default$1());
        StringSerializer x$2 = new StringSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        boolean x$16 = TestUtils$.MODULE$.createProducer$default$16();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3, x$16));
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createTopics(int numTopics, int numPartitions, scala.collection.immutable.Map<String, String> configs, int topicSuffixStart) {
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numTopics).map((Function1 & Serializable & scala.Serializable)t -> FetchRequestDownConversionConfigTest.$anonfun$createTopics$1(topicSuffixStart, BoxesRunTime.unboxToInt((Object)t)), IndexedSeq$.MODULE$.canBuildFrom());
        Properties topicConfig = new Properties();
        topicConfig.setProperty(LogConfig$.MODULE$.MinInSyncReplicasProp(), Integer.toString(1));
        configs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = topicConfig.setProperty(k, v);
            return object;
        });
        return ((TraversableOnce)topics.flatMap((Function1 & Serializable & scala.Serializable)topic -> (scala.collection.immutable.Map)this.createTopic((String)topic, numPartitions, 2, topicConfig, this.createTopic$default$5(), this.createTopic$default$6()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            if (x0$2 == null) {
                throw new MatchError(null);
            }
            int partition = x0$2._1$mcI$sp();
            int leader = x0$2._2$mcI$sp();
            Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, partition)), (Object)BoxesRunTime.boxToInteger((int)leader));
            return tuple2;
        }, scala.collection.immutable.Map$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private scala.collection.immutable.Map<String, String> createTopics$default$3() {
        return Predef$.MODULE$.Map().empty();
    }

    private int createTopics$default$4() {
        return 0;
    }

    private LinkedHashMap<TopicPartition, FetchRequest.PartitionData> createPartitionMap(int maxPartitionBytes, Seq<TopicPartition> topicPartitions, scala.collection.immutable.Map<String, Uuid> topicIds, scala.collection.immutable.Map<TopicPartition, Object> offsetMap) {
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = new LinkedHashMap<TopicPartition, FetchRequest.PartitionData>();
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> partitionMap.put((TopicPartition)tp, new FetchRequest.PartitionData((Uuid)topicIds.getOrElse((Object)tp.topic(), (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID), BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse(tp, (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), 0L, maxPartitionBytes, Optional.empty())));
        return partitionMap;
    }

    private scala.collection.immutable.Map<TopicPartition, Object> createPartitionMap$default$4() {
        return Predef$.MODULE$.Map().empty();
    }

    private FetchResponse sendFetchRequest(int leaderId, FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    @Test
    public void testV1FetchWithDownConversionDisabled() {
        scala.collection.immutable.Map<TopicPartition, Object> topicMap = this.createTopics(5, 1, this.createTopics$default$3(), this.createTopics$default$4());
        Seq topicPartitions = topicMap.keySet().toSeq();
        scala.collection.mutable.Map topicIds = ((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds();
        scala.collection.mutable.Map topicNames = (scala.collection.mutable.Map)topicIds.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.swap(), Map$.MODULE$.canBuildFrom());
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> (RecordMetadata)this.producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get());
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)1, (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), this.createPartitionMap$default$4())).build((short)1);
        LinkedHashMap fetchResponseData = this.sendFetchRequest(((Tuple2)topicMap.head())._2$mcI$sp(), fetchRequest).responseData((java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(topicNames).asJava(), (short)1);
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestDownConversionConfigTest.$anonfun$testV1FetchWithDownConversionDisabled$3(fetchResponseData, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testLatestFetchWithDownConversionDisabled() {
        scala.collection.immutable.Map<TopicPartition, Object> topicMap = this.createTopics(5, 1, this.createTopics$default$3(), this.createTopics$default$4());
        Seq topicPartitions = topicMap.keySet().toSeq();
        scala.collection.mutable.Map topicIds = ((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds();
        scala.collection.mutable.Map topicNames = (scala.collection.mutable.Map)topicIds.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.swap(), Map$.MODULE$.canBuildFrom());
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> (RecordMetadata)this.producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get());
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), this.createPartitionMap$default$4())).build();
        LinkedHashMap fetchResponseData = this.sendFetchRequest(((Tuple2)topicMap.head())._2$mcI$sp(), fetchRequest).responseData((java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(topicNames).asJava(), ApiKeys.FETCH.latestVersion());
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestDownConversionConfigTest.$anonfun$testLatestFetchWithDownConversionDisabled$3(fetchResponseData, tp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testV12WithDownConversionDisabled() {
        scala.collection.immutable.Map<TopicPartition, Object> topicMap = this.createTopics(5, 1, this.createTopics$default$3(), this.createTopics$default$4());
        Seq topicPartitions = topicMap.keySet().toSeq();
        scala.collection.mutable.Map topicIds = ((KafkaServer)this.servers().head()).kafkaController().controllerContext().topicIds();
        scala.collection.mutable.Map topicNames = (scala.collection.mutable.Map)topicIds.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.swap(), Map$.MODULE$.canBuildFrom());
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> (RecordMetadata)this.producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get());
        FetchRequest fetchRequest = FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)Integer.MAX_VALUE, (int)0, this.createPartitionMap(1024, (Seq<TopicPartition>)topicPartitions, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), this.createPartitionMap$default$4())).build((short)12);
        LinkedHashMap fetchResponseData = this.sendFetchRequest(((Tuple2)topicMap.head())._2$mcI$sp(), fetchRequest).responseData((java.util.Map)CollectionConverters$.MODULE$.mutableMapAsJavaMapConverter(topicNames).asJava(), (short)12);
        topicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> {
            FetchRequestDownConversionConfigTest.$anonfun$testV12WithDownConversionDisabled$3(fetchResponseData, tp);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testV1FetchFromConsumer(String quorum) {
        this.testV1Fetch(false);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testV1FetchFromReplica(String quorum) {
        this.testV1Fetch(true);
    }

    public void testV1Fetch(boolean isFollowerFetch) {
        String topicWithDownConversionEnabled = "foo";
        String topicWithDownConversionDisabled = "bar";
        Buffer replicaIds = (Buffer)this.brokers().map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)FetchRequestDownConversionConfigTest.$anonfun$testV1Fetch$1(x$4)), Buffer$.MODULE$.canBuildFrom());
        int leaderId = BoxesRunTime.unboxToInt((Object)replicaIds.head());
        int followerId = BoxesRunTime.unboxToInt((Object)replicaIds.last());
        Admin admin = this.createAdminClient(this.createAdminClient$default$1(), this.createAdminClient$default$2());
        scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)replicaIds)}));
        int x$42 = TestUtils$.MODULE$.createTopicWithAdminRaw$default$3();
        int x$5 = TestUtils$.MODULE$.createTopicWithAdminRaw$default$4();
        Properties x$6 = TestUtils$.MODULE$.createTopicWithAdminRaw$default$6();
        Uuid topicWithDownConversionDisabledId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, topicWithDownConversionDisabled, x$42, x$5, (Map<Object, Seq<Object>>)x$3, x$6);
        Properties topicConfig = new Properties();
        topicConfig.put(LogConfig$.MODULE$.MessageDownConversionEnableProp(), "true");
        scala.collection.immutable.Map x$9 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)replicaIds)}));
        int x$11 = TestUtils$.MODULE$.createTopicWithAdminRaw$default$3();
        int x$12 = TestUtils$.MODULE$.createTopicWithAdminRaw$default$4();
        Uuid topicWithDownConversionEnabledId = TestUtils$.MODULE$.createTopicWithAdminRaw(admin, topicWithDownConversionEnabled, x$11, x$12, (Map<Object, Seq<Object>>)x$9, topicConfig);
        TopicPartition partitionWithDownConversionEnabled = new TopicPartition(topicWithDownConversionEnabled, 0);
        TopicPartition partitionWithDownConversionDisabled = new TopicPartition(topicWithDownConversionDisabled, 0);
        .colon.colon allTopicPartitions = new .colon.colon((Object)partitionWithDownConversionEnabled, (List)new .colon.colon((Object)partitionWithDownConversionDisabled, (List)Nil$.MODULE$));
        allTopicPartitions.foreach((Function1 & Serializable & scala.Serializable)tp -> (RecordMetadata)this.producer().send(new ProducerRecord(tp.topic(), (Object)"key", (Object)"value")).get());
        scala.collection.immutable.Map topicIdMap = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicWithDownConversionEnabled), (Object)topicWithDownConversionEnabledId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicWithDownConversionDisabled), (Object)topicWithDownConversionDisabledId)}));
        LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> fetchResponseData = this.sendFetch(leaderId, (Seq<TopicPartition>)allTopicPartitions, (scala.collection.immutable.Map<String, Uuid>)topicIdMap, (short)1, (Option<Object>)(isFollowerFetch ? new Some((Object)BoxesRunTime.boxToInteger((int)followerId)) : None$.MODULE$));
        Assertions.assertEquals((Object)Errors.NONE, (Object)FetchRequestDownConversionConfigTest.error$1(partitionWithDownConversionEnabled, fetchResponseData));
        if (isFollowerFetch) {
            Assertions.assertEquals((Object)Errors.NONE, (Object)FetchRequestDownConversionConfigTest.error$1(partitionWithDownConversionDisabled, fetchResponseData));
            return;
        }
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)FetchRequestDownConversionConfigTest.error$1(partitionWithDownConversionDisabled, fetchResponseData));
    }

    private LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> sendFetch(int leaderId, Seq<TopicPartition> partitions, scala.collection.immutable.Map<String, Uuid> topicIdMap, short fetchVersion, Option<Object> replicaIdOpt) {
        scala.collection.immutable.Map topicNameMap = (scala.collection.immutable.Map)topicIdMap.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.swap(), scala.collection.immutable.Map$.MODULE$.canBuildFrom());
        LinkedHashMap<TopicPartition, FetchRequest.PartitionData> partitionMap = this.createPartitionMap(1024, partitions, topicIdMap, this.createPartitionMap$default$4());
        FetchRequest fetchRequest = (FetchRequest)replicaIdOpt.map((Function1 & Serializable & scala.Serializable)replicaId -> FetchRequestDownConversionConfigTest.$anonfun$sendFetch$2(fetchVersion, partitionMap, BoxesRunTime.unboxToInt((Object)replicaId))).getOrElse((Function0 & Serializable & scala.Serializable)() -> FetchRequest.Builder.forConsumer((short)fetchVersion, (int)Integer.MAX_VALUE, (int)0, (java.util.Map)partitionMap).build(fetchVersion));
        return this.sendFetchRequest(leaderId, fetchRequest).responseData((java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)topicNameMap).asJava(), fetchVersion);
    }

    public static final /* synthetic */ String $anonfun$createTopics$1(int topicSuffixStart$1, int t) {
        return new StringBuilder(5).append("topic").append(t + topicSuffixStart$1).toString();
    }

    public static final /* synthetic */ void $anonfun$testV1FetchWithDownConversionDisabled$3(LinkedHashMap fetchResponseData$1, TopicPartition tp) {
        Assertions.assertEquals((Object)Errors.UNSUPPORTED_VERSION, (Object)Errors.forCode((short)((FetchResponseData.PartitionData)fetchResponseData$1.get(tp)).errorCode()));
    }

    public static final /* synthetic */ void $anonfun$testLatestFetchWithDownConversionDisabled$3(LinkedHashMap fetchResponseData$2, TopicPartition tp) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)((FetchResponseData.PartitionData)fetchResponseData$2.get(tp)).errorCode()));
    }

    public static final /* synthetic */ void $anonfun$testV12WithDownConversionDisabled$3(LinkedHashMap fetchResponseData$3, TopicPartition tp) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)Errors.forCode((short)((FetchResponseData.PartitionData)fetchResponseData$3.get(tp)).errorCode()));
    }

    public static final /* synthetic */ int $anonfun$testV1Fetch$1(KafkaBroker x$4) {
        return x$4.config().brokerId();
    }

    private static final Errors error$1(TopicPartition tp, LinkedHashMap fetchResponseData$4) {
        return Errors.forCode((short)((FetchResponseData.PartitionData)fetchResponseData$4.get(tp)).errorCode());
    }

    public static final /* synthetic */ FetchRequest $anonfun$sendFetch$2(short fetchVersion$1, LinkedHashMap partitionMap$2, int replicaId) {
        return FetchRequest.Builder.forReplica((short)fetchVersion$1, (int)replicaId, (int)Integer.MAX_VALUE, (int)0, (java.util.Map)partitionMap$2).build(fetchVersion$1);
    }
}

