/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import java.io.Serializable;
import java.util.Collections;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.image.MetadataProvenance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q2Aa\u0002\u0005\u0003\u001f!)a\u0003\u0001C\u0001/!)!\u0004\u0001C\u00017!)A\u0006\u0001C\u00017!)a\u0006\u0001C\u00017!)\u0001\u0007\u0001C\u00017!)!\u0007\u0001C\u00017\t9\"I]8lKJ\u001cVM\u001d<fe6+GO]5dgR+7\u000f\u001e\u0006\u0003\u0013)\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0003\u00171\taa]3sm\u0016\u0014(\"A\u0007\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005A\u0002CA\r\u0001\u001b\u0005A\u0011a\u0005;fgRlU\r\u001e:jGN,\u0005\u0010]8si\u0016$G#\u0001\u000f\u0011\u0005Ei\u0012B\u0001\u0010\u0013\u0005\u0011)f.\u001b;)\u0005\t\u0001\u0003CA\u0011+\u001b\u0005\u0011#BA\u0012%\u0003\r\t\u0007/\u001b\u0006\u0003K\u0019\nqA[;qSR,'O\u0003\u0002(Q\u0005)!.\u001e8ji*\t\u0011&A\u0002pe\u001eL!a\u000b\u0012\u0003\tQ+7\u000f^\u0001\u001ci\u0016\u001cH\u000fT1ti\u0006\u0003\b\u000f\\5fIJ+7m\u001c:e\u001f\u001a47/\u001a;)\u0005\r\u0001\u0013A\b;fgRd\u0015m\u001d;BaBd\u0017.\u001a3SK\u000e|'\u000f\u001a+j[\u0016\u001cH/Y7qQ\t!\u0001%\u0001\u000euKN$X*\u001a;bI\u0006$\u0018\rT8bI\u0016\u0013(o\u001c:D_VtG\u000f\u000b\u0002\u0006A\u0005YB/Z:u\u001b\u0016$\u0018\rZ1uC\u0006\u0003\b\u000f\\=FeJ|'oQ8v]RD#A\u0002\u0011")
public final class BrokerServerMetricsTest {
    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetricsExported() {
        void resource_resource;
        Metrics metrics = new Metrics();
        String expectedGroup = "broker-metadata-metrics";
        Set expectedMetrics = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new MetricName[]{new MetricName("last-applied-record-offset", expectedGroup, "", Collections.emptyMap()), new MetricName("last-applied-record-timestamp", expectedGroup, "", Collections.emptyMap()), new MetricName("last-applied-record-lag-ms", expectedGroup, "", Collections.emptyMap()), new MetricName("metadata-load-error-count", expectedGroup, "", Collections.emptyMap()), new MetricName("metadata-apply-error-count", expectedGroup, "", Collections.emptyMap())}));
        BrokerServerMetrics brokerServerMetrics = BrokerServerMetrics$.MODULE$.apply(metrics);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var7_5 = resource_resource;
            BrokerServerMetricsTest.$anonfun$testMetricsExported$1(metrics, expectedGroup, expectedMetrics, (BrokerServerMetrics)var7_5);
        }
        finally {
            resource_resource.close();
        }
        Map metricsMap = (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$3 -> BoxesRunTime.boxToBoolean((boolean)BrokerServerMetricsTest.$anonfun$testMetricsExported$4(expectedGroup, x0$3)));
        Assertions.assertEquals((int)0, (int)metricsMap.size());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLastAppliedRecordOffset() {
        void resource_resource;
        Metrics metrics = new Metrics();
        BrokerServerMetrics brokerServerMetrics = BrokerServerMetrics$.MODULE$.apply(metrics);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var4_3 = resource_resource;
            BrokerServerMetricsTest.$anonfun$testLastAppliedRecordOffset$1(metrics, (BrokerServerMetrics)var4_3);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLastAppliedRecordTimestamp() {
        void resource_resource;
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        BrokerServerMetrics brokerServerMetrics = BrokerServerMetrics$.MODULE$.apply(metrics);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var5_4 = resource_resource;
            BrokerServerMetricsTest.$anonfun$testLastAppliedRecordTimestamp$1(time, metrics, (BrokerServerMetrics)var5_4);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataLoadErrorCount() {
        void resource_resource;
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        BrokerServerMetrics brokerServerMetrics = BrokerServerMetrics$.MODULE$.apply(metrics);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var5_4 = resource_resource;
            BrokerServerMetricsTest.$anonfun$testMetadataLoadErrorCount$1(metrics, (BrokerServerMetrics)var5_4);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMetadataApplyErrorCount() {
        void resource_resource;
        MockTime time = new MockTime();
        Metrics metrics = new Metrics((Time)time);
        BrokerServerMetrics brokerServerMetrics = BrokerServerMetrics$.MODULE$.apply(metrics);
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var5_4 = resource_resource;
            BrokerServerMetricsTest.$anonfun$testMetadataApplyErrorCount$1(metrics, (BrokerServerMetrics)var5_4);
        }
        finally {
            resource_resource.close();
        }
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExported$2(String expectedGroup$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).group();
        boolean bl = !(string != null ? !string.equals(expectedGroup$1) : expectedGroup$1 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testMetricsExported$3(Set expectedMetrics$1, Tuple2 x0$2) {
        if (x0$2 != null) {
            MetricName name = (MetricName)x0$2._1();
            Assertions.assertTrue((boolean)expectedMetrics$1.contains((Object)name));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testMetricsExported$1(Metrics metrics$1, String expectedGroup$1, Set expectedMetrics$1, BrokerServerMetrics brokerMetrics) {
        Map metricsMap = (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(metrics$1.metrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)BrokerServerMetricsTest.$anonfun$testMetricsExported$2(expectedGroup$1, x0$1)));
        Assertions.assertEquals((int)expectedMetrics$1.size(), (int)metricsMap.size());
        metricsMap.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            BrokerServerMetricsTest.$anonfun$testMetricsExported$3(expectedMetrics$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsExported$4(String expectedGroup$1, Tuple2 x0$3) {
        if (x0$3 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$3._1()).group();
        boolean bl = !(string != null ? !string.equals(expectedGroup$1) : expectedGroup$1 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testLastAppliedRecordOffset$1(Metrics metrics$2, BrokerServerMetrics brokerMetrics) {
        KafkaMetric offsetMetric = (KafkaMetric)metrics$2.metrics().get(brokerMetrics.lastAppliedRecordOffsetName());
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)offsetMetric.metricValue()));
        int expectedValue = 1000;
        brokerMetrics.updateLastAppliedImageProvenance(new MetadataProvenance((long)expectedValue, ((MetadataProvenance)brokerMetrics.lastAppliedImageProvenance().get()).lastContainedEpoch(), brokerMetrics.lastAppliedTimestamp()));
        Assertions.assertEquals((long)expectedValue, (long)BoxesRunTime.unboxToLong((Object)offsetMetric.metricValue()));
    }

    public static final /* synthetic */ void $anonfun$testLastAppliedRecordTimestamp$1(MockTime time$1, Metrics metrics$3, BrokerServerMetrics brokerMetrics) {
        time$1.sleep(1000L);
        KafkaMetric timestampMetric = (KafkaMetric)metrics$3.metrics().get(brokerMetrics.lastAppliedRecordTimestampName());
        KafkaMetric lagMetric = (KafkaMetric)metrics$3.metrics().get(brokerMetrics.lastAppliedRecordLagMsName());
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)timestampMetric.metricValue()));
        Assertions.assertEquals((long)(time$1.milliseconds() + 1L), (long)BoxesRunTime.unboxToLong((Object)lagMetric.metricValue()));
        long timestamp = 500L;
        brokerMetrics.updateLastAppliedImageProvenance(new MetadataProvenance(brokerMetrics.lastAppliedOffset(), ((MetadataProvenance)brokerMetrics.lastAppliedImageProvenance().get()).lastContainedEpoch(), timestamp));
        Assertions.assertEquals((long)timestamp, (long)BoxesRunTime.unboxToLong((Object)timestampMetric.metricValue()));
        Assertions.assertEquals((long)(time$1.milliseconds() - timestamp), (long)BoxesRunTime.unboxToLong((Object)lagMetric.metricValue()));
    }

    public static final /* synthetic */ void $anonfun$testMetadataLoadErrorCount$1(Metrics metrics$4, BrokerServerMetrics brokerMetrics) {
        KafkaMetric metadataLoadErrorCountMetric = (KafkaMetric)metrics$4.metrics().get(brokerMetrics.metadataLoadErrorCountName());
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)metadataLoadErrorCountMetric.metricValue()));
        int errorCount = 100;
        brokerMetrics.metadataLoadErrorCount().set(errorCount);
        Assertions.assertEquals((long)errorCount, (long)BoxesRunTime.unboxToLong((Object)metadataLoadErrorCountMetric.metricValue()));
    }

    public static final /* synthetic */ void $anonfun$testMetadataApplyErrorCount$1(Metrics metrics$5, BrokerServerMetrics brokerMetrics) {
        KafkaMetric metadataApplyErrorCountMetric = (KafkaMetric)metrics$5.metrics().get(brokerMetrics.metadataApplyErrorCountName());
        Assertions.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)metadataApplyErrorCountMetric.metricValue()));
        int errorCount = 100;
        brokerMetrics.metadataApplyErrorCount().set(errorCount);
        Assertions.assertEquals((long)errorCount, (long)BoxesRunTime.unboxToLong((Object)metadataApplyErrorCountMetric.metricValue()));
    }

    public static final /* synthetic */ Object $anonfun$testMetricsExported$1$adapted(Metrics metrics$1, String expectedGroup$1, Set expectedMetrics$1, BrokerServerMetrics brokerMetrics) {
        BrokerServerMetricsTest.$anonfun$testMetricsExported$1(metrics$1, expectedGroup$1, expectedMetrics$1, brokerMetrics);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLastAppliedRecordOffset$1$adapted(Metrics metrics$2, BrokerServerMetrics brokerMetrics) {
        BrokerServerMetricsTest.$anonfun$testLastAppliedRecordOffset$1(metrics$2, brokerMetrics);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testLastAppliedRecordTimestamp$1$adapted(MockTime time$1, Metrics metrics$3, BrokerServerMetrics brokerMetrics) {
        BrokerServerMetricsTest.$anonfun$testLastAppliedRecordTimestamp$1(time$1, metrics$3, brokerMetrics);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testMetadataLoadErrorCount$1$adapted(Metrics metrics$4, BrokerServerMetrics brokerMetrics) {
        BrokerServerMetricsTest.$anonfun$testMetadataLoadErrorCount$1(metrics$4, brokerMetrics);
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testMetadataApplyErrorCount$1$adapted(Metrics metrics$5, BrokerServerMetrics brokerMetrics) {
        BrokerServerMetricsTest.$anonfun$testMetadataApplyErrorCount$1(metrics$5, brokerMetrics);
        return BoxedUnit.UNIT;
    }
}

