/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import kafka.tools.ConsoleProducer;
import kafka.tools.ConsoleProducer$;
import kafka.utils.Exit$;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.utils.Exit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001i4A\u0001I\u0011\u0001M!)Q\u0006\u0001C\u0001]!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0004BB!\u0001A\u0003%1\u0007C\u0004C\u0001\t\u0007I\u0011\u0001\u001a\t\r\r\u0003\u0001\u0015!\u00034\u0011\u001d!\u0005A1A\u0005\u0002IBa!\u0012\u0001!\u0002\u0013\u0019\u0004b\u0002$\u0001\u0005\u0004%\tA\r\u0005\u0007\u000f\u0002\u0001\u000b\u0011B\u001a\t\u000f!\u0003!\u0019!C\u0001e!1\u0011\n\u0001Q\u0001\nMBqA\u0013\u0001C\u0002\u0013\u0005!\u0007\u0003\u0004L\u0001\u0001\u0006Ia\r\u0005\b\u0019\u0002\u0011\r\u0011\"\u00013\u0011\u0019i\u0005\u0001)A\u0005g!9a\n\u0001b\u0001\n\u0003\u0011\u0004BB(\u0001A\u0003%1\u0007C\u0004Q\u0001\t\u0007I\u0011\u0001\u001a\t\rE\u0003\u0001\u0015!\u00034\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015!\u0007\u0001\"\u0001T\u0011\u00151\u0007\u0001\"\u0001T\u0011\u0015A\u0007\u0001\"\u0001T\u0011\u0015Q\u0007\u0001\"\u0001T\u0011\u0015a\u0007\u0001\"\u0001T\u0011\u0015q\u0007\u0001\"\u0001T\u0011\u0015\u0001\b\u0001\"\u0001T\u0011\u0015\u0011\b\u0001\"\u0001T\u0011\u0015!\b\u0001\"\u0001T\u0011\u00151\b\u0001\"\u0001T\u0011\u0015A\b\u0001\"\u0001T\u0005M\u0019uN\\:pY\u0016\u0004&o\u001c3vG\u0016\u0014H+Z:u\u0015\t\u00113%A\u0003u_>d7OC\u0001%\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq\u0006\u0005\u00021\u00015\t\u0011%A\nce>\\WM\u001d'jgR4\u0016\r\\5e\u0003J<7/F\u00014!\rACGN\u0005\u0003k%\u0012Q!\u0011:sCf\u0004\"a\u000e \u000f\u0005ab\u0004CA\u001d*\u001b\u0005Q$BA\u001e&\u0003\u0019a$o\\8u}%\u0011Q(K\u0001\u0007!J,G-\u001a4\n\u0005}\u0002%AB*ue&twM\u0003\u0002>S\u0005!\"M]8lKJd\u0015n\u001d;WC2LG-\u0011:hg\u0002\n\u0001DY8piN$(/\u00199TKJ4XM\u001d,bY&$\u0017I]4t\u0003e\u0011wn\u001c;tiJ\f\u0007oU3sm\u0016\u0014h+\u00197jI\u0006\u0013xm\u001d\u0011\u0002\u0017%tg/\u00197jI\u0006\u0013xm]\u0001\rS:4\u0018\r\\5e\u0003J<7\u000fI\u0001\u0018E>|Go\u001d;sCB\u001cVM\u001d<fe>3XM\u001d:jI\u0016\f\u0001DY8piN$(/\u00199TKJ4XM](wKJ\u0014\u0018\u000eZ3!\u0003A\u0019G.[3oi&#wJ^3se&$W-A\tdY&,g\u000e^%e\u001fZ,'O]5eK\u0002\n\u0011GY1uG\"\u001c\u0016N_3Pm\u0016\u0014(/\u001b3eK:\u0014\u00150T1y!\u0006\u0014H/\u001b;j_:lU-\\8ss\nKH/Z:WC2,X-\u0001\u001acCR\u001c\u0007nU5{K>3XM\u001d:jI\u0012,gNQ=NCb\u0004\u0016M\u001d;ji&|g.T3n_JL()\u001f;fgZ\u000bG.^3!\u0003-\u0012Go\u00195TSj,7+\u001a;B]\u0012l\u0015\r\u001f)beRLG/[8o\u001b\u0016lwN]=CsR,7OT8u'\u0016$\u0018\u0001\f2uG\"\u001c\u0016N_3TKR\fe\u000eZ'bqB\u000b'\u000f^5uS>tW*Z7pef\u0014\u0015\u0010^3t\u001d>$8+\u001a;!\u00031\u0012\u0017\r^2i'&TXMT8u'\u0016$\u0018I\u001c3NCb\u0004\u0016M\u001d;ji&|g.T3n_JL()\u001f;fgN+G/A\u0017cCR\u001c\u0007nU5{K:{GoU3u\u0003:$W*\u0019=QCJ$\u0018\u000e^5p]6+Wn\u001c:z\u0005f$Xm]*fi\u0002\n\u0001CY1uG\"\u001c\u0016N_3EK\u001a\fW\u000f\u001c;\u0002#\t\fGo\u00195TSj,G)\u001a4bk2$\b%\u0001\u000euKN$h+\u00197jI\u000e{gNZ5hg\n\u0013xn[3s\u0019&\u001cH\u000fF\u0001U!\tAS+\u0003\u0002WS\t!QK\\5uQ\t!\u0002\f\u0005\u0002ZE6\t!L\u0003\u0002\\9\u0006\u0019\u0011\r]5\u000b\u0005us\u0016a\u00026va&$XM\u001d\u0006\u0003?\u0002\fQA[;oSRT\u0011!Y\u0001\u0004_J<\u0017BA2[\u0005\u0011!Vm\u001d;\u0002?Q,7\u000f\u001e,bY&$7i\u001c8gS\u001e\u001c(i\\8ugR\u0014\u0018\r]*feZ,'\u000f\u000b\u0002\u00161\u0006\u0011B/Z:u\u0013:4\u0018\r\\5e\u0007>tg-[4tQ\t1\u0002,\u0001\tuKN$\b+\u0019:tK.+\u0017\u0010\u0015:pa\"\u0012q\u0003W\u0001\u001ai\u0016\u001cH\u000fU1sg\u0016\u0014V-\u00193fe\u000e{gNZ5h\r&dW\r\u000b\u0002\u00191\u0006YB/Z:u\u0005>|Go\u001d;sCB\u001cVM\u001d<fe>3XM\u001d:jI\u0016D#!\u0007-\u0002)Q,7\u000f^\"mS\u0016tG/\u00133Pm\u0016\u0014(/\u001b3fQ\tQ\u0002,A\nuKN$H)\u001a4bk2$8\t\\5f]RLE\r\u000b\u0002\u001c1\u0006)D/Z:u\u0005\u0006$8\r[*ju\u0016|e/\u001a:sS\u0012$WM\u001c\"z\u001b\u0006D\b+\u0019:uSRLwN\\'f[>\u0014\u0018PQ=uKN4\u0016\r\\;fQ\ta\u0002,\u0001\u0019uKN$()\u0019;dQNK'0Z*fi\u0006sG-T1y!\u0006\u0014H/\u001b;j_:lU-\\8ss\nKH/Z:O_R\u001cV\r\u001e\u0015\u0003;a\u000bA\u0003^3ti\u0012+g-Y;mi\n\u000bGo\u00195TSj,\u0007F\u0001\u0010Y\u0003A\"Xm\u001d;CCR\u001c\u0007nU5{K:{GoU3u\u0003:$W*\u0019=QCJ$\u0018\u000e^5p]6+Wn\u001c:z\u0005f$Xm]*fi\"\u0012q\u0004\u0017")
public class ConsoleProducerTest {
    private final String[] brokerListValidArgs = (String[])((Object[])new String[]{"--broker-list", "localhost:1001,localhost:1002", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] bootstrapServerValidArgs = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:1003,localhost:1004", "--topic", "t3", "--property", "parse.key=true", "--property", "key.separator=#"});
    private final String[] invalidArgs = (String[])((Object[])new String[]{"--t", "t3"});
    private final String[] bootstrapServerOverride = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3"});
    private final String[] clientIdOverride = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--topic", "t3", "--producer-property", "client.id=producer-1"});
    private final String[] batchSizeOverriddenByMaxPartitionMemoryBytesValue = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3", "--batch-size", "123", "--max-partition-memory-bytes", "456"});
    private final String[] btchSizeSetAndMaxPartitionMemoryBytesNotSet = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3", "--batch-size", "123"});
    private final String[] batchSizeNotSetAndMaxPartitionMemoryBytesSet = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3", "--max-partition-memory-bytes", "456"});
    private final String[] batchSizeDefault = (String[])((Object[])new String[]{"--broker-list", "localhost:1001", "--bootstrap-server", "localhost:1002", "--topic", "t3"});

    public String[] brokerListValidArgs() {
        return this.brokerListValidArgs;
    }

    public String[] bootstrapServerValidArgs() {
        return this.bootstrapServerValidArgs;
    }

    public String[] invalidArgs() {
        return this.invalidArgs;
    }

    public String[] bootstrapServerOverride() {
        return this.bootstrapServerOverride;
    }

    public String[] clientIdOverride() {
        return this.clientIdOverride;
    }

    public String[] batchSizeOverriddenByMaxPartitionMemoryBytesValue() {
        return this.batchSizeOverriddenByMaxPartitionMemoryBytesValue;
    }

    public String[] btchSizeSetAndMaxPartitionMemoryBytesNotSet() {
        return this.btchSizeSetAndMaxPartitionMemoryBytesNotSet;
    }

    public String[] batchSizeNotSetAndMaxPartitionMemoryBytesSet() {
        return this.batchSizeNotSetAndMaxPartitionMemoryBytesSet;
    }

    public String[] batchSizeDefault() {
        return this.batchSizeDefault;
    }

    @Test
    public void testValidConfigsBrokerList() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1001", "localhost:1002"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testValidConfigsBootstrapServer() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1003", "localhost:1004"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidConfigs() {
        void setExitProcedure_exitProcedure;
        Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(x$1, message) -> ConsoleProducerTest.$anonfun$testInvalidConfigs$1(BoxesRunTime.unboxToInt((Object)x$1), message);
        if (Exit$.MODULE$ == null) {
            throw null;
        }
        Exit.setExitProcedure((Exit.Procedure)new /* Unavailable Anonymous Inner Class!! */);
        try {
            Assertions.assertThrows(IllegalArgumentException.class, () -> new ConsoleProducer.ProducerConfig(this.invalidArgs()));
        }
        finally {
            Exit$.MODULE$.resetExitProcedure();
        }
    }

    @Test
    public void testParseKeyProp() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        String string = reader.keySeparator();
        String string2 = "#";
        Assertions.assertTrue((string != null && string.equals(string2) ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)reader.parseKey());
    }

    @Test
    public void testParseReaderConfigFile() {
        File propsFile = TestUtils$.MODULE$.tempFile();
        OutputStream propsStream = Files.newOutputStream(propsFile.toPath(), new OpenOption[0]);
        propsStream.write("parse.key=true\n".getBytes());
        propsStream.write("key.separator=|".getBytes());
        propsStream.close();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", "localhost:9092", "--topic", "test", "--property", "key.separator=;", "--property", "parse.headers=true", "--reader-config", propsFile.getAbsolutePath()});
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(args);
        ConsoleProducer.LineMessageReader reader = (ConsoleProducer.LineMessageReader)Class.forName(config.readerClass()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        reader.init(System.in, ConsoleProducer$.MODULE$.getReaderProps(config));
        Assertions.assertEquals((Object)";", (Object)reader.keySeparator());
        Assertions.assertTrue((boolean)reader.parseKey());
        Assertions.assertTrue((boolean)reader.parseHeaders());
    }

    @Test
    public void testBootstrapServerOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.bootstrapServerOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals(Arrays.asList((Object[])new String[]{"localhost:1002"}), (Object)producerConfig.getList("bootstrap.servers"));
    }

    @Test
    public void testClientIdOverride() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.clientIdOverride());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((Object)"producer-1", (Object)producerConfig.getString("client.id"));
    }

    @Test
    public void testDefaultClientId() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.brokerListValidArgs());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((Object)"console-producer", (Object)producerConfig.getString("client.id"));
    }

    @Test
    public void testBatchSizeOverriddenByMaxPartitionMemoryBytesValue() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.batchSizeOverriddenByMaxPartitionMemoryBytesValue());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((int)456, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testBatchSizeSetAndMaxPartitionMemoryBytesNotSet() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.btchSizeSetAndMaxPartitionMemoryBytesNotSet());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((int)123, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testDefaultBatchSize() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.batchSizeDefault());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((int)16384, (Integer)producerConfig.getInt("batch.size"));
    }

    @Test
    public void testBatchSizeNotSetAndMaxPartitionMemoryBytesSet() {
        ConsoleProducer.ProducerConfig config = new ConsoleProducer.ProducerConfig(this.batchSizeNotSetAndMaxPartitionMemoryBytesSet());
        ProducerConfig producerConfig = new ProducerConfig(ConsoleProducer$.MODULE$.producerProps(config));
        Assertions.assertEquals((int)456, (Integer)producerConfig.getInt("batch.size"));
    }

    public static final /* synthetic */ Nothing$ $anonfun$testInvalidConfigs$1(int x$1, Option message) {
        throw new IllegalArgumentException((String)message.orNull(Predef$.MODULE$.$conforms()));
    }
}

