/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kafka.raft.KafkaRaftManager;
import kafka.server.DynamicBrokerConfig;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server$;
import kafka.server.metadata.BrokerServerMetrics;
import kafka.server.metadata.BrokerServerMetrics$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.QuorumControllerMetrics;
import org.apache.kafka.image.loader.MetadataLoader;
import org.apache.kafka.image.loader.MetadataLoaderMetrics;
import org.apache.kafka.image.publisher.SnapshotEmitter;
import org.apache.kafka.image.publisher.SnapshotGenerator;
import org.apache.kafka.metadata.MetadataRecordSerde;
import org.apache.kafka.raft.RaftClient;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.serialization.RecordSerde;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t]f\u0001\u0002\"D\u0001!C\u0001\"\u0016\u0001\u0003\u0006\u0004%IA\u0016\u0005\t7\u0002\u0011\t\u0011)A\u0005/\"AA\f\u0001BC\u0002\u0013\u0005Q\f\u0003\u0005b\u0001\t\u0005\t\u0015!\u0003_\u0011!\u0011\u0007A!b\u0001\n\u0003\u0019\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011\u00023\t\u0011E\u0004!Q1A\u0005\nID\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006Ia\u001d\u0005\tu\u0002\u0011)\u0019!C\u0001w\"I\u0011Q\u0003\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\u000b\u0003/\u0001!Q1A\u0005\u0002\u0005e\u0001BCA3\u0001\t\u0005\t\u0015!\u0003\u0002\u001c!Q\u0011q\r\u0001\u0003\u0006\u0004%\t!!\u001b\t\u0015\u0005E\u0004A!A!\u0002\u0013\tY\u0007C\u0004\u0002t\u0001!\t!!\u001e\t\u0013\u0005\u001d\u0005A1A\u0005\n\u0005%\u0005\u0002CAI\u0001\u0001\u0006I!a#\t\u0013\u0005M\u0005\u00011A\u0005\n\u0005U\u0005\"CAO\u0001\u0001\u0007I\u0011BAP\u0011!\tY\u000b\u0001Q!\n\u0005]\u0005\"CAW\u0001\u0001\u0007I\u0011BAK\u0011%\ty\u000b\u0001a\u0001\n\u0013\t\t\f\u0003\u0005\u00026\u0002\u0001\u000b\u0015BAL\u0011%\t9\f\u0001a\u0001\n\u0013\t)\nC\u0005\u0002:\u0002\u0001\r\u0011\"\u0003\u0002<\"A\u0011q\u0018\u0001!B\u0013\t9\n\u0003\u0005\u0002B\u0002\u0011\r\u0011\"\u0001W\u0011\u001d\t\u0019\r\u0001Q\u0001\n]C\u0001\"!2\u0001\u0005\u0004%\tA\u0016\u0005\b\u0003\u000f\u0004\u0001\u0015!\u0003X\u0011\u001d1\b\u00011A\u0005\u0002ID\u0011\"!3\u0001\u0001\u0004%\t!a3\t\u000f\u0005=\u0007\u0001)Q\u0005g\"Y\u0011\u0011\u001c\u0001A\u0002\u0003\u0007I\u0011AAn\u0011-\t\u0019\u0010\u0001a\u0001\u0002\u0004%\t!!>\t\u0017\u0005e\b\u00011A\u0001B\u0003&\u0011Q\u001c\u0005\f\u0003{\u0004\u0001\u0019!a\u0001\n\u0003\ty\u0010C\u0006\u0003\u000e\u0001\u0001\r\u00111A\u0005\u0002\t=\u0001b\u0003B\n\u0001\u0001\u0007\t\u0011)Q\u0005\u0005\u0003A1Ba\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003\u001a!Y!q\u0005\u0001A\u0002\u0003\u0007I\u0011\u0001B\u0015\u0011-\u0011i\u0003\u0001a\u0001\u0002\u0003\u0006KAa\u0007\t\u0017\tE\u0002\u00011AA\u0002\u0013\u0005!1\u0007\u0005\f\u0005\u0007\u0002\u0001\u0019!a\u0001\n\u0003\u0011)\u0005C\u0006\u0003J\u0001\u0001\r\u0011!Q!\n\tU\u0002\"\u0003B'\u0001\t\u0007I\u0011\u0001B(\u0011!\u0011i\u0006\u0001Q\u0001\n\tE\u0003b\u0003B0\u0001\u0001\u0007\t\u0019!C\u0001\u0005CB1Ba\u001c\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0003r!Y!Q\u000f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002B2\u0011-\u0011I\b\u0001a\u0001\u0002\u0004%\tAa\u001f\t\u0017\t\r\u0005\u00011AA\u0002\u0013\u0005!Q\u0011\u0005\f\u0005\u0013\u0003\u0001\u0019!A!B\u0013\u0011i\bC\u0004\u0003\u000e\u0002!\tAa$\t\u000f\tE\u0005\u0001\"\u0001\u0003\u0014\"9!Q\u0013\u0001\u0005\u0002\tM\u0005b\u0002BL\u0001\u0011\u0005!1\u0013\u0005\b\u00053\u0003A\u0011\u0001BJ\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;CqAa+\u0001\t\u0003\u0011i\nC\u0004\u0003.\u0002!\tA!(\t\u000f\t=\u0006\u0001\"\u0001\u0003\u001e\"9!\u0011\u0017\u0001\u0005\n\tM\u0005b\u0002BZ\u0001\u0011\u0005!1\u0013\u0005\b\u0005k\u0003A\u0011\u0002BJ\u00051\u0019\u0006.\u0019:fIN+'O^3s\u0015\t!U)\u0001\u0004tKJ4XM\u001d\u0006\u0002\r\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001J\u001fB\u0011!*T\u0007\u0002\u0017*\tA*A\u0003tG\u0006d\u0017-\u0003\u0002O\u0017\n1\u0011I\\=SK\u001a\u0004\"\u0001U*\u000e\u0003ES!AU#\u0002\u000bU$\u0018\u000e\\:\n\u0005Q\u000b&a\u0002'pO\u001eLgnZ\u0001\u0013g\"\f'/\u001a3TKJ4XM]\"p]\u001aLw-F\u0001X!\tA\u0016,D\u0001D\u0013\tQ6IA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aE:iCJ,GmU3sm\u0016\u00148i\u001c8gS\u001e\u0004\u0013!C7fi\u0006\u0004&o\u001c9t+\u0005q\u0006C\u0001-`\u0013\t\u00017I\u0001\bNKR\f\u0007K]8qKJ$\u0018.Z:\u0002\u00155,G/\u0019)s_B\u001c\b%\u0001\u0003uS6,W#\u00013\u0011\u0005\u0015tW\"\u00014\u000b\u0005I;'B\u00015j\u0003\u0019\u0019w.\\7p]*\u0011aI\u001b\u0006\u0003W2\fa!\u00199bG\",'\"A7\u0002\u0007=\u0014x-\u0003\u0002pM\n!A+[7f\u0003\u0015!\u0018.\\3!\u0003!yV.\u001a;sS\u000e\u001cX#A:\u0011\u0005Q<X\"A;\u000b\u0005Y<\u0017aB7fiJL7m]\u0005\u0003qV\u0014q!T3ue&\u001c7/A\u0005`[\u0016$(/[2tA\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u000b\u0002yB\u0019!*`@\n\u0005y\\%AB(qi&|g\u000e\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002L\u001b\t\t9AC\u0002\u0002\n\u001d\u000ba\u0001\u0010:p_Rt\u0014bAA\u0007\u0017\u00061\u0001K]3eK\u001aLA!!\u0005\u0002\u0014\t11\u000b\u001e:j]\u001eT1!!\u0004L\u0003E!\bN]3bI:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\tY\u0002\u0005\u0004\u0002\u001e\u0005-\u0012qF\u0007\u0003\u0003?QA!!\t\u0002$\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\u0015\u0012qE\u0001\u0005kRLGN\u0003\u0002\u0002*\u0005!!.\u0019<b\u0013\u0011\ti#a\b\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u00022\u0005M\u0012qGA\"\u001b\t\t\u0019#\u0003\u0003\u00026\u0005\r\"aA'baB!\u0011\u0011HA \u001b\t\tYD\u0003\u0003\u0002>\u0005\u001d\u0012\u0001\u00027b]\u001eLA!!\u0011\u0002<\t9\u0011J\u001c;fO\u0016\u0014\b\u0003BA#\u0003?rA!a\u0012\u0002Z9!\u0011\u0011JA+\u001d\u0011\tY%a\u0015\u000f\t\u00055\u0013\u0011\u000b\b\u0005\u0003\u000b\ty%C\u0001n\u0013\tYG.\u0003\u0002GU&\u0019\u0011qK5\u0002\tI\fg\r^\u0005\u0005\u00037\ni&\u0001\u0006SC\u001a$8i\u001c8gS\u001eT1!a\u0016j\u0013\u0011\t\t'a\u0019\u0003\u0017\u0005#GM]3tgN\u0003Xm\u0019\u0006\u0005\u00037\ni&A\u000fd_:$(o\u001c7mKJ\fVo\u001c:v[Z{G/\u001a:t\rV$XO]3!\u0003M1\u0017-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z+\t\tY\u0007E\u0002Y\u0003[J1!a\u001cD\u0005M1\u0015-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z\u0003Q1\u0017-\u001e7u\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:zA\u00051A(\u001b8jiz\"\u0002#a\u001e\u0002z\u0005m\u0014QPA@\u0003\u0003\u000b\u0019)!\"\u0011\u0005a\u0003\u0001\"B+\u0010\u0001\u00049\u0006\"\u0002/\u0010\u0001\u0004q\u0006\"\u00022\u0010\u0001\u0004!\u0007\"B9\u0010\u0001\u0004\u0019\b\"\u0002>\u0010\u0001\u0004a\bbBA\f\u001f\u0001\u0007\u00111\u0004\u0005\b\u0003Oz\u0001\u0019AA6\u0003)awnZ\"p]R,\u0007\u0010^\u000b\u0003\u0003\u0017\u00032!ZAG\u0013\r\tyI\u001a\u0002\u000b\u0019><7i\u001c8uKb$\u0018a\u00037pO\u000e{g\u000e^3yi\u0002\nqa\u001d;beR,G-\u0006\u0002\u0002\u0018B\u0019!*!'\n\u0007\u0005m5JA\u0004C_>dW-\u00198\u0002\u0017M$\u0018M\u001d;fI~#S-\u001d\u000b\u0005\u0003C\u000b9\u000bE\u0002K\u0003GK1!!*L\u0005\u0011)f.\u001b;\t\u0013\u0005%6#!AA\u0002\u0005]\u0015a\u0001=%c\u0005A1\u000f^1si\u0016$\u0007%\u0001\u0007vg\u0016$')\u001f\"s_.,'/\u0001\tvg\u0016$')\u001f\"s_.,'o\u0018\u0013fcR!\u0011\u0011UAZ\u0011%\tIKFA\u0001\u0002\u0004\t9*A\u0007vg\u0016$')\u001f\"s_.,'\u000fI\u0001\u0011kN,GMQ=D_:$(o\u001c7mKJ\fA#^:fI\nK8i\u001c8ue>dG.\u001a:`I\u0015\fH\u0003BAQ\u0003{C\u0011\"!+\u001a\u0003\u0003\u0005\r!a&\u0002#U\u001cX\r\u001a\"z\u0007>tGO]8mY\u0016\u0014\b%\u0001\u0007ce>\\WM]\"p]\u001aLw-A\u0007ce>\\WM]\"p]\u001aLw\rI\u0001\u0011G>tGO]8mY\u0016\u00148i\u001c8gS\u001e\f\u0011cY8oiJ|G\u000e\\3s\u0007>tg-[4!\u0003-iW\r\u001e:jGN|F%Z9\u0015\t\u0005\u0005\u0016Q\u001a\u0005\t\u0003S\u0003\u0013\u0011!a\u0001g\u0006AQ.\u001a;sS\u000e\u001c\b\u0005K\u0002\"\u0003'\u00042ASAk\u0013\r\t9n\u0013\u0002\tm>d\u0017\r^5mK\u0006Y!/\u00194u\u001b\u0006t\u0017mZ3s+\t\ti\u000e\u0005\u0004\u0002`\u0006\r\u0018q]\u0007\u0003\u0003CT1!a\u0016F\u0013\u0011\t)/!9\u0003!-\u000bgm[1SC\u001a$X*\u00198bO\u0016\u0014\b\u0003BAu\u0003_l!!a;\u000b\u0007!\fiO\u0003\u0002ES&!\u0011\u0011_Av\u0005Q\t\u0005/['fgN\fw-Z!oIZ+'o]5p]\u0006y!/\u00194u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0003\u0002\"\u0006]\b\"CAUG\u0005\u0005\t\u0019AAo\u00031\u0011\u0018M\u001a;NC:\fw-\u001a:!Q\r!\u00131[\u0001\u000eEJ|7.\u001a:NKR\u0014\u0018nY:\u0016\u0005\t\u0005\u0001\u0003\u0002B\u0002\u0005\u0013i!A!\u0002\u000b\u0007\t\u001d1)\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\u0011YA!\u0002\u0003'\t\u0013xn[3s'\u0016\u0014h/\u001a:NKR\u0014\u0018nY:\u0002#\t\u0014xn[3s\u001b\u0016$(/[2t?\u0012*\u0017\u000f\u0006\u0003\u0002\"\nE\u0001\"CAUM\u0005\u0005\t\u0019\u0001B\u0001\u00039\u0011'o\\6fe6+GO]5dg\u0002B3aJAj\u0003E\u0019wN\u001c;s_2dWM]'fiJL7m]\u000b\u0003\u00057\u0001BA!\b\u0003$5\u0011!q\u0004\u0006\u0004\u0005CI\u0017AC2p]R\u0014x\u000e\u001c7fe&!!Q\u0005B\u0010\u0005]\tVo\u001c:v[\u000e{g\u000e\u001e:pY2,'/T3ue&\u001c7/A\u000bd_:$(o\u001c7mKJlU\r\u001e:jGN|F%Z9\u0015\t\u0005\u0005&1\u0006\u0005\n\u0003SK\u0013\u0011!a\u0001\u00057\t!cY8oiJ|G\u000e\\3s\u001b\u0016$(/[2tA!\u001a!&a5\u0002\r1|\u0017\rZ3s+\t\u0011)\u0004\u0005\u0003\u00038\t}RB\u0001B\u001d\u0015\u0011\u0011\tDa\u000f\u000b\u0007\tu\u0012.A\u0003j[\u0006<W-\u0003\u0003\u0003B\te\"AD'fi\u0006$\u0017\r^1M_\u0006$WM]\u0001\u000bY>\fG-\u001a:`I\u0015\fH\u0003BAQ\u0005\u000fB\u0011\"!+-\u0003\u0003\u0005\rA!\u000e\u0002\u000f1|\u0017\rZ3sA!\u001aQ&a5\u0002-Mt\u0017\r]:i_R\u001cH)[1cY\u0016$'+Z1t_:,\"A!\u0015\u0011\u000b\tM#\u0011L@\u000e\u0005\tU#\u0002\u0002B,\u0003?\ta!\u0019;p[&\u001c\u0017\u0002\u0002B.\u0005+\u0012q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-Z\u0001\u0018g:\f\u0007o\u001d5piN$\u0015.\u00192mK\u0012\u0014V-Y:p]\u0002\nqb\u001d8baNDw\u000e^#nSR$XM]\u000b\u0003\u0005G\u0002BA!\u001a\u0003l5\u0011!q\r\u0006\u0005\u0005S\u0012Y$A\u0005qk\nd\u0017n\u001d5fe&!!Q\u000eB4\u0005=\u0019f.\u00199tQ>$X)\\5ui\u0016\u0014\u0018aE:oCB\u001c\bn\u001c;F[&$H/\u001a:`I\u0015\fH\u0003BAQ\u0005gB\u0011\"!+2\u0003\u0003\u0005\rAa\u0019\u0002!Mt\u0017\r]:i_R,U.\u001b;uKJ\u0004\u0003f\u0001\u001a\u0002T\u0006\t2O\\1qg\"|GoR3oKJ\fGo\u001c:\u0016\u0005\tu\u0004\u0003\u0002B3\u0005\u007fJAA!!\u0003h\t\t2K\\1qg\"|GoR3oKJ\fGo\u001c:\u0002+Mt\u0017\r]:i_R<UM\\3sCR|'o\u0018\u0013fcR!\u0011\u0011\u0015BD\u0011%\tI\u000bNA\u0001\u0002\u0004\u0011i(\u0001\nt]\u0006\u00048\u000f[8u\u000f\u0016tWM]1u_J\u0004\u0003fA\u001b\u0002T\u00061\u0011n]+tK\u0012$\"!a&\u0002\u001dM$\u0018M\u001d;G_J\u0014%o\\6feR\u0011\u0011\u0011U\u0001\u0013gR\f'\u000f\u001e$pe\u000e{g\u000e\u001e:pY2,'/A\u0007ti>\u0004hi\u001c:Ce>\\WM]\u0001\u0012gR|\u0007OR8s\u0007>tGO]8mY\u0016\u0014\u0018AG7fi\u0006$\u0017\r^1M_\u0006$WM\u001d$bk2$\b*\u00198eY\u0016\u0014XC\u0001BP!\u0011\u0011\tKa*\u000e\u0005\t\r&\u0002\u0002BS\u0003[\fQAZ1vYRLAA!+\u0003$\naa)Y;mi\"\u000bg\u000e\u001a7fe\u0006)\u0013N\\5uS\u0006d'I]8lKJlU\r^1eCR\fGj\\1e\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u001dcV|'/^7D_:$(o\u001c7mKJ4\u0015-\u001e7u\u0011\u0006tG\r\\3s\u0003yiW\r^1eCR\f\u0007+\u001e2mSND\u0017N\\4GCVdG\u000fS1oI2,'/A\u0003ti\u0006\u0014H/A\nf]N,(/\u001a(piJ\u000bg\r\u001e'fC\u0012,'/\u0001\u0003ti>\u0004\b")
public class SharedServer
implements Logging {
    private final KafkaConfig sharedServerConfig;
    private final MetaProperties metaProps;
    private final Time time;
    private final Metrics _metrics;
    private final Option<String> threadNamePrefix;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final FaultHandlerFactory faultHandlerFactory;
    private final LogContext logContext;
    private boolean started;
    private boolean usedByBroker;
    private boolean usedByController;
    private final KafkaConfig brokerConfig;
    private final KafkaConfig controllerConfig;
    private volatile Metrics metrics;
    private volatile KafkaRaftManager<ApiMessageAndVersion> raftManager;
    private volatile BrokerServerMetrics brokerMetrics;
    private volatile QuorumControllerMetrics controllerMetrics;
    private volatile MetadataLoader loader;
    private final AtomicReference<String> snapshotsDiabledReason;
    private volatile SnapshotEmitter snapshotEmitter;
    private volatile SnapshotGenerator snapshotGenerator;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private KafkaConfig sharedServerConfig() {
        return this.sharedServerConfig;
    }

    public MetaProperties metaProps() {
        return this.metaProps;
    }

    public Time time() {
        return this.time;
    }

    private Metrics _metrics() {
        return this._metrics;
    }

    public Option<String> threadNamePrefix() {
        return this.threadNamePrefix;
    }

    public CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public FaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private boolean started() {
        return this.started;
    }

    private void started_$eq(boolean x$1) {
        this.started = x$1;
    }

    private boolean usedByBroker() {
        return this.usedByBroker;
    }

    private void usedByBroker_$eq(boolean x$1) {
        this.usedByBroker = x$1;
    }

    private boolean usedByController() {
        return this.usedByController;
    }

    private void usedByController_$eq(boolean x$1) {
        this.usedByController = x$1;
    }

    public KafkaConfig brokerConfig() {
        return this.brokerConfig;
    }

    public KafkaConfig controllerConfig() {
        return this.controllerConfig;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public void metrics_$eq(Metrics x$1) {
        this.metrics = x$1;
    }

    public KafkaRaftManager<ApiMessageAndVersion> raftManager() {
        return this.raftManager;
    }

    public void raftManager_$eq(KafkaRaftManager<ApiMessageAndVersion> x$1) {
        this.raftManager = x$1;
    }

    public BrokerServerMetrics brokerMetrics() {
        return this.brokerMetrics;
    }

    public void brokerMetrics_$eq(BrokerServerMetrics x$1) {
        this.brokerMetrics = x$1;
    }

    public QuorumControllerMetrics controllerMetrics() {
        return this.controllerMetrics;
    }

    public void controllerMetrics_$eq(QuorumControllerMetrics x$1) {
        this.controllerMetrics = x$1;
    }

    public MetadataLoader loader() {
        return this.loader;
    }

    public void loader_$eq(MetadataLoader x$1) {
        this.loader = x$1;
    }

    public AtomicReference<String> snapshotsDiabledReason() {
        return this.snapshotsDiabledReason;
    }

    public SnapshotEmitter snapshotEmitter() {
        return this.snapshotEmitter;
    }

    public void snapshotEmitter_$eq(SnapshotEmitter x$1) {
        this.snapshotEmitter = x$1;
    }

    public SnapshotGenerator snapshotGenerator() {
        return this.snapshotGenerator;
    }

    public void snapshotGenerator_$eq(SnapshotGenerator x$1) {
        this.snapshotGenerator = x$1;
    }

    public synchronized boolean isUsed() {
        return this.usedByController() || this.usedByBroker();
    }

    public synchronized void startForBroker() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByBroker_$eq(true);
    }

    public synchronized void startForController() {
        if (!this.isUsed()) {
            this.start();
        }
        this.usedByController_$eq(true);
    }

    public synchronized void stopForBroker() {
        if (this.usedByBroker()) {
            this.usedByBroker_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
        }
    }

    public synchronized void stopForController() {
        if (this.usedByController()) {
            this.usedByController_$eq(false);
            if (!this.isUsed()) {
                this.stop();
                return;
            }
        }
    }

    public FaultHandler metadataLoaderFaultHandler() {
        return this.faultHandlerFactory().build("metadata loading", this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$), () -> {
            synchronized (this) {
                if (this.brokerMetrics() != null) {
                    this.brokerMetrics().metadataLoadErrorCount().getAndIncrement();
                }
                if (this.controllerMetrics() != null) {
                    this.controllerMetrics().incrementMetadataErrorCount();
                }
                this.snapshotsDiabledReason().compareAndSet(null, "metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler initialBrokerMetadataLoadFaultHandler() {
        return this.faultHandlerFactory().build("initial broker metadata loading", true, () -> {
            synchronized (this) {
                if (this.brokerMetrics() != null) {
                    this.brokerMetrics().metadataApplyErrorCount().getAndIncrement();
                }
                if (this.controllerMetrics() != null) {
                    this.controllerMetrics().incrementMetadataErrorCount();
                }
                this.snapshotsDiabledReason().compareAndSet(null, "initial broker metadata loading fault");
                return;
            }
        });
    }

    public FaultHandler quorumControllerFaultHandler() {
        return this.faultHandlerFactory().build("quorum controller", true, () -> {
            synchronized (this) {
                if (this.controllerMetrics() != null) {
                    this.controllerMetrics().incrementMetadataErrorCount();
                }
                this.snapshotsDiabledReason().compareAndSet(null, "quorum controller fault");
                return;
            }
        });
    }

    public FaultHandler metadataPublishingFaultHandler() {
        return this.faultHandlerFactory().build("metadata publishing", false, () -> {
            synchronized (this) {
                if (this.brokerMetrics() != null) {
                    this.brokerMetrics().metadataApplyErrorCount().getAndIncrement();
                }
                if (this.controllerMetrics() != null) {
                    this.controllerMetrics().incrementMetadataErrorCount();
                }
                return;
            }
        });
    }

    private synchronized void start() {
        if (this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SharedServer has already been started.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Starting SharedServer");
        try {
            if (this.metrics() == null) {
                this.metrics_$eq(new Metrics());
            }
            this.sharedServerConfig().dynamicConfig().initialize((Option<KafkaZkClient>)None$.MODULE$);
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$)) {
                this.brokerMetrics_$eq(BrokerServerMetrics$.MODULE$.apply(this.metrics()));
            }
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                this.controllerMetrics_$eq(new QuorumControllerMetrics(KafkaYammerMetrics.defaultRegistry(), this.time()));
            }
            this.raftManager_$eq(new KafkaRaftManager<ApiMessageAndVersion>(this.metaProps(), this.sharedServerConfig(), (RecordSerde<ApiMessageAndVersion>)new MetadataRecordSerde(), KafkaRaftServer$.MODULE$.MetadataPartition(), KafkaRaftServer$.MODULE$.MetadataTopicId(), this.time(), this.metrics(), this.threadNamePrefix(), this.controllerQuorumVotersFuture()));
            this.raftManager().startup();
            if (this.sharedServerConfig().processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$)) {
                MetadataLoader.Builder loaderBuilder = new MetadataLoader.Builder().setNodeId(this.metaProps().nodeId()).setTime(this.time()).setThreadNamePrefix((String)this.threadNamePrefix().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).setFaultHandler(this.metadataLoaderFaultHandler()).setHighWaterMarkAccessor(() -> this.raftManager().client().highWatermark());
                if (this.brokerMetrics() != null) {
                    loaderBuilder.setMetadataLoaderMetrics((MetadataLoaderMetrics)this.brokerMetrics());
                }
                this.loader_$eq(loaderBuilder.build());
                this.snapshotEmitter_$eq(new SnapshotEmitter.Builder().setNodeId(this.metaProps().nodeId()).setRaftClient(this.raftManager().client()).build());
                this.snapshotGenerator_$eq(new SnapshotGenerator.Builder((SnapshotGenerator.Emitter)this.snapshotEmitter()).setNodeId(this.metaProps().nodeId()).setTime(this.time()).setFaultHandler(this.metadataPublishingFaultHandler()).setMaxBytesSinceLastSnapshot(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxNewRecordBytes())).setMaxTimeSinceLastSnapshotNs(TimeUnit.MILLISECONDS.toNanos(Predef$.MODULE$.Long2long(this.sharedServerConfig().metadataSnapshotMaxIntervalMs()))).setDisabledReason(this.snapshotsDiabledReason()).build());
                this.raftManager().register((RaftClient.Listener<ApiMessageAndVersion>)this.loader());
                try {
                    this.loader().installPublishers(Collections.singletonList(this.snapshotGenerator()));
                }
                catch (Throwable t) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unable to install metadata publishers", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> t);
                    throw new RuntimeException("Unable to install metadata publishers.", t);
                }
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Completed SharedServer startup.");
            this.started_$eq(true);
            return;
        }
        catch (Throwable e) {
            this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got exception while starting SharedServer", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
            this.stop();
            return;
        }
    }

    public synchronized void ensureNotRaftLeader() {
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftManager().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.raftManager_$eq(null);
        }
    }

    private synchronized void stop() {
        if (!this.started()) {
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "SharedServer is not running.");
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping SharedServer");
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loader().beginShutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.snapshotGenerator().beginShutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
        }
        if (this.loader() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loader().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.loader_$eq(null);
        }
        if (this.snapshotGenerator() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.snapshotGenerator().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.snapshotGenerator_$eq(null);
        }
        if (this.raftManager() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.raftManager().shutdown(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.raftManager_$eq(null);
        }
        if (this.controllerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.controllerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.controllerMetrics_$eq(null);
        }
        if (this.brokerMetrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.brokerMetrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.brokerMetrics_$eq(null);
        }
        if (this.metrics() != null) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.metrics().close(), this, CoreUtils$.MODULE$.swallow$default$3());
            this.metrics_$eq(null);
        }
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.sharedServerConfig().nodeId()), (Metrics)this.metrics()), this, CoreUtils$.MODULE$.swallow$default$3());
        this.started_$eq(false);
    }

    public SharedServer(KafkaConfig sharedServerConfig, MetaProperties metaProps, Time time, Metrics _metrics, Option<String> threadNamePrefix, CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture, FaultHandlerFactory faultHandlerFactory) {
        this.sharedServerConfig = sharedServerConfig;
        this.metaProps = metaProps;
        this.time = time;
        this._metrics = _metrics;
        this.threadNamePrefix = threadNamePrefix;
        this.controllerQuorumVotersFuture = controllerQuorumVotersFuture;
        this.faultHandlerFactory = faultHandlerFactory;
        Logging.$init$(this);
        this.logContext = new LogContext(new StringBuilder(19).append("[SharedServer id=").append(sharedServerConfig.nodeId()).append("] ").toString());
        this.logIdent_$eq(this.logContext().logPrefix());
        this.started = false;
        this.usedByBroker = false;
        this.usedByController = false;
        this.brokerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.controllerConfig = new KafkaConfig(sharedServerConfig.props(), false, (Option<DynamicBrokerConfig>)None$.MODULE$);
        this.metrics = _metrics;
        this.snapshotsDiabledReason = new AtomicReference<Object>(null);
    }
}

