/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.group;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Optional;
import kafka.common.OffsetAndMetadata;
import kafka.coordinator.group.BaseKey;
import kafka.coordinator.group.Empty$;
import kafka.coordinator.group.GroupMetadata;
import kafka.coordinator.group.GroupMetadata$;
import kafka.coordinator.group.GroupMetadataKey;
import kafka.coordinator.group.GroupState;
import kafka.coordinator.group.GroupTopicPartition;
import kafka.coordinator.group.MemberMetadata;
import kafka.coordinator.group.OffsetKey;
import kafka.coordinator.group.Stable$;
import kafka.coordinator.group.UnknownKey;
import kafka.internals.generated.GroupMetadataValue;
import kafka.internals.generated.OffsetCommitKey;
import kafka.internals.generated.OffsetCommitValue;
import kafka.utils.Json$;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class GroupMetadataManager$ {
    public static GroupMetadataManager$ MODULE$;
    private final String MetricsGroup;
    private final String LoadTimeSensor;
    private final String OffsetCommitsSensor;
    private final String OffsetExpiredSensor;

    static {
        new GroupMetadataManager$();
    }

    public String MetricsGroup() {
        return this.MetricsGroup;
    }

    public String LoadTimeSensor() {
        return this.LoadTimeSensor;
    }

    public String OffsetCommitsSensor() {
        return this.OffsetCommitsSensor;
    }

    public String OffsetExpiredSensor() {
        return this.OffsetExpiredSensor;
    }

    public byte[] offsetCommitKey(String groupId, TopicPartition topicPartition) {
        return MessageUtil.toVersionPrefixedBytes((short)1, (Message)new OffsetCommitKey().setGroup(groupId).setTopic(topicPartition.topic()).setPartition(topicPartition.partition()));
    }

    public byte[] groupMetadataKey(String groupId) {
        return MessageUtil.toVersionPrefixedBytes((short)2, (Message)new kafka.internals.generated.GroupMetadataKey().setGroup(groupId));
    }

    public byte[] offsetCommitValue(OffsetAndMetadata offsetAndMetadata, MetadataVersion metadataVersion) {
        return MessageUtil.toVersionPrefixedBytes((short)(metadataVersion.isLessThan(MetadataVersion.IBP_2_1_IV0) || offsetAndMetadata.expireTimestamp().nonEmpty() ? (short)1 : (metadataVersion.isLessThan(MetadataVersion.IBP_2_1_IV1) ? (short)2 : (short)3)), (Message)new OffsetCommitValue().setOffset(offsetAndMetadata.offset()).setMetadata(offsetAndMetadata.metadata()).setCommitTimestamp(offsetAndMetadata.commitTimestamp()).setLeaderEpoch(Predef$.MODULE$.Integer2int(offsetAndMetadata.leaderEpoch().orElse(Predef$.MODULE$.int2Integer(-1)))).setExpireTimestamp(BoxesRunTime.unboxToLong((Object)offsetAndMetadata.expireTimestamp().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L))));
    }

    public byte[] groupMetadataValue(GroupMetadata groupMetadata, Map<String, byte[]> assignment, MetadataVersion metadataVersion) {
        return MessageUtil.toVersionPrefixedBytes((short)(metadataVersion.isLessThan(MetadataVersion.IBP_0_10_1_IV0) ? (short)0 : (metadataVersion.isLessThan(MetadataVersion.IBP_2_1_IV0) ? (short)1 : (metadataVersion.isLessThan(MetadataVersion.IBP_2_3_IV0) ? (short)2 : (short)3))), (Message)new GroupMetadataValue().setProtocolType((String)groupMetadata.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).setGeneration(groupMetadata.generationId()).setProtocol((String)groupMetadata.protocolName().orNull(Predef$.MODULE$.$conforms())).setLeader(groupMetadata.leaderOrNull()).setCurrentStateTimestamp(groupMetadata.currentStateTimestampOrDefault()).setMembers((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)groupMetadata.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)memberMetadata -> new GroupMetadataValue.MemberMetadata().setMemberId(memberMetadata.memberId()).setClientId(memberMetadata.clientId()).setClientHost(memberMetadata.clientHost()).setSessionTimeout(memberMetadata.sessionTimeoutMs()).setRebalanceTimeout(memberMetadata.rebalanceTimeoutMs()).setGroupInstanceId((String)memberMetadata.groupInstanceId().orNull(Predef$.MODULE$.$conforms())).setSubscription((byte[])groupMetadata.protocolName().map((Function1 & Serializable & scala.Serializable)protocol -> memberMetadata.metadata((String)protocol)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException("Attempted to write non-empty group metadata with no defined protocol.");
        })).setAssignment((byte[])assignment.getOrElse((Object)memberMetadata.memberId(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(56).append("Attempted to write member ").append(memberMetadata.memberId()).append(" of group ").append(groupMetadata.groupId()).append(" with no assignment.").toString());
        })), List$.MODULE$.canBuildFrom())).asJava()));
    }

    public BaseKey readMessageKey(ByteBuffer buffer) {
        short version = buffer.getShort();
        if (version >= 0 && version <= 1) {
            OffsetCommitKey key = new OffsetCommitKey((Readable)new ByteBufferAccessor(buffer), version);
            return new OffsetKey(version, new GroupTopicPartition(key.group(), new TopicPartition(key.topic(), key.partition())));
        }
        if (version >= 2 && version <= 2) {
            kafka.internals.generated.GroupMetadataKey key = new kafka.internals.generated.GroupMetadataKey((Readable)new ByteBufferAccessor(buffer), version);
            return new GroupMetadataKey(version, key.group());
        }
        return new UnknownKey(version);
    }

    public OffsetAndMetadata readOffsetMessageValue(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 4) {
            OffsetCommitValue value = new OffsetCommitValue((Readable)new ByteBufferAccessor(buffer), version);
            return new OffsetAndMetadata(value.offset(), value.leaderEpoch() == -1 ? Optional.empty() : Optional.of(Predef$.MODULE$.int2Integer(value.leaderEpoch())), value.metadata(), value.commitTimestamp(), (Option<Object>)(value.expireTimestamp() == -1L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)value.expireTimestamp()))));
        }
        throw new IllegalStateException(new StringBuilder(32).append("Unknown offset message version: ").append(version).toString());
    }

    public GroupMetadata readGroupMessageValue(String groupId, ByteBuffer buffer, Time time) {
        if (buffer == null) {
            return null;
        }
        short version = buffer.getShort();
        if (version >= 0 && version <= 4) {
            GroupMetadataValue value = new GroupMetadataValue((Readable)new ByteBufferAccessor(buffer), version);
            Buffer members = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(value.members()).asScala()).map((Function1 & Serializable & scala.Serializable)memberMetadata -> new MemberMetadata(memberMetadata.memberId(), (Option<String>)Option$.MODULE$.apply((Object)memberMetadata.groupInstanceId()), memberMetadata.clientId(), memberMetadata.clientHost(), version == 0 ? memberMetadata.sessionTimeout() : memberMetadata.rebalanceTimeout(), memberMetadata.sessionTimeout(), value.protocolType(), (List<Tuple2<String, byte[]>>)new .colon.colon((Object)new Tuple2((Object)value.protocol(), (Object)memberMetadata.subscription()), (List)Nil$.MODULE$), memberMetadata.assignment()), Buffer$.MODULE$.canBuildFrom());
            return GroupMetadata$.MODULE$.loadGroup(groupId, (GroupState)(members.isEmpty() ? Empty$.MODULE$ : Stable$.MODULE$), value.generation(), value.protocolType(), value.protocol(), value.leader(), (Option<Object>)(value.currentStateTimestamp() == -1L ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)value.currentStateTimestamp()))), (Iterable<MemberMetadata>)members, time);
        }
        throw new IllegalStateException(new StringBuilder(40).append("Unknown group metadata message version: ").append(version).toString());
    }

    public Tuple2<Option<String>, Option<String>> formatRecordKeyAndValue(Record record) {
        Tuple2 tuple2;
        if (!record.hasKey()) {
            throw new KafkaException("Failed to decode message using offset topic decoder (message had a missing key)");
        }
        BaseKey baseKey = this.readMessageKey(record.key());
        if (baseKey instanceof OffsetKey) {
            OffsetKey offsetKey = (OffsetKey)baseKey;
            tuple2 = this.parseOffsets(offsetKey, record.value());
        } else if (baseKey instanceof GroupMetadataKey) {
            GroupMetadataKey groupMetadataKey = (GroupMetadataKey)baseKey;
            tuple2 = this.parseGroupMetadata(groupMetadataKey, record.value());
        } else if (baseKey instanceof UnknownKey) {
            UnknownKey unknownKey = (UnknownKey)baseKey;
            tuple2 = new Tuple2((Object)new Some((Object)new StringBuilder(17).append("unknown::version=").append(unknownKey.version()).toString()), (Object)None$.MODULE$);
        } else {
            throw new MatchError((Object)baseKey);
        }
        return tuple2;
    }

    private Tuple2<Option<String>, Option<String>> parseOffsets(OffsetKey offsetKey, ByteBuffer payload) {
        String groupId = offsetKey.key().group();
        TopicPartition topicPartition = offsetKey.key().topicPartition();
        String keyString = new StringBuilder(32).append("offset_commit::group=").append(groupId).append(",partition=").append(topicPartition).toString();
        OffsetAndMetadata offset = this.readOffsetMessageValue(payload);
        String valueString = offset == null ? "<DELETE>" : (offset.metadata().isEmpty() ? new StringBuilder(7).append("offset=").append(offset.offset()).toString() : new StringBuilder(17).append("offset=").append(offset.offset()).append(",metadata=").append(offset.metadata()).toString());
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    private Tuple2<Option<String>, Option<String>> parseGroupMetadata(GroupMetadataKey groupMetadataKey, ByteBuffer payload) {
        String string;
        String groupId = groupMetadataKey.key();
        String keyString = new StringBuilder(22).append("group_metadata::group=").append(groupId).toString();
        GroupMetadata group = this.readGroupMessageValue(groupId, payload, Time.SYSTEM);
        if (group == null) {
            string = "<DELETE>";
        } else {
            String protocolType = (String)group.protocolType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String assignment = ((TraversableOnce)group.allMemberMetadata().map((Function1 & Serializable & scala.Serializable)member -> {
                String string = protocolType;
                String string2 = "consumer";
                if (string != null && string.equals(string2)) {
                    ConsumerPartitionAssignor.Assignment partitionAssignment = ConsumerProtocol.deserializeAssignment((ByteBuffer)ByteBuffer.wrap(member.assignment()));
                    String userData = (String)Option$.MODULE$.apply((Object)partitionAssignment.userData()).map((Function1 & Serializable & scala.Serializable)x$1 -> Utils.toArray((ByteBuffer)x$1)).map((Function1 & Serializable & scala.Serializable)bytes -> MODULE$.hex((byte[])bytes)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
                    if (userData.isEmpty()) {
                        return new StringBuilder(1).append(member.memberId()).append("=").append(partitionAssignment.partitions()).toString();
                    }
                    return new StringBuilder(2).append(member.memberId()).append("=").append(partitionAssignment.partitions()).append(":").append(userData).toString();
                }
                return new StringBuilder(1).append(member.memberId()).append("=").append(MODULE$.hex(member.assignment())).toString();
            }, List$.MODULE$.canBuildFrom())).mkString("{", ",", "}");
            string = Json$.MODULE$.encodeAsString(CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocolType"), (Object)protocolType), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"protocol"), group.protocolName().orNull(Predef$.MODULE$.$conforms())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"generationId"), (Object)BoxesRunTime.boxToInteger((int)group.generationId())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"assignment"), (Object)assignment)}))).asJava());
        }
        String valueString = string;
        return new Tuple2((Object)new Some((Object)keyString), (Object)new Some((Object)valueString));
    }

    private String hex(byte[] bytes) {
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).isEmpty()) {
            return "";
        }
        return new StringOps(Predef$.MODULE$.augmentString("%X")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{package$.MODULE$.BigInt().apply(1, bytes)}));
    }

    private GroupMetadataManager$() {
        MODULE$ = this;
        this.MetricsGroup = "group-coordinator-metrics";
        this.LoadTimeSensor = "GroupPartitionLoadTime";
        this.OffsetCommitsSensor = "OffsetCommits";
        this.OffsetExpiredSensor = "OffsetExpired";
    }
}

