/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kafka.server.FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$;
import kafka.server.FinalizedFeatureChangeListener$ZkStateChangeHandler$;
import kafka.server.metadata.FeatureCacheUpdateException;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.Logging;
import kafka.utils.ShutdownableThread;
import kafka.utils.ShutdownableThread$;
import kafka.zk.FeatureZNode;
import kafka.zk.FeatureZNode$;
import kafka.zk.FeatureZNodeStatus;
import kafka.zk.FeatureZNodeStatus$Disabled$;
import kafka.zk.FeatureZNodeStatus$Enabled$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZkVersion$;
import org.apache.kafka.common.internals.FatalExitError;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0015+\u0001=B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%I!\u0010\u0005\t\t\u0002\u0011\t\u0011)A\u0005}!AQ\t\u0001BC\u0002\u0013%a\t\u0003\u0005N\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015q\u0005\u0001\"\u0001P\r\u0011!\u0006\u0001B+\t\u0011Y3!\u0011!Q\u0001\n]C\u0001B\u0019\u0004\u0003\u0002\u0003\u0006Ia\u0019\u0005\u0006\u001d\u001a!\t\u0001\u001d\u0005\u0006\u001d\u001a!\t!\u001e\u0005\u0006o\u001a!\t\u0001\u001f\u0005\u0006y\u001a!\t! \u0004\u0007\u0003\u000f\u0001A!!\u0003\t\u0017\u0005EQB!A!\u0002\u00139\u00161\u0003\u0005\u0007\u001d6!\t!!\u0006\t\r\u0005mQ\u0002\"\u0011y\u000f\u001d\ti\u0002\u0001E\u0001\u0003?1q!!\t\u0001\u0011\u0003\t\u0019\u0003\u0003\u0004O%\u0011\u0005\u0011\u0011\u0007\u0005\n\u0003g\u0011\"\u0019!C!\u0003kAq!a\u000e\u0013A\u0003%q\u000b\u0003\u0004\u0002:I!\t\u0005\u001f\u0005\u0007\u0003w\u0011B\u0011\t=\t\r\u0005u\"\u0003\"\u0011y\u000f\u001d\ty\u0004\u0001E\u0001\u0003\u00032q!a\u0011\u0001\u0011\u0003\t)\u0005\u0003\u0004O5\u0011\u0005\u0011Q\n\u0005\n\u0003gQ\"\u0019!C\u0001\u0003kAq!a\u000e\u001bA\u0003%q\u000bC\u0005\u0002\u0012i\u0011\r\u0011\"\u0011\u00026!9\u0011q\n\u000e!\u0002\u00139\u0006BBA)5\u0011\u0005\u0003\u0010C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!A\u0011Q\f\u0001!\u0002\u0013\t9\u0006C\u0005\u0002`\u0001\u0011\r\u0011\"\u0003\u0002b!A\u00111\r\u0001!\u0002\u0013\t9\u0002C\u0004\u0002f\u0001!\t!a\u001a\t\r\u00055\u0004\u0001\"\u0001y\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!!\u001f\u0001\t\u0003\t\tH\u0001\u0010GS:\fG.\u001b>fI\u001a+\u0017\r^;sK\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8fe*\u00111\u0006L\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u00035\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001aY\u0002\"!\r\u001b\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012a!\u00118z%\u00164\u0007CA\u001c;\u001b\u0005A$BA\u001d-\u0003\u0015)H/\u001b7t\u0013\tY\u0004HA\u0004M_\u001e<\u0017N\\4\u0002+\u0019Lg.\u00197ju\u0016$g)Z1ukJ,7)Y2iKV\ta\b\u0005\u0002@\u00056\t\u0001I\u0003\u0002BU\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002D\u0001\ny!l['fi\u0006$\u0017\r^1DC\u000eDW-\u0001\fgS:\fG.\u001b>fI\u001a+\u0017\r^;sK\u000e\u000b7\r[3!\u0003!Q8n\u00117jK:$X#A$\u0011\u0005![U\"A%\u000b\u0005)c\u0013A\u0001>l\u0013\ta\u0015JA\u0007LC\u001a\\\u0017MW6DY&,g\u000e^\u0001\nu.\u001cE.[3oi\u0002\na\u0001P5oSRtDc\u0001)S'B\u0011\u0011\u000bA\u0007\u0002U!)A(\u0002a\u0001}!)Q)\u0002a\u0001\u000f\n\u0019b)Z1ukJ,7)Y2iKV\u0003H-\u0019;feN\u0011a\u0001M\u0001\u0012M\u0016\fG/\u001e:f5.tu\u000eZ3QCRD\u0007C\u0001-`\u001d\tIV\f\u0005\u0002[e5\t1L\u0003\u0002]]\u00051AH]8pizJ!A\u0018\u001a\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0017M\u0001\u0004TiJLgn\u001a\u0006\u0003=J\nq\"\\1zE\u0016tu\u000e^5gs>s7-\u001a\t\u0004c\u00114\u0017BA33\u0005\u0019y\u0005\u000f^5p]B\u0011qM\\\u0007\u0002Q*\u0011\u0011N[\u0001\u000bG>t7-\u001e:sK:$(BA6m\u0003\u0011)H/\u001b7\u000b\u00035\fAA[1wC&\u0011q\u000e\u001b\u0002\u000f\u0007>,h\u000e\u001e#po:d\u0015\r^2i)\r\t8\u000f\u001e\t\u0003e\u001ai\u0011\u0001\u0001\u0005\u0006-&\u0001\ra\u0016\u0005\u0006E&\u0001\ra\u0019\u000b\u0003cZDQA\u0016\u0006A\u0002]\u000b1#\u001e9eCR,G*\u0019;fgR|%\u000f\u00165s_^$\u0012!\u001f\t\u0003ciL!a\u001f\u001a\u0003\tUs\u0017\u000e^\u0001\u0013C^\f\u0017\u000e^+qI\u0006$Xm\u0014:UQJ|w\u000f\u0006\u0002z}\"1q\u0010\u0004a\u0001\u0003\u0003\t!b^1jiRKW.Z't!\r\t\u00141A\u0005\u0004\u0003\u000b\u0011$\u0001\u0002'p]\u001e\u0014\u0011e\u00115b]\u001e,gj\u001c;jM&\u001c\u0017\r^5p]B\u0013xnY3tg>\u0014H\u000b\u001b:fC\u0012\u001c2!DA\u0006!\r9\u0014QB\u0005\u0004\u0003\u001fA$AE*ikR$wn\u001e8bE2,G\u000b\u001b:fC\u0012\fAA\\1nK&!\u0011\u0011CA\u0007)\u0011\t9\"!\u0007\u0011\u0005Il\u0001BBA\t\u001f\u0001\u0007q+\u0001\u0004e_^{'o[\u0001\u001a\r\u0016\fG/\u001e:f5:{G-Z\"iC:<W\rS1oI2,'\u000f\u0005\u0002s%\tIb)Z1ukJ,'LT8eK\u000eC\u0017M\\4f\u0011\u0006tG\r\\3s'\u0011\u0011\u0002'!\n\u0011\t\u0005\u001d\u0012QF\u0007\u0003\u0003SQ1!a\u000b-\u0003%Qxn\\6fKB,'/\u0003\u0003\u00020\u0005%\"A\u0005.O_\u0012,7\t[1oO\u0016D\u0015M\u001c3mKJ$\"!a\b\u0002\tA\fG\u000f[\u000b\u0002/\u0006)\u0001/\u0019;iA\u0005q\u0001.\u00198eY\u0016\u001c%/Z1uS>t\u0017\u0001\u00055b]\u0012dW\rR1uC\u000eC\u0017M\\4f\u00039A\u0017M\u001c3mK\u0012+G.\u001a;j_:\fACW6Ti\u0006$Xm\u00115b]\u001e,\u0007*\u00198eY\u0016\u0014\bC\u0001:\u001b\u0005QQ6n\u0015;bi\u0016\u001c\u0005.\u00198hK\"\u000bg\u000e\u001a7feN!!\u0004MA$!\u0011\t9#!\u0013\n\t\u0005-\u0013\u0011\u0006\u0002\u0013'R\fG/Z\"iC:<W\rS1oI2,'\u000f\u0006\u0002\u0002B\u0005)a.Y7fA\u0005A\u0012M\u001a;fe&s\u0017\u000e^5bY&T\u0018N\\4TKN\u001c\u0018n\u001c8\u0002\u000bE,X-^3\u0016\u0005\u0005]\u0003\u0003B4\u0002ZEL1!a\u0017i\u0005Ma\u0015N\\6fI\ncwnY6j]\u001e\fV/Z;f\u0003\u0019\tX/Z;fA\u00051A\u000f\u001b:fC\u0012,\"!a\u0006\u0002\u000fQD'/Z1eA\u0005Y\u0011N\\5u\u001fJ$\u0006N]8x)\rI\u0018\u0011\u000e\u0005\b\u0003W*\u0003\u0019AA\u0001\u0003a9\u0018-\u001b;P]\u000e,gi\u001c:DC\u000eDW-\u00169eCR,Wj]\u0001\u0006G2|7/Z\u0001\u0014SNd\u0015n\u001d;f]\u0016\u0014\u0018J\\5uS\u0006$X\rZ\u000b\u0003\u0003g\u00022!MA;\u0013\r\t9H\r\u0002\b\u0005>|G.Z1o\u00039I7\u000fT5ti\u0016tWM\u001d#fC\u0012\u0004")
public class FinalizedFeatureChangeListener
implements Logging {
    private volatile FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$ FeatureZNodeChangeHandler$module;
    private volatile FinalizedFeatureChangeListener$ZkStateChangeHandler$ ZkStateChangeHandler$module;
    private final ZkMetadataCache kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache;
    private final KafkaZkClient kafka$server$FinalizedFeatureChangeListener$$zkClient;
    private final LinkedBlockingQueue<FeatureCacheUpdater> kafka$server$FinalizedFeatureChangeListener$$queue;
    private final ChangeNotificationProcessorThread thread;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$ FeatureZNodeChangeHandler() {
        if (this.FeatureZNodeChangeHandler$module == null) {
            this.FeatureZNodeChangeHandler$lzycompute$1();
        }
        return this.FeatureZNodeChangeHandler$module;
    }

    public FinalizedFeatureChangeListener$ZkStateChangeHandler$ ZkStateChangeHandler() {
        if (this.ZkStateChangeHandler$module == null) {
            this.ZkStateChangeHandler$lzycompute$1();
        }
        return this.ZkStateChangeHandler$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ZkMetadataCache kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache() {
        return this.kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache;
    }

    public KafkaZkClient kafka$server$FinalizedFeatureChangeListener$$zkClient() {
        return this.kafka$server$FinalizedFeatureChangeListener$$zkClient;
    }

    public LinkedBlockingQueue<FeatureCacheUpdater> kafka$server$FinalizedFeatureChangeListener$$queue() {
        return this.kafka$server$FinalizedFeatureChangeListener$$queue;
    }

    private ChangeNotificationProcessorThread thread() {
        return this.thread;
    }

    public void initOrThrow(long waitOnceForCacheUpdateMs) {
        if (waitOnceForCacheUpdateMs <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(53).append("Expected waitOnceForCacheUpdateMs > 0, but provided: ").append(waitOnceForCacheUpdateMs).toString());
        }
        this.thread().start();
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().registerStateChangeHandler(this.ZkStateChangeHandler());
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().registerZNodeChangeHandlerAndCheckExistence(this.FeatureZNodeChangeHandler());
        FeatureCacheUpdater ensureCacheUpdateOnce = new FeatureCacheUpdater(this, this.FeatureZNodeChangeHandler().path(), (Option<CountDownLatch>)new Some((Object)new CountDownLatch(1)));
        this.kafka$server$FinalizedFeatureChangeListener$$queue().add(ensureCacheUpdateOnce);
        try {
            ensureCacheUpdateOnce.awaitUpdateOrThrow(waitOnceForCacheUpdateMs);
            return;
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().unregisterStateChangeHandler(this.ZkStateChangeHandler().name());
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient().unregisterZNodeChangeHandler(this.FeatureZNodeChangeHandler().path());
        this.kafka$server$FinalizedFeatureChangeListener$$queue().clear();
        this.thread().shutdown();
    }

    public boolean isListenerInitiated() {
        return this.thread().isRunning() && this.thread().isAlive();
    }

    public boolean isListenerDead() {
        return !this.thread().isRunning() && !this.thread().isAlive();
    }

    private final void FeatureZNodeChangeHandler$lzycompute$1() {
        synchronized (this) {
            if (this.FeatureZNodeChangeHandler$module == null) {
                this.FeatureZNodeChangeHandler$module = new FinalizedFeatureChangeListener$FeatureZNodeChangeHandler$(this);
            }
            return;
        }
    }

    private final void ZkStateChangeHandler$lzycompute$1() {
        synchronized (this) {
            if (this.ZkStateChangeHandler$module == null) {
                this.ZkStateChangeHandler$module = new FinalizedFeatureChangeListener$ZkStateChangeHandler$(this);
            }
            return;
        }
    }

    public FinalizedFeatureChangeListener(ZkMetadataCache finalizedFeatureCache, KafkaZkClient zkClient) {
        this.kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache = finalizedFeatureCache;
        this.kafka$server$FinalizedFeatureChangeListener$$zkClient = zkClient;
        Logging.$init$(this);
        this.kafka$server$FinalizedFeatureChangeListener$$queue = new LinkedBlockingQueue();
        this.thread = new ChangeNotificationProcessorThread("feature-zk-node-event-process-thread");
    }

    private class ChangeNotificationProcessorThread
    extends ShutdownableThread {
        @Override
        public void doWork() {
            try {
                this.kafka$server$FinalizedFeatureChangeListener$ChangeNotificationProcessorThread$$$outer().kafka$server$FinalizedFeatureChangeListener$$queue().take().updateLatestOrThrow();
                return;
            }
            catch (InterruptedException interruptedException) {
                throw interruptedException;
            }
            catch (FeatureCacheUpdateException cacheUpdateException) {
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to process feature ZK node change event. The broker will eventually exit.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> cacheUpdateException);
                throw new FatalExitError(1);
            }
            catch (Exception e) {
                this.warn((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Unexpected exception in feature ZK node change event processing; will continue processing.", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                return;
            }
        }

        public /* synthetic */ FinalizedFeatureChangeListener kafka$server$FinalizedFeatureChangeListener$ChangeNotificationProcessorThread$$$outer() {
            return FinalizedFeatureChangeListener.this;
        }

        public ChangeNotificationProcessorThread(String name) {
            if (FinalizedFeatureChangeListener.this == null) {
                throw null;
            }
            super(name, ShutdownableThread$.MODULE$.$lessinit$greater$default$2());
        }
    }

    private class FeatureCacheUpdater {
        private final String featureZkNodePath;
        private final Option<CountDownLatch> maybeNotifyOnce;
        public final /* synthetic */ FinalizedFeatureChangeListener $outer;

        /*
         * WARNING - void declaration
         */
        public void updateLatestOrThrow() {
            this.maybeNotifyOnce.foreach((Function1 & Serializable & scala.Serializable)notifier -> {
                FeatureCacheUpdater.$anonfun$updateLatestOrThrow$1(notifier);
                return BoxedUnit.UNIT;
            });
            this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Reading feature ZK node at path: ").append($this.featureZkNodePath).toString());
            Tuple2<Option<byte[]>, Object> tuple2 = this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$zkClient().getDataAndVersion(this.featureZkNodePath);
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            Option mayBeFeatureZNodeBytes = (Option)tuple2._1();
            int n = tuple2._2$mcI$sp();
            if (n == ZkVersion$.MODULE$.UnknownVersion()) {
                this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Feature ZK node at path: ").append($this.featureZkNodePath).append(" does not exist").toString());
                this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clearFeatures();
            } else {
                Option maybeFeatureZNode = Option$.MODULE$.empty();
                try {
                    void var2_2;
                    maybeFeatureZNode = new Some((Object)FeatureZNode$.MODULE$.decode((byte[])var2_2.get()));
                }
                catch (IllegalArgumentException e) {
                    this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(47).append("Unable to deserialize feature ZK node at path: ").append($this.featureZkNodePath).toString(), (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clearFeatures();
                }
                maybeFeatureZNode.foreach((Function1 & Serializable & scala.Serializable)featureZNode -> {
                    FeatureCacheUpdater.$anonfun$updateLatestOrThrow$6(this, n, featureZNode);
                    return BoxedUnit.UNIT;
                });
            }
            this.maybeNotifyOnce.foreach((Function1 & Serializable & scala.Serializable)notifier -> {
                notifier.countDown();
                return BoxedUnit.UNIT;
            });
        }

        public void awaitUpdateOrThrow(long waitTimeMs) {
            this.maybeNotifyOnce.foreach((Function1 & Serializable & scala.Serializable)notifier -> {
                FeatureCacheUpdater.$anonfun$awaitUpdateOrThrow$1(waitTimeMs, notifier);
                return BoxedUnit.UNIT;
            });
        }

        public /* synthetic */ FinalizedFeatureChangeListener kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ void $anonfun$updateLatestOrThrow$1(CountDownLatch notifier) {
            if (notifier.getCount() != 1L) {
                throw new IllegalStateException("Can not notify after updateLatestOrThrow was called more than once successfully.");
            }
        }

        public static final /* synthetic */ void $anonfun$updateLatestOrThrow$6(FeatureCacheUpdater $this, int version$1, FeatureZNode featureZNode) {
            FeatureZNodeStatus featureZNodeStatus = featureZNode.status();
            if (FeatureZNodeStatus$Disabled$.MODULE$.equals(featureZNodeStatus)) {
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Feature ZK node at path: ").append($this.featureZkNodePath).append(" is in disabled status.").toString());
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().clearFeatures();
                return;
            }
            if (FeatureZNodeStatus$Enabled$.MODULE$.equals(featureZNodeStatus)) {
                $this.kafka$server$FinalizedFeatureChangeListener$FeatureCacheUpdater$$$outer().kafka$server$FinalizedFeatureChangeListener$$finalizedFeatureCache().updateFeaturesOrThrow((Map<String, Object>)featureZNode.features().toMap(Predef$.MODULE$.$conforms()), version$1);
                return;
            }
            throw new IllegalStateException(new StringBuilder(39).append("Unexpected FeatureZNodeStatus found in ").append(featureZNode).toString());
        }

        public static final /* synthetic */ void $anonfun$awaitUpdateOrThrow$1(long waitTimeMs$1, CountDownLatch notifier) {
            if (!notifier.await(waitTimeMs$1, TimeUnit.MILLISECONDS)) {
                throw new TimeoutException(new StringBuilder(62).append("Timed out after waiting for ").append(waitTimeMs$1).append("ms for FeatureCache to be updated.").toString());
            }
        }

        public FeatureCacheUpdater(FinalizedFeatureChangeListener $outer, String featureZkNodePath, Option<CountDownLatch> maybeNotifyOnce) {
            this.featureZkNodePath = featureZkNodePath;
            this.maybeNotifyOnce = maybeNotifyOnce;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }

        public FeatureCacheUpdater(FinalizedFeatureChangeListener $outer, String featureZkNodePath) {
            this($outer, featureZkNodePath, (Option<CountDownLatch>)Option$.MODULE$.empty());
        }
    }
}

