/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.tools.CompositeTopicPartitionFilter;
import kafka.tools.PartitionFilter;
import kafka.tools.PartitionRangeFilter;
import kafka.tools.PartitionsSetFilter;
import kafka.tools.TopicFilterAndPartitionFilter;
import kafka.tools.TopicPartitionFilter;
import kafka.tools.UniquePartitionFilter;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.IncludeList;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.ListTopicsOptions;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class GetOffsetShell$ {
    public static GetOffsetShell$ MODULE$;
    private final Pattern TopicPartitionPattern;

    static {
        new GetOffsetShell$();
    }

    private Pattern TopicPartitionPattern() {
        return this.TopicPartitionPattern;
    }

    public void main(String[] args) {
        try {
            this.fetchOffsets(args);
            return;
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("Error occurred: ").append(e.getMessage()).toString());
            throw Exit$.MODULE$.exit(1, (Option<String>)new Some((Object)e.getMessage()));
        }
    }

    public void fetchOffsets(String[] args) {
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "DEPRECATED, use --bootstrap-server instead; ignored if --bootstrap-server is specified. The server(s) to connect to in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("HOST1:PORT1,...,HOST3:PORT3").ofType(String.class);
        ArgumentAcceptingOptionSpec bootstrapServerOpt = parser.accepts("bootstrap-server", "REQUIRED. The server(s) to connect to in the form HOST1:PORT1,HOST2:PORT2.").requiredUnless("broker-list", new String[0]).withRequiredArg().describedAs("HOST1:PORT1,...,HOST3:PORT3").ofType(String.class);
        ArgumentAcceptingOptionSpec topicPartitionsOpt = parser.accepts("topic-partitions", new StringBuilder(496).append("Comma separated list of topic-partition patterns to get the offsets for, with the format of '").append(this.TopicPartitionPattern()).append("'.").append(" The first group is an optional regex for the topic name, if omitted, it matches any topic name.").append(" The section after ':' describes a 'partition' pattern, which can be: a number, a range in the format of 'NUMBER-NUMBER' (lower inclusive, upper exclusive), an inclusive lower bound in the format of 'NUMBER-', an exclusive upper bound in the format of '-NUMBER' or may be omitted to accept all partitions.").toString()).withRequiredArg().describedAs("topic1:1,topic2:0-3,topic3,topic4:5-,topic5:-3").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "The topic to get the offsets for. It also accepts a regular expression. If not present, all authorized topics are queried. Cannot be used if --topic-partitions is present.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionsOpt = parser.accepts("partitions", "Comma separated list of partition ids to get the offsets for. If not present, all partitions of the authorized topics are queried. Cannot be used if --topic-partitions is present.").withRequiredArg().describedAs("partition ids").ofType(String.class);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that. [Note: No offset is returned, if the timestamp greater than recently committed record timestamp is given.]").withRequiredArg().describedAs("<timestamp> / -1 or latest / -2 or earliest / -3 or max-timestamp").ofType(String.class).defaultsTo((Object)"latest", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec commandConfigOpt = parser.accepts("command-config", "Property file containing configs to be passed to Admin Client.").withRequiredArg().describedAs("config file").ofType(String.class);
        OptionSpecBuilder excludeInternalTopicsOpt = parser.accepts("exclude-internal-topics", "By default, internal topics are included. If specified, internal topics are excluded.");
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).isEmpty()) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting topic-partition offsets.");
        }
        OptionSet options = parser.parse(args);
        ArgumentAcceptingOptionSpec effectiveBrokerListOpt = options.has((OptionSpec)bootstrapServerOpt) ? bootstrapServerOpt : brokerListOpt;
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{effectiveBrokerListOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)effectiveBrokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        boolean excludeInternalTopics = options.has((OptionSpec)excludeInternalTopicsOpt);
        if (options.has((OptionSpec)topicPartitionsOpt) && (options.has((OptionSpec)topicOpt) || options.has((OptionSpec)partitionsOpt))) {
            throw new IllegalArgumentException("--topic-partitions cannot be used with --topic or --partitions");
        }
        OffsetSpec offsetSpec = this.parseOffsetSpec((String)options.valueOf((OptionSpec)timeOpt));
        TopicPartitionFilter topicPartitionFilter = options.has((OptionSpec)topicPartitionsOpt) ? this.createTopicPartitionFilterWithPatternList((String)options.valueOf((OptionSpec)topicPartitionsOpt)) : this.createTopicPartitionFilterWithTopicAndPartitionPattern((Option<String>)(options.has((OptionSpec)topicOpt) ? new Some(options.valueOf((OptionSpec)topicOpt)) : None$.MODULE$), (String)options.valueOf((OptionSpec)partitionsOpt));
        Properties config = options.has((OptionSpec)commandConfigOpt) ? Utils.loadProps((String)((String)options.valueOf((OptionSpec)commandConfigOpt))) : new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId);
        try (Admin adminClient = Admin.create((Properties)config);){
            Seq<TopicPartition> partitionInfos = this.listPartitionInfos(adminClient, topicPartitionFilter, excludeInternalTopics);
            if (partitionInfos.isEmpty()) {
                throw new IllegalArgumentException("Could not match any topic-partitions with the specified filters");
            }
            java.util.Map timestampsToSearch = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)partitionInfos.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)offsetSpec), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
            ListOffsetsResult listOffsetsResult = adminClient.listOffsets(timestampsToSearch);
            ((IterableLike)((Seq)partitionInfos.flatMap((Function1 & Serializable & scala.Serializable)tp -> {
                Iterable iterable;
                try {
                    ListOffsetsResult.ListOffsetsResultInfo partitionInfo = (ListOffsetsResult.ListOffsetsResultInfo)listOffsetsResult.partitionResult(tp).get();
                    if (partitionInfo.offset() == -1L) {
                        return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2(tp, (Object)BoxesRunTime.boxToLong((long)partitionInfo.offset()))));
                }
                catch (ExecutionException e) {
                    Throwable throwable = e.getCause();
                    if (!(throwable instanceof KafkaException)) {
                        throw e;
                    }
                    KafkaException kafkaException = (KafkaException)throwable;
                    System.err.println(new StringBuilder(57).append("Skip getting offsets for topic-partition ").append(tp.topic()).append(":").append(tp.partition()).append(" due to error: ").append(kafkaException.getMessage()).toString());
                    iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return iterable;
            }, Seq$.MODULE$.canBuildFrom())).sortWith((Function2 & Serializable & scala.Serializable)(tp1, tp2) -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.MODULE$.compareTopicPartitions((TopicPartition)tp1._1(), (TopicPartition)tp2._1())))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                GetOffsetShell$.$anonfun$fetchOffsets$4(x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    private OffsetSpec parseOffsetSpec(String listOffsetsTimestamp) {
        OffsetSpec offsetSpec;
        if ("earliest".equals(listOffsetsTimestamp)) {
            offsetSpec = OffsetSpec.earliest();
        } else if ("latest".equals(listOffsetsTimestamp)) {
            offsetSpec = OffsetSpec.latest();
        } else if ("max-timestamp".equals(listOffsetsTimestamp)) {
            offsetSpec = OffsetSpec.maxTimestamp();
        } else {
            OffsetSpec offsetSpec2;
            try {
                long l = new StringOps(Predef$.MODULE$.augmentString(listOffsetsTimestamp)).toLong();
                OffsetSpec offsetSpec3 = -2L == l ? OffsetSpec.earliest() : (-1L == l ? OffsetSpec.latest() : (-3L == l ? OffsetSpec.maxTimestamp() : OffsetSpec.forTimestamp((long)l)));
                offsetSpec2 = offsetSpec3;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(new StringBuilder(126).append("Malformed time argument ").append(listOffsetsTimestamp).append(", please use -1 or latest / -2 or earliest / -3 or max-timestamp, or a specified long format timestamp").toString(), e);
            }
            offsetSpec = offsetSpec2;
        }
        return offsetSpec;
    }

    public boolean compareTopicPartitions(TopicPartition a, TopicPartition b) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)new Tuple2((Object)a.topic(), (Object)BoxesRunTime.boxToInteger((int)a.partition())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$less((Object)new Tuple2((Object)b.topic(), (Object)BoxesRunTime.boxToInteger((int)b.partition())));
    }

    public TopicPartitionFilter createTopicPartitionFilterWithPatternList(String topicPartitions) {
        String[] ruleSpecs = topicPartitions.split(",");
        TopicPartitionFilter[] rules = (TopicPartitionFilter[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ruleSpecs)).map((Function1 & Serializable & scala.Serializable)ruleSpec -> MODULE$.parseRuleSpec((String)ruleSpec), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TopicPartitionFilter.class)));
        return new CompositeTopicPartitionFilter(rules);
    }

    public TopicPartitionFilter parseRuleSpec(String ruleSpec) {
        PartitionFilter partitionFilter;
        Matcher matcher = this.TopicPartitionPattern().matcher(ruleSpec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid rule specification: ").append(ruleSpec).toString());
        }
        IncludeList topicFilter = new IncludeList((String)GetOffsetShell$.group$1(1, matcher).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".*"));
        Option option = GetOffsetShell$.group$1(2, matcher).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$parseRuleSpec$3(x$1)));
        if (option instanceof Some) {
            int partition = BoxesRunTime.unboxToInt((Object)((Some)option).value());
            partitionFilter = new UniquePartitionFilter(partition);
        } else if (None$.MODULE$.equals(option)) {
            int lowerRange = BoxesRunTime.unboxToInt((Object)GetOffsetShell$.group$1(3, matcher).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$parseRuleSpec$4(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int upperRange = BoxesRunTime.unboxToInt((Object)GetOffsetShell$.group$1(4, matcher).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$parseRuleSpec$6(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
            partitionFilter = new PartitionRangeFilter(lowerRange, upperRange);
        } else {
            throw new MatchError((Object)option);
        }
        return new TopicFilterAndPartitionFilter(topicFilter, partitionFilter);
    }

    public TopicFilterAndPartitionFilter createTopicPartitionFilterWithTopicAndPartitionPattern(Option<String> topicOpt, String partitionIds) {
        return new TopicFilterAndPartitionFilter(new IncludeList((String)topicOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> ".*")), new PartitionsSetFilter(this.createPartitionSet(partitionIds)));
    }

    public scala.collection.immutable.Set<Object> createPartitionSet(String partitionsString) {
        if (partitionsString == null || partitionsString.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionsString.split(","))).map((Function1 & Serializable & scala.Serializable)partitionString -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$createPartitionSet$1(partitionsString, partitionString)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSet();
    }

    private Seq<TopicPartition> listPartitionInfos(Admin client, TopicPartitionFilter topicPartitionFilter, boolean excludeInternalTopics) {
        ListTopicsOptions listTopicsOptions = new ListTopicsOptions().listInternal(!excludeInternalTopics);
        Set topics = (Set)client.listTopics(listTopicsOptions).names().get();
        scala.collection.mutable.Set filteredTopics = (scala.collection.mutable.Set)((TraversableLike)CollectionConverters$.MODULE$.asScalaSetConverter(topics).asScala()).filter((Function1 & Serializable & scala.Serializable)topic -> BoxesRunTime.boxToBoolean((boolean)topicPartitionFilter.isTopicAllowed(topic)));
        return ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)client.describeTopics((Collection)CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter(filteredTopics).asJava()).allTopicNames().get()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            TopicDescription description = (TopicDescription)x0$1._2();
            Buffer buffer = (Buffer)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(description.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)tp -> new TopicPartition(topic, tp.partition()), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)partition -> BoxesRunTime.boxToBoolean((boolean)topicPartitionFilter.isTopicPartitionAllowed(partition)));
            return buffer;
        }, Iterable$.MODULE$.canBuildFrom())).toBuffer();
    }

    public static final /* synthetic */ void $anonfun$fetchOffsets$4(Tuple2 x0$1) {
        if (x0$1 != null) {
            TopicPartition tp = (TopicPartition)x0$1._1();
            long offset = x0$1._2$mcJ$sp();
            Predef$.MODULE$.println((Object)new StringBuilder(2).append(tp.topic()).append(":").append(tp.partition()).append(":").append(Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)offset)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$parseRuleSpec$1(String s) {
        return s != null && new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty();
    }

    private static final Option group$1(int group, Matcher matcher$1) {
        return Option$.MODULE$.apply((Object)matcher$1.group(group)).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.$anonfun$parseRuleSpec$1(s)));
    }

    public static final /* synthetic */ int $anonfun$parseRuleSpec$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ int $anonfun$parseRuleSpec$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ int $anonfun$parseRuleSpec$6(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ int $anonfun$createPartitionSet$1(String partitionsString$1, String partitionString) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(84).append("--partitions expects a comma separated list of numeric ").append("partition ids, but received: ").append(partitionsString$1).toString());
        }
    }

    private GetOffsetShell$() {
        MODULE$ = this;
        this.TopicPartitionPattern = Pattern.compile("([^:,]*)(?::(?:([0-9]*)|(?:([0-9]*)-([0-9]*))))?");
    }
}

