/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import kafka.cluster.AbstractPartitionTest$;
import kafka.cluster.AlterPartitionListener;
import kafka.cluster.DelayedOperations;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.Defaults$;
import kafka.server.MetadataCache;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.MockConfigRepository;
import kafka.server.metadata.MockConfigRepository$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.CleanerConfig;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\tMs!\u0002\u001c8\u0011\u0003ad!\u0002 8\u0011\u0003y\u0004\"\u0002$\u0002\t\u00039\u0005b\u0002%\u0002\u0005\u0004%\t!\u0013\u0005\u0007\u001b\u0006\u0001\u000b\u0011\u0002&\u0007\ty:\u0004A\u0014\u0005\u0006\r\u0016!\ta\u0014\u0005\b\u0011\u0016\u0011\r\u0011\"\u0001J\u0011\u0019iU\u0001)A\u0005\u0015\"9\u0011+\u0002b\u0001\n\u0003I\u0005B\u0002*\u0006A\u0003%!\nC\u0004T\u000b\t\u0007I\u0011\u0001+\t\r\u0001,\u0001\u0015!\u0003V\u0011\u001d\tWA1A\u0005\u0002\tDa![\u0003!\u0002\u0013\u0019\u0007\"\u00036\u0006\u0001\u0004\u0005\r\u0011\"\u0001l\u0011%!X\u00011AA\u0002\u0013\u0005Q\u000fC\u0005|\u000b\u0001\u0007\t\u0011)Q\u0005Y\"IA0\u0002a\u0001\u0002\u0004%\ta\u001b\u0005\n{\u0016\u0001\r\u00111A\u0005\u0002yD!\"!\u0001\u0006\u0001\u0004\u0005\t\u0015)\u0003m\u0011)\t\u0019!\u0002a\u0001\u0002\u0004%\ta\u001b\u0005\f\u0003\u000b)\u0001\u0019!a\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\f\u0015\u0001\r\u0011!Q!\n1D1\"!\u0004\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0010!Y\u0011QD\u0003A\u0002\u0003\u0007I\u0011AA\u0010\u0011-\t\u0019#\u0002a\u0001\u0002\u0003\u0006K!!\u0005\t\u0017\u0005\u0015R\u00011AA\u0002\u0013\u0005\u0011q\u0005\u0005\f\u0003\u000b*\u0001\u0019!a\u0001\n\u0003\t9\u0005C\u0006\u0002L\u0015\u0001\r\u0011!Q!\n\u0005%\u0002bCA'\u000b\u0001\u0007\t\u0019!C\u0001\u0003\u001fB1\"a\u0016\u0006\u0001\u0004\u0005\r\u0011\"\u0001\u0002Z!Y\u0011QL\u0003A\u0002\u0003\u0005\u000b\u0015BA)\u0011-\ty&\u0002a\u0001\u0002\u0004%\t!!\u0019\t\u0017\u0005UT\u00011AA\u0002\u0013\u0005\u0011q\u000f\u0005\f\u0003w*\u0001\u0019!A!B\u0013\t\u0019\u0007C\u0006\u0002~\u0015\u0001\r\u00111A\u0005\u0002\u0005}\u0004bCAI\u000b\u0001\u0007\t\u0019!C\u0001\u0003'C1\"a&\u0006\u0001\u0004\u0005\t\u0015)\u0003\u0002\u0002\"I\u0011\u0011T\u0003C\u0002\u0013\u0005\u00111\u0014\u0005\t\u0003G+\u0001\u0015!\u0003\u0002\u001e\"I\u0011QU\u0003C\u0002\u0013\u0005\u0011q\u0015\u0005\t\u0003c+\u0001\u0015!\u0003\u0002*\"I\u00111W\u0003C\u0002\u0013\u0005\u0011Q\u0017\u0005\t\u0003\u0007,\u0001\u0015!\u0003\u00028\"Y\u0011QY\u0003A\u0002\u0003\u0007I\u0011AAd\u0011-\ty-\u0002a\u0001\u0002\u0004%\t!!5\t\u0017\u0005UW\u00011A\u0001B\u0003&\u0011\u0011\u001a\u0005\b\u0003/,A\u0011AAm\u0011\u001d\t\t0\u0002C\t\u0003gDqA!\u0001\u0006\t\u0003\u0011\u0019\u0001C\u0004\u0003,\u0015!\t!!7\t\u000f\tUR\u0001\"\u0005\u00038!9!qI\u0003\u0005\u0002\t%\u0013!F!cgR\u0014\u0018m\u0019;QCJ$\u0018\u000e^5p]R+7\u000f\u001e\u0006\u0003qe\nqa\u00197vgR,'OC\u0001;\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0001\"!P\u0001\u000e\u0003]\u0012Q#\u00112tiJ\f7\r\u001e)beRLG/[8o)\u0016\u001cHo\u0005\u0002\u0002\u0001B\u0011\u0011\tR\u0007\u0002\u0005*\t1)A\u0003tG\u0006d\u0017-\u0003\u0002F\u0005\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012A\u0013\t\u0003\u0003.K!\u0001\u0014\"\u0003\u0007%sG/A\u0005ce>\\WM]%eAM\u0011Q\u0001\u0011\u000b\u0002!B\u0011Q(B\u0001\u0010e\u0016lw\u000e^3SKBd\u0017nY1JI\u0006\u0001\"/Z7pi\u0016\u0014V\r\u001d7jG\u0006LE\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005)\u0006C\u0001,_\u001b\u00059&B\u0001-Z\u0003\u0019\u0019w.\\7p]*\u0011!H\u0017\u0006\u00037r\u000ba!\u00199bG\",'\"A/\u0002\u0007=\u0014x-\u0003\u0002`/\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0017a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0011\u0002\tQLW.Z\u000b\u0002GB\u0011AmZ\u0007\u0002K*\u0011a-O\u0001\u0006kRLGn]\u0005\u0003Q\u0016\u0014\u0001\"T8dWRKW.Z\u0001\u0006i&lW\rI\u0001\u0007i6\u0004H)\u001b:\u0016\u00031\u0004\"!\u001c:\u000e\u00039T!a\u001c9\u0002\u0005%|'\"A9\u0002\t)\fg/Y\u0005\u0003g:\u0014AAR5mK\u0006QA/\u001c9ESJ|F%Z9\u0015\u0005YL\bCA!x\u0013\tA(I\u0001\u0003V]&$\bb\u0002>\u0011\u0003\u0003\u0005\r\u0001\\\u0001\u0004q\u0012\n\u0014a\u0002;na\u0012K'\u000fI\u0001\bY><G)\u001b:2\u0003-awn\u001a#jeFzF%Z9\u0015\u0005Y|\bb\u0002>\u0014\u0003\u0003\u0005\r\u0001\\\u0001\tY><G)\u001b:2A\u00059An\\4ESJ\u0014\u0014a\u00037pO\u0012K'OM0%KF$2A^A\u0005\u0011\u001dQh#!AA\u00021\f\u0001\u0002\\8h\t&\u0014(\u0007I\u0001\u000bY><W*\u00198bO\u0016\u0014XCAA\t!\u0011\t\u0019\"!\u0007\u000e\u0005\u0005U!bAA\fs\u0005\u0019An\\4\n\t\u0005m\u0011Q\u0003\u0002\u000b\u0019><W*\u00198bO\u0016\u0014\u0018A\u00047pO6\u000bg.Y4fe~#S-\u001d\u000b\u0004m\u0006\u0005\u0002\u0002\u0003>\u001a\u0003\u0003\u0005\r!!\u0005\u0002\u00171|w-T1oC\u001e,'\u000fI\u0001\u0016C2$XM\u001d)beRLG/[8o\u001b\u0006t\u0017mZ3s+\t\tI\u0003\u0005\u0003\u0002,\u0005}b\u0002BA\u0017\u0003wqA!a\f\u0002:9!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026m\na\u0001\u0010:p_Rt\u0014\"\u0001\u001e\n\u0005\u0019L\u0014bAA\u001fK\u0006IA+Z:u+RLGn]\u0005\u0005\u0003\u0003\n\u0019EA\rN_\u000e\\\u0017\t\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014(bAA\u001fK\u0006I\u0012\r\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014x\fJ3r)\r1\u0018\u0011\n\u0005\tur\t\t\u00111\u0001\u0002*\u00051\u0012\r\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014\b%\u0001\fbYR,'\u000fU1si&$\u0018n\u001c8MSN$XM\\3s+\t\t\t\u0006\u0005\u0003\u0002,\u0005M\u0013\u0002BA+\u0003\u0007\u0012!$T8dW\u0006cG/\u001a:QCJ$\u0018\u000e^5p]2K7\u000f^3oKJ\f!$\u00197uKJ\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM]0%KF$2A^A.\u0011!Qx$!AA\u0002\u0005E\u0013aF1mi\u0016\u0014\b+\u0019:uSRLwN\u001c'jgR,g.\u001a:!\u0003%awnZ\"p]\u001aLw-\u0006\u0002\u0002dA!\u0011QMA9\u001b\t\t9G\u0003\u0003\u0002\u0018\u0005%$\u0002BA6\u0003[\n\u0011\"\u001b8uKJt\u0017\r\\:\u000b\u0007\u0005=\u0014,A\u0004ti>\u0014\u0018mZ3\n\t\u0005M\u0014q\r\u0002\n\u0019><7i\u001c8gS\u001e\fQ\u0002\\8h\u0007>tg-[4`I\u0015\fHc\u0001<\u0002z!A!PIA\u0001\u0002\u0004\t\u0019'\u0001\u0006m_\u001e\u001cuN\u001c4jO\u0002\n\u0001cY8oM&<'+\u001a9pg&$xN]=\u0016\u0005\u0005\u0005\u0005\u0003BAB\u0003\u001bk!!!\"\u000b\t\u0005\u001d\u0015\u0011R\u0001\t[\u0016$\u0018\rZ1uC*\u0019\u00111R\u001d\u0002\rM,'O^3s\u0013\u0011\ty)!\"\u0003)5{7m[\"p]\u001aLwMU3q_NLGo\u001c:z\u0003Q\u0019wN\u001c4jOJ+\u0007o\\:ji>\u0014\u0018p\u0018\u0013fcR\u0019a/!&\t\u0011i,\u0013\u0011!a\u0001\u0003\u0003\u000b\u0011cY8oM&<'+\u001a9pg&$xN]=!\u0003E!W\r\\1zK\u0012|\u0005/\u001a:bi&|gn]\u000b\u0003\u0003;\u00032!PAP\u0013\r\t\tk\u000e\u0002\u0012\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:\u001c\u0018A\u00053fY\u0006LX\rZ(qKJ\fG/[8og\u0002\nQ\"\\3uC\u0012\fG/Y\"bG\",WCAAU!\u0011\tY+!,\u000e\u0005\u0005%\u0015\u0002BAX\u0003\u0013\u0013Q\"T3uC\u0012\fG/Y\"bG\",\u0017AD7fi\u0006$\u0017\r^1DC\u000eDW\rI\u0001\u0012_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001cXCAA\\!\u0011\tI,a0\u000e\u0005\u0005m&\u0002BA_\u0003\u0013\u000b1b\u00195fG.\u0004x.\u001b8ug&!\u0011\u0011YA^\u0005EyeMZ:fi\u000eCWmY6q_&tGo]\u0001\u0013_\u001a47/\u001a;DQ\u0016\u001c7\u000e]8j]R\u001c\b%A\u0005qCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u001a\t\u0004{\u0005-\u0017bAAgo\tI\u0001+\u0019:uSRLwN\\\u0001\u000ea\u0006\u0014H/\u001b;j_:|F%Z9\u0015\u0007Y\f\u0019\u000e\u0003\u0005{]\u0005\u0005\t\u0019AAe\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u0006g\u0016$X\u000f\u001d\u000b\u0002m\"\u001a\u0001'!8\u0011\t\u0005}\u0017Q^\u0007\u0003\u0003CTA!a9\u0002f\u0006\u0019\u0011\r]5\u000b\t\u0005\u001d\u0018\u0011^\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\tY\u000fX\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0003_\f\tO\u0001\u0006CK\u001a|'/Z#bG\"\f!$\u001b8uKJ\u0014%o\\6feB\u0013x\u000e^8d_24VM]:j_:,\"!!>\u0011\t\u0005]\u0018Q`\u0007\u0003\u0003sT1\u0001WA~\u0015\r\tY)W\u0005\u0005\u0003\u007f\fIPA\bNKR\fG-\u0019;b-\u0016\u00148/[8o\u0003M\u0019'/Z1uK2{w\r\u0015:pa\u0016\u0014H/[3t)\u0011\u0011)A!\u0005\u0011\t\t\u001d!QB\u0007\u0003\u0005\u0013Q1Aa\u0003q\u0003\u0011)H/\u001b7\n\t\t=!\u0011\u0002\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bb\u0002B\ne\u0001\u0007!QC\u0001\n_Z,'O]5eKN\u0004\u0002Ba\u0006\u0003 \t\u0015\"Q\u0005\b\u0005\u00053\u0011Y\u0002E\u0002\u00022\tK1A!\bC\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u0005B\u0012\u0005\ri\u0015\r\u001d\u0006\u0004\u0005;\u0011\u0005\u0003\u0002B\f\u0005OIAA!\u000b\u0003$\t11\u000b\u001e:j]\u001e\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004g\t=\u0002\u0003BAp\u0005cIAAa\r\u0002b\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u0018g\u0016$X\u000f\u001d)beRLG/[8o/&$\b.T8dWN$b!!3\u0003:\tu\u0002B\u0002B\u001ei\u0001\u0007!*A\u0006mK\u0006$WM]#q_\u000eD\u0007b\u0002B i\u0001\u0007!\u0011I\u0001\tSNdU-\u00193feB\u0019\u0011Ia\u0011\n\u0007\t\u0015#IA\u0004C_>dW-\u00198\u0002%\u0011,g-Y;mi\n\u0013xn[3s\u000bB|7\r\u001b\u000b\u0005\u0005\u0017\u0012\t\u0006E\u0002B\u0005\u001bJ1Aa\u0014C\u0005\u0011auN\\4\t\u000b!+\u0004\u0019\u0001&")
public class AbstractPartitionTest {
    private final int brokerId = AbstractPartitionTest$.MODULE$.brokerId();
    private final int remoteReplicaId = this.brokerId() + 1;
    private final TopicPartition topicPartition = new TopicPartition("test-topic", 0);
    private final MockTime time = new MockTime();
    private File tmpDir;
    private File logDir1;
    private File logDir2;
    private LogManager logManager;
    private TestUtils.MockAlterPartitionManager alterPartitionManager;
    private TestUtils.MockAlterPartitionListener alterPartitionListener;
    private LogConfig logConfig;
    private MockConfigRepository configRepository;
    private final DelayedOperations delayedOperations = (DelayedOperations)Mockito.mock(DelayedOperations.class);
    private final MetadataCache metadataCache = (MetadataCache)Mockito.mock(MetadataCache.class);
    private final OffsetCheckpoints offsetCheckpoints = (OffsetCheckpoints)Mockito.mock(OffsetCheckpoints.class);
    private Partition partition;

    public int brokerId() {
        return this.brokerId;
    }

    public int remoteReplicaId() {
        return this.remoteReplicaId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public MockTime time() {
        return this.time;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public void tmpDir_$eq(File x$1) {
        this.tmpDir = x$1;
    }

    public File logDir1() {
        return this.logDir1;
    }

    public void logDir1_$eq(File x$1) {
        this.logDir1 = x$1;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public void logDir2_$eq(File x$1) {
        this.logDir2 = x$1;
    }

    public LogManager logManager() {
        return this.logManager;
    }

    public void logManager_$eq(LogManager x$1) {
        this.logManager = x$1;
    }

    public TestUtils.MockAlterPartitionManager alterPartitionManager() {
        return this.alterPartitionManager;
    }

    public void alterPartitionManager_$eq(TestUtils.MockAlterPartitionManager x$1) {
        this.alterPartitionManager = x$1;
    }

    public TestUtils.MockAlterPartitionListener alterPartitionListener() {
        return this.alterPartitionListener;
    }

    public void alterPartitionListener_$eq(TestUtils.MockAlterPartitionListener x$1) {
        this.alterPartitionListener = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public void logConfig_$eq(LogConfig x$1) {
        this.logConfig = x$1;
    }

    public MockConfigRepository configRepository() {
        return this.configRepository;
    }

    public void configRepository_$eq(MockConfigRepository x$1) {
        this.configRepository = x$1;
    }

    public DelayedOperations delayedOperations() {
        return this.delayedOperations;
    }

    public MetadataCache metadataCache() {
        return this.metadataCache;
    }

    public OffsetCheckpoints offsetCheckpoints() {
        return this.offsetCheckpoints;
    }

    public Partition partition() {
        return this.partition;
    }

    public void partition_$eq(Partition x$1) {
        this.partition = x$1;
    }

    @BeforeEach
    public void setup() {
        TestUtils$.MODULE$.clearYammerMetrics();
        Properties logProps = this.createLogProperties((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        this.logConfig_$eq(new LogConfig((Map)logProps));
        this.configRepository_$eq(MockConfigRepository$.MODULE$.forTopic(this.topicPartition().topic(), logProps));
        this.tmpDir_$eq(TestUtils$.MODULE$.tempDir());
        this.logDir1_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logDir2_$eq(TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir()));
        this.logManager_$eq(TestUtils$.MODULE$.createLogManager((Seq<File>)new .colon.colon((Object)this.logDir1(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), this.logConfig(), this.configRepository(), new CleanerConfig(false), this.time(), this.interBrokerProtocolVersion(), TestUtils$.MODULE$.createLogManager$default$7()));
        this.logManager().startup((Set)Predef$.MODULE$.Set().empty());
        this.alterPartitionManager_$eq(TestUtils$.MODULE$.createAlterIsrManager());
        this.alterPartitionListener_$eq(TestUtils$.MODULE$.createIsrChangeListener());
        this.partition_$eq(new Partition(this.topicPartition(), Defaults$.MODULE$.ReplicaLagTimeMaxMs(), this.interBrokerProtocolVersion(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> this.defaultBrokerEpoch(this.brokerId()), (Time)this.time(), (AlterPartitionListener)this.alterPartitionListener(), this.delayedOperations(), this.metadataCache(), this.logManager(), (AlterPartitionManager)this.alterPartitionManager()));
        Mockito.when((Object)this.offsetCheckpoints().fetch(ArgumentMatchers.anyString(), (TopicPartition)ArgumentMatchers.eq((Object)this.topicPartition()))).thenReturn((Object)None$.MODULE$);
    }

    public MetadataVersion interBrokerProtocolVersion() {
        return MetadataVersion.latest();
    }

    /*
     * WARNING - void declaration
     */
    public Properties createLogProperties(scala.collection.immutable.Map<String, String> overrides) {
        void var2_2;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(512));
        logProps.put("segment.index.bytes", Predef$.MODULE$.int2Integer(1000));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(999));
        overrides.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String k = (String)x0$1._1();
            String v = (String)x0$1._2();
            Object object = logProps.put(k, v);
            return object;
        });
        return var2_2;
    }

    @AfterEach
    public void tearDown() {
        if (this.tmpDir().exists()) {
            this.logManager().shutdown();
            Utils.delete((File)this.tmpDir());
            TestUtils$.MODULE$.clearYammerMetrics();
        }
    }

    public Partition setupPartitionWithMocks(int leaderEpoch, boolean isLeader) {
        this.partition().createLogIfNotExists(false, false, this.offsetCheckpoints(), (Option)None$.MODULE$);
        int controllerEpoch = 0;
        java.util.List replicas = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.brokerId()), (List)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.remoteReplicaId()), (List)Nil$.MODULE$))).asJava();
        if (isLeader) {
            Assertions.assertTrue((boolean)this.partition().makeLeader(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.brokerId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become leader transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
        } else {
            Assertions.assertTrue((boolean)this.partition().makeFollower(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setControllerEpoch(controllerEpoch).setLeader(this.remoteReplicaId()).setLeaderEpoch(leaderEpoch).setIsr(replicas).setPartitionEpoch(1).setReplicas(replicas).setIsNew(true), this.offsetCheckpoints(), (Option)None$.MODULE$), (String)"Expected become follower transition to succeed");
            Assertions.assertEquals((int)leaderEpoch, (int)this.partition().getLeaderEpoch());
            Assertions.assertEquals((Object)None$.MODULE$, (Object)this.partition().leaderLogIfLocal());
        }
        return this.partition();
    }

    public long defaultBrokerEpoch(int brokerId) {
        return (long)brokerId + 1000L;
    }
}

