/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.server.QuorumTestHarness;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.authenticator.CredentialCache;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.controller.ControllerRequestContextUtil;
import org.apache.kafka.controller.ResultOrError;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\r\ra!B\u001e=\u0003\u0003\t\u0005\"\u0002%\u0001\t\u0003I\u0005\"\u0003'\u0001\u0001\u0004\u0005\r\u0011\"\u0001N\u0011%I\u0006\u00011AA\u0002\u0013\u0005!\fC\u0005b\u0001\u0001\u0007\t\u0011)Q\u0005\u001d\"9!\r\u0001b\u0001\n\u0013\u0019\u0007BB7\u0001A\u0003%A\rC\u0003o\u0001\u0011\u0005q\u000eC\u0003t\u0001\u0011\u0005A\u000fC\u0005z\u0001\u0001\u0007\t\u0019!C\u0001u\"Y\u00111\u0001\u0001A\u0002\u0003\u0007I\u0011AA\u0003\u0011)\tI\u0001\u0001a\u0001\u0002\u0003\u0006Ka\u001f\u0005\u0007\u0003\u0017\u0001a\u0011A'\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002BBA\u0019\u0001\u0011\u0005Q\nC\u0004\u00024\u0001!\t!!\u000e\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!9\u0011Q\n\u0001\u0005\u0002\u0005=\u0003\"CAA\u0001E\u0005I\u0011AAB\u0011\u001d\tI\n\u0001C\t\u00037Cq!!\u001b\u0001\t#\ti\u000bC\u0004\u00020\u0002!\t\"!-\t\u000f\u0005\u0015\u0007\u0001\"\u0005\u0002H\"9\u0011q\u001b\u0001\u0005\u0012\u0005\u001d\u0007bBAm\u0001\u0011E\u00111\u001c\u0005\b\u0003[\u0004A\u0011IAx\u0011\u001d\tY\u0010\u0001C!\u0003_AqA!\u0002\u0001\t\u0003\u00119\u0001C\u0005\u0003\u0012\u0001\t\n\u0011\"\u0001\u0003\u0014!I!q\u0003\u0001\u0012\u0002\u0013\u0005!1\u0003\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0011%\u0011\u0019\u0003AI\u0001\n\u0003\t\u0019\tC\u0005\u0003&\u0001\t\n\u0011\"\u0001\u0003(!9!1\u0006\u0001\u0005\u0002\t5\u0002\"\u0003B(\u0001E\u0005I\u0011\u0001B)\u0011%\u0011)\u0006AI\u0001\n\u0003\u0011\t\u0006C\u0005\u0003X\u0001\t\n\u0011\"\u0001\u0003(!I!\u0011\f\u0001\u0012\u0002\u0013\u0005\u00111\u0011\u0005\n\u00057\u0002\u0011\u0013!C\u0001\u0005OAqA!\u0018\u0001\t\u0003\u0011y\u0006C\u0005\u0003p\u0001\t\n\u0011\"\u0001\u0002\u0004\"9!\u0011\u000f\u0001\u0005\u0002\tM\u0004\"\u0003B=\u0001E\u0005I\u0011AAB\u0011\u001d\u0011Y\b\u0001C\u0001\u0005{BqAa)\u0001\t\u0003\u0011)\u000bC\u0004\u0003,\u0002!\tA!,\t\u000f\t=\u0006\u0001\"\u0001\u00032\"9!q\u0017\u0001\u0005\u0002\te\u0006\"\u0003B_\u0001E\u0005I\u0011\u0001B\n\u0011\u001d\u0011y\f\u0001C\u0001\u0005\u0003DqAa3\u0001\t\u0003\u0011i\rC\u0004\u0003P\u0002!\tA!5\t\u000f\t=\u0007\u0001\"\u0001\u0003f\"9!q\u001d\u0001\u0005\u0002\t%\bb\u0002Bw\u0001\u0011%!q\u001e\u0005\b\u0005g\u0004A\u0011\u0002B{\u0011\u001d\u0011Y\u0010\u0001C\u0001\u0005{Dqa!\u0001\u0001\t\u0003\tyC\u0001\fLC\u001a\\\u0017mU3sm\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0015\tid(A\u0006j]R,wM]1uS>t'\"A \u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bz\naa]3sm\u0016\u0014\u0018BA$E\u0005E\tVo\u001c:v[R+7\u000f\u001e%be:,7o]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\u0003\"a\u0013\u0001\u000e\u0003q\nq\"\u001b8ti\u0006t7-Z\"p]\u001aLwm]\u000b\u0002\u001dB\u0019q\n\u0016,\u000e\u0003AS!!\u0015*\u0002\u0015\r|G\u000e\\3di&|gNC\u0001T\u0003\u0015\u00198-\u00197b\u0013\t)\u0006KA\u0002TKF\u0004\"aQ,\n\u0005a#%aC&bM.\f7i\u001c8gS\u001e\f1#\u001b8ti\u0006t7-Z\"p]\u001aLwm]0%KF$\"aW0\u0011\u0005qkV\"\u0001*\n\u0005y\u0013&\u0001B+oSRDq\u0001Y\u0002\u0002\u0002\u0003\u0007a*A\u0002yIE\n\u0001#\u001b8ti\u0006t7-Z\"p]\u001aLwm\u001d\u0011\u0002\u0011}\u0013'o\\6feN,\u0012\u0001\u001a\t\u0004K\"TW\"\u00014\u000b\u0005\u001d\u0004\u0016aB7vi\u0006\u0014G.Z\u0005\u0003S\u001a\u00141\"\u0011:sCf\u0014UO\u001a4feB\u00111i[\u0005\u0003Y\u0012\u00131bS1gW\u0006\u0014%o\\6fe\u0006IqL\u0019:pW\u0016\u00148\u000fI\u0001\bEJ|7.\u001a:t+\u0005\u0001\bcA3rU&\u0011!O\u001a\u0002\u0007\u0005V4g-\u001a:\u0002\u000fM,'O^3sgV\tQ\u000fE\u0002fcZ\u0004\"aQ<\n\u0005a$%aC&bM.\f7+\u001a:wKJ\fQ!\u00197jm\u0016,\u0012a\u001f\t\u00049rt\u0018BA?S\u0005\u0015\t%O]1z!\tav0C\u0002\u0002\u0002I\u0013qAQ8pY\u0016\fg.A\u0005bY&4Xm\u0018\u0013fcR\u00191,a\u0002\t\u000f\u0001T\u0011\u0011!a\u0001w\u00061\u0011\r\\5wK\u0002\nqbZ3oKJ\fG/Z\"p]\u001aLwm]\u0001$G>tg-[4ve\u0016\u001cVmY;sSRL()\u001a4pe\u0016\u001cVM\u001d<feN\u001cF/\u0019:u)\rY\u0016\u0011\u0003\u0005\b\u0003'i\u0001\u0019AA\u000b\u0003!!Xm\u001d;J]\u001a|\u0007\u0003BA\f\u0003Si!!!\u0007\u000b\t\u0005m\u0011QD\u0001\u0004CBL'\u0002BA\u0010\u0003C\tqA[;qSR,'O\u0003\u0003\u0002$\u0005\u0015\u0012!\u00026v]&$(BAA\u0014\u0003\ry'oZ\u0005\u0005\u0003W\tIB\u0001\u0005UKN$\u0018J\u001c4p\u0003\t\u001awN\u001c4jOV\u0014XmU3dkJLG/_!gi\u0016\u00148+\u001a:wKJ\u001c8\u000b^1siR\t1,A\u0004d_:4\u0017nZ:\u0002\u0017M,'O^3s\r>\u0014\u0018\n\u001a\u000b\u0005\u0003o\ti\u0004\u0005\u0003]\u0003s1\u0018bAA\u001e%\n1q\n\u001d;j_:Dq!a\u0010\u0011\u0001\u0004\t\t%\u0001\u0002jIB\u0019A,a\u0011\n\u0007\u0005\u0015#KA\u0002J]R\f\u0011BY8v]\u0012\u0004vN\u001d;\u0015\t\u0005\u0005\u00131\n\u0005\u0006\u000bF\u0001\rA^\u0001\u0011E>|Go\u001d;sCB\u001cVM\u001d<feN$B!!\u0015\u0002hA!\u00111KA1\u001d\u0011\t)&!\u0018\u0011\u0007\u0005]#+\u0004\u0002\u0002Z)\u0019\u00111\f!\u0002\rq\u0012xn\u001c;?\u0013\r\tyFU\u0001\u0007!J,G-\u001a4\n\t\u0005\r\u0014Q\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005}#\u000bC\u0005\u0002jI\u0001\n\u00111\u0001\u0002l\u0005aA.[:uK:,'OT1nKB!\u0011QNA?\u001b\t\tyG\u0003\u0003\u0002r\u0005M\u0014a\u00028fi^|'o\u001b\u0006\u0005\u0003k\n9(\u0001\u0004d_6lwN\u001c\u0006\u0004\u007f\u0005e$\u0002BA>\u0003K\ta!\u00199bG\",\u0017\u0002BA@\u0003_\u0012A\u0002T5ti\u0016tWM\u001d(b[\u0016\f!DY8piN$(/\u00199TKJ4XM]:%I\u00164\u0017-\u001e7uIE*\"!!\"+\t\u0005-\u0014qQ\u0016\u0003\u0003\u0013\u0003B!a#\u0002\u00166\u0011\u0011Q\u0012\u0006\u0005\u0003\u001f\u000b\t*A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0013*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0018\u00065%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u00012/Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\\\u000b\u0003\u0003;\u0003B!a(\u0002*6\u0011\u0011\u0011\u0015\u0006\u0005\u0003G\u000b)+\u0001\u0003bkRD'\u0002BAT\u0003g\n\u0001b]3dkJLG/_\u0005\u0005\u0003W\u000b\tK\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pYV\u0011\u00111N\u0001\u000fiJ,8\u000f^*u_J,g)\u001b7f+\t\t\u0019\fE\u0003]\u0003s\t)\f\u0005\u0003\u00028\u0006\u0005WBAA]\u0015\u0011\tY,!0\u0002\u0005%|'BAA`\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0017\u0011\u0018\u0002\u0005\r&dW-\u0001\u000btKJ4XM]*bg2\u0004&o\u001c9feRLWm]\u000b\u0003\u0003\u0013\u0004R\u0001XA\u001d\u0003\u0017\u0004B!!4\u0002T6\u0011\u0011q\u001a\u0006\u0005\u0003#\fi,\u0001\u0003vi&d\u0017\u0002BAk\u0003\u001f\u0014!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Q\u0019G.[3oiN\u000b7\u000f\u001c)s_B,'\u000f^5fg\u0006Q!M]8lKJ$\u0016.\\3\u0015\t\u0005u\u0017\u0011\u001e\t\u0005\u0003?\f)/\u0004\u0002\u0002b*!\u00111]A:\u0003\u0015)H/\u001b7t\u0013\u0011\t9/!9\u0003\tQKW.\u001a\u0005\b\u0003WL\u0002\u0019AA!\u0003!\u0011'o\\6fe&#\u0017!B:fiV\u0003HcA.\u0002r\"9\u00111\u0003\u000eA\u0002\u0005U\u0001f\u0001\u000e\u0002vB!\u0011qCA|\u0013\u0011\tI0!\u0007\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\rY\u0012q \t\u0005\u0003/\u0011\t!\u0003\u0003\u0003\u0004\u0005e!!C!gi\u0016\u0014X)Y2i\u0003=\u0011Xm\u0019:fCR,'I]8lKJ\u001cH#B.\u0003\n\t5\u0001\u0002\u0003B\u00069A\u0005\t\u0019\u0001@\u0002\u0017I,7m\u001c8gS\u001e,(/\u001a\u0005\t\u0005\u001fa\u0002\u0013!a\u0001}\u000691\u000f^1siV\u0004\u0018!\u0007:fGJ,\u0017\r^3Ce>\\WM]:%I\u00164\u0017-\u001e7uIE*\"A!\u0006+\u0007y\f9)A\rsK\u000e\u0014X-\u0019;f\u0005J|7.\u001a:tI\u0011,g-Y;mi\u0012\u0012\u0014AE2sK\u0006$Xm\u00144gg\u0016$8\u000fV8qS\u000e$Ra\u0017B\u000f\u0005?A\u0011\"!\u001b !\u0003\u0005\r!a\u001b\t\u0013\t\u0005r\u0004%AA\u0002\u0005-\u0017!E1e[&t7\t\\5f]R\u001cuN\u001c4jO\u0006a2M]3bi\u0016|eMZ:fiN$v\u000e]5dI\u0011,g-Y;mi\u0012\n\u0014\u0001H2sK\u0006$Xm\u00144gg\u0016$8\u000fV8qS\u000e$C-\u001a4bk2$HEM\u000b\u0003\u0005SQC!a3\u0002\b\u0006Y1M]3bi\u0016$v\u000e]5d)9\u0011yCa\u000f\u0003@\t\r#q\tB&\u0005\u001b\u0002\u0002B!\r\u00038\u0005\u0005\u0013\u0011I\u0007\u0003\u0005gQ1A!\u000eQ\u0003%IW.\\;uC\ndW-\u0003\u0003\u0003:\tM\"aA'ba\"9!Q\b\u0012A\u0002\u0005E\u0013!\u0002;pa&\u001c\u0007\"\u0003B!EA\u0005\t\u0019AA!\u00035qW/\u001c)beRLG/[8og\"I!Q\t\u0012\u0011\u0002\u0003\u0007\u0011\u0011I\u0001\u0012e\u0016\u0004H.[2bi&|gNR1di>\u0014\b\"\u0003B%EA\u0005\t\u0019AAf\u0003-!x\u000e]5d\u0007>tg-[4\t\u0013\u0005%$\u0005%AA\u0002\u0005-\u0004\"\u0003B\u0011EA\u0005\t\u0019AAf\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uII*\"Aa\u0015+\t\u0005\u0005\u0013qQ\u0001\u0016GJ,\u0017\r^3U_BL7\r\n3fM\u0006,H\u000e\u001e\u00134\u0003U\u0019'/Z1uKR{\u0007/[2%I\u00164\u0017-\u001e7uIQ\nQc\u0019:fCR,Gk\u001c9jG\u0012\"WMZ1vYR$S'A\u000bde\u0016\fG/\u001a+pa&\u001cG\u0005Z3gCVdG\u000f\n\u001c\u00023\r\u0014X-\u0019;f)>\u0004\u0018nY,ji\"\f5o]5h]6,g\u000e\u001e\u000b\t\u0005_\u0011\tGa\u0019\u0003n!9!Q\b\u0015A\u0002\u0005E\u0003b\u0002B3Q\u0001\u0007!qM\u0001\u001ba\u0006\u0014H/\u001b;j_:\u0014V\r\u001d7jG\u0006\f5o]5h]6,g\u000e\u001e\t\b\u001f\n%\u0014\u0011\tB6\u0013\r\u0011I\u0004\u0015\t\u0005\u001fR\u000b\t\u0005C\u0005\u0002j!\u0002\n\u00111\u0001\u0002l\u0005\u00193M]3bi\u0016$v\u000e]5d/&$\b.Q:tS\u001etW.\u001a8uI\u0011,g-Y;mi\u0012\u001a\u0014a\u00033fY\u0016$X\rV8qS\u000e$Ra\u0017B;\u0005oBqA!\u0010+\u0001\u0004\t\t\u0006C\u0005\u0002j)\u0002\n\u00111\u0001\u0002l\u0005)B-\u001a7fi\u0016$v\u000e]5dI\u0011,g-Y;mi\u0012\u0012\u0014\u0001E1eI\u0006sGMV3sS\u001aL\u0018i\u00197t)\u0015Y&q\u0010BK\u0011\u001d\u0011\t\t\fa\u0001\u0005\u0007\u000bA!Y2mgB1\u00111\u000bBC\u0005\u0013KAAa\"\u0002f\t\u00191+\u001a;\u0011\t\t-%\u0011S\u0007\u0003\u0005\u001bSAAa$\u0002t\u0005\u0019\u0011m\u00197\n\t\tM%Q\u0012\u0002\u0013\u0003\u000e\u001cWm]:D_:$(o\u001c7F]R\u0014\u0018\u0010C\u0004\u0003\u00182\u0002\rA!'\u0002\u0011I,7o\\;sG\u0016\u0004BAa'\u0003 6\u0011!Q\u0014\u0006\u0005\u0005/\u000b\u0019(\u0003\u0003\u0003\"\nu%a\u0004*fg>,(oY3QCR$XM\u001d8\u0002'I,Wn\u001c<f\u0003:$g+\u001a:jMf\f5\r\\:\u0015\u000bm\u00139K!+\t\u000f\t\u0005U\u00061\u0001\u0003\u0004\"9!qS\u0017A\u0002\te\u0015\u0001E6jY2\u0014\u0016M\u001c3p[\n\u0013xn[3s)\t\t\t%\u0001\u0006lS2d'I]8lKJ$2a\u0017BZ\u0011\u001d\u0011)l\fa\u0001\u0003\u0003\nQ!\u001b8eKb\f!C]3ti\u0006\u0014H\u000fR3bI\n\u0013xn[3sgR\u00191La/\t\u0011\t-\u0001\u0007%AA\u0002y\fAD]3ti\u0006\u0014H\u000fR3bI\n\u0013xn[3sg\u0012\"WMZ1vYR$\u0013'\u0001\u0018xC&$hi\u001c:Vg\u0016\u00148k\u0019:b[\u000e\u0013X\rZ3oi&\fG\u000eV8BaB,\u0017M](o\u00032d'I]8lKJ\u001cH#B.\u0003D\n\u001d\u0007b\u0002Bce\u0001\u0007\u0011\u0011K\u0001\u0010G2LWM\u001c;Qe&t7-\u001b9bY\"9!\u0011\u001a\u001aA\u0002\u0005E\u0013!D7fG\"\fg.[:n\u001d\u0006lW-A\u0007hKR\u001cuN\u001c;s_2dWM\u001d\u000b\u0002m\u0006Yq-\u001a;U_BL7-\u00133t)\u0011\u0011\u0019Na8\u0011\u0011\u0005M#Q[A)\u0005/LAA!\u000f\u0002fA!!\u0011\u001cBn\u001b\t\t\u0019(\u0003\u0003\u0003^\u0006M$\u0001B+vS\u0012DqA!95\u0001\u0004\u0011\u0019/A\u0003oC6,7\u000f\u0005\u0003P)\u0006ECC\u0001Bj\u000359W\r\u001e+pa&\u001cg*Y7fgR\u0011!1\u001e\t\t\u0003'\u0012)Na6\u0002R\u0005i1M]3bi\u0016\u0014%o\\6feN$2a\u0017By\u0011\u0019\u0011ya\u000ea\u0001}\u000612M]3bi\u0016\u0014%o\\6fe\u001a\u0013x.\\\"p]\u001aLw\rF\u0002k\u0005oDaA!?9\u0001\u00041\u0016AB2p]\u001aLw-\u0001\u0007bY&4XM\u0011:pW\u0016\u00148/\u0006\u0002\u0003\u0000B\u0019q\n\u00166\u0002;\u0015t7/\u001e:f\u0007>t7/[:uK:$8JU1gi6+G/\u00193bi\u0006\u0004")
public abstract class KafkaServerTestHarness
extends QuorumTestHarness {
    private Seq<KafkaConfig> instanceConfigs;
    private final ArrayBuffer<KafkaBroker> _brokers = new ArrayBuffer();
    private boolean[] alive;

    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    private ArrayBuffer<KafkaBroker> _brokers() {
        return this._brokers;
    }

    public Buffer<KafkaBroker> brokers() {
        return this._brokers();
    }

    public Buffer<KafkaServer> servers() {
        this.checkIsZKTest();
        return this._brokers();
    }

    public boolean[] alive() {
        return this.alive;
    }

    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    public abstract Seq<KafkaConfig> generateConfigs();

    public void configureSecurityBeforeServersStart(TestInfo testInfo) {
    }

    public void configureSecurityAfterServersStart() {
    }

    public Seq<KafkaConfig> configs() {
        if (this.instanceConfigs() == null) {
            this.instanceConfigs_$eq(this.generateConfigs());
        }
        return this.instanceConfigs();
    }

    public Option<KafkaServer> serverForId(int id) {
        return this.servers().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$serverForId$1(id, s)));
    }

    public int boundPort(KafkaServer server) {
        return server.boundPort(this.listenerName());
    }

    public String bootstrapServers(ListenerName listenerName) {
        return TestUtils$.MODULE$.bootstrapServers(this._brokers(), listenerName);
    }

    public ListenerName bootstrapServers$default$1() {
        return this.listenerName();
    }

    public SecurityProtocol securityProtocol() {
        return SecurityProtocol.PLAINTEXT;
    }

    public ListenerName listenerName() {
        return ListenerName.forSecurityProtocol((SecurityProtocol)this.securityProtocol());
    }

    public Option<File> trustStoreFile() {
        return None$.MODULE$;
    }

    public Option<Properties> serverSaslProperties() {
        return None$.MODULE$;
    }

    public Option<Properties> clientSaslProperties() {
        return None$.MODULE$;
    }

    public Time brokerTime(int brokerId) {
        return Time.SYSTEM;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this.configureSecurityBeforeServersStart(testInfo);
        this.createBrokers(true);
        this.configureSecurityAfterServersStart();
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this._brokers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    public void recreateBrokers(boolean reconfigure, boolean startup) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        TestUtils$.MODULE$.shutdownServers(this._brokers(), false);
        this._brokers().clear();
        Arrays.fill(this.alive(), false);
        this.createBrokers(startup);
    }

    public boolean recreateBrokers$default$1() {
        return false;
    }

    public boolean recreateBrokers$default$2() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void createOffsetsTopic(ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var5_4 = resource_resource;
                TestUtils$.MODULE$.createOffsetsTopicWithAdmin((Admin)var5_4, this.brokers());
            }
            finally {
                resource_resource.close();
            }
            return;
        }
        TestUtils$.MODULE$.createOffsetsTopic(this.zkClient(), (Seq<KafkaBroker>)this.servers());
    }

    public ListenerName createOffsetsTopic$default$1() {
        return this.listenerName();
    }

    public Properties createOffsetsTopic$default$2() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopic(String topic, int numPartitions, int replicationFactor, Properties topicConfig, ListenerName listenerName, Properties adminClientConfig) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, adminClientConfig);
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var9_8 = resource_resource;
                map = KafkaServerTestHarness.$anonfun$createTopic$1(this, topic, numPartitions, replicationFactor, topicConfig, (Admin)var9_8);
            }
            finally {
                resource_resource.close();
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, numPartitions, replicationFactor, (Seq<KafkaBroker>)this.servers(), topicConfig);
    }

    public int createTopic$default$2() {
        return 1;
    }

    public int createTopic$default$3() {
        return 1;
    }

    public Properties createTopic$default$4() {
        return new Properties();
    }

    public ListenerName createTopic$default$5() {
        return this.listenerName();
    }

    public Properties createTopic$default$6() {
        return new Properties();
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Map<Object, Object> createTopicWithAssignment(String topic, Map<Object, Seq<Object>> partitionReplicaAssignment, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            scala.collection.immutable.Map map;
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, TestUtils$.MODULE$.createAdminClient$default$3());
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var6_5 = resource_resource;
                map = KafkaServerTestHarness.$anonfun$createTopicWithAssignment$1(this, topic, partitionReplicaAssignment, (Admin)var6_5);
            }
            finally {
                resource_resource.close();
            }
            return map;
        }
        return TestUtils$.MODULE$.createTopic(this.zkClient(), topic, partitionReplicaAssignment, (Seq<KafkaBroker>)this.servers());
    }

    public ListenerName createTopicWithAssignment$default$3() {
        return this.listenerName();
    }

    /*
     * WARNING - void declaration
     */
    public void deleteTopic(String topic, ListenerName listenerName) {
        if (this.isKRaftTest()) {
            void resource_resource;
            Admin admin = TestUtils$.MODULE$.createAdminClient(this.brokers(), listenerName, TestUtils$.MODULE$.createAdminClient$default$3());
            if (TestUtils$.MODULE$ == null) {
                throw null;
            }
            try {
                void var5_4 = resource_resource;
                TestUtils$.MODULE$.deleteTopicWithAdmin((Admin)var5_4, topic, this.aliveBrokers());
            }
            finally {
                resource_resource.close();
            }
            return;
        }
        this.adminZkClient().deleteTopic(topic);
    }

    public ListenerName deleteTopic$default$2() {
        return this.listenerName();
    }

    public void addAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        TestUtils$.MODULE$.addAndVerifyAcls(this.brokers(), acls, resource, this.controllerServers());
    }

    public void removeAndVerifyAcls(Set<AccessControlEntry> acls, ResourcePattern resource) {
        TestUtils$.MODULE$.removeAndVerifyAcls(this.brokers(), acls, resource, this.controllerServers());
    }

    /*
     * WARNING - void declaration
     */
    public int killRandomBroker() {
        void var1_1;
        int index = TestUtils$.MODULE$.random().nextInt(this._brokers().length());
        this.killBroker(index);
        return (int)var1_1;
    }

    public void killBroker(int index) {
        if (this.alive()[index]) {
            ((KafkaBroker)this._brokers().apply(index)).shutdown();
            ((KafkaBroker)this._brokers().apply(index)).awaitShutdown();
            this.alive()[index] = false;
        }
    }

    public void restartDeadBrokers(boolean reconfigure) {
        if (reconfigure) {
            this.instanceConfigs_$eq(null);
        }
        if (this.configs().isEmpty()) {
            throw new KafkaException("Must supply at least one server config.");
        }
        this._brokers().indices().withFilter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> !this.alive()[i]).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            if (reconfigure) {
                this._brokers().update(i, (Object)this.createBrokerFromConfig((KafkaConfig)this.configs().apply(i)));
            }
            ((KafkaBroker)this._brokers().apply(i)).startup();
            $this.alive()[i] = true;
        });
    }

    public boolean restartDeadBrokers$default$1() {
        return false;
    }

    public void waitForUserScramCredentialToAppearOnAllBrokers(String clientPrincipal, String mechanismName) {
        this._brokers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(mechanismName, clientPrincipal, server);
            return BoxedUnit.UNIT;
        });
    }

    public KafkaServer getController() {
        this.checkIsZKTest();
        int controllerId = TestUtils$.MODULE$.waitUntilControllerElected(this.zkClient(), TestUtils$.MODULE$.waitUntilControllerElected$default$2());
        return (KafkaServer)((IterableLike)this.servers().filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$getController$1(controllerId, s)))).head();
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds(Seq<String> names) {
        HashMap result = new HashMap();
        if (this.isKRaftTest()) {
            java.util.Map topicIdsMap = (java.util.Map)this.controllerServer().controller().findTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT, (Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(names).asJava()).get();
            names.foreach((Function1 & Serializable & scala.Serializable)name -> {
                ResultOrError response = (ResultOrError)topicIdsMap.get(name);
                return (Uuid)result.put(name, response.result());
            });
        } else {
            scala.collection.immutable.Map topicIdsMap = this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
            names.foreach((Function1 & Serializable & scala.Serializable)name -> {
                if (topicIdsMap.contains(name)) {
                    return result.put(name, topicIdsMap.get(name).get());
                }
                return BoxedUnit.UNIT;
            });
        }
        return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<String, Uuid> getTopicIds() {
        if (this.isKRaftTest()) {
            return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return this.getController().kafkaController().controllerContext().topicIds().toMap(Predef$.MODULE$.$conforms());
    }

    public scala.collection.immutable.Map<Uuid, String> getTopicNames() {
        if (this.isKRaftTest()) {
            HashMap result = new HashMap();
            ((java.util.Map)this.controllerServer().controller().findAllTopicIds(ControllerRequestContextUtil.ANONYMOUS_CONTEXT).get()).entrySet().forEach(e -> result.put(e.getValue(), e.getKey()));
            return ((TraversableOnce)CollectionConverters$.MODULE$.mapAsScalaMapConverter(result).asScala()).toMap(Predef$.MODULE$.$conforms());
        }
        return this.getController().kafkaController().controllerContext().topicNames().toMap(Predef$.MODULE$.$conforms());
    }

    private void createBrokers(boolean startup) {
        Seq<KafkaConfig> potentiallyRegeneratedConfigs = this.configs();
        this.alive_$eq(new boolean[potentiallyRegeneratedConfigs.length()]);
        Arrays.fill(this.alive(), false);
        potentiallyRegeneratedConfigs.foreach((Function1 & Serializable & scala.Serializable)config -> {
            KafkaServerTestHarness.$anonfun$createBrokers$1(this, startup, config);
            return BoxedUnit.UNIT;
        });
    }

    private KafkaBroker createBrokerFromConfig(KafkaConfig config) {
        if (this.isKRaftTest()) {
            return this.createBroker(config, this.brokerTime(config.brokerId()), false, this.createBroker$default$4());
        }
        return TestUtils$.MODULE$.createServer(config, this.brokerTime(config.brokerId()), (Option<String>)None$.MODULE$, false, this.isZkMigrationTest() || config.migrationEnabled() && config.interBrokerProtocolVersion().isApiForwardingEnabled());
    }

    public Seq<KafkaBroker> aliveBrokers() {
        return ((SeqLike)this._brokers().filter((Function1 & Serializable & scala.Serializable)broker -> BoxesRunTime.boxToBoolean((boolean)KafkaServerTestHarness.$anonfun$aliveBrokers$1(this, broker)))).toSeq();
    }

    public void ensureConsistentKRaftMetadata() {
        if (this.isKRaftTest()) {
            TestUtils$.MODULE$.ensureConsistentKRaftMetadata(this.aliveBrokers(), this.controllerServer(), TestUtils$.MODULE$.ensureConsistentKRaftMetadata$default$3());
        }
    }

    public static final /* synthetic */ boolean $anonfun$serverForId$1(int id$1, KafkaServer s) {
        return s.config().brokerId() == id$1;
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopic$1(KafkaServerTestHarness $this, String topic$1, int numPartitions$1, int replicationFactor$1, Properties topicConfig$1, Admin admin) {
        Buffer<KafkaBroker> x$3 = $this.brokers();
        Map<Object, Seq<Object>> x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$6();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$1, x$3, numPartitions$1, replicationFactor$1, x$7, topicConfig$1);
    }

    public static final /* synthetic */ scala.collection.immutable.Map $anonfun$createTopicWithAssignment$1(KafkaServerTestHarness $this, String topic$2, Map partitionReplicaAssignment$1, Admin admin) {
        Buffer<KafkaBroker> x$4 = $this.brokers();
        int x$5 = TestUtils$.MODULE$.createTopicWithAdmin$default$4();
        int x$6 = TestUtils$.MODULE$.createTopicWithAdmin$default$5();
        Properties x$7 = TestUtils$.MODULE$.createTopicWithAdmin$default$7();
        return TestUtils$.MODULE$.createTopicWithAdmin(admin, topic$2, x$4, x$5, x$6, (Map<Object, Seq<Object>>)partitionReplicaAssignment$1, x$7);
    }

    public static final /* synthetic */ boolean $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(CredentialCache.Cache cache$1, String clientPrincipal$1) {
        return cache$1.get(clientPrincipal$1) != null;
    }

    public static final /* synthetic */ String $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(String clientPrincipal$1) {
        return new StringBuilder(34).append("SCRAM credentials not created for ").append(clientPrincipal$1).toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$waitForUserScramCredentialToAppearOnAllBrokers$1(String mechanismName$1, String clientPrincipal$1, KafkaBroker server) {
        CredentialCache.Cache cache = server.credentialProvider().credentialCache().cache(mechanismName$1, ScramCredential.class);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$2(cache, clientPrincipal$1)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)KafkaServerTestHarness.$anonfun$waitForUserScramCredentialToAppearOnAllBrokers$3(clientPrincipal$1));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
    }

    public static final /* synthetic */ boolean $anonfun$getController$1(int controllerId$1, KafkaServer s) {
        return s.config().brokerId() == controllerId$1;
    }

    public static final /* synthetic */ void $anonfun$createBrokers$1(KafkaServerTestHarness $this, boolean startup$1, KafkaConfig config) {
        KafkaBroker broker = $this.createBrokerFromConfig(config);
        $this._brokers().$plus$eq((Object)broker);
        if (startup$1) {
            broker.startup();
            $this.alive()[$this._brokers().length() - 1] = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$aliveBrokers$1(KafkaServerTestHarness $this, KafkaBroker broker) {
        return $this.alive()[broker.config().brokerId()];
    }

    public static final /* synthetic */ Object $anonfun$deleteTopic$1$adapted(KafkaServerTestHarness $this, String topic$3, Admin admin) {
        TestUtils$.MODULE$.deleteTopicWithAdmin(admin, topic$3, $this.aliveBrokers());
        return BoxedUnit.UNIT;
    }
}

