/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Properties;
import kafka.log.AbstractLogCleanerIntegrationTest;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerManager$;
import kafka.log.LogSegment;
import kafka.log.UnifiedLog;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\t\u0013\u0001]AQ\u0001\b\u0001\u0005\u0002uAqa\b\u0001C\u0002\u0013\u0005\u0001\u0005\u0003\u0004/\u0001\u0001\u0006I!\t\u0005\b_\u0001\u0011\r\u0011\"\u00011\u0011\u00199\u0004\u0001)A\u0005c!9\u0001\b\u0001b\u0001\n\u0003I\u0004B\u0002#\u0001A\u0003%!\bC\u0003F\u0001\u0011\u0005a\tC\u0003V\u0001\u0011\u0005a\tC\u0003[\u0001\u0011%1\fC\u0003[\u0001\u0011%q\u0010\u0003\u0004[\u0001\u0011%\u00111\u0005\u0005\u0007\u0003g\u0001A\u0011\u0001$\t\u000f\u0005]\u0002\u0001\"\u0003\u0002:!9\u00111\f\u0001\u0005\n\u0005u\u0003BBAB\u0001\u0011\u0005aIA\rM_\u001e\u001cE.Z1oKJLe\u000e^3he\u0006$\u0018n\u001c8UKN$(BA\n\u0015\u0003\rawn\u001a\u0006\u0002+\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u0019!\tI\"$D\u0001\u0013\u0013\tY\"CA\u0011BEN$(/Y2u\u0019><7\t\\3b]\u0016\u0014\u0018J\u001c;fOJ\fG/[8o)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002=A\u0011\u0011\u0004A\u0001\u0006G>$WmY\u000b\u0002CA\u0011!\u0005L\u0007\u0002G)\u0011A%J\u0001\u0007e\u0016\u001cwN\u001d3\u000b\u0005\u0019:\u0013AB2p[6|gN\u0003\u0002\u0016Q)\u0011\u0011FK\u0001\u0007CB\f7\r[3\u000b\u0003-\n1a\u001c:h\u0013\ti3EA\bD_6\u0004(/Z:tS>tG+\u001f9f\u0003\u0019\u0019w\u000eZ3dA\u0005!A/[7f+\u0005\t\u0004C\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u0015\u0003\u0015)H/\u001b7t\u0013\t14G\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u001cX#\u0001\u001e\u0011\u0007mr\u0004)D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u0015\t%O]1z!\t\t%)D\u0001&\u0013\t\u0019UE\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]N\u0004\u0013aB2mK\u0006tW\u000f\u001d\u000b\u0002\u000fB\u00111\bS\u0005\u0003\u0013r\u0012A!\u00168ji\"\u0012\u0001b\u0013\t\u0003\u0019Nk\u0011!\u0014\u0006\u0003\u001d>\u000b1!\u00199j\u0015\t\u0001\u0016+A\u0004kkBLG/\u001a:\u000b\u0005IS\u0013!\u00026v]&$\u0018B\u0001+N\u0005%\te\r^3s\u000b\u0006\u001c\u0007.\u0001\u001euKN$X*\u0019:lgB\u000b'\u000f^5uS>t7/Q:PM\u001ad\u0017N\\3B]\u0012\u0004v\u000e];mCR,7/\u00168dY\u0016\fg.\u00192mK6+GO]5dg\"\u0012\u0011b\u0016\t\u0003\u0019bK!!W'\u0003\tQ+7\u000f^\u0001\tO\u0016$x)Y;hKV\u0011Al\u001b\u000b\u0003;R\u00042AX4j\u001b\u0005y&B\u00011b\u0003\u0011\u0019wN]3\u000b\u0005\t\u001c\u0017aB7fiJL7m\u001d\u0006\u0003I\u0016\fa!_1n[\u0016\u0014(\"\u00014\u0002\u0007\r|W.\u0003\u0002i?\n)q)Y;hKB\u0011!n\u001b\u0007\u0001\t\u0015a'B1\u0001n\u0005\u0005!\u0016C\u00018r!\tYt.\u0003\u0002qy\t9aj\u001c;iS:<\u0007CA\u001es\u0013\t\u0019HHA\u0002B]fDQ!\u001e\u0006A\u0002Y\faAZ5mi\u0016\u0014\b\u0003B\u001exsrL!\u0001\u001f\u001f\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u00010{\u0013\tYxL\u0001\u0006NKR\u0014\u0018n\u0019(b[\u0016\u0004\"aO?\n\u0005yd$a\u0002\"p_2,\u0017M\\\u000b\u0005\u0003\u0003\t9\u0001\u0006\u0003\u0002\u0004\u0005%\u0001\u0003\u00020h\u0003\u000b\u00012A[A\u0004\t\u0015a7B1\u0001n\u0011\u001d\tYa\u0003a\u0001\u0003\u001b\t!\"\\3ue&\u001cg*Y7f!\u0011\ty!!\b\u000f\t\u0005E\u0011\u0011\u0004\t\u0004\u0003'aTBAA\u000b\u0015\r\t9BF\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005mA(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003?\t\tC\u0001\u0004TiJLgn\u001a\u0006\u0004\u00037aT\u0003BA\u0013\u0003W!b!a\n\u0002.\u0005=\u0002\u0003\u00020h\u0003S\u00012A[A\u0016\t\u0015aGB1\u0001n\u0011\u001d\tY\u0001\u0004a\u0001\u0003\u001bAq!!\r\r\u0001\u0004\ti!A\u0006nKR\u0014\u0018nY*d_B,\u0017a\u0006;fgRl\u0015\r\u001f'pO\u000e{W\u000e]1di&|g\u000eT1hQ\tiq+A\u0006sK\u0006$gI]8n\u0019><G\u0003BA\u001e\u0003'\u0002b!!\u0010\u0002D\u0005\u001dSBAA \u0015\r\t\t\u0005P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA#\u0003\u007f\u0011\u0001\"\u0013;fe\u0006\u0014G.\u001a\t\bw\u0005%\u0013QJA'\u0013\r\tY\u0005\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007m\ny%C\u0002\u0002Rq\u00121!\u00138u\u0011\u0019\u0019b\u00021\u0001\u0002VA\u0019\u0011$a\u0016\n\u0007\u0005e#C\u0001\u0006V]&4\u0017.\u001a3M_\u001e\fAb\u001e:ji\u0016\\U-\u001f#vaN$\u0002#a\u0018\u0002f\u0005%\u0014QNA8\u0003c\nY(a \u0011\r\u0005u\u0012\u0011MA$\u0013\u0011\t\u0019'a\u0010\u0003\u0007M+\u0017\u000fC\u0004\u0002h=\u0001\r!!\u0014\u0002\u000f9,XnS3zg\"9\u00111N\bA\u0002\u00055\u0013a\u00028v[\u0012+\bo\u001d\u0005\u0007'=\u0001\r!!\u0016\t\u000b}y\u0001\u0019A\u0011\t\u000f\u0005Mt\u00021\u0001\u0002v\u0005IA/[7fgR\fW\u000e\u001d\t\u0004w\u0005]\u0014bAA=y\t!Aj\u001c8h\u0011\u001d\tih\u0004a\u0001\u0003\u001b\n!b\u001d;beR4\u0016\r\\;f\u0011\u001d\t\ti\u0004a\u0001\u0003\u001b\nAa\u001d;fa\u0006\u0011B/Z:u\u0013N$\u0006N]3bI\u001a\u000b\u0017\u000e\\3eQ\t\u0001r\u000b")
public class LogCleanerIntegrationTest
extends AbstractLogCleanerIntegrationTest {
    private final CompressionType codec = CompressionType.LZ4;
    private final MockTime time = new MockTime();
    private final TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});

    public CompressionType codec() {
        return this.codec;
    }

    @Override
    public MockTime time() {
        return this.time;
    }

    public TopicPartition[] topicPartitions() {
        return this.topicPartitions;
    }

    @AfterEach
    public void cleanup() {
        TestUtils$.MODULE$.clearYammerMetrics();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics() {
        void var3_3;
        int largeMessageKey = 20;
        Tuple2<String, MemoryRecords> tuple2 = this.createLargeSingleMessageSet(largeMessageKey, (byte)2, this.codec());
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        MemoryRecords largeMessageSet = (MemoryRecords)tuple2._2();
        int maxMessageSize = var3_3.sizeInBytes();
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, x$4, x$5, x$3, maxMessageSize, x$6, x$7, x$8, x$9, x$10, x$11));
        this.breakPartitionLog$1(this.topicPartitions()[0]);
        this.breakPartitionLog$1(this.topicPartitions()[1]);
        this.cleaner().startup();
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[0]);
        UnifiedLog log2 = (UnifiedLog)this.cleaner().logs().get((Object)this.topicPartitions()[1]);
        String uncleanableDirectory = log.dir().getParent();
        Gauge uncleanablePartitionsCountGauge = this.getGauge("uncleanable-partitions-count", uncleanableDirectory);
        Gauge uncleanableBytesGauge = this.getGauge("uncleanable-bytes", uncleanableDirectory);
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        long expectedTotalUncleanableBytes = LogCleanerManager$.MODULE$.calculateCleanableBytes(log, 0L, ((LogSegment)log.logSegments().last()).baseOffset())._2$mcJ$sp() + LogCleanerManager$.MODULE$.calculateCleanableBytes(log2, 0L, ((LogSegment)log2.logSegments().last()).baseOffset())._2$mcJ$sp();
        long l3 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l4 = 1000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(uncleanableBytesGauge, expectedTotalUncleanableBytes)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(expectedTotalUncleanableBytes));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions.contains((Object)this.topicPartitions()[2]));
        this.cleaner().logs().remove((Object)this.topicPartitions()[0]);
        long l5 = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l6 = 2000L;
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime3 = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(this, uncleanablePartitionsCountGauge)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime3 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Set uncleanablePartitions2 = this.cleaner().cleanerManager().uncleanablePartitions(uncleanableDirectory);
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[0]));
        Assertions.assertTrue((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[1]));
        Assertions.assertFalse((boolean)uncleanablePartitions2.contains((Object)this.topicPartitions()[2]));
    }

    private <T> Gauge<T> getGauge(Function1<MetricName, Object> filter) {
        return (Gauge)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getGauge$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getGauge$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName) {
        Function1 & Serializable & scala.Serializable getGauge_filter = (Function1 & Serializable & scala.Serializable)mName -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$3(metricName, mName));
        return (Gauge)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getGauge$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getGauge$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    private <T> Gauge<T> getGauge(String metricName, String metricScope) {
        Function1 & Serializable & scala.Serializable getGauge_filter = (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$getGauge$4(metricName, metricScope, k));
        return (Gauge)((Tuple2)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala()).filter((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            MetricName $anonfun$getGauge$1_k = (MetricName)x0$1._1();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)filter.apply((Object)$anonfun$getGauge$1_k));
            return BoxesRunTime.boxToBoolean((boolean)bl);
        })).headOption().getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)"Unable to find metric")))._2();
    }

    @Test
    public void testMaxLogCompactionLag() {
        int msPerHour = 3600000;
        int minCompactionLagMs = 1 * msPerHour;
        int maxCompactionLagMs = 6 * msPerHour;
        long cleanerBackOffMs = 200L;
        int segmentSize = 512;
        TopicPartition[] topicPartitions = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        float minCleanableDirtyRatio = 1.0f;
        WrappedArray x$1 = Predef$.MODULE$.wrapRefArray((Object[])topicPartitions);
        long x$3 = minCompactionLagMs;
        long x$5 = maxCompactionLagMs;
        int x$7 = this.makeCleaner$default$3();
        int x$8 = this.makeCleaner$default$5();
        int x$9 = this.makeCleaner$default$7();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$1, minCleanableDirtyRatio, x$7, cleanerBackOffMs, x$8, x$3, x$9, segmentSize, x$5, x$10, x$11));
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)topicPartitions[0]);
        long T0 = this.time().milliseconds();
        this.writeKeyDups(100, 3, log, CompressionType.NONE, T0, 0, 1);
        long startSizeBlock0 = log.size();
        LogSegment activeSegAtT0 = log.activeSegment();
        this.cleaner().startup();
        this.time().sleep(maxCompactionLagMs / 2);
        Thread.sleep(5L * cleanerBackOffMs);
        Assertions.assertEquals((long)startSizeBlock0, (long)log.size(), (String)"There should be no cleaning until the max compaction lag has passed");
        this.time().sleep(maxCompactionLagMs / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends1 = this.writeKeyDups(100, 1, log, CompressionType.NONE, T1, 0, 0);
        log.roll(log.roll$default$1());
        LogSegment activeSegAtT1 = log.activeSegment();
        long firstBlockCleanableSegmentOffset = activeSegAtT0.baseOffset();
        LogCleaner qual$1 = this.cleaner();
        TopicPartition x$12 = new TopicPartition("log", 0);
        long x$14 = qual$1.awaitCleaned$default$3();
        qual$1.awaitCleaned(x$12, firstBlockCleanableSegmentOffset, x$14);
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        long lastCleaned = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assertions.assertTrue((lastCleaned >= firstBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(firstBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned).toString());
        Assertions.assertNotEquals(appends1, read1, (String)"log should still contain non-zero keys");
        this.time().sleep(maxCompactionLagMs + 1);
        LogCleaner qual$2 = this.cleaner();
        TopicPartition x$15 = new TopicPartition("log", 0);
        long x$16 = activeSegAtT1.baseOffset();
        long x$17 = qual$2.awaitCleaned$default$3();
        qual$2.awaitCleaned(x$15, x$16, x$17);
        Iterable<Tuple2<Object, Object>> read2 = this.readFromLog(log);
        Assertions.assertEquals(appends1, read2, (String)"log should only contains zero keys now");
        long lastCleaned2 = BoxesRunTime.unboxToLong((Object)this.cleaner().cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        long secondBlockCleanableSegmentOffset = activeSegAtT1.baseOffset();
        Assertions.assertTrue((lastCleaned2 >= secondBlockCleanableSegmentOffset ? 1 : 0) != 0, (String)new StringBuilder(71).append("log cleaner should have processed at least to offset ").append(secondBlockCleanableSegmentOffset).append(", but lastCleaned=").append(lastCleaned2).toString());
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(UnifiedLog log) {
        return (Iterable)log.logSegments().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Iterable)((TraversableLike)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().records()).asScala()).map((Function1 & Serializable & scala.Serializable)record -> {
            int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(record.value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
        }, Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeKeyDups(int numKeys, int numDups, UnifiedLog log, CompressionType codec, long timestamp, int startValue, int step) {
        IntRef valCounter = IntRef.create((int)startValue);
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1 & Serializable & scala.Serializable)_ -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$1(numKeys, valCounter, log, codec, timestamp, step, BoxesRunTime.unboxToInt((Object)_)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIsThreadFailed() {
        String metricName = "DeadThreadCount";
        WrappedArray x$12 = Predef$.MODULE$.wrapRefArray((Object[])this.topicPartitions());
        int x$2 = 100000;
        long x$3 = 100L;
        float x$4 = this.makeCleaner$default$2();
        int x$5 = this.makeCleaner$default$3();
        long x$6 = this.makeCleaner$default$6();
        int x$7 = this.makeCleaner$default$7();
        int x$8 = this.makeCleaner$default$8();
        long x$9 = this.makeCleaner$default$9();
        Option<Object> x$10 = this.makeCleaner$default$10();
        Properties x$11 = this.makeCleaner$default$11();
        this.cleaner_$eq(this.makeCleaner((Iterable<TopicPartition>)x$12, x$4, x$5, x$3, x$2, x$6, x$7, x$8, x$9, x$10, x$11));
        this.cleaner().startup();
        Assertions.assertEquals((int)0, (int)this.cleaner().deadThreadCount());
        this.cleaner().cleaners().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.interrupt();
            return BoxedUnit.UNIT;
        });
        long l = TestUtils$.MODULE$.waitUntilTrue$default$4();
        long l2 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$2(this)) {
            void waitUntilTrue_pause;
            void waitUntilTrue_waitTimeMs;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$4());
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper((long)waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)BoxesRunTime.unboxToInt((Object)this.getGauge(metricName).value()));
        Assertions.assertEquals((int)this.cleaner().cleaners().size(), (int)this.cleaner().deadThreadCount());
    }

    private final void breakPartitionLog$1(TopicPartition tp) {
        UnifiedLog log = (UnifiedLog)this.cleaner().logs().get((Object)tp);
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
        File partitionFile = ((LogSegment)log.logSegments().last()).log().file();
        PrintWriter writer = new PrintWriter(partitionFile);
        writer.write("jogeajgoea");
        writer.close();
        this.writeDups(20, 3, log, this.codec(), this.writeDups$default$5(), this.writeDups$default$6());
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$1(Gauge uncleanablePartitionsCountGauge$1) {
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 2;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$2() {
        return "There should be 2 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$3(Gauge uncleanableBytesGauge$1, long expectedTotalUncleanableBytes$1) {
        return BoxesRunTime.unboxToLong((Object)uncleanableBytesGauge$1.value()) == expectedTotalUncleanableBytes$1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$4(long expectedTotalUncleanableBytes$1) {
        return new StringBuilder(34).append("There should be ").append(expectedTotalUncleanableBytes$1).append(" uncleanable bytes").toString();
    }

    public static final /* synthetic */ boolean $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$5(LogCleanerIntegrationTest $this, Gauge uncleanablePartitionsCountGauge$1) {
        $this.time().sleep(1000L);
        return BoxesRunTime.unboxToInt((Object)uncleanablePartitionsCountGauge$1.value()) == 1;
    }

    public static final /* synthetic */ String $anonfun$testMarksPartitionsAsOfflineAndPopulatesUncleanableMetrics$6() {
        return "There should be 1 uncleanable partitions";
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$1(Function1 filter$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        MetricName k = (MetricName)x0$1._1();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)filter$1.apply((Object)k));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$3(String metricName$1, MetricName mName) {
        return mName.getName().endsWith(metricName$1) && mName.getScope() == null;
    }

    public static final /* synthetic */ boolean $anonfun$getGauge$4(String metricName$2, String metricScope$1, MetricName k) {
        return k.getName().endsWith(metricName$2) && k.getScope().endsWith(metricScope$1);
    }

    public static final /* synthetic */ Tuple2 $anonfun$writeKeyDups$2(IntRef valCounter$1, UnifiedLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int key) {
        int curValue = valCounter$1.elem;
        byte[] x$1 = Integer.toString(curValue).getBytes();
        byte[] x$3 = Integer.toString(key).getBytes();
        byte x$5 = TestUtils$.MODULE$.singletonRecords$default$5();
        log$1.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, x$3, codec$1, timestamp$1, x$5), 0, log$1.appendAsLeader$default$3(), log$1.appendAsLeader$default$4(), log$1.appendAsLeader$default$5());
        log$1.updateHighWatermark(log$1.logEndOffset());
        valCounter$1.elem += step$1;
        return new Tuple2.mcII.sp(key, curValue);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$writeKeyDups$1(int numKeys$1, IntRef valCounter$1, UnifiedLog log$1, CompressionType codec$1, long timestamp$1, int step$1, int _) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numKeys$1).map((Function1 & Serializable & scala.Serializable)key -> LogCleanerIntegrationTest.$anonfun$writeKeyDups$2(valCounter$1, log$1, codec$1, timestamp$1, step$1, BoxesRunTime.unboxToInt((Object)key)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$3(boolean result, LogCleaner.CleanerThread thread) {
        return thread.isThreadFailed() && result;
    }

    public static final /* synthetic */ boolean $anonfun$testIsThreadFailed$2(LogCleanerIntegrationTest $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.cleaner().cleaners().foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2 & Serializable & scala.Serializable)(result, thread) -> BoxesRunTime.boxToBoolean((boolean)LogCleanerIntegrationTest.$anonfun$testIsThreadFailed$3(BoxesRunTime.unboxToBoolean((Object)result), thread))));
    }

    public static final /* synthetic */ String $anonfun$testIsThreadFailed$4() {
        return "Threads didn't terminate unexpectedly";
    }
}

