/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.ThrottledReplicaListValidator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001\u0002\u000b\u0016\u0001iAQ!\t\u0001\u0005\u0002\tBQ!\n\u0001\u0005\u0002\u0019BQa\u000e\u0001\u0005\u0002\u0019BQ!\u000f\u0001\u0005\u0002\u0019BQa\u000f\u0001\u0005\u0002\u0019BQ!\u0010\u0001\u0005\u0002\u0019BQa\u0010\u0001\u0005\u0002\u0019BQ!\u0011\u0001\u0005\u0002\u0019BQa\u0011\u0001\u0005\u0002\u0019BQ!\u0012\u0001\u0005\u0002\u0019BQa\u0012\u0001\u0005\u0002\u0019BQ!\u0013\u0001\u0005\u0002\u0019BQa\u0013\u0001\u0005\n1CQ!\u0018\u0001\u0005\nyCQA\u001a\u0001\u0005\u0002\u0019BQ\u0001\u001b\u0001\u0005\u0002\u0019BQA\u001b\u0001\u0005\u0002\u0019BQ\u0001\u001c\u0001\u0005\u0002\u0019BQA\u001c\u0001\u0005\n=\u0014Q\u0002T8h\u0007>tg-[4UKN$(B\u0001\f\u0018\u0003\rawn\u001a\u0006\u00021\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012a\t\t\u0003I\u0001i\u0011!F\u0001,K:\u001cXO]3O_N#\u0018\r^5d\u0013:LG/[1mSj\fG/[8o\u001fJ$WM\u001d#fa\u0016tG-\u001a8dsR\tq\u0005\u0005\u0002\u001dQ%\u0011\u0011&\b\u0002\u0005+:LG\u000f\u000b\u0002\u0003WA\u0011A&N\u0007\u0002[)\u0011afL\u0001\u0004CBL'B\u0001\u00192\u0003\u001dQW\u000f]5uKJT!AM\u001a\u0002\u000b),h.\u001b;\u000b\u0003Q\n1a\u001c:h\u0013\t1TF\u0001\u0003UKN$\u0018A\u0006;fgR\\\u0015MZ6b\u0007>tg-[4U_B\u0013x\u000e]:)\u0005\rY\u0013\u0001\u0006;fgR4%o\\7Qe>\u00048/\u00138wC2LG\r\u000b\u0002\u0005W\u0005qB/Z:u\u0013:4\u0018\r\\5e\u0007>l\u0007/Y2uS>tG*Y4D_:4\u0017n\u001a\u0015\u0003\u000b-\nQe\u001d5pk2$g+\u00197jI\u0006$X\r\u00165s_R$H.\u001a3SKBd\u0017nY1t\u0007>tg-[4)\u0005\u0019Y\u0013a\u0004;fgR$v\u000e\u0013;nYR\u000b'\r\\3)\u0005\u001dY\u0013A\u0003;fgR$v\u000e\u0013;nY\"\u0012\u0001bK\u0001\u0012i\u0016\u001cH\u000fV8F]JL7\r[3e%N$\bFA\u0005,\u0003%!Xm\u001d;U_J\u001bH\u000f\u000b\u0002\u000bW\u0005\u0011B/Z:u\u000f\u0016$8i\u001c8gS\u001e4\u0016\r\\;fQ\tY1&A\u0013uKN$xJ^3se&$G-\u001a8D_:4\u0017nZ:Bg2{wmZ1cY\u0016\u001cFO]5oO\"\u0012AbK\u0001\bSN4\u0016\r\\5e)\ti\u0005\u000b\u0005\u0002\u001d\u001d&\u0011q*\b\u0002\b\u0005>|G.Z1o\u0011\u0015\tV\u00021\u0001S\u0003-\u0019wN\u001c4jOZ\u000bG.^3\u0011\u0005MSfB\u0001+Y!\t)V$D\u0001W\u0015\t9\u0016$\u0001\u0004=e>|GOP\u0005\u00033v\ta\u0001\u0015:fI\u00164\u0017BA.]\u0005\u0019\u0019FO]5oO*\u0011\u0011,H\u0001\u0016CN\u001cXM\u001d;Qe>\u0004XM\u001d;z\u0013:4\u0018\r\\5e)\r9s,\u0019\u0005\u0006A:\u0001\rAU\u0001\u0005]\u0006lW\rC\u0003c\u001d\u0001\u00071-\u0001\u0004wC2,Xm\u001d\t\u00049\u0011\\\u0012BA3\u001e\u0005)a$/\u001a9fCR,GMP\u0001\"i\u0016\u001cH\u000fT8dC2dun\u001a*fi\u0016tG/[8o\t\u0016\u0014\u0018N^3e!J|\u0007o\u001d\u0015\u0003\u001f-\n\u0001\u0006^3ti2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000eR3sSZ,G\rR3gCVdG\u000f\u0015:paND#\u0001E\u0016\u00025Q,7\u000f\u001e'pG\u0006dGj\\4SKR,g\u000e^5p]B\u0013x\u000e]:)\u0005EY\u0013!\t;fgRLeN^1mS\u0012dunY1m\u0019><'+\u001a;f]RLwN\u001c)s_B\u001c\bF\u0001\n,\u0003\r\"w\u000eV3ti&sg/\u00197jI2{7-\u00197M_\u001e\u0014V\r^3oi&|g\u000e\u0015:paN$\u0002\u0002]>\u0002\u0002\u0005-\u0011q\u0002\t\u0003cfl\u0011A\u001d\u0006\u0003gR\faaY8oM&<'BA;w\u0003\u0019\u0019w.\\7p]*\u0011\u0001d\u001e\u0006\u0003qN\na!\u00199bG\",\u0017B\u0001>s\u0005=\u0019uN\u001c4jO\u0016C8-\u001a9uS>t\u0007\"\u0002?\u0014\u0001\u0004i\u0018\u0001\u00057pG\u0006d'+\u001a;f]RLwN\\'t!\tab0\u0003\u0002\u0000;\t!Aj\u001c8h\u0011\u001d\t\u0019a\u0005a\u0001\u0003\u000b\t1\u0003\\8dC2\u0014V\r^3oi&|gNQ=uKN\u00042\u0001HA\u0004\u0013\r\tI!\b\u0002\u0004\u0013:$\bbBA\u0007'\u0001\u0007\u0011QA\u0001\u000fe\u0016$XM\u001c;j_:\u0014\u0015\u0010^3t\u0011\u0019\t\tb\u0005a\u0001{\u0006Y!/\u001a;f]RLwN\\'t\u0001")
public class LogConfigTest {
    @Test
    public void ensureNoStaticInitializationOrderDependency() {
        Assertions.assertNotNull((Object)KafkaConfig$.MODULE$.LogRetentionTimeMillisProp());
        Assertions.assertTrue((boolean)((IterableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(LogConfig.configNames()).asScala()).filter((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$1(config)))).forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)LogConfigTest.$anonfun$ensureNoStaticInitializationOrderDependency$2(config))));
    }

    @Test
    public void testKafkaConfigToProps() {
        long millisInHour = 3600000L;
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRollTimeJitterHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionTimeHoursProp(), "2");
        kafkaProps.put(KafkaConfig$.MODULE$.LogMessageFormatVersionProp(), "0.11.0");
        Map logProps = KafkaConfig$.MODULE$.fromProps(kafkaProps).extractLogConfigMap();
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("segment.jitter.ms"));
        Assertions.assertEquals((Object)BoxesRunTime.boxToLong((long)(2L * millisInHour)), logProps.get("retention.ms"));
        Assertions.assertEquals((Object)MetadataVersion.IBP_3_0_IV1.version(), logProps.get("message.format.version"));
    }

    @Test
    public void testFromPropsInvalid() {
        LogConfig.configNames().forEach(name -> {
            if ("unclean.leader.election.enable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not a boolean"}));
                return;
            }
            if ("retention.bytes".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                return;
            }
            if ("retention.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number"}));
                return;
            }
            if ("cleanup.policy".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"true", "foobar"}));
                return;
            }
            if ("min.cleanable.dirty.ratio".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-0.1", "1.2"}));
                return;
            }
            if ("min.insync.replicas".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "0", "-1"}));
                return;
            }
            if ("message.format.version".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{""}));
                return;
            }
            if ("remote.storage.enable".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_boolean"}));
                return;
            }
            if ("local.retention.ms".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                return;
            }
            if ("local.retention.bytes".equals(name)) {
                this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-3"}));
                return;
            }
            this.assertPropertyInvalid((String)name, (Seq<Object>)Predef$.MODULE$.wrapRefArray(new Object[]{"not_a_number", "-1"}));
        });
    }

    @Test
    public void testInvalidCompactionLagConfig() {
        Properties props = new Properties();
        props.setProperty("max.compaction.lag.ms", "100");
        props.setProperty("min.compaction.lag.ms", "200");
        Assertions.assertThrows(Exception.class, () -> LogConfig.validate((Properties)props));
    }

    @Test
    public void shouldValidateThrottledReplicasConfig() {
        Assertions.assertTrue((boolean)this.isValid("*"));
        Assertions.assertTrue((boolean)this.isValid("* "));
        Assertions.assertTrue((boolean)this.isValid(""));
        Assertions.assertTrue((boolean)this.isValid(" "));
        Assertions.assertTrue((boolean)this.isValid("100:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1"));
        Assertions.assertTrue((boolean)this.isValid("100:10,12:10,15:1  "));
        Assertions.assertTrue((boolean)this.isValid("100:0,"));
        Assertions.assertFalse((boolean)this.isValid("100"));
        Assertions.assertFalse((boolean)this.isValid("100:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:"));
        Assertions.assertFalse((boolean)this.isValid("100:0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100 :0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100: 0,10:   "));
        Assertions.assertFalse((boolean)this.isValid("100:0,10 :   "));
        Assertions.assertFalse((boolean)this.isValid("*,100:10"));
        Assertions.assertFalse((boolean)this.isValid("* ,100:10"));
    }

    @Test
    public void testToHtmlTable() {
        String html = LogConfig.configDefCopy().toHtmlTable();
        String expectedConfig = "<td>file.delete.delay.ms</td>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToHtml() {
        String html = LogConfig.configDefCopy().toHtml(4, key -> new StringBuilder(7).append("prefix_").append((String)key).toString(), Collections.emptyMap());
        String expectedConfig = "<h4><a id=\"file.delete.delay.ms\"></a><a id=\"prefix_file.delete.delay.ms\" href=\"#prefix_file.delete.delay.ms\">file.delete.delay.ms</a></h4>";
        Assertions.assertTrue((boolean)html.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(html).toString());
    }

    @Test
    public void testToEnrichedRst() {
        String rst = LogConfig.configDefCopy().toEnrichedRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testToRst() {
        String rst = LogConfig.configDefCopy().toRst();
        String expectedConfig = "``file.delete.delay.ms``";
        Assertions.assertTrue((boolean)rst.contains(expectedConfig), (String)new StringBuilder(23).append("Could not find `").append(expectedConfig).append("` in:\n ").append(rst).toString());
    }

    @Test
    public void testGetConfigValue() {
        LogConfig.LogConfigDef configDef = LogConfig.configDefCopy();
        String configNameWithNoServerMapping = "log.foo";
        configDef.define(configNameWithNoServerMapping, ConfigDef.Type.INT, (Object)BoxesRunTime.boxToInteger((int)1), ConfigDef.Importance.MEDIUM, new StringBuilder(4).append(configNameWithNoServerMapping).append(" doc").toString());
        ConfigDef.ConfigKey deleteDelayKey = (ConfigDef.ConfigKey)configDef.configKeys().get("file.delete.delay.ms");
        String deleteDelayServerDefault = configDef.getConfigValue(deleteDelayKey, "Server Default Property");
        Assertions.assertEquals((Object)KafkaConfig$.MODULE$.LogDeleteDelayMsProp(), (Object)deleteDelayServerDefault);
        ConfigDef.ConfigKey keyWithNoServerMapping = (ConfigDef.ConfigKey)configDef.configKeys().get(configNameWithNoServerMapping);
        Assertions.assertNull((Object)configDef.getConfigValue(keyWithNoServerMapping, "Server Default Property"));
    }

    @Test
    public void testOverriddenConfigsAsLoggableString() {
        Properties kafkaProps = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        kafkaProps.put("unknown.broker.password.config", "aaaaa");
        kafkaProps.put(KafkaConfig$.MODULE$.SslKeyPasswordProp(), "somekeypassword");
        kafkaProps.put(KafkaConfig$.MODULE$.LogRetentionBytesProp(), "50");
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(kafkaProps);
        Properties topicOverrides = new Properties();
        topicOverrides.setProperty("min.insync.replicas", "2");
        topicOverrides.setProperty("retention.bytes", "100");
        topicOverrides.setProperty(KafkaConfig$.MODULE$.SslTruststorePasswordProp(), "sometrustpasswrd");
        topicOverrides.setProperty("unknown.topic.password.config", "bbbb");
        LogConfig logConfig = LogConfig.fromProps((Map)kafkaConfig.extractLogConfigMap(), (Properties)topicOverrides);
        Assertions.assertEquals((Object)"{min.insync.replicas=2, retention.bytes=100, ssl.truststore.password=(redacted), unknown.topic.password.config=(redacted)}", (Object)logConfig.overriddenConfigsAsLoggableString());
    }

    private boolean isValid(String configValue) {
        try {
            ThrottledReplicaListValidator.ensureValidString((String)"", (String)configValue);
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    private void assertPropertyInvalid(String name, Seq<Object> values) {
        values.foreach((Function1 & Serializable & scala.Serializable)value -> {
            Properties props = new Properties();
            props.setProperty(name, value.toString());
            return (Exception)Assertions.assertThrows(Exception.class, () -> new LogConfig((Map)props));
        });
    }

    @Test
    public void testLocalLogRetentionDerivedProps() {
        Properties props = new Properties();
        int retentionBytes = 1024;
        long retentionMs = 1000L;
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)retentionMs, (long)logConfig.remoteLogConfig.localRetentionMs);
        Assertions.assertEquals((long)retentionBytes, (long)logConfig.remoteLogConfig.localRetentionBytes);
    }

    @Test
    public void testLocalLogRetentionDerivedDefaultProps() {
        LogConfig logConfig = new LogConfig((Map)new Properties());
        Assertions.assertEquals((long)604800000L, (long)logConfig.remoteLogConfig.localRetentionMs);
        Assertions.assertEquals((long)-1L, (long)logConfig.remoteLogConfig.localRetentionBytes);
    }

    @Test
    public void testLocalLogRetentionProps() {
        Properties props = new Properties();
        int localRetentionMs = 500;
        int localRetentionBytes = 1000;
        props.put("retention.bytes", Integer.toString(2000));
        props.put("retention.ms", Integer.toString(1000));
        props.put("local.retention.ms", Integer.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        LogConfig logConfig = new LogConfig((Map)props);
        Assertions.assertEquals((long)localRetentionMs, (long)logConfig.remoteLogConfig.localRetentionMs);
        Assertions.assertEquals((long)localRetentionBytes, (long)logConfig.remoteLogConfig.localRetentionBytes);
    }

    @Test
    public void testInvalidLocalLogRetentionProps() {
        this.doTestInvalidLocalLogRetentionProps(-3L, 10, 2, 500L);
        this.doTestInvalidLocalLogRetentionProps(500L, -3, 2, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, 2, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(500L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(-1L, 200, 100, 1000L);
        this.doTestInvalidLocalLogRetentionProps(2000L, -1, 100, 1000L);
    }

    private ConfigException doTestInvalidLocalLogRetentionProps(long localRetentionMs, int localRetentionBytes, int retentionBytes, long retentionMs) {
        Properties props = new Properties();
        props.put("retention.bytes", Integer.toString(retentionBytes));
        props.put("retention.ms", Long.toString(retentionMs));
        props.put("local.retention.ms", Long.toString(localRetentionMs));
        props.put("local.retention.bytes", Integer.toString(localRetentionBytes));
        return (ConfigException)Assertions.assertThrows(ConfigException.class, () -> new LogConfig((Map)props));
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$1(String config) {
        return !LogConfig.CONFIGS_WITH_NO_SERVER_DEFAULTS.contains(config);
    }

    public static final /* synthetic */ boolean $anonfun$ensureNoStaticInitializationOrderDependency$2(String config) {
        Optional serverConfigOpt = LogConfig.serverConfigName((String)config);
        return serverConfigOpt.isPresent() && serverConfigOpt.get() != null;
    }
}

