/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.errors.InvalidOffsetException;
import org.apache.kafka.storage.internals.log.OffsetIndex;
import org.apache.kafka.storage.internals.log.OffsetPosition;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeMap;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015d\u0001B\r\u001b\u0001}AQA\n\u0001\u0005\u0002\u001dB\u0011B\u000b\u0001A\u0002\u0003\u0007I\u0011A\u0016\t\u0013i\u0002\u0001\u0019!a\u0001\n\u0003Y\u0004\"C!\u0001\u0001\u0004\u0005\t\u0015)\u0003-\u0011\u001d\u0011\u0005A1A\u0005\u0002\rCaa\u0012\u0001!\u0002\u0013!\u0005b\u0002%\u0001\u0005\u0004%\t!\u0013\u0005\u0007\u001b\u0002\u0001\u000b\u0011\u0002&\t\u000b9\u0003A\u0011A(\t\u000bm\u0003A\u0011A(\t\u000b\u0001\u0004A\u0011A(\t\u000b\u0015\u0004A\u0011A(\t\u000b\u001d\u0004A\u0011A(\t\u000b%\u0004A\u0011A(\t\u000b-\u0004A\u0011A(\t\u000b5\u0004A\u0011A(\t\u000b=\u0004A\u0011A(\t\u000bE\u0004A\u0011A(\t\u000bM\u0004A\u0011A(\t\u000bU\u0004A\u0011A(\t\u000b]\u0004A\u0011A(\t\u000be\u0004A\u0011\u0001>\t\u000f\u0005e\u0002\u0001\"\u0001\u0002<!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M#aD(gMN,G/\u00138eKb$Vm\u001d;\u000b\u0005ma\u0012a\u00017pO*\tQ$A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001\u0001\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002QA\u0011\u0011\u0006A\u0007\u00025\u0005\u0019\u0011\u000e\u001a=\u0016\u00031\u0002\"!\f\u001d\u000e\u00039R!aG\u0018\u000b\u0005A\n\u0014!C5oi\u0016\u0014h.\u00197t\u0015\t\u00114'A\u0004ti>\u0014\u0018mZ3\u000b\u0005u!$BA\u001b7\u0003\u0019\t\u0007/Y2iK*\tq'A\u0002pe\u001eL!!\u000f\u0018\u0003\u0017=3gm]3u\u0013:$W\r_\u0001\bS\u0012Dx\fJ3r)\tat\b\u0005\u0002\"{%\u0011aH\t\u0002\u0005+:LG\u000fC\u0004A\u0007\u0005\u0005\t\u0019\u0001\u0017\u0002\u0007a$\u0013'\u0001\u0003jIb\u0004\u0013AC7bq\u0016sGO]5fgV\tA\t\u0005\u0002\"\u000b&\u0011aI\t\u0002\u0004\u0013:$\u0018aC7bq\u0016sGO]5fg\u0002\n!BY1tK>3gm]3u+\u0005Q\u0005CA\u0011L\u0013\ta%E\u0001\u0003M_:<\u0017a\u00032bg\u0016|eMZ:fi\u0002\nQa]3ukB$\u0012\u0001\u0010\u0015\u0003\u0013E\u0003\"AU-\u000e\u0003MS!\u0001V+\u0002\u0007\u0005\u0004\u0018N\u0003\u0002W/\u00069!.\u001e9ji\u0016\u0014(B\u0001-7\u0003\u0015QWO\\5u\u0013\tQ6K\u0001\u0006CK\u001a|'/Z#bG\"\f\u0001\u0002^3be\u0012|wO\u001c\u0015\u0003\u0015u\u0003\"A\u00150\n\u0005}\u001b&!C!gi\u0016\u0014X)Y2i\u0003A\u0011\u0018M\u001c3p[2{wn[;q)\u0016\u001cH\u000f\u000b\u0002\fEB\u0011!kY\u0005\u0003IN\u0013A\u0001V3ti\u0006\u0011Bn\\8lkB,\u0005\u0010\u001e:f[\u0016\u001c\u0015m]3tQ\ta!-A\u0005uKN$XI\u001c;ss\"\u0012QBY\u0001\u0012i\u0016\u001cH/\u00128uef|e/\u001a:gY><\bF\u0001\bc\u00035\t\u0007\u000f]3oIR{w.T1os\"\u0012qBY\u0001\u0011CB\u0004XM\u001c3PkR|em\u0014:eKJD#\u0001\u00052\u00023Q,7\u000f\u001e$fi\u000eDW\u000b\u001d9fe\n{WO\u001c3PM\u001a\u001cX\r\u001e\u0015\u0003#\t\f!\u0002^3tiJ+w\u000e]3oQ\t\u0011\"-\u0001\u0005ueVt7-\u0019;fQ\t\u0019\"-\u0001\bg_J\u001cW-\u00168nCB$Vm\u001d;)\u0005Q\u0011\u0017!\n;fgR\u001c\u0016M\\5us2\u000b7\u000f^(gMN,G/R9vC2$vNQ1tK>3gm]3uQ\t)\"-\u0001\tbgN,'\u000f^,sSR,g)Y5mgV\u001910a\n\u0015\u0011qb\u00181CA\u000b\u00033AQ! \fA\u0002y\fq!\\3tg\u0006<W\rE\u0002\u0000\u0003\u001bqA!!\u0001\u0002\nA\u0019\u00111\u0001\u0012\u000e\u0005\u0005\u0015!bAA\u0004=\u00051AH]8pizJ1!a\u0003#\u0003\u0019\u0001&/\u001a3fM&!\u0011qBA\t\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0002\u0012\t\u000b)2\u0002\u0019\u0001\u0017\t\r\u0005]a\u00031\u0001E\u0003\u0019ygMZ:fi\"9\u00111\u0004\fA\u0002\u0005u\u0011!B6mCN\u001c\b#B@\u0002 \u0005\r\u0012\u0002BA\u0011\u0003#\u0011Qa\u00117bgN\u0004B!!\n\u0002(1\u0001AaBA\u0015-\t\u0007\u00111\u0006\u0002\u0002)F!\u0011QFA\u001a!\r\t\u0013qF\u0005\u0004\u0003c\u0011#a\u0002(pi\"Lgn\u001a\t\u0004C\u0005U\u0012bAA\u001cE\t\u0019\u0011I\\=\u0002\u00195|gn\u001c;p]&\u001c7+Z9\u0015\r\u0005u\u0012\u0011JA'!\u0015\ty$!\u0012E\u001b\t\t\tEC\u0002\u0002D\t\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t9%!\u0011\u0003\u0007M+\u0017\u000f\u0003\u0004\u0002L]\u0001\r\u0001R\u0001\u0005E\u0006\u001cX\r\u0003\u0004\u0002P]\u0001\r\u0001R\u0001\u0004Y\u0016t\u0017a\u00058p]\u0016C\u0018n\u001d;f]R$V-\u001c9GS2,GCAA+!\u0011\t9&!\u0019\u000e\u0005\u0005e#\u0002BA.\u0003;\n!![8\u000b\u0005\u0005}\u0013\u0001\u00026bm\u0006LA!a\u0019\u0002Z\t!a)\u001b7f\u0001")
public class OffsetIndexTest {
    private OffsetIndex idx;
    private final int maxEntries;
    private final long baseOffset;

    public OffsetIndex idx() {
        return this.idx;
    }

    public void idx_$eq(OffsetIndex x$1) {
        this.idx = x$1;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long baseOffset() {
        return this.baseOffset;
    }

    @BeforeEach
    public void setup() {
        this.idx_$eq(new OffsetIndex(this.nonExistentTempFile(), this.baseOffset(), 240));
    }

    @AfterEach
    public void teardown() {
        if (this.idx() != null) {
            this.idx().file().delete();
        }
    }

    @Test
    public void randomLookupTest() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(92L), (String)"Not present value should return physical offset 0.");
        int base = (int)this.idx().baseOffset() + 1;
        int size = this.idx().maxEntries();
        Seq vals = (Seq)((IterableLike)this.monotonicSeq(base, size).map((Function1)(JFunction1.mcJI.sp & Serializable & scala.Serializable)x$1 -> x$1, Seq$.MODULE$.canBuildFrom())).zip(this.monotonicSeq(0, size), Seq$.MODULE$.canBuildFrom());
        vals.foreach((Function1 & Serializable & scala.Serializable)x -> {
            OffsetIndexTest.$anonfun$randomLookupTest$2(this, x);
            return BoxedUnit.UNIT;
        });
        vals.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            OffsetIndexTest.$anonfun$randomLookupTest$4(this, x$2);
            return BoxedUnit.UNIT;
        });
        TreeMap valMap = new TreeMap((Ordering)Ordering.Long$.MODULE$).$plus$plus((GenTraversableOnce)vals.map((Function1 & Serializable & scala.Serializable)p -> new Tuple2((Object)BoxesRunTime.boxToLong((long)p._1$mcJ$sp()), p), Seq$.MODULE$.canBuildFrom()));
        long[] offsets = (long[])new RichLong(Predef$.MODULE$.longWrapper(this.idx().baseOffset())).until((Object)BoxesRunTime.boxToLong((long)((int)((Tuple2)vals.last())._1$mcJ$sp()))).toArray(ClassTag$.MODULE$.Long());
        Collections.shuffle(Arrays.asList((Object[])new long[][]{offsets}));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(offsets)).take(30))).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)offset -> Assertions.assertEquals((Object)(offset < BoxesRunTime.unboxToLong((Object)valMap.firstKey()) ? new OffsetPosition(this.idx().baseOffset(), 0) : new OffsetPosition(valMap.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._1$mcJ$sp(), ((Tuple2)valMap.to((Object)BoxesRunTime.boxToLong((long)offset)).last()._2())._2$mcI$sp())), (Object)this.idx().lookup(offset), (String)"The index should give the same answer as the sorted map"));
    }

    @Test
    public void lookupExtremeCases() {
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()), (String)"Lookup on empty file");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset(), 0), (Object)this.idx().lookup(this.idx().baseOffset()));
        Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)this.idx().maxEntries(), this.idx().maxEntries() - 1), (Object)this.idx().lookup(this.idx().baseOffset() + (long)this.idx().maxEntries()));
    }

    @Test
    public void testEntry() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.idx().append(this.idx().baseOffset() + (long)i + 1L, i));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> Assertions.assertEquals((Object)new OffsetPosition(this.idx().baseOffset() + (long)i + 1L, i), (Object)this.idx().entry(i)));
    }

    @Test
    public void testEntryOverflow() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.idx().entry(0));
    }

    @Test
    public void appendTooMany() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.idx().maxEntries()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            long offset = this.idx().baseOffset() + (long)i + 1L;
            this.idx().append(offset, i);
        });
        this.assertWriteFails("Append should fail on a full index", this.idx(), this.idx().maxEntries() + 1, IllegalArgumentException.class);
    }

    @Test
    public void appendOutOfOrder() {
        this.idx().append(51L, 0);
        Assertions.assertThrows(InvalidOffsetException.class, () -> this.idx().append(50L, 1));
    }

    @Test
    public void testFetchUpperBoundOffset() {
        OffsetPosition first = new OffsetPosition(this.baseOffset() + 0L, 0);
        OffsetPosition second = new OffsetPosition(this.baseOffset() + 1L, 10);
        OffsetPosition third = new OffsetPosition(this.baseOffset() + 2L, 23);
        OffsetPosition fourth = new OffsetPosition(this.baseOffset() + 3L, 37);
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        new .colon.colon((Object)first, (List)new .colon.colon((Object)second, (List)new .colon.colon((Object)third, (List)new .colon.colon((Object)fourth, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)offsetPosition -> {
            OffsetIndexTest.$anonfun$testFetchUpperBoundOffset$1(this, offsetPosition);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals(Optional.of(second), (Object)this.idx().fetchUpperBoundOffset(first, 5));
        Assertions.assertEquals(Optional.of(second), (Object)this.idx().fetchUpperBoundOffset(first, 10));
        Assertions.assertEquals(Optional.of(third), (Object)this.idx().fetchUpperBoundOffset(first, 23));
        Assertions.assertEquals(Optional.of(third), (Object)this.idx().fetchUpperBoundOffset(first, 22));
        Assertions.assertEquals(Optional.of(fourth), (Object)this.idx().fetchUpperBoundOffset(second, 24));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(fourth, 1));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(first, 200));
        Assertions.assertEquals(Optional.empty(), (Object)this.idx().fetchUpperBoundOffset(second, 200));
    }

    @Test
    public void testReopen() {
        OffsetPosition first = new OffsetPosition(51L, 0);
        OffsetPosition sec = new OffsetPosition(52L, 1);
        this.idx().append(first.offset, first.position);
        this.idx().append(sec.offset, sec.position);
        this.idx().close();
        OffsetIndex idxRo = new OffsetIndex(this.idx().file(), this.idx().baseOffset());
        Assertions.assertEquals((Object)first, (Object)idxRo.lookup(first.offset));
        Assertions.assertEquals((Object)sec, (Object)idxRo.lookup(sec.offset));
        Assertions.assertEquals((long)sec.offset, (long)idxRo.lastOffset());
        Assertions.assertEquals((int)2, (int)idxRo.entries());
        this.assertWriteFails("Append should fail on read-only index", idxRo, 53, IllegalArgumentException.class);
    }

    @Test
    public void truncate() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80);
        idx.truncate();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> idx.append((long)i, i));
        idx.truncateTo(12L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate past the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(10L);
        Assertions.assertEquals((Object)new OffsetPosition(9L, 9), (Object)idx.lookup(10L), (String)"Index should be unchanged by truncate at the end");
        Assertions.assertEquals((long)9L, (long)idx.lastOffset(), (String)"9 should be the last entry in the index");
        idx.append(10L, 10);
        idx.truncateTo(9L);
        Assertions.assertEquals((Object)new OffsetPosition(8L, 8), (Object)idx.lookup(10L), (String)"Index should truncate off last entry");
        Assertions.assertEquals((long)8L, (long)idx.lastOffset(), (String)"8 should be the last entry in the index");
        idx.append(9L, 9);
        idx.truncateTo(5L);
        Assertions.assertEquals((Object)new OffsetPosition(4L, 4), (Object)idx.lookup(10L), (String)"4 should be the last entry in the index");
        Assertions.assertEquals((long)4L, (long)idx.lastOffset(), (String)"4 should be the last entry in the index");
        idx.append(5L, 5);
        idx.truncate();
        Assertions.assertEquals((int)0, (int)idx.entries(), (String)"Full truncation should leave no entries");
        idx.append(0L, 0);
    }

    @Test
    public void forceUnmapTest() {
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), 0L, 80);
        idx.forceUnmap();
        Assertions.assertThrows(NullPointerException.class, () -> idx.lookup(1L));
    }

    @Test
    public void testSanityLastOffsetEqualToBaseOffset() {
        long baseOffset = 20L;
        OffsetIndex idx = new OffsetIndex(this.nonExistentTempFile(), baseOffset, 80);
        idx.append(baseOffset, 0);
        idx.sanityCheck();
    }

    public <T> void assertWriteFails(String message, OffsetIndex idx, int offset, Class<T> klass) {
        Exception e = (Exception)Assertions.assertThrows(Exception.class, () -> idx.append((long)offset, 1), () -> message);
        Assertions.assertEquals(klass, e.getClass(), (String)"Got an unexpected exception.");
    }

    public Seq<Object> monotonicSeq(int base, int len) {
        Random rand = new Random(1L);
        ArrayBuffer vals = new ArrayBuffer(len);
        IntRef last = IntRef.create((int)base);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1 & Serializable & scala.Serializable)_ -> OffsetIndexTest.$anonfun$monotonicSeq$1(last, rand, vals, BoxesRunTime.unboxToInt((Object)_)));
        return vals;
    }

    /*
     * WARNING - void declaration
     */
    public File nonExistentTempFile() {
        void var1_1;
        File file = TestUtils$.MODULE$.tempFile();
        Files.delete(file.toPath());
        return var1_1;
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$2(OffsetIndexTest $this, Tuple2 x) {
        $this.idx().append(x._1$mcJ$sp(), x._2$mcI$sp());
    }

    public static final /* synthetic */ void $anonfun$randomLookupTest$4(OffsetIndexTest $this, Tuple2 x$2) {
        if (x$2 != null) {
            long logical = x$2._1$mcJ$sp();
            int physical = x$2._2$mcI$sp();
            Assertions.assertEquals((Object)new OffsetPosition(logical, physical), (Object)$this.idx().lookup(logical), (String)"Should be able to find values that are present.");
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$testFetchUpperBoundOffset$1(OffsetIndexTest $this, OffsetPosition offsetPosition) {
        $this.idx().append(offsetPosition.offset, offsetPosition.position);
    }

    public static final /* synthetic */ ArrayBuffer $anonfun$monotonicSeq$1(IntRef last$1, Random rand$1, ArrayBuffer vals$1, int _) {
        last$1.elem += rand$1.nextInt(15) + 1;
        return vals$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)last$1.elem));
    }

    public OffsetIndexTest() {
        this.maxEntries = 30;
        this.baseOffset = 45L;
    }
}

