/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kafka.network.SocketServer;
import kafka.server.IntegrationTestUtils$;
import kafka.server.KafkaConfig$;
import kafka.test.ClusterInstance;
import kafka.utils.NotNothing$;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import scala.Function1;
import scala.Predef;
import scala.collection.IterableLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.Set$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001]4Q!\u0003\u0006\u0002\u0002=A\u0001B\u0006\u0001\u0003\u0002\u0003\u0006Ia\u0006\u0005\u0006;\u0001!\tA\b\u0005\u0006E\u0001!\ta\t\u0005\u0006}\u0001!\ta\u0010\u0005\u0006\u001b\u0002!\tA\u0014\u0005\u0006!\u0002!\t!\u0015\u0005\b5\u0002\t\n\u0011\"\u0001\\\u0011\u001d1\u0007!%A\u0005\u0002\u001d\u0014a$\u00112tiJ\f7\r^!qSZ+'o]5p]N\u0014V-];fgR$Vm\u001d;\u000b\u0005-a\u0011AB:feZ,'OC\u0001\u000e\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0003\u001d\u0019G.^:uKJ\u0004\"\u0001G\u000e\u000e\u0003eQ!A\u0007\u0007\u0002\tQ,7\u000f^\u0005\u00039e\u0011qb\u00117vgR,'/\u00138ti\u0006t7-Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005}\t\u0003C\u0001\u0011\u0001\u001b\u0005Q\u0001\"\u0002\f\u0003\u0001\u00049\u0012AF:f]\u0012\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;\u0015\u0007\u0011\nd\u0007\u0005\u0002&_5\taE\u0003\u0002(Q\u0005A!/Z9vKN$8O\u0003\u0002*U\u000511m\\7n_:T!!D\u0016\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0005\u0003a\u0019\u00121#\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016DQAM\u0002A\u0002M\nqA]3rk\u0016\u001cH\u000f\u0005\u0002&i%\u0011QG\n\u0002\u0013\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fC\u00038\u0007\u0001\u0007\u0001(\u0001\u0007mSN$XM\\3s\u001d\u0006lW\r\u0005\u0002:y5\t!H\u0003\u0002<Q\u00059a.\u001a;x_J\\\u0017BA\u001f;\u00051a\u0015n\u001d;f]\u0016\u0014h*Y7f\u0003]\u0011'o\\6feB\u0013x\u000e]3sif|e/\u001a:sS\u0012,7\u000f\u0006\u0002A\u0007B\u0011\u0011#Q\u0005\u0003\u0005J\u0011A!\u00168ji\")A\t\u0002a\u0001\u000b\u0006Q\u0001O]8qKJ$\u0018.Z:\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015\u0001B;uS2T\u0011AS\u0001\u0005U\u00064\u0018-\u0003\u0002M\u000f\nQ\u0001K]8qKJ$\u0018.Z:\u0002AM,g\u000eZ+ogV\u0004\bo\u001c:uK\u0012\f\u0005/\u001b,feNLwN\u001c*fcV,7\u000f\u001e\u000b\u0003I=CQAM\u0003A\u0002M\n1D^1mS\u0012\fG/Z!qSZ+'o]5p]N\u0014Vm\u001d9p]N,G\u0003\u0002!S)VCQa\u0015\u0004A\u0002\u0011\n1#\u00199j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016Dqa\u000e\u0004\u0011\u0002\u0003\u0007\u0001\bC\u0004W\rA\u0005\t\u0019A,\u00023\u0015t\u0017M\u00197f+:\u001cH/\u00192mK2\u000b7\u000f\u001e,feNLwN\u001c\t\u0003#aK!!\u0017\n\u0003\u000f\t{w\u000e\\3b]\u0006)c/\u00197jI\u0006$X-\u00119j-\u0016\u00148/[8ogJ+7\u000f]8og\u0016$C-\u001a4bk2$HEM\u000b\u00029*\u0012\u0001(X\u0016\u0002=B\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u0019\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002fA\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002KY\fG.\u001b3bi\u0016\f\u0005/\u001b,feNLwN\\:SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u001aT#\u00015+\u0005]k\u0006\u0006\u0002\u0001kiV\u0004\"a\u001b:\u000e\u00031T!!\u001c8\u0002\u0007\u0005\u0004\u0018N\u0003\u0002pa\u00069!.\u001e9ji\u0016\u0014(BA9.\u0003\u0015QWO\\5u\u0013\t\u0019HNA\u0002UC\u001e\fQA^1mk\u0016\f\u0013A^\u0001\fS:$Xm\u001a:bi&|g\u000e")
public abstract class AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    public ApiVersionsResponse sendApiVersionsRequest(ApiVersionsRequest request, ListenerName listenerName) {
        SocketServer socket = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.controllerSocketServers()).asScala()).head() : (SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head();
        return (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.connectAndReceive((AbstractRequest)request, socket, listenerName, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
    }

    public void brokerPropertyOverrides(Properties properties) {
        if (!this.cluster.isKRaftTest()) {
            String controlPlaneListenerName = "CONTROL_PLANE";
            SecurityProtocol securityProtocol = this.cluster.config().securityProtocol();
            properties.setProperty(KafkaConfig$.MODULE$.ControlPlaneListenerNameProp(), controlPlaneListenerName);
            properties.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(3).append(controlPlaneListenerName).append(":").append(securityProtocol).append(",").append(securityProtocol).append(":").append(securityProtocol).toString());
            properties.setProperty("listeners", new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(controlPlaneListenerName).append("://localhost:0").toString());
            properties.setProperty(KafkaConfig$.MODULE$.AdvertisedListenersProp(), new StringBuilder(29).append(securityProtocol).append("://localhost:0,").append(controlPlaneListenerName).append("://localhost:0").toString());
        }
    }

    public ApiVersionsResponse sendUnsupportedApiVersionRequest(ApiVersionsRequest request) {
        ApiVersionsResponse apiVersionsResponse;
        RequestHeader overrideHeader = IntegrationTestUtils$.MODULE$.nextRequestHeader(ApiKeys.API_VERSIONS, (short)Short.MAX_VALUE, IntegrationTestUtils$.MODULE$.nextRequestHeader$default$3(), IntegrationTestUtils$.MODULE$.nextRequestHeader$default$4());
        try (Socket socket = IntegrationTestUtils$.MODULE$.connect((SocketServer)((IterableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(this.cluster.brokerSocketServers()).asScala()).head(), this.cluster.clientListener());){
            byte[] serializedBytes = Utils.toArray((ByteBuffer)RequestUtils.serialize((Message)overrideHeader.data(), (short)overrideHeader.headerVersion(), (Message)request.data(), (short)request.version()));
            IntegrationTestUtils$.MODULE$.sendRequest(socket, serializedBytes);
            apiVersionsResponse = (ApiVersionsResponse)IntegrationTestUtils$.MODULE$.receive(socket, ApiKeys.API_VERSIONS, (short)0, ClassTag$.MODULE$.apply(ApiVersionsResponse.class), NotNothing$.MODULE$.notNothingEvidence(Predef.$eq$colon$eq$.MODULE$.tpEquals()));
        }
        return apiVersionsResponse;
    }

    public void validateApiVersionsResponse(ApiVersionsResponse apiVersionsResponse, ListenerName listenerName, boolean enableUnstableLastVersion) {
        ApiVersionsResponseData.ApiVersionCollection expectedApis = !this.cluster.isKRaftTest() ? ApiVersionsResponse.collectApis((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER), (boolean)enableUnstableLastVersion) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? ApiVersionsResponse.collectApis((Set)ApiKeys.apisForListener((ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER), (boolean)enableUnstableLastVersion) : ApiVersionsResponse.intersectForwardableApis((ApiMessageType.ListenerType)ApiMessageType.ListenerType.BROKER, (RecordVersion)RecordVersion.current(), (Map)NodeApiVersions.create((Collection)((Collection)CollectionConverters$.MODULE$.mutableSetAsJavaSetConverter((scala.collection.mutable.Set)((SetLike)CollectionConverters$.MODULE$.asScalaSetConverter((Set)ApiKeys.controllerApis()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> ApiVersionsResponse.toApiVersion((ApiKeys)x$1), Set$.MODULE$.canBuildFrom())).asJava())).allSupportedApiVersions(), (boolean)enableUnstableLastVersion));
        Assertions.assertEquals((int)expectedApis.size(), (int)apiVersionsResponse.data().apiKeys().size(), (String)"API keys in ApiVersionsResponse must match API keys supported by broker.");
        ApiVersionsResponse defaultApiVersionsResponse = !this.cluster.isKRaftTest() ? ApiVersionsResponse.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.ZK_BROKER, (boolean)enableUnstableLastVersion) : (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.cluster.controllerListenerName())).contains((Object)listenerName) ? ApiVersionsResponse.defaultApiVersionsResponse((int)0, (ApiMessageType.ListenerType)ApiMessageType.ListenerType.CONTROLLER, (boolean)enableUnstableLastVersion) : ApiVersionsResponse.createApiVersionsResponse((int)0, (ApiVersionsResponseData.ApiVersionCollection)expectedApis));
        ((TraversableLike)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)defaultApiVersionsResponse.data().apiKeys()).asScala()).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)(bl = check$ifrefutable$1 != null))).foreach((Function1 & Serializable & scala.Serializable)expectedApiVersion -> {
            AbstractApiVersionsRequestTest.$anonfun$validateApiVersionsResponse$3(apiVersionsResponse, expectedApiVersion);
            return BoxedUnit.UNIT;
        });
    }

    public ListenerName validateApiVersionsResponse$default$2() {
        return this.cluster.clientListener();
    }

    public boolean validateApiVersionsResponse$default$3() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$validateApiVersionsResponse$3(ApiVersionsResponse apiVersionsResponse$1, ApiVersionsResponseData.ApiVersion expectedApiVersion) {
        ApiVersionsResponseData.ApiVersion actualApiVersion = apiVersionsResponse$1.apiVersion(expectedApiVersion.apiKey());
        Assertions.assertNotNull((Object)actualApiVersion, (String)new StringBuilder(73).append("API key ").append(expectedApiVersion.apiKey()).append(" is supported by broker, but not received in ApiVersionsResponse.").toString());
        Assertions.assertEquals((short)expectedApiVersion.apiKey(), (short)actualApiVersion.apiKey(), (String)"API key must be supported by the broker.");
        Assertions.assertEquals((short)expectedApiVersion.minVersion(), (short)actualApiVersion.minVersion(), (String)new StringBuilder(45).append("Received unexpected min version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
        Assertions.assertEquals((short)expectedApiVersion.maxVersion(), (short)actualApiVersion.maxVersion(), (String)new StringBuilder(45).append("Received unexpected max version for API key ").append(actualApiVersion.apiKey()).append(".").toString());
    }

    public AbstractApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
    }
}

