/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.server.AlterPartitionManager;
import kafka.server.AlterPartitionManagerTest$;
import kafka.server.BrokerToControllerChannelManager;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.DefaultAlterPartitionManager;
import kafka.server.ZkAlterPartitionManager;
import kafka.utils.MockTime;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.InvalidUpdateVersionException;
import org.apache.kafka.common.errors.OperationNotAttemptedException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.kafka.common.message.AlterPartitionResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AlterPartitionRequest;
import org.apache.kafka.common.requests.AlterPartitionResponse;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.LeaderRecoveryState;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r-e\u0001\u0002 @\u0001\u0011CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001C\u0002\u0013\u0005\u0001\u000b\u0003\u0004Z\u0001\u0001\u0006I!\u0015\u0005\b5\u0002\u0011\r\u0011\"\u0001\\\u0011\u00199\u0007\u0001)A\u00059\"9\u0001\u000e\u0001b\u0001\n\u0003I\u0007B\u00029\u0001A\u0003%!\u000eC\u0004r\u0001\t\u0007I\u0011\u0001:\t\ra\u0004\u0001\u0015!\u0003t\u0011\u001dI\bA1A\u0005\u0002iDaA \u0001!\u0002\u0013Y\bBC@\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0002!Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011AA\u0006\u0011-\t9\u0002\u0001a\u0001\u0002\u0003\u0006K!a\u0001\t\u0013\u0005e\u0001A1A\u0005\u0002\u0005m\u0001\u0002CA\u0012\u0001\u0001\u0006I!!\b\t\u0013\u0005\u0015\u0002A1A\u0005\u0002\u0005m\u0001\u0002CA\u0014\u0001\u0001\u0006I!!\b\t\u0013\u0005%\u0002A1A\u0005\u0002\u0005m\u0001\u0002CA\u0016\u0001\u0001\u0006I!!\b\t\u000f\u00055\u0002\u0001\"\u0001\u00020!9\u0011q\t\u0001\u0005\u0002\u0005%\u0003bBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003\u0017\u0003A\u0011AAG\u0011\u001d\tY\u000b\u0001C\u0001\u0003[Cq!a.\u0001\t\u0003\tI\fC\u0004\u0002D\u0002!\t!a\f\t\u000f\u00055\u0007\u0001\"\u0001\u00020!9\u0011\u0011\u001b\u0001\u0005\u0002\u0005=\u0002bBAk\u0001\u0011\u0005\u0011q\u0006\u0005\b\u00033\u0004A\u0011AA\u0018\u0011\u001d\ti\u000e\u0001C\u0001\u0003_Aq!!9\u0001\t\u0013\t\u0019\u000fC\u0004\u0002v\u0002!I!a>\t\u000f\t%\u0001\u0001\"\u0001\u00020!9!Q\u0002\u0001\u0005\u0002\u0005=\u0002b\u0002B\t\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0005+\u0001A\u0011AA\u0018\u0011\u001d\u0011I\u0002\u0001C\u0005\u00057AqAa\b\u0001\t\u0013\u0011\t\u0003C\u0004\u00030\u0001!\tA!\r\t\u000f\tm\u0002\u0001\"\u0001\u0003>!9!q\t\u0001\u0005\u0002\t%\u0003b\u0002B*\u0001\u0011%!Q\u000b\u0005\b\u00057\u0003A\u0011\u0002BO\u0011\u001d\u0011y\r\u0001C\u0005\u0005#DqAa8\u0001\t\u0013\u0011\t\u000fC\u0004\u0004\u000e\u0001!Iaa\u0004\t\u000f\r]\u0001\u0001\"\u0001\u00020!911\u0004\u0001\u0005\n\ru\u0001\"CB\u001d\u0001E\u0005I\u0011BB\u001e\u0011%\u0019\t\u0006AI\u0001\n\u0013\u0019\u0019\u0006C\u0005\u0004X\u0001\t\n\u0011\"\u0003\u0004Z!I1Q\f\u0001\u0012\u0002\u0013%1\u0011\f\u0005\n\u0007?\u0002\u0011\u0013!C\u0005\u00073B\u0011b!\u0019\u0001#\u0003%Iaa\u0019\b\u000f\r\u001dt\b#\u0001\u0004j\u00191ah\u0010E\u0001\u0007WBaa\u0013\u001e\u0005\u0002\r5\u0004bBA:u\u0011\u00051q\u000e\u0005\b\u0003OSD\u0011ABA\u0005e\tE\u000e^3s!\u0006\u0014H/\u001b;j_:l\u0015M\\1hKJ$Vm\u001d;\u000b\u0005\u0001\u000b\u0015AB:feZ,'OC\u0001C\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A#\u0011\u0005\u0019KU\"A$\u000b\u0003!\u000bQa]2bY\u0006L!AS$\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ\n\u0005\u0002O\u00015\tq(A\u0003u_BL7-F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0003mC:<'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013aa\u0015;sS:<\u0017A\u0002;pa&\u001c\u0007%A\u0004u_BL7-\u00133\u0016\u0003q\u0003\"!X3\u000e\u0003yS!a\u00181\u0002\r\r|W.\\8o\u0015\t\u0011\u0015M\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014_\u0005\u0011)V/\u001b3\u0002\u0011Q|\u0007/[2JI\u0002\nA\u0001^5nKV\t!\u000e\u0005\u0002l]6\tAN\u0003\u0002n\u0003\u0006)Q\u000f^5mg&\u0011q\u000e\u001c\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cX#A:\u0011\u0005Q4X\"A;\u000b\u0005Et\u0016BA<v\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\tEJ|7.\u001a:JIV\t1\u0010\u0005\u0002Gy&\u0011Qp\u0012\u0002\u0004\u0013:$\u0018!\u00032s_.,'/\u00133!\u0003I\u0011'o\\6feR{7i\u001c8ue>dG.\u001a:\u0016\u0005\u0005\r\u0001c\u0001(\u0002\u0006%\u0019\u0011qA \u0003A\t\u0013xn[3s)>\u001cuN\u001c;s_2dWM]\"iC:tW\r\\'b]\u0006<WM]\u0001\u0017EJ|7.\u001a:U_\u000e{g\u000e\u001e:pY2,'o\u0018\u0013fcR!\u0011QBA\n!\r1\u0015qB\u0005\u0004\u0003#9%\u0001B+oSRD\u0011\"!\u0006\u000e\u0003\u0003\u0005\r!a\u0001\u0002\u0007a$\u0013'A\nce>\\WM\u001d+p\u0007>tGO]8mY\u0016\u0014\b%A\u0002uaB*\"!!\b\u0011\u0007u\u000by\"C\u0002\u0002\"y\u0013\u0001\u0003V8qS\u000eLE\rU1si&$\u0018n\u001c8\u0002\tQ\u0004\b\u0007I\u0001\u0004iB\f\u0014\u0001\u0002;qc\u0001\n1\u0001\u001e93\u0003\u0011!\bO\r\u0011\u0002\u000bM,G/\u001e9\u0015\u0005\u00055\u0001fA\u000b\u00024A!\u0011QGA\"\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012aA1qS*!\u0011QHA \u0003\u001dQW\u000f]5uKJT1!!\u0011d\u0003\u0015QWO\\5u\u0013\u0011\t)%a\u000e\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.A\u0005uKN$()Y:jGR!\u0011QBA&\u0011\u001d\tiE\u0006a\u0001\u0003\u001f\nq\"\\3uC\u0012\fG/\u0019,feNLwN\u001c\t\u0005\u0003#\n9&\u0004\u0002\u0002T)\u0019q,!\u0016\u000b\u0005\u0001\u0003\u0017\u0002BA-\u0003'\u0012q\"T3uC\u0012\fG/\u0019,feNLwN\u001c\u0015\b-\u0005u\u0013QNA8!\u0011\ty&!\u001b\u000e\u0005\u0005\u0005$\u0002BA2\u0003K\n\u0001\u0002\u001d:pm&$WM\u001d\u0006\u0005\u0003O\nY$\u0001\u0004qCJ\fWn]\u0005\u0005\u0003W\n\tG\u0001\u0007NKRDw\u000eZ*pkJ\u001cW-A\u0003wC2,X\r\f\u0002\u0002r\u0005\u0012\u00111O\u0001\u0018aJ|g/\u001b3f\u001b\u0016$\u0018\rZ1uCZ+'o]5p]ND3AFA<!\u0011\tI(a\u001f\u000e\u0005\u0005\u0015\u0014\u0002BA?\u0003K\u0012\u0011\u0003U1sC6,G/\u001a:ju\u0016$G+Z:u\u0003a!Xm\u001d;CCNL7mV5uQ\n\u0013xn[3s\u000bB|7\r\u001b\u000b\u0005\u0003\u001b\t\u0019\tC\u0004\u0002N]\u0001\r!a\u0014)\u000f]\ti&!\u001c\u0002\b2\u0012\u0011\u0011\u000f\u0015\u0004/\u0005]\u0014\u0001\t;fgR\u0014\u0015m]5d'\u0016tG\u000fT3bI\u0016\u0014(+Z2pm\u0016\u0014\u0018p\u0015;bi\u0016$b!!\u0004\u0002\u0010\u0006E\u0005bBA'1\u0001\u0007\u0011q\n\u0005\b\u0003'C\u0002\u0019AAK\u0003MaW-\u00193feJ+7m\u001c<fef\u001cF/\u0019;f!\u0011\t9*!(\u000e\u0005\u0005e%bAANA\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002 \u0006e%a\u0005'fC\u0012,'OU3d_Z,'/_*uCR,\u0007f\u0002\r\u0002^\u00055\u00141\u0015\u0017\u0003\u0003K\u000b#!a*\u00025A\u0014xN^5eK2+\u0017\rZ3s%\u0016\u001cwN^3ssN#\u0018\r^3)\u0007a\t9(\u0001\ruKN$xJ^3soJLG/Z,ji\"LgNQ1uG\"$B!!\u0004\u00020\"9\u0011QJ\rA\u0002\u0005=\u0003fB\r\u0002^\u00055\u00141\u0017\u0017\u0003\u0003cB3!GA<\u0003=!Xm\u001d;TS:<G.\u001a\"bi\u000eDG\u0003BA\u0007\u0003wCq!!\u0014\u001b\u0001\u0004\ty\u0005K\u0004\u001b\u0003;\ni'a0-\u0005\u0005E\u0004f\u0001\u000e\u0002x\u00051B/Z:u'V\u0014W.\u001b;Ge>l7)\u00197mE\u0006\u001c7\u000eK\u0002\u001c\u0003\u000f\u0004B!!\u000e\u0002J&!\u00111ZA\u001c\u0005\u0011!Vm\u001d;\u0002/Q,7\u000f^!vi\"|'/\u001b>bi&|gNR1jY\u0016$\u0007f\u0001\u000f\u0002H\u0006!B/Z:u'R\fG.\u001a\"s_.,'/\u00129pG\"D3!HAd\u0003E!Xm\u001d;V].twn\u001e8TKJ4XM\u001d\u0015\u0004=\u0005\u001d\u0017\u0001\t;fgR\u0014V\r\u001e:z\u001f:\fU\u000f\u001e5f]RL7-\u0019;j_:4\u0015-\u001b7ve\u0016D3aHAd\u0003\t\"Xm\u001d;SKR\u0014\u0018p\u00148V]N,\b\u000f]8si\u0016$g+\u001a:tS>tWI\u001d:pe\"\u001a\u0001%a2\u00021Q,7\u000f\u001e*fiJLxJ\u001c+pa2+g/\u001a7FeJ|'\u000f\u0006\u0003\u0002\u000e\u0005\u0015\bbBAtC\u0001\u0007\u0011\u0011^\u0001\u0006KJ\u0014xN\u001d\t\u0005\u0003W\f\t0\u0004\u0002\u0002n*\u0019\u0011q\u001e0\u0002\u0011A\u0014x\u000e^8d_2LA!a=\u0002n\n1QI\u001d:peN\f\u0001\u0004^3tiJ+GO]=P]\u0016\u0013(o\u001c:SKN\u0004xN\\:f)\u0011\ti!!?\t\u000f\u0005m(\u00051\u0001\u0002~\u0006A!/Z:q_:\u001cX\r\u0005\u0003\u0002\u0000\n\u0015QB\u0001B\u0001\u0015\r\u0011\u0019\u0001Y\u0001\bG2LWM\u001c;t\u0013\u0011\u00119A!\u0001\u0003\u001d\rc\u0017.\u001a8u%\u0016\u001c\bo\u001c8tK\u0006AB/Z:u\u0013:4\u0018\r\\5e+B$\u0017\r^3WKJ\u001c\u0018n\u001c8)\u0007\r\n9-A\ruKN$XK\\6o_^tGk\u001c9jGB\u000b'\u000f^5uS>t\u0007f\u0001\u0013\u0002H\u00069B/Z:u\u001d>$H*Z1eKJ|%OR8mY><XM\u001d\u0015\u0004K\u0005\u001d\u0017A\u0005;fgRLeN^1mS\u0012\u0014V-];fgRD3AJAd\u0003M\u0019\u0007.Z2l!\u0006\u0014H/\u001b;j_:,%O]8s)\u0011\tiA!\b\t\u000f\u0005\u001dx\u00051\u0001\u0002j\u0006\u0011B/Z:u!\u0006\u0014H/\u001b;j_:,%O]8s)\u0019\u0011\u0019C!\u000b\u0003.A\u0019aJ!\n\n\u0007\t\u001drHA\u000bBYR,'\u000fU1si&$\u0018n\u001c8NC:\fw-\u001a:\t\u000f\t-\u0002\u00061\u0001\u0002\u001e\u0005\u0011A\u000f\u001d\u0005\b\u0003OD\u0003\u0019AAu\u0003=!Xm\u001d;P]\u0016LeN\u00127jO\"$H\u0003BA\u0007\u0005gAq!!\u0014*\u0001\u0004\ty\u0005K\u0004*\u0003;\niGa\u000e-\u0005\u0005E\u0004fA\u0015\u0002x\u0005qB/Z:u!\u0006\u0014H/\u001b;j_:l\u0015n]:j]\u001eLeNU3ta>t7/\u001a\u000b\u0005\u0003\u001b\u0011y\u0004C\u0004\u0002N)\u0002\r!a\u0014)\u000f)\ni&!\u001c\u0003D1\u0012\u0011\u0011\u000f\u0015\u0004U\u0005]\u0014a\u0005;fgR\u0004\u0016M\u001d;jC2$v\u000e]5d\u0013\u0012\u001cH\u0003BA\u0007\u0005\u0017Bq!!\u0014,\u0001\u0004\ty\u0005K\u0004,\u0003;\niGa\u0014-\u0005\u0005E\u0004fA\u0016\u0002x\u0005\tb/\u001a:jMf\u001cVM\u001c3SKF,Xm\u001d;\u0015\r\t]#Q\fB0!\rq%\u0011L\u0005\u0004\u00057z$AI\"p]R\u0014x\u000e\u001c7feJ+\u0017/^3ti\u000e{W\u000e\u001d7fi&|g\u000eS1oI2,'\u000f\u0003\u0004\u0000Y\u0001\u0007\u00111\u0001\u0005\b\u0005Cb\u0003\u0019\u0001B2\u0003=)\u0007\u0010]3di\u0016$'+Z9vKN$\bC\u0002B3\u0005W\u0012y'\u0004\u0002\u0003h)\u0019!\u0011N2\u0002\u000f5|7m[5u_&!!Q\u000eB4\u0005=\t%oZ;nK:$X*\u0019;dQ\u0016\u0014\b\u0007\u0002B9\u0005\u0013\u0003bAa\u001d\u0003\u0000\t\u0015e\u0002\u0002B;\u0005wj!Aa\u001e\u000b\u0007\ted,\u0001\u0005sKF,Xm\u001d;t\u0013\u0011\u0011iHa\u001e\u0002\u001f\u0005\u00137\u000f\u001e:bGR\u0014V-];fgRLAA!!\u0003\u0004\n9!)^5mI\u0016\u0014(\u0002\u0002B?\u0005o\u0002BAa\"\u0003\n2\u0001A\u0001\u0004BF\u0005?\n\t\u0011!A\u0003\u0002\t5%aA0%eE!!q\u0012BK!\r1%\u0011S\u0005\u0004\u0005';%a\u0002(pi\"Lgn\u001a\t\u0005\u0005k\u00129*\u0003\u0003\u0003\u001a\n]$aD!cgR\u0014\u0018m\u0019;SKF,Xm\u001d;\u00029\u0005dG/\u001a:QCJ$\u0018\u000e^5p]J+\u0017/^3ti6\u000bGo\u00195feR1!q\u0014BV\u0005\u000b\u0004bA!\u001a\u0003l\t\u0005\u0006\u0007\u0002BR\u0005O\u0003bAa\u001d\u0003\u0000\t\u0015\u0006\u0003\u0002BD\u0005O#1B!+.\u0003\u0003\u0005\tQ!\u0001\u0003\u000e\n\u0019q\fJ\u001a\t\u000f\t5V\u00061\u0001\u00030\u00069R\r\u001f9fGR,G\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\t\u0007\u0005c\u0013y,!\b\u000f\t\tM&1\u0018\t\u0004\u0005k;UB\u0001B\\\u0015\r\u0011IlQ\u0001\u0007yI|w\u000e\u001e \n\u0007\tuv)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0005\u0003\u0014\u0019MA\u0002TKRT1A!0H\u0011\u001d\u00119-\fa\u0001\u0005\u0013\fq\"\u001a=qK\u000e$X\r\u001a,feNLwN\u001c\t\u0004\r\n-\u0017b\u0001Bg\u000f\n)1\u000b[8si\u0006\u0011R.Y6f\u00072LWM\u001c;SKN\u0004xN\\:f)\u0019\tiPa5\u0003\\\"9\u00111 \u0018A\u0002\tU\u0007\u0003\u0002B;\u0005/LAA!7\u0003x\t1\u0012\t\u001c;feB\u000b'\u000f^5uS>t'+Z:q_:\u001cX\rC\u0004\u0003^:\u0002\rA!3\u0002\u000fY,'o]5p]\u0006\u0011R.Y6f\u00032$XM\u001d)beRLG/[8o)\u0011\u0011)Na9\t\u000f\t\u0015x\u00061\u0001\u0003h\u00061Ao\u001c9jGN\u0004bA!;\u0003t\neh\u0002\u0002Bv\u0005_tAA!.\u0003n&\t\u0001*C\u0002\u0003r\u001e\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0003v\n](aA*fc*\u0019!\u0011_$\u0011\t\tm8q\u0001\b\u0005\u0005{\u001c\u0019!\u0004\u0002\u0003\u0000*\u00191\u0011\u00010\u0002\u000f5,7o]1hK&!1Q\u0001B\u0000\u0003i\tE\u000e^3s!\u0006\u0014H/\u001b;j_:\u0014Vm\u001d9p]N,G)\u0019;b\u0013\u0011\u0019Iaa\u0003\u0003\u0013Q{\u0007/[2ECR\f'\u0002BB\u0003\u0005\u007f\f1$\\1lK\u0006cG/\u001a:QCJ$\u0018\u000e^5p]R{\u0007/[2ECR\fGC\u0002B}\u0007#\u0019)\u0002C\u0004\u0004\u0014A\u0002\r!!\b\u0002!Q|\u0007/[2JIB\u000b'\u000f^5uS>t\u0007bBAta\u0001\u0007\u0011\u0011^\u0001\fi\u0016\u001cHOW6CCNL7\rK\u00022\u0003\u000f\f\u0011\u0003]1si&$\u0018n\u001c8SKN\u0004xN\\:f)9\u0011)na\b\u0004\"\r\r2qEB\u0016\u0007_A\u0011Ba\u000b3!\u0003\u0005\r!!\b\t\u0013\u0005\u001d(\u0007%AA\u0002\u0005%\b\u0002CB\u0013eA\u0005\t\u0019A>\u0002\u001dA\f'\u000f^5uS>tW\t]8dQ\"A1\u0011\u0006\u001a\u0011\u0002\u0003\u000710\u0001\u0005mK\u0006$WM]%e\u0011!\u0019iC\rI\u0001\u0002\u0004Y\u0018a\u00037fC\u0012,'/\u00129pG\"D\u0011b!\r3!\u0003\u0005\raa\r\u0002\u0007%\u001c(\u000fE\u0003\u0003j\u000eU20\u0003\u0003\u00048\t](\u0001\u0002'jgR\f1\u0004]1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\nTCAB\u001fU\u0011\tiba\u0010,\u0005\r\u0005\u0003\u0003BB\"\u0007\u001bj!a!\u0012\u000b\t\r\u001d3\u0011J\u0001\nk:\u001c\u0007.Z2lK\u0012T1aa\u0013H\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u001f\u001a)EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004]1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\u0012TCAB+U\u0011\tIoa\u0010\u00027A\f'\u000f^5uS>t'+Z:q_:\u001cX\r\n3fM\u0006,H\u000e\u001e\u00134+\t\u0019YFK\u0002|\u0007\u007f\t1\u0004]1si&$\u0018n\u001c8SKN\u0004xN\\:fI\u0011,g-Y;mi\u0012\"\u0014a\u00079beRLG/[8o%\u0016\u001c\bo\u001c8tK\u0012\"WMZ1vYR$S'A\u000eqCJ$\u0018\u000e^5p]J+7\u000f]8og\u0016$C-\u001a4bk2$HEN\u000b\u0003\u0007KRCaa\r\u0004@\u0005I\u0012\t\u001c;feB\u000b'\u000f^5uS>tW*\u00198bO\u0016\u0014H+Z:u!\tq%h\u0005\u0002;\u000bR\u00111\u0011\u000e\u000b\u0003\u0007c\u0002baa\u001d\u0004~\u0005=SBAB;\u0015\u0011\u00199h!\u001f\u0002\rM$(/Z1n\u0015\r\u0019Y(V\u0001\u0005kRLG.\u0003\u0003\u0004\u0000\rU$AB*ue\u0016\fW\u000e\u0006\u0002\u0004\u0004B111OB?\u0007\u000b\u0003B!a\u0018\u0004\b&!1\u0011RA1\u0005%\t%oZ;nK:$8\u000f")
public class AlterPartitionManagerTest {
    private final String topic;
    private final Uuid topicId = Uuid.randomUuid();
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final int brokerId;
    private BrokerToControllerChannelManager brokerToController;
    private final TopicIdPartition tp0 = new TopicIdPartition(this.topicId(), 0, this.topic());
    private final TopicIdPartition tp1 = new TopicIdPartition(this.topicId(), 1, this.topic());
    private final TopicIdPartition tp2 = new TopicIdPartition(this.topicId(), 2, this.topic());

    public static Stream<Arguments> provideLeaderRecoveryState() {
        return AlterPartitionManagerTest$.MODULE$.provideLeaderRecoveryState();
    }

    public static Stream<MetadataVersion> provideMetadataVersions() {
        return AlterPartitionManagerTest$.MODULE$.provideMetadataVersions();
    }

    public String topic() {
        return this.topic;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public BrokerToControllerChannelManager brokerToController() {
        return this.brokerToController;
    }

    public void brokerToController_$eq(BrokerToControllerChannelManager x$1) {
        this.brokerToController = x$1;
    }

    public TopicIdPartition tp0() {
        return this.tp0;
    }

    public TopicIdPartition tp1() {
        return this.tp1;
    }

    public TopicIdPartition tp2() {
        return this.tp2;
    }

    @BeforeEach
    public void setup() {
        this.brokerToController_$eq((BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class));
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasic(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testBasicWithBrokerEpoch(MetadataVersion metadataVersion) {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 101L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        ListBuffer isrWithBrokerEpoch = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).foreach((Function1 & Serializable & scala.Serializable)ii -> isrWithBrokerEpoch.$plus$eq((Object)new AlterPartitionRequestData.BrokerState().setBrokerId(BoxesRunTime.unboxToInt((Object)ii)).setBrokerEpoch((long)(100 + BoxesRunTime.unboxToInt((Object)ii)))));
        alterPartitionManager.submit(this.tp0(), new LeaderAndIsr(1, 1, LeaderRecoveryState.RECOVERED, isrWithBrokerEpoch.toList(), 10), 0);
        AlterPartitionRequestData expectedAlterPartitionData = new AlterPartitionRequestData().setBrokerId(this.brokerId()).setBrokerEpoch(101L);
        AlterPartitionRequestData.TopicData topicData = new AlterPartitionRequestData.TopicData().setTopicName(this.topic()).setTopicId(this.topicId());
        if (metadataVersion.isTopicIdsSupported()) {
            ListBuffer newIsrWithBrokerEpoch = new ListBuffer();
            newIsrWithBrokerEpoch.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterPartitionRequestData.BrokerState[]{new AlterPartitionRequestData.BrokerState().setBrokerId(1).setBrokerEpoch(101L)}));
            newIsrWithBrokerEpoch.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterPartitionRequestData.BrokerState[]{new AlterPartitionRequestData.BrokerState().setBrokerId(2).setBrokerEpoch(102L)}));
            newIsrWithBrokerEpoch.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AlterPartitionRequestData.BrokerState[]{new AlterPartitionRequestData.BrokerState().setBrokerId(3).setBrokerEpoch(103L)}));
            topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsrWithEpochs((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)newIsrWithBrokerEpoch.toList()).asJava()));
        } else {
            topicData.partitions().add(new AlterPartitionRequestData.PartitionData().setPartitionIndex(0).setLeaderEpoch(1).setPartitionEpoch(10).setNewIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()));
        }
        expectedAlterPartitionData.topics().add(topicData);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ArgumentCaptor captor = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)captor.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        Assertions.assertEquals((Object)expectedAlterPartitionData, (Object)((AlterPartitionRequest)((AlterPartitionRequest.Builder)captor.getValue()).build()).data());
    }

    @ParameterizedTest
    @MethodSource(value={"provideLeaderRecoveryState"})
    public void testBasicSentLeaderRecoveryState(MetadataVersion metadataVersion, LeaderRecoveryState leaderRecoveryState) {
        ArgumentCaptor requestCapture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), leaderRecoveryState, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)requestCapture.capture(), (ControllerRequestCompletionHandler)ArgumentMatchers.any());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)requestCapture.getValue()).build();
        Assertions.assertEquals((byte)(metadataVersion.isAtLeast(MetadataVersion.IBP_3_2_IV0) ? leaderRecoveryState : LeaderRecoveryState.RECOVERED).value(), (byte)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).leaderRecoveryState());
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOverwriteWithinBatch(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        CompletableFuture failedSubmitFuture = alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), LeaderRecoveryState.RECOVERED, 10), 0);
        Assertions.assertTrue((boolean)failedSubmitFuture.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)failedSubmitFuture, OperationNotAttemptedException.class);
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(this.partitionResponse$default$1(), this.partitionResponse$default$2(), this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertFalse((boolean)alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        if (request.version() < 3) {
            Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsr().size(), (int)1);
            return;
        }
        Assertions.assertEquals((int)((AlterPartitionRequestData.PartitionData)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().get(0)).newIsrWithEpochs().size(), (int)1);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testSingleBatch(MetadataVersion metadataVersion) {
        ArgumentCaptor capture = ArgumentCaptor.forClass(AbstractRequest.Builder.class);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(new TopicIdPartition(this.topicId(), 0, this.topic()), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 9).foreach((Function1 & Serializable & scala.Serializable)i -> alterPartitionManager.submit(new TopicIdPartition(this.topicId(), BoxesRunTime.unboxToInt((Object)i), this.topic()), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0));
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = new ClientResponse(null, null, "", 0L, 0L, false, null, null, (AbstractResponse)alterPartitionResp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController(), (VerificationMode)Mockito.times((int)2))).sendRequest((AbstractRequest.Builder)capture.capture(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        AlterPartitionRequest request = (AlterPartitionRequest)((AbstractRequest.Builder)capture.getValue()).build();
        Assertions.assertEquals((int)request.data().topics().size(), (int)1);
        Assertions.assertEquals((int)((AlterPartitionRequestData.TopicData)request.data().topics().get(0)).partitions().size(), (int)10);
    }

    @Test
    public void testSubmitFromCallback() {
        AlterPartitionResponse alterPartitionRespWithPartitionError = this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse errorResponse = this.makeClientResponse(alterPartitionRespWithPartitionError, ApiKeys.ALTER_PARTITION.latestVersion());
        int leaderId = 1;
        int leaderEpoch = 1;
        int partitionEpoch = 10;
        List isr = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3}));
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(leaderId, leaderEpoch, isr, LeaderRecoveryState.RECOVERED, partitionEpoch);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0);
        CompletableFuture finalFuture = new CompletableFuture();
        future.whenComplete((x$1, e2) -> {
            if (e2 != null) {
                alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0).whenComplete((result, e) -> {
                    if (e != null) {
                        finalFuture.completeExceptionally((Throwable)e);
                        return;
                    }
                    finalFuture.complete(result);
                });
                return;
            }
            finalFuture.completeExceptionally((Throwable)((Object)new AssertionError((Object)"Expected the future to be failed")));
        });
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(errorResponse);
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.tp0(), Errors.NONE, partitionEpoch, leaderId, leaderEpoch, (List<Object>)isr);
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertEquals((Object)leaderAndIsr, finalFuture.get(200L, TimeUnit.MILLISECONDS));
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testAuthorizationFailed() {
        this.testRetryOnTopLevelError(Errors.CLUSTER_AUTHORIZATION_FAILED);
    }

    @Test
    public void testStaleBrokerEpoch() {
        this.testRetryOnTopLevelError(Errors.STALE_BROKER_EPOCH);
    }

    @Test
    public void testUnknownServer() {
        this.testRetryOnTopLevelError(Errors.UNKNOWN_SERVER_ERROR);
    }

    @Test
    public void testRetryOnAuthenticationFailure() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, null, new AuthenticationException("authentication failed"), null));
    }

    @Test
    public void testRetryOnUnsupportedVersionError() {
        this.testRetryOnErrorResponse(new ClientResponse(null, null, "", 0L, 0L, false, new UnsupportedVersionException("unsupported version"), null, null));
    }

    private void testRetryOnTopLevelError(Errors error) {
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData().setErrorCode(error.code()));
        ClientResponse response = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        this.testRetryOnErrorResponse(response);
    }

    private void testRetryOnErrorResponse(ClientResponse response) {
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), leaderAndIsr, 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(response);
        Assertions.assertTrue((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        this.time().sleep(100L);
        scheduler.tick();
        AlterPartitionResponse retryAlterPartitionResponse = this.partitionResponse(this.partitionResponse$default$1(), this.partitionResponse$default$2(), this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse retryResponse = this.makeClientResponse(retryAlterPartitionResponse, ApiKeys.ALTER_PARTITION.latestVersion());
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(retryResponse);
        Assertions.assertFalse((boolean)alterPartitionManager.unsentIsrUpdates().containsKey(this.tp0().topicPartition()));
    }

    @Test
    public void testInvalidUpdateVersion() {
        this.checkPartitionError(Errors.INVALID_UPDATE_VERSION);
    }

    @Test
    public void testUnknownTopicPartition() {
        this.checkPartitionError(Errors.UNKNOWN_TOPIC_OR_PARTITION);
    }

    @Test
    public void testNotLeaderOrFollower() {
        this.checkPartitionError(Errors.NOT_LEADER_OR_FOLLOWER);
    }

    @Test
    public void testInvalidRequest() {
        this.checkPartitionError(Errors.INVALID_REQUEST);
    }

    private void checkPartitionError(Errors error) {
        Assertions.assertFalse((boolean)this.testPartitionError(this.tp0(), error).submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0).isDone());
    }

    private AlterPartitionManager testPartitionError(TopicIdPartition tp, Errors error) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> MetadataVersion.IBP_3_2_IV0);
        alterPartitionManager.start();
        CompletableFuture future = alterPartitionManager.submit(tp, LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = this.partitionResponse(tp, error, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
        Assertions.assertTrue((boolean)future.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future, (Class)error.exception().getClass());
        return alterPartitionManager;
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testOneInFlight(MetadataVersion metadataVersion) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(this.brokerToController(), (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 2L, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        alterPartitionManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterPartitionManager.submit(this.tp1(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        alterPartitionManager.submit(this.tp2(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10), 0);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).start();
        ((BrokerToControllerChannelManager)Mockito.verify((Object)this.brokerToController())).sendRequest((AbstractRequest.Builder)ArgumentMatchers.any(), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{this.brokerToController()});
        AlterPartitionResponse alterPartitionResp = new AlterPartitionResponse(new AlterPartitionResponseData());
        ClientResponse resp = this.makeClientResponse(alterPartitionResp, ApiKeys.ALTER_PARTITION.latestVersion());
        ((RequestCompletionHandler)callbackCapture.getValue()).onComplete(resp);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartitionMissingInResponse(MetadataVersion metadataVersion) {
        short expectedVersion = metadataVersion.isTopicIdsSupported() ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1;
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> brokerEpoch, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(this.tp0(), leaderAndIsr, controlledEpoch);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp0()}))), expectedVersion));
        CompletableFuture future2 = alterPartitionManager.submit(this.tp1(), leaderAndIsr, controlledEpoch);
        CompletableFuture future3 = alterPartitionManager.submit(this.tp2(), leaderAndIsr, controlledEpoch);
        callback1.onComplete(this.makeClientResponse(this.partitionResponse(this.tp0(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future1, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1(), this.tp2()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp2(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future3, UnknownServerException.class);
        Assertions.assertFalse((boolean)future2.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{this.tp1()}))), expectedVersion)).onComplete(this.makeClientResponse(this.partitionResponse(this.tp1(), Errors.UNKNOWN_SERVER_ERROR, this.partitionResponse$default$3(), this.partitionResponse$default$4(), this.partitionResponse$default$5(), this.partitionResponse$default$6()), expectedVersion));
        TestUtils.assertFutureThrows((Future)future2, UnknownServerException.class);
    }

    @ParameterizedTest
    @MethodSource(value={"provideMetadataVersions"})
    public void testPartialTopicIds(MetadataVersion metadataVersion) {
        boolean canUseTopicIds = metadataVersion.isAtLeast(MetadataVersion.IBP_2_8_IV0);
        TopicIdPartition foo = new TopicIdPartition(Uuid.ZERO_UUID, 0, "foo");
        TopicIdPartition bar = new TopicIdPartition(Uuid.randomUuid(), 0, "bar");
        TopicIdPartition zar = new TopicIdPartition(Uuid.randomUuid(), 0, "zar");
        LeaderAndIsr leaderAndIsr = LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 10);
        int controlledEpoch = 0;
        int brokerEpoch = 2;
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        BrokerToControllerChannelManager brokerToController = (BrokerToControllerChannelManager)Mockito.mock(BrokerToControllerChannelManager.class);
        DefaultAlterPartitionManager alterPartitionManager = new DefaultAlterPartitionManager(brokerToController, (Scheduler)scheduler, (Time)this.time(), this.brokerId(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> brokerEpoch, (Function0 & Serializable & scala.Serializable)() -> metadataVersion);
        alterPartitionManager.start();
        CompletableFuture future1 = alterPartitionManager.submit(zar, leaderAndIsr, controlledEpoch);
        ControllerRequestCompletionHandler callback1 = this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{zar}))), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        CompletableFuture future2 = alterPartitionManager.submit(foo, leaderAndIsr, controlledEpoch);
        CompletableFuture future3 = alterPartitionManager.submit(bar, leaderAndIsr, controlledEpoch);
        callback1.onComplete(this.makeClientResponse(this.makeAlterPartition((Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(zar, Errors.NONE), (List)Nil$.MODULE$)), canUseTopicIds ? ApiKeys.ALTER_PARTITION.latestVersion() : (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertFalse((boolean)future2.isDone());
        Assertions.assertFalse((boolean)future3.isDone());
        this.verifySendRequest(brokerToController, this.alterPartitionRequestMatcher((Set<TopicIdPartition>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicIdPartition[]{foo, bar}))), (short)1)).onComplete(this.makeClientResponse(this.makeAlterPartition((Seq<AlterPartitionResponseData.TopicData>)new .colon.colon((Object)this.makeAlterPartitionTopicData(foo, Errors.NONE), (List)new .colon.colon((Object)this.makeAlterPartitionTopicData(bar, Errors.NONE), (List)Nil$.MODULE$))), (short)1));
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertTrue((boolean)future2.isDone());
        Assertions.assertTrue((boolean)future3.isDone());
    }

    private ControllerRequestCompletionHandler verifySendRequest(BrokerToControllerChannelManager brokerToController, ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> expectedRequest) {
        ArgumentCaptor callbackCapture = ArgumentCaptor.forClass(ControllerRequestCompletionHandler.class);
        ((BrokerToControllerChannelManager)Mockito.verify((Object)brokerToController)).sendRequest((AbstractRequest.Builder)ArgumentMatchers.argThat(expectedRequest), (ControllerRequestCompletionHandler)callbackCapture.capture());
        Mockito.reset((Object[])new BrokerToControllerChannelManager[]{brokerToController});
        return (ControllerRequestCompletionHandler)callbackCapture.getValue();
    }

    private ArgumentMatcher<AbstractRequest.Builder<? extends AbstractRequest>> alterPartitionRequestMatcher(Set<TopicIdPartition> expectedTopicPartitions, short expectedVersion) {
        return request -> {
            Assertions.assertEquals((Object)ApiKeys.ALTER_PARTITION, (Object)request.apiKey());
            AlterPartitionRequest alterPartitionRequest = (AlterPartitionRequest)((AlterPartitionRequest.Builder)request).build();
            Assertions.assertEquals((short)expectedVersion, (short)alterPartitionRequest.version());
            Set requestTopicPartitions = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(alterPartitionRequest.data().topics()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)topicData -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicData.partitions()).asScala()).map((Function1 & Serializable & scala.Serializable)partitionData -> new TopicIdPartition(topicData.topicId(), partitionData.partitionIndex(), topicData.topicName()), Buffer$.MODULE$.canBuildFrom()), Buffer$.MODULE$.canBuildFrom())).toSet();
            Set set = expectedTopicPartitions;
            return !(set != null ? !set.equals(requestTopicPartitions) : requestTopicPartitions != null);
        };
    }

    private ClientResponse makeClientResponse(AlterPartitionResponse response, short version) {
        return new ClientResponse(new RequestHeader(response.apiKey(), version, "", 0), null, "", 0L, 0L, false, null, null, (AbstractResponse)AlterPartitionResponse.parse((ByteBuffer)MessageUtil.toByteBuffer((Message)response.data(), (short)version), (short)version));
    }

    private AlterPartitionResponse makeAlterPartition(Seq<AlterPartitionResponseData.TopicData> topics) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(topics).asJava()));
    }

    private AlterPartitionResponseData.TopicData makeAlterPartitionTopicData(TopicIdPartition topicIdPartition, Errors error) {
        return new AlterPartitionResponseData.TopicData().setTopicName(topicIdPartition.topic()).setTopicId(topicIdPartition.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(topicIdPartition.partition()).setErrorCode(error.code())));
    }

    @Test
    public void testZkBasic() {
        MockScheduler scheduler = new MockScheduler((Time)this.time());
        scheduler.startup();
        KafkaZkClient kafkaZkClient = (KafkaZkClient)Mockito.mock(KafkaZkClient.class);
        ((KafkaZkClient)Mockito.doAnswer(x$2 -> new Tuple2.mcZI.sp(true, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)1), (Option)ArgumentMatchers.any());
        ((KafkaZkClient)Mockito.doAnswer(x$3 -> new Tuple2.mcZI.sp(false, 2)).when((Object)kafkaZkClient)).conditionalUpdatePath(ArgumentMatchers.anyString(), (byte[])ArgumentMatchers.any(), ArgumentMatchers.eq((int)3), (Option)ArgumentMatchers.any());
        ZkAlterPartitionManager zkIsrManager = new ZkAlterPartitionManager((Scheduler)scheduler, (Time)this.time(), kafkaZkClient);
        zkIsrManager.start();
        CompletableFuture future1 = zkIsrManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 1), 0);
        Assertions.assertTrue((boolean)future1.isDone());
        Assertions.assertEquals((Object)LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 2), future1.get());
        CompletableFuture future2 = zkIsrManager.submit(this.tp0(), LeaderAndIsr$.MODULE$.apply(1, 1, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), LeaderRecoveryState.RECOVERED, 3), 0);
        Assertions.assertTrue((boolean)future2.isCompletedExceptionally());
        TestUtils.assertFutureThrows((Future)future2, InvalidUpdateVersionException.class);
    }

    private AlterPartitionResponse partitionResponse(TopicIdPartition tp, Errors error, int partitionEpoch, int leaderId, int leaderEpoch, List<Object> isr) {
        return new AlterPartitionResponse(new AlterPartitionResponseData().setTopics(Collections.singletonList(new AlterPartitionResponseData.TopicData().setTopicName(tp.topic()).setTopicId(tp.topicId()).setPartitions(Collections.singletonList(new AlterPartitionResponseData.PartitionData().setPartitionIndex(tp.partition()).setPartitionEpoch(partitionEpoch).setLeaderEpoch(leaderEpoch).setLeaderId(leaderId).setIsr((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)isr.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.unboxToInt((Object)x$1), List$.MODULE$.canBuildFrom())).asJava()).setErrorCode(error.code()))))));
    }

    private TopicIdPartition partitionResponse$default$1() {
        return this.tp0();
    }

    private Errors partitionResponse$default$2() {
        return Errors.NONE;
    }

    private int partitionResponse$default$3() {
        return 0;
    }

    private int partitionResponse$default$4() {
        return 0;
    }

    private int partitionResponse$default$5() {
        return 0;
    }

    private List<Object> partitionResponse$default$6() {
        return List$.MODULE$.empty();
    }

    public AlterPartitionManagerTest() {
        this.topic = "test-topic";
        this.brokerId = 1;
    }
}

