/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractApiVersionsRequestTest;
import kafka.test.ClusterConfig;
import kafka.test.ClusterInstance;
import kafka.test.annotation.ClusterConfigProperty;
import kafka.test.annotation.ClusterTest;
import kafka.test.annotation.ClusterTestDefaults;
import kafka.test.annotation.Type;
import kafka.test.junit.ClusterTestExtensions;
import org.apache.kafka.common.message.ApiVersionsRequestData;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiVersionsRequest;
import org.apache.kafka.common.requests.ApiVersionsResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import scala.reflect.ScalaSignature;

@ExtendWith(value={ClusterTestExtensions.class})
@ClusterTestDefaults(clusterType=Type.ALL, brokers=1)
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001B\u0007\u000f\u0001MA\u0001\u0002\u0007\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\u0006?\u0001!\t\u0001\t\u0005\u0006G\u0001!\t\u0001\n\u0005\u0006{\u0001!\tA\u0010\u0005\u0006\r\u0002!\tA\u0010\u0005\u0006)\u0002!\tA\u0010\u0005\u00069\u0002!\tA\u0010\u0005\u0006C\u0002!\tA\u0010\u0005\u0006G\u0002!\tA\u0010\u0005\u0006K\u0002!\tA\u0010\u0005\u0006O\u0002!\tA\u0010\u0005\u0006S\u0002!\tA\u0010\u0002\u0017\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cH\u000fV3ti*\u0011q\u0002E\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003E\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u001d%\u0011qC\u0004\u0002\u001f\u0003\n\u001cHO]1di\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e+fgR\fqa\u00197vgR,'\u000f\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d!\u0005!A/Z:u\u0013\tq2DA\bDYV\u001cH/\u001a:J]N$\u0018M\\2f\u0003\u0019a\u0014N\\5u}Q\u0011\u0011E\t\t\u0003+\u0001AQ\u0001\u0007\u0002A\u0002e\tQa]3ukB$\"!J\u0016\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006Y\r\u0001\r!L\u0001\u0007G>tg-[4\u0011\u0005iq\u0013BA\u0018\u001c\u00055\u0019E.^:uKJ\u001cuN\u001c4jO\"\u00121!\r\t\u0003emj\u0011a\r\u0006\u0003iU\n1!\u00199j\u0015\t1t'A\u0004kkBLG/\u001a:\u000b\u0005aJ\u0014!\u00026v]&$(\"\u0001\u001e\u0002\u0007=\u0014x-\u0003\u0002=g\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002-Q,7\u000f^!qSZ+'o]5p]N\u0014V-];fgR$\u0012!\n\u0015\u0003\t\u0001\u0003\"!\u0011#\u000e\u0003\tS!aQ\u000e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002F\u0005\nY1\t\\;ti\u0016\u0014H+Z:u\u00031\"Xm\u001d;Ba&4VM]:j_:\u001c(+Z9vKN$\u0018J\\2mk\u0012,7/\u00168sK2,\u0017m]3e\u0003BL7\u000f\u000b\u0003\u0006\u0001\"K\u0015\u0001E:feZ,'\u000f\u0015:pa\u0016\u0014H/[3tY\u0005Q5&B&O\u001fF\u0013\u0006CA!M\u0013\ti%IA\u000bDYV\u001cH/\u001a:D_:4\u0017n\u001a)s_B,'\u000f^=\u0002\u0007-,\u00170I\u0001Q\u0003q)hn\u001d;bE2,g&\u00199j]Y,'o]5p]NtSM\\1cY\u0016\fQA^1mk\u0016\f\u0013aU\u0001\u0005iJ,X-A\u0019uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\"\u0014x.^4i\u0007>tGO]8m!2\fg.\u001a'jgR,g.\u001a:)\t\u0019\u0001ekV\u0001\fG2,8\u000f^3s)f\u0004X\rJ\u0001Y\u0013\tI&,\u0001\u0002[\u0017*\u00111LQ\u0001\u0005)f\u0004X-A\u0018uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u)\"\u0014x.^4i\u0007>tGO]8mY\u0016\u0014H*[:uK:,'\u000f\u000b\u0003\b\u0001ZsF%A0\n\u0005\u0001T\u0016!B&S\u0003\u001a#\u0016\u0001\f;fgR\f\u0005/\u001b,feNLwN\\:SKF,Xm\u001d;XSRDWK\\:vaB|'\u000f^3e-\u0016\u00148/[8oQ\tA\u0001)\u0001\u0012uKN$\u0018\t]5WKJ\u001c\u0018n\u001c8t%\u0016\fX/Z:u-\u0006d\u0017\u000eZ1uS>tg\u000b\r\u0015\u0003\u0013\u0001\u000bQ\b^3ti\u0006\u0003\u0018NV3sg&|gn\u001d*fcV,7\u000f\u001e,bY&$\u0017\r^5p]Z\u0003D\u000b\u001b:pk\u001eD7i\u001c8ue>d\u0007\u000b\\1oK2K7\u000f^3oKJDCA\u0003!W/\u0006YD/Z:u\u0003BLg+\u001a:tS>t7OU3rk\u0016\u001cHOV1mS\u0012\fG/[8o-B\"\u0006N]8vO\"\u001cuN\u001c;s_2dWM\u001d'jgR,g.\u001a:)\t-\u0001eKX\u0001#i\u0016\u001cH/\u00119j-\u0016\u00148/[8ogJ+\u0017/^3tiZ\u000bG.\u001b3bi&|gNV\u001a)\u00051\u0001\u0005F\u0002\u0001m->\u00148\u000f\u0005\u0002B[&\u0011aN\u0011\u0002\u0014\u00072,8\u000f^3s)\u0016\u001cH\u000fR3gCVdGo\u001d\u0013\u0002a&\u0011\u0011OW\u0001\u0004\u00032c\u0015a\u00022s_.,'o]\u000f\u0002\u0003!\"\u0001!^)|!\t1\u00180D\u0001x\u0015\tA8'A\u0005fqR,gn]5p]&\u0011!p\u001e\u0002\u000b\u000bb$XM\u001c3XSRDG&\u0001?$\u0003u\u00042A`A\u0001\u001b\u0005y(B\u0001\u001d\u001c\u0013\r\t\u0019a \u0002\u0016\u00072,8\u000f^3s)\u0016\u001cH/\u0012=uK:\u001c\u0018n\u001c8t\u0001")
public class ApiVersionsRequestTest
extends AbstractApiVersionsRequestTest {
    private final ClusterInstance cluster;

    @BeforeEach
    public void setup(ClusterConfig config) {
        super.brokerPropertyOverrides(config.serverProperties());
    }

    @ClusterTest
    public void testApiVersionsRequest() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3());
    }

    @ClusterTest(serverProperties={@ClusterConfigProperty(key="unstable.api.versions.enable", value="true")})
    public void testApiVersionsRequestIncludesUnreleasedApis() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.clientListener());
        boolean x$2 = true;
        ListenerName x$3 = this.validateApiVersionsResponse$default$2();
        this.validateApiVersionsResponse(apiVersionsResponse, x$3, x$2);
    }

    @ClusterTest(clusterType=Type.ZK)
    public void testApiVersionsRequestThroughControlPlaneListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), this.validateApiVersionsResponse$default$3());
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testApiVersionsRequestThroughControllerListener() {
        ApiVersionsRequest request = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(request, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get(), this.validateApiVersionsResponse$default$3());
    }

    @ClusterTest
    public void testApiVersionsRequestWithUnsupportedVersion() {
        ApiVersionsRequest apiVersionsRequest = (ApiVersionsRequest)new ApiVersionsRequest.Builder().build();
        ApiVersionsResponse apiVersionsResponse = this.sendUnsupportedApiVersionRequest(apiVersionsRequest);
        Assertions.assertEquals((short)Errors.UNSUPPORTED_VERSION.code(), (short)apiVersionsResponse.data().errorCode());
        Assertions.assertFalse((boolean)apiVersionsResponse.data().apiKeys().isEmpty());
        ApiVersionsResponseData.ApiVersion apiVersion = apiVersionsResponse.data().apiKeys().find(ApiKeys.API_VERSIONS.id);
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.id, (short)apiVersion.apiKey());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.oldestVersion(), (short)apiVersion.minVersion());
        Assertions.assertEquals((short)ApiKeys.API_VERSIONS.latestVersion(), (short)apiVersion.maxVersion());
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV0() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        this.validateApiVersionsResponse(apiVersionsResponse, this.validateApiVersionsResponse$default$2(), this.validateApiVersionsResponse$default$3());
    }

    @ClusterTest(clusterType=Type.ZK)
    public void testApiVersionsRequestValidationV0ThroughControlPlaneListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controlPlaneListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controlPlaneListenerName().get(), this.validateApiVersionsResponse$default$3());
    }

    @ClusterTest(clusterType=Type.KRAFT)
    public void testApiVersionsRequestValidationV0ThroughControllerListener() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest.Builder().build((short)0);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.controllerListenerName().get());
        this.validateApiVersionsResponse(apiVersionsResponse, this.cluster.controllerListenerName().get(), this.validateApiVersionsResponse$default$3());
    }

    @ClusterTest
    public void testApiVersionsRequestValidationV3() {
        ApiVersionsRequest apiVersionsRequest = new ApiVersionsRequest(new ApiVersionsRequestData(), (short)3);
        ApiVersionsResponse apiVersionsResponse = this.sendApiVersionsRequest(apiVersionsRequest, this.cluster.clientListener());
        Assertions.assertEquals((short)Errors.INVALID_REQUEST.code(), (short)apiVersionsResponse.data().errorCode());
    }

    public ApiVersionsRequestTest(ClusterInstance cluster) {
        this.cluster = cluster;
        super(cluster);
    }
}

