/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.BrokerEndPoint;
import kafka.log.LogManager;
import kafka.server.AlterPartitionManager;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LeaderEndPoint;
import kafka.server.LocalLeaderEndPoint;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.server.checkpoints.LazyOffsetCheckpoints;
import kafka.server.checkpoints.OffsetCheckpoints;
import kafka.server.metadata.ZkMetadataCache;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochRequestData;
import org.apache.kafka.common.message.OffsetForLeaderEpochResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.OffsetAndEpoch;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tmb\u0001\u0002\u0015*\u00019BQ!\u000e\u0001\u0005\u0002YBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004B\u0001\u0001\u0006Ia\u000f\u0005\b\u0005\u0002\u0011\r\u0011\"\u0001D\u0011\u0019y\u0005\u0001)A\u0005\t\"9\u0001\u000b\u0001b\u0001\n\u0003\t\u0006B\u0002.\u0001A\u0003%!\u000bC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r\u0001\u0004\u0001\u0015!\u0003^\u0011\u001d\t\u0007A1A\u0005\u0002\tDa!\u001b\u0001!\u0002\u0013\u0019\u0007\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0001l\u0011%y\u0007\u00011AA\u0002\u0013\u0005\u0001\u000fC\u0005w\u0001\u0001\u0007\t\u0011)Q\u0005Y\"Iq\u000f\u0001a\u0001\u0002\u0004%\t\u0001\u001f\u0005\ny\u0002\u0001\r\u00111A\u0005\u0002uD\u0011b \u0001A\u0002\u0003\u0005\u000b\u0015B=\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u00111\u0004\u0001\u0005\u0002\u0005\r\u0001bBA\u0013\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003S\u0001A\u0011AA\u0002\u0011\u001d\ti\u0003\u0001C\u0001\u0003\u00071a!!\r\u0001\t\u0005M\u0002BB\u001b\u0018\t\u0003\t9\u0004C\u0005\u0002T]\u0001\r\u0011\"\u0003\u0002V!I\u0011QL\fA\u0002\u0013%\u0011q\f\u0005\t\u0003G:\u0002\u0015)\u0003\u0002X!I\u0011QM\fA\u0002\u0013%\u0011q\r\u0005\n\u0003c:\u0002\u0019!C\u0005\u0003gB\u0001\"a\u001e\u0018A\u0003&\u0011\u0011\u000e\u0005\b\u0003s:B\u0011AA>\u0011\u001d\t\u0019i\u0006C\u0001\u0003\u000bCq!!#\u0018\t\u0003\tY\tC\u0004\u0002\u0010\u0002!I!!%\t\u000f\u0005%\u0006\u0001\"\u0003\u0002,\"I!q\u0002\u0001\u0012\u0002\u0013%!\u0011\u0003\u0005\n\u0005O\u0001\u0011\u0013!C\u0005\u0005SAqA!\f\u0001\t\u0013\u0011y\u0003C\u0004\u0002`\u0002!IA!\u000f\u0003/1{7-\u00197MK\u0006$WM]#oIB{\u0017N\u001c;UKN$(B\u0001\u0016,\u0003\u0019\u0019XM\u001d<fe*\tA&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001y\u0003C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002oA\u0011\u0001\bA\u0007\u0002S\u0005!A/[7f+\u0005Y\u0004C\u0001\u001f@\u001b\u0005i$B\u0001 ,\u0003\u0015)H/\u001b7t\u0013\t\u0001UH\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001d!x\u000e]5d\u0013\u0012,\u0012\u0001\u0012\t\u0003\u000b6k\u0011A\u0012\u0006\u0003\u000f\"\u000baaY8n[>t'B\u0001\u0017J\u0015\tQ5*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0019\u0006\u0019qN]4\n\u000593%\u0001B+vS\u0012\f\u0001\u0002^8qS\u000eLE\rI\u0001\u0006i>\u0004\u0018nY\u000b\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0005Y\u0006twMC\u0001X\u0003\u0011Q\u0017M^1\n\u0005e#&AB*ue&tw-\u0001\u0004u_BL7\rI\u0001\u000fi>\u0004\u0018n\u0019)beRLG/[8o+\u0005i\u0006CA#_\u0013\tyfI\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001fQ|\u0007/[2QCJ$\u0018\u000e^5p]\u0002\nAb]8ve\u000e,'I]8lKJ,\u0012a\u0019\t\u0003I\u001el\u0011!\u001a\u0006\u0003M.\nqa\u00197vgR,'/\u0003\u0002iK\nq!I]8lKJ,e\u000e\u001a)pS:$\u0018!D:pkJ\u001cWM\u0011:pW\u0016\u0014\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u00031\u0004\"\u0001O7\n\u00059L#A\u0004*fa2L7-Y'b]\u0006<WM]\u0001\u0013e\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002riB\u0011\u0001G]\u0005\u0003gF\u0012A!\u00168ji\"9Q/DA\u0001\u0002\u0004a\u0017a\u0001=%c\u0005y!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\b%\u0001\u0005f]\u0012\u0004v.\u001b8u+\u0005I\bC\u0001\u001d{\u0013\tY\u0018F\u0001\bMK\u0006$WM]#oIB{\u0017N\u001c;\u0002\u0019\u0015tG\rU8j]R|F%Z9\u0015\u0005Et\bbB;\u0011\u0003\u0003\u0005\r!_\u0001\nK:$\u0007k\\5oi\u0002\nQa]3u+B$\u0012!\u001d\u0015\u0004%\u0005\u001d\u0001\u0003BA\u0005\u0003/i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0004CBL'\u0002BA\t\u0003'\tqA[;qSR,'OC\u0002\u0002\u0016-\u000bQA[;oSRLA!!\u0007\u0002\f\tQ!)\u001a4pe\u0016,\u0015m\u00195\u0002+Q,7\u000f\u001e$fi\u000eDG*\u0019;fgR|eMZ:fi\"\u001a1#a\b\u0011\t\u0005%\u0011\u0011E\u0005\u0005\u0003G\tYA\u0001\u0003UKN$\u0018a\u0006;fgR4U\r^2i\u000b\u0006\u0014H.[3ti>3gm]3uQ\r!\u0012qD\u0001\u001di\u0016\u001cHOR3uG\",\u0015M\u001d7jKN$Hj\\2bY>3gm]3uQ\r)\u0012qD\u0001\u0019i\u0016\u001cHOR3uG\",\u0005o\\2i\u000b:$wJ\u001a4tKR\u001c\bf\u0001\f\u0002 \tq1)\u00197mE\u0006\u001c7NU3tk2$X\u0003BA\u001b\u0003\u0003\u001a\"aF\u0018\u0015\u0005\u0005e\u0002#BA\u001e/\u0005uR\"\u0001\u0001\u0011\t\u0005}\u0012\u0011\t\u0007\u0001\t\u001d\t\u0019e\u0006b\u0001\u0003\u000b\u0012\u0011\u0001V\t\u0005\u0003\u000f\ni\u0005E\u00021\u0003\u0013J1!a\u00132\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001MA(\u0013\r\t\t&\r\u0002\u0004\u0003:L\u0018!\u0002<bYV,WCAA,!\u0015\u0001\u0014\u0011LA\u001f\u0013\r\tY&\r\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0013Y\fG.^3`I\u0015\fHcA9\u0002b!AQOGA\u0001\u0002\u0004\t9&\u0001\u0004wC2,X\rI\u0001\u0004MVtWCAA5!\u0015\u0001\u0014\u0011LA6!\u0019\u0001\u0014QNA\u001fc&\u0019\u0011qN\u0019\u0003\u0013\u0019+hn\u0019;j_:\f\u0014a\u00024v]~#S-\u001d\u000b\u0004c\u0006U\u0004\u0002C;\u001e\u0003\u0003\u0005\r!!\u001b\u0002\t\u0019,h\u000eI\u0001\tQ\u0006\u001ch)\u001b:fIV\u0011\u0011Q\u0010\t\u0004a\u0005}\u0014bAAAc\t9!i\\8mK\u0006t\u0017\u0001\u00024je\u0016$2!]AD\u0011\u001d\t\u0019\u0006\ta\u0001\u0003{\taa\u001c8GSJ,G\u0003BA\u001d\u0003\u001bCq!!\u001a\"\u0001\u0004\tY'\u0001\rck&dG\rT3bI\u0016\u0014\u0018I\u001c3JgJ\u0014V-];fgR$B!a%\u0002 B!\u0011QSAN\u001b\t\t9JC\u0002\u0002\u001a\u001a\u000b\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003;\u000b9JA\nMK\u0006$WM]!oI&\u001b(OU3rk\u0016\u001cH\u000fC\u0004\u0002\"\n\u0002\r!a)\u0002\u00171,\u0017\rZ3s\u000bB|7\r\u001b\t\u0004a\u0005\u0015\u0016bAATc\t\u0019\u0011J\u001c;\u0002\u001b\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3t)1\ti+a6\u0002Z\u0006u\u0017Q\u001eB\u0003!\u0015\tYdFAX!\u0011\t\t,!5\u000f\t\u0005M\u0016Q\u001a\b\u0005\u0003k\u000bYM\u0004\u0003\u00028\u0006%g\u0002BA]\u0003\u000ftA!a/\u0002F:!\u0011QXAb\u001b\t\tyLC\u0002\u0002B6\na\u0001\u0010:p_Rt\u0014\"\u0001'\n\u0005)[\u0015B\u0001\u0017J\u0013\t9\u0005*C\u0002\u0002\u001a\u001aKA!a4\u0002\u0018\u0006y\u0001K]8ek\u000e,'+Z:q_:\u001cX-\u0003\u0003\u0002T\u0006U'!\u0005)beRLG/[8o%\u0016\u001c\bo\u001c8tK*!\u0011qZAL\u0011\u0015Q7\u00051\u0001m\u0011\u0019\tYn\ta\u0001;\u0006I\u0001/\u0019:uSRLwN\u001c\u0005\b\u0003?\u001c\u0003\u0019AAq\u0003\u001d\u0011XmY8sIN\u0004B!a9\u0002j6\u0011\u0011Q\u001d\u0006\u0004\u0003O4\u0015A\u0002:fG>\u0014H-\u0003\u0003\u0002l\u0006\u0015(!D'f[>\u0014\u0018PU3d_J$7\u000fC\u0005\u0002p\u000e\u0002\n\u00111\u0001\u0002r\u00061qN]5hS:\u0004B!a=\u0003\u00025\u0011\u0011Q\u001f\u0006\u0005\u0003o\fI0A\u0002m_\u001eTA!a?\u0002~\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u0004\u0003\u007fD\u0015aB:u_J\fw-Z\u0005\u0005\u0005\u0007\t)P\u0001\u0007BaB,g\u000eZ(sS\u001eLg\u000eC\u0005\u0003\b\r\u0002\n\u00111\u0001\u0003\n\u0005a!/Z9vSJ,G-Q2lgB\u0019\u0001Ga\u0003\n\u0007\t5\u0011GA\u0003TQ>\u0014H/A\fbaB,g\u000e\u001a*fG>\u0014Hm\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0003\u0016\u0005\u0003c\u0014)b\u000b\u0002\u0003\u0018A!!\u0011\u0004B\u0012\u001b\t\u0011YB\u0003\u0003\u0003\u001e\t}\u0011!C;oG\",7m[3e\u0015\r\u0011\t#M\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B\u0013\u00057\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003]\t\u0007\u000f]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$S'\u0006\u0002\u0003,)\"!\u0011\u0002B\u000b\u0003\u0011qw\u000eZ3\u0015\t\tE\"q\u0007\t\u0004\u000b\nM\u0012b\u0001B\u001b\r\n!aj\u001c3f\u0011\u00159h\u00051\u0001d+\t\t\t\u000f")
public class LocalLeaderEndPointTest {
    private final MockTime time = new MockTime();
    private final Uuid topicId = Uuid.randomUuid();
    private final String topic;
    private final TopicPartition topicPartition = new TopicPartition(this.topic(), 5);
    private final BrokerEndPoint sourceBroker = new BrokerEndPoint(0, "localhost", 9092);
    private ReplicaManager replicaManager;
    private LeaderEndPoint endPoint;

    public MockTime time() {
        return this.time;
    }

    public Uuid topicId() {
        return this.topicId;
    }

    public String topic() {
        return this.topic;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public BrokerEndPoint sourceBroker() {
        return this.sourceBroker;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public LeaderEndPoint endPoint() {
        return this.endPoint;
    }

    public void endPoint_$eq(LeaderEndPoint x$1) {
        this.endPoint = x$1;
    }

    @BeforeEach
    public void setUp() {
        int x$12 = this.sourceBroker().id();
        String x$22 = TestUtils$.MODULE$.MockZkConnect();
        int x$32 = this.sourceBroker().port();
        boolean x$4 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$6 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$9 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$11 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$122 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$13 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$14 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$15 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$16 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        int x$17 = TestUtils$.MODULE$.createBrokerConfig$default$17();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        int x$19 = TestUtils$.MODULE$.createBrokerConfig$default$19();
        short x$20 = TestUtils$.MODULE$.createBrokerConfig$default$20();
        boolean x$21 = TestUtils$.MODULE$.createBrokerConfig$default$21();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$12, x$22, x$4, x$5, x$32, x$6, x$7, x$8, x$9, x$10, x$11, x$122, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4(), TestUtils$.MODULE$.createLogManager$default$5(), TestUtils$.MODULE$.createLogManager$default$6(), TestUtils$.MODULE$.createLogManager$default$7());
        AlterPartitionManager alterPartitionManager = (AlterPartitionManager)Mockito.mock(AlterPartitionManager.class);
        Metrics metrics = new Metrics();
        QuotaFactory.QuotaManagers quotaManager = QuotaFactory$.MODULE$.instantiate(config, metrics, (Time)this.time(), "");
        MockTime x$24 = this.time();
        MockScheduler x$25 = new MockScheduler((Time)this.time());
        ZkMetadataCache x$28 = MetadataCache$.MODULE$.zkMetadataCache(config.brokerId(), config.interBrokerProtocolVersion(), MetadataCache$.MODULE$.zkMetadataCache$default$3(), MetadataCache$.MODULE$.zkMetadataCache$default$4());
        LogDirFailureChannel x$29 = new LogDirFailureChannel(config.logDirs().size());
        Option x$31 = ReplicaManager$.MODULE$.$lessinit$greater$default$6();
        BrokerTopicStats x$322 = ReplicaManager$.MODULE$.$lessinit$greater$default$11();
        AtomicBoolean x$33 = ReplicaManager$.MODULE$.$lessinit$greater$default$12();
        Option x$34 = ReplicaManager$.MODULE$.$lessinit$greater$default$13();
        Option x$35 = ReplicaManager$.MODULE$.$lessinit$greater$default$14();
        Option x$36 = ReplicaManager$.MODULE$.$lessinit$greater$default$15();
        Option x$37 = ReplicaManager$.MODULE$.$lessinit$greater$default$16();
        Option x$38 = ReplicaManager$.MODULE$.$lessinit$greater$default$17();
        Option x$39 = ReplicaManager$.MODULE$.$lessinit$greater$default$18();
        Function0 x$40 = ReplicaManager$.MODULE$.$lessinit$greater$default$19();
        this.replicaManager_$eq(new ReplicaManager(config, metrics, (Time)x$24, (Scheduler)x$25, mockLogMgr, x$31, quotaManager, (MetadataCache)x$28, x$29, alterPartitionManager, x$322, x$33, x$34, x$35, x$36, x$37, x$38, x$39, x$40));
        this.replicaManager().createPartition(this.topicPartition()).createLogIfNotExists(false, false, (OffsetCheckpoints)new LazyOffsetCheckpoints(this.replicaManager().highWatermarkCheckpoints()), (Option)None$.MODULE$);
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(0);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> {
            LocalLeaderEndPointTest.$anonfun$setUp$2(x$2, x$3);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().getPartitionOrException(this.topicPartition()).localLogOrException();
        this.endPoint_$eq((LeaderEndPoint)new LocalLeaderEndPoint(this.sourceBroker(), config, this.replicaManager(), (ReplicaQuota)QuotaFactory.UnboundedQuota$.MODULE$));
    }

    @Test
    public void testFetchLatestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 0), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$4, x$5) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$2(x$4, x$5);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchLatestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(6L, 4), (Object)this.endPoint().fetchLatestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$6, x$7) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$2(x$6, x$7);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$3(response);
            return BoxedUnit.UNIT;
        });
        this.replicaManager().deleteRecords(1000L, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)BoxesRunTime.boxToLong((long)3L))})), (Function1 & Serializable & scala.Serializable)x$8 -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestOffset$4(x$8);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 4), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEarliestLocalOffset() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$1(response);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 0));
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$2(x$9, x$10);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEarliestLocalOffset$3(response);
            return BoxedUnit.UNIT;
        });
        LogManager qual$1 = this.replicaManager().logManager();
        TopicPartition x$1 = this.topicPartition();
        boolean x$2 = qual$1.getLog$default$2();
        qual$1.getLog(x$1, x$2).foreach((Function1 & Serializable & scala.Serializable)log -> {
            log._localLogStartOffset_$eq(3L);
            return BoxedUnit.UNIT;
        });
        Assertions.assertEquals((Object)new OffsetAndEpoch(0L, 0), (Object)this.endPoint().fetchEarliestOffset(this.topicPartition(), 7));
        Assertions.assertEquals((Object)new OffsetAndEpoch(3L, 4), (Object)this.endPoint().fetchEarliestLocalOffset(this.topicPartition(), 7));
    }

    @Test
    public void testFetchEpochEndOffsets() {
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$1(response);
            return BoxedUnit.UNIT;
        });
        Map result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(0))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        LeaderAndIsrRequest leaderAndIsrRequest = this.buildLeaderAndIsrRequest(4);
        this.replicaManager().becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$2(x$11, x$12);
            return BoxedUnit.UNIT;
        });
        this.appendRecords(this.replicaManager(), this.topicPartition(), this.records(), this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            LocalLeaderEndPointTest.$anonfun$testFetchEpochEndOffsets$3(response);
            return BoxedUnit.UNIT;
        });
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(4))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(4).setEndOffset(6L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(3))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(0).setEndOffset(3L))}))), (Object)result);
        result = this.endPoint().fetchEpochEndOffsets((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochRequestData.OffsetForLeaderPartition().setPartition(this.topicPartition().partition()).setLeaderEpoch(5))})));
        Assertions.assertEquals((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition()), (Object)new OffsetForLeaderEpochResponseData.EpochEndOffset().setPartition(this.topicPartition().partition()).setErrorCode(Errors.NONE.code()).setLeaderEpoch(-1).setEndOffset(-1L))}))), (Object)result);
    }

    private LeaderAndIsrRequest buildLeaderAndIsrRequest(int leaderEpoch) {
        java.util.List brokerList = (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)Predef$.MODULE$.int2Integer(this.sourceBroker().id()), (List)Nil$.MODULE$)).asJava();
        java.util.Map<String, Uuid> topicIds = Collections.singletonMap(this.topic(), this.topicId());
        return (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, 0L, (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName(this.topic()).setPartitionIndex(this.topicPartition().partition()).setControllerEpoch(0).setLeader(this.sourceBroker().id()).setLeaderEpoch(leaderEpoch).setIsr(brokerList).setPartitionEpoch(0).setReplicas(brokerList).setIsNew(false), (List)Nil$.MODULE$)).asJava(), topicIds, (Collection)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{this.node(this.sourceBroker())}))).asJava()).build();
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, AppendOrigin origin, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, origin, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable & scala.Serializable)responses -> {
            LocalLeaderEndPointTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8(), replicaManager.appendRecords$default$9());
        return result;
    }

    private AppendOrigin appendRecords$default$4() {
        return AppendOrigin.CLIENT;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    private Node node(BrokerEndPoint endPoint) {
        return new Node(endPoint.id(), endPoint.host(), endPoint.port());
    }

    private MemoryRecords records() {
        return MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes()), new SimpleRecord("second message".getBytes()), new SimpleRecord("third message".getBytes())});
    }

    public static final /* synthetic */ void $anonfun$setUp$2(Iterable x$2, Iterable x$3) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$2(Iterable x$4, Iterable x$5) {
    }

    public static final /* synthetic */ void $anonfun$testFetchLatestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$2(Iterable x$6, Iterable x$7) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestOffset$4(Map x$8) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$2(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEarliestLocalOffset$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$1(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$2(Iterable x$11, Iterable x$12) {
    }

    public static final /* synthetic */ void $anonfun$testFetchEpochEndOffsets$3(ProduceResponse.PartitionResponse response) {
        Assertions.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assertions.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    public LocalLeaderEndPointTest() {
        this.topic = "test";
    }

    private class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public boolean hasFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable & scala.Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
            if (this.hasFired()) {
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ LocalLeaderEndPointTest kafka$server$LocalLeaderEndPointTest$CallbackResult$$$outer() {
            return LocalLeaderEndPointTest.this;
        }

        public static final /* synthetic */ void $anonfun$fire$1(Object value$1, Function1 f) {
            f.apply(value$1);
        }

        public CallbackResult() {
            if (LocalLeaderEndPointTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

