/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.stream.Stream;
import kafka.server.MetadataCache;
import kafka.server.MetadataCache$;
import kafka.server.MetadataCacheTest$;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkMetadataCache;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.metadata.BrokerRegistrationChangeRecord;
import org.apache.kafka.common.metadata.RegisterBrokerRecord;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataProvenance;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015x!\u0002\r\u001a\u0011\u0003qb!\u0002\u0011\u001a\u0011\u0003\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\"B\u001d\u0002\t\u0003Y\u0003\"\u0002\u001e\u0002\t\u0003Yd\u0001\u0002\u0011\u001a\u0001ACQ\u0001\u000b\u0004\u0005\u0002ECqa\u0015\u0004C\u0002\u0013\u0005A\u000b\u0003\u0004Y\r\u0001\u0006I!\u0016\u0005\u00063\u001a!\tA\u0017\u0005\u0006c\u001a!\tA\u001d\u0005\u0006o\u001a!\t\u0001\u001f\u0005\u0006{\u001a!\tA \u0005\b\u0003\u000f1A\u0011BA\u0005\u0011\u001d\t\tI\u0002C\u0001\u0003\u0007Cq!!$\u0007\t\u0003\ty\tC\u0004\u0002\u001a\u001a!\t!a'\t\u000f\u0005\u0015f\u0001\"\u0001\u0002(\"9\u0011\u0011\u0017\u0004\u0005\u0002\u0005M\u0006bBA`\r\u0011\u0005\u0011\u0011\u0019\u0005\b\u0003#4A\u0011AAa\u0011\u001d\t)N\u0002C\u0001\u0003\u0003Dq!!7\u0007\t\u0003\tY.A\tNKR\fG-\u0019;b\u0007\u0006\u001c\u0007.\u001a+fgRT!AG\u000e\u0002\rM,'O^3s\u0015\u0005a\u0012!B6bM.\f7\u0001\u0001\t\u0003?\u0005i\u0011!\u0007\u0002\u0012\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3UKN$8CA\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AH\u0001\u0010u.\u001c\u0015m\u00195f!J|g/\u001b3feR\tA\u0006E\u0002.iYj\u0011A\f\u0006\u0003_A\naa\u001d;sK\u0006l'BA\u00193\u0003\u0011)H/\u001b7\u000b\u0003M\nAA[1wC&\u0011QG\f\u0002\u0007'R\u0014X-Y7\u0011\u0005}9\u0014B\u0001\u001d\u001a\u00055iU\r^1eCR\f7)Y2iK\u0006i1-Y2iKB\u0013xN^5eKJ\f1\"\u001e9eCR,7)Y2iKR\u0019AhP!\u0011\u0005\rj\u0014B\u0001 %\u0005\u0011)f.\u001b;\t\u000b\u0001+\u0001\u0019\u0001\u001c\u0002\u000b\r\f7\r[3\t\u000b\t+\u0001\u0019A\"\u0002\u000fI,\u0017/^3tiB\u0011AIT\u0007\u0002\u000b*\u0011aiR\u0001\te\u0016\fX/Z:ug*\u0011\u0001*S\u0001\u0007G>lWn\u001c8\u000b\u0005qQ%BA&M\u0003\u0019\t\u0007/Y2iK*\tQ*A\u0002pe\u001eL!aT#\u0003+U\u0003H-\u0019;f\u001b\u0016$\u0018\rZ1uCJ+\u0017/^3tiN\u0011aA\t\u000b\u0002%B\u0011qDB\u0001\fEJ|7.\u001a:Fa>\u001c\u0007.F\u0001V!\t\u0019c+\u0003\u0002XI\t!Aj\u001c8h\u00031\u0011'o\\6fe\u0016\u0003xn\u00195!\u0003\u0005:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018MT8o\u000bbL7\u000f^5oOR{\u0007/[2t)\ta4\fC\u0003A\u0015\u0001\u0007a\u0007\u000b\u0003\u000b;&T\u0007C\u00010h\u001b\u0005y&B\u00011b\u0003!\u0001(o\u001c<jI\u0016\u0014(B\u00012d\u0003\u0019\u0001\u0018M]1ng*\u0011A-Z\u0001\bUV\u0004\u0018\u000e^3s\u0015\t1G*A\u0003kk:LG/\u0003\u0002i?\naQ*\u001a;i_\u0012\u001cv.\u001e:dK\u0006)a/\u00197vK2\n1.I\u0001:Q\tQQ\u000e\u0005\u0002o_6\t\u0011-\u0003\u0002qC\n\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002!\u001d,G\u000fV8qS\u000elU\r^1eCR\fGC\u0001\u001ft\u0011\u0015\u00015\u00021\u00017Q\u0011YQ,[;-\u0003-D#aC7\u0002W\u001d,G\u000fV8qS\u000elU\r^1eCR\f\u0007+\u0019:uSRLwN\u001c'fC\u0012,'OT8u\u0003Z\f\u0017\u000e\\1cY\u0016$\"\u0001P=\t\u000b\u0001c\u0001\u0019\u0001\u001c)\t1i\u0016n\u001f\u0017\u0002W\"\u0012A\"\\\u00016O\u0016$Hk\u001c9jG6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|g\u000eT5ti\u0016tWM\u001d(pi\u00063\u0018-\u001b7bE2,wJ\u001c'fC\u0012,'\u000f\u0006\u0002=\u007f\")\u0001)\u0004a\u0001m!*Q\"X5\u0002\u00041\n1\u000e\u000b\u0002\u000e[\u0006Ad/\u001a:jMf$v\u000e]5d\u001b\u0016$\u0018\rZ1uCB\u000b'\u000f^5uS>tG*Z1eKJ|%/\u00128ea>Lg\u000e\u001e(pi\u00063\u0018-\u001b7bE2,Gc\u0004\u001f\u0002\f\u00055\u0011qCA*\u0003G\n9'a\u001e\t\u000b\u0001s\u0001\u0019\u0001\u001c\t\u000f\u0005=a\u00021\u0001\u0002\u0012\u0005)R.\u001a;bI\u0006$\u0018mQ1dQ\u0016\u0014%o\\6fe&#\u0007cA\u0012\u0002\u0014%\u0019\u0011Q\u0003\u0013\u0003\u0007%sG\u000fC\u0004\u0002\u001a9\u0001\r!a\u0007\u0002\u000f\t\u0014xn[3sgB1\u0011QDA\u0012\u0003Oi!!a\b\u000b\u0007\u0005\u0005B%\u0001\u0006d_2dWm\u0019;j_:LA!!\n\u0002 \t\u00191+Z9\u0011\t\u0005%\u0012Q\n\b\u0005\u0003W\t9E\u0004\u0003\u0002.\u0005\rc\u0002BA\u0018\u0003\u0003rA!!\r\u0002@9!\u00111GA\u001f\u001d\u0011\t)$a\u000f\u000e\u0005\u0005]\"bAA\u001d;\u00051AH]8pizJ\u0011!T\u0005\u0003\u00172K!\u0001\b&\n\u0005!K\u0015bAA#\u000f\u00069Q.Z:tC\u001e,\u0017\u0002BA%\u0003\u0017\n\u0011$\u00169eCR,W*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fR1uC*\u0019\u0011QI$\n\t\u0005=\u0013\u0011\u000b\u0002\u0015+B$\u0017\r^3NKR\fG-\u0019;b\u0005J|7.\u001a:\u000b\t\u0005%\u00131\n\u0005\b\u0003+r\u0001\u0019AA,\u00031a\u0017n\u001d;f]\u0016\u0014h*Y7f!\u0011\tI&a\u0018\u000e\u0005\u0005m#bAA/\u000f\u00069a.\u001a;x_J\\\u0017\u0002BA1\u00037\u0012A\u0002T5ti\u0016tWM\u001d(b[\u0016Dq!!\u001a\u000f\u0001\u0004\t\t\"\u0001\u0004mK\u0006$WM\u001d\u0005\b\u0003Sr\u0001\u0019AA6\u00035)\u0007\u0010]3di\u0016$WI\u001d:peB!\u0011QNA:\u001b\t\tyGC\u0002\u0002r\u001d\u000b\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003k\nyG\u0001\u0004FeJ|'o\u001d\u0005\b\u0003sr\u0001\u0019AA>\u0003e)'O]8s+:\fg/Y5mC\ndW\rT5ti\u0016tWM]:\u0011\u0007\r\ni(C\u0002\u0002\u0000\u0011\u0012qAQ8pY\u0016\fg.A\u0012hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+\u0007\u000f\\5dC:{G/\u0011<bS2\f'\r\\3\u0015\u0007q\n)\tC\u0003A\u001f\u0001\u0007a\u0007K\u0003\u0010;&\fI\tL\u0001lQ\tyQ.A\u0010hKR$v\u000e]5d\u001b\u0016$\u0018\rZ1uC&\u001b(OT8u\u0003Z\f\u0017\u000e\\1cY\u0016$2\u0001PAI\u0011\u0015\u0001\u0005\u00031\u00017Q\u0015\u0001R,[AKY\u0005Y\u0007F\u0001\tn\u0003A:W\r\u001e+pa&\u001cW*\u001a;bI\u0006$\u0018mV5uQ:{gnU;qa>\u0014H/\u001a3TK\u000e,(/\u001b;z!J|Go\\2pYR\u0019A(!(\t\u000b\u0001\u000b\u0002\u0019\u0001\u001c)\u000bEi\u0016.!)-\u0003-D#!E7\u0002]\u001d,G/\u00117jm\u0016\u0014%o\\6feN\u001c\u0006n\\;mI:{GOQ3NkR\fG/\u001a3CsV\u0003H-\u0019;f\u0007\u0006\u001c\u0007.\u001a\u000b\u0004y\u0005%\u0006\"\u0002!\u0013\u0001\u00041\u0004&\u0002\n^S\u00065F&A6)\u0005Ii\u0017!\u000b;fgR<U\r^\"mkN$XM]'fi\u0006$\u0017\r^1XSRDwJ\u001a4mS:,'+\u001a9mS\u000e\f7\u000fF\u0002=\u0003kCQ\u0001Q\nA\u0002YBSaE/j\u0003sc#!a/\"\u0003)B#aE7\u0002%Q,7\u000f^%t\u0005J|7.\u001a:GK:\u001cW\r\u001a\u000b\u0002y!\u001aA#!2\u0011\t\u0005\u001d\u0017QZ\u0007\u0003\u0003\u0013T1!a3d\u0003\r\t\u0007/[\u0005\u0005\u0003\u001f\fIM\u0001\u0003UKN$\u0018\u0001\t;fgRL5O\u0011:pW\u0016\u0014\u0018J\\\"p]R\u0014x\u000e\u001c7fINCW\u000f\u001e3po:D3!FAc\u0003Y!Xm\u001d;HKRd\u0015N^3Ce>\\WM]#q_\u000eD\u0007f\u0001\f\u0002F\u0006!B/Z:u\u000f\u0016$\b+\u0019:uSRLwN\\%oM>$2\u0001PAo\u0011\u0015\u0001u\u00031\u00017Q\u00159R,[AqY\u0005Y\u0007FA\fn\u0001")
public class MetadataCacheTest {
    private final long brokerEpoch;

    public static void updateCache(MetadataCache metadataCache, UpdateMetadataRequest updateMetadataRequest) {
        MetadataCacheTest$.MODULE$.updateCache(metadataCache, updateMetadataRequest);
    }

    public static Stream<MetadataCache> cacheProvider() {
        return MetadataCacheTest$.MODULE$.cacheProvider();
    }

    public static Stream<MetadataCache> zkCacheProvider() {
        return MetadataCacheTest$.MODULE$.zkCacheProvider();
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataNonExistingTopics(MetadataCache cache) {
        String topic = "topic";
        Assertions.assertTrue((boolean)cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4()).isEmpty());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadata(MetadataCache cache) {
        String topic0 = "topic-0";
        String topic1 = "topic-1";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        IndexedSeq brokers = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1 & Serializable & scala.Serializable)brokerId -> MetadataCacheTest.$anonfun$getTopicMetadata$1(BoxesRunTime.unboxToInt((Object)brokerId)), IndexedSeq$.MODULE$.canBuildFrom());
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(0).setLeaderEpoch(0).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic0).setPartitionIndex(1).setControllerEpoch(controllerEpoch).setLeader(1).setLeaderEpoch(1).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(0)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(4)})), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic1).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(2).setLeaderEpoch(2).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(3)})), (List)Nil$.MODULE$)));
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        topicIds.put(topic0, Uuid.randomUuid());
        topicIds.put(topic1, Uuid.randomUuid());
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), topicIds).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        new .colon.colon((Object)SecurityProtocol.PLAINTEXT, (List)new .colon.colon((Object)SecurityProtocol.SSL, (List)Nil$.MODULE$)).foreach(arg_0 -> MetadataCacheTest.$anonfun$getTopicMetadata$2$adapted(cache, topicIds, (Seq)partitionStates, topic0, topic1, arg_0));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionLeaderNotAvailable(MetadataCache cache) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, listenerName, 1, Errors.LEADER_NOT_AVAILABLE, true);
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataPartitionListenerNotAvailableOnLeader(MetadataCache cache) {
        ListenerName plaintextListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        ListenerName sslListenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL);
        .colon.colon broker0Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host0").setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(sslListenerName.value()), (List)Nil$.MODULE$));
        .colon.colon broker1Endpoints = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("host1").setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(plaintextListenerName.value()), (List)Nil$.MODULE$);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)broker0Endpoints).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)broker1Endpoints).asJava()), (List)Nil$.MODULE$));
        int metadataCacheBrokerId = 0;
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LISTENER_NOT_FOUND, true);
        this.verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(cache, metadataCacheBrokerId, (Seq<UpdateMetadataRequestData.UpdateMetadataBroker>)brokers, sslListenerName, 1, Errors.LEADER_NOT_AVAILABLE, false);
    }

    private void verifyTopicMetadataPartitionLeaderOrEndpointNotAvailable(MetadataCache cache, int metadataCacheBrokerId, Seq<UpdateMetadataRequestData.UpdateMetadataBroker> brokers, ListenerName listenerName, int leader, Errors expectedError, boolean errorUnavailableListeners) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        int leaderEpoch = 1;
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)})).setZkVersion(zkVersion).setReplicas(Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)})), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        scala.collection.immutable.Set x$1 = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}));
        boolean x$4 = cache.getTopicMetadata$default$3();
        Seq topicMetadatas = cache.getTopicMetadata((Set)x$1, listenerName, x$4, errorUnavailableListeners);
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)expectedError.code(), (short)partitionMetadata.errorCode());
        Assertions.assertFalse((boolean)partitionMetadata.isrNodes().isEmpty());
        Assertions.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicaNodes()).asScala());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataReplicaNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicaNodes()).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isrNodes()).asScala()).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicaNodes()).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isrNodes()).asScala()).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataIsrNotAvailable(MetadataCache cache) {
        String topic = "topic";
        int zkVersion = 3;
        int controllerId = 2;
        int controllerEpoch = 1;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadatas = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, false, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        java.util.List partitionMetadatas = topicMetadata.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatas.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)partitionMetadatas.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadata.partitionIndex());
        Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.replicaNodes()).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadata.isrNodes()).asScala()).toSet());
        Seq topicMetadatasWithError = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName, true, cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatasWithError.size());
        MetadataResponseData.MetadataResponseTopic topicMetadataWithError = (MetadataResponseData.MetadataResponseTopic)topicMetadatasWithError.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadataWithError.errorCode());
        java.util.List partitionMetadatasWithError = topicMetadataWithError.partitions();
        Assertions.assertEquals((int)1, (int)partitionMetadatasWithError.size());
        MetadataResponseData.MetadataResponsePartition partitionMetadataWithError = (MetadataResponseData.MetadataResponsePartition)partitionMetadatasWithError.get(0);
        Assertions.assertEquals((int)0, (int)partitionMetadataWithError.partitionIndex());
        Assertions.assertEquals((short)Errors.REPLICA_NOT_AVAILABLE.code(), (short)partitionMetadataWithError.errorCode());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.replicaNodes()).asScala()).toSet());
        Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)((TraversableOnce)CollectionConverters$.MODULE$.asScalaBufferConverter(partitionMetadataWithError.isrNodes()).asScala()).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getTopicMetadataWithNonSupportedSecurityProtocol(MetadataCache cache) {
        String topic = "topic";
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Seq topicMetadata = cache.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL), cache.getTopicMetadata$default$3(), cache.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadata.size());
        Assertions.assertEquals((int)1, (int)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().size());
        Assertions.assertEquals((int)-1, (int)((MetadataResponseData.MetadataResponsePartition)((MetadataResponseData.MetadataResponseTopic)topicMetadata.head()).partitions().get(0)).leaderId());
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void getAliveBrokersShouldNotBeMutatedByUpdateCache(MetadataCache cache) {
        String topic = "topic";
        Range.Inclusive initialBrokerIds = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 2);
        this.updateCache$1((Seq)initialBrokerIds, topic, cache);
        Iterable aliveBrokersFromCache = cache.getAliveBrokers();
        this.updateCache$1((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 3), topic, cache);
        Assertions.assertEquals((Object)initialBrokerIds.toSet(), (Object)((TraversableOnce)aliveBrokersFromCache.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.id()), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    @ParameterizedTest
    @MethodSource(value={"zkCacheProvider"})
    public void testGetClusterMetadataWithOfflineReplicas(MetadataCache cache) {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("r").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(1).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()), (List)Nil$.MODULE$));
        int controllerEpoch = 1;
        int leader = 1;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        java.util.List<Object> offline = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(1)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(topicPartition.partition()).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas).setOfflineReplicas(offline), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        Node expectedNode0 = new Node(0, "foo", 9092, "r");
        Node expectedNode1 = new Node(1, "", -1);
        Cluster cluster = cache.getClusterMetadata("clusterId", listenerName);
        Assertions.assertEquals((Object)expectedNode0, (Object)cluster.nodeById(0));
        Assertions.assertNull((Object)cluster.nodeById(1));
        Assertions.assertEquals((Object)expectedNode1, (Object)cluster.leaderFor(topicPartition));
        PartitionInfo partitionInfo = cluster.partition(topicPartition);
        Assertions.assertEquals((Object)expectedNode1, (Object)partitionInfo.leader());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.replicas())).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode0, (List)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$)), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.inSyncReplicas())).toSeq());
        Assertions.assertEquals((Object)new .colon.colon((Object)expectedNode1, (List)Nil$.MODULE$), (Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionInfo.offlineReplicas())).toSeq());
    }

    @Test
    public void testIsBrokerFenced() {
        KRaftMetadataCache metadataCache = MetadataCache$.MODULE$.kRaftMetadataCache(0);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setFenced(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerFenced(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setFenced((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerFenced(0));
    }

    @Test
    public void testIsBrokerInControlledShutdown() {
        KRaftMetadataCache metadataCache = MetadataCache$.MODULE$.kRaftMetadataCache(0);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setInControlledShutdown(false));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertFalse((boolean)metadataCache.isBrokerShuttingDown(0));
        delta.replay(new BrokerRegistrationChangeRecord().setBrokerId(0).setInControlledShutdown((byte)1));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertTrue((boolean)metadataCache.isBrokerShuttingDown(0));
    }

    @Test
    public void testGetLiveBrokerEpoch() {
        KRaftMetadataCache metadataCache = MetadataCache$.MODULE$.kRaftMetadataCache(0);
        MetadataDelta delta = new MetadataDelta.Builder().build();
        delta.replay(new RegisterBrokerRecord().setBrokerId(0).setBrokerEpoch(100L).setFenced(false));
        delta.replay(new RegisterBrokerRecord().setBrokerId(1).setBrokerEpoch(101L).setFenced(true));
        metadataCache.setImage(delta.apply(MetadataProvenance.EMPTY));
        Assertions.assertEquals((long)100L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(0).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
        Assertions.assertEquals((long)-1L, (long)BoxesRunTime.unboxToLong((Object)metadataCache.getAliveBrokerEpoch(1).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> -1L)));
    }

    @ParameterizedTest
    @MethodSource(value={"cacheProvider"})
    public void testGetPartitionInfo(MetadataCache cache) {
        String topic = "topic";
        int partitionIndex = 0;
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0)});
        int zkVersion = 3;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(2), Predef$.MODULE$.int2Integer(3), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(4)});
        java.util.List<Object> offlineReplicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic).setPartitionIndex(partitionIndex).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(zkVersion).setReplicas(replicas).setOfflineReplicas(offlineReplicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        int controllerId = 2;
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        .colon.colon brokers = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataBroker().setId(0).setRack("rack1").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(listenerName.value()), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, controllerId, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)brokers).asJava(), Collections.emptyMap(), false).build();
        MetadataCacheTest$.MODULE$.updateCache(cache, updateMetadataRequest);
        UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)cache.getPartitionInfo(topic, partitionIndex).get();
        Assertions.assertEquals((Object)topic, (Object)partitionState.topicName());
        Assertions.assertEquals((int)partitionIndex, (int)partitionState.partitionIndex());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals((int)controllerEpoch, (int)partitionState.controllerEpoch());
        } else {
            Assertions.assertEquals((int)-1, (int)partitionState.controllerEpoch());
        }
        Assertions.assertEquals((int)leader, (int)partitionState.leader());
        Assertions.assertEquals((int)leaderEpoch, (int)partitionState.leaderEpoch());
        Assertions.assertEquals(isr, (Object)partitionState.isr());
        Assertions.assertEquals((int)zkVersion, (int)partitionState.zkVersion());
        Assertions.assertEquals(replicas, (Object)partitionState.replicas());
        if (cache instanceof ZkMetadataCache) {
            Assertions.assertEquals(offlineReplicas, (Object)partitionState.offlineReplicas());
        }
    }

    private static final Seq endpoints$2(int brokerId) {
        String host = new StringBuilder(4).append("foo-").append(brokerId).toString();
        return new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9092).setSecurityProtocol(SecurityProtocol.PLAINTEXT.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT).value()), (List)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost(host).setPort(9093).setSecurityProtocol(SecurityProtocol.SSL.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL).value()), (List)Nil$.MODULE$));
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getTopicMetadata$1(int brokerId) {
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(MetadataCacheTest.endpoints$2(brokerId)).asJava()).setRack("rack1");
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$3(String topic$2, UpdateMetadataRequestData.UpdateMetadataPartitionState ps) {
        String string = ps.topicName();
        return !(string != null ? !string.equals(topic$2) : topic$2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getTopicMetadata$6(int partitionId$1, UpdateMetadataRequestData.UpdateMetadataPartitionState x$3) {
        return x$3.partitionIndex() == partitionId$1;
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$5(Seq topicPartitionStates$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            MetadataResponseData.MetadataResponsePartition partitionMetadata = (MetadataResponseData.MetadataResponsePartition)x0$1._1();
            int partitionId = x0$1._2$mcI$sp();
            Assertions.assertEquals((short)Errors.NONE.code(), (short)partitionMetadata.errorCode());
            Assertions.assertEquals((int)partitionId, (int)partitionMetadata.partitionIndex());
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)topicPartitionStates$1.find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$6(partitionId, x$3))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Nothing$)Assertions.fail((String)new StringBuilder(45).append("Unable to find partition state for partition ").append(partitionId).toString()));
            Assertions.assertEquals((int)partitionState.leader(), (int)partitionMetadata.leaderId());
            Assertions.assertEquals((int)partitionState.leaderEpoch(), (int)partitionMetadata.leaderEpoch());
            Assertions.assertEquals((Object)partitionState.isr(), (Object)partitionMetadata.isrNodes());
            Assertions.assertEquals((Object)partitionState.replicas(), (Object)partitionMetadata.replicaNodes());
            return;
        }
        throw new MatchError(null);
    }

    private static final void checkTopicMetadata$1(String topic, MetadataCache cache$1, ListenerName listenerName$1, HashMap topicIds$1, Seq partitionStates$1) {
        Seq topicMetadatas = cache$1.getTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), listenerName$1, cache$1.getTopicMetadata$default$3(), cache$1.getTopicMetadata$default$4());
        Assertions.assertEquals((int)1, (int)topicMetadatas.size());
        MetadataResponseData.MetadataResponseTopic topicMetadata = (MetadataResponseData.MetadataResponseTopic)topicMetadatas.head();
        Assertions.assertEquals((short)Errors.NONE.code(), (short)topicMetadata.errorCode());
        Assertions.assertEquals((Object)topic, (Object)topicMetadata.name());
        Assertions.assertEquals(topicIds$1.get(topic), (Object)topicMetadata.topicId());
        Seq topicPartitionStates = (Seq)partitionStates$1.filter((Function1 & Serializable & scala.Serializable)ps -> BoxesRunTime.boxToBoolean((boolean)MetadataCacheTest.$anonfun$getTopicMetadata$3(topic, ps)));
        Buffer partitionMetadatas = (Buffer)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(topicMetadata.partitions()).asScala()).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.partitionIndex()), (Ordering)Ordering.Int$.MODULE$);
        Assertions.assertEquals((int)topicPartitionStates.size(), (int)partitionMetadatas.size(), (String)new StringBuilder(37).append("Unexpected partition count for topic ").append(topic).toString());
        ((IterableLike)partitionMetadatas.zipWithIndex(Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MetadataCacheTest.$anonfun$getTopicMetadata$5(topicPartitionStates, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getTopicMetadata$2(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol);
        MetadataCacheTest.checkTopicMetadata$1(topic0$1, cache$1, listenerName, topicIds$1, partitionStates$1);
        MetadataCacheTest.checkTopicMetadata$1(topic1$1, cache$1, listenerName, topicIds$1, partitionStates$1);
    }

    public static final /* synthetic */ UpdateMetadataRequestData.UpdateMetadataBroker $anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(int brokerId) {
        SecurityProtocol securityProtocol = SecurityProtocol.PLAINTEXT;
        return new UpdateMetadataRequestData.UpdateMetadataBroker().setId(brokerId).setRack("").setEndpoints((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataEndpoint().setHost("foo").setPort(9092).setSecurityProtocol(securityProtocol.id).setListener(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol).value()), (List)Nil$.MODULE$)).asJava());
    }

    private final void updateCache$1(Seq brokerIds, String topic$3, MetadataCache cache$2) {
        Seq brokers = (Seq)brokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> MetadataCacheTest.$anonfun$getAliveBrokersShouldNotBeMutatedByUpdateCache$1(BoxesRunTime.unboxToInt((Object)brokerId)), Seq$.MODULE$.canBuildFrom());
        int controllerEpoch = 1;
        int leader = 0;
        int leaderEpoch = 0;
        java.util.List<Object> replicas = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0)});
        java.util.List<Object> isr = Arrays.asList((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)});
        .colon.colon partitionStates = new .colon.colon((Object)new UpdateMetadataRequestData.UpdateMetadataPartitionState().setTopicName(topic$3).setPartitionIndex(0).setControllerEpoch(controllerEpoch).setLeader(leader).setLeaderEpoch(leaderEpoch).setIsr(isr).setZkVersion(3).setReplicas(replicas), (List)Nil$.MODULE$);
        short version = ApiKeys.UPDATE_METADATA.latestVersion();
        UpdateMetadataRequest updateMetadataRequest = (UpdateMetadataRequest)new UpdateMetadataRequest.Builder(version, 2, controllerEpoch, this.brokerEpoch(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)partitionStates).asJava(), (java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(brokers).asJava(), Collections.emptyMap()).build();
        MetadataCacheTest$.MODULE$.updateCache(cache$2, updateMetadataRequest);
    }

    public MetadataCacheTest() {
        this.brokerEpoch = 0L;
    }

    public static final /* synthetic */ Object $anonfun$getTopicMetadata$2$adapted(MetadataCache cache$1, HashMap topicIds$1, Seq partitionStates$1, String topic0$1, String topic1$1, SecurityProtocol securityProtocol) {
        MetadataCacheTest.$anonfun$getTopicMetadata$2(cache$1, topicIds$1, partitionStates$1, topic0$1, topic1$1, securityProtocol);
        return BoxedUnit.UNIT;
    }
}

