/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.security.auth.login.Configuration;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KRaftQuorumImplementation;
import kafka.server.KafkaBroker;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaRaftServer$;
import kafka.server.MetaProperties;
import kafka.server.QuorumImplementation;
import kafka.server.QuorumTestHarness$;
import kafka.server.QuorumTestHarnessFaultHandlerFactory;
import kafka.server.SharedServer;
import kafka.server.ZooKeeperQuorumImplementation;
import kafka.tools.StorageTool$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.TestInfoUtils$;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.metadata.FeatureLevelRecord;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.common.MetadataVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.apache.kafka.server.fault.MockFaultHandler;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.client.ZKClientConfig;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@Tag(value="integration")
@ScalaSignature(bytes="\u0006\u0001\t-h!\u0002\u001f>\u0003\u0003\u0011\u0005\"B(\u0001\t\u0003\u0001\u0006bB*\u0001\u0005\u0004%\t\u0001\u0016\u0005\u00071\u0002\u0001\u000b\u0011B+\t\u000fe\u0003!\u0019!C\u0001)\"1!\f\u0001Q\u0001\nUCqa\u0017\u0001C\u0002\u0013\u0005A\u000b\u0003\u0004]\u0001\u0001\u0006I!\u0016\u0005\u0006;\u0002!\tB\u0018\u0005\bK\u0002\u0011\r\u0011\"\u0005g\u0011\u00191\b\u0001)A\u0005O\")q\u000f\u0001C\tq\"9\u0011q\u0002\u0001\u0005\u0012\u0005E\u0001bCA\u0010\u0001\u0001\u0007\t\u0019!C\u0005\u0003CA1\"a\u000e\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002:!Y\u0011Q\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0012\u0011-\t9\u0005\u0001a\u0001\u0002\u0004%I!!\u0013\t\u0017\u0005E\u0003\u00011AA\u0002\u0013%\u00111\u000b\u0005\f\u0003/\u0002\u0001\u0019!A!B\u0013\tY\u0005C\u0005\u0002Z\u0001\u0011\r\u0011\"\u0001\u0002\\!A\u0011q\u000e\u0001!\u0002\u0013\ti\u0006C\u0004\u0002r\u0001!\t!a\u001d\t\u000f\u0005U\u0004\u0001\"\u0001\u0002t!9\u0011q\u000f\u0001\u0005\u0002\u0005e\u0004bBA>\u0001\u0011\u0005\u0011\u0011\u0010\u0005\b\u0003{\u0002A\u0011BA@\u0011\u001d\t9\t\u0001C\u0005\u0003\u0013Cq!!%\u0001\t\u0003\t\u0019\nC\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005-\u0006\u0001\"\u0001\u0002$\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0006BBA\\\u0001\u0011\u0005A\u000bC\u0004\u0002:\u0002!\t!a/\t\u000f\u0005M\u0007\u0001\"\u0001\u0002<\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAp\u0001\u0011\u0005\u0011\u0011\u001d\u0005\n\u0003K\u0004!\u0019!C\u0001\u0003OD\u0001\"a<\u0001A\u0003%\u0011\u0011\u001e\u0005\n\u0003c\u0004!\u0019!C\u0001\u0003gD\u0001B!\u0001\u0001A\u0003%\u0011Q\u001f\u0005\b\u0005\u0007\u0001A\u0011\u0001B\u0003\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005'A\u0011B!\u0010\u0001#\u0003%\tAa\u0010\t\u0013\tU\u0003!%A\u0005\u0002\t]\u0003\"\u0003B.\u0001E\u0005I\u0011\u0001B/\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0003sBqAa\u0019\u0001\t\u0003\tI\bC\u0004\u0003f\u0001!\tAa\u001a\t\u000f\tE\u0004\u0001\"\u0003\u0003t!9!Q\u0012\u0001\u0005\n\t=\u0005b\u0002BJ\u0001\u0011%\u0011q\u0010\u0005\b\u0005+\u0003A\u0011AA=\u0011\u001d\u0011y\n\u0001C\u0001\u0005C;qAa0>\u0011\u0003\u0011\tM\u0002\u0004={!\u0005!1\u0019\u0005\u0007\u001fZ\"\tA!2\t\u0013\t\u001dgG1A\u0005\u0002\t%\u0007\u0002\u0003Bkm\u0001\u0006IAa3\t\u000f\t]g\u0007\"\u0001\u0002z!9!\u0011\u001d\u001c\u0005\u0002\u0005e$!E)v_J,X\u000eV3ti\"\u000b'O\\3tg*\u0011ahP\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0001\u000bQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0007&\u0003\"\u0001R$\u000e\u0003\u0015S\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u0013a!\u00118z%\u00164\u0007C\u0001&N\u001b\u0005Y%B\u0001'@\u0003\u0015)H/\u001b7t\u0013\tq5JA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005\t\u0006C\u0001*\u0001\u001b\u0005i\u0014a\u0005>l\u0007>tg.Z2uS>tG+[7f_V$X#A+\u0011\u0005\u00113\u0016BA,F\u0005\rIe\u000e^\u0001\u0015u.\u001cuN\u001c8fGRLwN\u001c+j[\u0016|W\u000f\u001e\u0011\u0002!i\\7+Z:tS>tG+[7f_V$\u0018!\u0005>l'\u0016\u001c8/[8o)&lWm\\;uA\u0005)\"p['bq&sg\t\\5hQR\u0014V-];fgR\u001c\u0018A\u0006>l\u001b\u0006D\u0018J\u001c$mS\u001eDGOU3rk\u0016\u001cHo\u001d\u0011\u0002\u001bi\\\u0017i\u00197t\u000b:\f'\r\\3e+\u0005y\u0006c\u0001#aE&\u0011\u0011-\u0012\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0011\u001b\u0017B\u00013F\u0005\u001d\u0011un\u001c7fC:\f!eY8oiJ|G\u000e\\3s\u0019&\u001cH/\u001a8feN+7-\u001e:jif\u0004&o\u001c;pG>dW#A4\u0011\u0005!$X\"A5\u000b\u0005)\\\u0017\u0001B1vi\"T!\u0001\\7\u0002\u0011M,7-\u001e:jifT!A\\8\u0002\r\r|W.\\8o\u0015\t\u0001\u0005O\u0003\u0002re\u00061\u0011\r]1dQ\u0016T\u0011a]\u0001\u0004_J<\u0017BA;j\u0005A\u0019VmY;sSRL\bK]8u_\u000e|G.A\u0012d_:$(o\u001c7mKJd\u0015n\u001d;f]\u0016\u00148+Z2ve&$\u0018\u0010\u0015:pi>\u001cw\u000e\u001c\u0011\u0002--\u0014\u0018M\u001a;D_:$(o\u001c7mKJ\u001cuN\u001c4jON$\u0012!\u001f\t\u0004uv|X\"A>\u000b\u0005q,\u0015AC2pY2,7\r^5p]&\u0011ap\u001f\u0002\u0004'\u0016\f\b\u0003BA\u0001\u0003\u0017i!!a\u0001\u000b\t\u0005\u0015\u0011qA\u0001\u0005kRLGN\u0003\u0002\u0002\n\u0005!!.\u0019<b\u0013\u0011\ti!a\u0001\u0003\u0015A\u0013x\u000e]3si&,7/A\bnKR\fG-\u0019;b-\u0016\u00148/[8o+\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005mQBAA\f\u0015\rq\u0017\u0011\u0004\u0006\u0003}=LA!!\b\u0002\u0018\tyQ*\u001a;bI\u0006$\u0018MV3sg&|g.\u0001\u0005uKN$\u0018J\u001c4p+\t\t\u0019\u0003\u0005\u0003\u0002&\u0005MRBAA\u0014\u0015\u0011\tI#a\u000b\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002.\u0005=\u0012a\u00026va&$XM\u001d\u0006\u0004\u0003c\u0011\u0018!\u00026v]&$\u0018\u0002BA\u001b\u0003O\u0011\u0001\u0002V3ti&sgm\\\u0001\ri\u0016\u001cH/\u00138g_~#S-\u001d\u000b\u0005\u0003w\t\t\u0005E\u0002E\u0003{I1!a\u0010F\u0005\u0011)f.\u001b;\t\u0013\u0005\rc\"!AA\u0002\u0005\r\u0012a\u0001=%c\u0005IA/Z:u\u0013:4w\u000eI\u0001\u000fS6\u0004H.Z7f]R\fG/[8o+\t\tY\u0005E\u0002S\u0003\u001bJ1!a\u0014>\u0005Q\tVo\u001c:v[&k\u0007\u000f\\3nK:$\u0018\r^5p]\u0006\u0011\u0012.\u001c9mK6,g\u000e^1uS>tw\fJ3r)\u0011\tY$!\u0016\t\u0013\u0005\r\u0013#!AA\u0002\u0005-\u0013aD5na2,W.\u001a8uCRLwN\u001c\u0011\u0002!\t|w\u000e^:ue\u0006\u0004(+Z2pe\u0012\u001cXCAA/!\u0019\ty&!\u001a\u0002j5\u0011\u0011\u0011\r\u0006\u0004\u0003GZ\u0018aB7vi\u0006\u0014G.Z\u0005\u0005\u0003O\n\tG\u0001\u0006MSN$()\u001e4gKJ\u0004B!!\u0006\u0002l%!\u0011QNA\f\u0005Q\t\u0005/['fgN\fw-Z!oIZ+'o]5p]\u0006\t\"m\\8ugR\u0014\u0018\r\u001d*fG>\u0014Hm\u001d\u0011\u0002\u0017%\u001c8JU1giR+7\u000f\u001e\u000b\u0002E\u0006\t\u0012n\u001d.l\u001b&<'/\u0019;j_:$Vm\u001d;\u0002\u001b\rDWmY6Jgj[E+Z:u)\t\tY$\u0001\tdQ\u0016\u001c7.S:L%\u00064G\u000fV3ti\u0006!\u0011m\u001d.l)\t\t\t\tE\u0002S\u0003\u0007K1!!\">\u0005uQvn\\&fKB,'/U;peVl\u0017*\u001c9mK6,g\u000e^1uS>t\u0017aB1t\u0017J\u000bg\r\u001e\u000b\u0003\u0003\u0017\u00032AUAG\u0013\r\ty)\u0010\u0002\u001a\u0017J\u000bg\r^)v_J,X.S7qY\u0016lWM\u001c;bi&|g.A\u0005{_>\\W-\u001a9feV\u0011\u0011Q\u0013\t\u0005\u0003/\u000bi*\u0004\u0002\u0002\u001a*\u0019\u00111T \u0002\u0005i\\\u0017\u0002BAP\u00033\u0013\u0011#R7cK\u0012$W\r\u001a.p_.,W\r]3s\u0003!Q8n\u00117jK:$XCAAS!\u0011\t9*a*\n\t\u0005%\u0016\u0011\u0014\u0002\u000e\u0017\u000647.\u0019.l\u00072LWM\u001c;\u0002\u001di\\7\t\\5f]R|%OT;mY\u0006i\u0011\rZ7j]j[7\t\\5f]R,\"!!-\u0011\t\u0005]\u00151W\u0005\u0005\u0003k\u000bIJA\u0007BI6LgNW6DY&,g\u000e^\u0001\u0007u.\u0004vN\u001d;\u0002\u0013i\\7i\u001c8oK\u000e$XCAA_!\u0011\ty,!4\u000f\t\u0005\u0005\u0017\u0011\u001a\t\u0004\u0003\u0007,UBAAc\u0015\r\t9-Q\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-W)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\f\tN\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u0017,\u0015a\u0004>l\u0007>tg.Z2u\u001fJtU\u000f\u001c7\u0002!\r|g\u000e\u001e:pY2,'oU3sm\u0016\u0014XCAAm!\r\u0011\u00161\\\u0005\u0004\u0003;l$\u0001E\"p]R\u0014x\u000e\u001c7feN+'O^3s\u0003E\u0019wN\u001c;s_2dWM]*feZ,'o]\u000b\u0003\u0003G\u0004BA_?\u0002Z\u0006\u0019b-Y;mi\"\u000bg\u000e\u001a7fe\u001a\u000b7\r^8ssV\u0011\u0011\u0011\u001e\t\u0004%\u0006-\u0018bAAw{\t!\u0013+^8sk6$Vm\u001d;ICJtWm]:GCVdG\u000fS1oI2,'OR1di>\u0014\u00180\u0001\u000bgCVdG\u000fS1oI2,'OR1di>\u0014\u0018\u0010I\u0001\rM\u0006,H\u000e\u001e%b]\u0012dWM]\u000b\u0003\u0003k\u0004B!a>\u0002~6\u0011\u0011\u0011 \u0006\u0005\u0003w\fI\"A\u0003gCVdG/\u0003\u0003\u0002\u0000\u0006e(\u0001E'pG.4\u0015-\u001e7u\u0011\u0006tG\r\\3s\u000351\u0017-\u001e7u\u0011\u0006tG\r\\3sA\u0005)1/\u001a;VaR!\u00111\bB\u0004\u0011\u001d\ty\u0002\u000ba\u0001\u0003GA3\u0001\u000bB\u0006!\u0011\t)C!\u0004\n\t\t=\u0011q\u0005\u0002\u000b\u0005\u00164wN]3FC\u000eD\u0017\u0001D2sK\u0006$XM\u0011:pW\u0016\u0014HC\u0003B\u000b\u00057\u0011)Ca\r\u00038A\u0019!Ka\u0006\n\u0007\teQHA\u0006LC\u001a\\\u0017M\u0011:pW\u0016\u0014\bb\u0002B\u000fS\u0001\u0007!qD\u0001\u0007G>tg-[4\u0011\u0007I\u0013\t#C\u0002\u0003$u\u00121bS1gW\u0006\u001cuN\u001c4jO\"I!qE\u0015\u0011\u0002\u0003\u0007!\u0011F\u0001\u0005i&lW\r\u0005\u0003\u0003,\t=RB\u0001B\u0017\u0015\taU.\u0003\u0003\u00032\t5\"\u0001\u0002+j[\u0016D\u0001B!\u000e*!\u0003\u0005\rAY\u0001\bgR\f'\u000f^;q\u0011%\u0011I$\u000bI\u0001\u0002\u0004\u0011Y$\u0001\tuQJ,\u0017\r\u001a(b[\u0016\u0004&/\u001a4jqB!A\tYA_\u0003Y\u0019'/Z1uK\n\u0013xn[3sI\u0011,g-Y;mi\u0012\u0012TC\u0001B!U\u0011\u0011ICa\u0011,\u0005\t\u0015\u0003\u0003\u0002B$\u0005#j!A!\u0013\u000b\t\t-#QJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0014F\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005'\u0012IEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fac\u0019:fCR,'I]8lKJ$C-\u001a4bk2$HeM\u000b\u0003\u00053R3A\u0019B\"\u0003Y\u0019'/Z1uK\n\u0013xn[3sI\u0011,g-Y;mi\u0012\"TC\u0001B0U\u0011\u0011YDa\u0011\u0002#MDW\u000f\u001e3po:Tvn\\&fKB,'/A\ftQV$Hm\\<o\u0017J\u000bg\r^\"p]R\u0014x\u000e\u001c7fe\u00069r\u000e\u001d;j_:\fG.T3uC\u0012\fG/\u0019*fG>\u0014Hm]\u000b\u0003\u0005S\u0002B\u0001\u00121\u0003lA1\u0011q\fB7\u0003SJAAa\u001c\u0002b\tY\u0011I\u001d:bs\n+hMZ3s\u0003E1wN]7bi\u0012K'/Z2u_JLWm\u001d\u000b\u0007\u0003w\u0011)Ha!\t\u000f\t]\u0004\u00071\u0001\u0003z\u0005YA-\u001b:fGR|'/[3t!\u0019\u0011YH!!\u0002>6\u0011!Q\u0010\u0006\u0004\u0005\u007fZ\u0018!C5n[V$\u0018M\u00197f\u0013\rq(Q\u0010\u0005\b\u0005\u000b\u0003\u0004\u0019\u0001BD\u00039iW\r^1Qe>\u0004XM\u001d;jKN\u00042A\u0015BE\u0013\r\u0011Y)\u0010\u0002\u000f\u001b\u0016$\u0018\r\u0015:pa\u0016\u0014H/[3t\u00039qWm^&SC\u001a$\u0018+^8sk6$B!a#\u0003\u0012\"9\u0011qD\u0019A\u0002\u0005\r\u0012A\u00058foj{wnS3fa\u0016\u0014\u0018+^8sk6\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0004g\te\u0005\u0003BA\u0013\u00057KAA!(\u0002(\tI\u0011I\u001a;fe\u0016\u000b7\r[\u0001,GJ,\u0017\r^3[_>\\U-\u001a9fe\u000ec\u0017.\u001a8u)>$&/[4hKJ\u001cVm]:j_:,\u0005\u0010]5ssR!!1\u0015BW!\u0011\u0011)K!+\u000e\u0005\t\u001d&bAAIa&!!1\u0016BT\u0005%Qvn\\&fKB,'\u000fC\u0004\u00030R\u0002\rAa)\u0002\u0013i|wnS3fa\u0016\u0014\bf\u0002\u0001\u00034\ne&1\u0018\t\u0005\u0003K\u0011),\u0003\u0003\u00038\u0006\u001d\"a\u0001+bO\u0006)a/\u00197vK\u0006\u0012!QX\u0001\fS:$Xm\u001a:bi&|g.A\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\u0004\"A\u0015\u001c\u0014\u0005Y\u001aEC\u0001Ba\u0003eQ6n\u00117jK:$XI^3oiRC'/Z1e'V4g-\u001b=\u0016\u0005\t-\u0007\u0003\u0002Bg\u0005'l!Aa4\u000b\t\tE\u0017qA\u0001\u0005Y\u0006tw-\u0003\u0003\u0002P\n=\u0017A\u0007.l\u00072LWM\u001c;Fm\u0016tG\u000f\u00165sK\u0006$7+\u001e4gSb\u0004\u0013AC:fiV\u00038\t\\1tg\"\u001a!Ha7\u0011\t\u0005\u0015\"Q\\\u0005\u0005\u0005?\f9CA\u0005CK\u001a|'/Z!mY\u0006iA/Z1s\t><hn\u00117bgND3a\u000fBs!\u0011\t)Ca:\n\t\t%\u0018q\u0005\u0002\t\u0003\u001a$XM]!mY\u0002")
public abstract class QuorumTestHarness
implements Logging {
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private final int zkMaxInFlightRequests;
    private final SecurityProtocol controllerListenerSecurityProtocol;
    private TestInfo testInfo;
    private QuorumImplementation implementation;
    private final ListBuffer<ApiMessageAndVersion> bootstrapRecords;
    private final QuorumTestHarnessFaultHandlerFactory faultHandlerFactory;
    private final MockFaultHandler faultHandler;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @AfterAll
    public static void tearDownClass() {
        QuorumTestHarness$.MODULE$.tearDownClass();
    }

    @BeforeAll
    public static void setUpClass() {
        QuorumTestHarness$.MODULE$.setUpClass();
    }

    public static String ZkClientEventThreadSuffix() {
        return QuorumTestHarness$.MODULE$.ZkClientEventThreadSuffix();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    public int zkMaxInFlightRequests() {
        return this.zkMaxInFlightRequests;
    }

    public Option<Object> zkAclsEnabled() {
        return None$.MODULE$;
    }

    public SecurityProtocol controllerListenerSecurityProtocol() {
        return this.controllerListenerSecurityProtocol;
    }

    public Seq<Properties> kraftControllerConfigs() {
        return new .colon.colon((Object)new Properties(), (List)Nil$.MODULE$);
    }

    public MetadataVersion metadataVersion() {
        return MetadataVersion.latest();
    }

    private TestInfo testInfo() {
        return this.testInfo;
    }

    private void testInfo_$eq(TestInfo x$1) {
        this.testInfo = x$1;
    }

    private QuorumImplementation implementation() {
        return this.implementation;
    }

    private void implementation_$eq(QuorumImplementation x$1) {
        this.implementation = x$1;
    }

    public ListBuffer<ApiMessageAndVersion> bootstrapRecords() {
        return this.bootstrapRecords;
    }

    public boolean isKRaftTest() {
        return TestInfoUtils$.MODULE$.isKRaft(this.testInfo());
    }

    public boolean isZkMigrationTest() {
        return TestInfoUtils$.MODULE$.isZkMigrationTest(this.testInfo());
    }

    public void checkIsZKTest() {
        if (this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in KRaft mode. ZooKeeper mode is required.");
        }
    }

    public void checkIsKRaftTest() {
        if (!this.isKRaftTest()) {
            throw new RuntimeException("This function can't be accessed when running the test in ZooKeeper mode. KRaft mode is required.");
        }
    }

    private ZooKeeperQuorumImplementation asZk() {
        this.checkIsZKTest();
        return (ZooKeeperQuorumImplementation)this.implementation();
    }

    private KRaftQuorumImplementation asKRaft() {
        this.checkIsKRaftTest();
        return (KRaftQuorumImplementation)this.implementation();
    }

    public EmbeddedZookeeper zookeeper() {
        return this.asZk().zookeeper();
    }

    public KafkaZkClient zkClient() {
        return this.asZk().zkClient();
    }

    public KafkaZkClient zkClientOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.asZk().zkClient();
    }

    public AdminZkClient adminZkClient() {
        return this.asZk().adminZkClient();
    }

    public int zkPort() {
        return this.asZk().zookeeper().port();
    }

    public String zkConnect() {
        return new StringBuilder(10).append("127.0.0.1:").append(this.zkPort()).toString();
    }

    public String zkConnectOrNull() {
        if (this.isKRaftTest()) {
            return null;
        }
        return this.zkConnect();
    }

    public ControllerServer controllerServer() {
        return this.asKRaft().controllerServer();
    }

    public Seq<ControllerServer> controllerServers() {
        if (this.isKRaftTest()) {
            return new .colon.colon((Object)this.asKRaft().controllerServer(), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public QuorumTestHarnessFaultHandlerFactory faultHandlerFactory() {
        return this.faultHandlerFactory;
    }

    public MockFaultHandler faultHandler() {
        return this.faultHandler;
    }

    @BeforeEach
    public void setUp(TestInfo testInfo) {
        this.testInfo_$eq(testInfo);
        Exit.setExitProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("exit(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        Exit.setHaltProcedure((code, message) -> {
            try {
                try {
                    throw new RuntimeException(new StringBuilder(16).append("halt(").append(code).append(", ").append(message).append(") called!").toString());
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "test error", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    throw e;
                }
            }
            catch (Throwable throwable) {
                this.tearDown();
                throw throwable;
            }
        });
        String name = (String)OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(testInfo.getTestMethod())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "[unspecified]");
        if (TestInfoUtils$.MODULE$.isKRaft(testInfo)) {
            this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Running KRAFT test ").append(name).toString());
            this.implementation_$eq(this.newKRaftQuorum(testInfo));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Running ZK test ").append(name).toString());
        this.implementation_$eq(this.newZooKeeperQuorum());
    }

    public KafkaBroker createBroker(KafkaConfig config, Time time, boolean startup, Option<String> threadNamePrefix) {
        return this.implementation().createBroker(config, time, startup, threadNamePrefix);
    }

    public Time createBroker$default$2() {
        return Time.SYSTEM;
    }

    public boolean createBroker$default$3() {
        return true;
    }

    public Option<String> createBroker$default$4() {
        return None$.MODULE$;
    }

    public void shutdownZooKeeper() {
        this.asZk().shutdown();
    }

    public void shutdownKRaftController() {
        KRaftQuorumImplementation kRaftQuorumImplementation = this.asKRaft();
        CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> kRaftQuorumImplementation.controllerServer().shutdown(), kRaftQuorumImplementation.log(), CoreUtils$.MODULE$.swallow$default$3());
    }

    public Option<ArrayBuffer<ApiMessageAndVersion>> optionalMetadataRecords() {
        return None$.MODULE$;
    }

    private void formatDirectories(scala.collection.immutable.Seq<String> directories, MetaProperties metaProperties) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        PrintStream out = null;
        try {
            out = new PrintStream(stream);
            BootstrapMetadata bootstrapMetadata = StorageTool$.MODULE$.buildBootstrapMetadata(this.metadataVersion(), this.optionalMetadataRecords(), "format command");
            if (StorageTool$.MODULE$.formatCommand(out, directories, metaProperties, bootstrapMetadata, this.metadataVersion(), false) != 0) {
                throw new RuntimeException(stream.toString());
            }
            this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Formatted storage directory(ies) ").append(directories).toString());
        }
        catch (Throwable throwable) {
            if (out != null) {
                out.close();
            }
            stream.close();
            throw throwable;
        }
        out.close();
        stream.close();
    }

    private KRaftQuorumImplementation newKRaftQuorum(TestInfo testInfo) {
        Seq<Properties> propsList = this.kraftControllerConfigs();
        if (propsList.size() != 1) {
            throw new RuntimeException("Only one KRaft controller is supported for now.");
        }
        Properties props = (Properties)propsList.apply(0);
        props.setProperty(KafkaConfig$.MODULE$.ServerMaxStartupTimeMsProp(), Long.toString(TimeUnit.MINUTES.toMillis(10L)));
        props.setProperty(KafkaConfig$.MODULE$.ProcessRolesProp(), "controller");
        if (props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()) == null) {
            props.setProperty(KafkaConfig$.MODULE$.NodeIdProp(), "1000");
        }
        int nodeId = Integer.parseInt(props.getProperty(KafkaConfig$.MODULE$.NodeIdProp()));
        File metadataDir = TestUtils$.MODULE$.tempDir();
        MetaProperties metaProperties = new MetaProperties(Uuid.randomUuid().toString(), nodeId);
        this.formatDirectories((scala.collection.immutable.Seq<String>)new .colon.colon((Object)metadataDir.getAbsolutePath(), (List)Nil$.MODULE$), metaProperties);
        ArrayList<ApiMessageAndVersion> metadataRecords = new ArrayList<ApiMessageAndVersion>();
        metadataRecords.add(new ApiMessageAndVersion((ApiMessage)new FeatureLevelRecord().setName("metadata.version").setFeatureLevel(this.metadataVersion().featureLevel()), (short)0));
        this.optionalMetadataRecords().foreach((Function1 & Serializable & scala.Serializable)metadataArguments -> {
            metadataArguments.foreach((Function1 & Serializable & scala.Serializable)record -> BoxesRunTime.boxToBoolean((boolean)metadataRecords$1.add(record)));
            return BoxedUnit.UNIT;
        });
        BootstrapMetadata bootstrapMetadata = BootstrapMetadata.fromRecords(metadataRecords, (String)"test harness");
        props.setProperty(KafkaConfig$.MODULE$.MetadataLogDirProp(), metadataDir.getAbsolutePath());
        String proto = this.controllerListenerSecurityProtocol().toString();
        props.setProperty(KafkaConfig$.MODULE$.ListenerSecurityProtocolMapProp(), new StringBuilder(11).append("CONTROLLER:").append(proto).toString());
        props.setProperty(KafkaConfig$.MODULE$.ListenersProp(), "CONTROLLER://localhost:0");
        props.setProperty(KafkaConfig$.MODULE$.ControllerListenerNamesProp(), "CONTROLLER");
        props.setProperty(KafkaConfig$.MODULE$.QuorumVotersProp(), new StringBuilder(12).append(nodeId).append("@localhost:0").toString());
        KafkaConfig config = new KafkaConfig((Map)props);
        CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture = new CompletableFuture<Map<Integer, RaftConfig.AddressSpec>>();
        SharedServer sharedServer = new SharedServer(config, metaProperties, Time.SYSTEM, new Metrics(), controllerQuorumVotersFuture, (FaultHandlerFactory)this.faultHandlerFactory());
        ObjectRef controllerServer = ObjectRef.create(null);
        try {
            controllerServer.elem = new ControllerServer(sharedServer, KafkaRaftServer$.MODULE$.configSchema(), bootstrapMetadata);
            ((ControllerServer)controllerServer.elem).socketServerFirstBoundPortFuture().whenComplete((port, e) -> {
                if (e != null) {
                    this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error completing controller socket server future", (Function0<Throwable>)(Function0 & Serializable & scala.Serializable)() -> e);
                    controllerQuorumVotersFuture.completeExceptionally((Throwable)e);
                    return;
                }
                controllerQuorumVotersFuture.complete(Collections.singletonMap(Predef$.MODULE$.int2Integer(nodeId), new RaftConfig.InetAddressSpec(new InetSocketAddress("localhost", Predef$.MODULE$.Integer2int(port)))));
            });
            ((ControllerServer)controllerServer.elem).startup();
        }
        catch (Throwable e2) {
            if ((ControllerServer)controllerServer.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((ControllerServer)controllerServer$1.elem).shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> sharedServer.stopForController(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            throw e2;
        }
        return new KRaftQuorumImplementation((ControllerServer)controllerServer.elem, this.faultHandlerFactory(), metadataDir, controllerQuorumVotersFuture, metaProperties.clusterId(), this, (FaultHandler)this.faultHandler());
    }

    private ZooKeeperQuorumImplementation newZooKeeperQuorum() {
        AdminZkClient adminZkClient;
        EmbeddedZookeeper zookeeper = new EmbeddedZookeeper();
        ObjectRef zkClient = ObjectRef.create(null);
        String zkConnect = new StringBuilder(10).append("127.0.0.1:").append(zookeeper.port()).toString();
        try {
            zkClient.elem = KafkaZkClient$.MODULE$.apply(zkConnect, BoxesRunTime.unboxToBoolean((Object)this.zkAclsEnabled().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> JaasUtils.isZkSaslEnabled())), this.zkSessionTimeout(), this.zkConnectionTimeout(), this.zkMaxInFlightRequests(), Time.SYSTEM, "ZooKeeperTestHarness", new ZKClientConfig(), KafkaZkClient$.MODULE$.apply$default$9(), KafkaZkClient$.MODULE$.apply$default$10(), KafkaZkClient$.MODULE$.apply$default$11());
            adminZkClient = new AdminZkClient((KafkaZkClient)zkClient.elem);
        }
        catch (Throwable t) {
            CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> zookeeper.shutdown(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            if ((KafkaZkClient)zkClient.elem != null) {
                CoreUtils$.MODULE$.swallow((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((KafkaZkClient)zkClient$1.elem).close(), (Logging)this, CoreUtils$.MODULE$.swallow$default$3());
            }
            throw t;
        }
        return new ZooKeeperQuorumImplementation(zookeeper, zkConnect, (KafkaZkClient)zkClient.elem, adminZkClient, this);
    }

    @AfterEach
    public void tearDown() {
        Exit.resetExitProcedure();
        Exit.resetHaltProcedure();
        if (this.implementation() != null) {
            this.implementation().shutdown();
        }
        TestUtils$.MODULE$.clearYammerMetrics();
        System.clearProperty("java.security.auth.login.config");
        Configuration.setConfiguration(null);
        this.faultHandler().maybeRethrowFirstException();
    }

    /*
     * WARNING - void declaration
     */
    public ZooKeeper createZooKeeperClientToTriggerSessionExpiry(ZooKeeper zooKeeper) {
        void var3_3;
        Watcher dummyWatcher = new Watcher(null){

            public void process(WatchedEvent event) {
            }
        };
        ZooKeeper anotherZkClient = new ZooKeeper(this.zkConnect(), 1000, dummyWatcher, zooKeeper.getSessionId(), zooKeeper.getSessionPasswd());
        Assertions.assertNull((Object)anotherZkClient.exists("/nonexistent", false));
        return var3_3;
    }

    public QuorumTestHarness() {
        Logging.$init$((Logging)this);
        this.zkConnectionTimeout = 10000;
        this.zkSessionTimeout = 15000;
        this.zkMaxInFlightRequests = Integer.MAX_VALUE;
        this.controllerListenerSecurityProtocol = SecurityProtocol.PLAINTEXT;
        this.bootstrapRecords = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.faultHandlerFactory = new QuorumTestHarnessFaultHandlerFactory(new MockFaultHandler("quorumTestHarnessFaultHandler"));
        this.faultHandler = this.faultHandlerFactory().faultHandler();
    }
}

