/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import kafka.common.InconsistentBrokerMetadataException;
import kafka.common.InconsistentClusterIdException;
import kafka.server.BrokerMetadataCheckpoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.KafkaServer$;
import kafka.server.QuorumTestHarness;
import kafka.server.RawMetaProperties;
import kafka.server.ZkMetaProperties;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001B\u000e\u001d\u0001\u0005BQA\n\u0001\u0005\u0002\u001dB\u0011\"\u000b\u0001A\u0002\u0003\u0007I\u0011\u0001\u0016\t\u00139\u0002\u0001\u0019!a\u0001\n\u0003y\u0003\"\u0003\u001d\u0001\u0001\u0004\u0005\t\u0015)\u0003,\u0011%I\u0004\u00011AA\u0002\u0013\u0005!\u0006C\u0005;\u0001\u0001\u0007\t\u0019!C\u0001w!IQ\b\u0001a\u0001\u0002\u0003\u0006Ka\u000b\u0005\n}\u0001\u0001\r\u00111A\u0005\u0002)B\u0011b\u0010\u0001A\u0002\u0003\u0007I\u0011\u0001!\t\u0013\t\u0003\u0001\u0019!A!B\u0013Y\u0003bB\"\u0001\u0001\u0004%\t\u0001\u0012\u0005\b\u001d\u0002\u0001\r\u0011\"\u0001P\u0011\u0019\t\u0006\u0001)Q\u0005\u000b\"9!\u000b\u0001b\u0001\n\u0003\u0019\u0006B\u0002/\u0001A\u0003%A\u000bC\u0003^\u0001\u0011\u0005c\fC\u0003r\u0001\u0011\u0005#\u000fC\u0003x\u0001\u0011\u0005!\u000fC\u0003}\u0001\u0011\u0005!\u000fC\u0003\u007f\u0001\u0011\u0005!\u000f\u0003\u0004\u0002\u0002\u0001!\tA\u001d\u0005\u0007\u0003\u000b\u0001A\u0011\u0001:\t\r\u0005%\u0001\u0001\"\u0001s\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\u0004\u0001\t\u0003\tI\u0004C\u0004\u0002D\u0001!\t!!\u0012\u00037M+'O^3s\u000f\u0016tWM]1uK\u000ecWo\u001d;fe&#G+Z:u\u0015\tib$\u0001\u0004tKJ4XM\u001d\u0006\u0002?\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001#!\t\u0019C%D\u0001\u001d\u0013\t)CDA\tRk>\u0014X/\u001c+fgRD\u0015M\u001d8fgN\fa\u0001P5oSRtD#\u0001\u0015\u0011\u0005\r\u0002\u0011aB2p]\u001aLw-M\u000b\u0002WA\u00111\u0005L\u0005\u0003[q\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006Y1m\u001c8gS\u001e\ft\fJ3r)\t\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0003V]&$\bbB\u001c\u0004\u0003\u0003\u0005\raK\u0001\u0004q\u0012\n\u0014\u0001C2p]\u001aLw-\r\u0011\u0002\u000f\r|gNZ5he\u0005Y1m\u001c8gS\u001e\u0014t\fJ3r)\t\u0001D\bC\u00048\r\u0005\u0005\t\u0019A\u0016\u0002\u0011\r|gNZ5he\u0001\nqaY8oM&<7'A\u0006d_:4\u0017nZ\u001a`I\u0015\fHC\u0001\u0019B\u0011\u001d9\u0014\"!AA\u0002-\n\u0001bY8oM&<7\u0007I\u0001\bg\u0016\u0014h/\u001a:t+\u0005)\u0005c\u0001$J\u00176\tqI\u0003\u0002Ie\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005);%aA*fcB\u00111\u0005T\u0005\u0003\u001br\u00111bS1gW\u0006\u001cVM\u001d<fe\u0006Y1/\u001a:wKJ\u001cx\fJ3r)\t\u0001\u0004\u000bC\u00048\u0019\u0005\u0005\t\u0019A#\u0002\u0011M,'O^3sg\u0002\n1C\u0019:pW\u0016\u0014X*\u001a;b!J|\u0007o\u001d$jY\u0016,\u0012\u0001\u0016\t\u0003+jk\u0011A\u0016\u0006\u0003/b\u000bA\u0001\\1oO*\t\u0011,\u0001\u0003kCZ\f\u0017BA.W\u0005\u0019\u0019FO]5oO\u0006!\"M]8lKJlU\r^1Qe>\u00048OR5mK\u0002\nQa]3u+B$\"\u0001M0\t\u000b\u0001\u0004\u0002\u0019A1\u0002\u0011Q,7\u000f^%oM>\u0004\"AY6\u000e\u0003\rT!\u0001Z3\u0002\u0007\u0005\u0004\u0018N\u0003\u0002gO\u00069!.\u001e9ji\u0016\u0014(B\u00015j\u0003\u0015QWO\\5u\u0015\u0005Q\u0017aA8sO&\u0011An\u0019\u0002\t)\u0016\u001cH/\u00138g_\"\u0012\u0001C\u001c\t\u0003E>L!\u0001]2\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005\u0001\u0004FA\tu!\t\u0011W/\u0003\u0002wG\nI\u0011I\u001a;fe\u0016\u000b7\r[\u0001\u001ai\u0016\u001cH/Q;u_\u001e+g.\u001a:bi\u0016\u001cE.^:uKJLE\r\u000b\u0002\u0013sB\u0011!M_\u0005\u0003w\u000e\u0014A\u0001V3ti\u0006\u0011D/Z:u\u0003V$xnR3oKJ\fG/Z\"mkN$XM]%e\r>\u00148*\u00194lC\u000ecWo\u001d;feN+\u0017/^3oi&\fG\u000e\u000b\u0002\u0014s\u0006\u0001D/Z:u\u0003V$xnR3oKJ\fG/Z\"mkN$XM]%e\r>\u00148*\u00194lC\u000ecWo\u001d;feB\u000b'/\u00197mK2D#\u0001F=\u0002iQ,7\u000f^\"p]NL7\u000f^3oi\u000ecWo\u001d;fe&#gI]8n5>|7.Z3qKJ\fe\u000e\u001a$s_6lU\r^1Qe>\u00048\u000f\u000b\u0002\u0016s\u00061D/Z:u\u0013:\u001cwN\\:jgR,g\u000e^\"mkN$XM]%e\rJ|WNW8pW\u0016,\u0007/\u001a:B]\u00124%o\\7NKR\f\u0007K]8qg\"\u0012a#_\u00015i\u0016\u001cH/\u00138d_:\u001c\u0018n\u001d;f]R\u0014%o\\6fe6+G/\u00193bi\u0006\u0014U\r^<fK:lU\u000f\u001c;ja2,Gj\\4ESJ\u001c\bFA\fz\u0003M1wN]4f\u0005J|7.\u001a:NKR\fG-\u0019;b)\u001d\u0001\u0014\u0011CA\u0016\u0003kAq!a\u0005\u0019\u0001\u0004\t)\"A\u0004m_\u001e$\u0015N]:\u0011\t\u0019K\u0015q\u0003\t\u0005\u00033\t9C\u0004\u0003\u0002\u001c\u0005\r\u0002cAA\u000fe5\u0011\u0011q\u0004\u0006\u0004\u0003C\u0001\u0013A\u0002\u001fs_>$h(C\u0002\u0002&I\na\u0001\u0015:fI\u00164\u0017bA.\u0002*)\u0019\u0011Q\u0005\u001a\t\u000f\u00055\u0002\u00041\u0001\u00020\u0005A!M]8lKJLE\rE\u00022\u0003cI1!a\r3\u0005\rIe\u000e\u001e\u0005\b\u0003oA\u0002\u0019AA\f\u0003%\u0019G.^:uKJLE\rF\u00041\u0003w\ty$!\u0011\t\u000f\u0005u\u0012\u00041\u0001\u0002\u0018\u00051An\\4ESJDq!!\f\u001a\u0001\u0004\ty\u0003C\u0004\u00028e\u0001\r!a\u0006\u0002)Y,'/\u001b4z\u0005J|7.\u001a:NKR\fG-\u0019;b)\u0019\t9%!\u0014\u0002PA\u0019\u0011'!\u0013\n\u0007\u0005-#GA\u0004C_>dW-\u00198\t\u000f\u0005M!\u00041\u0001\u0002\u0016!9\u0011q\u0007\u000eA\u0002\u0005]\u0001")
public class ServerGenerateClusterIdTest
extends QuorumTestHarness {
    private KafkaConfig config1;
    private KafkaConfig config2;
    private KafkaConfig config3;
    private Seq<KafkaServer> servers = Nil$.MODULE$;
    private final String brokerMetaPropsFile;

    public KafkaConfig config1() {
        return this.config1;
    }

    public void config1_$eq(KafkaConfig x$1) {
        this.config1 = x$1;
    }

    public KafkaConfig config2() {
        return this.config2;
    }

    public void config2_$eq(KafkaConfig x$1) {
        this.config2 = x$1;
    }

    public KafkaConfig config3() {
        return this.config3;
    }

    public void config3_$eq(KafkaConfig x$1) {
        this.config3 = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String brokerMetaPropsFile() {
        return this.brokerMetaPropsFile;
    }

    @Override
    @BeforeEach
    public void setUp(TestInfo testInfo) {
        super.setUp(testInfo);
        this.config1_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())));
        this.config2_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(2, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())));
        this.config3_$eq(KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(3, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21())));
    }

    @Override
    @AfterEach
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers(), TestUtils$.MODULE$.shutdownServers$default$2());
        super.tearDown();
    }

    @Test
    public void testAutoGenerateClusterId() {
        Assertions.assertFalse((boolean)this.zkClient().getClusterId().isDefined());
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        String clusterIdOnFirstBoot = server1.clusterId();
        TestUtils.isValidClusterId((String)clusterIdOnFirstBoot);
        server1.shutdown();
        Assertions.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assertions.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)Nil$.MODULE$));
        String clusterIdOnSecondBoot = server1.clusterId();
        Assertions.assertEquals((Object)clusterIdOnFirstBoot, (Object)clusterIdOnSecondBoot);
        server1.shutdown();
        Assertions.assertTrue((boolean)this.zkClient().getClusterId().isDefined());
        Assertions.assertEquals((Object)this.zkClient().getClusterId(), (Object)new Some((Object)clusterIdOnFirstBoot));
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testAutoGenerateClusterIdForKafkaClusterSequential() {
        KafkaServer server1 = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer1 = server1.clusterId();
        KafkaServer server2 = TestUtils$.MODULE$.createServer(this.config2(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer2 = server2.clusterId();
        KafkaServer server3 = TestUtils$.MODULE$.createServer(this.config3(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterIdFromServer3 = server3.clusterId();
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)server1, (List)new .colon.colon((Object)server2, (List)new .colon.colon((Object)server3, (List)Nil$.MODULE$))));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)clusterIdFromServer2, (String)clusterIdFromServer3);
        server1.startup();
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)server1.clusterId());
        server2.startup();
        Assertions.assertEquals((Object)clusterIdFromServer2, (Object)server2.clusterId());
        server3.startup();
        Assertions.assertEquals((Object)clusterIdFromServer3, (Object)server3.clusterId());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            x$2.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoGenerateClusterIdForKafkaClusterParallel() {
        void var6_6;
        void var5_5;
        void var4_4;
        Future firstBoot = Future$.MODULE$.traverse((TraversableOnce)new .colon.colon((Object)this.config1(), (List)new .colon.colon((Object)this.config2(), (List)new .colon.colon((Object)this.config3(), (List)Nil$.MODULE$))), (Function1 & Serializable & scala.Serializable)config -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> TestUtils$.MODULE$.createServer((KafkaConfig)config, (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName())), ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)firstBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        Seq<KafkaServer> seq = this.servers();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(3) != 0) {
            throw new MatchError(seq);
        }
        KafkaServer server1 = (KafkaServer)((SeqLike)some.get()).apply(0);
        KafkaServer server2 = (KafkaServer)((SeqLike)some.get()).apply(1);
        KafkaServer server3 = (KafkaServer)((SeqLike)some.get()).apply(2);
        void server12 = var4_4;
        void server22 = var5_5;
        void server32 = var6_6;
        String clusterIdFromServer1 = server12.clusterId();
        String clusterIdFromServer2 = server22.clusterId();
        String clusterIdFromServer3 = server32.clusterId();
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils.isValidClusterId((String)clusterIdFromServer1);
        Assertions.assertEquals((Object)clusterIdFromServer1, (Object)clusterIdFromServer2, (String)clusterIdFromServer3);
        Future secondBoot = Future$.MODULE$.traverse((TraversableOnce)new .colon.colon((Object)server12, (List)new .colon.colon((Object)server22, (List)new .colon.colon((Object)server32, (List)Nil$.MODULE$))), (Function1 & Serializable & scala.Serializable)server -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            server.startup();
            return server;
        }, ExecutionContext.Implicits$.MODULE$.global()), Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global());
        this.servers_$eq((Seq<KafkaServer>)((Seq)Await$.MODULE$.result((Awaitable)secondBoot, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(100)).second())));
        this.servers().foreach((Function1 & Serializable & scala.Serializable)server -> {
            ServerGenerateClusterIdTest.$anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(clusterIdFromServer1, server);
            return BoxedUnit.UNIT;
        });
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testConsistentClusterIdFromZookeeperAndFromMetaProps() {
        KafkaServer server = TestUtils$.MODULE$.createServer(this.config1(), (Option<String>)Option$.MODULE$.apply((Object)this.getClass().getName()));
        String clusterId = server.clusterId();
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), clusterId));
        server.shutdown();
        server.startup();
        Assertions.assertEquals((Object)clusterId, (Object)server.clusterId());
        Assertions.assertTrue((boolean)this.verifyBrokerMetadata((Seq<String>)server.config().logDirs(), server.clusterId()));
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentClusterIdFromZookeeperAndFromMetaProps() {
        this.forgeBrokerMetadata((Seq<String>)this.config1().logDirs(), this.config1().brokerId(), "aclusterid");
        KafkaConfig x$1 = this.config1();
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(x$1, x$3, x$2, x$4);
        Assertions.assertThrows(InconsistentClusterIdException.class, () -> server.startup());
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    @Test
    public void testInconsistentBrokerMetadataBetweenMultipleLogDirs() {
        String logDir1 = TestUtils$.MODULE$.tempDir().getAbsolutePath();
        String logDir2 = TestUtils$.MODULE$.tempDir().getAbsolutePath();
        String logDirs = new StringBuilder(1).append(logDir1).append(",").append(logDir2).toString();
        this.forgeBrokerMetadata(logDir1, 1, "ebwOKU-zSieInaFQh_qP4g");
        this.forgeBrokerMetadata(logDir2, 1, "blaOKU-zSieInaFQh_qP4g");
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18(), TestUtils$.MODULE$.createBrokerConfig$default$19(), TestUtils$.MODULE$.createBrokerConfig$default$20(), TestUtils$.MODULE$.createBrokerConfig$default$21());
        props.setProperty("log.dir", logDirs);
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Option x$2 = Option$.MODULE$.apply((Object)this.getClass().getName());
        Time x$3 = KafkaServer$.MODULE$.$lessinit$greater$default$2();
        boolean x$4 = KafkaServer$.MODULE$.$lessinit$greater$default$4();
        KafkaServer server = new KafkaServer(config, x$3, x$2, x$4);
        Assertions.assertThrows(InconsistentBrokerMetadataException.class, () -> server.startup());
        server.shutdown();
        TestUtils$.MODULE$.assertNoNonDaemonThreads(this.getClass().getName());
    }

    public void forgeBrokerMetadata(Seq<String> logDirs, int brokerId, String clusterId) {
        logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
            this.forgeBrokerMetadata(logDir, brokerId, clusterId);
            return BoxedUnit.UNIT;
        });
    }

    public void forgeBrokerMetadata(String logDir, int brokerId, String clusterId) {
        new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append(this.brokerMetaPropsFile()).toString())).write(new ZkMetaProperties(clusterId, brokerId).toProperties());
    }

    public boolean verifyBrokerMetadata(Seq<String> logDirs, String clusterId) {
        Object object = new Object();
        try {
            logDirs.foreach((Function1 & Serializable & scala.Serializable)logDir -> {
                ServerGenerateClusterIdTest.$anonfun$verifyBrokerMetadata$1(this, clusterId, object, logDir);
                return BoxedUnit.UNIT;
            });
            return true;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                return ex.value$mcZ$sp();
            }
            throw ex;
        }
    }

    public static final /* synthetic */ void $anonfun$testAutoGenerateClusterIdForKafkaClusterParallel$6(String clusterIdFromServer1$1, KafkaServer server) {
        Assertions.assertEquals((Object)clusterIdFromServer1$1, (Object)server.clusterId());
    }

    public static final /* synthetic */ boolean $anonfun$verifyBrokerMetadata$2(String clusterId$2, String x$6) {
        String string = x$6;
        return string == null ? clusterId$2 != null : !string.equals(clusterId$2);
    }

    public static final /* synthetic */ void $anonfun$verifyBrokerMetadata$1(ServerGenerateClusterIdTest $this, String clusterId$2, Object nonLocalReturnKey1$1, String logDir) {
        Option brokerMetadataOpt = new BrokerMetadataCheckpoint(new File(new StringBuilder(0).append(logDir).append(File.separator).append($this.brokerMetaPropsFile()).toString())).read();
        if (brokerMetadataOpt instanceof Some) {
            Properties properties = (Properties)((Some)brokerMetadataOpt).value();
            if (new RawMetaProperties(properties).clusterId().exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)ServerGenerateClusterIdTest.$anonfun$verifyBrokerMetadata$2(clusterId$2, x$6)))) {
                throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
            }
        } else {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, false);
        }
    }

    public ServerGenerateClusterIdTest() {
        this.brokerMetaPropsFile = "meta.properties";
    }
}

