/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.epoch;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpoint;
import org.apache.kafka.storage.internals.checkpoint.LeaderEpochCheckpointFile;
import org.apache.kafka.storage.internals.epoch.LeaderEpochFileCache;
import org.apache.kafka.storage.internals.log.EpochEntry;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u001a5\u0001mBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001C\u0002\u0013\u0005q\t\u0003\u0004T\u0001\u0001\u0006I\u0001\u0013\u0005\b)\u0002\u0011\r\u0011\"\u0003V\u0011\u0019y\u0006\u0001)A\u0005-\"9\u0001\r\u0001b\u0001\n\u0013\t\u0007BB4\u0001A\u0003%!\rC\u0003i\u0001\u0011\u0005\u0011\u000eC\u0003y\u0001\u0011\u0005\u0011\u000eC\u0003{\u0001\u0011\u0005\u0011\u000eC\u0003}\u0001\u0011\u0005\u0011\u000eC\u0003\u007f\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002\u0002\u0001!\t!\u001b\u0005\u0007\u0003\u000b\u0001A\u0011A5\t\r\u0005%\u0001\u0001\"\u0001j\u0011\u0019\ti\u0001\u0001C\u0001S\"1\u0011\u0011\u0003\u0001\u0005\u0002%Da!!\u0006\u0001\t\u0003I\u0007BBA\r\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002\u001e\u0001!\t!\u001b\u0005\u0007\u0003C\u0001A\u0011A5\t\r\u0005\u0015\u0002\u0001\"\u0001j\u0011\u0019\tI\u0003\u0001C\u0001S\"1\u0011Q\u0006\u0001\u0005\u0002%Da!!\r\u0001\t\u0003I\u0007bBA\u001b\u0001\u0011%\u0011q\u0007\u0005\u0007\u0003\u000b\u0003A\u0011A5\t\r\u0005%\u0005\u0001\"\u0001j\u0011\u0019\ti\t\u0001C\u0001S\"1\u0011\u0011\u0013\u0001\u0005\u0002%Da!!&\u0001\t\u0003I\u0007BBAM\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002\u001e\u0002!\t!\u001b\u0005\u0007\u0003C\u0003A\u0011A5\t\r\u0005\u0015\u0006\u0001\"\u0001j\u0011\u0019\tI\u000b\u0001C\u0001S\"1\u0011Q\u0016\u0001\u0005\u0002%Da!!-\u0001\t\u0003I\u0007BBA[\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002:\u0002!\t!\u001b\u0005\u0007\u0003{\u0003A\u0011A5\t\r\u0005\u0005\u0007\u0001\"\u0001j\u0011\u0019\t)\r\u0001C\u0001S\"1\u0011\u0011\u001a\u0001\u0005\u0002%Da!!4\u0001\t\u0003I\u0007BBAi\u0001\u0011\u0005\u0011\u000e\u0003\u0004\u0002V\u0002!\t!\u001b\u0005\u0007\u00033\u0004A\u0011A5\t\r\u0005u\u0007\u0001\"\u0001j\u0011\u0019\t\t\u000f\u0001C\u0001S\nAB*Z1eKJ,\u0005o\\2i\r&dWmQ1dQ\u0016$Vm\u001d;\u000b\u0005U2\u0014!B3q_\u000eD'BA\u001c9\u0003\u0019\u0019XM\u001d<fe*\t\u0011(A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001a\u0004CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\tB\u0011Q\tA\u0007\u0002i\u0005\u0011A\u000f]\u000b\u0002\u0011B\u0011\u0011*U\u0007\u0002\u0015*\u00111\nT\u0001\u0007G>lWn\u001c8\u000b\u0005ej%B\u0001(P\u0003\u0019\t\u0007/Y2iK*\t\u0001+A\u0002pe\u001eL!A\u0015&\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0019A\u000f\u001d\u0011\u0002\u0015\rDWmY6q_&tG/F\u0001W!\t9V,D\u0001Y\u0015\t!\u0016L\u0003\u0002[7\u0006I\u0011N\u001c;fe:\fGn\u001d\u0006\u000392\u000bqa\u001d;pe\u0006<W-\u0003\u0002_1\n)B*Z1eKJ,\u0005o\\2i\u0007\",7m\u001b9pS:$\u0018aC2iK\u000e\\\u0007o\\5oi\u0002\nQaY1dQ\u0016,\u0012A\u0019\t\u0003G\u0016l\u0011\u0001\u001a\u0006\u0003keK!A\u001a3\u0003)1+\u0017\rZ3s\u000bB|7\r\u001b$jY\u0016\u001c\u0015m\u00195f\u0003\u0019\u0019\u0017m\u00195fA\u0005\tB/Z:u!J,g/[8vg\u0016\u0003xn\u00195\u0015\u0003)\u0004\"!P6\n\u00051t$\u0001B+oSRD#\u0001\u00038\u0011\u0005=4X\"\u00019\u000b\u0005E\u0014\u0018aA1qS*\u00111\u000f^\u0001\bUV\u0004\u0018\u000e^3s\u0015\t)x*A\u0003kk:LG/\u0003\u0002xa\n!A+Z:u\u0003\u0015\u001a\bn\\;mI\u0006#G-\u00129pG\"\fe\u000eZ'fgN\fw-Z(gMN,G\u000fV8DC\u000eDW\r\u000b\u0002\n]\u0006q3\u000f[8vY\u0012\u0014V\r^;s]2{w-\u00128e\u001f\u001a47/\u001a;JM2\u000bG/Z:u\u000bB|7\r\u001b*fcV,7\u000f^3eQ\tQa.\u0001\u001btQ>,H\u000e\u001a*fiV\u0014h.\u00168eK\u001aLg.\u001a3PM\u001a\u001cX\r^%g+:$WMZ5oK\u0012,\u0005o\\2i%\u0016\fX/Z:uK\u0012D#a\u00038\u0002\u0005NDw.\u001e7e\u001d>$xJ^3soJLG/\u001a'pO\u0016sGm\u00144gg\u0016$hi\u001c:B\u0019\u0016\fG-\u001a:Fa>\u001c\u0007n\u00148dK&#\b*Y:CK\u0016t\u0017i]:jO:,G\r\u000b\u0002\r]\u0006\u00014\u000f[8vY\u0012,eNZ8sG\u0016luN\\8u_:L7-\u00197ms&s7M]3bg&twm\u0015;beR|eMZ:fiND#!\u00048\u0002yMDw.\u001e7e\u001d>$xJ^3soJLG/Z(gMN,GOR8s\u00032+\u0017\rZ3s\u000bB|7\r[(oG\u0016LE\u000fS1t\u0005\u0016,g.Q:tS\u001etW\r\u001a\u0015\u0003\u001d9\f\u0001f\u001d5pk2$'+\u001a;ve:,fn];qa>\u0014H/\u001a3JM:{W\t]8dQJ+7m\u001c:eK\u0012D#a\u00048\u0002\u0005NDw.\u001e7e%\u0016$XO\u001d8V]N,\b\u000f]8si\u0016$\u0017J\u001a(p\u000bB|7\r\u001b*fG>\u0014H-\u001a3B]\u0012,f\u000eZ3gS:,G-\u00129pG\"\u0014V-];fgR,G\r\u000b\u0002\u0011]\u0006A4\u000f[8vY\u0012\u0014V\r^;s]\u001aK'o\u001d;Fa>\u001c\u0007.\u00134SKF,Xm\u001d;fI\u0016\u0003xn\u00195MKN\u001cH\u000b[1o\r&\u00148\u000f^#q_\u000eD\u0007FA\to\u0003U\u001a\bn\\;mIR\u0013XO\\2bi\u0016Le-T1uG\"LgnZ#q_\u000eD')\u001e;FCJd\u0017.\u001a:Ti\u0006\u0014H/\u001b8h\u001f\u001a47/\u001a;)\u0005Iq\u0017\u0001S:i_VdGmR3u\r&\u00148\u000f^(gMN,Go\u00144Tk\n\u001cX-];f]R,\u0005o\\2i/\",gn\u00144gg\u0016$(+Z9vKN$X\r\u001a$peB\u0013XM^5pkN,\u0005o\\2iQ\t\u0019b.A#tQ>,H\u000e\u001a*fiV\u0014hNT3yi\u00063\u0018-\u001b7bE2,W\t]8dQ&3G\u000b[3sK&\u001bhj\\#yC\u000e$X\t]8dQ\u001a{'\u000f\u00165f\u001f:,'+Z9vKN$X\r\u001a\u0015\u0003)9\f!g\u001d5pk2$gj\u001c;Va\u0012\fG/Z#q_\u000eD\u0017I\u001c3Ti\u0006\u0014Ho\u00144gg\u0016$\u0018JZ%u\t&$gj\u001c;DQ\u0006tw-\u001a\u0015\u0003+9\fQi\u001d5pk2$'+\u001a;ve:LeN^1mS\u0012|eMZ:fi&3W\t]8dQ&\u001b(+Z9vKN$X\rZ,iS\u000eD\u0017j\u001d(pi\u000e+(O]3oi2LHK]1dW\u0016$\u0007F\u0001\fo\u0003%\u001a\bn\\;mIN+\b\u000f]8si\u0016\u0003xn\u00195t)\"\fG\u000fR8O_R\u001cF/\u0019:u\rJ|WNW3s_\"\u0012qC\\\u0001$g\"|W\u000f\u001c3QKJ\u001c\u0018n\u001d;Fa>\u001c\u0007n\u001d\"fi^,WM\\%ogR\fgnY3tQ\tAb.\u0001\u0016tQ>,H\u000eZ#oM>\u00148-Z'p]>$xN\\5dC2d\u00170\u00138de\u0016\f7/\u001b8h\u000bB|7\r[:)\u0005eq\u0017a\u0002;p)V\u0004H.Z\u000b\u0007\u0003s\t)%!\u0017\u0015\t\u0005m\u0012Q\f\t\b{\u0005u\u0012\u0011IA,\u0013\r\tyD\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u0005\r\u0013Q\t\u0007\u0001\t\u001d\t9E\u0007b\u0001\u0003\u0013\u0012\u0011aS\t\u0005\u0003\u0017\n\t\u0006E\u0002>\u0003\u001bJ1!a\u0014?\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!PA*\u0013\r\t)F\u0010\u0002\u0004\u0003:L\b\u0003BA\"\u00033\"q!a\u0017\u001b\u0005\u0004\tIEA\u0001W\u0011\u001d\tyF\u0007a\u0001\u0003C\nQ!\u001a8uef\u0004\u0002\"a\u0019\u0002\u0000\u0005\u0005\u0013q\u000b\b\u0005\u0003K\nIH\u0004\u0003\u0002h\u0005Md\u0002BA5\u0003_j!!a\u001b\u000b\u0007\u00055$(\u0001\u0004=e>|GOP\u0005\u0003\u0003c\nAA[1wC&!\u0011QOA<\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0014\u0002BA>\u0003{\n1!T1q\u0015\u0011\t)(a\u001e\n\t\u0005\u0005\u00151\u0011\u0002\u0006\u000b:$(/\u001f\u0006\u0005\u0003w\ni(A\u0015tQ>,H\u000eZ#oM>\u00148-Z(gMN,Go]%oGJ,\u0017m]3N_:|Go\u001c8jG\u0006dG.\u001f\u0015\u000379\fAg\u001d5pk2$\u0017J\\2sK\u0006\u001cX-\u00118e)J\f7m[#q_\u000eD7/Q:MK\u0006$WM]:DQ\u0006tw-Z'b]f$\u0016.\\3tQ\tab.\u0001\u001etQ>,H\u000eZ%oGJ,\u0017m]3B]\u0012$&/Y2l\u000bB|7\r[:Bg\u001a{G\u000e\\8xKJ\u0014VmY3jm\u0016\u001cX*\u00198z\u001b\u0016\u001c8/Y4fg\"\u0012QD\\\u0001:g\"|W\u000f\u001c3Ee>\u0004XI\u001c;sS\u0016\u001cxJ\\#q_\u000eD'i\\;oI\u0006\u0014\u0018p\u00165f]J+Wn\u001c<j]\u001ed\u0015\r^3ti\u0016sGO]5fg\"\u0012aD\\\u00014g\"|W\u000f\u001c3Qe\u0016\u001cXM\u001d<f%\u0016\u001cX\r^(gMN,Go\u00148DY\u0016\f'/R1sY&,7\u000f^%g\u001f:,W\t_5tiND#a\b8\u0002sMDw.\u001e7e+B$\u0017\r^3TCZ,Gm\u00144gg\u0016$x\u000b[3o\u001f\u001a47/\u001a;U_\u000ecW-\u0019:U_&\u001b()\u001a;xK\u0016tW\t]8dQND#\u0001\t8\u0002KMDw.\u001e7e\u001d>$8\t\\3be\u0006s\u0017\u0010\u001e5j]\u001eLem\u00144gg\u0016$Hk\\#be2L\bFA\u0011o\u0003-\u001a\bn\\;mI:{Go\u00117fCJ\fe.\u001f;iS:<\u0017JZ(gMN,G\u000fV8GSJ\u001cHo\u00144gg\u0016$\bF\u0001\u0012o\u0003%\u001a\bn\\;mIJ+G/Y5o\u0019\u0006$Xm\u001d;Fa>\u001c\u0007n\u00148DY\u0016\f'/\u00117m\u000b\u0006\u0014H.[3ti\"\u00121E\\\u00018g\"|W\u000f\u001c3Va\u0012\fG/Z(gMN,GOQ3uo\u0016,g.\u00129pG\"\u0014u.\u001e8eCJLWm](o\u00072,\u0017M]#be2LWm\u001d;)\u0005\u0011r\u0017\u0001O:i_VdG-\u00169eCR,wJ\u001a4tKR\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1sS\u0016\u001cxJ\\\"mK\u0006\u0014X)\u0019:mS\u0016\u001cHO\r\u0015\u0003K9\f1h\u001d5pk2$'+\u001a;bS:d\u0015\r^3ti\u0016\u0003xn\u00195P]\u000ecW-\u0019:BY2,\u0015M\u001d7jKN$\u0018I\u001c3Va\u0012\fG/Z%ug>3gm]3uQ\t1c.A\u001ctQ>,H\u000e\u001a#s_B,e\u000e\u001e:jKN\u0014U\r^<fK:,\u0005o\\2i\u0005>,h\u000eZ1ss^CWM\u001c*f[>4\u0018N\\4OK^,7\u000f\u001e\u0015\u0003O9\fQc\u001d5pk2$7\t\\3be\u0006cG.\u00128ue&,7\u000f\u000b\u0002)]\u0006y3\u000f[8vY\u0012tu\u000e\u001e*fg\u0016$X\t]8dQ\"K7\u000f^8ss\"+\u0017\rZ%g+:$WMZ5oK\u0012\u0004\u0016m]:fI\"\u0012\u0011F\\\u00010g\"|W\u000f\u001c3O_R\u0014Vm]3u\u000bB|7\r\u001b%jgR|'/\u001f+bS2Le-\u00168eK\u001aLg.\u001a3QCN\u001cX\r\u001a\u0015\u0003U9\f!e\u001d5pk2$g)\u001a;dQ2\u000bG/Z:u\u000bB|7\r[(g\u000b6\u0004H/_\"bG\",\u0007FA\u0016o\u0003\u0001\u001a\bn\\;mI\u001a+Go\u00195F]\u0012|eMZ:fi>3W)\u001c9us\u000e\u000b7\r[3)\u00051r\u0017aH:i_VdGm\u00117fCJ,\u0015M\u001d7jKN$xJ\\#naRL8)Y2iK\"\u0012QF\\\u0001\u001eg\"|W\u000f\u001c3DY\u0016\f'\u000fT1uKN$xJ\\#naRL8)Y2iK\"\u0012aF\\\u0001\u0016i\u0016\u001cHOR5oIB\u0013XM^5pkN,\u0005o\\2iQ\tyc.A\tuKN$h)\u001b8e\u001d\u0016DH/\u00129pG\"D#\u0001\r8\u0002#Q,7\u000f^$fi\u0016\u0003xn\u00195F]R\u0014\u0018\u0010\u000b\u00022]\u0006q2\u000f[8vY\u00124U\r^2i\u000bB|7\r\u001b$pe\u001eKg/\u001a8PM\u001a\u001cX\r\u001e\u0015\u0003e9\u0004")
public class LeaderEpochFileCacheTest {
    private final TopicPartition tp = new TopicPartition("TestTopic", 5);
    private final LeaderEpochCheckpoint checkpoint = new LeaderEpochCheckpoint(null){
        private Seq<EpochEntry> epochs;

        private Seq<EpochEntry> epochs() {
            return this.epochs;
        }

        private void epochs_$eq(Seq<EpochEntry> x$1) {
            this.epochs = x$1;
        }

        public void write(Collection<EpochEntry> epochs) {
            this.epochs_$eq((Seq<EpochEntry>)((TraversableOnce)CollectionConverters$.MODULE$.collectionAsScalaIterableConverter(epochs).asScala()).toSeq());
        }

        public List<EpochEntry> read() {
            return (List)CollectionConverters$.MODULE$.seqAsJavaListConverter(this.epochs()).asJava();
        }
        {
            this.epochs = Nil$.MODULE$;
        }
    };
    private final LeaderEpochFileCache cache = new LeaderEpochFileCache(this.tp(), this.checkpoint());

    public TopicPartition tp() {
        return this.tp;
    }

    private LeaderEpochCheckpoint checkpoint() {
        return this.checkpoint;
    }

    private LeaderEpochFileCache cache() {
        return this.cache;
    }

    @Test
    public void testPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch());
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch());
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch());
    }

    @Test
    public void shouldAddEpochAndMessageOffsetToCache() {
        this.cache().assign(2, 10L);
        int logEndOffset = 11;
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new EpochEntry(2, 10L), this.cache().epochEntries().get(0));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldReturnLogEndOffsetIfLatestEpochRequested() {
        this.cache().assign(2, 11L);
        this.cache().assign(2, 12L);
        int logEndOffset = 14;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
    }

    @Test
    public void shouldReturnUndefinedOffsetIfUndefinedEpochRequested() {
        Tuple2.mcIJ.sp expectedEpochEndOffset = new Tuple2.mcIJ.sp(-1, -1L);
        this.cache().assign(2, 11L);
        this.cache().assign(3, 12L);
        Tuple2 epochAndOffsetFor = this.toTuple(this.cache().endOffsetFor(-1, 0L));
        Assertions.assertEquals((Object)expectedEpochEndOffset, epochAndOffsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Cache not empty.");
    }

    @Test
    public void shouldNotOverwriteLogEndOffsetForALeaderEpochOnceItHasBeenAssigned() {
        int logEndOffset = 9;
        this.cache().assign(2, (long)logEndOffset);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)logEndOffset, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 9L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingStartOffsets() {
        this.cache().assign(2, 9L);
        this.cache().assign(3, 9L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 9L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotOverwriteOffsetForALeaderEpochOnceItHasBeenAssigned() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 10L);
        Assertions.assertEquals((long)6L, (long)((EpochEntry)this.cache().epochEntries().get((int)0)).startOffset);
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecorded() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(0, 0L)));
    }

    @Test
    public void shouldReturnUnsupportedIfNoEpochRecordedAndUndefinedEpochRequested() {
        Tuple2 offsetFor = this.toTuple(this.cache().endOffsetFor(-1, 73L));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), offsetFor, (String)"Expected undefined epoch and offset if undefined epoch requested. Empty cache.");
    }

    @Test
    public void shouldReturnFirstEpochIfRequestedEpochLessThanFirstEpoch() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        Tuple2 epochAndOffset = this.toTuple(this.cache().endOffsetFor(4, 0L));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(4, 11), epochAndOffset);
    }

    @Test
    public void shouldTruncateIfMatchingEpochButEarlierStartingOffset() {
        this.cache().assign(5, 11L);
        this.cache().assign(6, 12L);
        this.cache().assign(7, 13L);
        this.cache().assign(7, 12L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(5, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(5, 12), this.toTuple(this.cache().endOffsetFor(6, 0L)));
    }

    @Test
    public void shouldGetFirstOffsetOfSubsequentEpochWhenOffsetRequestedForPreviousEpoch() {
        this.cache().assign(1, 11L);
        this.cache().assign(1, 12L);
        this.cache().assign(2, 13L);
        this.cache().assign(2, 14L);
        this.cache().assign(3, 15L);
        this.cache().assign(3, 16L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 15), this.toTuple(this.cache().endOffsetFor(2, 17L)));
    }

    @Test
    public void shouldReturnNextAvailableEpochIfThereIsNoExactEpochForTheOneRequested() {
        this.cache().assign(0, 10L);
        this.cache().assign(2, 13L);
        this.cache().assign(4, 17L);
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 13), this.toTuple(this.cache().endOffsetFor(1, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(2, 0L)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 17), this.toTuple(this.cache().endOffsetFor(3, 0L)));
    }

    @Test
    public void shouldNotUpdateEpochAndStartOffsetIfItDidNotChange() {
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldReturnInvalidOffsetIfEpochIsRequestedWhichIsNotCurrentlyTracked() {
        this.cache().assign(2, 100L);
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(3, 100L)));
    }

    @Test
    public void shouldSupportEpochsThatDoNotStartFromZero() {
        this.cache().assign(2, 6L);
        int logEndOffset = 7;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((int)1, (int)this.cache().epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldPersistEpochsBetweenInstances() {
        String checkpointPath = TestUtils$.MODULE$.tempFile().getAbsolutePath();
        LeaderEpochCheckpointFile checkpoint = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint).assign(2, 6L);
        LeaderEpochCheckpointFile checkpoint2 = new LeaderEpochCheckpointFile(new File(checkpointPath), new LogDirFailureChannel(1));
        LeaderEpochFileCache cache2 = new LeaderEpochFileCache(this.tp(), (LeaderEpochCheckpoint)checkpoint2);
        Assertions.assertEquals((int)1, (int)cache2.epochEntries().size());
        Assertions.assertEquals((Object)new EpochEntry(2, 6L), cache2.epochEntries().get(0));
    }

    @Test
    public void shouldEnforceMonotonicallyIncreasingEpochs() {
        this.cache().assign(1, 5L);
        this.cache().assign(2, 6L);
        this.cache().assign(1, 7L);
        int logEndOffset = 8;
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 8), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new EpochEntry(1, 7L), this.cache().epochEntries().get(0));
    }

    private <K, V> Tuple2<K, V> toTuple(Map.Entry<K, V> entry) {
        return new Tuple2(entry.getKey(), entry.getValue());
    }

    @Test
    public void shouldEnforceOffsetsIncreaseMonotonically() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 5L);
        Assertions.assertEquals((Object)new EpochEntry(3, 5L), this.cache().epochEntries().get(0));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsLeadersChangeManyTimes() {
        long logEndOffset = 0L;
        this.cache().assign(0, 0L);
        this.cache().assign(1, 0L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 0), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        logEndOffset = 5L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
        this.cache().assign(2, 5L);
        logEndOffset = 10L;
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, 10), this.toTuple(this.cache().endOffsetFor(2, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 5), this.toTuple(this.cache().endOffsetFor(1, logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 0), this.toTuple(this.cache().endOffsetFor(0, logEndOffset)));
    }

    @Test
    public void shouldIncreaseAndTrackEpochsAsFollowerReceivesManyMessages() {
        this.cache().assign(0, 0L);
        this.cache().assign(0, 1L);
        this.cache().assign(0, 2L);
        int logEndOffset = 3;
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, logEndOffset), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        this.cache().assign(1, 3L);
        this.cache().assign(1, 4L);
        this.cache().assign(1, 5L);
        logEndOffset = 6;
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, logEndOffset), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
        this.cache().assign(2, 6L);
        this.cache().assign(2, 7L);
        this.cache().assign(2, 8L);
        logEndOffset = 9;
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().latestEpoch());
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(2, logEndOffset), this.toTuple(this.cache().endOffsetFor(2, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(0, 3), this.toTuple(this.cache().endOffsetFor(0, (long)logEndOffset)));
        Assertions.assertEquals((Object)new Tuple2.mcII.sp(1, 6), this.toTuple(this.cache().endOffsetFor(1, (long)logEndOffset)));
    }

    @Test
    public void shouldDropEntriesOnEpochBoundaryWhenRemovingLatestEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(8L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 6L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldPreserveResetOffsetOnClearEarliestIfOneExists() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(8L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 8L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateSavedOffsetWhenOffsetToClearToIsBetweenEpochs() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToEarly() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(1L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldNotClearAnythingIfOffsetToFirstOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(6L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(11L);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 11L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(9L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(3, 9L), new EpochEntry(4, 11L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldUpdateOffsetBetweenEpochBoundariesOnClearEarliest2() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 7L);
        this.cache().assign(2, 10L);
        this.cache().truncateFromStart(5L);
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(0, 5L), new EpochEntry(1, 7L), new EpochEntry(2, 10L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldRetainLatestEpochOnClearAllEarliestAndUpdateItsOffset() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(15L);
        Assertions.assertEquals(Collections.singletonList(new EpochEntry(4, 15L)), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldDropEntriesBetweenEpochBoundaryWhenRemovingNewest() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(9L);
        Assertions.assertEquals((Object)OptionalInt.of(3), (Object)this.cache().latestEpoch());
        Assertions.assertEquals(Arrays.asList((Object[])new EpochEntry[]{new EpochEntry(2, 6L), new EpochEntry(3, 8L)}), (Object)this.cache().epochEntries());
    }

    @Test
    public void shouldClearAllEntries() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().clearAndFlush();
        Assertions.assertEquals((int)0, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryHeadIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromStart(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldNotResetEpochHistoryTailIfUndefinedPassed() {
        this.cache().assign(2, 6L);
        this.cache().assign(3, 8L);
        this.cache().assign(4, 11L);
        this.cache().truncateFromEnd(-1L);
        Assertions.assertEquals((int)3, (int)this.cache().epochEntries().size());
    }

    @Test
    public void shouldFetchLatestEpochOfEmptyCache() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().latestEpoch());
    }

    @Test
    public void shouldFetchEndOffsetOfEmptyCache() {
        Assertions.assertEquals((Object)new Tuple2.mcIJ.sp(-1, -1L), this.toTuple(this.cache().endOffsetFor(7, 0L)));
    }

    @Test
    public void shouldClearEarliestOnEmptyCache() {
        this.cache().truncateFromStart(7L);
    }

    @Test
    public void shouldClearLatestOnEmptyCache() {
        this.cache().truncateFromEnd(7L);
    }

    @Test
    public void testFindPreviousEpoch() {
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(2, 10L);
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().previousEpoch(2));
        this.cache().assign(4, 15L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(4));
        this.cache().assign(10, 20L);
        Assertions.assertEquals((Object)OptionalInt.of(4), (Object)this.cache().previousEpoch(10));
        this.cache().truncateFromEnd(18L);
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().previousEpoch(this.cache().latestEpoch().getAsInt()));
    }

    @Test
    public void testFindNextEpoch() {
        this.cache().assign(0, 0L);
        this.cache().assign(1, 100L);
        this.cache().assign(2, 200L);
        Assertions.assertEquals((Object)OptionalInt.of(0), (Object)this.cache().nextEpoch(-1));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().nextEpoch(0));
        Assertions.assertEquals((Object)OptionalInt.of(2), (Object)this.cache().nextEpoch(1));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(2));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().nextEpoch(100));
    }

    @Test
    public void testGetEpochEntry() {
        this.cache().assign(2, 100L);
        this.cache().assign(3, 500L);
        this.cache().assign(5, 1000L);
        Assertions.assertEquals((Object)new EpochEntry(2, 100L), this.cache().epochEntry(2).get());
        Assertions.assertEquals((Object)new EpochEntry(3, 500L), this.cache().epochEntry(3).get());
        Assertions.assertEquals((Object)new EpochEntry(5, 1000L), this.cache().epochEntry(5).get());
    }

    @Test
    public void shouldFetchEpochForGivenOffset() {
        this.cache().assign(0, 10L);
        this.cache().assign(1, 20L);
        this.cache().assign(5, 30L);
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(25L));
        Assertions.assertEquals((Object)OptionalInt.of(1), (Object)this.cache().epochForOffset(20L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(30L));
        Assertions.assertEquals((Object)OptionalInt.of(5), (Object)this.cache().epochForOffset(50L));
        Assertions.assertEquals((Object)OptionalInt.empty(), (Object)this.cache().epochForOffset(5L));
    }
}

